/* 
 * BrowserController.m created by phr on 2000-10-21 09:35:35 +0000
 *
 * Project ImageViewer
 *
 * Created with ProjectCenter - http://www.gnustep.org
 *
 * $Id: BrowserController.m,v 1.9 2003/06/29 17:28:34 probert Exp $
 */

#include "BrowserController.h"
#include "ImageCache.h"
#include "ImageHolder.h"

@implementation BrowserController

- (id)initWithBrowser:(NSBrowser *)browser
{
  NSAssert(browser, _(@"No browser provided!"));

  if ((self = [super init])) 
  {
    _browser = [browser retain];
    [_browser setDelegate:self];

    _files = [[NSMutableArray alloc] init];
    _imageCache = [ImageCache sharedCache];
  }
  return self;
}

- (void)dealloc
{
  RELEASE(_browser);
  RELEASE(_files);
  RELEASE(_path);
  RELEASE(_imageView);

  RELEASE(currentPath);
  RELEASE(currentImgRep);
  RELEASE(currentAttribs);

  [super dealloc];
}

- (id)delegate
{
    return delegate;
}

- (void)setDelegate:(id)aDelegate
{
    delegate = aDelegate;
}

- (void)setPath:(NSString *)path
{
  NSFileManager  *fm = [NSFileManager defaultManager];
  NSString       *file;
  NSArray        *directoryContent = [fm directoryContentsAtPath:path];
  NSArray        *fileTypes = [NSImage imageFileTypes];
  NSEnumerator   *enumerator;
  NSUserDefaults *ud = [NSUserDefaults standardUserDefaults];

  enumerator = [directoryContent objectEnumerator];
     
  if( [[ud objectForKey:@"OpenRec"] isEqualToString:@"NO"] ) 
  {
    enumerator = [directoryContent objectEnumerator];
  }
  else 
  {
    enumerator = [fm enumeratorAtPath:path];
  }

  AUTORELEASE(_path);
  _path = [path copy];
  
  [_files removeAllObjects];

  while(file = [enumerator nextObject]) 
  {
    if ([fileTypes containsObject:[file pathExtension]]) 
    {
      [_files addObject:file];
    }
  }

  [_files sortUsingSelector:@selector(compare:)];
}

- (void)setImageView:(NSImageView *)imageView
{
  AUTORELEASE(_imageView);
  _imageView = RETAIN(imageView);
}

- (int)browser:(NSBrowser *)sender numberOfRowsInColumn:(int)column
{
  if ( _files != nil ) 
  {
    return [_files count];
  }

  return 0;
}

- (void)browser:(NSBrowser *)sender willDisplayCell:(id)cell atRow:(int)row 
         column:(int)column
{
  if ([sender isEqual:_browser]) 
  {
    [cell setLeaf:YES];
    [cell setStringValue:[_files objectAtIndex:row]];
  }
}

- (BOOL)browser:(NSBrowser *)sender isColumnValid:(int)column
{
}

- (void)showImage:(NSBrowser *)sender 
{
  NSString *pth = [_path stringByAppendingPathComponent:
    [[sender selectedCell] stringValue]];

  NSImage *image;
  ImageHolder *holder;
  NSRect vframe;
  NSRect frame = NSMakeRect(0,0,10,10);
  NSArray *array;

  if (![[NSFileManager defaultManager] isReadableFileAtPath:pth]) 
  {
    // Substitute
    pth = [[NSBundle mainBundle] pathForResource:@"genericImage" 
                                          ofType:@"tiff"];
  }

  AUTORELEASE(currentPath);
  currentPath = [pth copy];

  AUTORELEASE(currentAttribs);
  AUTORELEASE(currentImgRep);

  if (!(holder = [_imageCache imageHolderForKey:pth])) 
  {
    NSFileManager *fm = [NSFileManager defaultManager];

    image = [[NSImage alloc] initWithContentsOfFile:pth];

    //    array = [NSImageRep imageRepsWithContentsOfFile:currentPath];
    if( image == nil ) 
    {
      NSRunAlertPanel(_(@"Attention!"),
                      _(@"Couldn't load image at %@"),
                      _(@"Abort!"),nil,nil,pth);

      currentPath = nil;
      currentAttribs = nil;
      currentImgRep = nil;
      return;
    }
    else 
    {
      [image setBackgroundColor: [NSColor darkGrayColor]];
      array = [image representations];
      currentAttribs = [fm fileAttributesAtPath:currentPath traverseLink:NO];
	
      holder = [[ImageHolder alloc] initWithImage:image
                                             reps:array
                                       attributes:currentAttribs];

      [_imageCache cacheImageHolder:holder forKey:pth];
      RELEASE(holder);
      RELEASE(image);
    }

  }
  else 
  {
    array = [holder imageReps];
    image = [holder image];
    currentAttribs = [holder attributes];
  }

  reps  = [array count];
  currentImgRep = [array objectAtIndex:0];

  RETAIN(currentImgRep);
  RETAIN(currentAttribs);

  currentImgSize = [image size];
  frame.size = [image size];

  [_imageView setImage:image];
  [_imageView setFrame:frame];
 
  /*
  vframe = [[_imageView superview] frame];
  if (frame.size.width < vframe.size.width) {
    int wd = (vframe.size.width - frame.size.width)/2;

    frame.origin.x   += wd;
    frame.size.width += wd;
  }

  if (frame.size.height < vframe.size.height) {
    int wd = (vframe.size.height - frame.size.height)/2;

    frame.origin.y   += wd;
    frame.size.height += wd;
  }
  */
  
  if(delegate && 
    [delegate respondsToSelector:@selector(browserSelectionDidChange:)]) 
  {
    [delegate browserSelectionDidChange:self];
  }

}

- (NSString *)currentPath
{
  return currentPath;
}

- (NSImageRep *)currentImgRep
{
  return currentImgRep;
}

- (NSDictionary *)currentAttribs
{
  return currentAttribs;
}

- (int)currentImgRepCount
{
  return reps;
}

- (NSSize)currentImgSize
{
  return currentImgSize;
}

@end

