#!/bin/sh

if ! PREFIX=$(/bin/expr $0 : "\(/.*\)/etc/rc\.d/${0##*/}\$"); then
        echo "$0: Cannot determine the PREFIX" >&2
        exit 64
fi

BIN_DIR="/usr/local/sbin"

MILTER="smtp-vilter"
MILTER_FLAGS="" 
MILTER_PORT="-p local:/var/run/clamav/smtp-vilter.sock"

case "$1" in
start)
	${BIN_DIR}/${MILTER} ${MILTER_FLAGS} ${MILTER_PORT} 
	echo -n ' smtp-vilter'
	;;
stop)
	killall -TERM ${MILTER}
	echo -n ' smtp-vilter'
	;;
*)
	echo "Usage: `basename $0` {start|stop}" >&2
	;;
esac

exit 0
