#include "mailstream_cancel.h"

#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#ifdef LIBETPAN_REENTRANT
#include <pthread.h>
#endif

#include <stdlib.h>
#include <unistd.h>

struct mailstream_cancel_internal {
#ifdef LIBETPAN_REENTRANT
  pthread_mutex_t ms_lock;
#endif
};

struct mailstream_cancel * mailstream_cancel_new(void)
{
  int r;
  struct mailstream_cancel * cancel;
  struct mailstream_cancel_internal * ms_internal;
  
  cancel = malloc(sizeof(struct mailstream_cancel));
  if (cancel == NULL)
    goto err;
  
  cancel->ms_cancelled = 0;
  
  r = pipe(cancel->ms_fds);
  if (r < 0)
    goto free;
  
  ms_internal = malloc(sizeof(* ms_internal));
  cancel->ms_internal = ms_internal;
  if (cancel->ms_internal == NULL)
    goto close_pipe;
  
#ifdef LIBETPAN_REENTRANT
  r = pthread_mutex_init(&ms_internal->ms_lock, NULL);
  if (r != 0)
    goto free_internal;
#endif
  
  return cancel;
  
 free_internal:
  free(cancel->ms_internal);
 close_pipe:
  close(cancel->ms_fds[0]);
  close(cancel->ms_fds[1]);
 free:
  free(cancel);
 err:
  return NULL;
}

void mailstream_cancel_free(struct mailstream_cancel * cancel)
{
  struct mailstream_cancel_internal * ms_internal;
  
  ms_internal = cancel->ms_internal;
#ifdef LIBETPAN_REENTRANT
  pthread_mutex_destroy(&ms_internal->ms_lock);
#endif
  free(cancel->ms_internal);
  close(cancel->ms_fds[0]);
  close(cancel->ms_fds[1]);
  free(cancel);
}

void mailstream_cancel_notify(struct mailstream_cancel * cancel)
{
  char ch;
  struct mailstream_cancel_internal * ms_internal;
  
  ms_internal = cancel->ms_internal;
#ifdef LIBETPAN_REENTRANT
  pthread_mutex_lock(&ms_internal->ms_lock);
#endif
  cancel->ms_cancelled = 1;
#ifdef LIBETPAN_REENTRANT
  pthread_mutex_unlock(&ms_internal->ms_lock);
#endif
  
  ch = 0;
  write(cancel->ms_fds[1], &ch, 1);
}

void mailstream_cancel_ack(struct mailstream_cancel * cancel)
{
  char ch;
  
  read(cancel->ms_fds[0], &ch, 1);
}

int mailstream_cancel_cancelled(struct mailstream_cancel * cancel)
{
  int cancelled;
  struct mailstream_cancel_internal * ms_internal;
  
  ms_internal = cancel->ms_internal;
#ifdef LIBETPAN_REENTRANT
  pthread_mutex_lock(&ms_internal->ms_lock);
#endif
  cancelled = cancel->ms_cancelled;
#ifdef LIBETPAN_REENTRANT
  pthread_mutex_unlock(&ms_internal->ms_lock);
#endif
  
  return cancelled;
}

int mailstream_cancel_get_fd(struct mailstream_cancel * cancel)
{
  return cancel->ms_fds[0];
}
