/*
    ettercap -- dissector FTP -- TCP 21

    Copyright (C) 2001  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

    $Id: ec_dissector_ftp.c,v 1.8 2003/01/06 14:47:15 alor Exp $
*/

#include "include/ec_main.h"

#include "include/ec_dissector.h"
#include "include/ec_inet_structures.h"

#define __USE_GNU
#include <string.h>

// protos

FUNC_DISSECTOR(Dissector_ftp);

// --------------------


FUNC_DISSECTOR(Dissector_ftp)
{

   TCP_header *tcp;
   u_char *payload, *tmp;
   ONLY_CONNECTION;

   tcp = (TCP_header *) data;

   if (ntohs(tcp->source) == SERV_PORT) return 0;     // skip server messages...
	if (data_to_ettercap->datalen == 0) return 0;      // no data...

   payload = (char *)((int)tcp + tcp->doff * 4);
   tmp = payload + data_to_ettercap->datalen;
   
   while(payload[0] == ' ' && payload != tmp) payload++;
   
   if ( !strncasecmp(payload, "USER ", 5) ) {
      DEBUG_MSG("\tDissector_FTP USER");
      strlcpy(data_to_ettercap->user, payload + strlen("USER "), sizeof(data_to_ettercap->user));
      return 0;
   }

   if ( !strncasecmp(payload, "PASS ", 5) ) {
      DEBUG_MSG("\tDissector_FTP PASS");
      strlcpy(data_to_ettercap->pass, payload + strlen("PASS "), sizeof(data_to_ettercap->pass));
      return 0;
   }

   return 0;
}


/* EOF */

// vim:ts=3:expandtab

