============================================================================
                                ettercap 0.6.4
============================================================================


       @@@@@@@ @@@@@@@ @@@@@@@ @@@@@@@ @@@@@@@ @@@@@@@ @@@@@@@ @@@@@@@
       @@        @@@     @@@   @@      @@   @@ @@      @@   @@ @@   @@
       @@@@@@    @@@     @@@   @@@@@@  @@@@@@  @@      @@@@@@@ @@@@@@
       @@        @@@     @@@   @@      @@  @@  @@      @@   @@ @@
       @@@@@@@   @@@     @@@   @@@@@@@ @@  @@@ @@@@@@@ @@   @@ @@



            @@@@@@@ @@      @@   @@ @@@@@@@ @@@@ @@@@@@@ @@@@@@@
            @@   @@ @@      @@   @@ @@       @@  @@   @@ @@
            @@@@@@@ @@      @@   @@ @@  @@@  @@  @@   @@ @@@@@@@
            @@      @@      @@   @@ @@   @@  @@  @@   @@      @@
            @@      @@@@@@@ @@@@@@@ @@@@@@@ @@@@ @@   @@ @@@@@@@



         Wymagane biblioteki:             ettercap ;)

         Instalacja:                      configure --enable-plugins
                                          make plug-ins
                                          make plug-ins_install


============================================================================
                                 SPIS TRESCI
============================================================================


   1. INSTALACJA........................................rozdzial  1

   2. JAK Z NICH KORZYSTAC..............................rozdzial  2

      2.1   PLUGINY ZEWNETRZNE (EXTERNAL PLUGINS)
         2.1.1   Interfejs ncurses
         2.1.2   Tryb polecen (command line)
      2.2   PODCZEPIANIE PLUGINOW (HOOKING PLUGINS)


   3. JAK STWORZYC PLUGIN...............................rozdzial  3

   DODATEK A:  Zilustrowanie Illithid

============================================================================
1>                              INSTALACJA
============================================================================


 Aby zainstalowac plugin'y musisz uruchomic:

   configure --enable-plugins  (enabled by default)
   make plug-ins
   make plug-ins_install

 spowoduje to przygotowanie plugin'ow w folderze plugins oraz zainstaluje
 je w tym samym folderze, ktory zostal okreslony przy configure.

 Jezeli tworzysz nowy plugin, po prostu stworz nowy folder, w folderze
 plugins, nazywajac go tak samo jak plugin i umiesc w nim kod zrodlowy
 oraz maly Makefile. Plugin'y musza miec nazwe odpowiadajaca wzorcowi:
 ec_`nazwa`.so

 Dzieki temu proces instalacyjny bedzie odbywal sie automatycznie.

UWAGA:

 Poszukiwanie plugin'ow rozpoczyna sie od ./ a nastepnie w folderze
 instalacyjnym.


============================================================================
2>                          JAK Z NICH KORZYSTAC
============================================================================

2.1   PLUGINY ZEWNETRZNE (EXTERNAL PLUGINS)

 Zewnetrzne pluginy to te, ktore maja plug_type == PT_EXT i sa takie
 same jak stare plugin'y (wczesniejsze niz w ettercap 0.6.2)

   2.1.1   INTERFEJS NCURSES (NCURSES INTERFACE)

      Uzycie klawisza 'p' w podstawowym interfejscie spowoduje wyswietlenie
      listy wszystkich dostepnych pluginow. Wybierz jeden z nich i baw sie
      dobrze... ;)


   2.1.2   TRYB POLECEN (COMMAND LINE)

      Uzyj:

         ettercap -Np list

      aby otrzymac liste wszystkich dostepnych pluginow. Nastepnie uzyj:

         ettercap -Np plugin_name

      aby skorzystac z wybranego plugina.

      Przyklad:

         ettercap -Np ooze ghibli

      uruchomi "ooze" na hosta "ghibli" (plugin ooze pinguje docelowego
      hosta, w tym przykladzie "ghibli")

      to wszystko !!!


2.2   PODCZEPIANIE PLUGINOW (HOOKING PLUGINS)

 Podczepiane pluginy, mogace wchodzic z programem w interakcje, zostaly
 wprowadzone w ettercap'ie 0.6.2. Glowna idea jest dostarczenie pewnej ilosci
 punktow podczepienia w mechanizmie sniffowania, tak aby programista mogl
 uruchomic swoja wlasna funkcje w ktoryms z tych punktow.
 W ten sposob mozna stworzyc plugin, ktory potrzebuje pewnych zesniffowanych
 danych niezwracajac uwagi na to czy jest w sieci lokalnej korzystajacej ze
 switcha czy tez nie, tak ze cala oddolna praca jest wykonywana przez
 ettercap'a calkowicie przezroczycie dla plugina, nawet gdy konieczne jest
 zatrucie ofiar. Tylko zesniffowane dane zostana dopuszczone przez ettercap'a
 do plugina.
 Istnieje wiele punktow podczepienia, tak wiec moga to byc pluginy roznego
 typu, np. nowy dissector lub logger, a nawet IDS jesli chcesz... ;)
 Ten typ pluginow jest ladowany przez interfejs lub przez plik konfiguracyjny
 jezeli uruchamiasz ettercap'a w trybie polecen. Kolejnosc wykonywania
 pluginow jest okreslona w stylu init.d. Podczepiane pluginy maja 4 literowy
 prefiks "Hxx_", ktory informuje ettercap'a o priorytecie (xx moze miec
 wartosc od 00 do 99). Zostalo to tak zrobione poniewaz pluginy na tym samym
 punkcie podczepienia wykonywane sa sekwencyjnie, a poniewaz plugin moze
 modyfikowac sniffowane dane, nastepny plugin odczuwalby skutki
 wczesniejszych modyfikacji.


============================================================================
3>                          JAK STWORZYC PLUGIN
============================================================================

 Wierze, ze przyklad moze oddac wiecej niz tysiac slow. Dlatego tez,
 napisalem dwa wzorce pluginow, aby pokazac jak stworzyc prosty plugin.
 Jeden, nazwany "dummy", aby pokazac jak stworzyc plugin zewnetrzny, a
 drugi nazwany "H99_dummy", aby pokazac jak podczepiac pluginy.

 Jest kilka wytycznych, ktorych musisz przestrzegac.

 1) ZAWIERANIE (THE INCLUDES)

      #include "../../src/include/ec_main.h"       // for global variables
      #include "../../src/include/ec_plugins.h"    // for input/output

      Powyzsze sa wymagane, ale mozesz zawrzec tyle "include" ile chcesz.
      Aby otrzymac liste API, ktorych mozesz uzyc, zajrzyj do ./src/include
      Jedynymi API, ktorych NIE MOZESZ uzyc z plugina, sa te nazywajace sie
      ec_interface_*

 2) PLUGIN OPERATION

      struct plugin_ops ops = {
         ettercap_version: WERSJA,
         plug_info:        "krotki opis",
         plug_version:     15,
         plug_type:        PT_HOOK,
         hook_point:       PCK_DECODED,
         hook_function:    &dummy_function,
      };

      dla kazdego plugina musisz wypelnic powyzsza strukture, wpisujac
      informacje do odpowiednich pol. Struktora ta MUSI zostac dopuszczona
      przez Plugin_Register(...) w punckie inicjalizacji (patrz ponizej).

      ettercap_version: MUSI byc WERSJA globalna (uzywana dla wewnetrzengo
                        sprawdzenia)

      plug_info:        jest to ciag znakow (max 50) zawierajacy krotki opis

      plug_version:     jest to oznaczenie wersji (zwroc uwage, ze liczba 15
                        zostanie wyswietlona jako 1.5)

      plug_type:        moze miec postac PT_EXT (dla zewnetrznych pluginow)
                        lub PT_HOOK (dla pluginow podczepianych)

      hook_point:       jest to punkt podczepienia (zobacz w dalszej czesci
                        liste punktow podczepienia)

      hook_function:    jest wskaznikiem dla funkcji, ktora ma byc wykonana
                        w punkcie podczepienia. Musi miec postac
                        "int (*func)(void *)"


 3) ROZPOCZECIE I ZAKONCZENIE (INITIALIZATION AND FINALIZATION)

      Kazdy plugin MUSI zawierac dwie funkcje. Jedna rozpoczynajaca oraz
      druga wykonywana, gdy plugin konczy prace.

      int Plugin_Init(void *params)
      {
         /*
          *  w tej funkcji MUSIMY wywolac procedure rejestrujaca, ktora
          *  wywola plugin zgodny ze struktura plugin_ops.
          *  zwrocona wartosc MUSI byc taka sama jak Plugin_Register()
          *  nieprzezroczyste parametry wskaznika MUSZA byc przepuszczone
          *  do Plugin_Register()
          */
         return Plugin_Register(params, &ops);
      }

      int Plugin_Fini(void *params)
      {
         /*
          * Tutaj mozesz zwolnic wszystkie alokowane zasoby
          */
         return 0;
      }

      BARDZO WAZNE: Plugin NIE MOZE konczyc sie z uzyciem exit() !!!

 4) PUNKT PODCZEPIENIA (HOOKING POINT)

    "void * pointer" jest parametrem przepuszczanym do funkcji podczepiajacej;
    gdy plugin jest wykonywany, otrzymuje parametr "void * pointer", ktory by
    mogl zostac uzyty, musi zostac osadzony.


      HOOK_NONE         zarezerwowane dla plugina zewnetrznego

      PCK_RECEIVED_RAW  plugin jest wykonywany zaraz po otrzymaniu pakietu,
                        przed analiza illithid, poniewaz modyfikowanie danych
                        w tym miejscu kolidowaloby z dzialaniem illithid.
                        void * pointer wskazuje na strukture RAW_PACKET,
                        ktora zawiera dwa pola:
                        1) bufor (magazyn nieprzetworzonych pakietow (raw
                        packets) otrzymanych z Warstwy Polaczenia (Link Layer)
                        2) dlugosc - len (liczba calkowita okreslajaca dlugosc
                        pakietu)
                        PODPOWIEDZ: jezeli chcesz aby pakiet zostal zrzucony
                        przez ettercap'a, po prostu ustaw dlugosc (len) na 0.

      PCK_RECEIVED_STRUCT_FILLED plugin jest wykonywany po analizie illithid,
                        ale przed przepuszczeniem pakietu do ettercap'a.
                        void * pointer wskazuje na strukture SNIFFED_DATA

      PCK_PRE_FORWARD   plugin jest wykonywany przed przeslaniem pakietu
                        (oczywiscie tylko wtedy, gdy ettercap wykonuje
                        zatruwanie ARP (ARP Poisoning)).
                        Modyfikacja danych w tym miejscu zmieni tylko
                        przesylany pakiet, ktory zostal juz zdekodowany przez
                        illithid z zapamietaniem jego sesji oraz zesniffowanymi
                        danymi, ktore zostaly przeslane do ettercap'a.
                        void * pointer kieruje nieprzetworzony pakiet do
                        bufora z gotowoscia do wyslania do Warstwy Polaczenia
                        Link Layer), tak wiec musisz zdekodowac go z naglowka
                        Ethernet.

      PCK_DISSECTOR     plugin jest wykonywany po dzialaniu innych wbudowanych
                        analizatorow.
                        void * pointer wskazuje na strukture DISSECTION

      PCK_DECODED       plugin jest wykonywany po przeprowadzeniu aktywnej
                        analizy (aktywny analizator to taki, ktory modyfikuje
                        dane przed przeslaniem ich do ettercap'a, na przyklad
                        protokoly SSH, HTTPS, ICQ sa szyfrowane, zatem musza
                        zostac odszyfrowane zanim zostana pokazane
                        uzytkownikowi)
                        void * pointer wskazuje na strukture SNIFFED_DATA


      Zajrzyj do DODATKU A, aby zyskac pelny poglad na system podczepiania.


 5) ETTERCAP API

      + Plugin_Output()    to samo co printf(), wymagane aby moc przekazac
                           dane wyjsciowe do interfejsu ncurses.

      + Plugin_Input()     do zdobywania danych od uzytkownika.

      UWAGA: plugin podczepiany NIE MOZE uzywac jest funkcji !!!


      + Plugin_Hook_Output()  to samo co powyzej, tyle ze dla plugina
                              podczepianego


      + Wszystkie pozostale funkcje w ec_inet_forge.c, ec_inet.c oraz
        ec_decodedata.c dadza Ci latwy dostep do interfejsu Warstwy
        Polaczenia (Link Layer).


Nie krepuj sie napisac emaila do tworcy, aby uzyskac wiecej informacji.



============================================================================
DODATEK A>                 ZILUSTROWANIE ILLITHID
============================================================================

 Sposob zachowania illithid, przedstawiony w Jezyku-Bardzo-Wysokiego-Poziomu:


 loop
 {
   otrzymuje pojedynczy pakiet z Warstwy Polaczenia (Link Layer)

   PUNKT PODCZEPIENIA: PCK_RECEIVED_RAW  (void * pointer -> received buffer)

	if (len <= 0) continue;

   Analizuje bufor poprzez Warstwe (Layer) 2, 3 i 4

   *** Tylko pakiety UDP i TCP sa akceptowane ponizej ***

   Wypelnia strukture CONNECTION

   Uruchamia wbudowany analizator (ktory wypelnia pola: user, pass i info)

   PUNKT PODCZEPIENIA: PCK_DISSECTOR  (void * pointer -> DISSECTION structure)

   Uaktualnia prezentacje polaczenia wyswietlana przez ettercap'a

   if (connection_mode == 0)
   {
      Wypelnia strukture SNIFFED_DATA

      PUNKT PODCZEPIENIA: PCK_RECEIVED_STRUCT_FILLED (void * pointer ->
                          SNIFFED_DATA)

      Uruchamia wbudowany analizator danych (np. SSH, HTTPS, ICQ, itd.)

      PUNKT PODCZEPIENIA: PCK_DECODED  (void * pointer -> SNIFFED_DATA)

      Umieszcza SNIFFED_DATA w buforze ettercap'a
   }

   if (man_in_the_middle)
   {

      if (filter_activated)
      {
         Przeprowadza mechanizm filtrujacy na tym pakiecie

         PUNKT PODCZEPIENIA: ????  (void * pointer -> ????)
      }

      Tworzy wewnetrzna sesje (jedna dla kazdego polaczenia) z wrazliwymi
      danymi, aby utrzymac synchronizacje polaczenia.

      PUNKT PODCZEPIENIA: PCK_PRE_FORWARD (void * pointer -> to be sent buffer)

      Przesyla pakiet do Warstwy Polaczenia (Link Layer)
   }

   if (pending_killing_request)
   {
      Zabija to polaczenie
   }

   if (pending_inject_request)
   {
      Wstrzykuje znaki do Warstwy Polaczenia (Link Layer)

      Uaktualnia wewnetrzna sesje (numer sekwencji, itd.)
   }

 }



 Tlumaczenie: Joker z "Szarlotkowej Frakcji Narzekaczy" ;-)))

0xABADC0DE==============================================================EC-2K