#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <curl/curl.h>
#include <libmpd/debug_printf.h>
#include <gmpc/plugin.h>
#include "easy_download.h"
#include <gmpc/cover-art.h>


#define AMAZONKEY "14TC04B24356BPHXW1R2"

void init();
char * host = "http://xml.amazon.com/onca/xml3?v=1.0&f=xml&t=webservices-20&mode=music&type=lite&dev-t=";
void amazon_cover_art_pref_construct(GtkWidget *container);
void amazon_cover_art_pref_destroy(GtkWidget *container);
int fetch_cover_art(mpd_Song *song, GSourceFunc function);
int fetch_cover_art_path(mpd_Song *song, gchar **path);
int fetch_cover_priority();
static GtkWidget *wp_pref_vbox = NULL;
gmpcPrefPlugin cam_pref = {
	amazon_cover_art_pref_construct,
	amazon_cover_art_pref_destroy

};
typedef struct amazon_song_info {
	char *image_big;
	char *image_medium;
	char *image_small;

}amazon_song_info;

gmpcCoverArtPlugin cam_cover = {
	fetch_cover_art_path,
	fetch_cover_art,
	fetch_cover_priority
};

int plugin_api_version = PLUGIN_API_VERSION;
gmpcPlugin plugin = {
	"Amazon Cover Fetcher",
	{0,0,1},
	GMPC_PLUGIN_COVER_ART,
	0,
	NULL, /* path  */
	init, /* init  */
	NULL, /* browser */
	NULL, /* status changed */
	NULL, /* connection changed */
	&cam_pref, /* preferences */
	&cam_cover
};
void init()
{
	char *file = g_strdup_printf("%s/.covers/",g_get_home_dir());
	if(!g_file_test(file,G_FILE_TEST_EXISTS))
	{
		g_mkdir(file, 0755);
	}
	g_free(file);
}

int fetch_cover_priority(){
	return cfg_get_single_value_as_int_with_default(config, "cover-amazon", "priority", 80);

}



int fetch_cover_art_path(mpd_Song *song, gchar **path) 
{
	int i=0;
	char *url =NULL;
	char *artist = NULL;
	char *album = NULL;
	if(song == NULL || !cfg_get_single_value_as_int_with_default(config, "cover-amazon", "enable", TRUE))
		return COVER_ART_NO_IMAGE;
	if(song->artist == NULL || song->album == NULL)
		return COVER_ART_NO_IMAGE;
	artist = g_strdup(song->artist);
	album = g_strdup(song->album);
	for(i=0;i< strlen(artist);i++)if(artist[i] == G_DIR_SEPARATOR) artist[i] = ' ';
	for(i=0;i< strlen(album);i++)if(album[i] == G_DIR_SEPARATOR) album[i] = ' ';
	/* caching in gmpc makes this useless */
	/*
	url = g_strdup_printf("%s/.covers/%s-%s.jpg.na",
			g_get_home_dir(),
			artist,
			album);
	if(g_file_test(url, G_FILE_TEST_EXISTS))
	{
		g_free(artist);
		g_free(album);
		g_free(url);
		return COVER_ART_NO_IMAGE;
	}
	g_free(url);
	*/
	url = g_strdup_printf("%s/.covers/%s-%s.jpg",
			g_get_home_dir(),
			artist,
			album);
	if(g_file_test(url, G_FILE_TEST_EXISTS))
	{
		*path = url;
		g_free(artist);
		g_free(album); 		
		return COVER_ART_OK_LOCAL;
	}
	g_free(artist);
	g_free(album); 	
	g_free(url);
	return COVER_ART_NOT_FETCHED;
}


amazon_song_info * amazon_song_info_new()
{
	amazon_song_info *asi = g_malloc(sizeof(amazon_song_info));
	asi->image_big = NULL;
	asi->image_medium = NULL;
	asi->image_small = NULL;
	return asi;
}
void amazon_song_info_free(amazon_song_info *asi)
{
	if(asi->image_big != NULL) g_free(asi->image_big);
	if(asi->image_medium != NULL) g_free(asi->image_medium);
	if(asi->image_small != NULL) g_free(asi->image_small);
	g_free(asi);
	return;
}

amazon_song_info *__cover_art_xml_get_image(char *data,int size)
{
	xmlDocPtr doc = xmlParseMemory(data,size);
	if(doc)
	{
		xmlNodePtr root = xmlDocGetRootElement(doc);
		xmlNodePtr cur = root->xmlChildrenNode;
		for(;cur;cur = cur->next){
			if(xmlStrEqual(cur->name, (xmlChar *)"Details")){
				amazon_song_info *asi = amazon_song_info_new();
				xmlNodePtr child = cur->xmlChildrenNode;
				for(;child;child=child->next){
					if(xmlStrEqual(child->name, (xmlChar *)"ImageUrlLarge")){
						xmlChar *temp = xmlNodeGetContent(child);
						/* copy it, so we can fee it, and don't need xmlFree */
						asi->image_big = g_strdup((char *)temp);
						xmlFree(temp);
					}
					else if(xmlStrEqual(child->name, (xmlChar *)"ImageUrlMedium")){
						xmlChar *temp = xmlNodeGetContent(child);
						/* copy it, so we can fee it, and don't need xmlFree */
						asi->image_medium = g_strdup((char *)temp);
						xmlFree(temp);
					}
					else if(xmlStrEqual(child->name, (xmlChar *)"ImageUrlSmall")){
						xmlChar *temp = xmlNodeGetContent(child);
						/* copy it, so we can fee it, and don't need xmlFree */
						asi->image_small = g_strdup((char *)temp);
						xmlFree(temp);
					}
				}

				/* one result is enough */
				xmlFreeDoc(doc);
				xmlCleanupParser();
				return asi;
			}
		}
		xmlFreeDoc(doc);
		xmlCleanupParser();
	}
	return NULL;
}
char * __cover_art_process_string(char *name)
{
	int i = 0;
	int j = 0;
	int depth = 0;
	/* only gonna be smaller */
	char *result = g_malloc0((strlen(name)+1)*sizeof(char));
	for(i=0; i < strlen(name);i++)
	{
		if(name[i] == '(' || name[i] == '[') depth++;
		else if (name[i] == ')' || name[i] == ']') depth--;
		if(!depth)
		{
			result[j] = name[i];
			j++;
		}
	}
	return result;
}

int __cover_art_get_image(char *nartist, char *nalbum)
{

	easy_download_struct data= {NULL, 0,-1};
	int found = 0;
	char *artist = NULL; 
	char *album =NULL;
	char furl[1024];
	char *result = __cover_art_process_string(nalbum);
	char *amazon_key = cfg_get_single_value_as_string_with_default(config, "cover-amazon", "amazon-key",AMAZONKEY);

	if(strlen(amazon_key) ==0){
		g_free(result);
		debug_printf(DEBUG_ERROR,"You need a valid amazon-key");
		return FALSE;
	}
	artist =  curl_escape(nartist, 0);
	album =  curl_escape(result, 0);
	g_free(result);
	
	snprintf(furl,1024,"%s%s&ArtistSearch=%s&keywords=%s", host,amazon_key, artist, album);
	curl_free(artist);
	curl_free(album);


	if(easy_download(furl, &data))
	{
		amazon_song_info *asi = __cover_art_xml_get_image(data.data, data.size);
		easy_download_clean(&data);
		if(asi) 
		{
			easy_download(asi->image_big, &data);
			if(data.size <= 900){
				easy_download_clean(&data);
				easy_download(asi->image_medium, &data);
				if(data.size <= 900){
					easy_download_clean(&data);
					easy_download(asi->image_small, &data);
					if(data.size <= 900)
					{
						easy_download_clean(&data);
					}
				}
			}
			if(data.size){
				int i =0;
				FILE *fp = NULL;
				char *imgpath = NULL;
				artist = g_strdup(nartist);	
				album = g_strdup(nalbum);
				for(i=0;i< strlen(artist);i++)if(artist[i] == G_DIR_SEPARATOR) artist[i] = ' ';
				for(i=0;i< strlen(album);i++)if(album[i] == G_DIR_SEPARATOR) album[i] = ' ';
				imgpath = g_strdup_printf("%s/.covers/%s-%s.jpg",
						g_get_home_dir(),artist,album);
				fp = fopen(imgpath, "w");
				if(fp)
				{
					fwrite(data.data, sizeof(char), data.size,fp);
					fclose(fp);
				}
				g_free(imgpath);
				g_free(artist);
				g_free(album);
				easy_download_clean(&data);
				found = 1;
			}
			amazon_song_info_free(asi);
		}

	}
	/* caching in gmpc makes this useless????*/
	/*
	if(!found)
	{
		int i = 0;
		FILE *fp = NULL;
		gchar *imgpath = NULL;

		artist = g_strdup(nartist);	
		album = g_strdup(nalbum);
		for(i=0;i< strlen(artist);i++)if(artist[i] == G_DIR_SEPARATOR) artist[i] = ' ';
		for(i=0;i< strlen(album);i++)if(album[i] == G_DIR_SEPARATOR) album[i] = ' ';   		
		imgpath = g_strdup_printf("%s/.covers/%s-%s.jpg.na",
				g_get_home_dir(),artist,album);
		fp = fopen(imgpath, "w");
		if(fp)
		{
			fclose(fp);
		}
		g_free(artist);
		g_free(album);
		g_free(imgpath);
	}
	*/
	return found;
}
int fetch_cover_art(mpd_Song *song, GSourceFunc function)
{
	return __cover_art_get_image(song->artist, song->album);
}



void amazon_cover_art_enable_toggle(GtkWidget *wid)
{
	int kk = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wid));
	cfg_set_single_value_as_int(config, "cover-amazon", "enable", kk);
}
void amazon_cover_art_pref_destroy(GtkWidget *container)
{
	gtk_container_remove(GTK_CONTAINER(container), wp_pref_vbox);
}
void amazon_cover_art_entry_changed(GtkEntry *entry){
	const gchar *text = gtk_entry_get_text(entry);
	cfg_set_single_value_as_string(config, "cover-amazon", "amazon-key", (char *)text);

}

void amazon_cover_art_pref_construct(GtkWidget *container)
{
	GtkWidget *enable_cg = gtk_check_button_new_with_mnemonic("_Enable amazon as cover art source");
	GtkWidget *label = NULL;
	GtkWidget *entry = NULL;
	wp_pref_vbox = gtk_vbox_new(FALSE,6);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(enable_cg), 	
			cfg_get_single_value_as_int_with_default(config, "cover-amazon", "enable", TRUE));

	g_signal_connect(G_OBJECT(enable_cg), "toggled", G_CALLBACK(amazon_cover_art_enable_toggle), NULL);
	gtk_box_pack_start(GTK_BOX(wp_pref_vbox), enable_cg, FALSE, FALSE, 0);
	label = gtk_label_new("Please enter a valid amazon-key:");
	gtk_box_pack_start(GTK_BOX(wp_pref_vbox), label, FALSE, FALSE, 0);
	entry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(entry), 
			cfg_get_single_value_as_string_with_default(config, "cover-amazon", "amazon-key", AMAZONKEY));
	g_signal_connect(G_OBJECT(entry), "changed", G_CALLBACK(amazon_cover_art_entry_changed), NULL);
	gtk_box_pack_start(GTK_BOX(wp_pref_vbox), entry, FALSE, FALSE, 0);
	gtk_container_add(GTK_CONTAINER(container), wp_pref_vbox);
	gtk_widget_show_all(container);
}
