/***************************************************************************
                          ktransfer.h  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.25 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTRANSFER_H
#define KTRANSFER_H

#include <qdatetime.h>
#include <qstring.h>
#include <kprocess.h>
#include <kurl.h>
#include <qfile.h>
#include "kobject.h"

class KTManager;
class KTransferImpl;

/**
 * @short Bridge class for @ref KTransferImpl objects.
 *
 * @author Sergio Moretti
 *
 * @version $Id: ktransfer.h,v 1.25 2001/04/08 09:43:49 sergio Exp $
 */

class KTransfer : public KObject
{
   friend class KObject;
   friend class KTManager;

public:
   typedef QValueList<KTransfer> List;

   KTransfer() {}

   static KTransfer null() { return KTransfer(); }
   static QString stateStr(TrnState s);
   static QString resumeStr(RsmState s);
   static QString resumeString(RsmState s);
   static const char * docId();
   static const char * docType();

   int len() const;
   void setLen(int l) const;
   int partial() const;
   void setPartial(int p) const;
   int percent() const;
   int retry() const;
   int bandwidth() const;
   int mediumBandwidth() const;
   QTime startTime() const;
   TrnState state() const;
   void setState(TrnState s) const;
   RsmState rsmState() const;
   void setRsmState(RsmState s) const;
   QString stateStr() const;
   QString progressStr() const;
   QString connectionStr() const;
   QString resumeStr() const;
   QString fatalErrorLog() const;
   const KURL & local() const;
   void setLocal(const KURL &lcl) const;
   const KURL & remote() const;
   void setRemote(const KURL &rmt) const;
   const KURL & tmp() const;
   void setTmp(const KURL &tmp) const;
   int resumed() const;
   void setResumed(int r) const;

   // OPERATIONS on transfer

   bool startCheckResume() const;
   bool isProtocolSupported(const QString &proto) const;
   bool isComplete() const;
   bool isFinished() const;
   bool isReady() const;
   bool isRunnable(bool automatic) const;
   bool isResumable() const;
   QTime estTime() const;
   KURL getTempFile(const KURL &rmt, const KURL &lcl) const;
   void clear() const;
   bool stop(bool wait = false) const;
   void resetState() const;

   // CONFIG

   bool getCheckResume() const;
   void setCheckResume(bool c) const;
   int getMaxResume() const;
   void setMaxResume(int r) const;
   bool getAutoResume() const;
   void setAutoResume(bool m) const;
   int getWaitResume() const;
   void setWaitResume(int w) const;
   int getMaxRetry() const;
   void setMaxRetry(int m) const;
   int getWaitRetry() const;
   void setWaitRetry(int w) const;
   bool getLogProcess() const;
   void setLogProcess(bool l) const;

protected:
   KTransfer(KTransferImpl * impl);
   KTransferImpl * impl() const;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
