/***************************************************************************
                          ksystrayview.h  -  description
                             -------------------
    begin                : Tue Oct 10 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.7 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSYSTRAYVIEW_H
#define KSYSTRAYVIEW_H

#include <qwidget.h>
#include <ksystemtray.h>
#include <kaction.h>

#ifdef DMALLOC
#include <dmalloc.h>
#endif

class KMagoDoc;

/**
 * @short System Tray Icon class
 *
 * can't use the XML generated menu because the inflessibility of menu
 * management of KSystemTray
 *
 * @author Sergio Moretti
 *
 * @version $Id: ksystrayview.h,v 1.7 2001/04/04 18:06:04 sergio Exp $
 */

class KSysTrayView : public KSystemTray
{
   friend class KMagoDoc;

   Q_OBJECT

public:
   KSysTrayView(KMagoDoc *doc, QWidget *parent=0, const char *name=0);
   ~KSysTrayView();
   KMagoDoc * doc() const;
   void updateMenuTitle();
   void updateIcon();

protected:
   virtual void dragEnterEvent(QDragEnterEvent *event);
   //virtual void dragMoveEvent(QDragMoveEvent *event);
   //virtual void dragLeaveEvent(QDragLeaveEvent *event);
   virtual void dropEvent(QDropEvent *event);
   //virtual void mouseReleaseEvent(QMouseEvent *event);
   //virtual void mouseMoveEvent(QMouseEvent *event);
   virtual void mousePressEvent(QMouseEvent *event);

private:
   KMagoDoc *_doc;
   int _minimizeId, _titleId;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
