/***************************************************************************
                          kmmanagerimpl.h  -  description
                             -------------------
    begin                : Wed Oct 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.10 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMMANAGERIMPL_H
#define KMMANAGERIMPL_H

#include "krootcontainerimpl.h"
#include "knotifychange.h"
//#include "kmmanager.h"

class KTManagerImpl;
class KMManager;


/**
 * @short Implementation of a manager for @ref KTManagerImpl objects.
 *
 * @author Sergio Moretti
 *
 * @version $Id: kmmanagerimpl.h,v 1.10 2001/03/22 09:26:52 sergio Exp $
 */

class KMManagerImpl : public KRootContainerImpl 
{
   Q_OBJECT
   
   friend class KMManager;
   friend class KObject;

   static const char DOCID[];
   static const char DOCTYPE[];

public: 
   KMManagerImpl();

   //void init(const QString &fileName, bool createMode, KNotifyChange *cb);

   /** document name */
   virtual const char * docId() const { return DOCID; }

   /** dom document type */
   virtual const char * docType() const { return DOCTYPE; }

   /** new item */
   KTManagerImpl * itemNew(const QString &title);

   /** bandwidth */
   int bandwidth() const { return _bandwidth; }

   /** medium bandwidth */
   int mediumBandwidth() const { return _mediumBandwidth; }

   void startPendingTransfer();

   // CONFIG

   int getMaxConnection() const;

   void setMaxConnection(int c);

   int getMaxBandwidth() const;

   void setMaxBandwidth(int b);

protected:
   //KMManagerImpl(int type);

   //~KMManagerImpl();

   virtual KObjectImpl * clone() const;

   const KMManagerImpl * global() const;

   virtual void loadData();

   virtual void runPeriodically();

   /** download locking */
   bool downloadLock() const { return _downloadLock; }
   void setDownloadLock(bool v);

   bool isIdle() const { return _idle; }
   void setIdle(bool i);


private:
   int _bandwidth;
   int _mediumBandwidth;
   /** automatic download locking */
   bool _downloadLock;
   bool _idle;

   // configuration data

   /** max BPS bandwidth */
   int _cfg_maxBandwidth;
   /** max open connection */
   int _cfg_maxConnection;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
