/***************************************************************************
                          kdlgtransfer1.cpp  -  description
                             -------------------
    begin                : Wed Sep 6 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.13 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qdir.h>
#include <qtooltip.h>
#include <qlayout.h>
#include <qhbox.h>
#include <qfileinfo.h>
#include <kfiledialog.h>
#include "kdlgtransfer1.h"

KDlgTransfer1::KDlgTransfer1(KTransfer tr, QWidget *parent, const char *name) 
   : QWidget(parent,name)
{
   t = tr;
   initDialog();
   _oldGlobal = t.getGlobal();
   cbtGlobal->setChecked(t.getGlobal());
   cbtGlobal->setEnabled(!t.isGlobal());
   if (t.isNormal()) 
   {
      slotSetGlobal(t.useGlobal());
      connect(cbtGlobal, SIGNAL(toggled(bool)), this, SLOT(slotSetGlobal(bool)));
   } 
   else
      init();
}

KDlgTransfer1::~KDlgTransfer1()
{
}

/** init dialog state */
void KDlgTransfer1::init()
{
   lneMaxResume->setText(QString::number(t.getMaxResume()));
   lneResumeTO->setText(QString::number(t.getWaitResume()));
   cbtCheckResume->setChecked(t.getCheckResume());
   cbtAutoResume->setChecked(t.getAutoResume());
   lneMaxRetry->setText(QString::number(t.getMaxRetry()));
   lneRetryTO->setText(QString::number(t.getWaitRetry()));
   cbtLog->setChecked(t.getLogProcess());
}

void  KDlgTransfer1::initDialog()
{
   QBoxLayout *l = new QVBoxLayout(this, 8);

   QGroupBox *gbox = new QGroupBox(1, Horizontal, i18n("General"), this, "GB1");
   l->addWidget(gbox);

   cbtGlobal= new QCheckBox(i18n("Use global settings"), gbox, "CbtGlobal");

   cbtLog = new QCheckBox(i18n("Log Process output"), gbox, "CbtLog");

   gbox = new QGroupBox(1, Horizontal, i18n("Resuming"), this, "GB2");
   l->addWidget(gbox);

   cbtAutoResume = 
      new QCheckBox(i18n("Automatically resume interrupted transfers"), 
		    gbox, "CbtAutoResume");

   cbtCheckResume = new QCheckBox(i18n("Check for transfer resume capability"), 
				  gbox, "CbtCheckResume");

   QHBox *box = new QHBox(gbox);
   QLabel *lbl = new QLabel(i18n("Maximum number of resume retries"), 
			    box, "LblMaxResume");
   lneMaxResume = new QLineEdit(box, "LneMaxResume");
   lneMaxResume->setFixedWidth(lneMaxResume->fontMetrics().width("XXXX"));
   box->setStretchFactor(lbl, 1);
   box->setStretchFactor(lneMaxResume, 0);

   box = new QHBox(gbox);
   lbl = new QLabel(i18n("Try to resume after (seconds)"), box, "LblResumeTO");
   lneResumeTO= new QLineEdit(box, "LneResumeTO");
   lneResumeTO->setFixedWidth(lneResumeTO->fontMetrics().width("XXXXX"));
   box->setStretchFactor(lbl, 1);
   box->setStretchFactor(lneResumeTO, 0);

   gbox = new QGroupBox(1, Horizontal, i18n("Retries"), this, "GB3");
   l->addWidget(gbox);

   box = new QHBox(gbox);
   lbl = new QLabel(i18n("Maximum number of retries"), box, "LblMaxRetry");
   lneMaxRetry = new QLineEdit(box, "LneMaxRetry");
   lneMaxRetry->setFixedWidth(lneMaxRetry->fontMetrics().width("XXXX"));
   box->setStretchFactor(lbl, 1);
   box->setStretchFactor(lneMaxRetry, 0);

   box = new QHBox(gbox);
   lbl = new QLabel(i18n("Retry after (seconds)"), box, "LblRetryTO");
   lneRetryTO = new QLineEdit(box, "LneRetryTO");
   lneRetryTO->setFixedWidth(lneRetryTO->fontMetrics().width("XXXXX"));
   box->setStretchFactor(lbl, 1);
   box->setStretchFactor(lneRetryTO, 0);

   adjustSize();
   setMinimumSize(size());
}

void KDlgTransfer1::accept()
{
   if (t.isNormal() && t.useGlobal())
      return;
   t.setMaxResume(QString(lneMaxResume->text()).toInt());
   t.setWaitResume(QString(lneResumeTO->text()).toInt());
   t.setGlobal(cbtGlobal->isChecked());
   t.setCheckResume(cbtCheckResume->isChecked());
   t.setAutoResume(cbtAutoResume->isChecked());
   t.setMaxRetry(QString(lneMaxRetry->text()).toInt());
   t.setWaitRetry(QString(lneRetryTO->text()).toInt());
   t.setLogProcess(cbtLog->isChecked());
}

void KDlgTransfer1::reject() 
{
   t.setGlobal(_oldGlobal);
}

/** check if the dialog is in an acceptable state */
bool KDlgTransfer1::isAcceptable()
{
   bool check;
   QString(lneResumeTO->text()).toInt(&check);
   if (!check) return false;
   QString(lneMaxResume->text()).toInt(&check);
   if (!check) return false;
   QString(lneRetryTO->text()).toInt(&check);
   if (!check) return false;
   QString(lneMaxRetry->text()).toInt(&check);
   if (!check) return false;
   return true;
}

void KDlgTransfer1::slotSetGlobal(bool on)
{
   t.setGlobal(on);
   lneMaxResume->setEnabled(!on);
   lneResumeTO->setEnabled(!on);
   cbtCheckResume->setEnabled(!on);
   cbtAutoResume->setEnabled(!on);
   lneMaxRetry->setEnabled(!on);
   lneRetryTO->setEnabled(!on);
   cbtLog->setEnabled(!on);
   init();
   emit signalGlobalChange(on);
}

#include "kdlgtransfer1.moc"
