/***************************************************************************
                          kdlgmanager1.h  -  description
                             -------------------
    begin                : Wed Sep 6 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.15 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDLGMANAGER1_H
#define KDLGMANAGER1_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <kurlrequester.h>
#include <kcombobox.h>
#include <qvaluelist.h>
#include "ktmanager.h"

#ifdef DMALLOC
#include <dmalloc.h>
#endif

/**
 * @short First Page of @ref KTManager configuration
 * 
 * @author Sergio Moretti
 *
 * @version $Id: kdlgmanager1.h,v 1.15 2001/03/29 08:38:48 sergio Exp $
 */

class KDlgManager1 : public QWidget  
{
   Q_OBJECT

public:
   KDlgManager1(KTManager m, QWidget *parent, const char *name=0);
   ~KDlgManager1();
   /** check if dialog is in an acceptable state */
   bool isAcceptable();
  
protected:
   void initDialog();
   /** init the widgets state */
   void init();

   //QCheckBox *cbtGlobal;
   QCheckBox *cbtAutoDownload;
   QCheckBox *cbtRemoveCompleted;
   KComboBox *cmbType;
   KComboBox *cmbPriority;
   QLineEdit *lneMaxConn;
   QLineEdit *lneMaxBand;
   QLineEdit *lneMinBand;
#ifndef KURLREQ_ERR
   KURLRequester *cmbDDir;
   KURLRequester *cmbWDir;
   KURLRequester *cmbLog;
#else
   QLineEdit *lneDDir;
   QLineEdit *lneWDir;
   QLineEdit *lneLog;
#endif

public slots:
   /** close the dialog accepting the data */
   void accept();
   void reject();

protected slots:
   /** update the dialog after a change in global checkbutton */
   void slotSetGlobal(bool on);
#ifndef KURLREQ_ERR
#ifdef KDE_VERSION_POST_1207
   void slotOpenFileDialog(KURLRequester *kreq);
#else
   void slotOpenFileDialog(KURLRequester *) {}
#endif
#else
   void slotOpenFileDialog(KURLRequester *) {}
#endif

signals:
   void sigGlobalChange(bool on);

private:
   KTManager mngr;
   IntList _typeList;
   bool _oldGlobal;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
