/*
 * dwepcrack v0.4 [wep.c]
 * by h1kari - (c) Dachb0den Labs 2002
 *
 * wep code used in dwepcrack is partially based on the fabulous wep_tools
 * linux-based code written by Tim Newsham. http://www.lava.net/~newsham/
 */

/*
 * Copyright (c) 2002 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <openssl/rc4.h>
#include <openssl/md5.h>

#include "dwepcrack.h"

#define MAX_SEED_SIZE (HIGH_KEY_SIZE + IV_SIZE)
static u_char seed[MAX_SEED_SIZE], *wep_pkt;
static int id, wep_len;

/*
 * figure out the id and initialize the seed buffer so we don't have to do
 * a lot of legwork when it comes down to the actual cracking.
 */
void
wep_init(u_char *pkt, int len, int verbose)
{
  memcpy(seed, pkt, IV_SIZE);
  id = (pkt[IV_SIZE] >> 6) & 3;

  wep_pkt = pkt;
  wep_len = len;

  if(verbose)
    printf(" packet length: %d\n"
     " init vector: %02x:%02x:%02x\n"
     " default tx key: %d\n", len, seed[0], seed[1], seed[2], id);
}

/*
 * first decrypt the packet's contents with the specified key, then try to
 * verify the checksum
 */
int
wep_try_key(u_char *keys, int key_len, int verify)
{
  RC4_KEY k;
  u_int crc, compcrc, len;
  u_char *icvp, out[MAX_PKT_SIZE], *pkt;

  pkt = wep_pkt;
  len = wep_len;

  /*
   * in case we're doing a 40-bit optimized key crack, grab the correct key
   * out of those generated
   */
  memcpy(seed + IV_SIZE, keys + (id * WEP_KEY_SIZE), WEP_KEY_SIZE);

  len -= 4;
  pkt += 4;

  /* decrypt the packet */
  RC4_set_key(&k, WEP_KEY_SIZE + IV_SIZE, seed);
  RC4(&k, len, pkt, out);

  /* calculate checksum and see if it checks out */
  icvp = out + len - 4;
  crc = icvp[0] | (icvp[1] << 8) | (icvp[2] << 16) | (icvp[3] << 24);

  compcrc = bufcrc(out, len - 4);

  if(crc == compcrc)
  {
    if(verify)
      report_crack(keys, id, key_len);

    return 0;
  }

  return -1;
}

/*
 * try the specified key, and verify using specified packet
 */
int
wep_try_verify_key(u_char *keys, int key_len, u_char *pkt, int len)
{
  u_char *temp_pkt;
  int temp_len;

  temp_pkt = wep_pkt;
  temp_len = wep_len;

  if(wep_try_key(keys, key_len, 0) != -1)
  {
    /* if our first attempt is success, reinit with our verify packet */
    wep_init(pkt, len, 0);

    if(wep_try_key(keys, key_len, 1) != -1)
      return 0;
    else
      wep_init(temp_pkt, temp_len, 0); /* fallback if unsuccessful */
  }

  return -1;
}

/*
 * generate 40-bit keys based on the supplied seed value
 */
void
wep_seedkeygen40(int val, u_char *keys)
{
  int i;

  for(i = 0; i < WEP_KEY_STORE; i++)
  {
    val *= 0x343fd;
    val += 0x269ec3;
    keys[i] = val >> 16;
  }
}

/*
 * generate 40-bit key based on the supplied string
 */
void
wep_keygen40(char *str, u_char *keys)
{
  int val, i, shift;

  for(i = 0, val = 0; str[i] != 0; i++)
  {
    shift = i & 0x3;
    val ^= (str[i] << (shift * 8));
  }

  wep_seedkeygen40(val, keys);
}

/*
 * generate 104-bit key based on the supplied string
 */
#define MD5_BUF_LEN 64
void
wep_keygen104(char *str, u_char *key)
{
  int i, j;
  u_char md5_buf[MD5_BUF_LEN];
  MD5_CTX ctx;

  for(i = 0, j = 0; i < MD5_BUF_LEN; i++, j++)
  {
    if(str[j] == 0)
      j = 0;
    md5_buf[i] = str[j];
  }

  MD5_Init(&ctx);
  MD5_Update(&ctx, md5_buf, MD5_BUF_LEN);
  MD5_Final(md5_buf, &ctx);

  memcpy(key, md5_buf, HIGH_KEY_SIZE);
  memset(key + HIGH_KEY_SIZE, 0, WEP_KEY_STORE - HIGH_KEY_SIZE);
}
