/*
 * Copyright (c) 1997, 2000, 2001, Mark Buser.
 * Copyright (c) 2001, 2003, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/xutil.h,v 1.8 2003/11/19 20:01:09 danny Exp $
 */
#ifndef XUTIL_H
#define XUTIL_H

#ifndef COLOR_H
#include "color.h"
#endif

#ifdef	XPRINT
#include <X11/extensions/Print.h>
#endif

typedef struct PerDisplay {
        Widget          Toplevel;
        Display         *dpy;
        Window          win;
        GC              gc;
        Colormap        cmap;
        Widget          draw;
        Screen          *scr;
#ifdef	XPRINT
        XPContext       pctxt;
#endif
        Widget          wstart, wrate;
        GC              const_gc;
        Pixel           color[LAST_COLOR];
        Colormap        _cmap;
        XFontStruct     *small, *large;
        Dimension       wid, ht;
        int             busy, count;
        void            *attrib;
} PerDisplay;

extern PerDisplay Global[], *per;

#if XmVERSION == 1
/* Motif 1.x toggle button does not have XmSET, only True or False */
#define XmSET   True
#define XmUNSET False
/* Motif 1.x scrollbar does not have XmNONE, only True and False */
#define XmNONE False
#endif

typedef struct {
       char *name;                  /* "button_0", "separator_0", etc */
       char *class;                 /* XmVaPUSHBUTTON, etc */
       XtCallbackProc callbackproc; /* NULL if none */
} MENUITEMS;

#ifndef XQUOTE
typedef struct {
  char *name;                  /* "button_0", "separator_0", etc */
  char *class;                 /* XmVaPUSHBUTTON, etc */
  Pixmap sens, insens, sel;    /* Pixmap, NULL if not used */
  XtPointer userdata;          /* XmNuserData */
  XtCallbackProc eventproc;    /* proc for Enter/Leave Window, NULL if none */
  XtCallbackProc activecallbackproc; /* activate callback, NULL if none */
  XtCallbackProc armcallbackproc;    /* arm callback, NULL if none */
} BUTTONITEMS;
Widget makeButtonbar (Widget, char *, int, BUTTONITEMS *, int);
#endif

Widget GetTopShell (Widget); /* Get top most widget in the tree containing w */
void DestroyShell (Widget, XtPointer, XtPointer);

void CenterWidget (Widget, Widget); /* Center 2nd param in 1st param parent */

Widget makeMenuPulldown (Widget, char *, int, MENUITEMS *, int);

void setOptionMenu (Widget, int);

void setBusyCursor (Widget, int);

int  isCDE();                      /* Return true if running under CDE */
String *getFallbackResource();

/* AllowShellResize options */
#define UNLOCK   1
#define LOCK     2
#define ALLOW    4
#define DISALLOW 8

#ifdef XQUOTE
void AllowShellResize (Widget, int);
void PostIt (Widget, XtPointer, XEvent *);
void cylonStart (int);
#endif

#endif
