/*
 * Copyright (c) 1997, Mark Buser.
 * Copyright (c) 2003, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/tooltips.c,v 1.3 2003/11/19 19:35:13 danny Exp $
 */
#include <Xm/XmAll.h>

#include "color.h"

#define UP   0
#define DOWN 1

#define UP_TIME 750L        /* pause time before popup 750 mS */
#define DOWN_TIME 4000L     /* pause time before popdown 4 S */

static Widget popup = (Widget) NULL;
static int pause = True;    /* pause before popup? */

static void popToolTips (int way)
{
  if (popup) {
    if (way == UP)
      XtRealizeWidget (popup);
    else
      XtUnrealizeWidget (popup);
  }
}

/* ARGSUSED */
static void downTime (int client_data, XtIntervalId timer)
{
  popToolTips (DOWN);
  pause = True;
}

/* ARGSUSED */
static void upTime (XtAppContext appContext, XtIntervalId timer)
{
  static XtIntervalId downTimer = (XtIntervalId) NULL;

  popToolTips (UP);

  if (downTimer)
    XtRemoveTimeOut (downTimer);
  downTimer = XtAppAddTimeOut (appContext, DOWN_TIME, 
                      (XtTimerCallbackProc)downTime, (XtPointer)NULL);

}

/* ARGSUSED */
static void pauseTime (XtAppContext appContext, XtIntervalId timer)
{
  pause = True;
}

/* ARGSUSED */
static void downCB (Widget w, XtPointer client_data, XtPointer call_data)
{
  popToolTips (DOWN);
  pause = True;
}

/* ARGSUSED */
void showToolTips ( Widget w, XtPointer client_data, XEvent *event)
{
  static Widget label;
  Widget frame;

  XmFontList font_list;
  XmString label_str;
  Dimension label_width, label_height, height;

  Position root_x, root_y;

  static XtIntervalId upTimer = (XtIntervalId) NULL;
  XtAppContext appContext = XtWidgetToApplicationContext (w);

  if (event->type == EnterNotify) {

    if (popup == (Widget)NULL) {
       popup = XtVaAppCreateShell ("TipShell", "TipClass",
                                   applicationShellWidgetClass,
                                   XtDisplayOfObject(w),
                                   XmNoverrideRedirect, True,
                                   XmNcolormap, GetColormap(),
                                   NULL);
       frame = XtVaCreateManagedWidget ("tipFrame", 
                                xmFrameWidgetClass, popup, 
                                NULL);
       label = XtVaCreateManagedWidget("tipLabel", 
                                       xmLabelGadgetClass, frame,
                                       NULL);
    }

    XtVaGetValues( label, XmNfontList, &font_list, NULL);
    XtVaGetValues( w,     XmNlabelString, &label_str, NULL);

    label_width = XmStringWidth( font_list, label_str);
    label_height = XmStringHeight( font_list, label_str);

    XtVaSetValues( label, XmNlabelString, label_str, NULL);
    XmStringFree( label_str );

    XtTranslateCoords( w, (Position)0, (Position)0, &root_x, &root_y);
    XtVaGetValues( w, XmNheight, &height, NULL);

#define BORDER 2

    XtVaSetValues (popup, XmNx, root_x,
                          XmNy, root_y+height,
                          XmNwidth, label_width + (BORDER*2),
                          XmNheight, label_height + (BORDER*2),
                   NULL);
#undef BORDER

    if (upTimer) {
      XtRemoveTimeOut (upTimer);
      upTimer = (XtIntervalId) NULL;
    }

    if (pause == True)
      upTimer = XtAppAddTimeOut (appContext, UP_TIME, 
                        (XtTimerCallbackProc)upTime, (XtPointer)appContext);
    else
      upTime (appContext, (XtIntervalId) NULL);

  } else if (event->type == LeaveNotify && popup) {

    if (upTimer) {
      XtRemoveTimeOut (upTimer);
      upTimer = (XtIntervalId) NULL;
    }

    if (XtIsRealized (popup) ) {
      popToolTips (DOWN);

      pause = False;
      upTimer = XtAppAddTimeOut (appContext, UP_TIME, 
	                (XtTimerCallbackProc)pauseTime, (XtPointer)appContext);
    }
  }
}

/* 
** Install tooltips event handlers and callbacks.  Only works for 
** XmPushButton or XmToggleButton classes.
*/
void installToolTips (Widget w)
{
  XtAddEventHandler (w, LeaveWindowMask | EnterWindowMask, False,
		     (XtEventHandler) showToolTips, (XtPointer) 0);
  if (XmIsPushButton(w) || XmIsPushButtonGadget(w))
    XtAddCallback (w, XmNactivateCallback, downCB, (XtPointer)NULL);
  if (XmIsToggleButton(w) || XmIsToggleButtonGadget(w))
    XtAddCallback (w, XmNvalueChangedCallback, downCB, (XtPointer)NULL);
}
