/*
 * Copyright (c) 2000, Mark Buser.
 * Copyright (c) 2003, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/resource.c,v 1.2 2003/11/19 19:35:12 danny Exp $
 */
#include <ctype.h>
#include <Xm/XmAll.h>

#include "resource.h"

/* Globals */
static RESOURCE_STRUCT **type_data;
static int type_num;

/* Return string associated with X resource */
char *getResource (int type, int which)
{
  static char *empty = "";
  if (type >= type_num)
     return (empty);
  if (which >= type_data[type]->num_resources)
     return (empty);
  if (type_data[type]->resources->values[which] == NULL)
     return (empty);
  return (type_data[type]->resources->values[which]);
}

/* Read all there is to know from X resources */
int readResourceDatabase (Widget Toplevel, char *appname, 
                          char *resclass, char *resname, 
                          char propnames[][7], int num_propnames)
{
  XrmDatabase	db = XtScreenDatabase(XtScreenOfObject(Toplevel));
  XrmQuark      class[5], name[5];
  XrmValue      value;
  XrmRepresentation type;
  int field;

  /* Set up for resource fetch */
  class[0] = XrmStringToQuark("Xinvest");
  class[1] = XrmStringToQuark(resclass);
  class[2] = NULLQUARK;

  name[0] = XrmStringToQuark(appname);
  name[1] = XrmStringToQuark(resname);
  name[2] = NULLQUARK;

  /* when fetching query strings, these are the end */
  class[3] = XrmStringToQuark("LabelString");
  name[3]  = XrmStringToQuark("labelString");
  class[4] = NULLQUARK;
  name[4]  = NULLQUARK;

  /* Add new resource structure */
  type_num++;
  type_data = (RESOURCE_STRUCT **) XtRealloc ((char *)type_data, type_num *
		                               sizeof(RESOURCE_STRUCT *));
  type_data[type_num-1] = (RESOURCE_STRUCT *)
                                   XtCalloc(1, sizeof(RESOURCE_STRUCT));
  type_data[type_num-1]->num_resources = num_propnames;
  type_data[type_num-1]->resources = (QUERY_STRUCT *) 
                                   XtCalloc (1, sizeof (QUERY_STRUCT));

  /* Fill in resource fields */
  for (field = 0; field < num_propnames; field++) {
    propnames[field][0] = toupper ( propnames[field][0] );
    class[2] = XrmStringToQuark (propnames[field]);
    propnames[field][0] = tolower ( propnames[field][0] );
    name[2] = XrmStringToQuark (propnames[field]);
    XrmQGetResource (db, name, class, &type, &value);
    type_data[type_num-1]->resources->values[field] = XtNewString (value.addr);
  }

  return (type_num-1);
}
