/*
 * Copyright (c) 1997, 2000, 2001, Mark Buser.
 * Copyright (c) 2001, 2003, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/color.c,v 1.13 2003/11/19 19:35:09 danny Exp $
 */
static char id[] = "$Header: /pack/anoncvs/xinvest/src/color.c,v 1.13 2003/11/19 19:35:09 danny Exp $";

#include <stdio.h>

#if !defined(__NetBSD__)
#include <values.h>
#endif

#include <Xm/Xm.h>

#ifdef XQUOTE
#include "xquote.h"
#else
#include "xinvest.h"
#endif
#include "color.h"
#include "xutil.h"

Colormap GetColormap()
{
  return per->_cmap;
}

Colormap NewColormap(Display *dpy, Colormap cmap)
{
   Colormap new = XCopyColormapAndFree ( dpy, cmap );
   if ( new == (Colormap)BadAlloc ||
        new == (Colormap)BadColor) {
      return (Colormap)NULL;
   }
   per->_cmap = new;

   fprintf(stderr, "NewColormap -> %p\n", (void *)new);

   return new;
}

Pixel GetColor ( int which )
{
  return ( per->color[which] );
} 

/* 
** Allocate all colors in color table.  
** Return NULL if any failures.
*/
Colormap InitColor(Widget top, Colormap cmap, Pixel *appColor) 
{
  int i;

  /* Just copy app level color resources */
  if (appColor)
    for (i = USER0; i < LAST_COLOR; i++)
      per->color[i] = appColor[i];

  per->_cmap = cmap;
  return cmap;
}

/*
 * Do the XmRString -> XmRPixel conversion ourselves
 * because we need to have it done per display.
 */
Pixel GetNamedColor(PerDisplay *per, String name)
{
	Pixel	to_p;
	XrmValue	from, to;
	
	if (! name)
		return (Pixel)0;

	from.size = strlen(name)+1;
	from.addr = (caddr_t) name;
	to.size = sizeof(Pixel);
	to.addr = (caddr_t)&to_p;
	
	if (XtConvertAndStore(per->Toplevel, XmRString, &from, XmRPixel, &to))
		return to_p;

	return (Pixel)0;
}

int isColorVisual (Display *dpy)
{
  Visual *visual = XDefaultVisual( dpy, XDefaultScreen( dpy ));

  /* We're not supposed to do this, but its so much easier. */
  switch ( visual->class ) {

#ifndef MONO_TEST
     case DirectColor:
     case PseudoColor:
     case StaticColor:
     case TrueColor:
                       return True;
                       /* break; */
#endif

     case GrayScale:
     case StaticGray:
     default:
                       return False;
                       /* break; */
  }
}


int isDarkPixel ( Display *dpy, Pixel color )
{
  int color_intensity = 0, max_intensity = 0;
  XColor xcolor;

  xcolor.pixel = color;
  XQueryColor (dpy, GetColormap(), &xcolor);

  if ( xcolor.flags & DoGreen ) {
    color_intensity += xcolor.green;
    max_intensity += 65535;
  }
  if ( xcolor.flags & DoRed ) {
    color_intensity += xcolor.red;
    max_intensity += 65535;
  }
  if ( xcolor.flags & DoBlue ) {
    color_intensity += xcolor.blue;
    max_intensity += 65535;
  }

  if ( (float)color_intensity / (float)max_intensity < 0.67 )
    return True;
  else
    return False;
}

void AllocateAllColors(void)
{
	extern AppData	appdata;

	per->color[0] = GetNamedColor(per, appdata.color0);
	per->color[1] = GetNamedColor(per, appdata.color1);
	per->color[2] = GetNamedColor(per, appdata.color2);
	per->color[3] = GetNamedColor(per, appdata.color3);
	per->color[4] = GetNamedColor(per, appdata.color4);
	per->color[5] = GetNamedColor(per, appdata.color5);
	per->color[6] = GetNamedColor(per, appdata.color6);
	per->color[7] = GetNamedColor(per, appdata.color7);
	per->color[8] = GetNamedColor(per, appdata.colorRed);
	per->color[9] = GetNamedColor(per, appdata.colorGreen);
	per->color[10] = GetNamedColor(per, appdata.colorGrey);
	per->color[11] = GetNamedColor(per, appdata.colorWhite);
	per->color[12] = GetNamedColor(per, appdata.colorBlack);
	per->color[13] = GetNamedColor(per, appdata.colorPrintForeground);
	per->color[14] = GetNamedColor(per, appdata.colorPrintBackground);
	per->color[15] = GetNamedColor(per, appdata.colorPrintIllustrations);
}
