/*
 * Copyright (c) 1996, 1997, 1998, 2000, Mark Buser.
 * Copyright (c) 2003, 2004, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/account.h,v 2.17 2004/04/18 10:58:36 danny Exp $
 */
int activeAccount();              /* Return index number of current account */
int numAccounts();                 /* Return number of open accounts */



/* Return True if at least one account has 'flag' set */
#define ACCOUNT_DIRTY         1   /* The account has changed */
#define ACCOUNT_UPDATE        2   /* Changes need to be processed */
#define ACCOUNT_IN_PORTFOLIO  4   /* Account has been added  */
#define ACCOUNT_WRITABLE      8   /* Account file is writable  */
#define ACCOUNT_LIVEUPDATE   16   /* We've had a live-update for this account */

int accountStatus(int which, unsigned flag ); /* Is 'flag' set in 'which' */
int accountsStatus(int flag );    /* Is flag set anywhere */

/* Set account dirty flag to unmodified */
void accountClean( int );

#define ALL_ACCOUNTS -1           /* flag to add or delete all open accounts */
/* Set/clear account in portfolio flag */
void accountAddPortfolio( int );
void accountDelPortfolio( int );



/* Returns index number of account if passed filename matches an already open
** account. */
int accountIsOpen (char *);

/* Display the next account in line */
void cycleAccount();



/* Valid setAccount fields */
#define ACCOUNT_FILENAME  1
#define ACCOUNT_NUM_TRANS 2
#define ACCOUNT_TRANS     3
#define ACCOUNT_TITLE     4
#define ACCOUNT_TICKER    5
#define ACCOUNT_NAV       6
#define ACCOUNT_TRANSTEXT 7
#define ACCOUNT_PLOT      8
#define ACCOUNT_CURRENCY  9
#define ACCOUNT_CTICKER   10
#define ACCOUNT_ETICKER   11
#define ACCOUNT_ECTICKER  12

/* Set/get account fields */
void getAccount ( int, int, void *);
void setAccount ( int, int, void *);



/* Open an account.  1st param is filename, second pointer to text holding
** transactions, third file writable.  Returns index of new account */
int newAccount ( char *, char *, int);

/* Close account with index int */
void closeAccount ( int );

/* Process account transactions for account */
void processAccount ( int );

/* Update display with an account */
void displayAccount ( int );

/* Save account info into file */
void saveAccount ( FILE *, int);

/* Creation routine for account menu */
void makeAccountmenu();

/* Return a good name for an open account */
char *createAccountName (int);

/* Find account matching ticker name, update it's NAV */
int accountMatchTicker (char *, int, int, int, double);

/* Change background of Widget if passed date matches one in transaction */
void accountHighlightDay (char *, int, Widget);
void ProcessAccountsForCticker(void);
int Account2CurrencyAccount(int);
char *GetAccountTitle(int);
double GetCurrencyForDate(int num, long ldate);
