/*
   flame - cosmic recursive fractal flames
   Copyright (C) 1992  Scott Draves <spot@cs.cmu.edu>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include "cmap.h"

#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#include <glib.h>		/* Needed on Win32 where RAND_FUNC is from GLib */

#include "config.h"

unsigned char the_cmaps[][256][3] = {
/* south-sea-bather */
{{185, 234, 235}, {193, 238, 235}, {197, 242, 235}, {201, 242, 235}, 
 {201, 246, 235}, {205, 246, 235}, {205, 246, 235}, {205, 242, 235}, 
 {209, 242, 235}, {210, 238, 235}, {209, 242, 225}, {214, 242, 235}, 
 {221, 246, 254}, {213, 242, 244}, {242, 250, 244}, {226, 242, 235}, 
 {222, 242, 235}, {214, 242, 235}, {214, 242, 244}, {209, 238, 244}, 
 {209, 238, 244}, {205, 238, 244}, {205, 238, 235}, {201, 238, 235}, 
 {201, 238, 235}, {201, 238, 244}, {201, 238, 244}, {201, 242, 244}, 
 {205, 242, 244}, {209, 242, 244}, {210, 242, 244}, {209, 246, 244}, 
 {205, 242, 244}, {197, 242, 244}, {189, 242, 244}, {189, 242, 244}, 
 {185, 238, 244}, {181, 242, 244}, {189, 242, 244}, {193, 242, 244}, 
 {197, 242, 254}, {197, 242, 254}, {189, 242, 244}, {181, 242, 244}, 
 {177, 242, 244}, {181, 238, 244}, {189, 234, 235}, {189, 234, 235}, 
 {193, 230, 235}, {193, 230, 235}, {189, 230, 225}, {181, 230, 225}, 
 {165, 230, 225}, {165, 226, 225}, {161, 226, 235}, {157, 230, 234}, 
 {153, 222, 244}, {165, 226, 244}, {165, 230, 244}, {165, 230, 244}, 
 {169, 226, 244}, {173, 226, 235}, {177, 226, 235}, {177, 222, 235}, 
 {177, 226, 235}, {177, 230, 244}, {177, 226, 244}, {177, 226, 244}, 
 {177, 226, 244}, {173, 226, 244}, {169, 226, 244}, {161, 230, 254}, 
 {157, 230, 254}, {165, 234, 244}, {173, 234, 244}, {177, 238, 234}, 
 {185, 238, 235}, {193, 238, 235}, {197, 238, 235}, {197, 238, 235}, 
 {201, 238, 235}, {201, 242, 244}, {197, 242, 244}, {197, 238, 244}, 
 {197, 234, 244}, {197, 234, 244}, {197, 234, 244}, {193, 230, 235}, 
 {193, 230, 235}, {197, 234, 225}, {197, 230, 226}, {194, 226, 207}, 
 {206, 155, 132}, {178, 127, 113}, {166, 132, 85}, {145, 128, 85}, 
 {154, 128, 85}, {162, 114, 85}, {162, 118, 75}, {182, 114, 75}, 
 {186, 127, 103}, {210, 164, 132}, {198, 226, 198}, {201, 234, 225}, 
 {206, 238, 216}, {222, 171, 131}, {206, 155, 122}, {190, 144, 122}, 
 {202, 151, 122}, {219, 163, 132}, {230, 183, 150}, {250, 233, 206}, 
 {222, 234, 235}, {209, 238, 235}, {193, 226, 235}, {189, 222, 235}, 
 {181, 222, 235}, {173, 226, 244}, {169, 226, 244}, {169, 226, 244}, 
 {173, 230, 244}, {173, 234, 235}, {173, 234, 234}, {173, 230, 235}, 
 {173, 226, 235}, {173, 226, 234}, {177, 230, 226}, {181, 230, 226}, 
 {189, 230, 235}, {193, 230, 244}, {197, 234, 244}, {201, 234, 244}, 
 {201, 238, 244}, {201, 238, 244}, {201, 238, 244}, {201, 238, 244}, 
 {201, 238, 244}, {201, 242, 244}, {201, 242, 244}, {201, 242, 244}, 
 {201, 242, 244}, {201, 242, 244}, {197, 238, 244}, {193, 238, 254}, 
 {177, 238, 254}, {173, 230, 244}, {177, 230, 244}, {177, 234, 244}, 
 {181, 238, 244}, {189, 238, 244}, {193, 242, 244}, {201, 246, 244}, 
 {205, 246, 244}, {205, 246, 244}, {205, 246, 244}, {205, 242, 244}, 
 {205, 238, 244}, {205, 238, 254}, {201, 238, 254}, {197, 238, 254}, 
 {193, 238, 244}, {193, 238, 244}, {193, 234, 244}, {193, 234, 235}, 
 {193, 234, 235}, {193, 234, 235}, {189, 234, 244}, {185, 234, 244}, 
 {181, 234, 244}, {181, 230, 244}, {181, 230, 244}, {181, 234, 244}, 
 {189, 234, 244}, {193, 234, 244}, {197, 234, 235}, {197, 234, 235}, 
 {201, 234, 235}, {201, 234, 244}, {205, 234, 244}, {205, 238, 244}, 
 {205, 238, 244}, {205, 238, 244}, {205, 242, 244}, {201, 242, 235}, 
 {201, 242, 235}, {197, 242, 235}, {193, 234, 244}, {185, 230, 244}, 
 {181, 226, 244}, {181, 226, 244}, {181, 230, 244}, {181, 230, 244}, 
 {185, 234, 235}, {189, 238, 235}, {189, 242, 235}, {193, 238, 235}, 
 {197, 238, 235}, {197, 238, 235}, {197, 238, 225}, {193, 234, 225}, 
 {189, 222, 216}, {170, 148, 113}, {117, 104, 66}, {72, 55, 37}, 
 {11, 12, 9}, {36, 44, 37}, {76, 117, 103}, {158, 145, 113}, 
 {177, 206, 197}, {189, 226, 216}, {189, 234, 226}, {193, 238, 235}, 
 {189, 238, 244}, {189, 238, 244}, {189, 238, 244}, {185, 234, 244}, 
 {185, 234, 244}, {185, 230, 244}, {189, 230, 235}, {189, 230, 235}, 
 {189, 234, 244}, {193, 238, 244}, {197, 242, 254}, {201, 246, 254}, 
 {201, 242, 254}, {197, 238, 254}, {193, 238, 244}, {189, 238, 235}, 
 {185, 234, 235}, {177, 230, 234}, {181, 230, 235}, {181, 230, 235}, 
 {185, 226, 235}, {181, 230, 235}, {189, 230, 235}, {193, 234, 235}, 
 {193, 234, 244}, {189, 234, 244}, {185, 230, 244}, {181, 230, 244}, 
 {177, 230, 244}, {177, 230, 235}, {169, 226, 235}, {169, 226, 235}, 
 {161, 222, 225}, {137, 190, 197}, {158, 145, 122}, {149, 124, 103}, 
 {133, 121, 103}, {141, 106, 75}, {141, 95, 66}, {133, 99, 66}, 
 {121, 108, 66}, {121, 100, 56}, {117, 104, 65}, {93, 89, 56}, 
 },
   /* sky-flesh */
{{166, 148, 122}, {219, 162, 132}, {238, 212, 178}, {250, 237, 206}, 
 {238, 250, 235}, {226, 242, 235}, {218, 242, 225}, {206, 242, 225}, 
 {206, 238, 225}, {206, 234, 207}, {182, 169, 141}, {178, 138, 103}, 
 {178, 130, 103}, {170, 147, 113}, {177, 198, 179}, {181, 230, 225}, 
 {185, 230, 235}, {189, 230, 244}, {197, 230, 244}, {201, 234, 244}, 
 {205, 234, 244}, {205, 238, 244}, {201, 234, 235}, {197, 234, 225}, 
 {193, 222, 207}, {170, 148, 122}, {145, 127, 94}, {117, 100, 66}, 
 {60, 64, 47}, {20, 36, 28}, {8, 20, 9}, {20, 28, 18}, 
 {56, 60, 37}, {113, 91, 56}, {145, 106, 75}, {166, 121, 85}, 
 {190, 137, 103}, {230, 190, 169}, {218, 230, 226}, {214, 238, 235}, 
 {209, 238, 244}, {205, 238, 244}, {205, 238, 244}, {201, 238, 244}, 
 {197, 234, 244}, {197, 234, 244}, {197, 230, 244}, {197, 230, 244}, 
 {197, 230, 244}, {193, 234, 244}, {185, 230, 244}, {177, 226, 235}, 
 {157, 206, 206}, {120, 153, 141}, {96, 133, 132}, {108, 141, 141}, 
 {141, 177, 178}, {173, 226, 225}, {177, 230, 235}, {185, 234, 235}, 
 {185, 242, 244}, {197, 242, 244}, {197, 238, 244}, {197, 238, 244}, 
 {197, 238, 244}, {193, 234, 244}, {189, 230, 235}, {185, 214, 197}, 
 {154, 144, 122}, {150, 127, 94}, {146, 128, 85}, {133, 115, 75}, 
 {133, 120, 75}, {125, 107, 75}, {125, 112, 85}, {133, 111, 75}, 
 {141, 101, 66}, {129, 106, 75}, {137, 106, 66}, {133, 102, 66}, 
 {141, 91, 66}, {141, 93, 56}, {137, 93, 47}, {117, 87, 37}, 
 {109, 74, 37}, {56, 44, 28}, {12, 20, 9}, {4, 16, 0}, 
 {12, 28, 9}, {52, 47, 28}, {80, 76, 47}, {113, 91, 56}, 
 {121, 94, 56}, {125, 98, 56}, {113, 87, 37}, {85, 63, 28}, 
 {40, 44, 28}, {12, 12, 9}, {0, 12, 0}, {4, 24, 9}, 
 {28, 60, 37}, {56, 88, 75}, {121, 104, 84}, {145, 132, 103}, 
 {170, 160, 132}, {193, 226, 207}, {197, 238, 225}, {205, 242, 235}, 
 {205, 242, 244}, {205, 238, 244}, {201, 238, 244}, {201, 238, 244}, 
 {201, 238, 244}, {197, 238, 244}, {193, 234, 244}, {189, 230, 235}, 
 {189, 226, 225}, {186, 189, 151}, {186, 150, 103}, {166, 135, 94}, 
 {166, 134, 94}, {162, 130, 94}, {162, 130, 94}, {166, 130, 85}, 
 {162, 130, 85}, {158, 126, 75}, {150, 118, 75}, {158, 113, 75}, 
 {150, 117, 66}, {154, 117, 66}, {149, 114, 75}, {158, 131, 85}, 
 {166, 139, 85}, {174, 142, 85}, {182, 155, 113}, {198, 194, 169}, 
 {205, 230, 216}, {205, 234, 235}, {197, 222, 244}, {193, 226, 244}, 
 {185, 230, 244}, {181, 226, 244}, {177, 226, 226}, {145, 165, 160}, 
 {158, 144, 103}, {158, 144, 94}, {166, 143, 94}, {186, 160, 122}, 
 {197, 222, 207}, {202, 226, 226}, {201, 234, 235}, {197, 234, 235}, 
 {193, 238, 244}, {189, 234, 244}, {173, 226, 244}, {173, 222, 235}, 
 {137, 157, 160}, {137, 120, 113}, {129, 124, 103}, {141, 132, 94}, 
 {158, 126, 94}, {170, 143, 113}, {178, 185, 160}, {185, 230, 225}, 
 {189, 230, 235}, {193, 234, 235}, {193, 234, 235}, {193, 234, 225}, 
 {182, 194, 170}, {162, 144, 113}, {146, 119, 85}, {113, 92, 66}, 
 {68, 64, 37}, {24, 32, 9}, {0, 16, 9}, {0, 12, 9}, 
 {12, 16, 18}, {56, 47, 28}, {113, 83, 46}, {133, 90, 56}, 
 {150, 108, 56}, {154, 109, 66}, {158, 104, 66}, {153, 100, 56}, 
 {165, 95, 47}, {158, 103, 47}, {158, 108, 56}, {158, 104, 66}, 
 {157, 110, 75}, {158, 104, 75}, {162, 113, 75}, {162, 108, 75}, 
 {158, 113, 66}, {170, 112, 66}, {174, 116, 75}, {182, 124, 75}, 
 {174, 120, 75}, {182, 124, 85}, {190, 142, 103}, {214, 192, 169}, 
 {210, 230, 225}, {214, 234, 235}, {214, 234, 235}, {210, 234, 235}, 
 {209, 234, 235}, {205, 234, 235}, {205, 238, 235}, {202, 238, 235}, 
 {197, 238, 235}, {197, 238, 235}, {197, 238, 235}, {197, 238, 235}, 
 {201, 238, 235}, {202, 238, 235}, {205, 238, 235}, {205, 238, 235}, 
 {210, 242, 235}, {214, 242, 235}, {214, 238, 225}, {210, 234, 226}, 
 {198, 210, 188}, {178, 151, 122}, {158, 115, 103}, {125, 107, 85}, 
 {92, 97, 94}, {48, 76, 66}, {12, 24, 28}, {8, 12, 18}, 
 {4, 8, 9}, {16, 28, 18}, {56, 56, 37}, {100, 75, 56}, 
 {133, 98, 66}, {146, 110, 85}, {154, 123, 94}, {158, 140, 103}, 
 {178, 177, 141}, {185, 230, 216}, {193, 234, 235}, {197, 234, 235}, 
 {206, 234, 225}, {206, 234, 207}, {214, 162, 132}, {190, 137, 94}, 
 {178, 125, 94}, {170, 123, 94}, {170, 125, 94}, {166, 135, 113}, 
 {178, 168, 141}, {185, 226, 207}, {181, 230, 235}, {185, 230, 244}, 
 {185, 230, 244}, {181, 226, 235}, {190, 210, 198}, {170, 152, 113}, 
 },
   /* blue-bather */
{{125, 100, 84}, {162, 99, 75}, {174, 99, 75}, {182, 115, 104}, 
 {190, 124, 122}, {190, 137, 141}, {194, 153, 151}, {206, 161, 160}, 
 {218, 173, 169}, {230, 169, 188}, {238, 172, 197}, {234, 180, 197}, 
 {234, 176, 188}, {222, 180, 188}, {222, 173, 179}, {226, 161, 169}, 
 {226, 149, 169}, {214, 141, 151}, {210, 141, 151}, {198, 145, 141}, 
 {194, 137, 132}, {190, 132, 122}, {178, 124, 104}, {150, 104, 85}, 
 {113, 92, 75}, {56, 64, 75}, {52, 68, 103}, {48, 60, 122}, 
 {40, 60, 132}, {39, 56, 132}, {40, 56, 122}, {36, 52, 122}, 
 {36, 52, 103}, {40, 36, 56}, {31, 24, 47}, {12, 24, 37}, 
 {4, 20, 28}, {0, 16, 28}, {4, 16, 28}, {12, 24, 28}, 
 {40, 31, 37}, {52, 40, 56}, {44, 48, 66}, {52, 56, 113}, 
 {48, 68, 141}, {56, 81, 160}, {64, 85, 170}, {68, 97, 179}, 
 {72, 97, 188}, {72, 97, 188}, {72, 101, 188}, {72, 105, 179}, 
 {76, 101, 179}, {80, 101, 179}, {173, 124, 123}, {186, 136, 132}, 
 {186, 141, 132}, {190, 141, 141}, {190, 141, 132}, {190, 145, 132}, 
 {194, 141, 132}, {190, 137, 132}, {186, 137, 132}, {177, 128, 132}, 
 {76, 105, 179}, {80, 105, 188}, {84, 109, 188}, {186, 153, 151}, 
 {190, 157, 151}, {198, 161, 151}, {202, 165, 160}, {202, 161, 170}, 
 {202, 165, 170}, {202, 169, 170}, {202, 169, 170}, {206, 173, 170}, 
 {206, 173, 170}, {210, 173, 170}, {210, 169, 170}, {202, 165, 160}, 
 {202, 165, 160}, {202, 161, 151}, {198, 153, 151}, {198, 145, 141}, 
 {194, 145, 141}, {194, 145, 141}, {198, 145, 132}, {198, 136, 122}, 
 {182, 120, 113}, {170, 103, 94}, {158, 88, 75}, {84, 60, 56}, 
 {48, 52, 56}, {40, 40, 47}, {36, 48, 47}, {40, 48, 56}, 
 {40, 52, 66}, {40, 52, 113}, {48, 56, 132}, {52, 68, 151}, 
 {60, 81, 170}, {72, 93, 179}, {72, 97, 179}, {72, 97, 179}, 
 {72, 97, 179}, {73, 93, 170}, {169, 111, 122}, {186, 128, 132}, 
 {186, 132, 132}, {190, 128, 141}, {194, 116, 132}, {182, 115, 113}, 
 {190, 111, 104}, {178, 99, 85}, {170, 84, 75}, {117, 84, 84}, 
 {68, 60, 85}, {52, 68, 113}, {48, 64, 132}, {56, 73, 141}, 
 {109, 88, 122}, {158, 116, 104}, {169, 124, 113}, {161, 128, 113}, 
 {73, 101, 170}, {72, 101, 179}, {72, 101, 179}, {73, 97, 170}, 
 {165, 120, 113}, {170, 120, 113}, {178, 124, 113}, {182, 120, 113}, 
 {178, 119, 103}, {154, 107, 85}, {121, 96, 94}, {52, 64, 132}, 
 {44, 64, 132}, {48, 68, 141}, {52, 73, 151}, {56, 85, 160}, 
 {64, 89, 170}, {64, 93, 170}, {64, 93, 170}, {68, 93, 170}, 
 {68, 97, 170}, {84, 97, 151}, {145, 104, 94}, {174, 80, 75}, 
 {162, 72, 66}, {84, 60, 65}, {64, 52, 66}, {52, 48, 66}, 
 {77, 73, 75}, {141, 100, 84}, {170, 116, 104}, {182, 120, 113}, 
 {182, 120, 113}, {178, 124, 113}, {174, 124, 122}, {141, 104, 132}, 
 {64, 77, 151}, {52, 68, 151}, {48, 64, 141}, {44, 56, 141}, 
 {52, 68, 151}, {56, 81, 170}, {68, 89, 179}, {64, 97, 188}, 
 {72, 97, 188}, {76, 101, 188}, {76, 105, 188}, {80, 109, 188}, 
 {182, 137, 151}, {194, 149, 151}, {198, 153, 160}, {198, 153, 160}, 
 {194, 153, 151}, {186, 149, 141}, {186, 141, 132}, {169, 128, 122}, 
 {76, 101, 179}, {72, 101, 179}, {68, 101, 179}, {60, 93, 170}, 
 {52, 81, 160}, {48, 73, 151}, {52, 73, 151}, {60, 77, 151}, 
 {129, 100, 113}, {169, 120, 113}, {182, 132, 122}, {186, 132, 122}, 
 {186, 132, 122}, {170, 124, 123}, {76, 97, 170}, {68, 93, 170}, 
 {68, 93, 170}, {68, 85, 170}, {64, 85, 170}, {64, 81, 160}, 
 {68, 85, 122}, {129, 92, 84}, {170, 95, 75}, {178, 91, 75}, 
 {186, 111, 94}, {194, 119, 94}, {186, 119, 104}, {186, 132, 113}, 
 {186, 136, 113}, {182, 140, 113}, {174, 128, 113}, {166, 120, 113}, 
 {80, 84, 151}, {56, 73, 151}, {52, 68, 151}, {48, 68, 151}, 
 {48, 68, 151}, {44, 64, 151}, {44, 64, 141}, {44, 68, 141}, 
 {48, 73, 141}, {48, 73, 141}, {44, 73, 151}, {56, 85, 170}, 
 {68, 97, 179}, {72, 97, 188}, {72, 101, 188}, {72, 105, 198}, 
 {76, 101, 188}, {80, 109, 188}, {186, 141, 141}, {186, 141, 141}, 
 {194, 149, 151}, {202, 157, 151}, {206, 157, 151}, {202, 161, 151}, 
 {198, 153, 141}, {194, 149, 132}, {190, 148, 122}, {186, 136, 113}, 
 {182, 123, 104}, {182, 115, 104}, {166, 103, 75}, {113, 92, 65}, 
 {56, 60, 56}, {36, 52, 47}, {36, 52, 47}, {32, 44, 37}, 
 {56, 39, 28}, {146, 68, 66}, {174, 80, 66}, {182, 87, 66}, 
 {194, 107, 104}, {194, 111, 113}, {194, 115, 113}, {190, 116, 103}, 
 },



   /* no-name */
{{16, 9, 9}, {57, 50, 24}, {85, 76, 49}, {100, 96, 80}, 
 {121, 117, 88}, {138, 105, 74}, {141, 92, 73}, {144, 76, 66}, 
 {139, 70, 53}, {127, 60, 43}, {99, 44, 25}, {75, 35, 29}, 
 {61, 27, 18}, {41, 12, 9}, {19, 8, 8}, {13, 8, 8}, 
 {14, 8, 8}, {31, 12, 10}, {45, 34, 14}, {71, 49, 21}, 
 {89, 72, 38}, {103, 70, 29}, {107, 74, 31}, {107, 76, 31}, 
 {95, 75, 35}, {82, 65, 33}, {68, 40, 18}, {52, 24, 12}, 
 {41, 11, 7}, {16, 7, 7}, {11, 6, 6}, {8, 6, 6}, 
 {7, 6, 6}, {8, 6, 6}, {8, 6, 6}, {9, 7, 7}, 
 {11, 8, 8}, {13, 8, 12}, {15, 9, 13}, {19, 18, 20}, 
 {41, 32, 16}, {59, 53, 27}, {87, 74, 37}, {115, 89, 34}, 
 {129, 97, 34}, {137, 107, 44}, {136, 103, 35}, {136, 108, 36}, 
 {141, 109, 38}, {137, 109, 44}, {139, 113, 45}, {140, 111, 47}, 
 {140, 108, 50}, {155, 102, 67}, {148, 101, 76}, {151, 100, 78}, 
 {153, 105, 84}, {155, 104, 89}, {162, 113, 99}, {170, 123, 116}, 
 {172, 140, 123}, {168, 144, 123}, {168, 140, 121}, {169, 140, 125}, 
 {164, 141, 121}, {165, 135, 116}, {156, 123, 99}, {153, 117, 94}, 
 {141, 104, 88}, {132, 93, 72}, {99, 89, 54}, {90, 75, 43}, 
 {46, 45, 33}, {17, 26, 41}, {16, 20, 38}, {18, 25, 32}, 
 {47, 42, 23}, {65, 58, 32}, {92, 75, 43}, {116, 93, 36}, 
 {122, 96, 37}, {135, 97, 41}, {138, 87, 56}, {147, 91, 69}, 
 {141, 91, 68}, {140, 85, 58}, {140, 88, 69}, {143, 84, 66}, 
 {135, 76, 53}, {134, 76, 53}, {130, 71, 46}, {127, 70, 44}, 
 {126, 66, 43}, {128, 71, 43}, {127, 87, 31}, {126, 89, 30}, 
 {131, 93, 34}, {129, 97, 33}, {128, 91, 34}, {122, 87, 34}, 
 {112, 76, 30}, {96, 67, 28}, {79, 48, 24}, {56, 39, 21}, 
 {36, 32, 19}, {19, 17, 22}, {15, 8, 14}, {12, 8, 12}, 
 {10, 8, 8}, {10, 7, 7}, {9, 7, 8}, {8, 8, 8}, 
 {9, 8, 8}, {10, 8, 8}, {11, 8, 8}, {13, 8, 8}, 
 {16, 9, 8}, {36, 11, 8}, {49, 18, 14}, {69, 39, 21}, 
 {96, 59, 24}, {122, 75, 23}, {139, 97, 32}, {148, 109, 39}, 
 {148, 119, 52}, {148, 120, 58}, {148, 118, 60}, {148, 106, 81}, 
 {150, 108, 81}, {156, 110, 86}, {162, 117, 98}, {165, 127, 114}, 
 {162, 144, 123}, {145, 144, 133}, {140, 140, 125}, {139, 142, 126}, 
 {141, 161, 177}, {169, 153, 146}, {166, 152, 140}, {167, 148, 135}, 
 {171, 143, 125}, {167, 138, 120}, {167, 128, 110}, {163, 118, 96}, 
 {154, 109, 85}, {146, 100, 76}, {136, 80, 58}, {117, 58, 52}, 
 {84, 46, 39}, {62, 27, 19}, {47, 15, 8}, {25, 8, 8}, 
 {14, 8, 8}, {14, 8, 8}, {32, 11, 7}, {48, 17, 11}, 
 {70, 35, 17}, {88, 44, 27}, {118, 51, 33}, {119, 65, 38}, 
 {119, 65, 38}, {122, 66, 43}, {116, 69, 36}, {101, 76, 38}, 
 {90, 73, 39}, {68, 53, 25}, {43, 33, 21}, {17, 20, 31}, 
 {15, 17, 34}, {16, 16, 29}, {14, 10, 21}, {15, 8, 17}, 
 {38, 26, 16}, {67, 35, 14}, {91, 51, 19}, {106, 58, 20}, 
 {121, 72, 23}, {124, 83, 26}, {118, 86, 39}, {105, 91, 37}, 
 {90, 73, 40}, {63, 56, 33}, {26, 30, 32}, {16, 17, 32}, 
 {14, 15, 27}, {12, 8, 17}, {14, 8, 14}, {17, 8, 8}, 
 {40, 11, 7}, {53, 24, 15}, {75, 31, 18}, {103, 48, 18}, 
 {122, 55, 33}, {120, 71, 30}, {130, 88, 30}, {141, 101, 40}, 
 {139, 100, 51}, {139, 103, 70}, {120, 121, 97}, {118, 113, 124}, 
 {137, 138, 123}, {137, 140, 123}, {130, 131, 117}, {123, 123, 98}, 
 {128, 125, 108}, {125, 125, 93}, {151, 109, 83}, {169, 127, 69}, 
 {166, 129, 66}, {167, 131, 62}, {167, 130, 62}, {160, 123, 54}, 
 {155, 129, 57}, {152, 124, 55}, {153, 124, 53}, {154, 120, 46}, 
 {154, 119, 48}, {146, 116, 53}, {135, 108, 46}, {128, 107, 56}, 
 {104, 95, 65}, {92, 85, 52}, {93, 80, 46}, {81, 68, 35}, 
 {59, 51, 27}, {41, 32, 16}, {20, 11, 9}, {13, 8, 8}, 
 {12, 8, 8}, {12, 8, 8}, {13, 8, 8}, {13, 7, 7}, 
 {16, 8, 8}, {36, 9, 7}, {49, 15, 7}, {50, 15, 10}, 
 {54, 21, 14}, {63, 27, 16}, {67, 28, 16}, {70, 27, 20}, 
 {74, 26, 16}, {80, 31, 17}, {86, 30, 16}, {84, 37, 20}, 
 {98, 55, 20}, {101, 65, 25}, {111, 70, 23}, {121, 83, 29}, 
 {122, 96, 37}, {130, 105, 44}, {126, 103, 44}, {108, 94, 64}, 
 {109, 98, 68}, {106, 98, 69}, {106, 102, 74}, {116, 105, 71}, 
 },
   /* pillows */
{{75, 58, 47}, {58, 43, 43}, {43, 34, 28}, {28, 28, 22}, 
 {17, 17, 17}, {17, 17, 17}, {17, 17, 17}, {11, 17, 11}, 
 {11, 11, 11}, {11, 11, 11}, {11, 11, 11}, {11, 11, 11}, 
 {11, 11, 11}, {11, 17, 11}, {17, 17, 17}, {28, 17, 17}, 
 {43, 22, 17}, {60, 28, 22}, {77, 45, 28}, {94, 54, 32}, 
 {119, 68, 34}, {141, 90, 45}, {173, 101, 50}, {191, 106, 50}, 
 {203, 117, 67}, {186, 117, 78}, {175, 112, 67}, {141, 96, 62}, 
 {128, 79, 62}, {113, 73, 51}, {114, 66, 43}, {122, 77, 43}, 
 {151, 73, 22}, {160, 73, 28}, {138, 73, 22}, {117, 65, 26}, 
 {103, 60, 37}, {83, 49, 26}, {77, 49, 20}, {60, 28, 17}, 
 {45, 17, 11}, {26, 17, 11}, {17, 17, 17}, {17, 17, 17}, 
 {17, 17, 17}, {28, 22, 17}, {39, 22, 22}, {54, 34, 28}, 
 {60, 34, 22}, {81, 34, 22}, {81, 34, 17}, {87, 39, 17}, 
 {104, 45, 11}, {131, 50, 0}, {156, 61, 0}, {153, 67, 5}, 
 {136, 67, 5}, {125, 50, 11}, {107, 51, 17}, {107, 51, 17}, 
 {104, 50, 17}, {102, 51, 17}, {90, 62, 34}, {83, 54, 32}, 
 {92, 64, 30}, {96, 68, 39}, {96, 62, 45}, {104, 73, 56}, 
 {119, 79, 56}, {126, 81, 58}, {136, 96, 62}, {136, 96, 62}, 
 {136, 90, 56}, {117, 83, 54}, {102, 73, 51}, {100, 60, 49}, 
 {96, 60, 43}, {96, 62, 39}, {90, 62, 39}, {90, 62, 39}, 
 {86, 64, 41}, {86, 64, 47}, {81, 58, 52}, {71, 54, 49}, 
 {73, 62, 56}, {92, 75, 69}, {119, 79, 90}, {130, 102, 102}, 
 {145, 162, 173}, {175, 192, 197}, {210, 216, 227}, {243, 243, 243}, 
 {252, 246, 252}, {246, 246, 241}, {250, 250, 239}, {246, 246, 241}, 
 {242, 197, 157}, {201, 121, 88}, {169, 112, 96}, {141, 102, 90}, 
 {134, 84, 79}, {107, 68, 68}, {85, 51, 62}, {69, 49, 49}, 
 {54, 39, 39}, {45, 34, 28}, {34, 28, 22}, {34, 22, 17}, 
 {54, 22, 17}, {58, 20, 32}, {62, 35, 35}, {73, 51, 39}, 
 {79, 56, 39}, {81, 58, 47}, {92, 64, 47}, {96, 68, 51}, 
 {92, 75, 58}, {107, 85, 62}, {111, 83, 60}, {113, 85, 62}, 
 {122, 66, 77}, {134, 83, 83}, {121, 76, 93}, {119, 73, 84}, 
 {103, 70, 65}, {104, 73, 56}, {100, 66, 49}, {86, 64, 47}, 
 {73, 62, 45}, {73, 51, 39}, {56, 39, 28}, {28, 28, 28}, 
 {17, 22, 17}, {17, 17, 17}, {17, 17, 17}, {22, 28, 22}, 
 {28, 39, 45}, {28, 53, 78}, {64, 58, 52}, {75, 51, 51}, 
 {100, 60, 54}, {119, 68, 79}, {121, 76, 76}, {145, 62, 79}, 
 {130, 85, 73}, {147, 84, 34}, {179, 56, 56}, {158, 73, 22}, 
 {171, 73, 11}, {201, 5, 11}, {182, 49, 0}, {153, 61, 11}, 
 {153, 78, 11}, {167, 78, 5}, {150, 56, 11}, {134, 50, 5}, 
 {124, 22, 11}, {109, 17, 17}, {96, 34, 22}, {83, 45, 22}, 
 {83, 39, 17}, {73, 34, 22}, {62, 28, 22}, {54, 28, 17}, 
 {41, 35, 18}, {28, 22, 17}, {22, 17, 17}, {17, 17, 17}, 
 {11, 17, 11}, {11, 17, 11}, {11, 17, 11}, {17, 17, 17}, 
 {17, 17, 17}, {17, 17, 17}, {17, 17, 17}, {17, 17, 17}, 
 {11, 11, 11}, {11, 11, 11}, {5, 5, 5}, {5, 5, 5}, 
 {0, 5, 0}, {0, 11, 0}, {0, 11, 0}, {0, 11, 0}, 
 {0, 11, 0}, {5, 11, 5}, {5, 11, 5}, {11, 17, 5}, 
 {17, 11, 11}, {26, 11, 11}, {34, 17, 11}, {52, 17, 11}, 
 {56, 28, 22}, {60, 34, 34}, {62, 37, 37}, {75, 49, 43}, 
 {66, 54, 49}, {66, 54, 49}, {60, 54, 49}, {62, 51, 45}, 
 {66, 45, 39}, {69, 43, 43}, {58, 32, 47}, {45, 34, 39}, 
 {34, 28, 28}, {34, 34, 22}, {45, 39, 28}, {52, 47, 35}, 
 {71, 54, 43}, {79, 51, 56}, {96, 68, 79}, {119, 79, 90}, 
 {149, 115, 109}, {164, 169, 175}, {185, 191, 196}, {222, 228, 233}, 
 {241, 241, 241}, {254, 214, 186}, {240, 206, 139}, {203, 128, 78}, 
 {186, 112, 78}, {173, 90, 67}, {141, 84, 51}, {124, 79, 56}, 
 {113, 79, 62}, {86, 81, 75}, {86, 86, 118}, {134, 134, 156}, 
 {167, 139, 162}, {197, 140, 135}, {173, 127, 116}, {155, 133, 104}, 
 {141, 102, 79}, {156, 90, 67}, {169, 106, 50}, {164, 101, 28}, 
 {151, 73, 16}, {116, 45, 17}, {88, 34, 17}, {77, 28, 11}, 
 {66, 17, 17}, {36, 5, 5}, {22, 11, 0}, {17, 20, 0}, 
 {17, 11, 5}, {17, 11, 0}, {11, 11, 11}, {11, 11, 11}, 
 {11, 11, 11}, {11, 11, 11}, {5, 11, 5}, {5, 17, 5}, 
 {5, 17, 5}, {5, 11, 5}, {11, 11, 11}, {17, 11, 11}, 
 },
   /* mauve-splat */
{{22, 22, 22}, {22, 22, 22}, {22, 17, 20}, {22, 11, 15}, 
 {17, 5, 11}, {11, 5, 11}, {11, 5, 11}, {11, 5, 11}, 
 {11, 5, 11}, {11, 5, 11}, {11, 5, 11}, {11, 5, 15}, 
 {11, 11, 15}, {11, 11, 15}, {11, 11, 17}, {17, 11, 17}, 
 {17, 17, 17}, {17, 17, 17}, {17, 17, 17}, {17, 11, 11}, 
 {17, 11, 11}, {17, 11, 11}, {17, 5, 11}, {11, 5, 9}, 
 {5, 5, 5}, {5, 5, 5}, {5, 5, 5}, {5, 5, 9}, 
 {5, 5, 11}, {5, 5, 15}, {11, 5, 17}, {17, 5, 17}, 
 {17, 5, 15}, {17, 5, 15}, {11, 5, 11}, {11, 5, 11}, 
 {11, 5, 11}, {11, 5, 11}, {11, 5, 15}, {11, 11, 17}, 
 {11, 11, 17}, {17, 11, 17}, {17, 11, 20}, {17, 5, 22}, 
 {17, 11, 20}, {22, 11, 20}, {22, 17, 22}, {22, 22, 22}, 
 {22, 28, 17}, {22, 28, 22}, {22, 22, 22}, {22, 22, 22}, 
 {22, 22, 22}, {22, 22, 22}, {22, 22, 22}, {22, 17, 22}, 
 {22, 17, 20}, {22, 17, 17}, {22, 17, 17}, {28, 17, 17}, 
 {28, 17, 17}, {22, 17, 17}, {22, 11, 17}, {22, 11, 17}, 
 {17, 17, 17}, {17, 17, 22}, {17, 11, 22}, {11, 11, 17}, 
 {11, 11, 17}, {11, 11, 17}, {5, 11, 15}, {5, 5, 11}, 
 {5, 0, 11}, {5, 0, 9}, {5, 5, 5}, {11, 5, 5}, 
 {17, 5, 5}, {22, 11, 11}, {22, 17, 17}, {28, 22, 22}, 
 {28, 22, 22}, {28, 22, 22}, {28, 22, 34}, {28, 22, 37}, 
 {22, 17, 32}, {17, 11, 30}, {11, 11, 24}, {11, 11, 20}, 
 {11, 11, 20}, {11, 5, 26}, {11, 5, 20}, {11, 5, 20}, 
 {11, 5, 20}, {11, 5, 17}, {11, 5, 17}, {17, 5, 17}, 
 {17, 5, 17}, {17, 5, 20}, {17, 5, 20}, {17, 5, 20}, 
 {22, 11, 26}, {17, 11, 32}, {26, 20, 39}, {28, 28, 43}, 
 {77, 66, 72}, {96, 122, 101}, {174, 172, 129}, {84, 139, 146}, 
 {240, 195, 184}, {191, 112, 78}, {159, 90, 73}, {210, 73, 44}, 
 {120, 94, 66}, {107, 90, 90}, {84, 88, 90}, {118, 90, 67}, 
 {85, 96, 107}, {66, 100, 117}, {75, 75, 64}, {54, 80, 74}, 
 {54, 66, 54}, {39, 45, 17}, {28, 28, 28}, {32, 32, 32}, 
 {45, 39, 34}, {83, 37, 37}, {131, 28, 11}, {213, 22, 0}, 
 {218, 16, 5}, {148, 27, 0}, {75, 16, 22}, {43, 22, 17}, 
 {28, 22, 11}, {22, 22, 5}, {32, 17, 0}, {28, 37, 0}, 
 {17, 17, 5}, {17, 22, 11}, {17, 17, 11}, {17, 11, 11}, 
 {17, 11, 11}, {17, 11, 11}, {11, 11, 11}, {11, 5, 11}, 
 {11, 5, 11}, {11, 5, 11}, {17, 5, 11}, {17, 5, 11}, 
 {17, 5, 11}, {11, 0, 11}, {11, 0, 11}, {11, 0, 11}, 
 {11, 0, 11}, {11, 5, 11}, {11, 5, 11}, {11, 5, 11}, 
 {11, 5, 11}, {11, 5, 11}, {11, 11, 11}, {11, 11, 15}, 
 {11, 5, 17}, {11, 5, 17}, {17, 5, 17}, {17, 5, 17}, 
 {17, 11, 17}, {17, 11, 17}, {17, 11, 17}, {17, 11, 17}, 
 {17, 11, 15}, {17, 11, 11}, {17, 11, 5}, {11, 11, 0}, 
 {17, 5, 0}, {17, 5, 5}, {17, 5, 5}, {17, 5, 11}, 
 {17, 5, 11}, {17, 5, 11}, {17, 5, 11}, {17, 0, 11}, 
 {17, 0, 11}, {17, 0, 5}, {11, 5, 5}, {11, 5, 5}, 
 {5, 5, 5}, {0, 0, 5}, {5, 5, 5}, {11, 5, 5}, 
 {11, 5, 5}, {11, 11, 11}, {11, 11, 11}, {11, 11, 11}, 
 {11, 5, 11}, {11, 5, 11}, {11, 5, 11}, {11, 5, 11}, 
 {11, 5, 11}, {5, 5, 15}, {5, 0, 15}, {5, 0, 17}, 
 {11, 0, 17}, {11, 0, 15}, {11, 0, 11}, {11, 0, 11}, 
 {11, 0, 11}, {11, 0, 9}, {11, 0, 5}, {11, 0, 0}, 
 {11, 0, 0}, {11, 0, 5}, {11, 0, 5}, {11, 0, 5}, 
 {11, 5, 5}, {17, 5, 5}, {17, 5, 5}, {17, 11, 11}, 
 {17, 11, 11}, {17, 11, 11}, {17, 11, 11}, {20, 11, 11}, 
 {22, 17, 11}, {22, 17, 17}, {22, 17, 17}, {22, 17, 17}, 
 {17, 11, 17}, {17, 11, 17}, {17, 11, 17}, {17, 11, 17}, 
 {17, 11, 17}, {17, 11, 17}, {17, 11, 17}, {17, 11, 17}, 
 {17, 11, 17}, {17, 11, 17}, {17, 11, 17}, {17, 11, 20}, 
 {17, 11, 22}, {17, 17, 26}, {17, 22, 30}, {22, 22, 32}, 
 {28, 17, 28}, {28, 17, 22}, {34, 17, 26}, {37, 26, 20}, 
 {45, 28, 22}, {54, 49, 26}, {100, 51, 51}, {77, 56, 50}, 
 {77, 58, 58}, {50, 78, 90}, {49, 54, 60}, {71, 50, 56}, 
 {62, 58, 52}, {60, 66, 22}, {79, 68, 45}, {45, 34, 37}, 
 },
   /* facial-treescape 6 */
{{39, 34, 26}, {52, 37, 56}, {37, 60, 58}, {52, 73, 52}, 
 {73, 85, 51}, {110, 87, 59}, {164, 147, 127}, {133, 105, 88}, 
 {166, 134, 117}, {122, 133, 142}, {137, 125, 91}, {150, 129, 56}, 
 {152, 101, 0}, {135, 73, 39}, {62, 71, 17}, {39, 86, 17}, 
 {34, 62, 22}, {37, 77, 43}, {39, 62, 34}, {39, 79, 28}, 
 {45, 92, 51}, {54, 79, 49}, {52, 64, 58}, {49, 69, 49}, 
 {39, 64, 45}, {47, 62, 30}, {39, 62, 17}, {39, 49, 11}, 
 {45, 45, 17}, {39, 49, 22}, {34, 54, 28}, {32, 55, 35}, 
 {39, 56, 39}, {45, 51, 34}, {45, 60, 34}, {34, 49, 22}, 
 {28, 39, 17}, {20, 35, 15}, {22, 34, 11}, {17, 39, 11}, 
 {22, 28, 11}, {17, 34, 11}, {17, 39, 17}, {11, 28, 11}, 
 {11, 28, 5}, {11, 28, 11}, {17, 28, 11}, {22, 22, 11}, 
 {22, 17, 5}, {22, 11, 0}, {22, 11, 0}, {22, 17, 0}, 
 {22, 17, 0}, {35, 20, 9}, {60, 22, 17}, {82, 39, 16}, 
 {81, 49, 20}, {132, 80, 41}, {135, 123, 90}, {178, 166, 112}, 
 {197, 203, 169}, {205, 233, 222}, {178, 218, 212}, {107, 158, 175}, 
 {50, 96, 132}, {49, 86, 103}, {37, 55, 55}, {34, 45, 39}, 
 {34, 39, 34}, {28, 28, 34}, {34, 22, 22}, {28, 17, 17}, 
 {22, 22, 17}, {22, 22, 17}, {22, 17, 17}, {17, 17, 11}, 
 {15, 20, 9}, {17, 22, 5}, {22, 26, 0}, {22, 28, 0}, 
 {34, 32, 0}, {28, 32, 5}, {34, 28, 5}, {34, 28, 0}, 
 {28, 28, 0}, {34, 22, 11}, {34, 22, 11}, {28, 17, 17}, 
 {28, 22, 11}, {28, 22, 11}, {22, 22, 11}, {22, 28, 11}, 
 {22, 28, 17}, {22, 28, 17}, {17, 22, 22}, {17, 17, 17}, 
 {22, 17, 11}, {22, 17, 11}, {22, 17, 11}, {22, 17, 11}, 
 {22, 11, 11}, {17, 11, 11}, {17, 11, 11}, {17, 11, 11}, 
 {15, 9, 9}, {22, 5, 5}, {22, 11, 5}, {22, 11, 5}, 
 {22, 17, 5}, {22, 22, 5}, {17, 22, 5}, {17, 28, 11}, 
 {17, 28, 11}, {17, 26, 11}, {11, 22, 11}, {11, 22, 11}, 
 {11, 17, 5}, {11, 17, 5}, {5, 17, 5}, {11, 17, 0}, 
 {11, 17, 5}, {17, 17, 5}, {17, 17, 11}, {17, 22, 17}, 
 {22, 28, 22}, {28, 28, 37}, {22, 39, 64}, {51, 83, 73}, 
 {85, 117, 74}, {122, 176, 142}, {193, 222, 227}, {220, 231, 237}, 
 {215, 226, 232}, {250, 216, 154}, {244, 205, 109}, {195, 114, 69}, 
 {149, 114, 58}, {93, 103, 53}, {62, 71, 34}, {51, 54, 22}, 
 {39, 34, 17}, {32, 26, 20}, {17, 22, 11}, {11, 11, 11}, 
 {11, 5, 5}, {11, 5, 5}, {11, 5, 5}, {11, 11, 5}, 
 {11, 11, 0}, {11, 11, 5}, {17, 11, 5}, {17, 11, 5}, 
 {17, 17, 5}, {17, 22, 5}, {11, 22, 0}, {11, 17, 0}, 
 {11, 11, 0}, {11, 11, 0}, {11, 5, 0}, {17, 5, 0}, 
 {20, 5, 0}, {17, 5, 0}, {17, 5, 0}, {17, 0, 0}, 
 {17, 0, 0}, {11, 0, 0}, {11, 5, 0}, {11, 5, 0}, 
 {11, 5, 0}, {0, 0, 0}, {11, 5, 0}, {5, 5, 0}, 
 {5, 5, 0}, {5, 11, 0}, {5, 11, 5}, {11, 11, 5}, 
 {17, 17, 5}, {17, 22, 0}, {22, 28, 0}, {22, 37, 5}, 
 {26, 37, 9}, {28, 43, 15}, {26, 57, 29}, {43, 68, 43}, 
 {28, 64, 43}, {28, 69, 34}, {32, 80, 35}, {41, 77, 47}, 
 {56, 96, 68}, {73, 110, 76}, {45, 111, 79}, {82, 105, 94}, 
 {62, 114, 116}, {67, 147, 147}, {78, 175, 197}, {180, 220, 220}, 
 {216, 222, 222}, {250, 210, 131}, {180, 123, 95}, {121, 87, 59}, 
 {73, 68, 39}, {58, 72, 44}, {51, 66, 34}, {37, 49, 32}, 
 {34, 39, 22}, {28, 34, 17}, {28, 22, 11}, {22, 17, 11}, 
 {17, 11, 5}, {17, 11, 5}, {17, 11, 0}, {11, 11, 0}, 
 {11, 11, 0}, {11, 11, 0}, {17, 17, 0}, {22, 22, 5}, 
 {26, 26, 9}, {28, 34, 11}, {28, 34, 11}, {26, 37, 15}, 
 {28, 39, 17}, {28, 34, 22}, {28, 32, 22}, {32, 32, 20}, 
 {34, 34, 17}, {34, 37, 17}, {39, 43, 11}, {37, 43, 15}, 
 {34, 39, 17}, {34, 37, 11}, {28, 32, 11}, {22, 28, 11}, 
 {28, 28, 11}, {26, 26, 9}, {34, 34, 11}, {45, 28, 11}, 
 {49, 37, 15}, {54, 39, 22}, {69, 39, 28}, {56, 39, 28}, 
 {41, 35, 26}, {34, 34, 28}, {28, 34, 28}, {26, 34, 22}, 
 {28, 37, 22}, {34, 39, 22}, {34, 45, 22}, {34, 39, 22}, 
 {34, 39, 17}, {34, 37, 17}, {45, 39, 11}, {45, 39, 20}, 
 {45, 39, 22}, {51, 39, 17}, {49, 43, 20}, {51, 57, 36}, 
 },
   /* fasion-bug */
{{24, 19, 26}, {45, 31, 41}, {67, 45, 51}, {122, 31, 44}, 
 {144, 31, 39}, {145, 29, 37}, {146, 30, 35}, {150, 30, 36}, 
 {144, 30, 36}, {133, 33, 35}, {69, 45, 44}, {47, 34, 40}, 
 {35, 29, 36}, {31, 25, 30}, {27, 23, 27}, {26, 21, 26}, 
 {27, 22, 28}, {30, 24, 33}, {32, 28, 34}, {37, 34, 41}, 
 {48, 43, 47}, {59, 53, 56}, {83, 77, 73}, {95, 77, 69}, 
 {123, 90, 77}, {130, 109, 88}, {124, 116, 98}, {148, 142, 112}, 
 {176, 164, 120}, {201, 192, 153}, {214, 208, 194}, {228, 222, 206}, 
 {230, 224, 205}, {230, 225, 201}, {230, 221, 202}, {229, 213, 190}, 
 {219, 190, 158}, {176, 152, 111}, {141, 109, 83}, {152, 73, 69}, 
 {156, 58, 53}, {146, 125, 94}, {182, 149, 123}, {218, 205, 144}, 
 {229, 216, 191}, {230, 222, 205}, {230, 224, 218}, {230, 226, 219}, 
 {228, 226, 220}, {230, 227, 221}, {232, 228, 217}, {236, 232, 204}, 
 {233, 231, 191}, {230, 222, 199}, {229, 219, 200}, {217, 212, 198}, 
 {221, 209, 181}, {199, 168, 145}, {156, 127, 125}, {92, 74, 81}, 
 {69, 50, 51}, {55, 40, 50}, {41, 34, 40}, {29, 29, 34}, 
 {23, 24, 32}, {21, 24, 29}, {22, 21, 28}, {24, 20, 27}, 
 {30, 21, 29}, {37, 25, 29}, {45, 25, 32}, {56, 30, 34}, 
 {108, 29, 38}, {142, 30, 39}, {149, 34, 37}, {150, 32, 36}, 
 {148, 30, 36}, {146, 29, 36}, {142, 29, 35}, {136, 31, 36}, 
 {72, 50, 53}, {63, 47, 50}, {59, 48, 48}, {57, 45, 49}, 
 {63, 48, 51}, {78, 55, 58}, {92, 80, 76}, {126, 112, 95}, 
 {167, 147, 117}, {206, 160, 142}, {204, 195, 168}, {214, 206, 190}, 
 {172, 155, 142}, {146, 130, 123}, {115, 95, 88}, {90, 74, 81}, 
 {61, 54, 56}, {55, 40, 52}, {49, 40, 43}, {46, 41, 45}, 
 {44, 42, 46}, {46, 42, 46}, {46, 38, 40}, {42, 41, 37}, 
 {37, 33, 33}, {34, 27, 27}, {31, 23, 28}, {29, 21, 23}, 
 {25, 18, 23}, {24, 13, 21}, {22, 14, 21}, {20, 15, 21}, 
 {19, 16, 21}, {19, 17, 21}, {20, 16, 23}, {22, 17, 24}, 
 {25, 19, 25}, {28, 19, 27}, {31, 21, 29}, {44, 24, 36}, 
 {52, 33, 41}, {66, 40, 44}, {122, 29, 33}, {142, 28, 35}, 
 {143, 28, 35}, {140, 31, 34}, {119, 34, 33}, {68, 40, 40}, 
 {43, 30, 33}, {31, 19, 27}, {24, 16, 20}, {18, 14, 17}, 
 {16, 12, 16}, {13, 12, 16}, {12, 11, 17}, {13, 11, 16}, 
 {15, 12, 16}, {18, 14, 18}, {22, 20, 24}, {27, 25, 29}, 
 {37, 33, 35}, {52, 39, 43}, {69, 45, 48}, {127, 30, 36}, 
 {142, 29, 36}, {148, 30, 36}, {152, 29, 38}, {156, 29, 39}, 
 {156, 28, 35}, {154, 28, 36}, {148, 29, 32}, {145, 33, 33}, 
 {138, 32, 34}, {74, 48, 52}, {59, 40, 50}, {48, 34, 44}, 
 {44, 34, 40}, {38, 33, 36}, {31, 31, 36}, {33, 28, 34}, 
 {41, 26, 31}, {46, 27, 37}, {58, 37, 41}, {116, 28, 35}, 
 {139, 27, 33}, {144, 27, 35}, {149, 29, 39}, {153, 31, 38}, 
 {156, 31, 39}, {157, 33, 39}, {154, 36, 40}, {151, 34, 42}, 
 {145, 30, 37}, {136, 27, 35}, {95, 24, 29}, {49, 32, 25}, 
 {32, 24, 25}, {25, 20, 23}, {20, 17, 24}, {18, 16, 23}, 
 {17, 15, 21}, {18, 16, 22}, {16, 15, 24}, {20, 16, 27}, 
 {18, 19, 35}, {32, 25, 35}, {42, 36, 38}, {46, 42, 41}, 
 {52, 53, 45}, {67, 68, 46}, {98, 75, 65}, {101, 69, 63}, 
 {146, 34, 48}, {150, 33, 43}, {157, 33, 41}, {160, 30, 39}, 
 {160, 32, 39}, {162, 29, 37}, {161, 35, 40}, {171, 37, 38}, 
 {157, 37, 40}, {151, 36, 40}, {144, 32, 39}, {138, 32, 38}, 
 {79, 44, 48}, {61, 41, 46}, {55, 36, 39}, {47, 32, 42}, 
 {35, 28, 35}, {27, 24, 29}, {27, 21, 27}, {22, 20, 26}, 
 {19, 20, 24}, {16, 18, 24}, {15, 16, 22}, {15, 16, 23}, 
 {15, 19, 22}, {16, 16, 22}, {17, 15, 22}, {14, 16, 21}, 
 {12, 15, 20}, {15, 13, 20}, {18, 14, 21}, {19, 16, 21}, 
 {22, 16, 21}, {25, 20, 21}, {24, 22, 25}, {25, 24, 29}, 
 {29, 25, 31}, {32, 27, 32}, {31, 27, 33}, {31, 25, 29}, 
 {27, 21, 26}, {28, 19, 26}, {26, 16, 24}, {25, 17, 23}, 
 {23, 14, 23}, {19, 15, 22}, {16, 14, 19}, {14, 13, 18}, 
 {13, 11, 18}, {15, 12, 18}, {16, 14, 17}, {15, 15, 19}, 
 {16, 16, 20}, {16, 16, 21}, {18, 15, 23}, {20, 16, 23}, 
 {23, 18, 26}, {24, 19, 33}, {29, 18, 30}, {35, 24, 32}, 
 {43, 28, 34}, {55, 32, 37}, {69, 42, 43}, {131, 27, 32}, 
 },
   /* leafy-face */
{{42, 37, 33}, {31, 23, 25}, {23, 19, 22}, {20, 20, 24}, 
 {24, 23, 25}, {31, 25, 25}, {47, 37, 39}, {64, 40, 39}, 
 {81, 51, 51}, {74, 59, 57}, {73, 69, 63}, {77, 81, 72}, 
 {95, 98, 94}, {200, 168, 134}, {215, 188, 153}, {223, 209, 177}, 
 {238, 225, 207}, {237, 227, 215}, {238, 227, 201}, {225, 195, 162}, 
 {210, 182, 147}, {191, 163, 133}, {91, 98, 97}, {75, 74, 79}, 
 {70, 70, 67}, {73, 69, 59}, {83, 76, 55}, {84, 74, 55}, 
 {107, 79, 73}, {197, 132, 96}, {218, 159, 116}, {222, 174, 130}, 
 {225, 182, 134}, {222, 182, 137}, {220, 173, 131}, {215, 164, 114}, 
 {163, 109, 88}, {103, 83, 68}, {90, 83, 61}, {145, 104, 88}, 
 {208, 163, 121}, {209, 174, 138}, {213, 176, 151}, {213, 178, 151}, 
 {211, 183, 143}, {206, 174, 133}, {197, 154, 120}, {89, 91, 91}, 
 {72, 77, 78}, {66, 71, 69}, {64, 66, 63}, {62, 56, 59}, 
 {60, 59, 58}, {58, 58, 55}, {56, 54, 54}, {50, 51, 48}, 
 {60, 47, 46}, {65, 50, 46}, {65, 50, 46}, {67, 52, 49}, 
 {66, 59, 57}, {65, 67, 59}, {68, 73, 68}, {78, 84, 80}, 
 {130, 120, 108}, {206, 162, 135}, {217, 172, 144}, {223, 184, 152}, 
 {224, 188, 154}, {226, 188, 154}, {226, 187, 152}, {225, 190, 148}, 
 {226, 195, 144}, {224, 195, 146}, {220, 190, 147}, {223, 190, 153}, 
 {226, 193, 152}, {227, 192, 152}, {223, 187, 152}, {223, 187, 147}, 
 {227, 184, 143}, {223, 184, 141}, {221, 174, 135}, {204, 162, 130}, 
 {130, 108, 102}, {82, 82, 75}, {74, 77, 63}, {70, 76, 63}, 
 {68, 71, 63}, {68, 71, 63}, {66, 72, 63}, {71, 76, 66}, 
 {78, 89, 77}, {138, 122, 109}, {205, 166, 137}, {210, 179, 149}, 
 {213, 182, 152}, {222, 189, 155}, {226, 199, 156}, {237, 210, 172}, 
 {240, 227, 199}, {238, 229, 214}, {238, 231, 222}, {239, 232, 227}, 
 {235, 230, 227}, {230, 228, 223}, {220, 217, 207}, {203, 193, 176}, 
 {206, 166, 149}, {194, 148, 118}, {87, 98, 78}, {72, 89, 71}, 
 {82, 86, 69}, {139, 116, 93}, {208, 167, 123}, {219, 170, 135}, 
 {219, 179, 138}, {218, 182, 149}, {214, 176, 151}, {212, 174, 147}, 
 {198, 160, 136}, {98, 97, 97}, {78, 76, 82}, {68, 71, 71}, 
 {60, 66, 68}, {65, 67, 69}, {67, 72, 71}, {82, 87, 80}, 
 {168, 130, 113}, {208, 164, 139}, {209, 167, 138}, {189, 141, 129}, 
 {99, 86, 90}, {80, 75, 64}, {82, 71, 63}, {83, 77, 68}, 
 {98, 94, 96}, {202, 155, 123}, {219, 170, 130}, {212, 164, 117}, 
 {142, 106, 92}, {81, 81, 74}, {72, 73, 68}, {71, 73, 67}, 
 {73, 79, 69}, {83, 99, 85}, {164, 149, 121}, {207, 166, 140}, 
 {213, 177, 153}, {224, 193, 170}, {222, 210, 207}, {223, 222, 215}, 
 {232, 231, 225}, {233, 227, 226}, {226, 226, 223}, {218, 226, 216}, 
 {222, 222, 214}, {222, 213, 199}, {225, 191, 157}, {213, 184, 148}, 
 {209, 176, 138}, {199, 165, 128}, {96, 96, 95}, {75, 77, 69}, 
 {70, 67, 64}, {68, 61, 60}, {68, 62, 59}, {70, 63, 58}, 
 {74, 72, 63}, {82, 88, 77}, {175, 142, 113}, {217, 171, 125}, 
 {221, 170, 130}, {207, 159, 122}, {112, 86, 73}, {83, 64, 60}, 
 {51, 41, 43}, {29, 27, 31}, {21, 18, 24}, {13, 11, 15}, 
 {19, 16, 17}, {22, 17, 23}, {30, 24, 29}, {46, 37, 41}, 
 {44, 41, 44}, {43, 46, 38}, {32, 32, 27}, {25, 26, 28}, 
 {28, 22, 25}, {32, 30, 32}, {41, 41, 42}, {43, 41, 47}, 
 {47, 50, 49}, {55, 55, 53}, {58, 63, 60}, {61, 68, 58}, 
 {64, 70, 57}, {67, 74, 62}, {75, 76, 65}, {88, 89, 83}, 
 {176, 145, 118}, {206, 166, 144}, {224, 190, 168}, {238, 223, 210}, 
 {233, 230, 225}, {233, 229, 224}, {227, 218, 210}, {220, 188, 162}, 
 {204, 167, 151}, {150, 142, 132}, {85, 97, 95}, {75, 78, 72}, 
 {70, 70, 65}, {67, 64, 57}, {63, 61, 52}, {57, 55, 49}, 
 {62, 56, 46}, {60, 59, 46}, {61, 59, 52}, {64, 61, 58}, 
 {64, 68, 57}, {62, 70, 54}, {62, 67, 54}, {63, 67, 55}, 
 {64, 64, 55}, {66, 65, 51}, {67, 65, 50}, {69, 65, 51}, 
 {69, 65, 54}, {76, 66, 55}, {84, 65, 54}, {121, 72, 64}, 
 {197, 132, 96}, {217, 166, 119}, {222, 178, 124}, {225, 188, 129}, 
 {224, 188, 138}, {222, 184, 139}, {209, 178, 141}, {206, 171, 134}, 
 {162, 144, 108}, {78, 90, 81}, {67, 76, 72}, {72, 72, 72}, 
 {83, 70, 82}, {114, 112, 105}, {203, 167, 143}, {213, 184, 157}, 
 {219, 210, 199}, {221, 220, 210}, {218, 213, 200}, {183, 173, 165}, 
 {107, 106, 103}, {77, 83, 78}, {74, 83, 75}, {82, 95, 83}, 
 },
   /* mouldy-sun */
{{17, 11, 11}, {11, 11, 11}, {11, 11, 5}, {11, 17, 0}, 
 {11, 17, 0}, {17, 22, 0}, {22, 28, 0}, {34, 28, 11}, 
 {51, 39, 22}, {69, 64, 24}, {84, 105, 50}, {129, 135, 73}, 
 {189, 166, 78}, {195, 194, 78}, {207, 189, 83}, {208, 180, 95}, 
 {214, 203, 90}, {214, 197, 90}, {207, 179, 105}, {191, 173, 92}, 
 {191, 163, 90}, {180, 158, 62}, {177, 149, 45}, {180, 146, 39}, 
 {174, 145, 55}, {159, 130, 65}, {126, 109, 60}, {144, 104, 34}, 
 {148, 104, 45}, {153, 115, 48}, {146, 93, 31}, {154, 96, 17}, 
 {163, 115, 25}, {180, 123, 16}, {183, 138, 28}, {173, 129, 45}, 
 {210, 135, 61}, {225, 146, 67}, {197, 174, 123}, {148, 193, 193}, 
 {191, 191, 180}, {204, 192, 170}, {213, 196, 139}, {203, 208, 135}, 
 {165, 185, 156}, {113, 124, 90}, {67, 113, 50}, {77, 84, 26}, 
 {60, 68, 20}, {66, 64, 20}, {83, 69, 20}, {120, 82, 20}, 
 {159, 104, 11}, {172, 126, 39}, {186, 134, 45}, {208, 146, 39}, 
 {242, 146, 44}, {206, 148, 39}, {164, 121, 45}, {145, 95, 45}, 
 {128, 84, 34}, {89, 39, 22}, {58, 28, 17}, {43, 22, 11}, 
 {28, 17, 11}, {22, 11, 11}, {22, 11, 11}, {22, 11, 11}, 
 {17, 11, 11}, {11, 5, 26}, {11, 11, 11}, {17, 11, 17}, 
 {17, 17, 11}, {22, 22, 5}, {17, 11, 0}, {22, 22, 0}, 
 {17, 22, 0}, {17, 11, 0}, {28, 17, 0}, {37, 11, 0}, 
 {49, 22, 5}, {62, 39, 0}, {71, 58, 9}, {119, 73, 0}, 
 {164, 72, 28}, {186, 117, 22}, {203, 157, 33}, {242, 174, 50}, 
 {248, 208, 89}, {244, 239, 154}, {254, 248, 169}, {237, 220, 135}, 
 {240, 206, 88}, {231, 186, 72}, {203, 174, 50}, {178, 146, 39}, 
 {139, 127, 16}, {116, 101, 11}, {94, 81, 5}, {51, 58, 0}, 
 {22, 32, 0}, {17, 26, 0}, {11, 17, 0}, {5, 17, 0}, 
 {5, 5, 5}, {0, 0, 0}, {5, 0, 0}, {11, 5, 0}, 
 {11, 5, 5}, {11, 5, 5}, {17, 5, 5}, {17, 5, 5}, 
 {22, 5, 5}, {22, 5, 5}, {17, 5, 5}, {17, 5, 5}, 
 {17, 5, 5}, {11, 11, 0}, {11, 11, 0}, {11, 5, 5}, 
 {11, 5, 5}, {17, 5, 0}, {17, 5, 0}, {17, 5, 0}, 
 {17, 5, 0}, {22, 5, 5}, {17, 0, 0}, {17, 0, 0}, 
 {17, 0, 0}, {17, 5, 5}, {17, 17, 11}, {11, 17, 9}, 
 {11, 22, 0}, {11, 28, 0}, {17, 39, 17}, {45, 69, 0}, 
 {62, 86, 25}, {84, 98, 11}, {107, 99, 17}, {119, 93, 17}, 
 {122, 99, 20}, {134, 101, 28}, {141, 112, 22}, {150, 110, 33}, 
 {130, 113, 39}, {128, 111, 75}, {133, 132, 87}, {165, 142, 120}, 
 {197, 163, 135}, {220, 202, 146}, {225, 225, 180}, {229, 229, 190}, 
 {250, 239, 199}, {244, 233, 188}, {242, 237, 163}, {218, 200, 127}, 
 {225, 202, 118}, {224, 201, 105}, {227, 205, 91}, {225, 208, 78}, 
 {237, 220, 44}, {237, 197, 50}, {248, 191, 67}, {225, 174, 89}, 
 {181, 146, 85}, {144, 138, 76}, {124, 124, 51}, {108, 119, 43}, 
 {96, 99, 42}, {73, 73, 28}, {71, 52, 20}, {79, 50, 22}, 
 {79, 39, 22}, {93, 50, 56}, {154, 90, 84}, {158, 107, 67}, 
 {162, 127, 66}, {197, 163, 50}, {210, 176, 47}, {203, 168, 33}, 
 {180, 139, 0}, {152, 118, 5}, {125, 80, 0}, {96, 73, 11}, 
 {69, 45, 11}, {54, 28, 22}, {39, 34, 22}, {34, 34, 22}, 
 {28, 28, 17}, {28, 28, 11}, {39, 22, 5}, {34, 22, 0}, 
 {28, 24, 0}, {22, 28, 5}, {28, 34, 20}, {51, 52, 30}, 
 {66, 54, 24}, {94, 60, 46}, {126, 86, 47}, {132, 118, 82}, 
 {158, 140, 90}, {208, 168, 101}, {214, 197, 140}, {233, 227, 188}, 
 {252, 240, 201}, {252, 252, 212}, {252, 246, 201}, {250, 244, 176}, 
 {254, 242, 152}, {254, 220, 95}, {248, 208, 84}, {231, 174, 44}, 
 {203, 157, 28}, {194, 126, 0}, {191, 123, 5}, {190, 112, 5}, 
 {175, 118, 16}, {138, 116, 0}, {107, 99, 0}, {99, 96, 14}, 
 {91, 89, 20}, {54, 64, 9}, {39, 28, 17}, {28, 17, 17}, 
 {17, 11, 11}, {11, 5, 5}, {11, 5, 5}, {11, 5, 5}, 
 {11, 5, 5}, {11, 5, 5}, {5, 5, 5}, {5, 0, 0}, 
 {5, 0, 0}, {11, 0, 0}, {11, 5, 0}, {11, 5, 5}, 
 {17, 5, 5}, {17, 11, 17}, {17, 17, 17}, {28, 33, 33}, 
 {57, 63, 46}, {77, 71, 34}, {91, 75, 43}, {124, 88, 33}, 
 {155, 112, 11}, {186, 135, 22}, {203, 146, 39}, {231, 157, 39}, 
 {225, 168, 50}, {237, 203, 90}, {239, 233, 148}, {252, 235, 189}, 
 {248, 242, 208}, {229, 218, 224}, {244, 244, 210}, {237, 208, 169}, 
 },
   /* sunny-harvest */
{{0, 0, 0}, {34, 4, 13}, {71, 19, 23}, {105, 20, 32}, 
 {107, 51, 32}, {102, 30, 34}, {70, 23, 27}, {52, 20, 20}, 
 {18, 6, 8}, {4, 0, 1}, {0, 0, 0}, {0, 0, 0}, 
 {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, 
 {8, 5, 6}, {16, 12, 21}, {58, 29, 30}, {89, 49, 39}, 
 {116, 94, 73}, {149, 126, 100}, {193, 171, 144}, {208, 199, 181}, 
 {213, 202, 184}, {204, 203, 195}, {227, 209, 188}, {228, 210, 184}, 
 {219, 200, 171}, {216, 190, 148}, {212, 182, 123}, {211, 171, 108}, 
 {189, 137, 88}, {173, 125, 72}, {167, 123, 82}, {157, 127, 103}, 
 {184, 159, 137}, {204, 180, 162}, {205, 185, 156}, {206, 182, 146}, 
 {200, 168, 133}, {170, 131, 87}, {163, 112, 64}, {145, 103, 68}, 
 {132, 98, 68}, {123, 102, 49}, {93, 65, 39}, {84, 57, 33}, 
 {86, 64, 30}, {118, 81, 44}, {137, 96, 57}, {148, 118, 62}, 
 {159, 116, 64}, {176, 136, 77}, {195, 143, 90}, {206, 164, 112}, 
 {186, 160, 114}, {169, 130, 85}, {151, 114, 89}, {121, 104, 81}, 
 {112, 93, 68}, {102, 77, 53}, {86, 52, 33}, {76, 49, 28}, 
 {82, 63, 30}, {92, 79, 38}, {113, 102, 71}, {132, 128, 98}, 
 {154, 155, 150}, {201, 187, 161}, {207, 191, 163}, {215, 191, 174}, 
 {204, 181, 165}, {185, 169, 137}, {143, 133, 100}, {99, 88, 80}, 
 {61, 41, 39}, {41, 16, 21}, {17, 3, 12}, {6, 0, 3}, 
 {0, 0, 0}, {0, 0, 0}, {3, 1, 3}, {16, 8, 9}, 
 {54, 24, 30}, {65, 63, 43}, {85, 87, 72}, {124, 122, 90}, 
 {182, 154, 108}, {201, 174, 136}, {202, 181, 122}, {207, 183, 113}, 
 {218, 169, 91}, {208, 146, 67}, {213, 132, 64}, {227, 133, 48}, 
 {226, 130, 48}, {223, 124, 47}, {213, 122, 45}, {211, 112, 41}, 
 {215, 101, 43}, {214, 103, 44}, {205, 112, 45}, {194, 106, 42}, 
 {175, 100, 37}, {169, 89, 35}, {164, 74, 39}, {166, 83, 42}, 
 {163, 74, 36}, {176, 92, 35}, {187, 102, 42}, {202, 116, 54}, 
 {218, 131, 45}, {229, 156, 54}, {229, 164, 62}, {229, 179, 77}, 
 {224, 183, 95}, {222, 193, 115}, {224, 189, 123}, {218, 195, 149}, 
 {223, 200, 158}, {215, 190, 172}, {202, 179, 157}, {154, 144, 119}, 
 {143, 122, 97}, {122, 94, 70}, {119, 85, 51}, {101, 45, 32}, 
 {97, 47, 31}, {83, 35, 29}, {71, 29, 33}, {56, 21, 24}, 
 {16, 8, 21}, {2, 0, 3}, {0, 0, 0}, {0, 0, 0}, 
 {0, 0, 0}, {0, 0, 0}, {16, 10, 8}, {23, 16, 11}, 
 {62, 40, 29}, {92, 66, 41}, {138, 99, 61}, {193, 146, 50}, 
 {215, 170, 60}, {222, 164, 57}, {229, 168, 54}, {233, 168, 56}, 
 {236, 175, 55}, {238, 180, 55}, {236, 177, 57}, {235, 179, 60}, 
 {236, 183, 59}, {231, 190, 63}, {234, 184, 61}, {236, 173, 60}, 
 {233, 169, 59}, {235, 170, 58}, {235, 166, 58}, {233, 160, 58}, 
 {233, 151, 58}, {233, 150, 59}, {226, 137, 53}, {231, 125, 50}, 
 {219, 101, 46}, {202, 98, 45}, {207, 84, 39}, {193, 77, 37}, 
 {190, 74, 37}, {178, 62, 39}, {179, 52, 35}, {183, 57, 36}, 
 {191, 62, 40}, {190, 80, 45}, {187, 97, 43}, {170, 114, 57}, 
 {174, 124, 71}, {181, 151, 81}, {205, 170, 95}, {218, 189, 119}, 
 {215, 190, 114}, {227, 191, 103}, {225, 190, 96}, {235, 192, 73}, 
 {235, 186, 67}, {233, 174, 68}, {233, 152, 56}, {216, 126, 43}, 
 {198, 94, 40}, {183, 72, 41}, {151, 71, 39}, {128, 43, 33}, 
 {89, 14, 25}, {25, 15, 6}, {6, 0, 2}, {0, 0, 0}, 
 {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, 
 {3, 0, 1}, {18, 4, 7}, {33, 13, 19}, {60, 28, 33}, 
 {74, 44, 36}, {87, 53, 35}, {93, 62, 37}, {122, 84, 46}, 
 {121, 88, 45}, {141, 90, 51}, {140, 67, 41}, {122, 81, 49}, 
 {139, 60, 40}, {135, 61, 34}, {150, 57, 34}, {145, 38, 38}, 
 {149, 64, 37}, {123, 56, 32}, {154, 40, 39}, {158, 46, 36}, 
 {175, 45, 38}, {179, 56, 41}, {164, 72, 39}, {160, 85, 40}, 
 {150, 81, 47}, {166, 93, 48}, {157, 99, 55}, {135, 106, 66}, 
 {116, 109, 74}, {136, 114, 90}, {141, 108, 86}, {159, 115, 69}, 
 {180, 133, 80}, {211, 175, 110}, {214, 190, 145}, {224, 203, 178}, 
 {232, 226, 194}, {235, 218, 187}, {225, 213, 184}, {212, 196, 164}, 
 {193, 177, 137}, {180, 135, 90}, {175, 113, 57}, {198, 110, 44}, 
 {208, 113, 41}, {222, 136, 45}, {233, 152, 53}, {235, 157, 54}, 
 {231, 160, 55}, {231, 160, 54}, {228, 151, 52}, {216, 130, 45}, 
 {197, 106, 43}, {173, 84, 39}, {150, 67, 37}, {133, 55, 31}, 
 },
   /* peach-tree */
{{170, 59, 28}, {170, 63, 28}, {129, 68, 37}, {68, 84, 37}, 
 {77, 109, 37}, {81, 121, 47}, {81, 113, 47}, {93, 113, 56}, 
 {101, 133, 75}, {117, 141, 85}, {137, 161, 94}, {141, 162, 84}, 
 {194, 173, 65}, {218, 139, 47}, {222, 119, 37}, {214, 103, 47}, 
 {214, 106, 37}, {194, 95, 28}, {145, 76, 37}, {76, 105, 37}, 
 {52, 80, 18}, {32, 68, 9}, {32, 60, 18}, {32, 48, 18}, 
 {32, 56, 18}, {44, 72, 18}, {64, 105, 37}, {97, 137, 56}, 
 {141, 178, 94}, {170, 198, 122}, {238, 209, 122}, {250, 225, 84}, 
 {230, 151, 46}, {230, 122, 37}, {230, 122, 37}, {219, 105, 37}, 
 {202, 94, 37}, {182, 76, 28}, {133, 55, 18}, {84, 43, 9}, 
 {36, 27, 9}, {28, 32, 0}, {28, 48, 9}, {32, 64, 9}, 
 {64, 92, 28}, {84, 121, 56}, {105, 145, 75}, {145, 174, 103}, 
 {150, 178, 113}, {149, 174, 113}, {141, 170, 113}, {113, 141, 85}, 
 {81, 109, 66}, {64, 68, 47}, {36, 52, 28}, {16, 24, 18}, 
 {12, 12, 9}, {4, 8, 0}, {0, 4, 0}, {0, 4, 0}, 
 {0, 4, 0}, {0, 0, 0}, {4, 0, 0}, {12, 0, 0}, 
 {16, 11, 0}, {36, 15, 0}, {68, 23, 18}, {129, 38, 18}, 
 {170, 55, 18}, {194, 95, 28}, {178, 124, 47}, {154, 174, 103}, 
 {166, 194, 122}, {170, 202, 122}, {178, 210, 141}, {190, 218, 160}, 
 {190, 210, 151}, {202, 214, 151}, {226, 222, 132}, {182, 218, 141}, 
 {182, 210, 141}, {186, 206, 141}, {190, 206, 151}, {198, 206, 169}, 
 {210, 218, 179}, {234, 230, 197}, {234, 234, 197}, {250, 241, 188}, 
 {246, 229, 188}, {234, 192, 141}, {210, 172, 150}, {190, 202, 150}, 
 {178, 198, 151}, {182, 206, 141}, {182, 202, 141}, {182, 198, 132}, 
 {170, 202, 132}, {166, 198, 132}, {158, 186, 122}, {141, 178, 113}, 
 {113, 149, 75}, {81, 117, 56}, {60, 84, 37}, {48, 64, 28}, 
 {24, 56, 9}, {20, 40, 9}, {20, 24, 9}, {12, 16, 9}, 
 {7, 12, 9}, {4, 8, 9}, {8, 4, 9}, {20, 7, 9}, 
 {28, 15, 9}, {36, 23, 9}, {80, 39, 18}, {129, 47, 18}, 
 {178, 59, 18}, {198, 87, 37}, {219, 102, 37}, {222, 102, 37}, 
 {222, 117, 28}, {226, 135, 28}, {230, 142, 28}, {242, 146, 37}, 
 {250, 155, 28}, {246, 187, 28}, {234, 127, 47}, {250, 188, 103}, 
 {250, 225, 112}, {250, 225, 84}, {254, 211, 46}, {254, 207, 46}, 
 {254, 208, 74}, {218, 181, 94}, {149, 120, 103}, {89, 121, 66}, 
 {64, 93, 47}, {32, 60, 18}, {20, 44, 9}, {4, 24, 0}, 
 {0, 12, 0}, {4, 8, 0}, {0, 4, 0}, {0, 4, 0}, 
 {0, 4, 0}, {4, 0, 0}, {4, 0, 0}, {4, 4, 0}, 
 {4, 4, 0}, {4, 8, 0}, {4, 8, 0}, {4, 8, 0}, 
 {0, 4, 0}, {0, 0, 0}, {0, 0, 9}, {0, 0, 0}, 
 {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, 
 {0, 0, 0}, {4, 0, 0}, {4, 4, 0}, {12, 8, 0}, 
 {16, 16, 0}, {32, 16, 0}, {56, 27, 9}, {89, 51, 9}, 
 {125, 67, 9}, {166, 63, 18}, {178, 72, 18}, {198, 90, 28}, 
 {190, 107, 37}, {157, 112, 56}, {153, 99, 47}, {89, 121, 56}, 
 {85, 101, 56}, {113, 72, 28}, {182, 80, 37}, {206, 98, 37}, 
 {210, 102, 37}, {214, 110, 28}, {214, 110, 28}, {218, 118, 37}, 
 {222, 110, 28}, {226, 114, 37}, {222, 110, 47}, {238, 111, 65}, 
 {198, 160, 84}, {169, 148, 112}, {161, 186, 122}, {170, 194, 132}, 
 {190, 206, 151}, {206, 214, 160}, {226, 238, 188}, {246, 238, 197}, 
 {254, 250, 254}, {250, 254, 206}, {242, 254, 206}, {230, 238, 197}, 
 {198, 214, 160}, {170, 194, 132}, {145, 149, 113}, {84, 109, 66}, 
 {56, 64, 37}, {28, 44, 18}, {24, 36, 9}, {20, 20, 9}, 
 {32, 19, 9}, {48, 15, 9}, {101, 39, 18}, {137, 47, 18}, 
 {166, 51, 19}, {145, 55, 18}, {101, 47, 18}, {68, 39, 18}, 
 {32, 56, 9}, {28, 44, 9}, {20, 28, 9}, {16, 20, 9}, 
 {8, 16, 0}, {8, 16, 0}, {4, 12, 0}, {4, 16, 0}, 
 {8, 20, 9}, {16, 32, 9}, {20, 48, 18}, {40, 72, 18}, 
 {68, 109, 37}, {97, 129, 56}, {137, 170, 103}, {149, 182, 113}, 
 {145, 182, 113}, {129, 161, 94}, {105, 133, 75}, {68, 89, 56}, 
 {60, 76, 37}, {48, 64, 37}, {60, 68, 28}, {113, 55, 18}, 
 {166, 51, 19}, {190, 76, 28}, {202, 91, 28}, {210, 94, 28}, 
 {210, 98, 28}, {198, 87, 18}, {158, 55, 9}, {105, 34, 0}, 
 {44, 15, 0}, {20, 4, 0}, {12, 0, 0}, {8, 4, 0}, 
 {4, 8, 0}, {8, 16, 0}, {16, 32, 9}, {28, 52, 9}, 
 },
   /* fire-dragon */
{{88, 3, 9}, {64, 0, 9}, {44, 3, 9}, {24, 4, 9}, 
 {15, 0, 9}, {16, 4, 9}, {28, 8, 9}, {40, 4, 9}, 
 {48, 3, 0}, {52, 0, 0}, {52, 0, 0}, {48, 0, 0}, 
 {40, 0, 0}, {28, 4, 0}, {16, 0, 0}, {8, 0, 9}, 
 {8, 0, 9}, {15, 0, 9}, {28, 0, 0}, {40, 0, 0}, 
 {44, 0, 0}, {48, 0, 0}, {56, 4, 0}, {56, 3, 0}, 
 {52, 0, 0}, {48, 0, 0}, {40, 0, 0}, {28, 0, 0}, 
 {16, 0, 0}, {4, 0, 0}, {0, 0, 0}, {0, 0, 0}, 
 {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 4, 0}, 
 {0, 4, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, 
 {4, 0, 0}, {8, 4, 0}, {12, 4, 0}, {24, 4, 0}, 
 {32, 4, 0}, {40, 4, 9}, {48, 4, 9}, {52, 3, 9}, 
 {68, 3, 9}, {81, 4, 0}, {101, 3, 0}, {117, 0, 0}, 
 {137, 0, 9}, {158, 0, 9}, {182, 0, 9}, {202, 7, 0}, 
 {210, 10, 0}, {202, 7, 0}, {190, 0, 9}, {174, 0, 9}, 
 {145, 3, 9}, {113, 3, 0}, {89, 3, 0}, {68, 3, 9}, 
 {48, 7, 9}, {36, 4, 9}, {20, 0, 0}, {8, 0, 0}, 
 {4, 0, 0}, {4, 0, 0}, {4, 0, 0}, {8, 4, 0}, 
 {24, 4, 0}, {40, 4, 0}, {60, 3, 0}, {84, 3, 0}, 
 {109, 3, 0}, {125, 3, 0}, {145, 0, 0}, {158, 0, 0}, 
 {162, 0, 0}, {162, 0, 0}, {162, 0, 0}, {162, 0, 0}, 
 {162, 3, 0}, {153, 7, 9}, {157, 11, 0}, {153, 0, 0}, 
 {145, 3, 0}, {129, 0, 0}, {109, 0, 0}, {89, 0, 0}, 
 {73, 3, 0}, {52, 3, 0}, {36, 4, 0}, {16, 0, 0}, 
 {8, 0, 0}, {4, 0, 0}, {0, 0, 0}, {0, 0, 0}, 
 {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, 
 {0, 0, 0}, {0, 0, 0}, {0, 0, 9}, {4, 0, 9}, 
 {0, 0, 9}, {0, 0, 9}, {0, 0, 9}, {0, 0, 0}, 
 {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, 
 {0, 0, 0}, {0, 4, 0}, {0, 4, 0}, {0, 0, 0}, 
 {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {4, 0, 0}, 
 {16, 0, 0}, {40, 4, 0}, {60, 0, 0}, {73, 0, 0}, 
 {97, 0, 0}, {113, 0, 0}, {133, 0, 0}, {157, 0, 0}, 
 {166, 7, 0}, {182, 7, 0}, {174, 10, 0}, {174, 15, 9}, 
 {166, 29, 0}, {157, 35, 9}, {121, 30, 9}, {93, 15, 9}, 
 {93, 11, 9}, {92, 11, 0}, {89, 3, 9}, {88, 3, 9}, 
 {80, 3, 9}, {76, 0, 0}, {68, 0, 0}, {64, 3, 0}, 
 {68, 3, 0}, {76, 0, 0}, {89, 3, 0}, {105, 0, 0}, 
 {121, 0, 0}, {145, 0, 0}, {158, 0, 0}, {162, 3, 0}, 
 {153, 18, 9}, {169, 7, 0}, {166, 0, 0}, {174, 3, 0}, 
 {174, 0, 0}, {178, 0, 0}, {178, 3, 0}, {182, 3, 0}, 
 {190, 11, 9}, {206, 14, 9}, {234, 58, 9}, {246, 131, 28}, 
 {242, 179, 28}, {250, 187, 37}, {250, 233, 84}, {246, 254, 102}, 
 {250, 254, 140}, {254, 249, 140}, {250, 241, 102}, {242, 195, 46}, 
 {246, 159, 46}, {186, 91, 37}, {137, 43, 18}, {101, 55, 18}, 
 {76, 39, 18}, {56, 11, 9}, {44, 11, 9}, {28, 4, 0}, 
 {16, 0, 0}, {4, 0, 0}, {4, 0, 0}, {0, 0, 0}, 
 {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {4, 0, 0}, 
 {8, 4, 0}, {16, 8, 0}, {24, 4, 0}, {36, 7, 0}, 
 {40, 4, 0}, {32, 0, 0}, {28, 0, 0}, {20, 0, 0}, 
 {12, 0, 0}, {8, 0, 0}, {4, 0, 0}, {0, 0, 0}, 
 {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {4, 0, 0}, 
 {8, 0, 0}, {24, 0, 0}, {44, 3, 0}, {60, 0, 0}, 
 {77, 0, 0}, {101, 0, 0}, {133, 3, 0}, {162, 30, 0}, 
 {182, 47, 0}, {194, 79, 18}, {197, 107, 18}, {206, 95, 18}, 
 {198, 86, 18}, {198, 47, 0}, {190, 39, 9}, {194, 18, 9}, 
 {182, 7, 0}, {182, 10, 0}, {186, 22, 9}, {190, 22, 9}, 
 {206, 66, 9}, {230, 98, 9}, {246, 134, 9}, {246, 155, 28}, 
 {238, 138, 9}, {238, 142, 37}, {226, 126, 18}, {190, 87, 9}, 
 {141, 48, 0}, {125, 43, 9}, {101, 15, 9}, {101, 0, 9}, 
 {97, 3, 0}, {92, 7, 0}, {89, 15, 9}, {77, 24, 9}, 
 {85, 7, 0}, {64, 7, 0}, {60, 3, 0}, {52, 7, 0}, 
 {48, 4, 0}, {44, 4, 0}, {44, 3, 0}, {48, 0, 0}, 
 {44, 0, 0}, {40, 7, 0}, {36, 4, 0}, {28, 0, 0}, 
 },
   /* ice-dragon */
{{96, 43, 37}, {113, 80, 75}, {157, 120, 103}, {174, 141, 122}, 
 {178, 161, 151}, {194, 173, 160}, {186, 169, 170}, {165, 141, 150}, 
 {153, 129, 141}, {141, 133, 131}, {137, 129, 131}, {137, 133, 141}, 
 {141, 137, 141}, {157, 157, 160}, {161, 173, 188}, {165, 189, 216}, 
 {181, 205, 235}, {193, 222, 235}, {189, 226, 244}, {193, 230, 244}, 
 {197, 230, 254}, {197, 226, 254}, {189, 226, 244}, {185, 222, 244}, 
 {173, 209, 244}, {157, 193, 235}, {133, 177, 226}, {120, 169, 235}, 
 {124, 173, 225}, {133, 185, 225}, {144, 198, 235}, {149, 193, 244}, 
 {157, 201, 244}, {161, 197, 235}, {169, 193, 226}, {161, 185, 197}, 
 {177, 177, 179}, {185, 177, 188}, {193, 193, 207}, {226, 222, 216}, 
 {246, 246, 235}, {254, 254, 254}, {254, 254, 254}, {254, 254, 254}, 
 {250, 254, 254}, {237, 245, 254}, {209, 230, 244}, {193, 201, 216}, 
 {181, 173, 188}, {173, 161, 179}, {161, 157, 160}, {145, 137, 141}, 
 {149, 120, 122}, {133, 96, 94}, {121, 60, 56}, {97, 56, 46}, 
 {80, 39, 37}, {60, 15, 18}, {44, 19, 9}, {48, 19, 18}, 
 {56, 23, 18}, {60, 31, 37}, {64, 39, 56}, {76, 52, 65}, 
 {92, 72, 103}, {97, 101, 122}, {117, 113, 132}, {125, 117, 132}, 
 {133, 117, 122}, {137, 117, 113}, {125, 109, 94}, {117, 92, 84}, 
 {117, 88, 84}, {133, 97, 94}, {141, 100, 94}, {133, 104, 113}, 
 {129, 121, 132}, {128, 145, 178}, {116, 162, 216}, {121, 149, 197}, 
 {116, 112, 151}, {108, 92, 122}, {76, 48, 85}, {56, 40, 66}, 
 {60, 31, 37}, {52, 27, 28}, {44, 27, 28}, {48, 19, 28}, 
 {48, 27, 28}, {56, 31, 47}, {68, 56, 75}, {96, 92, 113}, 
 {113, 117, 151}, {108, 153, 197}, {108, 158, 225}, {100, 154, 235}, 
 {100, 158, 235}, {108, 158, 235}, {141, 189, 244}, {157, 201, 244}, 
 {169, 210, 244}, {173, 209, 244}, {165, 205, 244}, {148, 197, 254}, 
 {140, 193, 254}, {116, 185, 254}, {104, 173, 244}, {100, 162, 244}, 
 {96, 154, 244}, {100, 158, 244}, {104, 158, 244}, {104, 165, 244}, 
 {108, 181, 244}, {141, 197, 244}, {169, 210, 244}, {185, 226, 244}, 
 {205, 238, 254}, {218, 246, 254}, {230, 250, 254}, {234, 254, 254}, 
 {234, 254, 244}, {213, 250, 244}, {189, 242, 244}, {177, 226, 254}, 
 {173, 226, 244}, {160, 226, 254}, {173, 234, 254}, {189, 238, 254}, 
 {221, 246, 254}, {250, 254, 254}, {254, 254, 254}, {254, 254, 254}, 
 {250, 254, 254}, {234, 250, 254}, {222, 242, 254}, {201, 226, 244}, 
 {181, 210, 235}, {161, 202, 235}, {149, 189, 235}, {120, 173, 235}, 
 {108, 177, 235}, {108, 177, 244}, {112, 181, 244}, {140, 197, 244}, 
 {157, 205, 244}, {177, 218, 244}, {193, 234, 235}, {214, 246, 244}, 
 {222, 246, 254}, {226, 250, 254}, {222, 246, 244}, {209, 226, 235}, 
 {193, 197, 216}, {173, 177, 207}, {161, 161, 179}, {145, 133, 150}, 
 {125, 100, 122}, {100, 72, 84}, {88, 52, 66}, {80, 48, 56}, 
 {88, 43, 47}, {68, 39, 47}, {72, 39, 56}, {80, 43, 56}, 
 {80, 52, 65}, {88, 64, 75}, {113, 97, 103}, {125, 129, 151}, 
 {116, 154, 207}, {104, 158, 235}, {100, 158, 235}, {100, 158, 244}, 
 {100, 166, 254}, {104, 173, 254}, {100, 173, 244}, {104, 189, 254}, 
 {132, 202, 254}, {161, 201, 244}, {185, 202, 244}, {201, 226, 254}, 
 {221, 230, 254}, {233, 250, 254}, {250, 254, 254}, {254, 254, 254}, 
 {250, 250, 254}, {230, 238, 235}, {206, 202, 207}, {178, 169, 169}, 
 {149, 129, 132}, {117, 88, 103}, {93, 60, 65}, {105, 56, 56}, 
 {113, 56, 56}, {133, 88, 75}, {141, 108, 94}, {149, 137, 132}, 
 {170, 165, 169}, {182, 190, 198}, {214, 214, 226}, {217, 230, 244}, 
 {217, 234, 244}, {209, 234, 254}, {197, 226, 235}, {173, 194, 226}, 
 {149, 173, 198}, {157, 165, 179}, {149, 149, 160}, {149, 121, 122}, 
 {129, 100, 103}, {113, 76, 84}, {96, 56, 65}, {92, 52, 56}, 
 {88, 52, 56}, {84, 68, 56}, {97, 85, 94}, {112, 109, 132}, 
 {128, 129, 150}, {133, 137, 179}, {137, 157, 188}, {161, 157, 169}, 
 {161, 141, 150}, {166, 136, 132}, {153, 132, 122}, {157, 120, 113}, 
 {169, 141, 131}, {198, 173, 160}, {202, 177, 170}, {218, 210, 207}, 
 {246, 238, 244}, {250, 254, 254}, {254, 254, 254}, {254, 254, 254}, 
 {250, 254, 254}, {238, 250, 244}, {222, 242, 244}, {218, 214, 226}, 
 {190, 190, 198}, {181, 177, 178}, {185, 173, 169}, {194, 173, 169}, 
 {181, 173, 179}, {161, 165, 179}, {157, 169, 179}, {141, 173, 207}, 
 {133, 173, 216}, {136, 169, 226}, {137, 149, 188}, {125, 121, 132}, 
 {96, 92, 103}, {84, 64, 75}, {80, 60, 66}, {88, 60, 66}, 
 {104, 76, 85}, {129, 125, 122}, {161, 161, 169}, {201, 193, 197}, 
 },
   /* german-landscape */
{{61, 62, 43}, {52, 48, 45}, {42, 44, 39}, {37, 39, 34}, 
 {33, 39, 23}, {36, 44, 22}, {46, 54, 32}, {51, 55, 33}, 
 {45, 49, 38}, {45, 49, 38}, {45, 45, 45}, {45, 45, 45}, 
 {35, 35, 35}, {35, 39, 28}, {36, 44, 22}, {36, 44, 22}, 
 {31, 39, 17}, {31, 39, 17}, {31, 39, 17}, {31, 39, 17}, 
 {31, 39, 17}, {31, 39, 17}, {28, 34, 18}, {23, 29, 13}, 
 {25, 29, 18}, {30, 34, 23}, {30, 34, 23}, {33, 39, 23}, 
 {36, 44, 22}, {39, 48, 22}, {45, 43, 38}, {55, 55, 44}, 
 {60, 54, 45}, {63, 61, 54}, {69, 68, 58}, {70, 66, 54}, 
 {66, 64, 48}, {70, 69, 45}, {79, 75, 50}, {77, 85, 55}, 
 {94, 101, 63}, {100, 123, 70}, {115, 123, 80}, {131, 132, 106}, 
 {134, 139, 102}, {131, 130, 80}, {120, 105, 63}, {110, 98, 70}, 
 {96, 76, 62}, {77, 68, 57}, {65, 79, 60}, {72, 79, 65}, 
 {90, 95, 69}, {102, 99, 77}, {118, 130, 107}, {137, 163, 141}, 
 {159, 182, 173}, {167, 178, 180}, {177, 170, 179}, {178, 172, 183}, 
 {183, 179, 196}, {165, 177, 194}, {151, 168, 185}, {127, 154, 156}, 
 {131, 133, 141}, {132, 125, 149}, {133, 139, 140}, {151, 129, 154}, 
 {163, 157, 170}, {169, 168, 176}, {164, 174, 180}, {168, 179, 193}, 
 {168, 187, 195}, {161, 179, 194}, {161, 195, 194}, {174, 198, 204}, 
 {193, 227, 202}, {210, 230, 224}, {214, 223, 214}, {240, 234, 209}, 
 {219, 215, 201}, {201, 197, 192}, {204, 180, 172}, {197, 156, 171}, 
 {184, 157, 167}, {169, 156, 169}, {177, 129, 137}, {148, 105, 71}, 
 {111, 83, 64}, {101, 79, 57}, {93, 80, 50}, {81, 73, 45}, 
 {79, 79, 47}, {85, 89, 56}, {100, 94, 74}, {119, 120, 84}, 
 {154, 109, 96}, {132, 132, 120}, {133, 188, 112}, {124, 180, 99}, 
 {130, 156, 103}, {111, 139, 75}, {102, 109, 62}, {94, 94, 54}, 
 {91, 79, 57}, {86, 72, 56}, {86, 70, 53}, {78, 68, 49}, 
 {68, 57, 46}, {58, 58, 44}, {53, 59, 43}, {50, 54, 43}, 
 {46, 50, 28}, {41, 49, 27}, {39, 48, 22}, {39, 48, 22}, 
 {39, 48, 22}, {39, 48, 22}, {44, 53, 27}, {47, 57, 33}, 
 {54, 63, 37}, {70, 71, 45}, {75, 79, 40}, {84, 78, 41}, 
 {96, 93, 46}, {110, 106, 55}, {122, 115, 50}, {142, 158, 73}, 
 {137, 185, 77}, {132, 178, 79}, {135, 150, 71}, {114, 109, 53}, 
 {97, 92, 58}, {86, 97, 78}, {97, 96, 62}, {113, 121, 90}, 
 {110, 129, 129}, {138, 144, 170}, {164, 173, 181}, {183, 184, 200}, 
 {194, 193, 202}, {214, 210, 211}, {208, 220, 216}, {210, 220, 212}, 
 {205, 202, 204}, {186, 186, 193}, {186, 173, 176}, {176, 155, 152}, 
 {185, 123, 88}, {172, 130, 65}, {161, 126, 53}, {120, 106, 56}, 
 {98, 83, 60}, {76, 70, 51}, {58, 58, 47}, {58, 58, 44}, 
 {64, 67, 43}, {70, 78, 42}, {80, 97, 50}, {99, 111, 58}, 
 {104, 140, 59}, {113, 144, 62}, {145, 139, 67}, {164, 133, 60}, 
 {172, 133, 65}, {184, 149, 59}, {158, 135, 56}, {134, 109, 56}, 
 {114, 100, 58}, {106, 103, 65}, {109, 108, 64}, {114, 120, 75}, 
 {123, 134, 118}, {136, 147, 152}, {145, 168, 187}, {156, 179, 183}, 
 {153, 174, 190}, {153, 172, 190}, {143, 161, 178}, {130, 139, 150}, 
 {114, 116, 120}, {93, 89, 82}, {87, 81, 62}, {79, 79, 47}, 
 {75, 85, 47}, {76, 87, 46}, {77, 85, 45}, {84, 88, 45}, 
 {87, 97, 46}, {97, 97, 47}, {116, 108, 56}, {159, 130, 57}, 
 {170, 120, 72}, {137, 103, 67}, {108, 85, 65}, {99, 75, 56}, 
 {87, 78, 54}, {78, 68, 46}, {69, 68, 44}, {70, 64, 45}, 
 {73, 67, 48}, {77, 75, 55}, {84, 88, 65}, {97, 102, 83}, 
 {108, 119, 128}, {131, 146, 146}, {151, 162, 177}, {168, 172, 190}, 
 {180, 182, 200}, {168, 187, 195}, {182, 190, 196}, {194, 197, 197}, 
 {212, 210, 202}, {221, 217, 208}, {220, 217, 217}, {218, 217, 216}, 
 {210, 205, 204}, {200, 182, 162}, {223, 194, 83}, {220, 174, 75}, 
 {225, 173, 78}, {214, 151, 77}, {170, 115, 76}, {125, 88, 80}, 
 {101, 83, 60}, {88, 83, 55}, {86, 91, 47}, {83, 91, 50}, 
 {82, 92, 57}, {98, 99, 70}, {114, 116, 69}, {117, 137, 99}, 
 {129, 148, 127}, {143, 157, 168}, {161, 171, 179}, {160, 168, 189}, 
 {153, 157, 182}, {155, 139, 161}, {179, 116, 112}, {158, 104, 89}, 
 {164, 97, 83}, {161, 97, 68}, {173, 102, 80}, {182, 119, 100}, 
 {181, 144, 157}, {170, 170, 169}, {156, 158, 172}, {130, 141, 156}, 
 {115, 140, 140}, {124, 139, 130}, {131, 155, 114}, {130, 160, 116}, 
 {126, 149, 104}, {134, 148, 136}, {147, 157, 172}, {163, 178, 187}, 
 },
   /* no-name */
{{218, 222, 188}, {238, 230, 197}, {238, 242, 206}, {238, 242, 207}, 
 {230, 238, 225}, {234, 238, 216}, {242, 241, 235}, {242, 245, 216}, 
 {230, 242, 206}, {222, 234, 197}, {214, 218, 198}, {206, 210, 188}, 
 {194, 202, 169}, {190, 202, 160}, {206, 214, 170}, {222, 226, 197}, 
 {234, 237, 206}, {234, 242, 197}, {222, 226, 197}, {194, 202, 170}, 
 {174, 190, 170}, {165, 178, 150}, {162, 169, 141}, {150, 162, 132}, 
 {141, 141, 122}, {133, 137, 113}, {133, 141, 113}, {133, 133, 103}, 
 {121, 125, 103}, {121, 125, 103}, {113, 121, 94}, {101, 109, 85}, 
 {77, 93, 66}, {52, 64, 37}, {48, 64, 37}, {48, 56, 28}, 
 {44, 60, 28}, {44, 52, 28}, {36, 44, 18}, {36, 36, 0}, 
 {36, 44, 9}, {40, 52, 9}, {56, 64, 18}, {48, 64, 28}, 
 {64, 80, 47}, {85, 105, 66}, {101, 117, 85}, {108, 125, 94}, 
 {116, 141, 113}, {116, 137, 132}, {116, 141, 132}, {120, 141, 132}, 
 {121, 137, 122}, {121, 133, 113}, {117, 125, 103}, {113, 121, 94}, 
 {108, 113, 94}, {109, 112, 94}, {108, 121, 94}, {104, 117, 94}, 
 {105, 113, 85}, {109, 117, 85}, {109, 117, 85}, {105, 113, 85}, 
 {101, 113, 85}, {105, 109, 85}, {100, 113, 94}, {104, 112, 103}, 
 {104, 112, 103}, {104, 108, 103}, {108, 108, 94}, {113, 113, 94}, 
 {121, 121, 103}, {129, 133, 113}, {125, 145, 113}, {133, 146, 122}, 
 {133, 146, 122}, {125, 146, 132}, {121, 146, 132}, {120, 146, 141}, 
 {120, 141, 141}, {116, 141, 132}, {116, 146, 132}, {117, 146, 122}, 
 {108, 133, 103}, {100, 121, 94}, {89, 105, 75}, {170, 87, 0}, 
 {56, 68, 28}, {48, 60, 28}, {44, 60, 28}, {52, 64, 37}, 
 {80, 97, 75}, {93, 109, 94}, {100, 113, 94}, {96, 113, 94}, 
 {96, 117, 94}, {104, 117, 94}, {108, 121, 94}, {108, 121, 94}, 
 {113, 121, 103}, {112, 121, 103}, {108, 125, 103}, {104, 121, 103}, 
 {108, 121, 103}, {108, 117, 103}, {113, 117, 94}, {113, 117, 94}, 
 {117, 121, 94}, {117, 125, 94}, {129, 141, 94}, {141, 146, 94}, 
 {141, 146, 103}, {154, 154, 113}, {154, 162, 122}, {154, 162, 122}, 
 {154, 161, 122}, {146, 154, 113}, {137, 146, 103}, {129, 133, 94}, 
 {125, 125, 85}, {105, 121, 75}, {97, 109, 66}, {68, 76, 37}, 
 {56, 68, 28}, {64, 81, 37}, {69, 77, 37}, {113, 109, 66}, 
 {121, 125, 75}, {129, 125, 85}, {121, 121, 85}, {109, 117, 85}, 
 {105, 125, 85}, {108, 121, 94}, {101, 121, 84}, {104, 121, 94}, 
 {100, 121, 103}, {100, 121, 103}, {104, 117, 94}, {100, 113, 94}, 
 {100, 108, 94}, {101, 109, 85}, {77, 88, 66}, {52, 64, 37}, 
 {44, 56, 28}, {32, 40, 28}, {28, 20, 9}, {24, 24, 0}, 
 {4, 20, 0}, {8, 16, 0}, {12, 24, 0}, {28, 40, 9}, 
 {36, 48, 18}, {60, 68, 37}, {93, 101, 85}, {117, 121, 85}, 
 {133, 137, 94}, {137, 145, 113}, {150, 162, 113}, {154, 162, 122}, 
 {158, 170, 122}, {158, 170, 122}, {170, 174, 113}, {166, 170, 122}, 
 {162, 170, 122}, {161, 165, 122}, {150, 158, 122}, {133, 150, 122}, 
 {129, 146, 122}, {120, 146, 122}, {117, 146, 122}, {117, 141, 122}, 
 {112, 129, 103}, {125, 125, 103}, {137, 137, 103}, {146, 154, 113}, 
 {158, 170, 122}, {170, 182, 132}, {178, 182, 141}, {182, 186, 151}, 
 {194, 202, 151}, {178, 190, 141}, {178, 182, 141}, {170, 178, 141}, 
 {162, 174, 132}, {154, 166, 122}, {146, 158, 122}, {133, 154, 122}, 
 {125, 150, 122}, {125, 146, 122}, {125, 146, 132}, {125, 146, 132}, 
 {129, 150, 132}, {133, 150, 132}, {133, 150, 132}, {129, 146, 132}, 
 {133, 154, 132}, {133, 154, 132}, {141, 154, 132}, {146, 150, 132}, 
 {158, 169, 132}, {174, 178, 132}, {170, 186, 132}, {178, 190, 141}, 
 {182, 194, 160}, {198, 202, 160}, {198, 206, 170}, {214, 218, 179}, 
 {218, 226, 197}, {210, 214, 188}, {190, 194, 160}, {170, 182, 141}, 
 {158, 166, 122}, {146, 154, 113}, {137, 137, 113}, {129, 125, 103}, 
 {125, 125, 103}, {129, 120, 103}, {125, 125, 94}, {121, 121, 94}, 
 {121, 129, 94}, {129, 125, 103}, {129, 125, 103}, {129, 129, 103}, 
 {129, 137, 113}, {133, 145, 122}, {137, 146, 122}, {150, 157, 122}, 
 {150, 158, 122}, {146, 150, 132}, {150, 154, 141}, {146, 146, 132}, 
 {137, 145, 132}, {129, 146, 132}, {125, 146, 141}, {120, 146, 141}, 
 {116, 146, 141}, {120, 146, 141}, {120, 150, 151}, {129, 150, 141}, 
 {129, 150, 141}, {129, 154, 141}, {133, 154, 141}, {137, 158, 141}, 
 {137, 158, 141}, {141, 162, 151}, {149, 162, 151}, {141, 162, 151}, 
 {150, 166, 141}, {154, 161, 141}, {158, 169, 132}, {158, 166, 122}, 
 {162, 165, 113}, {158, 166, 113}, {154, 166, 113}, {149, 157, 113}, 
 },
   /* living-mud-bomb */
{{193, 144, 35}, {153, 117, 33}, {133, 107, 35}, {102, 76, 20}, 
 {96, 67, 20}, {79, 51, 16}, {70, 47, 16}, {66, 52, 16}, 
 {64, 48, 16}, {64, 47, 16}, {61, 44, 16}, {58, 41, 16}, 
 {58, 42, 16}, {64, 46, 16}, {72, 48, 16}, {85, 52, 18}, 
 {86, 60, 18}, {88, 64, 22}, {85, 76, 24}, {75, 76, 24}, 
 {89, 56, 15}, {84, 47, 16}, {84, 46, 16}, {84, 43, 16}, 
 {84, 41, 16}, {84, 40, 16}, {84, 40, 16}, {84, 39, 16}, 
 {84, 39, 16}, {84, 39, 16}, {81, 39, 16}, {79, 39, 16}, 
 {75, 39, 16}, {66, 39, 16}, {64, 40, 16}, {55, 40, 16}, 
 {51, 40, 16}, {48, 40, 16}, {48, 40, 16}, {49, 42, 16}, 
 {53, 43, 16}, {55, 41, 16}, {55, 41, 16}, {53, 41, 16}, 
 {49, 40, 16}, {48, 40, 16}, {48, 40, 16}, {48, 40, 16}, 
 {48, 40, 16}, {48, 40, 16}, {48, 40, 16}, {48, 38, 16}, 
 {48, 38, 16}, {48, 38, 16}, {48, 38, 16}, {48, 38, 16}, 
 {45, 35, 16}, {48, 38, 16}, {48, 38, 16}, {49, 40, 16}, 
 {53, 40, 16}, {58, 40, 16}, {64, 40, 16}, {75, 39, 16}, 
 {81, 39, 16}, {83, 39, 16}, {84, 39, 16}, {81, 39, 16}, 
 {79, 39, 16}, {75, 40, 16}, {68, 47, 16}, {64, 48, 16}, 
 {64, 48, 16}, {64, 48, 16}, {58, 46, 16}, {56, 44, 16}, 
 {56, 44, 16}, {53, 43, 16}, {49, 40, 16}, {48, 40, 16}, 
 {48, 40, 16}, {48, 40, 16}, {48, 40, 16}, {49, 40, 16}, 
 {55, 41, 16}, {63, 43, 16}, {68, 47, 16}, {79, 49, 16}, 
 {93, 56, 15}, {96, 68, 20}, {120, 84, 20}, {151, 110, 35}, 
 {186, 141, 35}, {236, 162, 35}, {246, 167, 44}, {238, 165, 35}, 
 {226, 153, 33}, {185, 106, 22}, {128, 82, 15}, {96, 70, 20}, 
 {84, 60, 22}, {72, 48, 16}, {62, 47, 16}, {55, 42, 16}, 
 {49, 40, 16}, {48, 40, 16}, {48, 40, 16}, {48, 40, 16}, 
 {48, 40, 16}, {48, 40, 16}, {48, 40, 16}, {48, 40, 16}, 
 {48, 40, 16}, {48, 40, 16}, {48, 40, 16}, {48, 40, 16}, 
 {48, 40, 16}, {48, 40, 16}, {49, 40, 16}, {55, 40, 16}, 
 {58, 40, 16}, {64, 42, 16}, {68, 46, 16}, {70, 47, 16}, 
 {77, 43, 16}, {81, 40, 16}, {84, 39, 16}, {85, 39, 16}, 
 {91, 39, 15}, {96, 39, 16}, {96, 39, 16}, {94, 39, 16}, 
 {91, 39, 16}, {85, 39, 16}, {85, 39, 16}, {84, 39, 16}, 
 {84, 39, 16}, {84, 39, 16}, {84, 39, 16}, {84, 39, 16}, 
 {84, 39, 16}, {84, 39, 16}, {84, 39, 16}, {84, 39, 16}, 
 {84, 39, 16}, {84, 39, 16}, {85, 39, 16}, {87, 42, 16}, 
 {91, 43, 16}, {96, 43, 16}, {100, 40, 16}, {106, 52, 22}, 
 {124, 75, 17}, {164, 105, 21}, {217, 135, 30}, {239, 162, 49}, 
 {248, 175, 48}, {237, 159, 49}, {202, 125, 32}, {163, 84, 15}, 
 {130, 76, 20}, {106, 71, 22}, {98, 53, 15}, {91, 43, 16}, 
 {84, 41, 16}, {77, 39, 16}, {68, 39, 16}, {64, 42, 16}, 
 {64, 44, 16}, {68, 47, 16}, {75, 46, 16}, {84, 42, 16}, 
 {91, 40, 16}, {98, 39, 16}, {100, 40, 16}, {101, 50, 15}, 
 {117, 55, 15}, {120, 53, 15}, {120, 51, 15}, {120, 54, 15}, 
 {106, 52, 15}, {102, 43, 15}, {100, 39, 16}, {92, 39, 16}, 
 {87, 39, 16}, {85, 39, 16}, {84, 39, 16}, {84, 39, 16}, 
 {84, 39, 16}, {84, 39, 16}, {84, 39, 16}, {84, 39, 16}, 
 {84, 39, 16}, {84, 39, 16}, {84, 39, 16}, {84, 39, 16}, 
 {84, 39, 16}, {84, 39, 16}, {84, 39, 16}, {85, 39, 16}, 
 {92, 39, 16}, {100, 39, 16}, {100, 39, 16}, {117, 46, 15}, 
 {127, 62, 15}, {175, 55, 15}, {192, 53, 15}, {237, 60, 15}, 
 {247, 74, 20}, {230, 62, 17}, {184, 53, 15}, {182, 56, 15}, 
 {134, 48, 15}, {128, 67, 20}, {128, 78, 28}, {137, 103, 28}, 
 {188, 128, 30}, {229, 153, 35}, {245, 151, 35}, {248, 133, 41}, 
 {248, 106, 31}, {202, 107, 22}, {137, 94, 35}, {108, 76, 15}, 
 {93, 56, 15}, {84, 47, 16}, {84, 45, 16}, {84, 42, 16}, 
 {81, 39, 16}, {81, 39, 16}, {73, 39, 16}, {64, 40, 16}, 
 {58, 40, 16}, {55, 39, 16}, {49, 40, 16}, {48, 40, 16}, 
 {48, 40, 16}, {48, 40, 16}, {48, 40, 16}, {48, 40, 16}, 
 {48, 40, 16}, {49, 40, 16}, {53, 40, 16}, {57, 40, 16}, 
 {64, 40, 16}, {66, 39, 16}, {70, 39, 16}, {77, 39, 16}, 
 {81, 39, 16}, {84, 39, 16}, {84, 39, 16}, {81, 41, 16}, 
 {77, 40, 16}, {68, 46, 16}, {64, 47, 16}, {64, 47, 16}, 
 },
   /* cars */
{{43, 30, 36}, {38, 26, 33}, {29, 22, 30}, {32, 24, 32}, 
 {31, 31, 35}, {40, 39, 36}, {51, 56, 42}, {69, 71, 43}, 
 {92, 94, 54}, {116, 120, 64}, {183, 130, 77}, {221, 172, 85}, 
 {218, 188, 136}, {187, 189, 148}, {190, 191, 173}, {176, 180, 172}, 
 {159, 184, 170}, {142, 161, 152}, {126, 135, 130}, {104, 119, 98}, 
 {98, 83, 78}, {81, 60, 64}, {87, 41, 42}, {90, 44, 36}, 
 {78, 35, 32}, {59, 24, 34}, {57, 24, 32}, {54, 32, 38}, 
 {51, 35, 37}, {54, 32, 39}, {64, 51, 38}, {74, 59, 34}, 
 {82, 70, 38}, {91, 96, 51}, {132, 137, 68}, {207, 152, 66}, 
 {229, 204, 97}, {217, 199, 117}, {213, 222, 147}, {218, 215, 178}, 
 {193, 204, 181}, {177, 197, 185}, {171, 199, 191}, {165, 182, 185}, 
 {155, 161, 156}, {116, 122, 129}, {91, 87, 99}, {72, 74, 85}, 
 {63, 55, 63}, {44, 41, 50}, {34, 33, 45}, {33, 25, 34}, 
 {27, 23, 28}, {33, 21, 25}, {39, 33, 24}, {47, 45, 38}, 
 {52, 51, 45}, {67, 62, 56}, {92, 82, 69}, {120, 118, 89}, 
 {152, 134, 85}, {164, 135, 91}, {152, 152, 93}, {155, 166, 95}, 
 {146, 157, 118}, {138, 166, 102}, {130, 164, 111}, {133, 155, 93}, 
 {113, 136, 88}, {102, 131, 85}, {96, 100, 60}, {90, 81, 57}, 
 {69, 70, 37}, {59, 63, 38}, {58, 49, 37}, {49, 39, 39}, 
 {43, 36, 32}, {33, 23, 30}, {27, 17, 30}, {27, 19, 31}, 
 {26, 23, 29}, {24, 20, 27}, {26, 21, 29}, {33, 24, 32}, 
 {45, 32, 37}, {51, 45, 46}, {70, 66, 62}, {108, 94, 78}, 
 {174, 107, 74}, {205, 144, 56}, {210, 171, 78}, {205, 194, 148}, 
 {211, 201, 178}, {205, 226, 197}, {195, 210, 202}, {183, 207, 199}, 
 {178, 206, 195}, {162, 203, 184}, {156, 195, 177}, {158, 187, 169}, 
 {152, 186, 156}, {152, 162, 151}, {143, 143, 137}, {147, 147, 111}, 
 {125, 138, 102}, {125, 124, 97}, {122, 132, 68}, {109, 114, 62}, 
 {92, 94, 49}, {82, 73, 41}, {72, 55, 49}, {69, 50, 39}, 
 {67, 49, 47}, {69, 62, 60}, {70, 70, 80}, {84, 93, 100}, 
 {96, 132, 114}, {106, 133, 125}, {113, 130, 123}, {117, 128, 114}, 
 {136, 138, 123}, {143, 160, 126}, {151, 174, 128}, {157, 188, 118}, 
 {165, 184, 135}, {173, 203, 155}, {186, 219, 163}, {198, 226, 180}, 
 {195, 244, 191}, {203, 247, 199}, {207, 238, 196}, {205, 244, 226}, 
 {221, 248, 232}, {236, 250, 236}, {222, 247, 232}, {207, 230, 212}, 
 {190, 212, 200}, {165, 190, 191}, {136, 162, 173}, {107, 133, 128}, 
 {96, 116, 109}, {92, 105, 77}, {76, 72, 69}, {89, 76, 60}, 
 {100, 92, 76}, {120, 118, 98}, {150, 164, 137}, {167, 198, 158}, 
 {188, 218, 157}, {209, 237, 162}, {215, 244, 184}, {222, 254, 212}, 
 {236, 253, 238}, {246, 253, 239}, {252, 252, 241}, {251, 254, 243}, 
 {248, 252, 241}, {243, 251, 238}, {242, 240, 224}, {239, 239, 213}, 
 {211, 229, 209}, {224, 229, 197}, {215, 229, 179}, {203, 228, 197}, 
 {190, 220, 180}, {182, 218, 163}, {159, 197, 139}, {133, 167, 129}, 
 {120, 145, 128}, {106, 130, 110}, {79, 82, 94}, {64, 64, 70}, 
 {52, 44, 57}, {42, 31, 43}, {39, 42, 46}, {58, 59, 61}, 
 {76, 73, 84}, {108, 107, 114}, {140, 148, 145}, {169, 178, 165}, 
 {195, 205, 186}, {213, 227, 209}, {218, 244, 225}, {241, 253, 215}, 
 {241, 254, 212}, {239, 248, 180}, {233, 247, 175}, {223, 225, 171}, 
 {183, 192, 147}, {152, 143, 122}, {123, 118, 103}, {105, 112, 95}, 
 {90, 89, 94}, {76, 77, 89}, {79, 88, 98}, {96, 110, 112}, 
 {116, 116, 116}, {134, 134, 134}, {144, 156, 164}, {138, 166, 175}, 
 {153, 184, 183}, {166, 201, 161}, {174, 218, 170}, {179, 215, 175}, 
 {182, 191, 169}, {171, 184, 169}, {149, 164, 168}, {136, 158, 163}, 
 {116, 131, 127}, {92, 120, 99}, {78, 101, 65}, {77, 78, 61}, 
 {66, 68, 48}, {66, 67, 44}, {75, 72, 52}, {92, 77, 66}, 
 {153, 100, 68}, {178, 87, 59}, {168, 60, 50}, {152, 53, 43}, 
 {92, 77, 50}, {79, 68, 52}, {68, 59, 66}, {63, 59, 72}, 
 {57, 71, 73}, {79, 83, 91}, {111, 110, 95}, {134, 120, 91}, 
 {182, 74, 55}, {189, 30, 39}, {189, 28, 37}, {167, 26, 34}, 
 {159, 32, 36}, {97, 36, 37}, {63, 36, 40}, {48, 27, 36}, 
 {40, 23, 24}, {32, 22, 16}, {24, 17, 23}, {22, 17, 25}, 
 {23, 17, 25}, {24, 20, 27}, {24, 19, 24}, {26, 19, 26}, 
 {30, 18, 26}, {33, 16, 29}, {36, 19, 27}, {33, 19, 27}, 
 {35, 22, 27}, {45, 27, 21}, {50, 34, 37}, {49, 44, 43}, 
 {64, 53, 45}, {80, 69, 52}, {92, 94, 68}, {127, 123, 85}, 
 },
   /* unhealthy-tan */
{{218, 205, 192}, {223, 205, 183}, {219, 202, 177}, {205, 193, 171}, 
 {206, 186, 157}, {189, 170, 147}, {173, 151, 130}, {163, 143, 129}, 
 {160, 142, 119}, {156, 141, 120}, {159, 150, 133}, {168, 161, 143}, 
 {183, 172, 164}, {211, 200, 191}, {216, 206, 199}, {218, 212, 211}, 
 {220, 213, 206}, {222, 213, 203}, {223, 209, 199}, {212, 203, 192}, 
 {205, 194, 176}, {198, 180, 151}, {187, 160, 127}, {173, 141, 106}, 
 {153, 126, 101}, {130, 108, 88}, {104, 96, 79}, {88, 76, 64}, 
 {72, 59, 51}, {67, 48, 48}, {63, 42, 44}, {58, 35, 38}, 
 {60, 41, 45}, {64, 46, 45}, {76, 56, 50}, {80, 60, 53}, 
 {92, 66, 57}, {96, 70, 58}, {99, 77, 64}, {105, 84, 67}, 
 {114, 91, 71}, {118, 97, 79}, {121, 104, 84}, {123, 105, 82}, 
 {114, 101, 82}, {113, 96, 72}, {113, 89, 64}, {113, 81, 60}, 
 {108, 67, 51}, {102, 65, 52}, {88, 63, 53}, {79, 54, 49}, 
 {74, 48, 48}, {65, 46, 47}, {69, 46, 44}, {68, 41, 43}, 
 {70, 46, 46}, {73, 48, 49}, {77, 54, 52}, {77, 58, 54}, 
 {90, 70, 59}, {93, 76, 64}, {97, 85, 67}, {101, 93, 81}, 
 {115, 106, 87}, {125, 112, 97}, {141, 124, 97}, {147, 121, 104}, 
 {146, 120, 104}, {138, 114, 91}, {134, 109, 85}, {122, 96, 75}, 
 {111, 83, 66}, {106, 70, 62}, {102, 65, 53}, {92, 58, 51}, 
 {83, 49, 49}, {83, 48, 46}, {83, 54, 49}, {94, 66, 56}, 
 {99, 70, 54}, {103, 75, 58}, {108, 79, 63}, {113, 85, 64}, 
 {119, 90, 72}, {123, 98, 76}, {128, 102, 78}, {130, 107, 78}, 
 {131, 108, 79}, {132, 104, 79}, {131, 100, 79}, {135, 99, 73}, 
 {135, 98, 71}, {131, 100, 70}, {124, 94, 70}, {118, 91, 71}, 
 {114, 93, 70}, {105, 96, 69}, {105, 90, 67}, {105, 86, 64}, 
 {104, 81, 63}, {103, 75, 62}, {94, 73, 56}, {88, 72, 58}, 
 {85, 74, 59}, {92, 70, 60}, {87, 74, 60}, {96, 79, 62}, 
 {101, 87, 70}, {112, 102, 77}, {124, 107, 84}, {133, 108, 87}, 
 {143, 114, 92}, {148, 119, 99}, {149, 124, 104}, {149, 124, 106}, 
 {150, 131, 104}, {165, 140, 109}, {175, 148, 113}, {189, 164, 131}, 
 {199, 178, 144}, {202, 182, 160}, {209, 192, 178}, {214, 202, 191}, 
 {220, 210, 194}, {219, 207, 192}, {222, 204, 181}, {208, 192, 165}, 
 {196, 169, 138}, {184, 153, 118}, {176, 142, 104}, {165, 129, 92}, 
 {155, 115, 75}, {142, 110, 77}, {136, 108, 82}, {136, 108, 84}, 
 {134, 110, 84}, {134, 115, 87}, {136, 116, 90}, {146, 123, 95}, 
 {148, 126, 98}, {149, 127, 102}, {149, 125, 101}, {149, 127, 97}, 
 {150, 125, 99}, {148, 124, 97}, {140, 120, 92}, {136, 118, 86}, 
 {131, 118, 86}, {129, 109, 85}, {128, 108, 85}, {125, 108, 89}, 
 {126, 107, 97}, {131, 112, 95}, {140, 126, 101}, {153, 135, 112}, 
 {171, 147, 118}, {195, 164, 136}, {204, 177, 144}, {199, 179, 149}, 
 {201, 185, 160}, {199, 184, 162}, {182, 170, 153}, {172, 156, 140}, 
 {158, 148, 125}, {144, 139, 121}, {132, 125, 112}, {129, 121, 100}, 
 {124, 110, 92}, {112, 100, 84}, {104, 84, 68}, {100, 76, 67}, 
 {98, 75, 63}, {94, 76, 60}, {94, 76, 60}, {94, 73, 60}, 
 {102, 78, 61}, {111, 81, 65}, {113, 89, 65}, {123, 93, 71}, 
 {128, 101, 78}, {132, 108, 80}, {133, 108, 84}, {130, 109, 80}, 
 {123, 102, 78}, {117, 101, 75}, {112, 94, 71}, {106, 86, 67}, 
 {106, 82, 65}, {109, 82, 60}, {111, 84, 57}, {113, 84, 57}, 
 {118, 88, 57}, {121, 92, 64}, {125, 98, 69}, {129, 106, 74}, 
 {132, 109, 79}, {143, 119, 82}, {162, 125, 87}, {168, 133, 95}, 
 {162, 140, 115}, {158, 144, 132}, {156, 152, 147}, {155, 152, 150}, 
 {161, 159, 156}, {183, 168, 159}, {188, 174, 151}, {190, 171, 145}, 
 {194, 170, 143}, {193, 173, 146}, {193, 167, 145}, {188, 163, 138}, 
 {180, 155, 124}, {162, 140, 118}, {148, 123, 100}, {137, 106, 85}, 
 {130, 99, 76}, {123, 94, 68}, {124, 91, 62}, {121, 89, 64}, 
 {123, 91, 64}, {126, 94, 69}, {131, 97, 75}, {128, 98, 75}, 
 {123, 96, 72}, {117, 94, 66}, {117, 92, 65}, {111, 89, 63}, 
 {102, 83, 63}, {90, 75, 60}, {84, 66, 59}, {79, 55, 55}, 
 {72, 49, 52}, {71, 46, 48}, {72, 46, 48}, {75, 50, 48}, 
 {79, 54, 52}, {92, 62, 53}, {99, 67, 54}, {109, 75, 59}, 
 {122, 79, 55}, {126, 89, 63}, {132, 94, 67}, {136, 97, 67}, 
 {138, 102, 70}, {135, 106, 80}, {139, 114, 91}, {152, 126, 96}, 
 {163, 130, 101}, {159, 134, 104}, {162, 141, 109}, {168, 136, 101}, 
 {152, 132, 103}, {151, 123, 95}, {142, 115, 83}, {138, 108, 78}, 
 },
   /* daffodil */
{{17, 0, 0}, {54, 34, 22}, {92, 62, 28}, {128, 122, 46}, 
 {214, 134, 0}, {248, 152, 0}, {242, 157, 5}, {225, 157, 5}, 
 {172, 143, 56}, {133, 110, 56}, {90, 90, 51}, {65, 65, 46}, 
 {66, 54, 43}, {54, 54, 47}, {37, 51, 45}, {34, 49, 34}, 
 {34, 60, 28}, {39, 52, 36}, {34, 45, 28}, {51, 51, 30}, 
 {49, 49, 32}, {54, 49, 32}, {49, 45, 26}, {45, 39, 17}, 
 {34, 28, 11}, {22, 22, 11}, {17, 17, 11}, {17, 17, 5}, 
 {17, 5, 5}, {11, 5, 11}, {5, 11, 11}, {5, 5, 5}, 
 {5, 0, 0}, {5, 0, 0}, {11, 5, 5}, {11, 5, 5}, 
 {11, 5, 5}, {11, 5, 5}, {11, 5, 0}, {11, 5, 5}, 
 {11, 0, 0}, {11, 0, 0}, {17, 0, 0}, {17, 5, 0}, 
 {28, 5, 5}, {47, 22, 11}, {75, 43, 20}, {114, 83, 46}, 
 {186, 134, 50}, {239, 146, 11}, {254, 146, 0}, {237, 152, 5}, 
 {210, 135, 28}, {114, 101, 43}, {68, 66, 22}, {54, 60, 32}, 
 {45, 56, 34}, {51, 60, 28}, {51, 54, 28}, {47, 51, 24}, 
 {54, 49, 15}, {54, 49, 11}, {51, 28, 5}, {43, 26, 0}, 
 {28, 22, 0}, {22, 17, 0}, {28, 34, 0}, {30, 45, 15}, 
 {43, 41, 15}, {45, 45, 22}, {49, 45, 22}, {51, 45, 22}, 
 {47, 37, 22}, {45, 39, 22}, {32, 32, 20}, {28, 17, 17}, 
 {22, 11, 11}, {17, 11, 11}, {17, 11, 11}, {17, 17, 17}, 
 {17, 17, 17}, {17, 22, 17}, {17, 20, 15}, {17, 22, 5}, 
 {17, 17, 0}, {17, 11, 0}, {17, 5, 5}, {22, 11, 5}, 
 {24, 9, 9}, {28, 17, 11}, {34, 22, 11}, {41, 28, 17}, 
 {45, 39, 22}, {51, 53, 29}, {68, 62, 34}, {101, 78, 56}, 
 {155, 116, 65}, {220, 151, 73}, {242, 157, 39}, {254, 186, 39}, 
 {248, 203, 33}, {248, 191, 27}, {248, 163, 11}, {254, 134, 0}, 
 {254, 129, 0}, {212, 95, 0}, {127, 62, 28}, {77, 59, 25}, 
 {60, 58, 32}, {60, 63, 35}, {68, 79, 45}, {85, 93, 59}, 
 {96, 96, 56}, {103, 81, 92}, {82, 124, 147}, {60, 111, 139}, 
 {45, 73, 131}, {49, 83, 83}, {51, 62, 68}, {58, 52, 52}, 
 {49, 43, 43}, {35, 36, 36}, {34, 34, 22}, {22, 22, 20}, 
 {22, 22, 26}, {22, 17, 26}, {22, 17, 17}, {22, 17, 11}, 
 {22, 22, 17}, {22, 22, 17}, {26, 32, 20}, {28, 34, 22}, 
 {34, 45, 26}, {49, 49, 37}, {56, 56, 49}, {77, 71, 66}, 
 {109, 112, 92}, {120, 160, 159}, {180, 186, 180}, {218, 224, 190}, 
 {239, 233, 205}, {207, 218, 178}, {158, 168, 123}, {127, 155, 96}, 
 {107, 113, 90}, {66, 77, 66}, {54, 79, 54}, {49, 69, 49}, 
 {56, 68, 36}, {39, 72, 48}, {49, 86, 63}, {90, 102, 79}, 
 {139, 133, 94}, {179, 179, 122}, {237, 214, 157}, {246, 235, 189}, 
 {248, 225, 163}, {248, 208, 129}, {248, 208, 73}, {254, 197, 44}, 
 {254, 197, 44}, {248, 185, 56}, {208, 180, 73}, {189, 155, 59}, 
 {152, 141, 79}, {127, 138, 73}, {138, 144, 67}, {135, 141, 79}, 
 {150, 156, 94}, {177, 148, 103}, {214, 180, 118}, {246, 217, 161}, 
 {244, 198, 159}, {246, 229, 178}, {254, 237, 180}, {254, 237, 180}, 
 {246, 223, 172}, {171, 191, 142}, {147, 152, 118}, {147, 141, 107}, 
 {135, 141, 107}, {149, 131, 104}, {158, 141, 108}, {152, 141, 118}, 
 {156, 154, 128}, {188, 165, 154}, {231, 208, 169}, {248, 226, 186}, 
 {248, 226, 197}, {208, 225, 197}, {175, 179, 152}, {151, 145, 117}, 
 {119, 124, 96}, {86, 100, 66}, {62, 85, 51}, {45, 71, 22}, 
 {49, 64, 26}, {60, 69, 25}, {101, 87, 50}, {145, 113, 56}, 
 {214, 135, 28}, {248, 163, 16}, {248, 169, 22}, {254, 174, 16}, 
 {254, 180, 11}, {254, 180, 16}, {242, 174, 11}, {254, 168, 5}, 
 {254, 157, 0}, {254, 151, 0}, {254, 157, 0}, {254, 174, 0}, 
 {254, 186, 0}, {254, 191, 16}, {242, 197, 28}, {196, 178, 60}, 
 {152, 130, 68}, {113, 124, 59}, {100, 100, 56}, {68, 79, 59}, 
 {53, 60, 39}, {49, 37, 32}, {39, 28, 22}, {34, 17, 17}, 
 {28, 22, 17}, {34, 22, 11}, {34, 32, 11}, {49, 37, 15}, 
 {56, 39, 28}, {60, 47, 32}, {77, 57, 31}, {90, 80, 48}, 
 {107, 116, 65}, {164, 118, 84}, {188, 148, 109}, {197, 152, 107}, 
 {231, 197, 129}, {197, 174, 95}, {158, 152, 95}, {133, 121, 65}, 
 {111, 82, 71}, {90, 60, 54}, {92, 75, 47}, {110, 70, 42}, 
 {132, 88, 50}, {186, 112, 50}, {220, 129, 28}, {224, 117, 22}, 
 {180, 95, 28}, {102, 60, 34}, {60, 60, 20}, {43, 52, 15}, 
 {26, 43, 5}, {17, 31, 0}, {11, 28, 5}, {28, 22, 17}, 
 },
   /* rose */
{{113, 33, 37}, {84, 23, 37}, {55, 27, 28}, {36, 40, 18}, 
 {32, 56, 9}, {60, 77, 18}, {56, 101, 27}, {60, 81, 28}, 
 {52, 89, 18}, {48, 85, 28}, {40, 68, 28}, {40, 56, 28}, 
 {40, 52, 28}, {76, 30, 28}, {105, 18, 18}, {121, 22, 19}, 
 {125, 21, 28}, {105, 22, 28}, {84, 19, 28}, {56, 23, 28}, 
 {36, 36, 28}, {32, 40, 28}, {28, 36, 18}, {28, 32, 18}, 
 {27, 32, 9}, {48, 27, 9}, {77, 22, 9}, {101, 15, 9}, 
 {137, 14, 9}, {150, 21, 19}, {162, 28, 38}, {178, 38, 57}, 
 {166, 35, 86}, {166, 39, 86}, {178, 44, 86}, {178, 47, 95}, 
 {174, 68, 113}, {170, 182, 170}, {177, 190, 188}, {181, 198, 179}, 
 {166, 170, 160}, {182, 52, 105}, {198, 44, 96}, {166, 31, 86}, 
 {154, 30, 67}, {146, 29, 47}, {129, 25, 28}, {101, 22, 18}, 
 {68, 22, 18}, {52, 23, 18}, {36, 36, 18}, {28, 36, 18}, 
 {32, 44, 18}, {36, 48, 18}, {40, 56, 28}, {52, 60, 28}, 
 {52, 73, 28}, {64, 73, 28}, {101, 26, 28}, {125, 25, 28}, 
 {141, 22, 28}, {129, 18, 28}, {109, 21, 28}, {76, 26, 28}, 
 {48, 52, 37}, {60, 72, 28}, {73, 97, 47}, {77, 109, 85}, 
 {92, 133, 122}, {100, 133, 132}, {96, 133, 131}, {85, 113, 85}, 
 {93, 96, 47}, {93, 117, 47}, {113, 108, 37}, {125, 63, 47}, 
 {141, 29, 38}, {146, 25, 28}, {146, 22, 28}, {146, 25, 38}, 
 {146, 25, 57}, {150, 26, 66}, {158, 30, 76}, {158, 35, 86}, 
 {162, 27, 86}, {166, 27, 86}, {158, 34, 76}, {153, 34, 57}, 
 {141, 29, 47}, {121, 33, 37}, {76, 59, 37}, {48, 60, 37}, 
 {28, 56, 28}, {28, 40, 18}, {20, 28, 18}, {20, 24, 18}, 
 {23, 24, 18}, {24, 32, 28}, {28, 36, 37}, {40, 39, 37}, 
 {64, 23, 28}, {101, 22, 28}, {141, 19, 38}, {146, 22, 47}, 
 {150, 21, 47}, {158, 26, 57}, {150, 22, 47}, {150, 21, 57}, 
 {146, 22, 47}, {141, 18, 38}, {137, 21, 28}, {137, 22, 28}, 
 {133, 21, 28}, {133, 21, 18}, {113, 18, 9}, {133, 20, 18}, 
 {141, 21, 19}, {146, 21, 28}, {150, 21, 28}, {154, 28, 28}, 
 {158, 24, 28}, {150, 28, 28}, {154, 28, 38}, {166, 33, 48}, 
 {166, 25, 48}, {154, 22, 47}, {158, 30, 57}, {162, 31, 67}, 
 {162, 43, 76}, {157, 140, 56}, {129, 170, 103}, {166, 186, 169}, 
 {181, 189, 198}, {173, 189, 207}, {169, 185, 188}, {154, 170, 170}, 
 {182, 52, 133}, {178, 44, 115}, {178, 40, 105}, {182, 56, 114}, 
 {150, 170, 160}, {165, 186, 188}, {165, 185, 188}, {112, 158, 160}, 
 {104, 133, 113}, {76, 113, 75}, {85, 92, 47}, {133, 30, 38}, 
 {150, 29, 28}, {158, 28, 28}, {158, 29, 28}, {170, 25, 28}, 
 {166, 37, 38}, {157, 30, 48}, {150, 26, 57}, {146, 22, 66}, 
 {150, 34, 67}, {150, 33, 57}, {150, 25, 47}, {146, 22, 47}, 
 {146, 19, 38}, {137, 21, 28}, {109, 21, 28}, {72, 19, 28}, 
 {48, 27, 28}, {43, 40, 37}, {36, 44, 28}, {36, 52, 28}, 
 {48, 60, 37}, {52, 77, 37}, {52, 81, 47}, {60, 77, 56}, 
 {60, 85, 56}, {77, 109, 66}, {77, 125, 65}, {77, 133, 56}, 
 {93, 141, 46}, {101, 146, 66}, {93, 133, 74}, {81, 129, 83}, 
 {105, 137, 75}, {109, 162, 94}, {113, 158, 84}, {121, 162, 85}, 
 {142, 154, 66}, {113, 141, 75}, {109, 129, 56}, {101, 121, 47}, 
 {109, 137, 47}, {97, 121, 37}, {81, 117, 37}, {73, 97, 28}, 
 {81, 93, 18}, {109, 25, 28}, {129, 25, 28}, {141, 25, 28}, 
 {141, 22, 28}, {141, 22, 28}, {141, 21, 28}, {137, 21, 37}, 
 {93, 19, 28}, {68, 19, 28}, {51, 19, 28}, {24, 24, 37}, 
 {23, 24, 28}, {24, 24, 18}, {24, 24, 18}, {27, 24, 18}, 
 {28, 24, 18}, {47, 23, 28}, {63, 23, 28}, {88, 19, 28}, 
 {121, 18, 19}, {133, 24, 19}, {146, 21, 28}, {146, 21, 28}, 
 {146, 21, 28}, {146, 18, 28}, {146, 18, 28}, {146, 18, 28}, 
 {146, 17, 28}, {146, 18, 28}, {146, 21, 28}, {146, 21, 19}, 
 {146, 21, 19}, {146, 17, 19}, {141, 21, 19}, {141, 21, 19}, 
 {141, 21, 19}, {133, 21, 19}, {129, 21, 19}, {109, 18, 18}, 
 {80, 26, 18}, {56, 27, 18}, {32, 32, 18}, {28, 28, 18}, 
 {32, 32, 18}, {56, 19, 18}, {80, 19, 18}, {113, 22, 28}, 
 {146, 26, 57}, {154, 34, 67}, {161, 51, 85}, {107, 133, 132}, 
 {150, 174, 170}, {165, 186, 179}, {154, 174, 170}, {124, 154, 122}, 
 {170, 55, 85}, {174, 39, 67}, {182, 55, 66}, {170, 37, 47}, 
 {158, 32, 38}, {145, 26, 38}, {125, 25, 28}, {68, 23, 28}, 
 },
   /* healthy-skin */
{{250, 225, 235}, {194, 165, 188}, {157, 133, 141}, {137, 100, 94}, 
 {96, 60, 47}, {72, 43, 28}, {60, 35, 28}, {52, 23, 18}, 
 {35, 16, 9}, {35, 16, 9}, {35, 16, 9}, {32, 8, 0}, 
 {31, 12, 9}, {24, 12, 9}, {35, 16, 18}, {40, 19, 28}, 
 {56, 27, 28}, {80, 39, 47}, {113, 64, 65}, {141, 84, 75}, 
 {166, 95, 85}, {182, 107, 94}, {186, 107, 94}, {190, 111, 94}, 
 {186, 111, 94}, {182, 111, 85}, {154, 92, 66}, {141, 88, 47}, 
 {105, 68, 46}, {81, 51, 18}, {56, 27, 18}, {52, 23, 9}, 
 {35, 16, 18}, {27, 12, 18}, {24, 8, 18}, {0, 0, 0}, 
 {0, 0, 0}, {24, 4, 18}, {35, 8, 18}, {44, 12, 18}, 
 {44, 20, 18}, {44, 19, 18}, {40, 12, 18}, {52, 19, 18}, 
 {52, 19, 28}, {40, 16, 28}, {35, 12, 28}, {39, 16, 28}, 
 {52, 23, 28}, {56, 27, 28}, {68, 39, 28}, {76, 48, 47}, 
 {101, 64, 65}, {133, 100, 84}, {158, 112, 94}, {186, 119, 94}, 
 {198, 136, 113}, {206, 152, 132}, {210, 157, 141}, {226, 161, 160}, 
 {238, 164, 160}, {238, 180, 169}, {246, 184, 169}, {250, 184, 169}, 
 {246, 180, 159}, {242, 172, 150}, {250, 160, 141}, {242, 152, 122}, 
 {242, 148, 122}, {234, 144, 113}, {234, 144, 122}, {222, 145, 132}, 
 {214, 149, 132}, {214, 149, 122}, {219, 149, 122}, {210, 165, 132}, 
 {219, 165, 141}, {234, 172, 150}, {238, 176, 150}, {238, 176, 150}, 
 {246, 176, 140}, {250, 164, 141}, {242, 160, 131}, {234, 156, 113}, 
 {234, 144, 103}, {219, 128, 94}, {214, 123, 85}, {210, 119, 94}, 
 {214, 124, 103}, {226, 140, 113}, {238, 152, 131}, {238, 164, 141}, 
 {238, 164, 150}, {234, 160, 150}, {238, 156, 141}, {242, 148, 141}, 
 {219, 141, 132}, {210, 136, 122}, {198, 119, 104}, {194, 119, 103}, 
 {182, 103, 94}, {174, 103, 85}, {170, 95, 75}, {166, 88, 85}, 
 {150, 88, 85}, {149, 92, 75}, {146, 96, 85}, {141, 88, 75}, 
 {121, 76, 65}, {96, 60, 56}, {84, 52, 47}, {80, 47, 37}, 
 {84, 51, 28}, {92, 60, 37}, {113, 60, 47}, {137, 84, 56}, 
 {166, 95, 75}, {182, 115, 85}, {186, 128, 104}, {206, 157, 132}, 
 {222, 165, 151}, {238, 184, 169}, {246, 197, 206}, {246, 213, 244}, 
 {234, 226, 254}, {242, 226, 244}, {214, 202, 207}, {219, 169, 160}, 
 {214, 149, 132}, {219, 145, 122}, {210, 137, 113}, {214, 128, 113}, 
 {210, 120, 104}, {202, 124, 103}, {206, 128, 113}, {198, 119, 104}, 
 {194, 107, 94}, {178, 99, 85}, {158, 84, 75}, {154, 80, 75}, 
 {137, 68, 66}, {125, 68, 65}, {125, 64, 56}, {137, 72, 56}, 
 {146, 84, 56}, {158, 107, 75}, {166, 111, 85}, {182, 128, 103}, 
 {202, 153, 141}, {222, 185, 169}, {246, 209, 188}, {246, 222, 244}, 
 {250, 226, 244}, {246, 221, 244}, {230, 205, 225}, {206, 202, 198}, 
 {226, 185, 179}, {238, 184, 169}, {234, 172, 150}, {210, 161, 122}, 
 {210, 141, 113}, {190, 111, 94}, {170, 103, 85}, {146, 84, 75}, 
 {117, 60, 56}, {96, 47, 47}, {80, 43, 37}, {72, 39, 37}, 
 {76, 43, 47}, {96, 60, 47}, {113, 76, 56}, {141, 92, 66}, 
 {162, 116, 94}, {182, 140, 113}, {190, 161, 150}, {198, 157, 179}, 
 {206, 169, 179}, {210, 173, 170}, {206, 160, 151}, {194, 153, 151}, 
 {194, 148, 151}, {166, 133, 122}, {149, 120, 113}, {129, 104, 103}, 
 {125, 100, 103}, {101, 80, 84}, {84, 56, 47}, {80, 56, 37}, 
 {88, 47, 37}, {101, 56, 47}, {121, 72, 56}, {154, 88, 66}, 
 {186, 115, 94}, {202, 145, 132}, {218, 161, 160}, {230, 172, 169}, 
 {226, 181, 188}, {205, 185, 207}, {202, 185, 198}, {178, 174, 170}, 
 {161, 137, 141}, {133, 112, 113}, {129, 84, 84}, {100, 68, 56}, 
 {84, 51, 47}, {72, 39, 37}, {72, 39, 28}, {80, 43, 28}, 
 {92, 64, 47}, {117, 88, 75}, {133, 112, 94}, {170, 128, 103}, 
 {186, 157, 141}, {186, 165, 151}, {186, 157, 160}, {169, 149, 160}, 
 {170, 137, 132}, {170, 120, 104}, {178, 111, 94}, {186, 107, 94}, 
 {194, 107, 85}, {198, 111, 85}, {186, 115, 85}, {178, 111, 85}, 
 {178, 107, 85}, {178, 95, 56}, {149, 63, 37}, {101, 52, 47}, 
 {84, 39, 37}, {72, 31, 28}, {72, 27, 28}, {60, 27, 28}, 
 {48, 31, 28}, {56, 31, 28}, {68, 35, 28}, {68, 35, 28}, 
 {80, 39, 28}, {89, 56, 37}, {113, 76, 56}, {137, 96, 75}, 
 {157, 120, 94}, {178, 140, 103}, {202, 153, 132}, {198, 149, 141}, 
 {198, 145, 132}, {198, 128, 104}, {194, 119, 94}, {174, 103, 85}, 
 {146, 104, 85}, {145, 100, 85}, {145, 104, 85}, {153, 112, 103}, 
 {170, 112, 103}, {194, 119, 94}, {214, 132, 94}, {230, 140, 103}, 
 },
   /* orange */
{{123, 106, 57}, {97, 100, 60}, {91, 83, 58}, {70, 74, 54}, 
 {70, 71, 53}, {59, 68, 51}, {59, 56, 32}, {54, 61, 44}, 
 {57, 72, 57}, {67, 74, 62}, {81, 97, 76}, {95, 114, 91}, 
 {109, 114, 82}, {115, 113, 84}, {112, 120, 98}, {128, 131, 98}, 
 {130, 137, 106}, {134, 142, 106}, {150, 151, 107}, {149, 150, 114}, 
 {149, 152, 123}, {148, 156, 135}, {170, 161, 127}, {188, 121, 129}, 
 {228, 101, 100}, {234, 92, 73}, {224, 66, 57}, {195, 72, 57}, 
 {121, 65, 36}, {86, 54, 32}, {75, 73, 38}, {29, 34, 39}, 
 {54, 52, 52}, {53, 57, 62}, {60, 78, 68}, {63, 69, 77}, 
 {64, 89, 73}, {84, 105, 77}, {84, 114, 95}, {98, 122, 108}, 
 {120, 143, 125}, {132, 158, 138}, {138, 165, 137}, {139, 162, 137}, 
 {154, 153, 159}, {178, 155, 163}, {176, 154, 155}, {183, 159, 157}, 
 {187, 171, 130}, {169, 174, 143}, {165, 183, 130}, {170, 171, 138}, 
 {175, 179, 129}, {159, 175, 124}, {155, 156, 122}, {143, 142, 110}, 
 {131, 129, 116}, {125, 128, 116}, {127, 121, 131}, {119, 119, 134}, 
 {115, 118, 132}, {121, 139, 133}, {123, 138, 124}, {124, 141, 130}, 
 {136, 154, 141}, {140, 148, 158}, {131, 149, 158}, {91, 155, 182}, 
 {100, 132, 171}, {83, 129, 184}, {82, 128, 193}, {85, 149, 207}, 
 {93, 183, 236}, {113, 192, 242}, {137, 196, 237}, {127, 191, 237}, 
 {119, 187, 234}, {114, 170, 214}, {109, 156, 197}, {144, 153, 173}, 
 {153, 147, 160}, {169, 161, 168}, {175, 185, 189}, {158, 196, 225}, 
 {143, 193, 219}, {161, 186, 214}, {179, 185, 193}, {199, 168, 158}, 
 {225, 119, 116}, {235, 102, 114}, {230, 100, 108}, {217, 112, 120}, 
 {176, 143, 147}, {141, 135, 141}, {113, 145, 147}, {95, 128, 153}, 
 {103, 125, 146}, {112, 129, 127}, {122, 133, 106}, {135, 148, 97}, 
 {144, 134, 85}, {163, 136, 81}, {160, 143, 93}, {198, 163, 73}, 
 {220, 178, 61}, {213, 162, 67}, {201, 149, 50}, {161, 119, 68}, 
 {186, 108, 93}, {166, 138, 99}, {152, 149, 140}, {156, 158, 164}, 
 {142, 180, 213}, {138, 181, 225}, {117, 187, 236}, {90, 177, 233}, 
 {83, 153, 201}, {111, 136, 164}, {136, 113, 115}, {187, 103, 92}, 
 {236, 100, 67}, {228, 75, 48}, {247, 68, 36}, {248, 69, 32}, 
 {241, 64, 42}, {233, 68, 41}, {218, 64, 51}, {136, 85, 64}, 
 {96, 85, 68}, {100, 103, 79}, {91, 100, 77}, {106, 99, 68}, 
 {121, 113, 71}, {136, 148, 79}, {147, 152, 81}, {158, 154, 91}, 
 {191, 168, 101}, {200, 179, 97}, {190, 173, 101}, {185, 175, 112}, 
 {177, 194, 115}, {172, 183, 132}, {175, 191, 149}, {149, 177, 132}, 
 {136, 156, 131}, {125, 139, 122}, {107, 132, 119}, {97, 119, 102}, 
 {89, 109, 92}, {84, 92, 72}, {75, 75, 66}, {79, 80, 73}, 
 {76, 91, 73}, {77, 106, 93}, {76, 101, 107}, {92, 121, 107}, 
 {98, 125, 119}, {112, 148, 137}, {139, 170, 156}, {150, 187, 213}, 
 {144, 193, 230}, {145, 192, 228}, {146, 191, 222}, {167, 180, 181}, 
 {158, 185, 154}, {157, 177, 121}, {155, 160, 89}, {158, 168, 78}, 
 {172, 175, 93}, {186, 158, 73}, {186, 158, 73}, {181, 153, 84}, 
 {151, 157, 88}, {133, 154, 91}, {130, 151, 99}, {132, 147, 98}, 
 {126, 139, 105}, {123, 129, 103}, {106, 111, 96}, {84, 95, 105}, 
 {74, 81, 89}, {71, 64, 92}, {77, 73, 81}, {90, 101, 83}, 
 {96, 100, 90}, {105, 105, 97}, {115, 114, 97}, {117, 122, 95}, 
 {134, 137, 83}, {136, 138, 55}, {150, 126, 52}, {110, 118, 59}, 
 {85, 107, 55}, {89, 96, 60}, {76, 76, 53}, {68, 67, 37}, 
 {72, 73, 59}, {90, 87, 73}, {115, 107, 86}, {144, 110, 76}, 
 {150, 121, 87}, {152, 123, 95}, {139, 140, 106}, {132, 144, 123}, 
 {141, 151, 150}, {162, 158, 160}, {169, 178, 175}, {185, 199, 218}, 
 {191, 205, 221}, {185, 202, 221}, {185, 195, 212}, {189, 197, 144}, 
 {194, 177, 136}, {213, 196, 90}, {220, 182, 64}, {208, 164, 76}, 
 {238, 106, 91}, {236, 103, 85}, {240, 88, 83}, {239, 80, 72}, 
 {239, 82, 57}, {236, 68, 52}, {246, 65, 43}, {245, 63, 26}, 
 {244, 67, 16}, {244, 78, 17}, {244, 82, 23}, {243, 76, 23}, 
 {247, 69, 28}, {243, 74, 28}, {244, 72, 44}, {238, 86, 55}, 
 {243, 75, 60}, {225, 84, 71}, {159, 92, 97}, {124, 125, 103}, 
 {113, 117, 105}, {92, 113, 100}, {95, 113, 101}, {106, 111, 113}, 
 {107, 115, 109}, {110, 115, 99}, {117, 123, 90}, {119, 123, 75}, 
 {134, 122, 81}, {130, 128, 71}, {132, 142, 75}, {155, 155, 94}, 
 {163, 164, 121}, {160, 152, 148}, {130, 165, 160}, {107, 163, 204}, 
 {94, 183, 235}, {96, 188, 238}, {106, 180, 234}, {126, 172, 209}, 
 },
   /* white-ivy */
{{242, 242, 254}, {208, 231, 197}, {163, 197, 152}, {141, 175, 118}, 
 {107, 152, 73}, {96, 147, 51}, {79, 124, 45}, {79, 107, 28}, 
 {85, 107, 22}, {96, 124, 39}, {107, 147, 62}, {113, 164, 96}, 
 {135, 169, 135}, {152, 203, 152}, {178, 212, 178}, {208, 231, 197}, 
 {220, 242, 225}, {212, 246, 246}, {208, 237, 254}, {197, 242, 254}, 
 {169, 233, 225}, {169, 220, 186}, {152, 208, 163}, {152, 203, 152}, 
 {163, 186, 152}, {146, 163, 158}, {156, 156, 156}, {144, 158, 158}, 
 {135, 152, 124}, {118, 152, 118}, {101, 130, 113}, {82, 82, 82}, 
 {58, 32, 32}, {56, 28, 28}, {84, 84, 39}, {96, 113, 33}, 
 {107, 130, 22}, {118, 152, 28}, {141, 175, 34}, {135, 175, 67}, 
 {113, 164, 90}, {118, 152, 101}, {112, 141, 112}, {101, 137, 112}, 
 {101, 135, 101}, {96, 130, 96}, {84, 118, 84}, {67, 113, 62}, 
 {56, 107, 51}, {56, 107, 45}, {68, 102, 34}, {73, 124, 51}, 
 {79, 118, 79}, {107, 141, 96}, {130, 164, 124}, {158, 180, 141}, 
 {186, 186, 169}, {214, 220, 208}, {239, 239, 239}, {246, 246, 246}, 
 {254, 254, 254}, {254, 254, 254}, {242, 254, 254}, {242, 248, 254}, 
 {237, 242, 248}, {231, 242, 242}, {220, 237, 203}, {214, 208, 118}, 
 {163, 197, 56}, {169, 163, 28}, {147, 169, 50}, {141, 158, 84}, 
 {118, 164, 118}, {113, 169, 118}, {107, 158, 118}, {73, 141, 101}, 
 {45, 128, 56}, {34, 85, 34}, {28, 73, 28}, {28, 77, 28}, 
 {45, 90, 56}, {84, 118, 84}, {118, 152, 118}, {152, 180, 152}, 
 {175, 203, 175}, {197, 231, 208}, {208, 231, 254}, {208, 231, 254}, 
 {208, 220, 254}, {206, 214, 197}, {192, 169, 169}, {171, 180, 175}, 
 {174, 208, 174}, {180, 209, 180}, {197, 231, 191}, {220, 237, 214}, 
 {237, 242, 237}, {246, 246, 246}, {254, 254, 254}, {254, 254, 254}, 
 {254, 254, 254}, {242, 254, 254}, {242, 254, 254}, {242, 248, 254}, 
 {237, 237, 248}, {225, 225, 225}, {231, 163, 163}, {150, 112, 112}, 
 {96, 84, 79}, {82, 82, 82}, {56, 96, 56}, {50, 92, 45}, 
 {34, 85, 28}, {39, 90, 39}, {73, 115, 73}, {124, 135, 101}, 
 {158, 175, 129}, {163, 186, 163}, {186, 209, 186}, {208, 214, 254}, 
 {208, 225, 254}, {208, 208, 254}, {174, 208, 197}, {152, 192, 152}, 
 {118, 152, 118}, {84, 124, 79}, {62, 101, 56}, {28, 73, 28}, 
 {5, 51, 0}, {34, 0, 0}, {0, 52, 0}, {0, 51, 0}, 
 {0, 52, 0}, {11, 62, 5}, {28, 79, 22}, {28, 73, 28}, 
 {56, 83, 11}, {68, 68, 0}, {45, 51, 0}, {73, 96, 28}, 
 {84, 101, 33}, {90, 102, 28}, {79, 130, 51}, {90, 143, 112}, 
 {90, 175, 118}, {152, 203, 152}, {163, 209, 186}, {186, 220, 254}, 
 {208, 225, 254}, {220, 220, 254}, {220, 220, 254}, {220, 225, 254}, 
 {220, 231, 254}, {220, 231, 254}, {231, 231, 254}, {231, 231, 254}, 
 {231, 231, 254}, {231, 242, 254}, {220, 254, 254}, {208, 254, 254}, 
 {208, 254, 254}, {197, 254, 254}, {208, 254, 254}, {220, 254, 254}, 
 {231, 248, 254}, {231, 237, 254}, {231, 231, 254}, {231, 231, 254}, 
 {231, 231, 254}, {231, 237, 254}, {231, 242, 254}, {231, 242, 254}, 
 {231, 242, 254}, {231, 242, 254}, {231, 237, 254}, {231, 231, 254}, 
 {231, 231, 254}, {220, 237, 254}, {220, 237, 254}, {197, 254, 254}, 
 {163, 254, 254}, {140, 191, 197}, {152, 175, 152}, {152, 158, 129}, 
 {124, 130, 90}, {107, 67, 62}, {124, 34, 34}, {137, 45, 45}, 
 {153, 51, 51}, {153, 51, 51}, {175, 95, 67}, {141, 141, 112}, 
 {135, 152, 124}, {141, 163, 135}, {152, 186, 152}, {152, 203, 152}, 
 {152, 203, 152}, {163, 208, 163}, {191, 225, 191}, {231, 231, 231}, 
 {220, 231, 254}, {220, 225, 254}, {220, 225, 254}, {231, 231, 254}, 
 {242, 242, 254}, {242, 242, 254}, {242, 248, 254}, {242, 254, 254}, 
 {254, 254, 254}, {254, 254, 254}, {254, 254, 254}, {242, 248, 254}, 
 {242, 242, 254}, {231, 242, 254}, {231, 242, 254}, {231, 242, 254}, 
 {231, 242, 231}, {231, 225, 175}, {220, 214, 135}, {254, 169, 140}, 
 {208, 197, 118}, {208, 191, 112}, {163, 191, 107}, {107, 152, 73}, 
 {96, 147, 51}, {90, 141, 51}, {90, 135, 39}, {85, 136, 51}, 
 {96, 141, 45}, {101, 147, 45}, {118, 141, 62}, {135, 129, 78}, 
 {135, 158, 107}, {146, 192, 101}, {146, 197, 112}, {152, 197, 135}, 
 {152, 203, 152}, {186, 214, 186}, {208, 242, 231}, {220, 237, 254}, 
 {231, 242, 254}, {242, 242, 254}, {242, 242, 254}, {242, 242, 254}, 
 {242, 242, 254}, {242, 248, 254}, {231, 254, 254}, {231, 254, 254}, 
 {231, 242, 254}, {237, 237, 248}, {214, 237, 220}, {186, 220, 180}, 
 {152, 203, 152}, {141, 192, 84}, {118, 164, 45}, {96, 124, 28}, 
 },
   /* summer-makeup */
{{238, 193, 141}, {238, 192, 141}, {238, 192, 141}, {234, 193, 141}, 
 {234, 193, 141}, {234, 193, 141}, {230, 193, 141}, {230, 189, 141}, 
 {226, 189, 141}, {226, 193, 141}, {234, 193, 141}, {238, 197, 141}, 
 {238, 201, 141}, {234, 197, 150}, {234, 193, 150}, {234, 197, 150}, 
 {230, 193, 150}, {226, 189, 141}, {222, 185, 132}, {219, 177, 113}, 
 {210, 144, 85}, {219, 106, 75}, {219, 95, 66}, {190, 63, 37}, 
 {150, 64, 28}, {145, 47, 28}, {133, 51, 37}, {101, 43, 28}, 
 {84, 51, 37}, {80, 52, 37}, {80, 56, 37}, {80, 60, 47}, 
 {89, 72, 56}, {109, 84, 56}, {125, 104, 66}, {166, 107, 66}, 
 {198, 136, 75}, {219, 161, 94}, {222, 180, 103}, {226, 193, 122}, 
 {226, 189, 122}, {222, 180, 113}, {219, 169, 103}, {198, 140, 85}, 
 {178, 115, 66}, {158, 99, 56}, {158, 88, 47}, {158, 88, 56}, 
 {166, 107, 56}, {186, 119, 66}, {202, 140, 94}, {219, 173, 103}, 
 {230, 180, 113}, {230, 180, 122}, {226, 180, 122}, {219, 165, 113}, 
 {202, 140, 94}, {162, 103, 66}, {125, 80, 56}, {113, 72, 46}, 
 {89, 60, 37}, {76, 52, 37}, {64, 48, 37}, {52, 39, 28}, 
 {40, 35, 28}, {36, 36, 28}, {32, 36, 37}, {36, 36, 37}, 
 {40, 35, 37}, {48, 40, 37}, {52, 39, 37}, {48, 35, 37}, 
 {52, 40, 37}, {64, 48, 37}, {72, 52, 37}, {80, 60, 47}, 
 {96, 68, 56}, {97, 68, 56}, {100, 68, 56}, {97, 64, 56}, 
 {84, 56, 56}, {76, 48, 47}, {68, 47, 47}, {64, 48, 47}, 
 {68, 48, 47}, {76, 52, 47}, {84, 60, 47}, {101, 68, 56}, 
 {117, 84, 65}, {137, 88, 66}, {166, 103, 66}, {206, 136, 75}, 
 {210, 157, 85}, {222, 164, 94}, {214, 156, 85}, {202, 140, 85}, 
 {186, 123, 66}, {150, 103, 66}, {121, 88, 56}, {105, 76, 56}, 
 {88, 60, 47}, {76, 48, 47}, {64, 48, 37}, {56, 44, 37}, 
 {60, 48, 47}, {68, 48, 47}, {85, 60, 47}, {105, 80, 56}, 
 {137, 88, 66}, {154, 107, 75}, {194, 140, 85}, {214, 169, 113}, 
 {219, 177, 122}, {222, 180, 141}, {137, 145, 151}, {88, 104, 94}, 
 {76, 68, 66}, {81, 68, 65}, {80, 64, 56}, {76, 60, 56}, 
 {80, 56, 47}, {76, 52, 47}, {76, 52, 56}, {76, 52, 56}, 
 {68, 52, 56}, {56, 44, 56}, {48, 39, 47}, {48, 35, 47}, 
 {48, 35, 37}, {40, 35, 37}, {39, 32, 28}, {36, 32, 28}, 
 {36, 32, 28}, {36, 32, 28}, {32, 32, 28}, {31, 28, 28}, 
 {28, 32, 28}, {31, 32, 28}, {24, 32, 28}, {31, 28, 28}, 
 {32, 28, 28}, {35, 28, 37}, {36, 32, 37}, {36, 32, 37}, 
 {40, 31, 28}, {44, 35, 28}, {52, 36, 28}, {56, 39, 28}, 
 {52, 35, 37}, {60, 39, 37}, {52, 40, 37}, {48, 40, 37}, 
 {48, 48, 37}, {44, 40, 28}, {44, 36, 28}, {44, 36, 28}, 
 {48, 35, 28}, {56, 39, 28}, {64, 39, 28}, {88, 51, 37}, 
 {117, 72, 46}, {146, 80, 56}, {166, 111, 56}, {198, 136, 75}, 
 {214, 164, 94}, {219, 177, 113}, {222, 185, 132}, {226, 184, 141}, 
 {226, 189, 141}, {230, 193, 131}, {230, 197, 131}, {234, 192, 131}, 
 {230, 184, 131}, {222, 185, 132}, {230, 184, 131}, {230, 184, 131}, 
 {226, 189, 132}, {222, 189, 132}, {234, 188, 131}, {234, 184, 131}, 
 {230, 184, 122}, {222, 180, 113}, {219, 177, 103}, {210, 148, 85}, 
 {194, 132, 66}, {190, 106, 56}, {170, 95, 56}, {174, 91, 47}, 
 {194, 87, 28}, {194, 72, 28}, {154, 76, 37}, {129, 64, 37}, 
 {93, 51, 37}, {72, 43, 37}, {68, 43, 37}, {64, 48, 37}, 
 {60, 52, 37}, {68, 52, 37}, {89, 64, 47}, {113, 84, 56}, 
 {145, 100, 66}, {182, 127, 85}, {210, 165, 94}, {219, 181, 103}, 
 {234, 193, 112}, {234, 193, 122}, {234, 188, 122}, {222, 176, 113}, 
 {202, 148, 94}, {186, 119, 75}, {170, 103, 66}, {146, 92, 75}, 
 {137, 92, 75}, {149, 104, 75}, {174, 111, 75}, {186, 127, 85}, 
 {202, 144, 94}, {222, 169, 122}, {226, 180, 141}, {234, 193, 150}, 
 {234, 201, 160}, {234, 205, 169}, {234, 201, 160}, {230, 197, 150}, 
 {230, 189, 141}, {226, 180, 122}, {214, 161, 103}, {186, 135, 85}, 
 {153, 104, 84}, {129, 108, 84}, {121, 92, 75}, {121, 80, 65}, 
 {113, 76, 56}, {121, 72, 56}, {117, 72, 46}, {125, 68, 47}, 
 {125, 68, 56}, {109, 64, 56}, {109, 60, 46}, {88, 55, 47}, 
 {84, 43, 47}, {72, 43, 47}, {60, 44, 37}, {52, 44, 37}, 
 {44, 40, 37}, {40, 35, 28}, {36, 36, 28}, {36, 36, 37}, 
 {40, 35, 37}, {44, 44, 37}, {52, 48, 47}, {80, 60, 47}, 
 {109, 68, 46}, {129, 84, 47}, {158, 99, 66}, {186, 119, 75}, 
 },
   /* glow-buzz */
{{182, 91, 37}, {141, 84, 37}, {121, 68, 46}, {93, 60, 46}, 
 {76, 48, 37}, {72, 43, 37}, {80, 48, 47}, {101, 60, 46}, 
 {137, 68, 47}, {162, 76, 47}, {178, 95, 56}, {182, 102, 56}, 
 {182, 99, 47}, {182, 87, 47}, {194, 84, 56}, {198, 84, 56}, 
 {190, 87, 66}, {174, 87, 56}, {146, 76, 56}, {117, 60, 47}, 
 {88, 51, 37}, {64, 39, 28}, {52, 27, 28}, {44, 24, 28}, 
 {40, 24, 28}, {40, 23, 28}, {40, 23, 28}, {40, 23, 28}, 
 {44, 27, 28}, {52, 31, 28}, {60, 39, 28}, {84, 47, 37}, 
 {109, 51, 47}, {133, 59, 56}, {162, 64, 56}, {178, 68, 47}, 
 {190, 68, 56}, {198, 72, 47}, {198, 72, 47}, {198, 72, 47}, 
 {190, 68, 47}, {178, 68, 47}, {166, 68, 47}, {149, 71, 37}, 
 {129, 64, 37}, {100, 60, 28}, {92, 47, 37}, {76, 43, 37}, 
 {72, 48, 37}, {76, 52, 47}, {100, 56, 56}, {133, 76, 56}, 
 {154, 80, 47}, {178, 87, 47}, {178, 80, 47}, {158, 80, 47}, 
 {141, 68, 47}, {113, 60, 46}, {96, 56, 47}, {84, 47, 56}, 
 {84, 48, 47}, {92, 55, 47}, {100, 51, 46}, {96, 51, 47}, 
 {92, 55, 47}, {84, 56, 47}, {93, 60, 47}, {84, 52, 37}, 
 {76, 52, 28}, {72, 40, 18}, {64, 35, 28}, {56, 31, 28}, 
 {48, 32, 37}, {44, 35, 37}, {48, 31, 37}, {56, 35, 37}, 
 {48, 36, 37}, {56, 35, 37}, {64, 35, 37}, {60, 39, 47}, 
 {60, 35, 47}, {56, 35, 37}, {52, 35, 28}, {48, 31, 28}, 
 {48, 31, 28}, {44, 31, 28}, {44, 31, 28}, {44, 28, 28}, 
 {40, 27, 28}, {44, 28, 28}, {56, 31, 37}, {64, 43, 47}, 
 {80, 43, 56}, {100, 60, 56}, {137, 76, 65}, {178, 102, 56}, 
 {210, 123, 66}, {198, 144, 75}, {214, 148, 75}, {219, 157, 75}, 
 {222, 160, 75}, {222, 168, 84}, {250, 179, 74}, {250, 191, 65}, 
 {246, 183, 56}, {242, 183, 65}, {238, 168, 56}, {230, 152, 47}, 
 {242, 159, 56}, {219, 145, 75}, {214, 128, 122}, {222, 176, 169}, 
 {190, 169, 122}, {254, 212, 121}, {250, 225, 150}, {254, 212, 93}, 
 {254, 221, 84}, {250, 213, 93}, {254, 217, 84}, {250, 200, 74}, 
 {254, 212, 84}, {246, 208, 74}, {254, 208, 74}, {254, 191, 56}, 
 {254, 178, 46}, {234, 167, 46}, {222, 149, 47}, {210, 145, 56}, 
 {206, 127, 56}, {194, 106, 56}, {190, 106, 56}, {198, 91, 56}, 
 {190, 91, 47}, {186, 106, 56}, {198, 119, 47}, {219, 132, 56}, 
 {230, 119, 56}, {230, 110, 47}, {230, 123, 47}, {234, 148, 56}, 
 {250, 166, 56}, {250, 175, 56}, {250, 179, 56}, {250, 179, 56}, 
 {238, 171, 56}, {219, 153, 66}, {230, 152, 56}, {210, 140, 47}, 
 {194, 106, 47}, {174, 83, 37}, {162, 72, 37}, {154, 72, 47}, 
 {166, 76, 47}, {170, 84, 47}, {170, 91, 47}, {182, 95, 47}, 
 {186, 84, 56}, {198, 87, 56}, {210, 102, 56}, {226, 110, 56}, 
 {226, 98, 47}, {226, 102, 56}, {222, 87, 56}, {214, 83, 56}, 
 {202, 84, 56}, {194, 84, 56}, {182, 80, 56}, {162, 72, 56}, 
 {146, 76, 47}, {137, 64, 47}, {125, 64, 47}, {109, 56, 56}, 
 {113, 56, 56}, {129, 64, 56}, {146, 76, 56}, {166, 72, 56}, 
 {182, 76, 56}, {194, 72, 47}, {182, 80, 56}, {186, 72, 37}, 
 {186, 59, 28}, {194, 72, 37}, {206, 72, 47}, {206, 83, 37}, 
 {206, 80, 47}, {210, 87, 47}, {219, 83, 47}, {210, 80, 56}, 
 {198, 76, 56}, {174, 72, 56}, {146, 60, 47}, {129, 60, 37}, 
 {109, 51, 28}, {92, 47, 28}, {101, 51, 28}, {121, 51, 37}, 
 {141, 55, 37}, {158, 60, 37}, {170, 56, 47}, {174, 64, 47}, 
 {174, 68, 47}, {178, 64, 47}, {182, 63, 47}, {190, 80, 47}, 
 {202, 80, 47}, {202, 87, 47}, {198, 83, 47}, {182, 83, 47}, 
 {178, 80, 47}, {150, 72, 47}, {133, 64, 47}, {113, 60, 46}, 
 {101, 51, 37}, {76, 39, 37}, {60, 31, 28}, {44, 27, 28}, 
 {40, 23, 28}, {39, 19, 18}, {36, 16, 18}, {36, 16, 18}, 
 {35, 20, 18}, {35, 20, 28}, {35, 24, 28}, {36, 24, 18}, 
 {35, 20, 9}, {36, 20, 9}, {36, 20, 18}, {36, 24, 18}, 
 {44, 31, 18}, {56, 35, 28}, {72, 43, 37}, {96, 43, 37}, 
 {109, 51, 46}, {117, 60, 46}, {129, 72, 47}, {125, 68, 37}, 
 {109, 60, 37}, {96, 47, 37}, {80, 39, 37}, {60, 35, 37}, 
 {48, 27, 28}, {44, 27, 18}, {40, 23, 18}, {40, 23, 18}, 
 {39, 24, 28}, {36, 24, 28}, {35, 20, 28}, {35, 16, 28}, 
 {35, 20, 37}, {40, 28, 37}, {56, 40, 37}, {72, 43, 47}, 
 {97, 52, 46}, {113, 51, 47}, {162, 60, 47}, {186, 68, 47}, 
 },
   /* deep-water */
{{24, 20, 18}, {24, 24, 28}, {28, 28, 47}, {27, 24, 66}, 
 {24, 28, 75}, {23, 28, 75}, {23, 28, 66}, {19, 28, 47}, 
 {20, 24, 28}, {20, 24, 18}, {20, 24, 18}, {24, 28, 28}, 
 {28, 32, 56}, {28, 36, 66}, {28, 36, 85}, {36, 52, 103}, 
 {48, 64, 113}, {48, 56, 122}, {44, 64, 122}, {52, 64, 132}, 
 {52, 64, 113}, {68, 60, 113}, {68, 64, 103}, {56, 77, 103}, 
 {56, 68, 94}, {52, 60, 94}, {52, 52, 94}, {36, 52, 94}, 
 {36, 52, 85}, {36, 40, 66}, {32, 32, 56}, {24, 24, 28}, 
 {16, 16, 18}, {11, 8, 18}, {11, 8, 9}, {8, 4, 0}, 
 {8, 4, 0}, {11, 4, 9}, {11, 8, 18}, {11, 8, 28}, 
 {16, 16, 28}, {19, 28, 37}, {24, 32, 56}, {24, 40, 75}, 
 {28, 48, 94}, {36, 64, 103}, {40, 64, 113}, {44, 68, 122}, 
 {44, 68, 113}, {40, 64, 113}, {36, 60, 113}, {36, 52, 103}, 
 {28, 48, 94}, {32, 40, 75}, {36, 36, 66}, {32, 36, 56}, 
 {24, 32, 47}, {19, 32, 37}, {20, 32, 28}, {11, 24, 18}, 
 {8, 20, 18}, {8, 16, 18}, {12, 16, 18}, {12, 16, 18}, 
 {15, 20, 18}, {16, 20, 28}, {20, 28, 37}, {23, 32, 47}, 
 {27, 32, 56}, {28, 28, 47}, {27, 28, 37}, {23, 20, 28}, 
 {19, 16, 18}, {15, 16, 18}, {16, 16, 9}, {12, 12, 0}, 
 {8, 12, 0}, {8, 8, 0}, {8, 8, 9}, {8, 8, 9}, 
 {8, 8, 9}, {8, 12, 9}, {11, 12, 18}, {11, 12, 18}, 
 {11, 12, 18}, {11, 12, 18}, {12, 16, 18}, {16, 24, 18}, 
 {24, 32, 18}, {28, 44, 37}, {40, 52, 37}, {48, 56, 66}, 
 {48, 56, 75}, {52, 68, 85}, {56, 77, 113}, {73, 97, 132}, 
 {84, 109, 160}, {100, 113, 160}, {100, 117, 169}, {101, 117, 160}, 
 {104, 129, 151}, {113, 129, 151}, {104, 125, 170}, {104, 125, 170}, 
 {124, 137, 198}, {104, 116, 170}, {88, 100, 132}, {68, 77, 103}, 
 {52, 64, 94}, {40, 56, 85}, {28, 44, 75}, {28, 36, 56}, 
 {24, 32, 47}, {24, 28, 28}, {24, 24, 18}, {20, 24, 18}, 
 {15, 20, 18}, {12, 16, 18}, {12, 16, 18}, {12, 16, 9}, 
 {12, 12, 9}, {12, 12, 9}, {11, 12, 9}, {11, 16, 9}, 
 {12, 16, 9}, {16, 16, 9}, {16, 20, 0}, {16, 24, 0}, 
 {20, 20, 9}, {24, 20, 18}, {28, 24, 18}, {32, 32, 28}, 
 {32, 36, 47}, {32, 40, 56}, {32, 36, 66}, {28, 36, 75}, 
 {28, 36, 75}, {28, 36, 75}, {28, 36, 75}, {28, 36, 66}, 
 {24, 36, 66}, {24, 36, 75}, {20, 36, 85}, {20, 36, 85}, 
 {24, 36, 75}, {24, 32, 66}, {24, 32, 56}, {23, 24, 28}, 
 {20, 20, 18}, {16, 16, 9}, {16, 16, 9}, {16, 20, 9}, 
 {16, 20, 9}, {19, 20, 9}, {20, 24, 18}, {20, 24, 18}, 
 {20, 24, 18}, {16, 16, 18}, {15, 16, 18}, {12, 12, 18}, 
 {11, 12, 9}, {11, 12, 9}, {8, 12, 9}, {12, 8, 9}, 
 {8, 8, 9}, {8, 8, 9}, {4, 4, 9}, {4, 4, 9}, 
 {7, 0, 18}, {3, 4, 18}, {3, 8, 18}, {3, 4, 9}, 
 {4, 4, 9}, {8, 8, 9}, {8, 8, 9}, {12, 12, 9}, 
 {16, 12, 9}, {16, 12, 9}, {16, 16, 9}, {19, 20, 9}, 
 {20, 28, 18}, {24, 32, 28}, {32, 40, 37}, {36, 44, 56}, 
 {56, 68, 75}, {84, 101, 113}, {117, 125, 151}, {149, 165, 188}, 
 {157, 177, 216}, {181, 189, 235}, {193, 206, 216}, {198, 202, 198}, 
 {149, 177, 197}, {141, 161, 188}, {108, 146, 150}, {92, 108, 141}, 
 {68, 73, 113}, {56, 64, 103}, {48, 56, 94}, {36, 52, 85}, 
 {28, 40, 85}, {32, 40, 85}, {28, 36, 85}, {32, 44, 85}, 
 {36, 56, 94}, {48, 68, 113}, {52, 73, 132}, {52, 73, 132}, 
 {48, 73, 141}, {56, 72, 141}, {64, 81, 141}, {73, 93, 141}, 
 {76, 92, 132}, {60, 77, 132}, {56, 64, 132}, {48, 48, 113}, 
 {36, 40, 85}, {32, 36, 75}, {31, 32, 56}, {23, 28, 37}, 
 {19, 20, 28}, {11, 20, 18}, {7, 16, 9}, {7, 16, 9}, 
 {7, 12, 9}, {7, 12, 9}, {7, 8, 9}, {4, 8, 0}, 
 {4, 4, 0}, {4, 4, 0}, {4, 4, 0}, {4, 4, 0}, 
 {7, 8, 9}, {8, 12, 9}, {8, 16, 9}, {11, 16, 18}, 
 {12, 20, 18}, {19, 24, 28}, {20, 32, 47}, {20, 36, 66}, 
 {20, 36, 85}, {20, 36, 85}, {24, 32, 85}, {24, 32, 85}, 
 {23, 28, 85}, {19, 28, 85}, {20, 32, 85}, {23, 32, 85}, 
 {24, 32, 85}, {31, 32, 94}, {28, 36, 85}, {24, 36, 85}, 
 {27, 28, 66}, {24, 28, 47}, {23, 24, 28}, {15, 16, 18}, 
 },
   /* afternoon-beach */
{{182, 162, 170}, {190, 157, 132}, {178, 136, 113}, {174, 107, 75}, 
 {162, 124, 85}, {190, 160, 94}, {219, 197, 103}, {230, 210, 113}, 
 {254, 245, 131}, {254, 254, 159}, {254, 254, 178}, {250, 254, 206}, 
 {254, 254, 216}, {254, 254, 197}, {250, 254, 169}, {234, 222, 141}, 
 {219, 193, 160}, {202, 189, 170}, {190, 185, 169}, {181, 169, 179}, 
 {181, 157, 179}, {169, 153, 188}, {173, 157, 198}, {161, 149, 188}, 
 {165, 149, 179}, {162, 146, 170}, {145, 141, 151}, {108, 108, 141}, 
 {112, 112, 103}, {129, 129, 103}, {149, 124, 103}, {173, 149, 94}, 
 {206, 149, 94}, {234, 168, 103}, {250, 192, 112}, {250, 200, 112}, 
 {242, 217, 122}, {242, 229, 122}, {254, 237, 112}, {246, 229, 112}, 
 {246, 209, 103}, {254, 204, 93}, {250, 196, 93}, {238, 152, 94}, 
 {194, 127, 75}, {186, 111, 66}, {190, 127, 75}, {222, 168, 94}, 
 {254, 204, 121}, {254, 245, 169}, {250, 254, 206}, {250, 254, 225}, 
 {222, 213, 225}, {210, 193, 207}, {238, 197, 169}, {250, 233, 150}, 
 {254, 249, 159}, {254, 254, 169}, {254, 254, 197}, {250, 254, 216}, 
 {254, 254, 197}, {254, 254, 169}, {254, 254, 159}, {254, 241, 140}, 
 {254, 221, 121}, {250, 209, 112}, {246, 209, 112}, {254, 217, 112}, 
 {254, 221, 121}, {250, 225, 140}, {238, 197, 169}, {226, 185, 207}, 
 {206, 185, 207}, {205, 177, 207}, {201, 185, 216}, {189, 181, 226}, 
 {189, 181, 216}, {177, 165, 216}, {173, 165, 207}, {185, 169, 188}, 
 {202, 165, 188}, {219, 181, 160}, {230, 184, 141}, {234, 180, 131}, 
 {230, 180, 122}, {210, 181, 141}, {210, 169, 151}, {202, 161, 160}, 
 {174, 154, 170}, {177, 149, 179}, {170, 150, 170}, {169, 153, 179}, 
 {166, 162, 170}, {161, 165, 151}, {174, 162, 151}, {178, 157, 141}, 
 {170, 157, 141}, {158, 145, 113}, {141, 116, 94}, {125, 96, 75}, 
 {97, 92, 47}, {77, 77, 47}, {73, 73, 47}, {64, 68, 47}, 
 {68, 64, 47}, {64, 60, 47}, {60, 52, 47}, {56, 48, 47}, 
 {48, 36, 47}, {48, 40, 37}, {52, 40, 37}, {52, 39, 37}, 
 {52, 39, 37}, {64, 39, 37}, {64, 44, 37}, {72, 56, 37}, 
 {64, 60, 37}, {68, 60, 37}, {84, 56, 56}, {117, 76, 65}, 
 {146, 88, 75}, {145, 92, 75}, {149, 99, 75}, {146, 108, 85}, 
 {145, 104, 103}, {162, 108, 104}, {158, 116, 94}, {169, 115, 104}, 
 {157, 129, 94}, {162, 153, 103}, {182, 186, 113}, {222, 214, 122}, 
 {246, 246, 131}, {250, 254, 169}, {254, 254, 197}, {254, 254, 216}, 
 {254, 254, 225}, {234, 226, 254}, {209, 201, 226}, {206, 193, 207}, 
 {210, 177, 198}, {181, 165, 179}, {162, 141, 160}, {145, 121, 122}, 
 {145, 100, 113}, {121, 96, 94}, {104, 93, 94}, {85, 80, 75}, 
 {89, 85, 75}, {97, 93, 84}, {100, 96, 94}, {101, 105, 84}, 
 {121, 121, 103}, {137, 129, 113}, {150, 150, 103}, {182, 152, 103}, 
 {206, 177, 113}, {230, 197, 94}, {238, 180, 84}, {238, 168, 93}, 
 {226, 172, 84}, {189, 152, 84}, {182, 112, 66}, {166, 99, 66}, 
 {133, 80, 56}, {88, 59, 47}, {68, 48, 47}, {64, 44, 47}, 
 {52, 39, 37}, {48, 40, 28}, {48, 35, 28}, {52, 39, 28}, 
 {48, 44, 37}, {56, 48, 37}, {56, 48, 47}, {68, 52, 56}, 
 {76, 64, 56}, {85, 76, 65}, {113, 88, 75}, {117, 92, 84}, 
 {125, 96, 84}, {125, 96, 84}, {125, 92, 84}, {133, 88, 84}, 
 {117, 88, 75}, {92, 72, 56}, {81, 68, 56}, {72, 68, 56}, 
 {68, 68, 56}, {76, 76, 66}, {81, 81, 75}, {85, 77, 75}, 
 {85, 68, 65}, {72, 56, 66}, {68, 64, 56}, {64, 60, 66}, 
 {64, 56, 56}, {60, 48, 56}, {60, 52, 56}, {60, 56, 56}, 
 {60, 56, 47}, {68, 60, 47}, {68, 64, 56}, {73, 73, 56}, 
 {81, 81, 66}, {85, 96, 75}, {97, 105, 75}, {105, 109, 56}, 
 {125, 117, 66}, {125, 129, 66}, {146, 141, 85}, {170, 169, 85}, 
 {198, 202, 113}, {234, 205, 112}, {250, 192, 112}, {238, 172, 103}, 
 {234, 152, 94}, {190, 119, 66}, {174, 106, 56}, {166, 111, 66}, 
 {141, 108, 75}, {125, 112, 85}, {108, 113, 103}, {113, 129, 103}, 
 {133, 125, 122}, {182, 145, 160}, {202, 161, 179}, {210, 193, 179}, 
 {254, 241, 197}, {254, 254, 216}, {254, 254, 216}, {254, 254, 197}, 
 {254, 254, 169}, {254, 254, 159}, {254, 245, 150}, {254, 245, 140}, 
 {250, 229, 131}, {226, 206, 122}, {182, 182, 113}, {162, 141, 94}, 
 {149, 128, 65}, {145, 116, 75}, {137, 100, 84}, {125, 108, 85}, 
 {129, 96, 84}, {125, 112, 75}, {117, 109, 84}, {105, 109, 75}, 
 {97, 109, 75}, {101, 105, 75}, {121, 112, 66}, {141, 112, 75}, 
 {149, 116, 85}, {162, 141, 103}, {194, 169, 122}, {218, 201, 132}, 
 },
   /* dim-beach */
{{27, 28, 28}, {48, 36, 37}, {68, 48, 37}, {72, 60, 37}, 
 {68, 68, 37}, {56, 60, 37}, {44, 44, 28}, {36, 36, 28}, 
 {32, 32, 28}, {28, 32, 28}, {28, 28, 28}, {28, 28, 28}, 
 {28, 32, 28}, {28, 36, 28}, {32, 40, 37}, {48, 60, 56}, 
 {56, 73, 66}, {60, 81, 75}, {80, 93, 75}, {92, 137, 141}, 
 {100, 170, 160}, {133, 185, 188}, {153, 194, 188}, {141, 182, 169}, 
 {117, 162, 131}, {109, 145, 122}, {85, 113, 84}, {69, 85, 56}, 
 {64, 68, 47}, {56, 56, 37}, {40, 40, 28}, {32, 36, 28}, 
 {31, 32, 28}, {28, 32, 28}, {28, 32, 28}, {32, 32, 28}, 
 {36, 36, 28}, {52, 44, 28}, {72, 56, 18}, {97, 60, 28}, 
 {121, 84, 28}, {129, 112, 37}, {150, 107, 37}, {141, 100, 37}, 
 {129, 84, 28}, {109, 72, 28}, {64, 73, 28}, {48, 44, 28}, 
 {36, 40, 18}, {36, 40, 18}, {52, 56, 37}, {64, 64, 47}, 
 {68, 76, 56}, {97, 88, 56}, {109, 100, 56}, {109, 100, 56}, 
 {93, 97, 66}, {68, 76, 66}, {48, 76, 75}, {48, 56, 56}, 
 {40, 36, 37}, {28, 32, 37}, {28, 32, 37}, {27, 32, 37}, 
 {28, 32, 37}, {32, 32, 28}, {32, 32, 28}, {28, 32, 28}, 
 {28, 32, 28}, {28, 28, 28}, {27, 28, 28}, {24, 28, 18}, 
 {24, 28, 18}, {23, 28, 18}, {20, 28, 18}, {20, 28, 28}, 
 {19, 28, 28}, {19, 28, 28}, {16, 24, 28}, {19, 28, 28}, 
 {20, 28, 28}, {24, 32, 28}, {24, 36, 28}, {24, 40, 28}, 
 {24, 36, 37}, {24, 32, 37}, {32, 36, 37}, {52, 60, 47}, 
 {68, 77, 47}, {105, 88, 46}, {133, 116, 37}, {166, 140, 37}, 
 {182, 153, 103}, {214, 206, 132}, {222, 218, 169}, {230, 234, 188}, 
 {242, 242, 197}, {242, 241, 197}, {230, 226, 178}, {246, 196, 93}, 
 {242, 184, 74}, {226, 156, 56}, {210, 164, 56}, {222, 160, 56}, 
 {214, 156, 47}, {222, 163, 37}, {222, 152, 37}, {214, 157, 37}, 
 {186, 123, 37}, {182, 114, 47}, {174, 111, 47}, {149, 99, 56}, 
 {121, 92, 56}, {101, 113, 75}, {125, 170, 122}, {154, 174, 160}, 
 {185, 202, 188}, {198, 218, 198}, {169, 198, 188}, {141, 178, 169}, 
 {104, 154, 150}, {52, 109, 151}, {44, 89, 122}, {40, 56, 75}, 
 {20, 48, 56}, {24, 36, 37}, {24, 32, 28}, {24, 32, 28}, 
 {24, 32, 28}, {24, 32, 28}, {27, 32, 28}, {28, 32, 28}, 
 {28, 36, 28}, {32, 40, 28}, {40, 56, 47}, {48, 60, 56}, 
 {48, 64, 56}, {56, 64, 56}, {56, 64, 56}, {80, 68, 56}, 
 {92, 60, 46}, {113, 96, 47}, {150, 111, 56}, {153, 128, 66}, 
 {170, 166, 132}, {210, 202, 160}, {226, 226, 188}, {246, 242, 197}, 
 {250, 241, 206}, {234, 230, 197}, {226, 222, 188}, {194, 189, 141}, 
 {153, 145, 103}, {105, 101, 66}, {73, 77, 56}, {60, 64, 47}, 
 {44, 40, 37}, {32, 32, 37}, {27, 28, 37}, {24, 24, 37}, 
 {24, 28, 28}, {24, 28, 28}, {24, 28, 28}, {27, 32, 28}, 
 {31, 32, 28}, {32, 36, 28}, {40, 48, 37}, {48, 64, 47}, 
 {52, 73, 47}, {56, 72, 56}, {60, 68, 47}, {68, 76, 56}, 
 {93, 85, 47}, {113, 96, 47}, {105, 80, 47}, {101, 72, 46}, 
 {104, 72, 56}, {97, 76, 46}, {92, 68, 37}, {89, 76, 37}, 
 {88, 72, 47}, {68, 73, 47}, {48, 64, 37}, {36, 40, 28}, 
 {32, 36, 28}, {28, 36, 28}, {28, 32, 28}, {28, 32, 18}, 
 {32, 28, 18}, {28, 28, 28}, {28, 28, 28}, {24, 28, 28}, 
 {23, 28, 28}, {24, 28, 28}, {24, 28, 28}, {24, 28, 28}, 
 {24, 32, 28}, {27, 36, 37}, {28, 36, 37}, {32, 60, 56}, 
 {48, 64, 56}, {48, 68, 56}, {52, 73, 56}, {52, 72, 56}, 
 {48, 64, 56}, {48, 60, 56}, {52, 56, 47}, {44, 40, 37}, 
 {36, 36, 28}, {36, 32, 28}, {36, 36, 28}, {44, 52, 37}, 
 {60, 60, 47}, {60, 64, 47}, {68, 73, 56}, {77, 84, 56}, 
 {93, 97, 56}, {93, 101, 56}, {97, 101, 66}, {97, 97, 56}, 
 {97, 101, 66}, {97, 109, 66}, {88, 137, 112}, {97, 154, 141}, 
 {108, 158, 141}, {116, 166, 160}, {125, 182, 160}, {125, 178, 141}, 
 {141, 182, 132}, {166, 157, 113}, {174, 136, 75}, {198, 140, 56}, 
 {210, 149, 56}, {219, 172, 66}, {210, 206, 151}, {210, 222, 198}, 
 {214, 230, 207}, {222, 230, 207}, {226, 226, 197}, {206, 206, 151}, 
 {166, 162, 122}, {125, 125, 75}, {89, 101, 66}, {60, 73, 47}, 
 {40, 44, 28}, {28, 32, 18}, {24, 32, 18}, {20, 32, 18}, 
 {24, 32, 28}, {28, 36, 37}, {36, 40, 47}, {36, 52, 66}, 
 {40, 80, 85}, {56, 85, 84}, {88, 142, 141}, {129, 182, 160}, 
 },
   /* cloudy-brick */
{{202, 206, 188}, {178, 186, 160}, {153, 157, 141}, {129, 141, 122}, 
 {112, 129, 113}, {96, 125, 122}, {104, 146, 141}, {112, 158, 169}, 
 {137, 181, 188}, {157, 222, 225}, {153, 218, 235}, {132, 210, 235}, 
 {100, 198, 216}, {84, 154, 188}, {60, 117, 122}, {48, 80, 94}, 
 {40, 60, 75}, {28, 48, 56}, {40, 44, 37}, {24, 32, 28}, 
 {48, 56, 37}, {80, 35, 28}, {76, 35, 37}, {68, 35, 37}, 
 {68, 39, 28}, {68, 39, 37}, {68, 72, 56}, {56, 68, 47}, 
 {68, 72, 56}, {48, 72, 47}, {60, 72, 66}, {77, 97, 85}, 
 {84, 113, 103}, {100, 133, 132}, {133, 162, 160}, {173, 190, 188}, 
 {189, 210, 198}, {193, 218, 207}, {193, 218, 216}, {193, 218, 216}, 
 {173, 210, 225}, {132, 201, 225}, {104, 161, 188}, {84, 141, 169}, 
 {80, 121, 141}, {76, 109, 122}, {93, 104, 84}, {105, 92, 66}, 
 {129, 80, 56}, {145, 95, 28}, {153, 95, 28}, {174, 111, 66}, 
 {226, 167, 84}, {234, 155, 65}, {194, 119, 37}, {178, 63, 9}, 
 {170, 33, 9}, {129, 38, 18}, {125, 63, 37}, {153, 76, 28}, 
 {170, 107, 56}, {246, 188, 74}, {246, 196, 103}, {250, 217, 159}, 
 {226, 213, 188}, {230, 234, 216}, {230, 237, 225}, {230, 246, 235}, 
 {218, 246, 244}, {218, 242, 235}, {209, 238, 225}, {210, 230, 225}, 
 {206, 222, 226}, {197, 218, 216}, {189, 218, 207}, {185, 210, 207}, 
 {153, 169, 188}, {105, 150, 160}, {80, 125, 141}, {68, 101, 122}, 
 {56, 93, 113}, {52, 97, 122}, {68, 105, 113}, {92, 129, 132}, 
 {129, 150, 141}, {185, 177, 141}, {242, 196, 122}, {202, 165, 132}, 
 {182, 115, 75}, {170, 59, 28}, {153, 59, 18}, {125, 42, 28}, 
 {113, 43, 28}, {92, 35, 37}, {80, 39, 37}, {64, 64, 66}, 
 {52, 76, 85}, {56, 89, 84}, {56, 81, 85}, {64, 85, 94}, 
 {73, 97, 94}, {85, 109, 94}, {100, 109, 94}, {121, 145, 113}, 
 {129, 166, 141}, {146, 186, 169}, {177, 210, 197}, {189, 218, 207}, 
 {197, 218, 226}, {197, 222, 226}, {206, 222, 226}, {217, 226, 225}, 
 {222, 234, 225}, {218, 234, 226}, {214, 234, 216}, {201, 234, 216}, 
 {201, 230, 216}, {197, 230, 225}, {197, 230, 225}, {193, 230, 225}, 
 {193, 230, 226}, {193, 230, 226}, {189, 242, 235}, {201, 242, 244}, 
 {213, 237, 244}, {205, 234, 235}, {201, 238, 235}, {201, 234, 235}, 
 {193, 230, 235}, {193, 230, 226}, {193, 226, 226}, {189, 226, 225}, 
 {181, 230, 225}, {161, 198, 207}, {108, 166, 178}, {92, 153, 160}, 
 {73, 126, 150}, {88, 137, 150}, {89, 142, 151}, {125, 162, 151}, 
 {149, 182, 170}, {181, 202, 188}, {189, 218, 207}, {194, 226, 216}, 
 {201, 230, 225}, {205, 230, 225}, {213, 234, 225}, {214, 234, 225}, 
 {214, 230, 216}, {206, 230, 207}, {194, 218, 198}, {166, 190, 170}, 
 {145, 149, 132}, {121, 109, 84}, {117, 104, 75}, {141, 113, 103}, 
 {166, 141, 132}, {182, 174, 160}, {206, 214, 179}, {218, 238, 207}, 
 {246, 249, 225}, {250, 254, 235}, {254, 254, 244}, {254, 254, 254}, 
 {254, 254, 254}, {250, 254, 254}, {254, 254, 254}, {254, 254, 244}, 
 {250, 250, 244}, {246, 250, 244}, {242, 250, 244}, {230, 245, 235}, 
 {226, 230, 225}, {214, 222, 216}, {226, 238, 216}, {210, 222, 216}, 
 {206, 222, 216}, {201, 230, 226}, {205, 226, 216}, {206, 222, 207}, 
 {198, 222, 207}, {202, 222, 207}, {201, 226, 216}, {197, 222, 216}, 
 {198, 222, 207}, {198, 222, 198}, {202, 210, 179}, {174, 198, 169}, 
 {153, 185, 188}, {157, 190, 179}, {181, 202, 188}, {198, 210, 198}, 
 {202, 210, 198}, {193, 218, 207}, {198, 226, 207}, {206, 230, 207}, 
 {206, 230, 207}, {202, 230, 216}, {202, 226, 216}, {197, 218, 216}, 
 {193, 218, 226}, {185, 221, 235}, {185, 230, 244}, {181, 234, 244}, 
 {173, 234, 244}, {173, 230, 244}, {116, 207, 235}, {76, 194, 216}, 
 {72, 185, 206}, {60, 170, 207}, {76, 153, 169}, {68, 121, 122}, 
 {76, 105, 94}, {60, 85, 75}, {73, 81, 75}, {77, 77, 56}, 
 {76, 68, 66}, {73, 89, 85}, {97, 80, 65}, {80, 64, 47}, 
 {96, 43, 37}, {125, 38, 28}, {125, 42, 28}, {100, 47, 47}, 
 {92, 72, 75}, {68, 81, 85}, {68, 85, 94}, {84, 93, 103}, 
 {72, 113, 122}, {100, 149, 141}, {133, 170, 169}, {185, 202, 207}, 
 {206, 222, 216}, {226, 234, 225}, {238, 250, 244}, {246, 254, 244}, 
 {250, 254, 244}, {250, 250, 244}, {250, 254, 244}, {250, 254, 244}, 
 {254, 254, 244}, {250, 254, 235}, {250, 254, 235}, {250, 254, 225}, 
 {254, 254, 216}, {250, 249, 216}, {210, 222, 207}, {218, 181, 169}, 
 {214, 185, 150}, {182, 116, 103}, {129, 120, 56}, {129, 91, 56}, 
 {125, 88, 65}, {105, 88, 84}, {129, 129, 113}, {149, 161, 160}, 
 },
   /* burning-wood */
{{80, 35, 28}, {92, 39, 28}, {97, 39, 28}, {96, 39, 37}, 
 {97, 39, 28}, {80, 43, 37}, {68, 43, 37}, {84, 39, 37}, 
 {76, 43, 47}, {72, 48, 56}, {60, 43, 47}, {44, 44, 47}, 
 {36, 32, 37}, {31, 28, 37}, {27, 28, 37}, {28, 32, 37}, 
 {40, 28, 37}, {48, 32, 37}, {52, 31, 37}, {56, 27, 28}, 
 {68, 35, 28}, {84, 35, 28}, {96, 30, 28}, {104, 34, 18}, 
 {105, 30, 18}, {97, 34, 18}, {88, 34, 18}, {76, 35, 28}, 
 {68, 39, 28}, {64, 43, 18}, {60, 48, 37}, {52, 52, 37}, 
 {48, 44, 37}, {32, 40, 28}, {32, 32, 28}, {27, 32, 28}, 
 {28, 28, 28}, {28, 28, 18}, {31, 28, 18}, {31, 28, 18}, 
 {35, 28, 18}, {36, 32, 18}, {52, 35, 18}, {56, 31, 18}, 
 {76, 31, 18}, {96, 30, 18}, {113, 30, 18}, {133, 26, 18}, 
 {145, 26, 18}, {154, 22, 19}, {162, 22, 18}, {174, 25, 0}, 
 {178, 25, 0}, {178, 46, 9}, {190, 87, 18}, {214, 105, 18}, 
 {219, 97, 0}, {198, 87, 18}, {178, 72, 9}, {162, 37, 0}, 
 {158, 22, 0}, {158, 22, 9}, {154, 22, 0}, {146, 22, 0}, 
 {146, 26, 9}, {137, 26, 9}, {117, 30, 9}, {105, 30, 18}, 
 {92, 23, 18}, {88, 23, 28}, {92, 39, 28}, {88, 39, 28}, 
 {80, 52, 47}, {72, 56, 56}, {84, 68, 65}, {73, 73, 75}, 
 {64, 60, 56}, {52, 56, 56}, {36, 52, 47}, {32, 36, 37}, 
 {36, 32, 28}, {40, 31, 28}, {52, 31, 28}, {48, 31, 18}, 
 {60, 27, 18}, {76, 31, 18}, {88, 31, 18}, {100, 30, 9}, 
 {113, 34, 9}, {121, 30, 9}, {133, 30, 18}, {125, 39, 18}, 
 {121, 31, 28}, {121, 38, 28}, {109, 35, 37}, {109, 34, 28}, 
 {105, 31, 28}, {101, 34, 28}, {84, 35, 37}, {72, 31, 37}, 
 {68, 27, 37}, {56, 27, 28}, {48, 23, 28}, {40, 24, 28}, 
 {36, 27, 28}, {35, 28, 28}, {35, 28, 28}, {36, 32, 18}, 
 {48, 31, 18}, {80, 43, 18}, {101, 64, 28}, {141, 76, 28}, 
 {182, 95, 28}, {214, 123, 37}, {234, 163, 56}, {234, 176, 84}, 
 {234, 176, 75}, {222, 157, 47}, {222, 131, 47}, {210, 110, 28}, 
 {222, 79, 37}, {194, 38, 18}, {202, 14, 9}, {206, 26, 19}, 
 {186, 30, 9}, {182, 30, 9}, {186, 72, 9}, {174, 83, 9}, 
 {161, 79, 18}, {141, 59, 9}, {129, 64, 28}, {121, 76, 47}, 
 {121, 63, 56}, {133, 46, 37}, {125, 47, 28}, {129, 43, 28}, 
 {121, 47, 28}, {113, 47, 28}, {125, 47, 18}, {121, 47, 28}, 
 {109, 47, 18}, {100, 43, 28}, {92, 39, 28}, {76, 31, 28}, 
 {56, 31, 28}, {48, 31, 37}, {40, 27, 28}, {35, 28, 28}, 
 {32, 28, 28}, {36, 31, 28}, {44, 36, 28}, {56, 35, 28}, 
 {68, 35, 28}, {76, 35, 37}, {80, 47, 28}, {88, 39, 28}, 
 {88, 43, 37}, {101, 43, 28}, {105, 39, 28}, {109, 43, 28}, 
 {109, 60, 46}, {97, 72, 56}, {105, 88, 75}, {113, 104, 84}, 
 {133, 100, 94}, {165, 91, 56}, {165, 87, 47}, {162, 71, 37}, 
 {166, 59, 28}, {162, 63, 18}, {149, 64, 18}, {150, 59, 18}, 
 {146, 60, 9}, {141, 33, 0}, {129, 59, 0}, {121, 59, 18}, 
 {133, 64, 18}, {149, 64, 28}, {154, 80, 37}, {174, 83, 18}, 
 {182, 91, 18}, {198, 96, 18}, {202, 110, 28}, {202, 106, 37}, 
 {202, 106, 37}, {198, 95, 47}, {178, 86, 28}, {133, 68, 28}, 
 {113, 59, 28}, {92, 43, 18}, {76, 35, 28}, {60, 35, 28}, 
 {56, 31, 28}, {64, 31, 28}, {68, 27, 28}, {72, 31, 28}, 
 {76, 31, 28}, {76, 35, 28}, {80, 39, 18}, {84, 31, 28}, 
 {85, 35, 18}, {81, 31, 18}, {80, 31, 18}, {76, 27, 28}, 
 {64, 27, 28}, {56, 27, 28}, {44, 27, 28}, {36, 28, 28}, 
 {31, 28, 28}, {27, 24, 28}, {23, 24, 28}, {27, 24, 28}, 
 {31, 28, 28}, {32, 28, 28}, {35, 28, 28}, {44, 31, 28}, 
 {68, 31, 28}, {88, 43, 28}, {109, 60, 28}, {133, 64, 28}, 
 {166, 91, 28}, {210, 140, 66}, {214, 210, 188}, {230, 180, 113}, 
 {238, 176, 93}, {219, 173, 85}, {222, 164, 66}, {202, 131, 47}, 
 {174, 103, 47}, {141, 100, 47}, {121, 88, 66}, {80, 60, 47}, 
 {60, 43, 37}, {48, 27, 37}, {44, 27, 37}, {36, 28, 28}, 
 {32, 28, 28}, {31, 28, 28}, {27, 28, 28}, {27, 28, 28}, 
 {24, 28, 28}, {27, 28, 28}, {27, 28, 28}, {31, 28, 28}, 
 {32, 28, 28}, {32, 36, 37}, {44, 40, 37}, {56, 31, 37}, 
 {68, 35, 56}, {89, 60, 47}, {117, 64, 37}, {121, 56, 37}, 
 {125, 56, 47}, {109, 47, 37}, {105, 47, 37}, {92, 27, 37}, 
 },
   /* aquatic-garden */
{{146, 80, 9}, {133, 92, 28}, {133, 108, 56}, {153, 112, 75}, 
 {141, 125, 84}, {133, 113, 65}, {105, 76, 56}, {80, 72, 37}, 
 {60, 68, 37}, {52, 60, 47}, {40, 44, 47}, {36, 36, 37}, 
 {32, 28, 37}, {32, 28, 28}, {32, 24, 28}, {27, 24, 37}, 
 {27, 28, 37}, {28, 32, 37}, {40, 44, 47}, {60, 64, 56}, 
 {77, 89, 66}, {92, 105, 66}, {117, 133, 85}, {125, 158, 103}, 
 {166, 177, 103}, {149, 178, 122}, {157, 157, 113}, {125, 133, 103}, 
 {109, 96, 94}, {81, 93, 75}, {64, 85, 75}, {52, 68, 56}, 
 {40, 56, 47}, {40, 44, 37}, {36, 36, 28}, {32, 32, 28}, 
 {28, 28, 28}, {24, 28, 28}, {23, 28, 28}, {28, 32, 28}, 
 {36, 36, 28}, {40, 40, 28}, {56, 39, 28}, {72, 48, 28}, 
 {84, 51, 28}, {80, 56, 28}, {84, 64, 28}, {72, 64, 28}, 
 {68, 39, 28}, {56, 43, 28}, {36, 32, 18}, {28, 28, 18}, 
 {24, 28, 28}, {23, 24, 28}, {20, 20, 28}, {23, 20, 28}, 
 {19, 20, 28}, {19, 20, 28}, {24, 24, 28}, {31, 24, 28}, 
 {31, 28, 28}, {35, 28, 28}, {48, 35, 28}, {64, 43, 28}, 
 {72, 52, 37}, {76, 56, 37}, {72, 52, 37}, {56, 39, 28}, 
 {48, 31, 28}, {36, 28, 28}, {32, 28, 28}, {28, 28, 28}, 
 {28, 32, 28}, {28, 32, 28}, {28, 32, 28}, {24, 32, 28}, 
 {24, 32, 28}, {24, 32, 28}, {24, 32, 28}, {24, 32, 28}, 
 {24, 32, 28}, {28, 36, 28}, {36, 40, 28}, {44, 48, 37}, 
 {64, 64, 47}, {81, 97, 66}, {96, 121, 103}, {88, 146, 150}, 
 {96, 158, 169}, {100, 158, 179}, {100, 150, 160}, {100, 129, 141}, 
 {85, 109, 113}, {68, 93, 85}, {44, 60, 66}, {36, 44, 47}, 
 {24, 40, 37}, {24, 36, 37}, {23, 32, 28}, {20, 24, 18}, 
 {24, 24, 18}, {23, 20, 9}, {24, 32, 18}, {36, 44, 18}, 
 {44, 48, 37}, {52, 60, 47}, {56, 81, 75}, {64, 97, 85}, 
 {68, 101, 94}, {85, 113, 85}, {96, 117, 94}, {84, 84, 94}, 
 {68, 80, 85}, {64, 73, 75}, {56, 56, 56}, {52, 56, 47}, 
 {40, 44, 37}, {36, 36, 37}, {35, 32, 28}, {28, 24, 18}, 
 {32, 28, 28}, {32, 32, 18}, {52, 39, 18}, {60, 35, 18}, 
 {84, 47, 37}, {81, 55, 37}, {80, 72, 56}, {64, 76, 66}, 
 {52, 64, 75}, {48, 73, 85}, {52, 81, 94}, {60, 89, 122}, 
 {64, 101, 122}, {88, 105, 122}, {89, 117, 113}, {93, 117, 113}, 
 {100, 117, 113}, {100, 125, 103}, {104, 125, 103}, {109, 129, 85}, 
 {96, 105, 75}, {93, 101, 66}, {89, 93, 66}, {105, 105, 75}, 
 {117, 125, 56}, {121, 121, 75}, {117, 100, 56}, {109, 100, 47}, 
 {89, 93, 56}, {84, 93, 66}, {73, 85, 66}, {56, 64, 47}, 
 {44, 48, 47}, {40, 32, 37}, {44, 31, 37}, {40, 44, 37}, 
 {56, 52, 28}, {68, 68, 37}, {64, 56, 37}, {68, 56, 37}, 
 {64, 48, 47}, {48, 52, 47}, {40, 40, 47}, {32, 36, 37}, 
 {32, 36, 28}, {32, 36, 28}, {36, 40, 37}, {44, 52, 47}, 
 {52, 60, 66}, {64, 85, 85}, {84, 109, 103}, {100, 121, 122}, 
 {104, 145, 151}, {116, 158, 141}, {112, 150, 151}, {108, 129, 132}, 
 {113, 105, 103}, {89, 101, 75}, {69, 93, 56}, {68, 76, 37}, 
 {68, 68, 28}, {52, 48, 28}, {40, 40, 28}, {36, 36, 28}, 
 {32, 36, 28}, {32, 32, 28}, {32, 32, 28}, {32, 32, 28}, 
 {32, 36, 28}, {32, 40, 37}, {28, 44, 47}, {36, 68, 66}, 
 {48, 85, 94}, {44, 109, 160}, {88, 150, 169}, {113, 178, 159}, 
 {116, 170, 169}, {133, 173, 179}, {92, 154, 197}, {36, 93, 170}, 
 {40, 93, 160}, {36, 73, 103}, {48, 56, 75}, {44, 48, 56}, 
 {36, 36, 37}, {32, 32, 28}, {27, 28, 18}, {24, 28, 18}, 
 {20, 32, 18}, {24, 28, 18}, {19, 28, 18}, {19, 24, 28}, 
 {20, 24, 28}, {20, 28, 28}, {23, 28, 28}, {20, 32, 28}, 
 {20, 28, 28}, {24, 28, 28}, {28, 28, 28}, {28, 28, 28}, 
 {28, 32, 28}, {32, 32, 28}, {36, 32, 37}, {40, 36, 47}, 
 {52, 48, 66}, {60, 77, 94}, {92, 121, 132}, {125, 166, 160}, 
 {145, 177, 179}, {161, 190, 198}, {169, 198, 188}, {174, 186, 170}, 
 {166, 186, 170}, {145, 170, 132}, {141, 162, 85}, {129, 133, 85}, 
 {137, 99, 47}, {137, 72, 9}, {125, 46, 0}, {109, 47, 18}, 
 {85, 51, 28}, {105, 80, 28}, {93, 64, 47}, {104, 72, 75}, 
 {125, 121, 94}, {129, 137, 113}, {108, 150, 122}, {96, 146, 131}, 
 {88, 137, 122}, {68, 105, 141}, {52, 72, 94}, {28, 52, 56}, 
 {23, 32, 47}, {31, 28, 47}, {32, 40, 47}, {40, 52, 56}, 
 },
   /* no-name */
{{24, 24, 9}, {24, 28, 9}, {24, 28, 18}, {28, 28, 18}, 
 {28, 28, 28}, {27, 28, 28}, {24, 28, 28}, {24, 28, 28}, 
 {20, 28, 28}, {19, 28, 18}, {24, 28, 9}, {23, 24, 9}, 
 {20, 24, 18}, {19, 20, 18}, {20, 20, 18}, {19, 20, 28}, 
 {15, 24, 28}, {11, 20, 18}, {12, 16, 18}, {12, 12, 9}, 
 {16, 20, 18}, {20, 24, 28}, {24, 24, 28}, {27, 32, 28}, 
 {32, 36, 28}, {32, 44, 28}, {32, 52, 37}, {48, 60, 37}, 
 {76, 68, 47}, {101, 80, 37}, {150, 96, 28}, {194, 102, 28}, 
 {210, 106, 37}, {214, 110, 37}, {214, 127, 37}, {210, 127, 37}, 
 {206, 132, 47}, {214, 156, 47}, {226, 168, 47}, {246, 191, 46}, 
 {246, 208, 46}, {254, 220, 56}, {254, 207, 56}, {250, 191, 46}, 
 {250, 187, 46}, {238, 179, 46}, {238, 159, 46}, {234, 148, 46}, 
 {222, 136, 37}, {218, 148, 37}, {222, 179, 47}, {230, 200, 37}, 
 {227, 230, 46}, {246, 225, 46}, {226, 218, 47}, {215, 192, 56}, 
 {165, 149, 66}, {101, 109, 47}, {72, 72, 28}, {56, 60, 28}, 
 {40, 44, 28}, {32, 32, 18}, {28, 28, 18}, {24, 32, 18}, 
 {24, 32, 18}, {24, 32, 18}, {32, 32, 28}, {32, 36, 28}, 
 {40, 44, 37}, {52, 48, 47}, {64, 48, 56}, {76, 64, 47}, 
 {89, 64, 47}, {109, 80, 56}, {154, 96, 56}, {190, 107, 47}, 
 {186, 106, 47}, {174, 123, 37}, {149, 111, 37}, {109, 84, 46}, 
 {85, 80, 47}, {81, 76, 56}, {64, 77, 66}, {56, 64, 66}, 
 {48, 52, 56}, {32, 36, 47}, {28, 36, 37}, {28, 32, 28}, 
 {28, 32, 28}, {35, 32, 18}, {44, 40, 18}, {72, 48, 28}, 
 {101, 55, 37}, {133, 72, 47}, {186, 102, 47}, {186, 91, 56}, 
 {149, 84, 56}, {109, 80, 56}, {137, 99, 47}, {162, 108, 47}, 
 {178, 136, 56}, {186, 148, 56}, {210, 189, 75}, {234, 209, 103}, 
 {234, 205, 103}, {234, 197, 103}, {238, 180, 65}, {210, 148, 56}, 
 {226, 115, 65}, {222, 115, 75}, {198, 110, 66}, {182, 110, 47}, 
 {125, 80, 37}, {105, 59, 37}, {68, 52, 28}, {44, 40, 28}, 
 {32, 32, 18}, {28, 28, 18}, {24, 28, 18}, {20, 24, 18}, 
 {23, 24, 18}, {28, 32, 28}, {40, 40, 37}, {52, 48, 37}, 
 {72, 60, 37}, {96, 72, 37}, {145, 99, 56}, {194, 102, 56}, 
 {214, 123, 85}, {230, 180, 103}, {254, 245, 131}, {254, 254, 140}, 
 {250, 254, 197}, {234, 234, 188}, {190, 173, 151}, {129, 146, 141}, 
 {105, 137, 84}, {85, 101, 47}, {93, 77, 46}, {109, 60, 37}, 
 {121, 76, 37}, {149, 108, 47}, {182, 119, 47}, {178, 140, 56}, 
 {186, 144, 47}, {194, 136, 47}, {194, 123, 37}, {178, 115, 37}, 
 {117, 88, 47}, {84, 64, 47}, {60, 56, 47}, {52, 60, 56}, 
 {52, 64, 47}, {60, 68, 56}, {73, 81, 75}, {116, 141, 141}, 
 {182, 186, 151}, {218, 222, 169}, {206, 206, 179}, {150, 166, 151}, 
 {84, 109, 103}, {60, 73, 85}, {56, 73, 75}, {73, 77, 75}, 
 {85, 93, 65}, {97, 113, 66}, {129, 141, 75}, {166, 157, 113}, 
 {182, 169, 113}, {198, 156, 103}, {186, 132, 66}, {174, 119, 47}, 
 {121, 84, 37}, {81, 60, 28}, {64, 56, 28}, {48, 52, 18}, 
 {44, 44, 28}, {40, 40, 37}, {32, 36, 37}, {32, 36, 37}, 
 {40, 40, 37}, {48, 48, 47}, {48, 73, 56}, {73, 117, 46}, 
 {113, 125, 47}, {150, 170, 94}, {186, 181, 103}, {215, 206, 94}, 
 {246, 233, 74}, {250, 249, 84}, {254, 233, 84}, {254, 241, 74}, 
 {254, 229, 56}, {250, 229, 56}, {254, 225, 65}, {250, 233, 84}, 
 {238, 241, 112}, {246, 217, 122}, {206, 181, 113}, {198, 123, 85}, 
 {202, 119, 66}, {194, 127, 56}, {198, 131, 56}, {194, 136, 66}, 
 {222, 185, 84}, {234, 230, 112}, {254, 249, 112}, {254, 254, 131}, 
 {222, 226, 150}, {214, 193, 132}, {174, 157, 113}, {105, 113, 56}, 
 {77, 84, 56}, {52, 68, 47}, {44, 52, 37}, {36, 40, 28}, 
 {32, 36, 28}, {36, 40, 28}, {36, 36, 28}, {40, 32, 37}, 
 {48, 39, 37}, {64, 39, 28}, {80, 52, 37}, {105, 55, 47}, 
 {165, 84, 56}, {194, 98, 47}, {198, 106, 47}, {202, 131, 56}, 
 {238, 172, 84}, {242, 196, 103}, {250, 213, 103}, {246, 221, 74}, 
 {246, 200, 56}, {210, 180, 56}, {170, 149, 56}, {141, 111, 47}, 
 {93, 92, 47}, {84, 72, 47}, {64, 68, 28}, {56, 64, 28}, 
 {44, 52, 28}, {36, 44, 28}, {36, 36, 28}, {40, 40, 28}, 
 {40, 40, 28}, {56, 43, 18}, {60, 43, 18}, {72, 52, 28}, 
 {96, 64, 46}, {117, 84, 65}, {170, 123, 66}, {170, 132, 66}, 
 {121, 72, 56}, {100, 55, 46}, {56, 48, 37}, {36, 36, 37}, 
 },
   /* fall-quilt */
{{24, 40, 37}, {56, 52, 37}, {93, 68, 37}, {137, 68, 18}, 
 {174, 76, 18}, {190, 102, 9}, {190, 94, 18}, {178, 75, 18}, 
 {162, 64, 18}, {129, 60, 18}, {105, 76, 18}, {77, 68, 28}, 
 {64, 60, 37}, {40, 48, 37}, {24, 40, 37}, {20, 32, 37}, 
 {19, 32, 37}, {15, 32, 37}, {15, 32, 37}, {20, 36, 47}, 
 {24, 40, 56}, {24, 40, 56}, {28, 40, 56}, {28, 44, 56}, 
 {28, 44, 56}, {32, 44, 47}, {36, 48, 37}, {48, 52, 37}, 
 {76, 68, 37}, {81, 73, 37}, {109, 80, 37}, {137, 80, 28}, 
 {170, 87, 37}, {194, 98, 18}, {198, 102, 18}, {210, 110, 18}, 
 {214, 118, 9}, {198, 119, 18}, {170, 128, 28}, {146, 99, 28}, 
 {117, 80, 28}, {85, 72, 37}, {68, 52, 37}, {40, 40, 37}, 
 {24, 36, 28}, {19, 32, 28}, {24, 24, 28}, {32, 28, 28}, 
 {40, 31, 18}, {56, 35, 18}, {76, 52, 28}, {105, 84, 37}, 
 {133, 96, 37}, {194, 144, 56}, {214, 197, 141}, {214, 202, 179}, 
 {234, 230, 216}, {250, 233, 225}, {250, 233, 216}, {222, 193, 169}, 
 {150, 145, 94}, {109, 96, 56}, {77, 68, 47}, {40, 48, 56}, 
 {36, 44, 56}, {36, 40, 56}, {32, 36, 56}, {28, 40, 56}, 
 {24, 36, 47}, {20, 32, 47}, {20, 32, 37}, {24, 36, 37}, 
 {24, 36, 37}, {36, 36, 37}, {36, 36, 28}, {40, 32, 28}, 
 {40, 31, 28}, {48, 31, 28}, {68, 47, 28}, {109, 39, 28}, 
 {129, 46, 18}, {133, 47, 9}, {162, 59, 0}, {198, 114, 9}, 
 {214, 145, 28}, {226, 171, 47}, {234, 183, 47}, {230, 192, 65}, 
 {222, 165, 65}, {194, 144, 47}, {145, 112, 47}, {113, 88, 47}, 
 {93, 72, 46}, {60, 60, 47}, {36, 48, 47}, {32, 44, 47}, 
 {32, 36, 47}, {36, 36, 37}, {36, 40, 37}, {40, 40, 37}, 
 {40, 44, 28}, {48, 52, 28}, {76, 68, 37}, {93, 76, 37}, 
 {113, 88, 28}, {170, 123, 28}, {194, 122, 28}, {210, 132, 18}, 
 {214, 141, 18}, {210, 127, 18}, {182, 119, 28}, {153, 76, 28}, 
 {137, 64, 18}, {121, 55, 9}, {93, 51, 18}, {80, 64, 37}, 
 {97, 76, 37}, {113, 84, 37}, {166, 115, 47}, {214, 173, 75}, 
 {230, 197, 75}, {242, 200, 75}, {218, 173, 66}, {182, 132, 47}, 
 {113, 88, 46}, {77, 72, 37}, {56, 48, 37}, {44, 40, 37}, 
 {35, 24, 28}, {24, 12, 18}, {23, 12, 18}, {27, 20, 18}, 
 {52, 31, 18}, {93, 51, 18}, {149, 92, 28}, {194, 140, 37}, 
 {226, 180, 75}, {242, 213, 84}, {250, 213, 112}, {254, 212, 121}, 
 {238, 222, 141}, {250, 233, 197}, {254, 241, 216}, {250, 237, 225}, 
 {254, 233, 197}, {250, 229, 169}, {254, 229, 150}, {254, 229, 140}, 
 {250, 221, 131}, {246, 217, 112}, {250, 209, 84}, {250, 208, 74}, 
 {238, 192, 56}, {214, 131, 28}, {186, 72, 9}, {146, 38, 0}, 
 {109, 30, 9}, {76, 15, 9}, {48, 16, 9}, {27, 8, 9}, 
 {23, 24, 28}, {24, 32, 37}, {24, 36, 37}, {24, 40, 47}, 
 {32, 44, 47}, {40, 44, 56}, {56, 52, 56}, {89, 64, 56}, 
 {125, 72, 37}, {158, 60, 37}, {162, 63, 28}, {154, 55, 18}, 
 {141, 38, 18}, {133, 26, 9}, {113, 22, 0}, {89, 11, 9}, 
 {73, 11, 0}, {52, 11, 9}, {36, 20, 0}, {40, 16, 9}, 
 {27, 20, 18}, {23, 20, 28}, {24, 24, 37}, {19, 28, 47}, 
 {15, 28, 47}, {16, 32, 47}, {12, 28, 37}, {16, 28, 37}, 
 {19, 28, 37}, {16, 28, 37}, {24, 36, 28}, {40, 35, 18}, 
 {44, 35, 18}, {64, 35, 18}, {97, 38, 0}, {121, 51, 9}, 
 {125, 42, 9}, {121, 38, 9}, {93, 31, 18}, {52, 40, 28}, 
 {36, 40, 47}, {32, 44, 47}, {32, 48, 47}, {32, 48, 47}, 
 {28, 44, 47}, {24, 36, 47}, {19, 28, 37}, {19, 20, 28}, 
 {20, 12, 18}, {24, 4, 9}, {16, 8, 0}, {16, 12, 0}, 
 {20, 12, 9}, {20, 20, 18}, {16, 28, 28}, {16, 28, 37}, 
 {15, 28, 37}, {12, 28, 28}, {23, 28, 18}, {44, 27, 18}, 
 {56, 19, 18}, {80, 19, 28}, {113, 30, 18}, {129, 51, 9}, 
 {145, 79, 28}, {186, 127, 28}, {226, 163, 47}, {234, 192, 65}, 
 {242, 200, 75}, {226, 188, 84}, {190, 144, 47}, {125, 96, 47}, 
 {97, 80, 56}, {60, 60, 47}, {36, 48, 47}, {24, 40, 47}, 
 {20, 32, 47}, {16, 28, 47}, {12, 24, 37}, {12, 20, 37}, 
 {12, 20, 47}, {15, 24, 47}, {15, 28, 56}, {20, 28, 56}, 
 {20, 36, 56}, {28, 44, 56}, {36, 48, 47}, {52, 48, 47}, 
 {77, 73, 37}, {109, 88, 56}, {125, 96, 47}, {186, 127, 37}, 
 {218, 163, 47}, {230, 166, 37}, {230, 144, 28}, {198, 120, 37}, 
 },
   /* night-blue-sky */
{{3, 12, 66}, {4, 12, 66}, {7, 12, 66}, {7, 8, 56}, 
 {4, 8, 47}, {3, 8, 37}, {0, 4, 18}, {0, 4, 9}, 
 {0, 4, 0}, {0, 4, 0}, {0, 4, 0}, {0, 4, 0}, 
 {0, 4, 9}, {0, 4, 18}, {3, 4, 18}, {4, 4, 18}, 
 {4, 4, 18}, {4, 4, 9}, {4, 4, 9}, {0, 4, 9}, 
 {0, 0, 0}, {0, 0, 0}, {0, 4, 0}, {0, 4, 0}, 
 {4, 4, 9}, {4, 4, 18}, {4, 4, 18}, {4, 8, 18}, 
 {3, 8, 18}, {0, 8, 18}, {0, 4, 18}, {0, 4, 18}, 
 {0, 4, 18}, {0, 4, 28}, {0, 8, 37}, {0, 12, 47}, 
 {3, 12, 56}, {3, 16, 66}, {3, 16, 75}, {3, 12, 75}, 
 {3, 12, 75}, {3, 16, 75}, {3, 16, 75}, {4, 16, 75}, 
 {4, 12, 75}, {3, 12, 75}, {3, 12, 75}, {3, 12, 75}, 
 {0, 12, 66}, {3, 8, 56}, {3, 8, 56}, {3, 8, 56}, 
 {3, 4, 47}, {4, 4, 47}, {4, 4, 56}, {4, 8, 56}, 
 {4, 8, 56}, {3, 8, 56}, {3, 8, 47}, {0, 8, 37}, 
 {0, 8, 28}, {0, 4, 28}, {0, 4, 18}, {0, 4, 18}, 
 {4, 4, 18}, {4, 4, 28}, {3, 4, 28}, {0, 4, 37}, 
 {0, 4, 37}, {0, 4, 37}, {0, 4, 37}, {0, 4, 28}, 
 {0, 0, 18}, {0, 0, 9}, {0, 0, 9}, {0, 4, 9}, 
 {0, 4, 9}, {0, 4, 9}, {0, 4, 9}, {0, 4, 0}, 
 {0, 4, 0}, {0, 4, 9}, {0, 4, 9}, {0, 8, 18}, 
 {0, 8, 28}, {0, 4, 28}, {0, 4, 28}, {3, 4, 28}, 
 {4, 4, 18}, {4, 4, 9}, {4, 4, 9}, {4, 4, 18}, 
 {4, 4, 28}, {7, 8, 37}, {4, 12, 47}, {8, 12, 56}, 
 {7, 12, 66}, {7, 16, 75}, {7, 16, 75}, {11, 16, 75}, 
 {11, 16, 75}, {11, 16, 75}, {7, 16, 66}, {7, 16, 66}, 
 {7, 16, 66}, {4, 16, 66}, {3, 16, 66}, {4, 12, 56}, 
 {4, 8, 47}, {4, 4, 37}, {4, 4, 28}, {4, 0, 18}, 
 {4, 0, 18}, {3, 0, 18}, {0, 0, 9}, {0, 0, 9}, 
 {0, 4, 9}, {0, 4, 9}, {0, 4, 9}, {0, 0, 9}, 
 {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 9}, 
 {4, 4, 9}, {4, 4, 9}, {4, 4, 9}, {3, 4, 9}, 
 {0, 4, 9}, {0, 4, 9}, {0, 0, 9}, {0, 0, 9}, 
 {0, 0, 9}, {0, 4, 9}, {0, 4, 9}, {4, 4, 9}, 
 {4, 4, 18}, {4, 8, 28}, {7, 8, 37}, {4, 8, 47}, 
 {3, 8, 47}, {3, 8, 47}, {0, 4, 47}, {0, 4, 37}, 
 {0, 4, 37}, {0, 4, 37}, {0, 4, 37}, {0, 4, 47}, 
 {0, 4, 56}, {3, 8, 56}, {4, 12, 56}, {7, 20, 66}, 
 {7, 24, 66}, {3, 20, 66}, {0, 16, 56}, {0, 8, 56}, 
 {0, 4, 47}, {0, 4, 28}, {0, 4, 18}, {4, 4, 9}, 
 {4, 4, 9}, {0, 4, 18}, {0, 4, 28}, {0, 8, 37}, 
 {0, 8, 56}, {3, 12, 66}, {7, 12, 75}, {8, 16, 75}, 
 {8, 16, 85}, {7, 20, 85}, {8, 20, 75}, {7, 16, 75}, 
 {7, 12, 66}, {4, 12, 56}, {3, 8, 47}, {3, 8, 37}, 
 {0, 8, 37}, {0, 4, 28}, {0, 4, 28}, {0, 4, 28}, 
 {0, 4, 28}, {0, 4, 28}, {0, 4, 28}, {0, 8, 28}, 
 {0, 8, 18}, {0, 8, 9}, {4, 8, 9}, {4, 4, 9}, 
 {4, 4, 18}, {4, 8, 37}, {4, 12, 56}, {3, 12, 66}, 
 {3, 16, 66}, {3, 16, 56}, {4, 16, 56}, {8, 12, 56}, 
 {7, 8, 56}, {7, 8, 47}, {4, 4, 47}, {4, 4, 47}, 
 {4, 4, 47}, {3, 8, 56}, {3, 12, 56}, {3, 12, 66}, 
 {3, 12, 66}, {3, 12, 75}, {3, 12, 75}, {4, 12, 75}, 
 {4, 12, 75}, {7, 12, 75}, {7, 12, 75}, {7, 12, 66}, 
 {4, 8, 56}, {3, 4, 47}, {0, 0, 28}, {0, 0, 18}, 
 {0, 0, 9}, {0, 0, 9}, {0, 0, 9}, {4, 0, 9}, 
 {4, 0, 9}, {4, 0, 9}, {4, 0, 9}, {0, 0, 0}, 
 {0, 0, 0}, {0, 4, 0}, {0, 4, 0}, {0, 4, 9}, 
 {0, 4, 9}, {4, 4, 9}, {4, 4, 9}, {4, 4, 9}, 
 {4, 4, 18}, {4, 8, 28}, {4, 8, 37}, {4, 8, 47}, 
 {4, 8, 56}, {4, 12, 56}, {3, 12, 47}, {0, 16, 47}, 
 {0, 8, 37}, {0, 8, 28}, {0, 4, 18}, {0, 4, 9}, 
 {0, 0, 9}, {0, 0, 9}, {0, 4, 9}, {3, 4, 18}, 
 {4, 8, 28}, {4, 12, 37}, {4, 16, 47}, {4, 16, 47}, 
 {4, 12, 37}, {4, 8, 28}, {4, 4, 18}, {4, 4, 9}, 
 },
   /* shadow-iris */
{{36, 20, 18}, {32, 20, 18}, {31, 20, 18}, {31, 20, 18}, 
 {32, 24, 18}, {35, 28, 18}, {36, 32, 18}, {28, 24, 18}, 
 {27, 20, 18}, {24, 16, 18}, {23, 12, 18}, {23, 12, 18}, 
 {23, 16, 18}, {24, 20, 18}, {24, 20, 18}, {23, 20, 18}, 
 {19, 20, 18}, {16, 20, 18}, {19, 16, 9}, {20, 12, 9}, 
 {23, 12, 9}, {24, 16, 9}, {24, 20, 9}, {24, 20, 9}, 
 {20, 20, 9}, {20, 16, 9}, {20, 8, 9}, {23, 12, 9}, 
 {24, 12, 9}, {28, 16, 9}, {28, 20, 9}, {28, 20, 9}, 
 {27, 20, 9}, {24, 20, 18}, {23, 16, 18}, {23, 16, 18}, 
 {20, 16, 18}, {19, 12, 18}, {16, 12, 9}, {19, 16, 9}, 
 {20, 16, 9}, {23, 16, 9}, {28, 16, 9}, {35, 16, 18}, 
 {44, 20, 28}, {56, 23, 37}, {64, 19, 47}, {76, 23, 47}, 
 {80, 27, 37}, {88, 35, 37}, {88, 35, 37}, {88, 31, 28}, 
 {68, 31, 28}, {52, 23, 28}, {44, 20, 28}, {36, 20, 28}, 
 {35, 24, 28}, {35, 24, 28}, {35, 24, 28}, {35, 20, 28}, 
 {32, 20, 18}, {28, 20, 18}, {28, 20, 18}, {27, 16, 18}, 
 {27, 16, 18}, {28, 16, 18}, {31, 16, 18}, {35, 16, 28}, 
 {40, 19, 28}, {48, 23, 37}, {60, 23, 47}, {72, 31, 56}, 
 {88, 35, 66}, {100, 39, 75}, {96, 44, 75}, {96, 48, 75}, 
 {100, 40, 84}, {100, 40, 75}, {84, 27, 56}, {72, 23, 47}, 
 {56, 23, 37}, {44, 23, 18}, {36, 20, 9}, {35, 16, 9}, 
 {32, 16, 9}, {28, 16, 9}, {28, 20, 9}, {35, 20, 9}, 
 {35, 24, 9}, {35, 24, 18}, {35, 20, 18}, {35, 20, 18}, 
 {35, 24, 18}, {36, 24, 28}, {40, 23, 28}, {44, 23, 28}, 
 {56, 27, 28}, {64, 27, 37}, {72, 27, 37}, {76, 35, 37}, 
 {64, 31, 37}, {52, 23, 28}, {52, 23, 28}, {52, 23, 28}, 
 {60, 27, 37}, {64, 23, 37}, {68, 27, 47}, {72, 27, 47}, 
 {80, 35, 56}, {88, 40, 65}, {101, 44, 66}, {100, 43, 56}, 
 {84, 35, 56}, {68, 39, 56}, {40, 40, 47}, {39, 28, 37}, 
 {40, 23, 28}, {43, 20, 28}, {44, 23, 28}, {48, 23, 37}, 
 {52, 24, 37}, {56, 27, 37}, {52, 27, 37}, {47, 27, 47}, 
 {39, 24, 47}, {35, 24, 37}, {35, 20, 37}, {28, 24, 28}, 
 {28, 24, 18}, {24, 24, 18}, {23, 20, 18}, {19, 16, 18}, 
 {15, 16, 18}, {16, 16, 18}, {19, 16, 18}, {20, 16, 18}, 
 {23, 20, 18}, {23, 20, 18}, {23, 16, 18}, {20, 12, 18}, 
 {24, 12, 18}, {27, 12, 18}, {31, 16, 18}, {32, 16, 18}, 
 {35, 16, 18}, {36, 16, 18}, {36, 20, 18}, {36, 20, 18}, 
 {40, 20, 18}, {40, 19, 18}, {44, 20, 28}, {56, 23, 37}, 
 {64, 23, 56}, {76, 31, 66}, {84, 68, 75}, {108, 60, 94}, 
 {121, 64, 94}, {125, 52, 94}, {117, 56, 84}, {109, 39, 75}, 
 {104, 40, 75}, {104, 43, 65}, {109, 35, 66}, {100, 35, 56}, 
 {80, 31, 47}, {72, 19, 37}, {56, 19, 28}, {52, 19, 28}, 
 {48, 20, 28}, {44, 19, 28}, {39, 16, 28}, {36, 16, 18}, 
 {32, 16, 9}, {36, 20, 9}, {35, 20, 18}, {40, 24, 18}, 
 {48, 23, 28}, {72, 31, 37}, {92, 31, 56}, {113, 44, 84}, 
 {141, 60, 94}, {202, 181, 188}, {177, 116, 142}, {145, 76, 122}, 
 {145, 76, 113}, {137, 80, 113}, {129, 56, 94}, {125, 56, 84}, 
 {121, 47, 75}, {104, 35, 66}, {96, 35, 56}, {84, 31, 47}, 
 {76, 35, 37}, {64, 23, 28}, {52, 23, 28}, {44, 20, 18}, 
 {39, 16, 18}, {31, 16, 18}, {24, 16, 18}, {20, 16, 18}, 
 {16, 12, 9}, {16, 12, 9}, {16, 12, 9}, {16, 16, 9}, 
 {15, 16, 9}, {15, 12, 9}, {15, 12, 18}, {16, 12, 18}, 
 {16, 12, 18}, {19, 12, 18}, {20, 12, 18}, {24, 12, 18}, 
 {27, 12, 18}, {27, 16, 28}, {27, 16, 28}, {27, 16, 28}, 
 {28, 16, 28}, {31, 16, 28}, {40, 19, 28}, {48, 23, 37}, 
 {52, 23, 47}, {56, 27, 47}, {64, 35, 47}, {72, 31, 47}, 
 {68, 35, 47}, {60, 36, 47}, {48, 31, 37}, {40, 24, 28}, 
 {40, 24, 28}, {43, 24, 28}, {48, 28, 28}, {52, 32, 37}, 
 {64, 31, 47}, {68, 27, 47}, {80, 31, 47}, {84, 31, 56}, 
 {88, 35, 56}, {96, 35, 56}, {96, 31, 56}, {84, 31, 56}, 
 {76, 27, 56}, {72, 27, 56}, {68, 27, 56}, {60, 27, 47}, 
 {52, 23, 37}, {40, 20, 28}, {31, 20, 28}, {16, 20, 28}, 
 {20, 12, 28}, {20, 12, 28}, {23, 12, 18}, {27, 16, 18}, 
 {32, 20, 28}, {35, 24, 28}, {36, 28, 28}, {40, 28, 37}, 
 },
   /* solid-sky */
{{145, 104, 84}, {178, 111, 75}, {202, 123, 75}, {198, 127, 75}, 
 {129, 112, 85}, {84, 72, 37}, {40, 40, 28}, {20, 16, 18}, 
 {11, 4, 28}, {12, 4, 28}, {23, 24, 28}, {0, 93, 141}, 
 {0, 109, 160}, {4, 122, 170}, {7, 134, 179}, {19, 138, 188}, 
 {24, 142, 179}, {31, 151, 179}, {44, 158, 179}, {52, 162, 179}, 
 {129, 117, 122}, {190, 137, 103}, {214, 152, 66}, {206, 131, 37}, 
 {202, 119, 28}, {198, 106, 9}, {194, 90, 9}, {166, 43, 9}, 
 {133, 18, 0}, {72, 19, 9}, {60, 19, 18}, {36, 28, 9}, 
 {36, 36, 18}, {52, 60, 37}, {0, 101, 150}, {0, 109, 150}, 
 {0, 109, 150}, {0, 105, 150}, {0, 97, 141}, {20, 36, 18}, 
 {16, 24, 9}, {8, 8, 9}, {12, 4, 9}, {12, 4, 9}, 
 {11, 4, 9}, {8, 4, 9}, {4, 4, 9}, {7, 4, 9}, 
 {8, 0, 9}, {12, 0, 9}, {15, 0, 9}, {16, 4, 18}, 
 {19, 12, 28}, {0, 89, 141}, {0, 97, 160}, {0, 101, 160}, 
 {0, 101, 150}, {60, 60, 37}, {68, 31, 18}, {105, 30, 9}, 
 {170, 80, 9}, {198, 90, 0}, {178, 67, 0}, {133, 30, 0}, 
 {72, 15, 9}, {36, 12, 18}, {23, 8, 9}, {16, 4, 9}, 
 {19, 8, 9}, {27, 20, 18}, {52, 44, 37}, {4, 105, 150}, 
 {60, 162, 188}, {173, 173, 160}, {198, 165, 151}, {194, 148, 113}, 
 {218, 160, 84}, {222, 153, 84}, {214, 132, 47}, {210, 123, 37}, 
 {202, 111, 28}, {218, 118, 28}, {202, 119, 47}, {149, 104, 85}, 
 {88, 116, 113}, {4, 113, 160}, {0, 118, 160}, {0, 122, 160}, 
 {0, 122, 160}, {0, 122, 160}, {0, 122, 170}, {4, 122, 170}, 
 {0, 118, 170}, {0, 114, 170}, {0, 109, 160}, {0, 101, 150}, 
 {44, 60, 28}, {28, 36, 9}, {20, 16, 9}, {16, 8, 9}, 
 {15, 4, 9}, {12, 0, 18}, {11, 0, 18}, {8, 0, 18}, 
 {8, 0, 18}, {12, 4, 9}, {15, 4, 9}, {20, 4, 9}, 
 {28, 12, 18}, {36, 36, 18}, {52, 52, 47}, {0, 97, 150}, 
 {0, 101, 150}, {73, 73, 66}, {64, 60, 37}, {48, 56, 28}, 
 {64, 64, 47}, {0, 105, 150}, {0, 118, 160}, {4, 122, 170}, 
 {8, 126, 170}, {4, 130, 170}, {4, 134, 170}, {0, 130, 170}, 
 {0, 126, 170}, {0, 126, 170}, {0, 122, 170}, {0, 114, 170}, 
 {0, 105, 160}, {0, 93, 150}, {16, 32, 28}, {16, 12, 18}, 
 {19, 8, 9}, {20, 20, 18}, {28, 44, 28}, {0, 97, 141}, 
 {4, 118, 160}, {23, 142, 179}, {44, 158, 188}, {60, 166, 197}, 
 {60, 166, 197}, {68, 170, 197}, {72, 170, 197}, {72, 173, 197}, 
 {96, 177, 188}, {149, 145, 103}, {214, 143, 75}, {210, 127, 47}, 
 {154, 99, 37}, {68, 68, 28}, {44, 35, 18}, {24, 20, 18}, 
 {15, 8, 18}, {7, 4, 18}, {4, 0, 18}, {3, 4, 18}, 
 {7, 4, 18}, {11, 4, 18}, {19, 8, 18}, {32, 36, 28}, 
 {0, 105, 150}, {24, 138, 179}, {72, 174, 188}, {149, 190, 197}, 
 {206, 218, 207}, {210, 222, 207}, {218, 210, 207}, {218, 218, 198}, 
 {218, 210, 198}, {194, 194, 170}, {194, 181, 160}, {141, 137, 103}, 
 {113, 81, 75}, {72, 84, 37}, {52, 68, 28}, {52, 48, 28}, 
 {68, 64, 28}, {81, 80, 37}, {141, 88, 47}, {194, 106, 37}, 
 {206, 106, 28}, {206, 110, 18}, {206, 110, 9}, {194, 98, 18}, 
 {174, 87, 37}, {96, 88, 94}, {4, 113, 150}, {12, 134, 170}, 
 {19, 142, 179}, {31, 147, 179}, {39, 151, 188}, {48, 158, 188}, 
 {48, 166, 188}, {48, 162, 188}, {43, 159, 197}, {39, 151, 198}, 
 {27, 147, 188}, {23, 142, 179}, {20, 138, 179}, {19, 134, 179}, 
 {8, 130, 179}, {4, 122, 160}, {4, 109, 160}, {0, 97, 150}, 
 {44, 36, 37}, {31, 16, 18}, {23, 8, 18}, {23, 8, 18}, 
 {27, 28, 28}, {0, 93, 141}, {0, 105, 150}, {0, 97, 141}, 
 {48, 39, 37}, {28, 28, 18}, {32, 24, 9}, {44, 15, 9}, 
 {60, 27, 18}, {93, 55, 37}, {154, 84, 37}, {186, 98, 28}, 
 {186, 102, 9}, {170, 87, 18}, {73, 80, 28}, {40, 52, 18}, 
 {40, 36, 18}, {48, 35, 18}, {64, 60, 18}, {149, 75, 0}, 
 {194, 94, 9}, {198, 98, 9}, {214, 105, 0}, {210, 98, 9}, 
 {210, 101, 18}, {198, 112, 37}, {190, 107, 56}, {108, 108, 94}, 
 {4, 105, 150}, {0, 105, 160}, {0, 109, 160}, {0, 105, 160}, 
 {0, 101, 160}, {0, 89, 141}, {11, 8, 37}, {11, 4, 28}, 
 {11, 4, 18}, {12, 4, 18}, {20, 8, 18}, {36, 12, 18}, 
 {64, 19, 9}, {77, 11, 0}, {109, 19, 0}, {169, 14, 9}, 
 {149, 67, 18}, {85, 85, 66}, {24, 113, 150}, {35, 155, 188}, 
 },
   /* misty-field */
{{84, 89, 103}, {96, 100, 94}, {101, 105, 85}, {93, 105, 84}, 
 {89, 109, 85}, {100, 113, 94}, {109, 121, 103}, {104, 117, 113}, 
 {116, 117, 122}, {121, 141, 141}, {133, 166, 179}, {153, 185, 197}, 
 {161, 185, 207}, {157, 189, 207}, {161, 185, 207}, {157, 177, 207}, 
 {149, 169, 198}, {133, 158, 188}, {116, 146, 179}, {108, 133, 179}, 
 {108, 133, 179}, {116, 141, 179}, {112, 141, 170}, {129, 150, 170}, 
 {133, 157, 188}, {141, 161, 188}, {137, 153, 169}, {125, 141, 141}, 
 {121, 133, 113}, {109, 121, 94}, {105, 125, 85}, {101, 133, 84}, 
 {101, 133, 85}, {109, 133, 85}, {97, 133, 85}, {93, 121, 75}, 
 {97, 125, 85}, {101, 117, 85}, {105, 117, 75}, {89, 117, 75}, 
 {84, 121, 75}, {93, 141, 75}, {109, 150, 75}, {117, 170, 103}, 
 {133, 178, 122}, {145, 170, 151}, {169, 194, 188}, {169, 198, 207}, 
 {173, 193, 207}, {169, 189, 207}, {169, 189, 216}, {165, 189, 216}, 
 {165, 185, 216}, {161, 181, 216}, {157, 181, 226}, {157, 185, 226}, 
 {157, 189, 225}, {177, 201, 226}, {205, 210, 235}, {214, 218, 244}, 
 {214, 222, 244}, {209, 222, 244}, {205, 218, 244}, {193, 214, 235}, 
 {177, 197, 216}, {177, 189, 207}, {169, 185, 207}, {169, 181, 207}, 
 {165, 177, 216}, {161, 181, 216}, {165, 185, 216}, {165, 189, 216}, 
 {169, 193, 216}, {177, 197, 216}, {193, 206, 226}, {206, 222, 226}, 
 {218, 222, 235}, {222, 226, 244}, {226, 222, 235}, {222, 230, 244}, 
 {222, 226, 254}, {222, 226, 244}, {218, 226, 244}, {218, 226, 244}, 
 {222, 234, 244}, {214, 226, 244}, {205, 218, 235}, {185, 197, 216}, 
 {165, 181, 207}, {141, 153, 169}, {121, 121, 141}, {105, 101, 113}, 
 {84, 84, 94}, {77, 85, 85}, {73, 77, 75}, {73, 73, 75}, 
 {73, 73, 75}, {73, 77, 75}, {73, 85, 85}, {77, 97, 85}, 
 {84, 113, 94}, {104, 133, 132}, {112, 154, 132}, {129, 162, 160}, 
 {141, 169, 188}, {145, 165, 198}, {141, 165, 207}, {137, 161, 207}, 
 {124, 165, 207}, {64, 139, 207}, {64, 139, 207}, {64, 135, 207}, 
 {100, 129, 179}, {96, 125, 160}, {108, 145, 132}, {112, 137, 103}, 
 {97, 121, 94}, {89, 113, 85}, {89, 105, 85}, {77, 89, 85}, 
 {77, 81, 84}, {77, 73, 75}, {77, 73, 75}, {77, 77, 75}, 
 {81, 81, 84}, {77, 77, 75}, {73, 73, 66}, {73, 73, 66}, 
 {73, 77, 75}, {76, 77, 94}, {68, 68, 103}, {72, 77, 103}, 
 {92, 100, 132}, {124, 133, 141}, {145, 161, 179}, {165, 185, 207}, 
 {173, 201, 225}, {201, 222, 235}, {213, 230, 244}, {222, 230, 235}, 
 {222, 226, 235}, {222, 226, 235}, {209, 222, 235}, {205, 218, 235}, 
 {185, 206, 226}, {173, 197, 216}, {169, 189, 216}, {165, 189, 207}, 
 {165, 185, 198}, {153, 169, 179}, {141, 166, 141}, {137, 154, 132}, 
 {125, 157, 132}, {121, 158, 103}, {101, 149, 75}, {85, 125, 65}, 
 {81, 117, 75}, {72, 109, 94}, {77, 85, 85}, {80, 81, 94}, 
 {81, 77, 84}, {77, 73, 75}, {73, 73, 75}, {68, 68, 66}, 
 {68, 68, 66}, {73, 73, 66}, {73, 73, 75}, {72, 72, 75}, 
 {81, 85, 75}, {81, 89, 75}, {81, 89, 75}, {85, 97, 75}, 
 {89, 97, 94}, {89, 93, 94}, {85, 89, 85}, {81, 81, 75}, 
 {85, 97, 75}, {85, 89, 75}, {85, 85, 75}, {81, 97, 75}, 
 {81, 105, 66}, {85, 97, 66}, {85, 101, 75}, {81, 101, 75}, 
 {76, 101, 75}, {73, 97, 75}, {77, 93, 75}, {73, 81, 75}, 
 {68, 77, 75}, {73, 73, 75}, {73, 73, 75}, {73, 73, 75}, 
 {73, 73, 75}, {73, 73, 66}, {81, 85, 75}, {81, 97, 66}, 
 {81, 105, 56}, {60, 101, 47}, {73, 97, 56}, {68, 89, 66}, 
 {73, 77, 66}, {73, 73, 66}, {68, 68, 75}, {52, 72, 103}, 
 {44, 81, 141}, {60, 130, 207}, {60, 135, 207}, {64, 138, 198}, 
 {96, 125, 160}, {88, 121, 122}, {84, 108, 113}, {92, 101, 103}, 
 {101, 101, 113}, {112, 117, 132}, {104, 117, 141}, {104, 125, 151}, 
 {116, 133, 170}, {128, 145, 188}, {128, 157, 198}, {129, 154, 207}, 
 {129, 157, 197}, {137, 173, 198}, {145, 173, 198}, {141, 165, 188}, 
 {133, 165, 188}, {125, 157, 188}, {120, 145, 179}, {112, 133, 170}, 
 {96, 121, 160}, {100, 117, 151}, {72, 105, 122}, {68, 89, 113}, 
 {80, 93, 103}, {76, 97, 132}, {108, 125, 151}, {137, 141, 160}, 
 {145, 157, 188}, {161, 181, 207}, {169, 193, 216}, {181, 210, 226}, 
 {193, 222, 235}, {197, 218, 235}, {181, 201, 226}, {165, 193, 216}, 
 {161, 189, 216}, {157, 181, 216}, {157, 181, 216}, {153, 181, 216}, 
 {149, 181, 207}, {157, 181, 207}, {153, 177, 207}, {149, 177, 207}, 
 {149, 177, 207}, {141, 169, 207}, {137, 165, 198}, {128, 161, 198}, 
 },
   /* wooden-highlight */
{{97, 76, 75}, {85, 68, 56}, {97, 72, 46}, {125, 84, 56}, 
 {141, 100, 85}, {149, 107, 113}, {137, 116, 122}, {153, 112, 113}, 
 {154, 133, 122}, {157, 124, 103}, {153, 124, 94}, {161, 119, 94}, 
 {178, 119, 85}, {174, 132, 103}, {170, 137, 122}, {194, 153, 122}, 
 {166, 124, 123}, {162, 125, 123}, {170, 120, 103}, {178, 131, 85}, 
 {174, 119, 66}, {166, 111, 47}, {154, 95, 47}, {137, 80, 28}, 
 {141, 72, 9}, {141, 68, 18}, {141, 64, 18}, {137, 59, 18}, 
 {125, 55, 9}, {141, 51, 9}, {125, 51, 9}, {117, 51, 18}, 
 {117, 55, 28}, {109, 55, 28}, {105, 55, 28}, {109, 51, 28}, 
 {97, 55, 28}, {101, 51, 46}, {88, 64, 47}, {109, 68, 46}, 
 {141, 96, 66}, {166, 120, 85}, {170, 119, 66}, {174, 111, 75}, 
 {170, 115, 85}, {178, 123, 85}, {150, 108, 94}, {154, 107, 85}, 
 {133, 92, 75}, {141, 88, 47}, {129, 76, 28}, {121, 64, 28}, 
 {133, 72, 28}, {137, 80, 37}, {146, 88, 37}, {150, 96, 47}, 
 {154, 99, 47}, {154, 99, 47}, {146, 92, 28}, {154, 76, 18}, 
 {146, 64, 18}, {141, 64, 28}, {141, 76, 28}, {145, 80, 37}, 
 {158, 95, 47}, {174, 106, 37}, {178, 110, 47}, {170, 102, 28}, 
 {150, 84, 18}, {129, 72, 18}, {109, 68, 18}, {96, 47, 9}, 
 {84, 35, 18}, {72, 35, 18}, {68, 35, 18}, {68, 39, 18}, 
 {76, 43, 28}, {84, 43, 28}, {92, 51, 28}, {100, 55, 28}, 
 {117, 72, 28}, {133, 88, 28}, {162, 106, 28}, {170, 106, 28}, 
 {162, 91, 28}, {150, 80, 28}, {141, 64, 28}, {125, 51, 28}, 
 {117, 47, 18}, {101, 42, 18}, {84, 39, 18}, {60, 31, 9}, 
 {44, 23, 9}, {32, 16, 9}, {24, 16, 9}, {16, 16, 9}, 
 {16, 20, 0}, {16, 16, 9}, {16, 16, 9}, {16, 20, 9}, 
 {20, 20, 9}, {27, 20, 9}, {27, 20, 9}, {27, 24, 9}, 
 {24, 20, 18}, {32, 16, 18}, {28, 16, 18}, {20, 16, 18}, 
 {19, 12, 18}, {19, 12, 18}, {16, 12, 18}, {16, 16, 18}, 
 {16, 16, 18}, {15, 16, 18}, {16, 16, 18}, {19, 16, 18}, 
 {27, 24, 18}, {31, 20, 28}, {36, 24, 28}, {48, 24, 28}, 
 {68, 35, 28}, {80, 43, 28}, {89, 51, 18}, {105, 51, 18}, 
 {109, 51, 18}, {121, 51, 18}, {121, 42, 9}, {121, 51, 18}, 
 {125, 46, 18}, {121, 55, 18}, {117, 64, 18}, {113, 68, 18}, 
 {109, 68, 18}, {105, 64, 28}, {105, 59, 28}, {96, 51, 28}, 
 {80, 43, 28}, {56, 27, 28}, {44, 19, 28}, {36, 24, 28}, 
 {24, 20, 28}, {19, 16, 18}, {12, 12, 9}, {12, 12, 9}, 
 {16, 16, 9}, {24, 20, 9}, {40, 23, 9}, {68, 35, 9}, 
 {85, 43, 9}, {105, 42, 9}, {109, 47, 18}, {109, 47, 18}, 
 {109, 46, 9}, {109, 46, 9}, {97, 38, 9}, {80, 43, 9}, 
 {60, 35, 9}, {40, 24, 18}, {32, 24, 18}, {28, 24, 18}, 
 {28, 24, 18}, {40, 28, 18}, {44, 23, 18}, {56, 31, 18}, 
 {68, 39, 18}, {80, 43, 18}, {85, 52, 28}, {101, 72, 37}, 
 {133, 88, 47}, {141, 100, 75}, {146, 112, 85}, {146, 116, 85}, 
 {146, 107, 75}, {121, 72, 37}, {113, 60, 28}, {88, 47, 28}, 
 {56, 35, 28}, {35, 24, 18}, {23, 16, 18}, {19, 16, 18}, 
 {16, 16, 18}, {16, 12, 9}, {16, 12, 9}, {24, 16, 9}, 
 {35, 20, 9}, {48, 27, 9}, {56, 31, 18}, {60, 31, 18}, 
 {68, 35, 37}, {76, 39, 37}, {76, 39, 28}, {76, 35, 28}, 
 {84, 35, 28}, {96, 38, 18}, {97, 39, 18}, {100, 38, 18}, 
 {84, 39, 28}, {68, 35, 18}, {56, 27, 18}, {44, 23, 18}, 
 {48, 23, 18}, {56, 27, 18}, {64, 35, 37}, {72, 64, 56}, 
 {89, 72, 65}, {105, 93, 84}, {137, 100, 85}, {149, 108, 94}, 
 {150, 104, 85}, {129, 92, 84}, {101, 84, 75}, {101, 72, 37}, 
 {113, 68, 28}, {133, 68, 28}, {129, 64, 18}, {137, 68, 18}, 
 {137, 72, 28}, {125, 64, 18}, {125, 60, 18}, {121, 60, 18}, 
 {117, 55, 18}, {101, 47, 28}, {84, 47, 28}, {68, 39, 28}, 
 {48, 31, 18}, {31, 24, 18}, {20, 16, 9}, {16, 12, 9}, 
 {12, 12, 9}, {11, 12, 9}, {12, 12, 9}, {16, 12, 9}, 
 {24, 12, 9}, {31, 12, 9}, {35, 16, 9}, {60, 23, 9}, 
 {64, 27, 9}, {72, 39, 18}, {72, 47, 18}, {76, 47, 28}, 
 {72, 52, 28}, {76, 47, 28}, {80, 43, 28}, {72, 35, 28}, 
 {64, 31, 18}, {60, 31, 9}, {40, 27, 9}, {27, 20, 9}, 
 {32, 20, 9}, {36, 28, 9}, {48, 27, 9}, {56, 39, 18}, 
 {81, 47, 18}, {105, 59, 18}, {121, 64, 18}, {146, 76, 28}, 
 },
   /* jet-tundra */
{{109, 92, 75}, {105, 85, 75}, {105, 85, 75}, {97, 89, 75}, 
 {93, 85, 75}, {93, 81, 75}, {93, 80, 65}, {85, 73, 65}, 
 {84, 68, 56}, {84, 68, 47}, {80, 64, 47}, {76, 64, 47}, 
 {72, 60, 37}, {68, 64, 37}, {72, 64, 47}, {77, 73, 47}, 
 {85, 76, 47}, {93, 76, 56}, {97, 80, 56}, {101, 80, 56}, 
 {105, 80, 56}, {109, 84, 56}, {105, 88, 56}, {101, 84, 56}, 
 {97, 80, 56}, {93, 76, 56}, {85, 68, 47}, {72, 60, 47}, 
 {64, 56, 37}, {60, 56, 37}, {60, 56, 37}, {68, 60, 37}, 
 {72, 56, 37}, {73, 64, 47}, {76, 68, 56}, {76, 68, 56}, 
 {81, 64, 56}, {80, 68, 56}, {81, 73, 56}, {85, 80, 65}, 
 {93, 85, 65}, {101, 93, 65}, {101, 93, 75}, {105, 97, 84}, 
 {113, 96, 84}, {113, 100, 94}, {113, 104, 94}, {113, 104, 94}, 
 {117, 108, 94}, {121, 108, 85}, {121, 104, 84}, {121, 104, 75}, 
 {117, 100, 75}, {109, 97, 75}, {105, 93, 75}, {105, 92, 65}, 
 {105, 92, 66}, {97, 89, 75}, {93, 89, 75}, {93, 85, 75}, 
 {85, 77, 65}, {81, 73, 65}, {81, 72, 56}, {77, 72, 56}, 
 {73, 73, 56}, {72, 68, 56}, {72, 68, 56}, {76, 68, 56}, 
 {77, 68, 56}, {85, 76, 56}, {89, 80, 56}, {93, 81, 65}, 
 {97, 89, 75}, {105, 92, 75}, {113, 92, 75}, {121, 92, 75}, 
 {121, 92, 66}, {113, 92, 65}, {105, 88, 65}, {93, 85, 56}, 
 {89, 84, 56}, {85, 77, 56}, {73, 73, 56}, {72, 68, 56}, 
 {72, 64, 47}, {68, 60, 47}, {68, 60, 47}, {64, 60, 47}, 
 {64, 60, 56}, {68, 60, 56}, {68, 60, 56}, {72, 64, 66}, 
 {68, 68, 56}, {68, 64, 47}, {68, 64, 47}, {64, 56, 47}, 
 {56, 52, 37}, {56, 52, 37}, {52, 52, 37}, {52, 52, 37}, 
 {52, 48, 37}, {48, 48, 37}, {48, 48, 28}, {60, 52, 28}, 
 {60, 56, 28}, {56, 52, 37}, {52, 48, 37}, {56, 48, 37}, 
 {56, 48, 37}, {60, 48, 37}, {72, 60, 47}, {85, 72, 56}, 
 {97, 85, 65}, {109, 96, 75}, {121, 104, 85}, {129, 116, 103}, 
 {133, 125, 103}, {137, 125, 113}, {137, 124, 113}, {133, 125, 103}, 
 {137, 116, 103}, {133, 112, 103}, {129, 112, 94}, {125, 116, 85}, 
 {113, 108, 85}, {105, 101, 75}, {101, 92, 66}, {93, 88, 65}, 
 {89, 85, 65}, {89, 85, 56}, {89, 85, 56}, {89, 85, 65}, 
 {89, 89, 75}, {93, 89, 84}, {104, 104, 94}, {108, 96, 94}, 
 {108, 96, 94}, {105, 97, 84}, {101, 93, 84}, {97, 80, 75}, 
 {89, 76, 65}, {81, 73, 56}, {73, 68, 47}, {68, 64, 47}, 
 {60, 56, 47}, {56, 56, 47}, {64, 64, 47}, {72, 68, 47}, 
 {81, 73, 56}, {93, 81, 56}, {97, 88, 66}, {101, 88, 75}, 
 {105, 89, 84}, {109, 97, 84}, {117, 100, 84}, {125, 100, 84}, 
 {125, 100, 84}, {121, 100, 84}, {121, 104, 84}, {121, 108, 94}, 
 {121, 108, 94}, {117, 108, 94}, {121, 108, 94}, {121, 117, 94}, 
 {133, 121, 103}, {145, 116, 103}, {149, 124, 94}, {150, 120, 94}, 
 {154, 120, 94}, {158, 128, 85}, {158, 132, 85}, {137, 120, 75}, 
 {133, 112, 66}, {113, 96, 65}, {97, 88, 56}, {85, 76, 47}, 
 {73, 68, 47}, {64, 56, 47}, {60, 52, 47}, {60, 48, 37}, 
 {64, 52, 37}, {73, 60, 37}, {85, 72, 47}, {89, 76, 47}, 
 {93, 80, 47}, {97, 81, 56}, {97, 85, 65}, {97, 88, 65}, 
 {101, 92, 65}, {101, 97, 75}, {113, 104, 84}, {125, 108, 94}, 
 {133, 116, 103}, {145, 120, 113}, {154, 137, 122}, {178, 149, 141}, 
 {198, 165, 151}, {218, 193, 179}, {210, 185, 179}, {178, 153, 141}, 
 {166, 145, 132}, {157, 141, 122}, {153, 133, 132}, {120, 112, 122}, 
 {125, 108, 113}, {121, 100, 94}, {113, 97, 75}, {109, 93, 65}, 
 {109, 92, 65}, {105, 93, 65}, {109, 93, 75}, {113, 104, 84}, 
 {113, 100, 84}, {113, 104, 84}, {113, 104, 84}, {113, 104, 75}, 
 {109, 96, 66}, {105, 92, 56}, {105, 92, 56}, {105, 88, 47}, 
 {109, 93, 56}, {113, 96, 65}, {121, 100, 75}, {125, 100, 84}, 
 {129, 108, 85}, {133, 112, 85}, {133, 112, 94}, {133, 116, 103}, 
 {137, 120, 103}, {145, 124, 103}, {137, 120, 103}, {141, 116, 94}, 
 {133, 116, 75}, {121, 100, 75}, {121, 96, 75}, {109, 92, 65}, 
 {105, 88, 65}, {101, 84, 56}, {93, 77, 56}, {85, 72, 47}, 
 {80, 68, 37}, {72, 64, 37}, {68, 64, 28}, {60, 56, 28}, 
 {64, 60, 28}, {68, 60, 37}, {76, 64, 37}, {85, 73, 37}, 
 {89, 84, 47}, {97, 88, 47}, {97, 88, 56}, {97, 85, 56}, 
 {97, 80, 56}, {93, 76, 56}, {81, 72, 56}, {73, 68, 56}, 
 },
   /* pastel-lime */
{{137, 149, 85}, {133, 146, 94}, {129, 141, 94}, {109, 133, 85}, 
 {121, 133, 85}, {105, 121, 75}, {133, 129, 75}, {162, 128, 85}, 
 {190, 107, 66}, {158, 111, 37}, {198, 115, 56}, {202, 152, 66}, 
 {174, 140, 85}, {149, 149, 75}, {137, 146, 94}, {113, 133, 75}, 
 {105, 121, 75}, {101, 121, 75}, {97, 121, 66}, {93, 105, 56}, 
 {93, 85, 56}, {113, 76, 56}, {146, 88, 18}, {162, 59, 9}, 
 {113, 68, 9}, {85, 80, 37}, {81, 68, 47}, {64, 64, 47}, 
 {52, 73, 47}, {56, 73, 37}, {64, 77, 37}, {64, 77, 28}, 
 {68, 73, 37}, {68, 77, 37}, {77, 89, 47}, {89, 109, 56}, 
 {113, 137, 75}, {109, 133, 85}, {121, 150, 103}, {137, 162, 122}, 
 {145, 166, 151}, {150, 182, 151}, {194, 198, 160}, {234, 205, 150}, 
 {214, 185, 132}, {214, 181, 94}, {210, 157, 103}, {198, 144, 94}, 
 {153, 116, 94}, {109, 113, 85}, {101, 109, 75}, {89, 100, 66}, 
 {77, 93, 66}, {69, 89, 56}, {64, 77, 56}, {60, 77, 47}, 
 {56, 81, 56}, {56, 76, 56}, {56, 73, 56}, {60, 73, 56}, 
 {68, 73, 56}, {73, 81, 56}, {73, 89, 56}, {73, 89, 56}, 
 {85, 113, 56}, {101, 121, 75}, {109, 129, 85}, {129, 150, 94}, 
 {141, 166, 113}, {166, 173, 103}, {162, 178, 132}, {174, 182, 132}, 
 {186, 190, 122}, {194, 194, 132}, {214, 202, 132}, {186, 194, 141}, 
 {170, 186, 122}, {166, 173, 103}, {162, 169, 85}, {145, 166, 85}, 
 {125, 133, 85}, {109, 117, 66}, {105, 109, 66}, {97, 97, 56}, 
 {93, 76, 56}, {113, 88, 66}, {113, 109, 75}, {170, 91, 37}, 
 {170, 119, 56}, {174, 115, 56}, {157, 145, 85}, {125, 137, 85}, 
 {109, 113, 75}, {105, 109, 75}, {101, 101, 75}, {97, 105, 66}, 
 {93, 109, 66}, {89, 113, 66}, {89, 109, 75}, {89, 109, 75}, 
 {85, 109, 75}, {85, 105, 75}, {84, 101, 66}, {81, 101, 66}, 
 {81, 101, 66}, {81, 101, 66}, {85, 105, 66}, {85, 105, 56}, 
 {89, 100, 56}, {81, 97, 56}, {73, 97, 56}, {73, 93, 56}, 
 {77, 81, 47}, {93, 76, 47}, {85, 72, 56}, {81, 73, 56}, 
 {81, 80, 66}, {89, 73, 75}, {101, 85, 84}, {113, 96, 84}, 
 {121, 121, 94}, {137, 137, 103}, {157, 149, 122}, {178, 177, 122}, 
 {202, 185, 151}, {210, 206, 170}, {214, 193, 170}, {190, 190, 170}, 
 {182, 190, 151}, {170, 186, 160}, {174, 190, 151}, {170, 194, 151}, 
 {158, 186, 141}, {149, 178, 141}, {162, 194, 160}, {149, 170, 132}, 
 {145, 153, 122}, {125, 133, 113}, {104, 117, 94}, {89, 105, 75}, 
 {77, 93, 66}, {64, 76, 56}, {56, 64, 56}, {60, 60, 56}, 
 {60, 60, 66}, {76, 64, 65}, {97, 76, 65}, {97, 97, 75}, 
 {101, 109, 75}, {105, 121, 84}, {125, 141, 103}, {129, 158, 113}, 
 {133, 158, 122}, {129, 154, 122}, {129, 158, 113}, {117, 150, 103}, 
 {109, 117, 75}, {89, 97, 66}, {73, 77, 56}, {60, 60, 47}, 
 {52, 48, 37}, {44, 39, 28}, {32, 40, 18}, {20, 20, 18}, 
 {23, 20, 28}, {20, 24, 37}, {19, 28, 37}, {36, 32, 37}, 
 {40, 48, 47}, {44, 56, 66}, {48, 44, 56}, {48, 48, 56}, 
 {44, 56, 56}, {56, 64, 56}, {56, 60, 56}, {48, 56, 47}, 
 {52, 52, 47}, {60, 48, 47}, {48, 48, 47}, {48, 48, 47}, 
 {36, 56, 47}, {40, 48, 37}, {32, 52, 37}, {44, 60, 47}, 
 {44, 52, 37}, {40, 56, 37}, {40, 64, 37}, {40, 68, 37}, 
 {48, 56, 28}, {56, 68, 37}, {48, 52, 28}, {56, 64, 37}, 
 {56, 52, 47}, {52, 64, 47}, {60, 68, 47}, {64, 64, 56}, 
 {64, 73, 56}, {68, 73, 56}, {68, 68, 47}, {68, 73, 47}, 
 {60, 77, 47}, {68, 76, 47}, {68, 81, 56}, {60, 81, 56}, 
 {60, 81, 56}, {64, 81, 56}, {68, 81, 66}, {73, 77, 75}, 
 {76, 88, 75}, {81, 93, 75}, {85, 97, 75}, {89, 105, 75}, 
 {89, 109, 75}, {93, 117, 75}, {93, 113, 85}, {101, 117, 84}, 
 {109, 129, 94}, {125, 141, 113}, {141, 161, 122}, {174, 157, 122}, 
 {190, 145, 132}, {166, 170, 103}, {162, 182, 113}, {154, 178, 132}, 
 {150, 174, 113}, {141, 170, 132}, {137, 170, 122}, {137, 162, 113}, 
 {125, 145, 103}, {121, 133, 94}, {105, 117, 85}, {101, 109, 85}, 
 {93, 109, 85}, {93, 104, 85}, {89, 109, 85}, {101, 117, 85}, 
 {117, 137, 103}, {117, 150, 113}, {116, 133, 113}, {97, 109, 94}, 
 {85, 105, 85}, {73, 97, 75}, {76, 84, 66}, {77, 84, 66}, 
 {81, 80, 56}, {73, 81, 56}, {68, 85, 56}, {64, 85, 47}, 
 {56, 85, 47}, {69, 81, 47}, {73, 81, 56}, {68, 81, 47}, 
 {73, 85, 47}, {73, 89, 56}, {81, 89, 56}, {85, 97, 56}, 
 },
   /* hell */
{{141, 31, 18}, {145, 38, 9}, {149, 34, 9}, {154, 34, 9}, 
 {154, 34, 9}, {153, 34, 18}, {154, 34, 9}, {162, 37, 0}, 
 {166, 37, 0}, {174, 46, 0}, {186, 54, 0}, {198, 67, 0}, 
 {198, 62, 0}, {174, 58, 0}, {166, 38, 0}, {158, 26, 0}, 
 {137, 22, 0}, {137, 11, 0}, {133, 11, 0}, {129, 7, 9}, 
 {137, 22, 0}, {137, 26, 9}, {129, 26, 9}, {141, 30, 0}, 
 {154, 42, 0}, {170, 50, 0}, {178, 63, 9}, {170, 75, 18}, 
 {182, 75, 18}, {182, 75, 18}, {178, 71, 9}, {186, 75, 0}, 
 {186, 75, 9}, {190, 67, 9}, {194, 67, 9}, {202, 63, 9}, 
 {198, 67, 9}, {206, 79, 9}, {218, 94, 9}, {214, 102, 18}, 
 {230, 98, 9}, {218, 103, 9}, {242, 139, 56}, {222, 98, 9}, 
 {210, 86, 9}, {194, 75, 28}, {182, 63, 9}, {170, 42, 9}, 
 {150, 38, 9}, {137, 34, 9}, {125, 26, 9}, {113, 15, 0}, 
 {101, 7, 0}, {85, 7, 0}, {73, 11, 0}, {76, 3, 0}, 
 {73, 11, 0}, {85, 11, 0}, {89, 15, 9}, {97, 26, 9}, 
 {113, 39, 18}, {125, 47, 28}, {121, 67, 37}, {133, 63, 18}, 
 {158, 59, 9}, {190, 87, 18}, {210, 98, 9}, {210, 107, 18}, 
 {218, 103, 18}, {214, 98, 9}, {202, 90, 9}, {182, 74, 9}, 
 {162, 59, 9}, {150, 42, 9}, {133, 34, 9}, {117, 26, 0}, 
 {97, 19, 0}, {80, 15, 9}, {60, 11, 9}, {56, 15, 9}, 
 {56, 15, 0}, {56, 7, 0}, {64, 7, 0}, {77, 15, 0}, 
 {89, 19, 0}, {97, 22, 0}, {117, 34, 0}, {129, 34, 0}, 
 {133, 34, 0}, {137, 34, 0}, {137, 34, 0}, {137, 38, 0}, 
 {133, 34, 0}, {129, 34, 0}, {121, 27, 0}, {113, 22, 0}, 
 {113, 22, 0}, {109, 22, 0}, {105, 26, 9}, {105, 23, 9}, 
 {105, 19, 0}, {105, 11, 0}, {109, 11, 0}, {109, 22, 0}, 
 {113, 26, 0}, {117, 31, 0}, {121, 34, 0}, {125, 30, 0}, 
 {121, 30, 0}, {117, 30, 0}, {109, 26, 0}, {101, 22, 0}, 
 {89, 19, 0}, {85, 19, 0}, {77, 23, 0}, {73, 19, 0}, 
 {73, 19, 0}, {68, 15, 9}, {76, 19, 0}, {76, 15, 9}, 
 {76, 19, 9}, {80, 27, 18}, {80, 31, 18}, {84, 23, 9}, 
 {93, 23, 9}, {105, 26, 9}, {125, 26, 18}, {117, 26, 18}, 
 {105, 27, 18}, {97, 31, 18}, {93, 27, 18}, {97, 23, 9}, 
 {89, 26, 0}, {89, 23, 0}, {89, 27, 9}, {93, 26, 0}, 
 {97, 26, 0}, {109, 27, 0}, {117, 34, 0}, {125, 34, 9}, 
 {133, 34, 9}, {141, 34, 0}, {146, 34, 0}, {154, 33, 0}, 
 {158, 29, 0}, {158, 33, 0}, {158, 38, 9}, {162, 34, 9}, 
 {161, 42, 9}, {161, 42, 9}, {162, 38, 9}, {166, 37, 0}, 
 {170, 37, 0}, {170, 50, 0}, {174, 63, 0}, {178, 63, 9}, 
 {174, 59, 0}, {162, 46, 0}, {146, 42, 0}, {129, 43, 9}, 
 {121, 38, 9}, {125, 38, 9}, {121, 38, 9}, {121, 38, 0}, 
 {117, 42, 0}, {121, 46, 9}, {125, 42, 9}, {129, 44, 18}, 
 {149, 56, 28}, {145, 75, 37}, {153, 68, 28}, {182, 80, 47}, 
 {165, 95, 75}, {165, 99, 84}, {194, 124, 75}, {178, 120, 56}, 
 {173, 87, 37}, {174, 83, 37}, {174, 79, 28}, {169, 55, 28}, 
 {157, 46, 28}, {154, 55, 9}, {154, 55, 9}, {146, 43, 9}, 
 {149, 51, 0}, {154, 46, 0}, {146, 42, 0}, {150, 42, 9}, 
 {150, 38, 9}, {146, 34, 9}, {141, 39, 18}, {133, 43, 18}, 
 {133, 39, 18}, {141, 42, 19}, {146, 51, 9}, {149, 59, 9}, 
 {158, 67, 9}, {190, 86, 18}, {202, 95, 18}, {206, 79, 9}, 
 {194, 72, 0}, {174, 63, 9}, {149, 51, 18}, {133, 46, 9}, 
 {121, 55, 0}, {113, 39, 0}, {101, 31, 9}, {92, 30, 9}, 
 {101, 30, 9}, {105, 26, 9}, {117, 39, 9}, {129, 38, 9}, 
 {133, 34, 9}, {137, 34, 9}, {137, 38, 9}, {141, 38, 9}, 
 {145, 38, 9}, {145, 38, 0}, {146, 38, 0}, {154, 34, 0}, 
 {158, 34, 0}, {150, 33, 0}, {141, 27, 0}, {133, 22, 0}, 
 {125, 22, 0}, {125, 22, 0}, {121, 18, 0}, {121, 18, 0}, 
 {117, 22, 0}, {125, 27, 0}, {125, 34, 0}, {121, 38, 9}, 
 {121, 38, 9}, {121, 38, 9}, {113, 38, 9}, {105, 26, 0}, 
 {101, 19, 0}, {97, 15, 0}, {97, 15, 0}, {85, 15, 0}, 
 {84, 15, 0}, {80, 15, 0}, {77, 15, 0}, {81, 19, 0}, 
 {85, 19, 0}, {89, 22, 0}, {97, 22, 0}, {105, 22, 0}, 
 {113, 15, 9}, {125, 26, 9}, {129, 30, 0}, {129, 30, 0}, 
 {125, 22, 0}, {125, 18, 0}, {133, 18, 0}, {133, 22, 0}, 
 },
   /* indian-coast */
{{68, 56, 47}, {80, 64, 47}, {89, 76, 47}, {105, 68, 46}, 
 {104, 68, 46}, {80, 60, 37}, {60, 52, 37}, {52, 44, 37}, 
 {44, 40, 37}, {36, 40, 37}, {32, 32, 37}, {40, 44, 28}, 
 {36, 44, 28}, {36, 40, 28}, {28, 36, 28}, {20, 32, 28}, 
 {19, 24, 28}, {20, 24, 28}, {28, 28, 28}, {35, 32, 37}, 
 {27, 36, 37}, {12, 36, 47}, {20, 36, 28}, {32, 32, 28}, 
 {32, 32, 28}, {36, 44, 28}, {36, 48, 28}, {40, 48, 28}, 
 {52, 56, 28}, {56, 60, 28}, {60, 60, 28}, {64, 60, 37}, 
 {81, 77, 47}, {93, 89, 47}, {109, 92, 37}, {113, 88, 47}, 
 {129, 96, 56}, {125, 100, 56}, {125, 100, 56}, {129, 96, 56}, 
 {121, 84, 56}, {117, 84, 56}, {109, 80, 47}, {109, 76, 46}, 
 {97, 80, 47}, {85, 77, 56}, {84, 76, 56}, {81, 72, 66}, 
 {77, 73, 66}, {89, 97, 85}, {137, 177, 188}, {169, 210, 216}, 
 {173, 210, 216}, {173, 206, 216}, {177, 202, 198}, {182, 119, 75}, 
 {166, 103, 56}, {162, 99, 56}, {178, 123, 75}, {181, 206, 207}, 
 {181, 210, 216}, {181, 210, 216}, {177, 210, 216}, {177, 210, 216}, 
 {177, 210, 207}, {165, 133, 103}, {149, 108, 56}, {141, 107, 56}, 
 {145, 103, 56}, {145, 100, 56}, {158, 103, 75}, {169, 210, 197}, 
 {169, 210, 216}, {169, 206, 207}, {141, 125, 113}, {133, 88, 75}, 
 {121, 84, 65}, {125, 76, 56}, {117, 80, 56}, {117, 76, 47}, 
 {121, 80, 46}, {121, 88, 47}, {125, 84, 56}, {133, 92, 56}, 
 {141, 103, 56}, {141, 104, 75}, {149, 149, 122}, {177, 202, 216}, 
 {177, 210, 216}, {181, 214, 216}, {185, 218, 216}, {185, 214, 216}, 
 {181, 210, 226}, {181, 210, 226}, {177, 210, 226}, {173, 210, 216}, 
 {161, 206, 197}, {121, 121, 85}, {101, 88, 56}, {84, 76, 47}, 
 {68, 68, 37}, {52, 60, 37}, {52, 60, 28}, {40, 60, 47}, 
 {56, 68, 28}, {77, 64, 37}, {109, 72, 46}, {133, 88, 56}, 
 {145, 96, 66}, {170, 115, 85}, {173, 206, 207}, {177, 206, 216}, 
 {177, 210, 226}, {177, 206, 225}, {177, 210, 216}, {177, 214, 207}, 
 {137, 137, 113}, {129, 100, 75}, {113, 88, 56}, {93, 76, 37}, 
 {85, 60, 9}, {48, 44, 18}, {44, 40, 28}, {36, 28, 28}, 
 {52, 35, 28}, {52, 48, 47}, {64, 56, 56}, {76, 72, 56}, 
 {93, 85, 56}, {117, 109, 84}, {157, 206, 207}, {165, 206, 225}, 
 {169, 206, 225}, {169, 206, 225}, {169, 210, 216}, {165, 198, 207}, 
 {121, 108, 94}, {117, 88, 65}, {109, 72, 56}, {109, 72, 56}, 
 {85, 72, 56}, {80, 68, 56}, {80, 64, 56}, {76, 68, 56}, 
 {81, 72, 56}, {85, 76, 56}, {105, 80, 56}, {121, 80, 56}, 
 {141, 96, 66}, {145, 104, 75}, {157, 166, 141}, {181, 210, 207}, 
 {189, 210, 216}, {185, 214, 216}, {185, 210, 207}, {186, 127, 85}, 
 {154, 99, 66}, {145, 99, 56}, {145, 99, 56}, {146, 96, 47}, 
 {158, 88, 47}, {157, 99, 56}, {186, 127, 75}, {177, 206, 198}, 
 {169, 210, 216}, {153, 194, 207}, {108, 104, 94}, {85, 89, 75}, 
 {73, 76, 56}, {64, 68, 47}, {56, 60, 47}, {60, 60, 56}, 
 {68, 60, 56}, {72, 68, 56}, {81, 77, 56}, {89, 89, 47}, 
 {93, 88, 56}, {105, 97, 84}, {165, 186, 197}, {189, 206, 216}, 
 {197, 214, 216}, {206, 218, 216}, {246, 229, 197}, {246, 225, 188}, 
 {206, 148, 94}, {158, 100, 75}, {133, 96, 65}, {105, 76, 56}, 
 {72, 60, 56}, {32, 48, 56}, {32, 48, 56}, {32, 48, 56}, 
 {24, 48, 66}, {52, 68, 66}, {77, 77, 84}, {113, 121, 113}, 
 {165, 206, 207}, {181, 214, 216}, {193, 218, 216}, {193, 218, 216}, 
 {202, 218, 216}, {202, 218, 216}, {202, 210, 198}, {186, 131, 75}, 
 {170, 119, 56}, {174, 115, 66}, {194, 144, 85}, {185, 214, 207}, 
 {181, 214, 216}, {181, 218, 226}, {181, 214, 226}, {189, 214, 226}, 
 {193, 218, 226}, {197, 218, 226}, {206, 218, 226}, {206, 218, 226}, 
 {201, 218, 226}, {197, 218, 226}, {198, 218, 207}, {226, 214, 179}, 
 {190, 136, 75}, {174, 115, 66}, {178, 111, 75}, {194, 152, 103}, 
 {185, 214, 207}, {181, 210, 216}, {177, 202, 216}, {149, 133, 113}, 
 {137, 100, 66}, {141, 96, 56}, {133, 84, 47}, {125, 88, 37}, 
 {129, 79, 37}, {125, 80, 47}, {109, 84, 37}, {109, 76, 46}, 
 {93, 80, 47}, {68, 64, 47}, {60, 60, 37}, {60, 60, 37}, 
 {68, 60, 47}, {72, 68, 56}, {73, 73, 66}, {81, 85, 85}, 
 {113, 133, 122}, {165, 210, 216}, {173, 210, 225}, {173, 210, 226}, 
 {173, 210, 216}, {169, 214, 216}, {165, 210, 207}, {129, 125, 85}, 
 {125, 104, 56}, {109, 84, 56}, {89, 76, 56}, {81, 77, 56}, 
 },
   /* dentist-decor */
{{218, 185, 169}, {214, 193, 151}, {210, 189, 141}, {202, 198, 132}, 
 {178, 169, 113}, {166, 162, 103}, {149, 133, 94}, {133, 120, 103}, 
 {121, 109, 94}, {109, 105, 84}, {105, 101, 84}, {105, 105, 85}, 
 {109, 109, 85}, {109, 109, 85}, {109, 109, 85}, {117, 109, 94}, 
 {129, 129, 103}, {137, 146, 94}, {146, 166, 94}, {146, 166, 85}, 
 {137, 149, 85}, {133, 141, 85}, {141, 141, 85}, {137, 146, 85}, 
 {141, 137, 94}, {137, 145, 103}, {146, 154, 113}, {158, 162, 122}, 
 {157, 166, 113}, {154, 170, 113}, {150, 170, 122}, {166, 182, 132}, 
 {194, 177, 141}, {210, 185, 141}, {218, 185, 151}, {230, 180, 141}, 
 {234, 180, 150}, {234, 176, 141}, {230, 172, 131}, {214, 157, 113}, 
 {198, 145, 113}, {182, 128, 103}, {153, 108, 94}, {141, 100, 84}, 
 {121, 101, 84}, {117, 92, 84}, {109, 88, 94}, {96, 80, 94}, 
 {121, 76, 94}, {117, 92, 94}, {117, 105, 94}, {117, 92, 94}, 
 {129, 100, 94}, {133, 125, 103}, {153, 132, 103}, {174, 141, 122}, 
 {190, 148, 113}, {194, 165, 113}, {219, 161, 122}, {230, 180, 141}, 
 {230, 180, 141}, {238, 180, 141}, {234, 157, 151}, {230, 172, 141}, 
 {234, 157, 160}, {234, 156, 150}, {230, 157, 169}, {222, 149, 151}, 
 {219, 145, 141}, {206, 149, 122}, {198, 140, 113}, {190, 128, 113}, 
 {186, 136, 103}, {194, 128, 104}, {194, 136, 103}, {202, 140, 103}, 
 {202, 145, 113}, {202, 152, 113}, {210, 152, 113}, {222, 161, 113}, 
 {222, 169, 122}, {219, 165, 122}, {219, 169, 132}, {214, 169, 132}, 
 {210, 165, 132}, {214, 161, 132}, {219, 145, 141}, {219, 141, 132}, 
 {222, 141, 141}, {219, 145, 141}, {214, 161, 141}, {206, 168, 132}, 
 {202, 173, 132}, {174, 170, 122}, {149, 149, 103}, {137, 133, 94}, 
 {113, 108, 85}, {101, 93, 84}, {81, 77, 75}, {77, 81, 75}, 
 {85, 85, 84}, {109, 97, 84}, {137, 112, 75}, {149, 112, 94}, 
 {165, 119, 94}, {186, 123, 94}, {186, 128, 104}, {194, 136, 113}, 
 {194, 148, 113}, {206, 165, 132}, {222, 197, 160}, {250, 245, 216}, 
 {222, 197, 160}, {214, 181, 160}, {214, 181, 179}, {250, 197, 197}, 
 {238, 164, 169}, {234, 157, 160}, {234, 160, 150}, {234, 145, 151}, 
 {219, 141, 141}, {206, 137, 141}, {186, 144, 132}, {178, 153, 132}, 
 {166, 165, 122}, {162, 170, 113}, {146, 166, 103}, {137, 150, 103}, 
 {149, 137, 94}, {174, 157, 103}, {190, 173, 103}, {202, 198, 113}, 
 {206, 219, 132}, {206, 202, 113}, {190, 181, 122}, {174, 169, 113}, 
 {141, 141, 94}, {105, 113, 85}, {77, 81, 75}, {60, 64, 66}, 
 {48, 44, 47}, {44, 44, 37}, {36, 32, 37}, {24, 32, 37}, 
 {36, 36, 47}, {52, 40, 56}, {80, 64, 65}, {84, 72, 75}, 
 {105, 88, 84}, {121, 113, 103}, {145, 141, 113}, {162, 149, 122}, 
 {186, 157, 141}, {202, 181, 151}, {210, 189, 151}, {210, 193, 160}, 
 {222, 197, 160}, {218, 189, 150}, {206, 181, 141}, {210, 165, 132}, 
 {210, 153, 122}, {210, 153, 122}, {219, 141, 132}, {219, 137, 132}, 
 {206, 137, 122}, {206, 148, 122}, {206, 145, 122}, {219, 137, 132}, 
 {219, 141, 132}, {222, 145, 141}, {222, 153, 151}, {222, 164, 150}, 
 {219, 153, 151}, {219, 145, 151}, {206, 137, 151}, {169, 132, 141}, 
 {165, 141, 132}, {145, 129, 113}, {145, 108, 103}, {133, 92, 103}, 
 {137, 104, 103}, {125, 113, 103}, {125, 117, 103}, {145, 116, 103}, 
 {161, 128, 103}, {178, 152, 94}, {178, 161, 103}, {178, 165, 94}, 
 {166, 174, 94}, {154, 166, 94}, {174, 169, 94}, {154, 162, 94}, 
 {153, 149, 85}, {157, 137, 94}, {186, 132, 94}, {186, 127, 94}, 
 {190, 128, 94}, {194, 136, 104}, {190, 136, 104}, {194, 140, 94}, 
 {202, 140, 94}, {202, 145, 103}, {202, 145, 113}, {206, 149, 122}, 
 {206, 149, 132}, {210, 141, 141}, {214, 137, 141}, {206, 137, 141}, 
 {206, 137, 132}, {198, 141, 132}, {198, 145, 122}, {194, 145, 122}, 
 {178, 148, 122}, {174, 161, 122}, {166, 165, 103}, {162, 178, 94}, 
 {158, 170, 103}, {162, 186, 113}, {178, 186, 94}, {190, 194, 103}, 
 {190, 177, 122}, {198, 173, 132}, {186, 161, 151}, {206, 145, 151}, 
 {214, 141, 141}, {219, 141, 132}, {206, 141, 122}, {219, 137, 113}, 
 {202, 145, 122}, {194, 140, 122}, {182, 136, 113}, {182, 132, 103}, 
 {149, 120, 94}, {121, 105, 84}, {93, 76, 65}, {85, 68, 66}, 
 {72, 68, 75}, {48, 48, 66}, {48, 40, 47}, {44, 44, 47}, 
 {44, 40, 47}, {40, 44, 47}, {32, 40, 47}, {28, 40, 56}, 
 {32, 36, 56}, {44, 44, 56}, {68, 56, 66}, {85, 81, 65}, 
 {105, 101, 75}, {117, 117, 85}, {137, 133, 85}, {133, 137, 94}, 
 {145, 120, 85}, {133, 108, 75}, {97, 97, 66}, {76, 68, 75}, 
 },
   /* greenland */
{{173, 210, 188}, {169, 185, 198}, {145, 169, 198}, {141, 161, 188}, 
 {137, 157, 179}, {125, 153, 169}, {120, 158, 169}, {129, 158, 170}, 
 {137, 174, 169}, {162, 198, 160}, {194, 234, 197}, {206, 242, 206}, 
 {229, 242, 225}, {254, 238, 225}, {254, 233, 216}, {250, 237, 216}, 
 {250, 229, 216}, {234, 209, 188}, {230, 201, 179}, {222, 189, 169}, 
 {206, 168, 141}, {190, 173, 132}, {214, 189, 160}, {230, 197, 169}, 
 {234, 201, 188}, {230, 210, 197}, {242, 225, 216}, {250, 242, 235}, 
 {238, 250, 244}, {234, 242, 254}, {218, 234, 254}, {205, 222, 254}, 
 {193, 210, 235}, {181, 201, 226}, {165, 181, 216}, {141, 165, 198}, 
 {137, 165, 188}, {137, 169, 188}, {145, 178, 170}, {162, 210, 169}, 
 {189, 226, 207}, {197, 230, 216}, {214, 238, 225}, {222, 238, 244}, 
 {222, 238, 254}, {222, 238, 254}, {221, 238, 254}, {218, 238, 254}, 
 {213, 242, 244}, {197, 238, 225}, {181, 230, 216}, {177, 197, 216}, 
 {137, 173, 188}, {125, 158, 169}, {120, 154, 170}, {124, 157, 179}, 
 {133, 165, 188}, {153, 177, 198}, {177, 193, 226}, {189, 205, 235}, 
 {201, 218, 235}, {210, 238, 225}, {214, 242, 225}, {218, 242, 226}, 
 {218, 242, 235}, {218, 246, 235}, {214, 242, 235}, {214, 238, 235}, 
 {214, 238, 235}, {218, 238, 235}, {218, 238, 235}, {218, 238, 235}, 
 {218, 238, 225}, {214, 242, 225}, {206, 238, 216}, {198, 230, 207}, 
 {181, 218, 188}, {166, 186, 160}, {150, 150, 170}, {137, 141, 170}, 
 {133, 141, 160}, {125, 137, 160}, {121, 145, 169}, {120, 146, 170}, 
 {124, 150, 170}, {112, 153, 169}, {116, 146, 170}, {120, 154, 170}, 
 {129, 154, 169}, {145, 165, 179}, {169, 202, 188}, {189, 222, 207}, 
 {189, 226, 207}, {177, 206, 179}, {174, 186, 151}, {153, 166, 151}, 
 {133, 146, 151}, {133, 146, 151}, {116, 141, 151}, {108, 133, 151}, 
 {104, 129, 151}, {100, 129, 151}, {104, 129, 160}, {108, 133, 160}, 
 {108, 137, 160}, {112, 137, 160}, {112, 137, 160}, {113, 137, 160}, 
 {116, 137, 160}, {112, 141, 160}, {112, 141, 170}, {108, 141, 170}, 
 {108, 137, 170}, {108, 137, 170}, {112, 133, 160}, {116, 129, 141}, 
 {104, 121, 132}, {100, 117, 132}, {100, 129, 132}, {104, 133, 141}, 
 {116, 133, 141}, {116, 133, 151}, {133, 141, 160}, {145, 145, 160}, 
 {166, 153, 151}, {174, 161, 151}, {182, 166, 160}, {222, 189, 179}, 
 {230, 201, 188}, {206, 206, 216}, {210, 222, 235}, {222, 230, 244}, 
 {222, 234, 254}, {222, 234, 254}, {226, 234, 254}, {226, 234, 254}, 
 {226, 242, 254}, {226, 246, 254}, {226, 246, 254}, {230, 250, 254}, 
 {234, 250, 254}, {234, 250, 254}, {230, 246, 254}, {226, 246, 254}, 
 {222, 242, 254}, {218, 242, 244}, {210, 238, 225}, {193, 230, 216}, 
 {202, 214, 197}, {218, 193, 169}, {202, 181, 151}, {186, 169, 160}, 
 {186, 181, 170}, {189, 218, 207}, {206, 238, 226}, {214, 238, 235}, 
 {222, 238, 244}, {218, 234, 244}, {213, 222, 244}, {205, 218, 244}, 
 {205, 218, 244}, {197, 210, 235}, {201, 206, 226}, {193, 206, 226}, 
 {189, 206, 226}, {197, 214, 226}, {214, 238, 226}, {226, 242, 235}, 
 {230, 246, 244}, {230, 246, 244}, {226, 246, 244}, {222, 238, 244}, 
 {222, 234, 244}, {213, 218, 244}, {201, 209, 235}, {185, 201, 226}, 
 {177, 193, 216}, {161, 161, 179}, {166, 153, 179}, {170, 154, 151}, 
 {178, 161, 151}, {178, 169, 151}, {202, 173, 151}, {222, 193, 169}, 
 {234, 205, 188}, {246, 218, 216}, {250, 230, 225}, {230, 242, 244}, 
 {226, 242, 254}, {226, 242, 254}, {226, 242, 254}, {226, 242, 254}, 
 {225, 238, 254}, {222, 238, 254}, {222, 238, 254}, {222, 238, 254}, 
 {222, 234, 254}, {218, 234, 235}, {217, 238, 225}, {201, 234, 207}, 
 {186, 222, 179}, {162, 194, 160}, {150, 182, 151}, {129, 166, 141}, 
 {125, 158, 132}, {141, 146, 122}, {145, 141, 132}, {174, 153, 132}, 
 {194, 161, 132}, {202, 160, 132}, {222, 189, 169}, {234, 205, 188}, 
 {238, 221, 216}, {234, 234, 235}, {226, 238, 244}, {226, 238, 254}, 
 {226, 238, 254}, {226, 238, 254}, {226, 238, 254}, {230, 242, 254}, 
 {230, 250, 244}, {234, 254, 244}, {246, 254, 235}, {254, 245, 235}, 
 {250, 242, 254}, {238, 250, 254}, {234, 246, 254}, {234, 246, 244}, 
 {234, 246, 244}, {230, 242, 244}, {226, 238, 244}, {226, 242, 244}, 
 {226, 242, 244}, {226, 246, 244}, {226, 246, 244}, {226, 250, 244}, 
 {226, 246, 244}, {222, 242, 244}, {222, 238, 244}, {222, 234, 244}, 
 {214, 226, 244}, {205, 218, 244}, {185, 201, 235}, {173, 193, 216}, 
 {145, 165, 188}, {129, 153, 170}, {125, 149, 160}, {120, 146, 160}, 
 {112, 146, 160}, {112, 146, 151}, {112, 142, 160}, {112, 141, 160}, 
 {112, 141, 170}, {116, 141, 170}, {116, 141, 170}, {112, 141, 169}, 
 },
   /* purple-dress */
{{198, 96, 142}, {206, 108, 142}, {198, 136, 122}, {178, 153, 132}, 
 {182, 149, 141}, {174, 149, 132}, {158, 137, 113}, {153, 120, 103}, 
 {153, 111, 103}, {153, 107, 94}, {146, 104, 85}, {137, 100, 84}, 
 {121, 92, 84}, {109, 89, 84}, {109, 85, 84}, {109, 85, 84}, 
 {117, 84, 84}, {137, 96, 94}, {149, 104, 94}, {170, 88, 113}, 
 {178, 92, 123}, {178, 88, 132}, {186, 96, 142}, {194, 100, 142}, 
 {194, 104, 132}, {182, 128, 113}, {173, 132, 113}, {162, 136, 113}, 
 {154, 137, 113}, {153, 133, 113}, {157, 124, 113}, {154, 116, 113}, 
 {169, 92, 123}, {177, 88, 132}, {190, 100, 142}, {206, 108, 151}, 
 {219, 121, 170}, {238, 141, 188}, {246, 168, 207}, {246, 205, 188}, 
 {219, 173, 151}, {246, 188, 178}, {249, 225, 225}, {190, 161, 151}, 
 {174, 149, 132}, {165, 128, 113}, {165, 115, 94}, {166, 111, 94}, 
 {174, 120, 103}, {170, 132, 113}, {166, 141, 122}, {165, 141, 122}, 
 {161, 141, 132}, {157, 137, 132}, {157, 137, 141}, {169, 141, 141}, 
 {174, 150, 151}, {178, 157, 141}, {182, 157, 141}, {178, 153, 141}, 
 {186, 161, 151}, {210, 117, 161}, {218, 121, 161}, {219, 121, 161}, 
 {218, 112, 161}, {222, 125, 160}, {219, 157, 141}, {219, 161, 141}, 
 {202, 153, 122}, {170, 140, 122}, {161, 124, 122}, {157, 96, 132}, 
 {149, 88, 132}, {153, 88, 132}, {157, 84, 122}, {161, 80, 123}, 
 {169, 84, 142}, {173, 92, 142}, {177, 88, 142}, {169, 88, 132}, 
 {157, 84, 122}, {149, 80, 113}, {141, 80, 103}, {137, 92, 94}, 
 {145, 104, 94}, {146, 116, 94}, {145, 124, 103}, {150, 129, 103}, 
 {154, 128, 103}, {161, 124, 94}, {158, 116, 94}, {158, 112, 94}, 
 {153, 124, 113}, {150, 128, 113}, {150, 133, 113}, {145, 133, 113}, 
 {145, 133, 122}, {153, 129, 132}, {153, 133, 132}, {154, 133, 132}, 
 {154, 133, 122}, {153, 133, 122}, {153, 133, 113}, {161, 128, 113}, 
 {165, 120, 113}, {186, 104, 123}, {190, 96, 123}, {198, 100, 132}, 
 {202, 104, 132}, {198, 104, 132}, {182, 100, 132}, {170, 112, 123}, 
 {157, 128, 122}, {162, 137, 122}, {162, 140, 122}, {161, 133, 113}, 
 {170, 124, 113}, {186, 104, 132}, {198, 104, 132}, {202, 104, 142}, 
 {206, 104, 142}, {206, 104, 142}, {202, 100, 142}, {202, 96, 142}, 
 {198, 100, 142}, {198, 104, 142}, {202, 104, 142}, {198, 100, 151}, 
 {198, 101, 151}, {198, 108, 151}, {190, 100, 151}, {198, 100, 151}, 
 {194, 100, 142}, {190, 104, 142}, {182, 104, 132}, {165, 120, 113}, 
 {158, 124, 113}, {158, 120, 113}, {153, 108, 113}, {153, 88, 122}, 
 {165, 92, 122}, {166, 104, 104}, {157, 112, 104}, {157, 120, 113}, 
 {154, 120, 113}, {149, 125, 113}, {149, 116, 113}, {141, 112, 103}, 
 {133, 112, 103}, {133, 108, 103}, {133, 100, 94}, {117, 92, 84}, 
 {109, 85, 84}, {97, 81, 84}, {97, 85, 84}, {117, 96, 84}, 
 {145, 104, 94}, {157, 111, 103}, {174, 100, 123}, {186, 96, 132}, 
 {190, 100, 132}, {190, 92, 132}, {182, 100, 132}, {157, 120, 122}, 
 {141, 112, 113}, {133, 104, 103}, {117, 100, 103}, {121, 108, 113}, 
 {137, 116, 113}, {145, 124, 113}, {149, 129, 122}, {153, 132, 122}, 
 {157, 133, 122}, {161, 141, 122}, {165, 141, 122}, {165, 137, 132}, 
 {166, 137, 132}, {186, 104, 142}, {194, 100, 142}, {198, 100, 142}, 
 {198, 104, 142}, {194, 100, 142}, {190, 104, 132}, {178, 124, 113}, 
 {162, 124, 104}, {145, 120, 113}, {129, 112, 103}, {108, 96, 94}, 
 {100, 88, 94}, {109, 89, 84}, {121, 96, 84}, {133, 100, 94}, 
 {141, 104, 94}, {137, 104, 94}, {121, 100, 94}, {108, 92, 94}, 
 {100, 84, 94}, {97, 81, 84}, {89, 81, 75}, {89, 73, 75}, 
 {89, 73, 75}, {93, 77, 84}, {104, 84, 93}, {133, 92, 94}, 
 {161, 84, 122}, {186, 96, 142}, {198, 104, 151}, {210, 112, 161}, 
 {222, 125, 170}, {238, 137, 188}, {238, 137, 188}, {234, 133, 189}, 
 {222, 121, 170}, {210, 112, 151}, {202, 132, 122}, {190, 136, 113}, 
 {202, 149, 113}, {186, 132, 104}, {182, 128, 103}, {182, 123, 104}, 
 {166, 120, 113}, {169, 88, 123}, {165, 84, 123}, {161, 80, 122}, 
 {153, 76, 122}, {153, 84, 122}, {137, 92, 113}, {141, 100, 103}, 
 {141, 112, 113}, {149, 120, 122}, {145, 116, 122}, {145, 120, 122}, 
 {149, 124, 122}, {157, 133, 122}, {166, 141, 122}, {170, 145, 122}, 
 {170, 145, 122}, {170, 145, 132}, {162, 141, 132}, {166, 141, 132}, 
 {170, 137, 132}, {194, 108, 151}, {198, 112, 161}, {198, 108, 161}, 
 {202, 100, 161}, {206, 104, 151}, {206, 108, 151}, {210, 108, 151}, 
 {206, 100, 151}, {202, 100, 151}, {202, 100, 151}, {202, 96, 142}, 
 {198, 96, 142}, {194, 92, 132}, {178, 88, 123}, {166, 84, 123}, 
 },
   /* no-name */
{{121, 92, 75}, {162, 132, 103}, {182, 152, 122}, {198, 169, 141}, 
 {210, 189, 160}, {206, 210, 188}, {194, 198, 188}, {202, 185, 170}, 
 {206, 181, 160}, {206, 177, 151}, {202, 177, 160}, {198, 177, 151}, 
 {194, 173, 160}, {194, 173, 160}, {194, 173, 160}, {198, 173, 151}, 
 {194, 165, 151}, {186, 157, 141}, {186, 153, 132}, {186, 148, 122}, 
 {170, 128, 94}, {145, 84, 66}, {109, 64, 37}, {81, 68, 37}, 
 {64, 60, 37}, {48, 56, 37}, {56, 52, 28}, {48, 60, 37}, 
 {56, 60, 37}, {60, 60, 37}, {72, 68, 37}, {89, 51, 28}, 
 {109, 59, 28}, {133, 72, 28}, {166, 115, 66}, {186, 148, 103}, 
 {190, 157, 132}, {194, 165, 151}, {190, 181, 170}, {202, 206, 207}, 
 {202, 214, 207}, {197, 214, 216}, {197, 214, 216}, {197, 214, 216}, 
 {193, 214, 216}, {197, 214, 216}, {201, 214, 216}, {206, 214, 216}, 
 {206, 210, 216}, {206, 214, 207}, {202, 214, 198}, {194, 206, 188}, 
 {186, 182, 169}, {190, 173, 141}, {194, 173, 113}, {202, 173, 113}, 
 {214, 181, 122}, {230, 193, 141}, {230, 201, 160}, {234, 201, 169}, 
 {234, 205, 169}, {234, 205, 169}, {230, 201, 169}, {230, 197, 160}, 
 {222, 189, 160}, {202, 169, 141}, {182, 153, 122}, {158, 141, 94}, 
 {121, 76, 56}, {85, 52, 37}, {68, 35, 28}, {60, 40, 37}, 
 {48, 39, 37}, {52, 44, 28}, {44, 44, 37}, {44, 44, 37}, 
 {44, 52, 37}, {40, 44, 28}, {36, 44, 37}, {40, 48, 47}, 
 {44, 44, 47}, {48, 44, 47}, {56, 48, 56}, {68, 48, 56}, 
 {72, 52, 47}, {92, 68, 46}, {105, 93, 65}, {137, 141, 85}, 
 {146, 154, 94}, {154, 153, 103}, {158, 157, 113}, {129, 141, 132}, 
 {84, 97, 85}, {64, 81, 66}, {44, 60, 47}, {36, 44, 47}, 
 {28, 32, 28}, {31, 24, 18}, {24, 28, 28}, {20, 28, 28}, 
 {20, 24, 28}, {20, 24, 28}, {20, 24, 28}, {20, 32, 28}, 
 {20, 32, 28}, {20, 32, 28}, {20, 36, 28}, {32, 36, 37}, 
 {40, 44, 47}, {52, 52, 47}, {64, 52, 47}, {72, 68, 56}, 
 {93, 105, 66}, {133, 146, 94}, {178, 169, 113}, {222, 193, 151}, 
 {234, 205, 169}, {242, 217, 188}, {222, 226, 207}, {222, 226, 216}, 
 {226, 222, 216}, {226, 230, 216}, {218, 226, 216}, {202, 218, 216}, 
 {201, 214, 216}, {201, 210, 216}, {202, 218, 216}, {206, 218, 207}, 
 {210, 218, 207}, {234, 209, 179}, {230, 205, 169}, {226, 193, 160}, 
 {202, 173, 132}, {190, 165, 113}, {162, 149, 94}, {113, 97, 75}, 
 {85, 80, 56}, {64, 68, 47}, {52, 56, 47}, {44, 48, 47}, 
 {40, 52, 47}, {44, 52, 56}, {52, 60, 56}, {72, 72, 66}, 
 {93, 80, 65}, {105, 121, 85}, {137, 150, 94}, {166, 165, 103}, 
 {178, 153, 113}, {190, 169, 122}, {194, 169, 132}, {198, 169, 141}, 
 {202, 185, 160}, {202, 214, 198}, {198, 214, 207}, {198, 210, 207}, 
 {189, 210, 207}, {181, 198, 188}, {190, 177, 170}, {182, 161, 151}, 
 {178, 145, 122}, {146, 92, 75}, {129, 68, 46}, {129, 68, 47}, 
 {141, 112, 85}, {186, 153, 122}, {219, 193, 160}, {234, 209, 178}, 
 {214, 214, 207}, {210, 218, 207}, {206, 218, 207}, {206, 214, 198}, 
 {194, 177, 170}, {186, 153, 141}, {169, 140, 113}, {125, 104, 75}, 
 {97, 80, 75}, {77, 77, 66}, {72, 76, 75}, {97, 109, 75}, 
 {146, 146, 94}, {182, 157, 122}, {202, 173, 141}, {219, 185, 151}, 
 {226, 189, 141}, {214, 164, 132}, {198, 161, 113}, {182, 140, 94}, 
 {141, 92, 66}, {109, 59, 46}, {117, 72, 46}, {146, 88, 66}, 
 {182, 131, 94}, {202, 157, 122}, {230, 193, 141}, {242, 201, 150}, 
 {242, 213, 169}, {242, 213, 178}, {238, 213, 178}, {230, 201, 160}, 
 {226, 193, 141}, {206, 168, 113}, {194, 161, 94}, {170, 153, 103}, 
 {137, 145, 85}, {109, 104, 66}, {77, 77, 56}, {64, 64, 56}, 
 {64, 64, 56}, {76, 72, 66}, {97, 88, 75}, {129, 125, 85}, 
 {169, 149, 122}, {182, 145, 132}, {190, 145, 132}, {190, 157, 132}, 
 {190, 157, 132}, {194, 161, 132}, {186, 157, 132}, {178, 145, 122}, 
 {137, 104, 84}, {109, 64, 56}, {72, 64, 56}, {64, 60, 56}, 
 {60, 64, 47}, {60, 68, 47}, {60, 64, 47}, {68, 64, 56}, 
 {93, 81, 65}, {125, 133, 85}, {150, 145, 103}, {178, 153, 122}, 
 {186, 165, 132}, {190, 165, 132}, {190, 161, 141}, {194, 165, 141}, 
 {190, 165, 132}, {190, 165, 132}, {190, 164, 132}, {190, 161, 122}, 
 {174, 152, 113}, {150, 145, 94}, {113, 84, 65}, {89, 72, 56}, 
 {68, 64, 47}, {52, 48, 37}, {36, 28, 37}, {28, 28, 37}, 
 {19, 32, 37}, {16, 24, 28}, {19, 20, 18}, {16, 20, 28}, 
 {20, 24, 28}, {24, 28, 28}, {32, 40, 28}, {48, 44, 28}, 
 },

   /* spring-flora */
{{51, 67, 36}, {53, 66, 34}, {51, 62, 29}, {40, 51, 23}, 
{40, 42, 26}, {37, 43, 25}, {36, 48, 25}, {32, 46, 23}, 
{34, 44, 22}, {21, 28, 17}, {18, 19, 14}, {16, 17, 11}, 
{15, 17, 11}, {13, 15, 10}, {13, 14, 12}, {13, 14, 12}, 
{15, 17, 13}, {17, 21, 14}, {26, 35, 21}, {34, 44, 28}, 
{42, 51, 39}, {49, 59, 39}, {50, 64, 54}, {55, 57, 63}, 
{57, 54, 66}, {55, 37, 59}, {50, 27, 51}, {44, 38, 28}, 
{26, 32, 18}, {17, 20, 14}, {15, 18, 12}, {14, 16, 10}, 
{14, 14, 9}, {18, 18, 13}, {19, 23, 16}, {31, 41, 36}, 
{44, 40, 58}, {52, 48, 72}, {66, 53, 79}, {65, 63, 76}, 
{63, 61, 68}, {54, 63, 42}, {53, 66, 34}, {46, 67, 34}, 
{46, 62, 32}, {35, 51, 24}, {26, 35, 19}, {18, 19, 14}, 
{12, 13, 9}, {9, 10, 7}, {8, 6, 5}, {7, 5, 4}, 
{9, 6, 6}, {11, 9, 9}, {14, 15, 11}, {21, 22, 15}, 
{44, 31, 50}, {48, 27, 54}, {55, 39, 59}, {53, 32, 59}, 
{48, 38, 62}, {44, 43, 55}, {50, 59, 42}, {53, 67, 39}, 
{54, 72, 45}, {58, 79, 44}, {63, 87, 44}, {61, 87, 42}, 
{58, 79, 42}, {56, 74, 36}, {50, 72, 34}, {45, 66, 34}, 
{36, 57, 31}, {32, 44, 26}, {23, 33, 20}, {16, 20, 15}, 
{15, 19, 12}, {17, 19, 13}, {17, 20, 15}, {23, 33, 22}, 
{30, 46, 29}, {36, 55, 32}, {41, 62, 33}, {46, 67, 34}, 
{48, 66, 36}, {50, 66, 37}, {50, 66, 37}, {53, 66, 37}, 
{51, 67, 39}, {53, 67, 38}, {55, 72, 42}, {57, 72, 42}, 
{52, 72, 45}, {52, 72, 45}, {49, 72, 45}, {49, 72, 42}, 
{50, 72, 37}, {50, 72, 37}, {47, 72, 42}, {51, 74, 39}, 
{57, 72, 34}, {55, 72, 39}, {57, 75, 39}, {61, 79, 39}, 
{70, 81, 37}, {76, 89, 51}, {82, 102, 67}, {86, 112, 73}, 
{100, 114, 76}, {89, 118, 60}, {102, 126, 88}, {114, 140, 97}, 
{135, 152, 98}, {112, 127, 93}, {118, 140, 93}, {191, 174, 163}, 
{143, 154, 113}, {99, 127, 100}, {93, 120, 59}, {79, 102, 60}, 
{82, 103, 67}, {83, 104, 71}, {86, 103, 72}, {86, 103, 64}, 
{87, 87, 52}, {73, 88, 50}, {76, 80, 52}, {62, 87, 57}, 
{70, 88, 50}, {71, 84, 56}, {70, 75, 50}, {67, 74, 44}, 
{57, 72, 42}, {52, 72, 42}, {47, 66, 40}, {41, 54, 36}, 
{34, 42, 25}, {21, 27, 16}, {16, 19, 12}, {12, 11, 10}, 
{10, 8, 7}, {7, 5, 5}, {6, 4, 4}, {5, 4, 3}, 
{5, 3, 4}, {5, 4, 3}, {5, 5, 5}, {6, 5, 5}, 
{6, 4, 5}, {7, 4, 5}, {7, 4, 5}, {7, 5, 5}, 
{8, 6, 6}, {10, 8, 7}, {13, 11, 10}, {14, 15, 11}, 
{19, 21, 15}, {39, 33, 23}, {48, 47, 30}, {60, 57, 53}, 
{79, 65, 97}, {74, 58, 76}, {106, 59, 79}, {96, 90, 85}, 
{84, 62, 85}, {88, 79, 94}, {80, 82, 72}, {70, 69, 59}, 
{57, 69, 54}, {60, 79, 47}, {58, 79, 47}, {58, 79, 46}, 
{54, 79, 44}, {53, 79, 44}, {53, 79, 44}, {53, 79, 47}, 
{55, 79, 50}, {60, 79, 50}, {62, 87, 49}, {60, 87, 52}, 
{61, 94, 52}, {67, 94, 52}, {76, 94, 56}, {86, 118, 56}, 
{80, 96, 53}, {83, 109, 44}, {83, 110, 55}, {76, 103, 55}, 
{73, 102, 54}, {68, 88, 50}, {63, 79, 44}, {57, 72, 39}, 
{55, 72, 34}, {53, 67, 34}, {50, 66, 37}, {44, 62, 36}, 
{44, 55, 38}, {41, 57, 35}, {40, 61, 36}, {41, 62, 38}, 
{44, 72, 42}, {55, 79, 41}, {61, 87, 47}, {67, 94, 47}, 
{77, 103, 53}, {89, 118, 57}, {86, 117, 57}, {89, 118, 76}, 
{114, 127, 85}, {106, 126, 97}, {93, 119, 76}, {82, 117, 72}, 
{73, 102, 59}, {60, 87, 52}, {49, 72, 45}, {39, 57, 34}, 
{32, 46, 27}, {23, 33, 18}, {17, 23, 13}, {17, 21, 13}, 
{17, 20, 14}, {22, 27, 17}, {33, 42, 25}, {36, 47, 28}, 
{44, 57, 31}, {49, 62, 33}, {49, 63, 35}, {45, 58, 33}, 
{37, 51, 27}, {32, 44, 23}, {23, 33, 17}, {16, 21, 13}, 
{12, 15, 8}, {11, 13, 7}, {11, 11, 7}, {10, 14, 8}, 
{12, 12, 9}, {13, 15, 8}, {15, 19, 11}, {19, 23, 15}, 
{29, 44, 22}, {35, 52, 29}, {39, 57, 30}, {46, 67, 28}, 
{50, 66, 28}, {47, 72, 29}, {47, 63, 30}, {39, 57, 27}, 
{32, 51, 25}, {28, 40, 25}, {21, 26, 17}, {19, 23, 15}, 
{28, 35, 21}, {35, 47, 26}, {46, 62, 33}, {53, 67, 39}, 
},

   /* andi */
{{53, 15, 5}, {77, 47, 22}, {92, 69, 39}, {112, 83, 55}, 
{126, 90, 59}, {138, 87, 63}, {140, 90, 66}, {140, 93, 64}, 
{137, 88, 50}, {122, 82, 32}, {100, 62, 19}, {72, 31, 12}, 
{52, 2, 1}, {20, 0, 0}, {2, 0, 0}, {2, 0, 0}, 
{24, 21, 12}, {72, 34, 30}, {82, 53, 47}, {97, 62, 41}, 
{108, 71, 42}, {122, 77, 55}, {132, 81, 65}, {136, 92, 71}, 
{137, 92, 71}, {137, 94, 71}, {136, 92, 71}, {135, 82, 69}, 
{132, 74, 61}, {115, 67, 53}, {106, 59, 54}, {85, 45, 42}, 
{48, 13, 21}, {16, 2, 1}, {0, 0, 0}, {0, 0, 0}, 
{0, 0, 0}, {2, 0, 0}, {46, 17, 5}, {73, 36, 18}, 
{84, 60, 38}, {116, 76, 52}, {137, 83, 59}, {148, 94, 71}, 
{157, 104, 76}, {162, 109, 79}, {160, 118, 82}, {156, 116, 79}, 
{153, 110, 79}, {148, 102, 73}, {148, 93, 72}, {143, 87, 65}, 
{145, 81, 58}, {144, 81, 55}, {146, 79, 49}, {140, 81, 48}, 
{143, 84, 48}, {149, 88, 63}, {151, 91, 65}, {148, 90, 67}, 
{145, 87, 68}, {144, 87, 68}, {138, 91, 68}, {137, 88, 62}, 
{118, 85, 56}, {111, 83, 43}, {100, 74, 36}, {100, 63, 33}, 
{100, 56, 24}, {94, 63, 20}, {96, 52, 20}, {87, 56, 18}, 
{88, 48, 14}, {72, 38, 7}, {68, 23, 6}, {69, 20, 11}, 
{83, 34, 12}, {97, 43, 28}, {100, 46, 40}, {114, 66, 50}, 
{122, 87, 64}, {129, 104, 76}, {142, 119, 101}, {162, 134, 122}, 
{170, 150, 140}, {168, 162, 155}, {184, 175, 167}, {178, 167, 159}, 
{174, 157, 148}, {164, 151, 133}, {163, 143, 115}, {149, 127, 91}, 
{140, 106, 63}, {117, 76, 51}, {89, 46, 30}, {57, 13, 4}, 
{23, 0, 0}, {2, 0, 0}, {0, 0, 0}, {0, 0, 0}, 
{19, 6, 1}, {56, 21, 8}, {86, 50, 35}, {108, 57, 48}, 
{126, 65, 49}, {130, 68, 57}, {128, 72, 48}, {133, 65, 46}, 
{128, 68, 40}, {135, 65, 29}, {120, 66, 24}, {130, 57, 20}, 
{97, 47, 11}, {73, 23, 7}, {63, 14, 2}, {54, 0, 0}, 
{54, 0, 0}, {65, 18, 11}, {83, 55, 30}, {89, 61, 37}, 
{105, 74, 43}, {116, 89, 52}, {130, 96, 61}, {129, 97, 66}, 
{132, 96, 71}, {141, 100, 78}, {142, 109, 76}, {145, 108, 76}, 
{149, 114, 80}, {151, 116, 80}, {151, 117, 84}, {154, 119, 87}, 
{170, 128, 103}, {177, 137, 108}, {173, 147, 120}, {172, 152, 124}, 
{176, 156, 141}, {187, 171, 142}, {182, 172, 146}, {174, 157, 140}, 
{172, 156, 121}, {161, 145, 106}, {155, 136, 98}, {153, 132, 93}, 
{148, 118, 87}, {150, 108, 77}, {149, 100, 74}, {150, 93, 72}, 
{145, 92, 61}, {143, 89, 62}, {140, 85, 57}, {140, 89, 52}, 
{138, 100, 54}, {134, 101, 59}, {135, 99, 59}, {141, 97, 64}, 
{142, 94, 66}, {138, 98, 59}, {132, 99, 54}, {130, 96, 49}, 
{120, 91, 38}, {105, 60, 17}, {94, 14, 3}, {61, 0, 0}, 
{59, 4, 2}, {68, 13, 17}, {88, 27, 10}, {96, 48, 19}, 
{111, 73, 37}, {125, 88, 42}, {130, 94, 50}, {140, 96, 58}, 
{148, 97, 69}, {150, 98, 73}, {153, 103, 80}, {158, 110, 79}, 
{155, 110, 84}, {158, 110, 80}, {157, 105, 79}, {155, 102, 75}, 
{152, 98, 73}, {154, 97, 72}, {163, 96, 70}, {164, 106, 80}, 
{165, 112, 81}, {164, 117, 80}, {163, 118, 81}, {162, 120, 81}, 
{158, 117, 80}, {152, 109, 77}, {140, 100, 73}, {126, 87, 68}, 
{118, 80, 61}, {105, 63, 45}, {91, 53, 25}, {88, 44, 12}, 
{86, 40, 15}, {104, 35, 17}, {117, 57, 30}, {117, 68, 42}, 
{131, 80, 42}, {127, 82, 47}, {124, 86, 46}, {126, 82, 39}, 
{120, 86, 40}, {109, 68, 30}, {104, 60, 25}, {95, 65, 24}, 
{101, 66, 21}, {103, 65, 36}, {107, 72, 39}, {116, 82, 42}, 
{124, 88, 46}, {124, 91, 52}, {121, 100, 56}, {126, 102, 62}, 
{131, 100, 70}, {136, 96, 72}, {140, 95, 72}, {142, 93, 72}, 
{142, 96, 72}, {143, 93, 68}, {140, 93, 70}, {140, 90, 70}, 
{142, 89, 70}, {140, 82, 64}, {137, 75, 60}, {132, 77, 55}, 
{125, 87, 60}, {120, 89, 62}, {128, 104, 70}, {136, 111, 76}, 
{147, 118, 89}, {156, 135, 117}, {159, 145, 124}, {174, 148, 130}, 
{179, 151, 125}, {174, 151, 119}, {173, 148, 113}, {178, 146, 100}, 
{170, 143, 112}, {161, 138, 109}, {161, 134, 92}, {160, 125, 81}, 
{161, 135, 91}, {170, 123, 85}, {164, 122, 88}, {153, 130, 80}, 
{152, 118, 84}, {148, 119, 80}, {139, 111, 77}, {141, 111, 73}, 
{137, 109, 79}, {135, 108, 93}, {143, 111, 94}, {148, 128, 100}, 
},

/* gig-o835 */
{{56, 97, 85}, {76, 105, 84}, {77, 117, 84}, {76, 109, 94}, 
{84, 109, 94}, {88, 113, 94}, {92, 125, 94}, {101, 121, 103}, 
{105, 133, 113}, {113, 145, 122}, {113, 149, 122}, {101, 141, 113}, 
{92, 125, 103}, {84, 113, 94}, {81, 101, 75}, {56, 97, 66}, 
{52, 89, 66}, {36, 81, 66}, {28, 77, 66}, {44, 72, 47}, 
{20, 60, 47}, {20, 60, 47}, {16, 68, 66}, {16, 68, 66}, 
{4, 68, 75}, {4, 81, 84}, {12, 89, 103}, {16, 101, 122}, 
{28, 101, 122}, {28, 105, 122}, {28, 113, 122}, {36, 105, 122}, 
{36, 105, 122}, {48, 105, 122}, {52, 105, 113}, {48, 109, 103}, 
{44, 101, 93}, {40, 97, 84}, {48, 89, 75}, {40, 76, 56}, 
{24, 72, 56}, {28, 72, 56}, {24, 76, 56}, {40, 72, 66}, 
{48, 89, 75}, {56, 93, 84}, {68, 105, 103}, {68, 117, 122}, 
{68, 117, 122}, {72, 117, 122}, {72, 121, 113}, {76, 121, 113}, 
{84, 125, 103}, {89, 125, 103}, {92, 121, 113}, {93, 129, 103}, 
{104, 145, 122}, {100, 157, 141}, {121, 162, 150}, {125, 166, 169}, 
{161, 182, 169}, {173, 210, 197}, {161, 186, 160}, {137, 178, 179}, 
{121, 165, 160}, {108, 145, 141}, {92, 141, 131}, {80, 129, 131}, 
{80, 125, 122}, {76, 125, 122}, {76, 129, 112}, {72, 125, 103}, 
{72, 117, 103}, {72, 117, 103}, {68, 121, 113}, {60, 121, 112}, 
{52, 117, 122}, {48, 121, 131}, {40, 117, 141}, {40, 113, 141}, 
{48, 121, 150}, {56, 117, 160}, {64, 125, 150}, {76, 125, 132}, 
{89, 138, 132}, {100, 146, 141}, {112, 154, 150}, {117, 149, 151}, 
{116, 145, 150}, {112, 149, 150}, {100, 146, 160}, {80, 142, 160}, 
{60, 130, 150}, {48, 121, 141}, {36, 117, 131}, {36, 113, 131}, 
{56, 113, 131}, {68, 121, 131}, {76, 125, 132}, {84, 137, 131}, 
{96, 142, 141}, {100, 149, 150}, {100, 146, 160}, {104, 150, 160}, 
{100, 142, 160}, {100, 133, 150}, {92, 129, 132}, {88, 125, 122}, 
{89, 121, 103}, {80, 113, 103}, {72, 105, 94}, {72, 101, 85}, 
{64, 93, 75}, {36, 93, 84}, {28, 97, 93}, {12, 81, 84}, 
{12, 89, 103}, {4, 77, 103}, {16, 93, 103}, {19, 97, 103}, 
{32, 93, 94}, {48, 97, 94}, {64, 105, 94}, {76, 117, 94}, 
{93, 121, 103}, {97, 121, 103}, {92, 125, 113}, {84, 125, 113}, 
{92, 129, 113}, {84, 133, 113}, {88, 129, 122}, {88, 129, 122}, 
{92, 129, 122}, {96, 129, 122}, {108, 129, 122}, {112, 141, 132}, 
{109, 153, 131}, {108, 146, 141}, {113, 149, 141}, {125, 149, 132}, 
{113, 150, 132}, {108, 153, 141}, {108, 162, 150}, {113, 166, 150}, 
{112, 154, 141}, {116, 149, 141}, {117, 153, 141}, {120, 154, 151}, 
{125, 162, 151}, {133, 162, 151}, {141, 170, 151}, {145, 174, 160}, 
{141, 178, 169}, {137, 182, 179}, {133, 162, 160}, {125, 162, 141}, 
{121, 157, 132}, {117, 146, 122}, {109, 145, 122}, {96, 133, 113}, 
{88, 121, 113}, {84, 113, 103}, {76, 113, 103}, {68, 113, 103}, 
{60, 105, 103}, {52, 101, 94}, {48, 101, 103}, {28, 101, 112}, 
{32, 109, 131}, {28, 105, 132}, {32, 113, 132}, {39, 117, 131}, 
{56, 121, 132}, {68, 125, 131}, {68, 125, 131}, {76, 129, 131}, 
{73, 130, 132}, {72, 134, 141}, {81, 134, 151}, {80, 134, 160}, 
{84, 134, 150}, {84, 134, 141}, {88, 129, 132}, {100, 133, 132}, 
{100, 137, 132}, {100, 142, 132}, {100, 137, 141}, {100, 142, 141}, 
{97, 142, 132}, {92, 146, 121}, {88, 133, 122}, {88, 129, 122}, 
{88, 129, 122}, {88, 133, 122}, {96, 137, 122}, {96, 137, 122}, 
{108, 145, 132}, {112, 141, 132}, {108, 145, 141}, {116, 141, 141}, 
{108, 141, 150}, {96, 146, 160}, {72, 130, 160}, {60, 126, 150}, 
{44, 117, 141}, {36, 109, 131}, {40, 105, 122}, {44, 109, 122}, 
{60, 113, 122}, {72, 121, 122}, {85, 129, 122}, {96, 133, 131}, 
{100, 133, 132}, {104, 133, 132}, {104, 137, 141}, {108, 137, 141}, 
{104, 133, 141}, {100, 133, 132}, {92, 121, 122}, {88, 117, 122}, 
{76, 117, 113}, {80, 117, 103}, {76, 117, 103}, {72, 117, 103}, 
{68, 113, 103}, {64, 113, 113}, {56, 109, 113}, {56, 109, 113}, 
{48, 113, 113}, {52, 113, 112}, {60, 117, 122}, {73, 126, 132}, 
{80, 130, 160}, {88, 138, 170}, {80, 138, 170}, {68, 134, 160}, 
{56, 130, 160}, {40, 117, 160}, {28, 113, 141}, {20, 101, 141}, 
{24, 97, 132}, {16, 97, 122}, {20, 97, 112}, {36, 97, 94}, 
{48, 101, 93}, {60, 105, 94}, {72, 117, 94}, {77, 121, 103}, 
{84, 125, 122}, {84, 134, 132}, {88, 134, 150}, {88, 137, 160}, 
{84, 142, 160}, {76, 133, 141}, {80, 125, 132}, {80, 121, 122}, 
},

/* rie02 */
{{48, 72, 37}, {60, 85, 28}, {48, 88, 28}, {60, 76, 37}, 
{56, 64, 37}, {48, 52, 28}, {44, 48, 28}, {36, 44, 28}, 
{24, 36, 18}, {20, 36, 18}, {24, 40, 18}, {28, 44, 18}, 
{36, 40, 18}, {36, 28, 18}, {20, 20, 18}, {12, 16, 9}, 
{16, 20, 9}, {20, 24, 9}, {28, 28, 9}, {40, 44, 18}, 
{56, 52, 28}, {68, 64, 37}, {88, 72, 47}, {85, 93, 47}, 
{85, 100, 56}, {88, 96, 75}, {93, 97, 75}, {92, 97, 66}, 
{85, 101, 56}, {88, 105, 66}, {89, 105, 75}, {84, 105, 66}, 
{89, 113, 66}, {113, 141, 85}, {133, 157, 122}, {141, 190, 150}, 
{145, 182, 169}, {129, 189, 188}, {169, 181, 179}, {177, 189, 169}, 
{210, 230, 160}, {222, 234, 179}, {246, 241, 159}, {214, 230, 141}, 
{190, 218, 160}, {198, 226, 122}, {234, 246, 121}, {218, 209, 112}, 
{157, 173, 93}, {125, 149, 94}, {121, 149, 84}, {101, 125, 66}, 
{93, 109, 66}, {89, 101, 47}, {89, 117, 47}, {101, 113, 47}, 
{113, 125, 56}, {125, 133, 75}, {153, 141, 84}, {153, 157, 103}, 
{162, 194, 103}, {182, 202, 103}, {182, 190, 84}, {194, 152, 112}, 
{137, 129, 94}, {113, 113, 75}, {89, 109, 66}, {72, 92, 56}, 
{60, 89, 56}, {56, 92, 56}, {60, 93, 47}, {64, 88, 47}, 
{56, 89, 56}, {52, 89, 56}, {52, 80, 56}, {56, 80, 56}, 
{48, 72, 47}, {44, 72, 47}, {36, 60, 47}, {32, 52, 56}, 
{36, 56, 66}, {36, 56, 56}, {36, 68, 56}, {48, 88, 56}, 
{68, 101, 65}, {97, 125, 85}, {113, 149, 94}, {145, 170, 122}, 
{149, 177, 112}, {125, 153, 103}, {97, 121, 84}, {85, 93, 66}, 
{60, 64, 66}, {36, 44, 47}, {20, 36, 28}, {12, 24, 18}, 
{8, 16, 0}, {12, 12, 0}, {20, 24, 18}, {32, 48, 28}, 
{44, 60, 37}, {68, 76, 47}, {72, 89, 47}, {64, 84, 47}, 
{81, 88, 47}, {72, 93, 28}, {60, 76, 47}, {56, 56, 47}, 
{44, 56, 37}, {32, 52, 28}, {24, 52, 28}, {20, 44, 18}, 
{28, 48, 9}, {24, 48, 18}, {28, 56, 28}, {24, 56, 37}, 
{24, 56, 37}, {28, 56, 37}, {36, 60, 47}, {48, 72, 37}, 
{52, 88, 37}, {60, 97, 37}, {60, 93, 47}, {60, 96, 46}, 
{48, 76, 47}, {40, 68, 37}, {32, 52, 28}, {28, 56, 28}, 
{16, 44, 18}, {16, 40, 18}, {16, 44, 9}, {28, 48, 9}, 
{44, 52, 28}, {36, 56, 18}, {40, 64, 18}, {36, 72, 37}, 
{44, 76, 37}, {44, 76, 37}, {40, 72, 37}, {44, 56, 28}, 
{36, 52, 28}, {28, 48, 28}, {32, 40, 28}, {32, 32, 18}, 
{24, 32, 28}, {20, 40, 28}, {28, 40, 37}, {28, 36, 28}, 
{24, 40, 37}, {24, 44, 37}, {24, 52, 47}, {28, 44, 47}, 
{28, 40, 37}, {28, 48, 37}, {20, 40, 37}, {12, 40, 28}, 
{20, 32, 18}, {16, 20, 18}, {12, 20, 18}, {12, 24, 9}, 
{12, 24, 9}, {16, 36, 18}, {20, 52, 28}, {24, 60, 37}, 
{32, 76, 47}, {44, 80, 56}, {44, 81, 47}, {48, 97, 47}, 
{60, 121, 37}, {64, 109, 37}, {72, 101, 47}, {60, 93, 56}, 
{56, 89, 75}, {60, 80, 94}, {76, 93, 103}, {88, 121, 94}, 
{101, 129, 75}, {97, 145, 75}, {93, 133, 56}, {113, 157, 65}, 
{93, 121, 66}, {85, 117, 47}, {77, 101, 47}, {68, 85, 37}, 
{60, 68, 37}, {60, 56, 37}, {56, 52, 37}, {60, 60, 47}, 
{80, 80, 56}, {88, 104, 75}, {117, 129, 94}, {149, 173, 113}, 
{166, 186, 141}, {166, 198, 122}, {173, 186, 132}, {162, 178, 122}, 
{133, 149, 94}, {117, 133, 75}, {93, 113, 75}, {84, 105, 75}, 
{60, 97, 75}, {64, 68, 66}, {44, 64, 75}, {36, 52, 66}, 
{28, 56, 66}, {28, 56, 66}, {32, 48, 56}, {36, 48, 47}, 
{52, 48, 28}, {48, 56, 37}, {48, 44, 28}, {44, 52, 28}, 
{56, 56, 28}, {60, 60, 28}, {64, 68, 37}, {80, 80, 56}, 
{105, 101, 66}, {129, 129, 85}, {133, 133, 113}, {129, 137, 122}, 
{117, 145, 103}, {121, 157, 84}, {113, 145, 66}, {97, 117, 66}, 
{76, 105, 56}, {72, 113, 56}, {68, 129, 56}, {60, 125, 55}, 
{52, 109, 65}, {52, 97, 65}, {64, 105, 75}, {89, 133, 94}, 
{125, 149, 113}, {162, 174, 132}, {153, 198, 151}, {170, 198, 141}, 
{169, 206, 141}, {174, 210, 132}, {181, 214, 131}, {169, 214, 140}, 
{174, 222, 141}, {182, 206, 151}, {190, 202, 150}, {198, 198, 150}, 
{218, 213, 141}, {214, 214, 160}, {189, 206, 141}, {190, 210, 103}, 
{174, 210, 75}, {117, 153, 56}, {105, 133, 56}, {105, 125, 56}, 
{109, 109, 56}, {93, 113, 66}, {105, 109, 75}, {117, 125, 113}, 
},

/* rie05 */
{{73, 125, 84}, {77, 141, 83}, {89, 146, 83}, {104, 154, 94}, 
{109, 170, 103}, {146, 198, 113}, {162, 214, 132}, {182, 226, 160}, 
{198, 234, 160}, {206, 234, 169}, {218, 242, 178}, {222, 238, 169}, 
{218, 226, 150}, {222, 230, 141}, {218, 230, 131}, {210, 222, 131}, 
{206, 222, 122}, {190, 219, 113}, {203, 226, 122}, {206, 226, 103}, 
{218, 226, 94}, {211, 222, 94}, {198, 222, 75}, {170, 210, 94}, 
{170, 206, 103}, {150, 194, 113}, {137, 174, 113}, {121, 170, 103}, 
{129, 174, 113}, {129, 182, 113}, {146, 198, 132}, {162, 222, 160}, 
{182, 218, 169}, {210, 234, 197}, {230, 246, 206}, {230, 246, 216}, 
{230, 242, 207}, {222, 234, 197}, {214, 238, 188}, {214, 234, 169}, 
{214, 230, 150}, {210, 230, 131}, {198, 230, 122}, {186, 219, 122}, 
{170, 206, 122}, {154, 198, 113}, {137, 182, 85}, {125, 178, 75}, 
{121, 170, 84}, {137, 153, 94}, {141, 174, 94}, {162, 182, 113}, 
{193, 201, 141}, {205, 205, 178}, {222, 230, 197}, {234, 250, 206}, 
{246, 254, 197}, {254, 241, 169}, {246, 234, 159}, {242, 250, 112}, 
{230, 238, 94}, {222, 234, 112}, {198, 222, 113}, {190, 219, 103}, 
{198, 206, 103}, {186, 214, 103}, {174, 214, 113}, {166, 218, 113}, 
{182, 214, 113}, {186, 219, 122}, {198, 226, 132}, {202, 226, 150}, 
{222, 222, 160}, {238, 234, 159}, {246, 233, 169}, {226, 238, 178}, 
{210, 234, 169}, {198, 234, 160}, {198, 230, 150}, {202, 226, 132}, 
{207, 230, 122}, {198, 226, 122}, {186, 222, 113}, {178, 214, 103}, 
{166, 206, 103}, {166, 202, 94}, {150, 190, 84}, {141, 186, 75}, 
{153, 174, 66}, {165, 169, 66}, {150, 182, 85}, {158, 194, 94}, 
{162, 194, 103}, {162, 206, 103}, {158, 206, 103}, {166, 210, 113}, 
{162, 202, 113}, {162, 210, 122}, {166, 214, 113}, {158, 206, 94}, 
{142, 194, 85}, {129, 174, 85}, {121, 166, 75}, {121, 174, 75}, 
{121, 157, 75}, {129, 162, 75}, {154, 148, 37}, {137, 157, 75}, 
{109, 154, 75}, {121, 162, 103}, {137, 170, 132}, {166, 198, 151}, 
{178, 218, 169}, {182, 214, 179}, {185, 210, 179}, {178, 218, 169}, 
{154, 198, 141}, {125, 178, 122}, {125, 186, 113}, {146, 194, 103}, 
{150, 194, 103}, {150, 194, 103}, {154, 194, 94}, {146, 198, 85}, 
{142, 194, 85}, {142, 182, 85}, {141, 182, 84}, {146, 194, 75}, 
{150, 194, 75}, {154, 198, 75}, {158, 194, 56}, {170, 198, 56}, 
{162, 206, 66}, {190, 210, 75}, {230, 187, 28}, {254, 198, 9}, 
{242, 208, 37}, {242, 225, 75}, {246, 237, 112}, {222, 242, 159}, 
{226, 238, 178}, {242, 242, 207}, {246, 242, 216}, {246, 246, 225}, 
{242, 242, 225}, {242, 241, 216}, {226, 242, 188}, {206, 234, 179}, 
{194, 226, 150}, {178, 214, 132}, {162, 210, 122}, {129, 194, 103}, 
{117, 166, 85}, {109, 149, 65}, {101, 153, 75}, {89, 150, 74}, 
{97, 158, 75}, {101, 162, 84}, {113, 170, 85}, {137, 194, 94}, 
{154, 206, 103}, {170, 206, 94}, {189, 193, 84}, {238, 208, 65}, 
{254, 228, 84}, {254, 233, 102}, {254, 221, 93}, {230, 205, 94}, 
{182, 206, 113}, {153, 177, 122}, {113, 154, 94}, {100, 150, 94}, 
{84, 129, 93}, {73, 121, 75}, {65, 117, 65}, {61, 113, 56}, 
{60, 109, 56}, {65, 113, 47}, {61, 109, 56}, {65, 109, 56}, 
{65, 113, 56}, {69, 117, 65}, {77, 129, 65}, {93, 141, 65}, 
{93, 150, 74}, {113, 158, 85}, {133, 170, 85}, {146, 190, 103}, 
{150, 190, 122}, {157, 190, 132}, {158, 202, 132}, {162, 210, 132}, 
{174, 219, 122}, {186, 222, 122}, {198, 230, 150}, {206, 230, 169}, 
{214, 230, 179}, {222, 234, 197}, {230, 246, 216}, {238, 237, 225}, 
{238, 234, 235}, {238, 238, 216}, {226, 238, 188}, {214, 230, 160}, 
{194, 218, 141}, {190, 198, 131}, {174, 198, 122}, {174, 202, 122}, 
{174, 214, 122}, {182, 219, 122}, {194, 214, 132}, {198, 226, 160}, 
{202, 226, 160}, {202, 226, 160}, {190, 222, 179}, {190, 222, 179}, 
{194, 230, 179}, {202, 230, 178}, {214, 234, 178}, {222, 230, 179}, 
{218, 234, 178}, {210, 230, 169}, {206, 218, 169}, {182, 222, 160}, 
{154, 194, 141}, {129, 170, 113}, {101, 154, 93}, {81, 141, 83}, 
{81, 133, 83}, {77, 125, 74}, {73, 121, 74}, {69, 129, 65}, 
{73, 121, 74}, {77, 129, 74}, {109, 133, 75}, {97, 146, 75}, 
{108, 154, 94}, {125, 178, 103}, {150, 202, 113}, {166, 210, 122}, 
{186, 222, 141}, {194, 222, 151}, {194, 218, 151}, {182, 218, 151}, 
{162, 218, 131}, {170, 214, 122}, {174, 210, 122}, {182, 210, 122}, 
{186, 214, 122}, {190, 214, 122}, {194, 218, 132}, {198, 230, 141}, 
{202, 230, 150}, {207, 230, 141}, {202, 218, 131}, {190, 206, 122}, 
},

/* rie11 */
{{174, 144, 103}, {129, 96, 85}, {117, 80, 66}, {105, 92, 56}, 
{113, 80, 47}, {101, 92, 66}, {109, 113, 85}, {125, 137, 103}, 
{161, 136, 122}, {198, 152, 122}, {206, 157, 132}, {174, 165, 132}, 
{145, 158, 103}, {113, 117, 94}, {88, 92, 66}, {68, 68, 56}, 
{60, 56, 47}, {52, 43, 37}, {48, 40, 37}, {44, 44, 28}, 
{44, 44, 28}, {44, 44, 37}, {48, 48, 47}, {52, 52, 47}, 
{52, 52, 47}, {52, 52, 47}, {44, 52, 56}, {52, 56, 56}, 
{56, 56, 56}, {56, 56, 56}, {56, 60, 56}, {60, 60, 56}, 
{64, 60, 56}, {68, 56, 56}, {64, 56, 47}, {60, 60, 47}, 
{56, 56, 37}, {52, 52, 37}, {48, 48, 37}, {48, 44, 37}, 
{48, 44, 37}, {48, 44, 47}, {44, 44, 56}, {40, 48, 56}, 
{44, 56, 56}, {48, 60, 66}, {52, 64, 75}, {56, 72, 75}, 
{81, 85, 85}, {105, 97, 84}, {121, 121, 103}, {153, 125, 103}, 
{174, 140, 122}, {194, 148, 132}, {190, 152, 132}, {161, 141, 113}, 
{133, 121, 94}, {113, 96, 66}, {92, 80, 56}, {68, 60, 47}, 
{60, 52, 37}, {52, 43, 28}, {48, 35, 28}, {48, 40, 28}, 
{52, 52, 37}, {52, 56, 47}, {56, 60, 47}, {60, 56, 47}, 
{56, 52, 47}, {48, 52, 47}, {40, 44, 37}, {32, 36, 28}, 
{32, 36, 28}, {28, 32, 28}, {36, 36, 28}, {48, 48, 37}, 
{68, 60, 47}, {85, 72, 56}, {113, 92, 75}, {153, 129, 103}, 
{178, 153, 122}, {198, 165, 151}, {198, 165, 151}, {198, 165, 141}, 
{158, 154, 113}, {133, 133, 94}, {101, 97, 66}, {76, 60, 47}, 
{73, 56, 37}, {64, 48, 47}, {64, 48, 47}, {60, 56, 56}, 
{68, 68, 66}, {72, 89, 66}, {97, 105, 85}, {121, 129, 103}, 
{145, 145, 122}, {194, 165, 132}, {210, 165, 141}, {210, 173, 141}, 
{218, 181, 151}, {218, 180, 160}, {218, 177, 160}, {198, 169, 141}, 
{157, 145, 113}, {125, 125, 103}, {109, 109, 75}, {77, 77, 66}, 
{72, 76, 66}, {73, 73, 75}, {68, 60, 66}, {60, 56, 56}, 
{48, 48, 56}, {48, 48, 47}, {44, 44, 47}, {32, 36, 37}, 
{24, 28, 28}, {20, 20, 28}, {15, 20, 28}, {12, 20, 18}, 
{12, 16, 18}, {12, 16, 9}, {12, 20, 9}, {16, 16, 9}, 
{12, 20, 9}, {16, 20, 9}, {20, 20, 9}, {20, 20, 9}, 
{23, 20, 9}, {24, 20, 9}, {27, 16, 9}, {28, 24, 9}, 
{24, 20, 9}, {23, 20, 18}, {19, 20, 18}, {24, 20, 18}, 
{31, 20, 18}, {35, 24, 28}, {28, 24, 18}, {32, 24, 28}, 
{31, 24, 28}, {28, 28, 28}, {28, 32, 37}, {24, 36, 47}, 
{28, 32, 47}, {28, 32, 37}, {23, 24, 28}, {23, 20, 28}, 
{24, 28, 28}, {28, 36, 37}, {40, 40, 37}, {44, 44, 47}, 
{44, 40, 56}, {40, 40, 56}, {31, 28, 37}, {20, 20, 28}, 
{19, 16, 28}, {16, 16, 28}, {16, 16, 18}, {16, 20, 18}, 
{16, 24, 18}, {16, 24, 18}, {20, 24, 18}, {23, 20, 18}, 
{20, 24, 18}, {24, 24, 18}, {28, 28, 28}, {40, 44, 28}, 
{48, 60, 37}, {56, 60, 47}, {56, 72, 56}, {64, 72, 56}, 
{68, 64, 56}, {68, 64, 66}, {64, 64, 56}, {68, 64, 66}, 
{68, 73, 66}, {76, 76, 66}, {68, 89, 85}, {84, 96, 113}, 
{113, 117, 103}, {145, 137, 122}, {149, 141, 132}, {137, 141, 122}, 
{105, 121, 103}, {81, 85, 84}, {60, 68, 66}, {48, 60, 56}, 
{52, 56, 56}, {56, 56, 47}, {52, 52, 47}, {56, 52, 47}, 
{60, 43, 47}, {56, 48, 47}, {52, 44, 47}, {48, 31, 37}, 
{40, 28, 28}, {40, 32, 28}, {36, 31, 28}, {44, 32, 18}, 
{36, 36, 28}, {36, 36, 28}, {36, 36, 37}, {40, 31, 37}, 
{36, 36, 37}, {40, 36, 37}, {48, 39, 37}, {52, 40, 37}, 
{64, 44, 37}, {64, 44, 37}, {60, 48, 37}, {56, 48, 47}, 
{52, 48, 56}, {56, 52, 56}, {60, 52, 56}, {56, 52, 47}, 
{56, 48, 37}, {60, 56, 37}, {56, 48, 37}, {52, 48, 37}, 
{48, 48, 37}, {44, 44, 37}, {44, 48, 28}, {32, 44, 18}, 
{24, 32, 18}, {23, 24, 18}, {23, 16, 18}, {20, 16, 18}, 
{15, 20, 28}, {12, 24, 28}, {15, 28, 28}, {24, 24, 28}, 
{36, 28, 28}, {44, 32, 28}, {48, 40, 37}, {52, 48, 47}, 
{52, 52, 47}, {52, 56, 47}, {56, 56, 47}, {60, 60, 47}, 
{68, 56, 47}, {76, 56, 47}, {85, 64, 56}, {121, 76, 56}, 
{153, 103, 75}, {174, 136, 94}, {210, 164, 132}, {222, 189, 169}, 
{230, 197, 169}, {234, 192, 178}, {222, 189, 169}, {206, 169, 151}, 
{174, 149, 132}, {125, 112, 94}, {64, 64, 47}, {15, 16, 9}, 
},
/* etretat.ppm */
{{37, 54, 37}, {56, 74, 51}, {72, 89, 61}, {92, 102, 76}, 
{110, 104, 91}, {122, 114, 96}, {130, 115, 99}, {147, 129, 105}, 
{156, 123, 113}, {158, 122, 110}, {154, 117, 112}, {128, 105, 86}, 
{113, 95, 78}, {111, 88, 68}, {109, 75, 53}, {119, 73, 54}, 
{113, 87, 64}, {109, 90, 77}, {112, 99, 83}, {119, 107, 90}, 
{119, 106, 100}, {111, 114, 107}, {108, 108, 119}, {111, 132, 117}, 
{122, 140, 117}, {131, 147, 122}, {125, 148, 116}, {128, 146, 117}, 
{129, 134, 106}, {119, 120, 100}, {122, 118, 102}, {126, 111, 93}, 
{128, 105, 83}, {127, 100, 79}, {116, 96, 68}, {115, 95, 71}, 
{105, 93, 75}, {96, 95, 76}, {94, 88, 75}, {91, 90, 84}, 
{89, 104, 99}, {84, 113, 105}, {86, 116, 115}, {94, 113, 111}, 
{99, 115, 105}, {90, 106, 97}, {75, 101, 90}, {66, 98, 88}, 
{64, 83, 77}, {54, 80, 74}, {48, 74, 60}, {63, 77, 61}, 
{53, 84, 60}, {58, 84, 68}, {74, 78, 77}, {87, 88, 83}, 
{102, 100, 95}, {120, 112, 109}, {142, 128, 126}, {157, 150, 131}, 
{173, 160, 142}, {172, 164, 151}, {171, 163, 140}, {152, 166, 129}, 
{146, 152, 117}, {124, 122, 102}, {119, 101, 83}, {107, 87, 68}, 
{98, 77, 59}, {83, 73, 56}, {71, 70, 54}, {64, 69, 53}, 
{62, 65, 49}, {51, 58, 44}, {46, 53, 42}, {42, 55, 36}, 
{41, 51, 36}, {33, 46, 29}, {32, 35, 25}, {32, 33, 25}, 
{32, 33, 26}, {34, 33, 25}, {49, 41, 28}, {53, 42, 32}, 
{46, 46, 32}, {35, 39, 27}, {35, 36, 26}, {33, 35, 26}, 
{33, 45, 33}, {37, 50, 46}, {43, 49, 49}, {39, 53, 48}, 
{46, 60, 57}, {64, 73, 61}, {76, 83, 70}, {98, 92, 88}, 
{120, 108, 103}, {130, 119, 129}, {133, 122, 130}, {140, 134, 141}, 
{140, 136, 140}, {149, 148, 129}, {152, 158, 138}, {163, 155, 142}, 
{166, 158, 139}, {164, 150, 138}, {160, 129, 117}, {164, 127, 110}, 
{160, 117, 85}, {129, 101, 81}, {95, 89, 60}, {75, 83, 56}, 
{57, 74, 54}, {50, 72, 46}, {50, 66, 45}, {56, 66, 52}, 
{59, 61, 52}, {54, 61, 52}, {47, 62, 45}, {48, 57, 47}, 
{45, 58, 46}, {45, 51, 40}, {50, 49, 35}, {50, 48, 35}, 
{55, 49, 35}, {58, 51, 45}, {69, 65, 55}, {76, 67, 59}, 
{85, 76, 68}, {90, 80, 66}, {96, 75, 58}, {95, 73, 58}, 
{84, 72, 61}, {83, 72, 62}, {76, 71, 65}, {72, 68, 63}, 
{67, 65, 58}, {60, 61, 53}, {53, 66, 55}, {52, 70, 63}, 
{47, 70, 64}, {48, 65, 61}, {45, 66, 47}, {41, 58, 40}, 
{38, 58, 38}, {31, 46, 31}, {31, 34, 25}, {33, 33, 24}, 
{33, 33, 24}, {36, 36, 26}, {45, 45, 33}, {47, 49, 35}, 
{49, 48, 38}, {58, 57, 46}, {71, 66, 49}, {74, 71, 57}, 
{75, 74, 63}, {70, 78, 64}, {63, 77, 60}, {59, 67, 51}, 
{54, 57, 38}, {52, 52, 40}, {59, 57, 50}, {69, 64, 57}, 
{80, 83, 68}, {98, 92, 81}, {116, 107, 100}, {135, 122, 110}, 
{149, 139, 125}, {168, 152, 137}, {173, 164, 146}, {178, 166, 145}, 
{187, 161, 142}, {175, 160, 139}, {167, 156, 132}, {157, 146, 127}, 
{154, 127, 107}, {137, 103, 78}, {118, 89, 65}, {97, 74, 55}, 
{94, 64, 46}, {81, 67, 51}, {77, 68, 53}, {77, 75, 64}, 
{75, 79, 74}, {69, 86, 85}, {81, 84, 88}, {82, 92, 86}, 
{87, 93, 88}, {91, 98, 98}, {95, 112, 99}, {100, 109, 98}, 
{92, 102, 92}, {86, 97, 88}, {95, 99, 92}, {108, 109, 98}, 
{119, 115, 101}, {120, 135, 102}, {129, 145, 106}, {123, 142, 117}, 
{121, 136, 119}, {108, 117, 110}, {101, 118, 101}, {92, 104, 89}, 
{84, 95, 87}, {83, 88, 74}, {85, 82, 74}, {82, 80, 72}, 
{85, 79, 66}, {89, 82, 61}, {95, 83, 56}, {98, 81, 61}, 
{101, 80, 68}, {92, 81, 69}, {90, 84, 74}, {94, 86, 82}, 
{98, 92, 86}, {96, 99, 90}, {113, 110, 94}, {119, 105, 92}, 
{120, 104, 88}, {103, 94, 86}, {90, 91, 78}, {76, 90, 75}, 
{78, 83, 79}, {70, 84, 73}, {66, 92, 77}, {76, 94, 87}, 
{94, 99, 100}, {103, 108, 119}, {105, 132, 130}, {129, 156, 139}, 
{158, 162, 146}, {178, 172, 157}, {178, 176, 173}, {166, 166, 167}, 
{125, 150, 143}, {97, 132, 135}, {105, 129, 130}, {104, 126, 123}, 
{100, 128, 120}, {95, 119, 120}, {95, 117, 107}, {103, 127, 111}, 
{110, 137, 122}, {130, 141, 133}, {142, 138, 120}, {137, 157, 120}, 
{139, 133, 110}, {131, 123, 109}, {127, 112, 99}, {120, 105, 95}, 
{116, 103, 90}, {103, 92, 79}, {105, 92, 76}, {114, 99, 83}, 
},

/* the-hollow-needle-at-etretat.ppm */
{{106, 110, 103}, {105, 117, 116}, {105, 119, 120}, {117, 133, 130}, 
{123, 144, 135}, {124, 144, 138}, {125, 149, 140}, {123, 146, 140}, 
{122, 149, 150}, {127, 156, 144}, {128, 155, 142}, {137, 151, 143}, 
{140, 148, 142}, {143, 151, 132}, {150, 154, 130}, {151, 152, 135}, 
{147, 158, 149}, {143, 154, 144}, {139, 151, 144}, {137, 150, 147}, 
{143, 152, 149}, {137, 149, 146}, {137, 147, 142}, {134, 146, 140}, 
{131, 141, 135}, {125, 140, 138}, {123, 143, 138}, {123, 144, 140}, 
{123, 144, 140}, {128, 145, 142}, {127, 150, 141}, {120, 153, 141}, 
{125, 157, 144}, {131, 159, 151}, {134, 161, 147}, {143, 160, 151}, 
{142, 166, 163}, {136, 172, 169}, {139, 163, 165}, {130, 157, 142}, 
{130, 151, 141}, {131, 146, 141}, {134, 148, 150}, {130, 152, 143}, 
{130, 156, 138}, {132, 155, 137}, {137, 158, 132}, {134, 153, 129}, 
{134, 147, 129}, {135, 143, 126}, {133, 142, 127}, {138, 135, 118}, 
{132, 125, 106}, {125, 113, 95}, {118, 101, 87}, {103, 92, 72}, 
{78, 69, 55}, {64, 59, 54}, {59, 56, 53}, {60, 58, 54}, 
{69, 64, 58}, {88, 86, 83}, {95, 101, 97}, {93, 108, 101}, 
{91, 108, 101}, {91, 109, 107}, {91, 110, 109}, {89, 114, 113}, 
{93, 112, 109}, {93, 108, 105}, {101, 112, 108}, {107, 116, 118}, 
{115, 128, 125}, {120, 147, 132}, {125, 154, 134}, {131, 150, 131}, 
{138, 147, 135}, {138, 144, 132}, {136, 139, 128}, {138, 138, 127}, 
{138, 138, 115}, {137, 134, 102}, {132, 131, 102}, {137, 124, 97}, 
{127, 120, 88}, {120, 108, 84}, {114, 110, 84}, {112, 104, 84}, 
{113, 99, 83}, {116, 105, 87}, {118, 111, 89}, {121, 117, 102}, 
{126, 127, 112}, {131, 131, 121}, {136, 137, 128}, {136, 136, 130}, 
{135, 139, 131}, {132, 140, 127}, {131, 132, 126}, {128, 121, 119}, 
{122, 110, 104}, {106, 92, 92}, {91, 75, 69}, {70, 59, 53}, 
{60, 55, 52}, {59, 54, 51}, {59, 55, 48}, {57, 54, 50}, 
{59, 53, 52}, {58, 51, 51}, {52, 51, 51}, {52, 49, 50}, 
{55, 52, 51}, {51, 53, 50}, {55, 52, 52}, {58, 53, 54}, 
{55, 55, 57}, {58, 61, 59}, {58, 79, 76}, {85, 101, 93}, 
{95, 101, 97}, {101, 102, 97}, {103, 104, 99}, {96, 106, 104}, 
{108, 116, 106}, {116, 120, 110}, {125, 129, 121}, {129, 141, 131}, 
{129, 141, 135}, {130, 139, 132}, {126, 128, 128}, {114, 120, 117}, 
{107, 106, 100}, {100, 94, 85}, {88, 80, 69}, {68, 59, 55}, 
{60, 53, 52}, {55, 51, 48}, {53, 49, 48}, {49, 52, 48}, 
{47, 50, 45}, {47, 46, 47}, {49, 44, 43}, {51, 43, 42}, 
{52, 49, 45}, {56, 52, 52}, {58, 57, 56}, {63, 81, 78}, 
{86, 105, 100}, {102, 121, 118}, {99, 124, 126}, {105, 124, 123}, 
{117, 127, 119}, {129, 135, 121}, {133, 141, 123}, {136, 139, 115}, 
{133, 130, 109}, {127, 125, 102}, {124, 118, 97}, {116, 114, 98}, 
{120, 113, 99}, {121, 113, 96}, {125, 109, 96}, {120, 110, 94}, 
{119, 106, 92}, {112, 106, 92}, {106, 94, 90}, {92, 84, 78}, 
{69, 60, 61}, {61, 55, 53}, {58, 54, 53}, {57, 54, 53}, 
{52, 54, 54}, {52, 53, 51}, {53, 55, 50}, {60, 57, 52}, 
{71, 66, 59}, {91, 97, 89}, {96, 106, 102}, {106, 121, 116}, 
{127, 138, 129}, {128, 141, 135}, {123, 139, 137}, {116, 129, 123}, 
{103, 125, 111}, {104, 121, 111}, {111, 115, 106}, {114, 114, 105}, 
{121, 111, 103}, {120, 115, 110}, {122, 120, 112}, {127, 124, 112}, 
{131, 118, 107}, {130, 116, 105}, {128, 124, 102}, {130, 124, 103}, 
{139, 121, 98}, {143, 116, 99}, {147, 128, 100}, {154, 127, 99}, 
{147, 135, 109}, {157, 128, 102}, {158, 130, 115}, {162, 148, 115}, 
{150, 137, 119}, {144, 145, 121}, {143, 148, 132}, {141, 142, 126}, 
{135, 140, 128}, {134, 141, 133}, {134, 144, 132}, {132, 140, 130}, 
{131, 142, 130}, {132, 141, 128}, {134, 141, 126}, {133, 141, 123}, 
{136, 135, 113}, {134, 129, 107}, {127, 122, 100}, {121, 119, 94}, 
{107, 116, 90}, {106, 111, 91}, {105, 103, 93}, {107, 103, 92}, 
{108, 111, 94}, {112, 119, 107}, {114, 128, 121}, {119, 139, 131}, 
{122, 145, 135}, {126, 148, 136}, {128, 147, 135}, {138, 146, 137}, 
{139, 145, 132}, {142, 142, 125}, {143, 133, 118}, {144, 132, 111}, 
{142, 136, 110}, {140, 136, 110}, {135, 130, 115}, {132, 123, 106}, 
{130, 118, 92}, {132, 115, 92}, {142, 106, 91}, {123, 109, 89}, 
{107, 101, 84}, {95, 91, 86}, {72, 64, 59}, {64, 58, 53}, 
{59, 54, 54}, {59, 56, 51}, {63, 57, 55}, {71, 69, 68}, 
{97, 100, 88}, {112, 114, 103}, {123, 135, 123}, {132, 145, 128}, 
},

/* rouen-cathedral-sunset.ppm */
{{137, 129, 126}, {130, 125, 111}, {120, 112, 98}, {113, 109, 87}, 
{100, 101, 83}, {91, 93, 81}, {78, 84, 72}, {82, 89, 66}, 
{86, 88, 71}, {95, 95, 69}, {100, 92, 61}, {114, 94, 53}, 
{125, 91, 54}, {127, 96, 57}, {124, 99, 57}, {115, 101, 64}, 
{101, 98, 68}, {96, 101, 80}, {100, 106, 87}, {104, 104, 90}, 
{109, 106, 87}, {115, 111, 90}, {126, 115, 100}, {133, 126, 107}, 
{143, 135, 116}, {144, 133, 122}, {149, 131, 136}, {156, 134, 129}, 
{145, 134, 125}, {141, 128, 118}, {133, 129, 109}, {131, 125, 111}, 
{129, 125, 110}, {126, 124, 99}, {126, 130, 107}, {128, 129, 111}, 
{133, 129, 113}, {136, 136, 123}, {148, 145, 137}, {156, 150, 144}, 
{159, 153, 146}, {159, 150, 152}, {160, 152, 145}, {156, 147, 147}, 
{148, 143, 149}, {141, 141, 144}, {138, 133, 130}, {135, 127, 125}, 
{134, 131, 124}, {140, 131, 120}, {140, 129, 126}, {138, 137, 132}, 
{138, 138, 149}, {135, 149, 160}, {134, 149, 164}, {134, 153, 171}, 
{138, 149, 164}, {128, 140, 150}, {137, 142, 147}, {146, 144, 145}, 
{158, 141, 140}, {163, 146, 139}, {176, 154, 136}, {179, 159, 144}, 
{187, 167, 151}, {198, 171, 154}, {190, 158, 132}, {166, 145, 107}, 
{145, 133, 91}, {146, 114, 79}, {138, 108, 71}, {119, 101, 76}, 
{107, 102, 78}, {98, 98, 78}, {94, 92, 78}, {93, 90, 71}, 
{91, 88, 60}, {90, 82, 53}, {88, 77, 52}, {73, 74, 52}, 
{84, 82, 57}, {93, 89, 57}, {105, 94, 71}, {94, 91, 69}, 
{97, 94, 72}, {108, 98, 64}, {115, 99, 71}, {110, 101, 74}, 
{115, 107, 73}, {128, 112, 75}, {142, 113, 73}, {148, 117, 75}, 
{151, 128, 86}, {156, 137, 106}, {162, 141, 119}, {163, 151, 126}, 
{167, 156, 133}, {163, 155, 136}, {152, 147, 144}, {140, 147, 140}, 
{133, 139, 127}, {126, 130, 125}, {124, 125, 113}, {115, 119, 108}, 
{112, 120, 111}, {102, 118, 115}, {104, 116, 116}, {97, 117, 107}, 
{107, 113, 107}, {111, 108, 103}, {105, 109, 99}, {104, 111, 97}, 
{106, 106, 91}, {105, 101, 88}, {108, 102, 85}, {107, 102, 78}, 
{112, 105, 78}, {129, 112, 90}, {138, 127, 92}, {144, 135, 111}, 
{138, 142, 129}, {149, 149, 147}, {155, 152, 161}, {153, 158, 170}, 
{155, 159, 171}, {163, 158, 161}, {167, 155, 153}, {173, 159, 145}, 
{169, 155, 135}, {169, 141, 105}, {162, 125, 95}, {150, 117, 93}, 
{138, 116, 91}, {134, 109, 85}, {119, 109, 80}, {119, 108, 82}, 
{122, 108, 77}, {124, 105, 74}, {125, 111, 79}, {120, 109, 77}, 
{118, 111, 81}, {116, 115, 87}, {111, 113, 89}, {114, 114, 91}, 
{116, 121, 96}, {134, 128, 108}, {153, 138, 122}, {169, 146, 132}, 
{181, 154, 130}, {168, 153, 130}, {152, 142, 119}, {143, 135, 108}, 
{133, 126, 95}, {125, 123, 93}, {119, 112, 86}, {116, 106, 83}, 
{121, 111, 84}, {128, 107, 87}, {129, 110, 95}, {138, 120, 91}, 
{140, 124, 91}, {144, 126, 93}, {141, 131, 91}, {128, 122, 90}, 
{119, 119, 90}, {116, 112, 102}, {109, 114, 95}, {109, 112, 110}, 
{109, 120, 119}, {121, 129, 122}, {132, 131, 122}, {144, 145, 135}, 
{158, 148, 141}, {175, 158, 144}, {180, 158, 149}, {187, 171, 158}, 
{188, 176, 158}, {184, 167, 145}, {175, 166, 137}, {162, 151, 133}, 
{153, 137, 111}, {144, 123, 100}, {128, 119, 90}, {120, 113, 85}, 
{113, 110, 80}, {115, 104, 72}, {116, 100, 68}, {124, 101, 64}, 
{134, 100, 67}, {135, 109, 63}, {139, 112, 67}, {135, 120, 75}, 
{133, 120, 93}, {133, 127, 105}, {132, 128, 123}, {132, 136, 146}, 
{134, 143, 152}, {140, 153, 164}, {141, 154, 168}, {142, 155, 165}, 
{157, 156, 151}, {159, 159, 138}, {173, 162, 141}, {177, 164, 143}, 
{177, 163, 150}, {181, 166, 158}, {181, 169, 162}, {175, 170, 163}, 
{179, 164, 162}, {175, 162, 155}, {161, 155, 148}, {158, 157, 147}, 
{150, 155, 147}, {147, 153, 144}, {136, 138, 124}, {128, 126, 114}, 
{112, 112, 107}, {100, 106, 99}, {96, 104, 99}, {93, 103, 96}, 
{103, 102, 89}, {111, 104, 84}, {112, 102, 80}, {118, 102, 74}, 
{119, 98, 70}, {118, 95, 67}, {116, 94, 61}, {112, 90, 58}, 
{104, 90, 60}, {103, 91, 56}, {98, 86, 57}, {92, 84, 51}, 
{89, 84, 60}, {106, 82, 55}, {111, 90, 56}, {113, 85, 56}, 
{103, 92, 65}, {109, 103, 77}, {104, 99, 86}, {106, 96, 89}, 
{101, 101, 95}, {103, 105, 98}, {109, 110, 103}, {102, 114, 94}, 
{112, 114, 107}, {126, 117, 99}, {136, 130, 104}, {150, 140, 107}, 
{157, 138, 106}, {157, 142, 104}, {154, 139, 109}, {155, 146, 128}, 
{154, 142, 136}, {155, 145, 145}, {148, 151, 156}, {135, 158, 170}, 
},

/* the-houses-of-parliament.ppm */
{{105, 95, 133}, {97, 86, 120}, {81, 81, 103}, {78, 71, 88}, 
{74, 66, 79}, {75, 64, 73}, {76, 68, 75}, {79, 65, 74}, 
{81, 71, 74}, {83, 74, 81}, {88, 74, 87}, {91, 81, 96}, 
{98, 92, 112}, {101, 95, 126}, {107, 95, 136}, {110, 95, 141}, 
{109, 90, 136}, {104, 88, 136}, {105, 89, 130}, {103, 87, 118}, 
{102, 88, 117}, {105, 87, 110}, {101, 84, 111}, {105, 90, 112}, 
{103, 99, 115}, {105, 101, 116}, {107, 98, 117}, {104, 90, 120}, 
{97, 87, 122}, {98, 90, 114}, {94, 89, 109}, {90, 91, 103}, 
{88, 82, 96}, {82, 76, 86}, {78, 74, 77}, {70, 72, 69}, 
{66, 72, 63}, {57, 67, 60}, {60, 67, 57}, {68, 73, 65}, 
{77, 83, 71}, {85, 94, 92}, {94, 102, 97}, {97, 101, 106}, 
{101, 101, 100}, {99, 99, 106}, {100, 98, 109}, {103, 94, 112}, 
{103, 90, 112}, {101, 87, 113}, {104, 89, 111}, {100, 96, 107}, 
{95, 96, 107}, {95, 88, 106}, {97, 88, 108}, {99, 93, 112}, 
{98, 90, 105}, {99, 89, 96}, {97, 90, 96}, {96, 87, 99}, 
{94, 88, 105}, {97, 85, 111}, {101, 86, 113}, {105, 88, 117}, 
{109, 93, 128}, {116, 98, 135}, {115, 98, 135}, {113, 103, 131}, 
{112, 105, 138}, {108, 99, 133}, {107, 95, 124}, {109, 94, 123}, 
{106, 91, 122}, {106, 88, 116}, {107, 87, 116}, {104, 84, 117}, 
{105, 84, 116}, {109, 87, 112}, {110, 91, 114}, {107, 96, 117}, 
{111, 92, 117}, {107, 89, 116}, {105, 86, 118}, {105, 80, 127}, 
{99, 75, 134}, {98, 73, 129}, {100, 80, 128}, {98, 79, 126}, 
{101, 74, 127}, {98, 78, 121}, {97, 76, 113}, {96, 75, 103}, 
{92, 76, 99}, {88, 79, 90}, {87, 75, 90}, {90, 74, 94}, 
{87, 75, 92}, {88, 76, 92}, {91, 71, 96}, {99, 77, 99}, 
{96, 80, 102}, {95, 77, 105}, {91, 71, 112}, {94, 69, 117}, 
{98, 78, 117}, {103, 87, 122}, {114, 90, 141}, {109, 96, 134}, 
{113, 101, 136}, {126, 107, 140}, {119, 100, 132}, {114, 96, 113}, 
{108, 88, 109}, {99, 87, 106}, {92, 83, 102}, {87, 79, 96}, 
{88, 76, 95}, {85, 74, 97}, {87, 69, 102}, {88, 71, 101}, 
{88, 73, 97}, {90, 79, 103}, {93, 81, 107}, {93, 82, 118}, 
{99, 81, 123}, {96, 81, 125}, {93, 84, 125}, {94, 82, 129}, 
{100, 90, 128}, {101, 97, 124}, {100, 99, 116}, {107, 103, 112}, 
{117, 106, 104}, {114, 106, 108}, {117, 106, 115}, {108, 99, 108}, 
{104, 99, 107}, {103, 107, 98}, {103, 102, 98}, {95, 96, 97}, 
{95, 94, 91}, {87, 87, 83}, {87, 79, 87}, {81, 73, 84}, 
{77, 63, 79}, {75, 60, 74}, {73, 61, 75}, {72, 61, 78}, 
{75, 63, 78}, {73, 62, 78}, {78, 63, 84}, {77, 58, 97}, 
{85, 66, 100}, {87, 65, 102}, {82, 72, 104}, {81, 66, 105}, 
{80, 60, 96}, {73, 63, 82}, {66, 63, 76}, {57, 55, 54}, 
{21, 24, 21}, {23, 29, 20}, {48, 55, 48}, {55, 64, 60}, 
{63, 67, 69}, {70, 66, 72}, {81, 74, 83}, {89, 79, 89}, 
{96, 86, 96}, {105, 86, 105}, {117, 96, 112}, {118, 114, 124}, 
{126, 123, 126}, {135, 132, 151}, {125, 115, 137}, {119, 118, 134}, 
{109, 109, 133}, {109, 101, 128}, {112, 107, 128}, {109, 104, 122}, 
{101, 103, 124}, {106, 99, 117}, {112, 100, 119}, {109, 98, 112}, 
{106, 101, 114}, {105, 102, 114}, {100, 99, 111}, {96, 94, 103}, 
{94, 89, 94}, {94, 88, 88}, {88, 92, 82}, {82, 92, 73}, 
{79, 89, 73}, {72, 84, 72}, {70, 83, 68}, {83, 75, 77}, 
{89, 76, 87}, {91, 80, 103}, {101, 84, 114}, {108, 86, 126}, 
{110, 87, 139}, {115, 90, 142}, {124, 85, 142}, {107, 82, 129}, 
{109, 92, 129}, {100, 82, 119}, {97, 82, 112}, {97, 83, 102}, 
{89, 84, 97}, {89, 83, 96}, {92, 86, 94}, {96, 87, 95}, 
{99, 86, 92}, {95, 84, 96}, {94, 85, 93}, {91, 84, 85}, 
{86, 83, 84}, {78, 85, 89}, {73, 84, 86}, {69, 76, 83}, 
{75, 71, 83}, {77, 68, 83}, {77, 69, 81}, {79, 70, 84}, 
{80, 69, 82}, {77, 68, 83}, {78, 69, 85}, {83, 72, 86}, 
{82, 75, 87}, {84, 74, 84}, {83, 72, 81}, {77, 66, 76}, 
{73, 60, 73}, {62, 52, 70}, {60, 52, 63}, {67, 65, 63}, 
{80, 68, 65}, {84, 78, 71}, {87, 78, 86}, {88, 82, 93}, 
{92, 84, 96}, {97, 85, 102}, {105, 82, 108}, {103, 84, 105}, 
{98, 82, 102}, {94, 77, 103}, {88, 74, 101}, {88, 73, 102}, 
{89, 74, 104}, {88, 75, 115}, {90, 81, 118}, {95, 83, 122}, 
{97, 82, 118}, {100, 83, 113}, {97, 86, 109}, {91, 89, 101}, 
},

/* starry-night.ppm */
{{23, 26, 18}, {27, 29, 21}, {30, 29, 21}, {29, 30, 22}, 
{32, 35, 26}, {40, 42, 32}, {43, 47, 35}, {45, 54, 38}, 
{52, 52, 36}, {50, 54, 38}, {51, 56, 39}, {50, 56, 42}, 
{50, 60, 42}, {52, 63, 47}, {60, 68, 51}, {69, 73, 55}, 
{67, 76, 55}, {68, 78, 53}, {69, 82, 55}, {70, 87, 59}, 
{77, 101, 65}, {87, 101, 66}, {92, 108, 67}, {93, 105, 65}, 
{93, 107, 65}, {90, 110, 66}, {93, 110, 65}, {95, 111, 69}, 
{102, 114, 73}, {104, 110, 69}, {109, 110, 61}, {98, 105, 65}, 
{94, 108, 61}, {82, 98, 56}, {78, 86, 53}, {81, 79, 57}, 
{81, 82, 62}, {88, 91, 60}, {99, 93, 62}, {95, 106, 64}, 
{91, 110, 65}, {84, 117, 77}, {89, 124, 81}, {104, 128, 92}, 
{114, 130, 84}, {120, 132, 84}, {138, 148, 85}, {148, 150, 76}, 
{134, 147, 76}, {131, 138, 78}, {110, 108, 66}, {96, 89, 57}, 
{81, 72, 49}, {66, 65, 45}, {63, 60, 40}, {60, 55, 44}, 
{58, 56, 43}, {56, 56, 42}, {53, 57, 42}, {58, 59, 42}, 
{57, 61, 41}, {57, 65, 42}, {57, 65, 45}, {59, 61, 49}, 
{63, 68, 55}, {71, 77, 53}, {76, 86, 54}, {90, 95, 55}, 
{101, 108, 65}, {114, 125, 74}, {133, 146, 76}, {142, 156, 82}, 
{161, 168, 92}, {177, 178, 94}, {177, 173, 93}, {167, 158, 86}, 
{152, 147, 79}, {133, 115, 72}, {98, 100, 67}, {80, 86, 54}, 
{73, 80, 53}, {61, 71, 47}, {44, 58, 38}, {37, 46, 32}, 
{35, 38, 27}, {29, 35, 23}, {28, 36, 25}, {28, 38, 24}, 
{33, 46, 30}, {37, 47, 30}, {44, 48, 34}, {47, 49, 36}, 
{46, 51, 36}, {41, 51, 31}, {35, 50, 34}, {35, 48, 31}, 
{42, 51, 35}, {46, 53, 44}, {53, 62, 43}, {60, 70, 49}, 
{73, 77, 59}, {80, 88, 64}, {83, 98, 84}, {86, 101, 99}, 
{100, 114, 92}, {101, 108, 80}, {93, 106, 76}, {81, 103, 75}, 
{87, 101, 75}, {85, 113, 85}, {78, 110, 80}, {83, 109, 74}, 
{86, 107, 71}, {86, 113, 65}, {89, 104, 67}, {79, 101, 66}, 
{77, 98, 63}, {70, 86, 63}, {68, 76, 67}, {69, 82, 61}, 
{73, 82, 59}, {72, 84, 61}, {70, 90, 69}, {80, 98, 83}, 
{91, 106, 77}, {102, 110, 80}, {102, 120, 77}, {98, 126, 70}, 
{99, 122, 78}, {94, 114, 72}, {84, 101, 67}, {75, 84, 58}, 
{76, 78, 53}, {69, 77, 48}, {64, 65, 44}, {58, 64, 43}, 
{51, 55, 41}, {46, 51, 38}, {40, 45, 35}, {30, 34, 29}, 
{29, 29, 22}, {26, 27, 22}, {26, 28, 24}, {25, 27, 22}, 
{28, 28, 22}, {31, 30, 25}, {37, 34, 28}, {41, 37, 29}, 
{42, 39, 34}, {47, 44, 36}, {42, 47, 33}, {38, 44, 30}, 
{33, 36, 27}, {31, 31, 25}, {29, 27, 21}, {27, 24, 21}, 
{24, 26, 19}, {23, 26, 18}, {20, 18, 14}, {24, 25, 18}, 
{30, 32, 23}, {37, 40, 30}, {42, 45, 37}, {51, 55, 41}, 
{60, 63, 47}, {70, 75, 52}, {84, 78, 49}, {100, 92, 59}, 
{112, 106, 63}, {118, 115, 66}, {121, 131, 78}, {122, 138, 89}, 
{125, 149, 98}, {139, 157, 105}, {124, 152, 98}, {113, 139, 83}, 
{103, 125, 72}, {105, 112, 69}, {93, 103, 63}, {80, 88, 54}, 
{73, 78, 53}, {61, 76, 49}, {57, 66, 47}, {54, 68, 47}, 
{50, 64, 40}, {53, 60, 42}, {56, 53, 44}, {58, 54, 39}, 
{58, 56, 39}, {53, 57, 37}, {53, 56, 38}, {56, 54, 36}, 
{52, 49, 33}, {42, 44, 30}, {35, 38, 26}, {29, 35, 24}, 
{29, 35, 26}, {38, 42, 31}, {44, 44, 32}, {53, 51, 31}, 
{62, 62, 41}, {78, 77, 54}, {91, 97, 67}, {109, 122, 77}, 
{136, 138, 83}, {149, 149, 83}, {163, 154, 83}, {167, 153, 89}, 
{156, 160, 90}, {145, 153, 84}, {129, 142, 79}, {109, 130, 80}, 
{101, 123, 85}, {98, 123, 94}, {91, 102, 87}, {90, 98, 79}, 
{94, 92, 81}, {83, 92, 66}, {78, 84, 59}, {74, 77, 55}, 
{64, 65, 48}, {58, 56, 43}, {50, 48, 36}, {45, 42, 31}, 
{37, 34, 25}, {34, 30, 21}, {34, 28, 24}, {38, 39, 28}, 
{47, 48, 35}, {52, 52, 41}, {56, 59, 43}, {59, 68, 57}, 
{57, 78, 58}, {68, 89, 57}, {69, 88, 56}, {67, 80, 54}, 
{61, 77, 51}, {56, 74, 47}, {56, 69, 44}, {53, 62, 42}, 
{51, 56, 42}, {53, 53, 45}, {51, 52, 44}, {51, 54, 48}, 
{54, 59, 52}, {64, 61, 53}, {69, 66, 63}, {63, 69, 56}, 
{75, 76, 52}, {80, 79, 52}, {78, 82, 51}, {84, 91, 59}, 
{92, 100, 65}, {97, 104, 63}, {98, 99, 61}, {92, 93, 57}, 
},

/* water-lilies-sunset.ppm */
{{71, 67, 46}, {71, 67, 50}, {67, 72, 57}, {72, 84, 60}, 
{81, 87, 72}, {92, 93, 74}, {84, 86, 74}, {88, 100, 84}, 
{83, 84, 73}, {77, 74, 68}, {68, 62, 56}, {60, 59, 48}, 
{60, 55, 47}, {57, 49, 38}, {53, 45, 38}, {52, 44, 36}, 
{52, 46, 36}, {57, 49, 37}, {58, 49, 38}, {60, 52, 39}, 
{63, 57, 43}, {70, 60, 45}, {80, 65, 48}, {85, 71, 52}, 
{89, 76, 54}, {90, 83, 53}, {96, 92, 57}, {102, 95, 62}, 
{106, 98, 61}, {112, 100, 62}, {115, 107, 65}, {119, 106, 67}, 
{129, 111, 70}, {132, 119, 74}, {130, 120, 71}, {126, 118, 69}, 
{112, 111, 84}, {101, 100, 80}, {87, 93, 92}, {90, 101, 87}, 
{85, 94, 100}, {107, 108, 90}, {130, 118, 110}, {135, 118, 104}, 
{153, 156, 127}, {183, 183, 126}, {189, 184, 126}, {177, 165, 100}, 
{173, 153, 91}, {162, 148, 88}, {145, 135, 77}, {134, 124, 72}, 
{116, 107, 66}, {103, 91, 59}, {89, 73, 62}, {78, 65, 49}, 
{69, 58, 43}, {67, 51, 41}, {63, 50, 42}, {66, 51, 48}, 
{69, 57, 49}, {76, 58, 53}, {81, 65, 54}, {86, 73, 55}, 
{86, 81, 53}, {95, 87, 55}, {100, 87, 58}, {101, 88, 65}, 
{112, 87, 80}, {117, 98, 73}, {114, 106, 68}, {120, 110, 68}, 
{122, 109, 67}, {122, 107, 66}, {125, 104, 66}, {116, 94, 63}, 
{114, 90, 60}, {105, 84, 56}, {93, 76, 53}, {93, 75, 51}, 
{91, 75, 52}, {84, 76, 49}, {83, 73, 48}, {82, 74, 48}, 
{77, 76, 51}, {72, 74, 53}, {68, 68, 54}, {69, 66, 54}, 
{66, 66, 52}, {65, 64, 48}, {65, 62, 49}, {64, 58, 49}, 
{63, 58, 46}, {62, 60, 46}, {61, 60, 46}, {58, 57, 44}, 
{56, 55, 45}, {56, 52, 44}, {55, 51, 45}, {49, 50, 41}, 
{51, 47, 38}, {54, 49, 41}, {50, 46, 38}, {45, 49, 39}, 
{44, 47, 36}, {50, 47, 34}, {48, 44, 33}, {51, 44, 34}, 
{51, 49, 37}, {55, 51, 37}, {56, 49, 38}, {54, 52, 42}, 
{55, 50, 40}, {57, 51, 39}, {58, 53, 39}, {60, 53, 38}, 
{59, 54, 40}, {61, 55, 41}, {61, 58, 43}, {64, 60, 43}, 
{72, 64, 48}, {83, 65, 47}, {84, 72, 48}, {93, 75, 51}, 
{102, 87, 55}, {106, 97, 61}, {113, 104, 64}, {122, 109, 67}, 
{133, 113, 69}, {136, 116, 69}, {142, 123, 72}, {142, 123, 74}, 
{144, 118, 73}, {130, 100, 83}, {134, 88, 71}, {112, 86, 58}, 
{100, 68, 52}, {80, 54, 44}, {72, 52, 42}, {66, 49, 38}, 
{63, 55, 41}, {63, 57, 42}, {63, 60, 44}, {70, 64, 47}, 
{72, 68, 48}, {78, 71, 47}, {76, 77, 51}, {78, 82, 52}, 
{82, 81, 52}, {79, 74, 48}, {78, 70, 47}, {75, 67, 45}, 
{67, 64, 43}, {62, 59, 42}, {59, 55, 42}, {57, 53, 40}, 
{56, 53, 44}, {60, 55, 50}, {67, 61, 49}, {77, 68, 51}, 
{84, 74, 52}, {89, 82, 53}, {98, 89, 56}, {101, 88, 58}, 
{102, 90, 59}, {101, 95, 69}, {95, 95, 61}, {96, 94, 59}, 
{83, 88, 66}, {84, 79, 68}, {76, 73, 67}, {73, 68, 54}, 
{68, 62, 51}, {66, 61, 48}, {61, 61, 47}, {60, 57, 47}, 
{57, 55, 44}, {57, 54, 40}, {57, 56, 40}, {57, 54, 39}, 
{56, 55, 38}, {52, 51, 37}, {48, 46, 38}, {44, 41, 36}, 
{42, 42, 33}, {44, 43, 33}, {48, 40, 34}, {52, 44, 36}, 
{57, 47, 42}, {57, 49, 42}, {62, 55, 41}, {64, 55, 44}, 
{67, 56, 43}, {68, 58, 44}, {69, 61, 41}, {71, 61, 41}, 
{78, 63, 48}, {78, 72, 52}, {86, 75, 58}, {95, 85, 61}, 
{110, 99, 68}, {119, 111, 69}, {134, 124, 74}, {149, 132, 78}, 
{152, 141, 84}, {161, 143, 85}, {143, 122, 76}, {129, 116, 70}, 
{114, 90, 60}, {98, 82, 55}, {89, 66, 48}, {79, 56, 45}, 
{74, 53, 44}, {71, 54, 46}, {66, 54, 42}, {64, 56, 40}, 
{62, 56, 40}, {64, 52, 39}, {63, 48, 39}, {61, 48, 43}, 
{58, 50, 44}, {57, 51, 44}, {61, 53, 46}, {67, 53, 49}, 
{68, 57, 48}, {71, 60, 52}, {70, 63, 49}, {69, 61, 48}, 
{70, 62, 49}, {70, 65, 48}, {68, 68, 47}, {65, 67, 48}, 
{62, 64, 46}, {63, 61, 43}, {64, 60, 42}, {68, 59, 43}, 
{72, 61, 44}, {79, 56, 45}, {85, 65, 47}, {85, 71, 52}, 
{82, 77, 59}, {79, 77, 63}, {72, 71, 65}, {70, 69, 56}, 
{63, 69, 53}, {61, 66, 52}, {58, 63, 47}, {64, 62, 45}, 
{67, 59, 48}, {71, 63, 51}, {74, 64, 54}, {74, 72, 52}, 
{84, 77, 54}, {92, 84, 61}, {105, 96, 62}, {117, 102, 75}, 
},

/* gogh.chambre-arles.ppm*/
{
 {24, 17, 8}, {25, 34, 4}, {53, 56, 72}, {75, 94, 108},
 {86, 110, 145}, {99, 141, 175}, {125, 154, 163}, {166, 146, 109},
 {182, 142, 103}, {191, 159, 113}, {206, 191, 120}, {238, 216, 142},
 {252, 233, 156}, {242, 229, 171}, {220, 226, 215}, {209, 216, 221},
 {207, 213, 224}, {199, 215, 224}, {189, 208, 223}, {171, 194, 208},
 {176, 188, 187}, {183, 159, 117}, {172, 130, 92}, {163, 113, 62},
 {159, 109, 53}, {176, 110, 9}, {188, 116, 6}, {196, 118, 6},
 {202, 123, 10}, {209, 126, 15}, {200, 127, 38}, {193, 145, 91},
 {240, 193, 119}, {251, 235, 153}, {252, 240, 170}, {246, 231, 174},
 {229, 224, 220}, {232, 232, 224}, {224, 230, 230}, {206, 219, 225},
 {194, 207, 215}, {177, 193, 190}, {205, 177, 130}, {196, 149, 101},
 {191, 134, 97}, {193, 146, 106}, {196, 168, 125}, {176, 190, 191},
 {170, 197, 217}, {187, 204, 220}, {188, 206, 216}, {178, 198, 204},
 {171, 191, 183}, {173, 147, 108}, {162, 121, 84}, {154, 108, 70},
 {140, 98, 58}, {116, 85, 48}, {116, 84, 56}, {131, 93, 52},
 {148, 97, 49}, {171, 95, 9}, {183, 104, 7}, {188, 110, 6},
 {190, 110, 4}, {193, 109, 2}, {198, 109, 1}, {193, 107, 1},
 {194, 106, 7}, {196, 109, 4}, {196, 110, 6}, {199, 108, 5},
 {208, 107, 2}, {208, 114, 3}, {209, 118, 3}, {207, 116, 4},
 {207, 118, 1}, {205, 116, 2}, {205, 115, 2}, {203, 113, 2},
 {200, 113, 3}, {199, 113, 4}, {200, 113, 8}, {198, 110, 6},
 {195, 112, 4}, {195, 111, 8}, {197, 113, 9}, {193, 112, 8},
 {193, 108, 14}, {169, 119, 67}, {172, 143, 109}, {171, 184, 178},
 {169, 189, 198}, {168, 187, 198}, {168, 185, 180}, {169, 148, 113},
 {169, 132, 96}, {167, 122, 89}, {169, 124, 91}, {169, 131, 94},
 {166, 155, 102}, {148, 172, 162}, {129, 172, 187}, {136, 170, 194},
 {153, 157, 161}, {165, 131, 95}, {160, 121, 84}, {161, 118, 85},
 {163, 122, 91}, {171, 133, 94}, {184, 152, 116}, {179, 181, 168},
 {177, 188, 203}, {169, 193, 202}, {163, 191, 202}, {149, 178, 194},
 {133, 162, 176}, {136, 138, 111}, {132, 144, 61}, {137, 134, 53},
 {194, 125, 15}, {190, 117, 10}, {191, 118, 4}, {193, 122, 4},
 {200, 125, 8}, {207, 130, 2}, {210, 134, 2}, {216, 134, 8},
 {219, 135, 6}, {219, 145, 9}, {206, 205, 99}, {232, 220, 127},
 {222, 216, 127}, {201, 205, 98}, {196, 170, 103}, {175, 139, 86},
 {151, 118, 83}, {115, 102, 102}, {110, 133, 148}, {120, 156, 176},
 {134, 169, 197}, {136, 177, 199}, {161, 174, 178}, {182, 144, 107},
 {181, 124, 68}, {201, 121, 16}, {206, 122, 10}, {208, 119, 4},
 {214, 118, 1}, {220, 132, 10}, {212, 144, 55}, {234, 182, 112},
 {228, 188, 116}, {194, 165, 109}, {185, 142, 96}, {187, 133, 83},
 {177, 126, 79}, {178, 127, 86}, {187, 139, 104}, {198, 164, 121},
 {209, 185, 155}, {216, 212, 192}, {221, 224, 217}, {227, 230, 223},
 {230, 233, 226}, {222, 228, 229}, {207, 218, 218}, {189, 198, 201},
 {197, 169, 130}, {181, 136, 99}, {169, 120, 86}, {155, 117, 75},
 {153, 114, 75}, {151, 110, 72}, {144, 106, 72}, {144, 104, 68},
 {148, 105, 65}, {147, 103, 64}, {147, 100, 66}, {145, 106, 67},
 {141, 112, 72}, {137, 119, 73}, {134, 114, 77}, {139, 118, 78},
 {150, 115, 79}, {164, 119, 78}, {185, 138, 95}, {195, 171, 118},
 {243, 205, 123}, {251, 237, 150}, {253, 240, 166}, {252, 235, 164},
 {224, 211, 162}, {191, 180, 120}, {162, 128, 86}, {132, 94, 56},
 {84, 77, 37}, {55, 30, 16}, {64, 34, 7}, {112, 61, 7},
 {150, 78, 12}, {177, 94, 6}, {186, 107, 5}, {192, 115, 5},
 {200, 115, 7}, {207, 117, 5}, {205, 124, 12}, {209, 130, 13},
 {196, 163, 88}, {221, 200, 109}, {247, 221, 145}, {239, 223, 166},
 {217, 211, 177}, {176, 195, 194}, {129, 161, 184}, {94, 125, 148},
 {73, 92, 121}, {85, 85, 107}, {99, 94, 60}, {97, 90, 58},
 {106, 72, 24}, {133, 77, 14}, {143, 80, 7}, {128, 63, 11},
 {96, 59, 24}, {100, 56, 31}, {125, 80, 40}, {142, 96, 59},
 {158, 112, 62}, {174, 133, 82}, {185, 158, 112}, {201, 192, 157},
 {196, 206, 208}, {197, 216, 223}, {202, 212, 223}, {198, 212, 215},
 {190, 198, 209}, {190, 188, 167}, {184, 158, 112}, {169, 129, 94},
 {155, 114, 77}, {146, 112, 78}, {142, 112, 78}, {142, 107, 75},
 {142, 107, 69}, {138, 104, 65}, {144, 98, 61}, {153, 107, 52},
 {166, 97, 11}, {174, 101, 5}, {186, 109, 5}, {190, 106, 5},
 {190, 102, 4}, {197, 41, 1}, {116, 33, 7}, {58, 32, 5},
},
/* gogh.entrance.ppm*/
{
 {2, 2, 1}, {6, 5, 8}, {5, 8, 7}, {8, 15, 8},
 {9, 21, 16}, {11, 26, 20}, {27, 49, 30}, {35, 65, 35},
 {54, 77, 47}, {69, 106, 52}, {94, 125, 64}, {124, 137, 81},
 {148, 157, 87}, {169, 182, 104}, {190, 193, 116}, {207, 207, 129},
 {219, 220, 140}, {219, 208, 142}, {217, 220, 140}, {215, 214, 126},
 {207, 199, 112}, {188, 169, 87}, {179, 142, 58}, {182, 132, 44},
 {185, 143, 29}, {198, 203, 65}, {220, 214, 99}, {231, 222, 117},
 {238, 228, 127}, {234, 229, 136}, {251, 245, 156}, {235, 235, 144},
 {240, 235, 151}, {244, 234, 151}, {241, 233, 149}, {239, 236, 136},
 {241, 230, 124}, {233, 232, 116}, {223, 216, 105}, {213, 204, 98},
 {179, 179, 91}, {136, 145, 60}, {93, 138, 53}, {74, 111, 58},
 {62, 113, 53}, {59, 102, 62}, {52, 94, 67}, {43, 94, 70},
 {45, 87, 61}, {39, 83, 56}, {38, 87, 54}, {62, 100, 47},
 {66, 108, 47}, {89, 112, 52}, {117, 127, 44}, {139, 139, 44},
 {139, 139, 50}, {131, 129, 42}, {102, 121, 60}, {80, 112, 58},
 {68, 94, 42}, {47, 88, 28}, {35, 68, 39}, {42, 56, 54},
 {45, 56, 61}, {41, 64, 72}, {37, 98, 69}, {40, 111, 80},
 {53, 139, 100}, {77, 133, 110}, {84, 136, 112}, {81, 122, 117},
 {77, 95, 121}, {71, 97, 103}, {59, 97, 100}, {54, 90, 90},
 {44, 80, 92}, {44, 71, 79}, {42, 80, 76}, {63, 93, 67},
 {88, 113, 66}, {129, 128, 58}, {155, 157, 69}, {177, 179, 99},
 {194, 197, 109}, {206, 201, 124}, {221, 216, 120}, {233, 236, 121},
 {240, 235, 118}, {231, 221, 104}, {221, 208, 98}, {200, 199, 94},
 {182, 172, 58}, {171, 136, 47}, {142, 133, 57}, {124, 108, 46},
 {81, 97, 48}, {77, 94, 46}, {89, 92, 52}, {125, 84, 42},
 {156, 99, 32}, {134, 106, 41}, {82, 99, 42}, {76, 92, 40},
 {65, 85, 37}, {36, 75, 45}, {23, 75, 49}, {33, 79, 47},
 {29, 90, 53}, {41, 104, 75}, {61, 112, 79}, {74, 134, 72},
 {109, 151, 93}, {145, 173, 124}, {174, 196, 161}, {186, 206, 175},
 {189, 207, 161}, {175, 188, 141}, {138, 168, 118}, {109, 132, 109},
 {73, 101, 101}, {55, 95, 82}, {46, 73, 57}, {20, 55, 43},
 {17, 36, 39}, {12, 37, 36}, {13, 28, 28}, {20, 25, 20},
 {21, 18, 23}, {11, 15, 28}, {30, 30, 17}, {22, 29, 26},
 {21, 28, 22}, {19, 42, 22}, {30, 37, 23}, {31, 38, 30},
 {25, 38, 31}, {24, 27, 34}, {25, 30, 48}, {31, 46, 62},
 {31, 55, 54}, {35, 63, 60}, {29, 76, 77}, {31, 78, 79},
 {36, 91, 82}, {45, 90, 99}, {49, 97, 111}, {64, 108, 108},
 {74, 122, 123}, {99, 143, 139}, {168, 173, 141}, {190, 209, 149},
 {204, 215, 159}, {209, 226, 160}, {209, 214, 153}, {197, 207, 132},
 {185, 180, 115}, {169, 158, 102}, {144, 149, 73}, {102, 133, 62},
 {73, 107, 58}, {54, 74, 55}, {42, 64, 52}, {31, 52, 44},
 {34, 45, 38}, {39, 47, 30}, {49, 51, 29}, {55, 52, 34},
 {44, 53, 45}, {55, 76, 60}, {81, 95, 78}, {105, 124, 100},
 {143, 165, 98}, {182, 200, 132}, {202, 214, 149}, {215, 220, 168},
 {230, 236, 165}, {231, 235, 181}, {216, 229, 170}, {207, 213, 174},
 {194, 210, 185}, {180, 219, 201}, {140, 198, 201}, {142, 188, 193},
 {159, 184, 158}, {110, 160, 143}, {82, 144, 137}, {89, 145, 113},
 {103, 137, 95}, {131, 146, 98}, {146, 151, 109}, {156, 157, 110},
 {196, 190, 134}, {207, 201, 144}, {208, 209, 154}, {208, 211, 148},
 {195, 201, 146}, {131, 157, 129}, {97, 132, 126}, {77, 126, 117},
 {49, 120, 108}, {58, 113, 88}, {65, 92, 76}, {73, 95, 66},
 {89, 94, 62}, {123, 96, 47}, {160, 100, 40}, {165, 107, 42},
 {143, 113, 58}, {107, 105, 61}, {88, 112, 70}, {83, 97, 66},
 {74, 81, 60}, {57, 84, 64}, {49, 90, 67}, {54, 100, 76},
 {60, 96, 84}, {67, 115, 90}, {98, 124, 91}, {105, 118, 89},
 {132, 135, 72}, {163, 134, 84}, {181, 167, 99}, {198, 191, 105},
 {210, 208, 116}, {212, 212, 112}, {219, 215, 108}, {219, 219, 115},
 {219, 221, 131}, {227, 218, 137}, {231, 228, 139}, {228, 228, 135},
 {226, 224, 134}, {233, 228, 134}, {236, 233, 129}, {237, 233, 133},
 {243, 233, 138}, {243, 230, 134}, {241, 232, 129}, {237, 230, 123},
 {226, 217, 108}, {213, 211, 99}, {193, 191, 89}, {163, 175, 74},
 {149, 155, 48}, {144, 152, 62}, {167, 155, 61}, {182, 173, 83},
 {186, 180, 104}, {190, 176, 100}, {178, 171, 89}, {168, 141, 62},
 {144, 137, 64}, {107, 111, 51}, {79, 86, 46}, {35, 31, 17},
},
/* gogh.the-night-cafe.ppm*/
{
 {56, 36, 25}, {72, 40, 16}, {76, 46, 26}, {96, 55, 31},
 {121, 71, 41}, {145, 88, 46}, {161, 90, 60}, {168, 109, 63},
 {168, 119, 83}, {169, 122, 86}, {162, 123, 79}, {139, 115, 75},
 {102, 115, 73}, {99, 123, 72}, {105, 132, 75}, {108, 137, 75},
 {133, 147, 94}, {146, 139, 137}, {179, 173, 130}, {198, 185, 140},
 {202, 187, 145}, {208, 180, 162}, {215, 187, 141}, {233, 188, 126},
 {234, 192, 124}, {212, 183, 114}, {214, 176, 101}, {222, 181, 93},
 {214, 174, 83}, {210, 165, 80}, {207, 161, 83}, {199, 155, 77},
 {197, 154, 74}, {194, 149, 67}, {190, 144, 62}, {187, 136, 62},
 {188, 133, 66}, {191, 122, 70}, {192, 129, 67}, {190, 137, 63},
 {194, 137, 62}, {196, 143, 64}, {195, 149, 70}, {200, 155, 70},
 {201, 162, 73}, {205, 165, 77}, {206, 162, 85}, {202, 160, 91},
 {193, 150, 96}, {183, 156, 98}, {182, 153, 106}, {179, 160, 112},
 {163, 157, 107}, {165, 147, 91}, {163, 143, 88}, {172, 137, 83},
 {180, 134, 79}, {181, 136, 77}, {179, 132, 67}, {175, 132, 72},
 {178, 131, 73}, {178, 124, 67}, {180, 134, 64}, {181, 131, 60},
 {188, 126, 59}, {181, 116, 63}, {168, 117, 60}, {173, 101, 61},
 {161, 88, 58}, {158, 80, 58}, {144, 83, 53}, {128, 81, 62},
 {112, 94, 57}, {98, 104, 62}, {90, 102, 66}, {89, 102, 71},
 {99, 93, 83}, {112, 100, 85}, {127, 103, 76}, {144, 107, 69},
 {152, 110, 69}, {150, 112, 63}, {155, 113, 63}, {162, 112, 60},
 {157, 110, 57}, {154, 109, 51}, {154, 101, 55}, {142, 91, 55},
 {118, 79, 54}, {107, 74, 48}, {105, 74, 45}, {103, 67, 36},
 {108, 52, 39}, {116, 56, 41}, {122, 53, 37}, {135, 60, 44},
 {149, 67, 41}, {155, 67, 45}, {163, 68, 48}, {170, 74, 50},
 {175, 81, 55}, {176, 98, 43}, {173, 109, 37}, {167, 112, 51},
 {176, 116, 48}, {170, 117, 57}, {170, 119, 61}, {170, 116, 55},
 {168, 123, 59}, {173, 129, 61}, {174, 124, 65}, {170, 120, 64},
 {156, 126, 59}, {157, 110, 61}, {158, 93, 69}, {140, 100, 55},
 {132, 91, 47}, {110, 76, 48}, {93, 79, 54}, {75, 63, 46},
 {74, 52, 43}, {70, 45, 43}, {65, 48, 41}, {72, 55, 41},
 {80, 57, 37}, {88, 61, 37}, {97, 66, 44}, {104, 66, 46},
 {113, 69, 45}, {125, 70, 43}, {137, 83, 48}, {149, 85, 42},
 {158, 82, 45}, {154, 90, 46}, {155, 79, 49}, {157, 81, 50},
 {161, 80, 48}, {165, 76, 55}, {165, 75, 56}, {160, 70, 49},
 {159, 70, 45}, {156, 74, 48}, {158, 72, 45}, {157, 68, 47},
 {163, 67, 46}, {161, 64, 45}, {157, 66, 47}, {162, 63, 44},
 {162, 58, 43}, {155, 59, 44}, {154, 67, 47}, {154, 76, 52},
 {147, 80, 55}, {134, 71, 58}, {123, 73, 49}, {115, 78, 57},
 {113, 78, 59}, {116, 89, 60}, {119, 91, 69}, {119, 92, 65},
 {123, 92, 58}, {129, 97, 52}, {146, 103, 57}, {152, 109, 61},
 {151, 113, 61}, {163, 114, 63}, {163, 124, 60}, {164, 122, 52},
 {172, 133, 52}, {166, 111, 58}, {170, 101, 53}, {168, 95, 51},
 {163, 91, 51}, {160, 91, 51}, {160, 92, 52}, {165, 97, 52},
 {165, 96, 45}, {171, 93, 49}, {176, 92, 50}, {180, 105, 51},
 {186, 112, 59}, {199, 121, 54}, {201, 141, 67}, {200, 146, 71},
 {205, 156, 72}, {207, 162, 76}, {208, 165, 77}, {212, 169, 86},
 {215, 170, 89}, {221, 174, 95}, {218, 172, 100}, {215, 172, 99},
 {209, 166, 89}, {206, 165, 83}, {206, 165, 82}, {196, 164, 86},
 {195, 162, 91}, {190, 160, 90}, {189, 154, 92}, {177, 149, 84},
 {180, 142, 81}, {172, 133, 70}, {152, 129, 77}, {109, 130, 76},
 {100, 127, 70}, {97, 123, 70}, {98, 118, 68}, {94, 116, 69},
 {90, 113, 68}, {87, 97, 55}, {88, 80, 63}, {92, 80, 57},
 {86, 75, 61}, {99, 73, 62}, {119, 83, 63}, {149, 98, 67},
 {160, 113, 66}, {171, 128, 69}, {176, 142, 76}, {190, 156, 75},
 {204, 170, 86}, {214, 175, 100}, {225, 179, 110}, {238, 201, 109},
 {239, 196, 98}, {225, 180, 89}, {224, 178, 82}, {218, 159, 77},
 {212, 158, 81}, {202, 155, 82}, {200, 151, 79}, {194, 149, 75},
 {188, 141, 69}, {188, 144, 69}, {177, 140, 68}, {188, 140, 66},
 {178, 147, 70}, {185, 141, 69}, {186, 136, 77}, {196, 138, 82},
 {200, 143, 106}, {211, 164, 103}, {215, 172, 106}, {208, 180, 132},
 {202, 174, 141}, {180, 169, 126}, {181, 163, 117}, {166, 141, 101},
 {175, 131, 101}, {149, 106, 85}, {123, 92, 70}, {99, 74, 55},
 {76, 55, 43}, {71, 47, 35}, {68, 34, 33}, {64, 45, 33},
},
/* gogh.vegetable-montmartre.ppm*/
{
 {40, 43, 29}, {44, 40, 28}, {66, 55, 30}, {91, 61, 30},
 {112, 65, 40}, {137, 82, 49}, {164, 102, 53}, {196, 118, 67},
 {220, 129, 69}, {227, 128, 77}, {232, 141, 72}, {221, 151, 83},
 {236, 161, 80}, {225, 161, 82}, {225, 163, 80}, {221, 168, 96},
 {221, 153, 88}, {233, 171, 96}, {210, 174, 105}, {227, 161, 98},
 {235, 172, 109}, {238, 179, 116}, {232, 176, 103}, {231, 186, 102},
 {227, 184, 110}, {210, 171, 118}, {190, 161, 102}, {178, 160, 101},
 {159, 156, 109}, {143, 154, 124}, {134, 149, 126}, {132, 146, 120},
 {127, 144, 118}, {131, 144, 118}, {144, 152, 114}, {144, 150, 104},
 {163, 143, 102}, {185, 147, 93}, {193, 154, 98}, {199, 155, 92},
 {198, 155, 90}, {193, 146, 87}, {192, 142, 90}, {185, 142, 87},
 {182, 141, 83}, {169, 139, 80}, {145, 132, 92}, {125, 148, 90},
 {127, 138, 106}, {123, 137, 121}, {120, 136, 121}, {116, 132, 118},
 {112, 134, 121}, {106, 134, 117}, {99, 122, 113}, {96, 119, 109},
 {91, 107, 99}, {87, 103, 102}, {89, 103, 86}, {95, 100, 77},
 {97, 96, 72}, {95, 90, 64}, {98, 89, 79}, {100, 95, 69},
 {117, 98, 64}, {109, 97, 72}, {104, 100, 72}, {115, 96, 71},
 {120, 99, 74}, {133, 110, 70}, {156, 123, 77}, {165, 139, 76},
 {177, 146, 79}, {194, 150, 88}, {210, 148, 87}, {213, 156, 85},
 {212, 158, 97}, {211, 160, 98}, {211, 161, 100}, {218, 168, 111},
 {222, 182, 114}, {236, 194, 126}, {232, 198, 125}, {224, 187, 122},
 {211, 183, 126}, {228, 198, 141}, {182, 189, 131}, {151, 169, 141},
 {144, 161, 134}, {134, 155, 137}, {129, 152, 136}, {127, 149, 136},
 {128, 148, 135}, {124, 145, 132}, {123, 145, 131}, {116, 142, 132},
 {111, 136, 131}, {108, 130, 128}, {107, 126, 122}, {99, 122, 111},
 {102, 105, 88}, {107, 112, 82}, {111, 107, 74}, {115, 106, 67},
 {123, 102, 60}, {151, 111, 62}, {162, 99, 57}, {161, 103, 76},
 {161, 115, 73}, {154, 121, 70}, {148, 125, 66}, {139, 123, 78},
 {143, 122, 88}, {148, 124, 84}, {135, 113, 77}, {127, 117, 76},
 {114, 111, 73}, {114, 111, 73}, {117, 106, 91}, {114, 110, 74},
 {111, 114, 83}, {104, 111, 97}, {99, 122, 112}, {98, 124, 119},
 {100, 127, 118}, {105, 128, 119}, {106, 129, 121}, {112, 132, 121},
 {114, 136, 127}, {111, 136, 130}, {112, 137, 131}, {117, 141, 128},
 {121, 147, 130}, {125, 145, 126}, {125, 141, 122}, {124, 141, 120},
 {129, 141, 111}, {154, 137, 98}, {166, 147, 94}, {187, 148, 90},
 {202, 147, 85}, {211, 141, 84}, {218, 142, 83}, {219, 149, 89},
 {227, 156, 96}, {222, 155, 94}, {210, 153, 97}, {204, 152, 96},
 {190, 148, 93}, {172, 149, 91}, {156, 147, 93}, {143, 149, 103},
 {137, 146, 106}, {128, 143, 114}, {125, 141, 115}, {125, 138, 112},
 {124, 131, 98}, {122, 123, 91}, {119, 120, 88}, {105, 115, 79},
 {103, 102, 69}, {95, 94, 61}, {84, 87, 62}, {82, 78, 54},
 {75, 75, 46}, {71, 69, 54}, {83, 76, 40}, {99, 68, 31},
 {101, 66, 33}, {95, 48, 18}, {107, 55, 26}, {105, 60, 35},
 {103, 57, 37}, {111, 56, 27}, {120, 40, 23}, {117, 60, 29},
 {118, 80, 46}, {141, 99, 57}, {149, 104, 54}, {150, 98, 54},
 {126, 88, 37}, {128, 68, 33}, {121, 73, 34}, {117, 65, 22},
 {133, 74, 34}, {158, 66, 35}, {168, 90, 53}, {169, 97, 49},
 {195, 102, 56}, {200, 110, 61}, {203, 118, 65}, {209, 124, 65},
 {196, 126, 55}, {181, 128, 57}, {174, 125, 72}, {171, 121, 70},
 {165, 114, 68}, {168, 100, 58}, {175, 105, 52}, {182, 110, 62},
 {178, 120, 72}, {188, 131, 73}, {197, 139, 79}, {197, 143, 79},
 {196, 155, 89}, {195, 163, 97}, {193, 159, 110}, {193, 173, 124},
 {185, 173, 134}, {154, 164, 134}, {150, 164, 131}, {148, 159, 133},
 {140, 157, 132}, {135, 149, 128}, {130, 152, 128}, {124, 146, 126},
 {121, 144, 124}, {118, 142, 125}, {116, 135, 118}, {119, 130, 102},
 {124, 131, 98}, {125, 128, 95}, {121, 120, 89}, {114, 109, 76},
 {114, 104, 70}, {101, 95, 59}, {103, 88, 59}, {85, 84, 48},
 {92, 75, 43}, {97, 79, 55}, {85, 85, 40}, {97, 74, 35},
 {103, 72, 40}, {98, 76, 42}, {103, 78, 45}, {101, 83, 47},
 {105, 88, 60}, {115, 95, 59}, {114, 99, 55}, {138, 112, 55},
 {151, 122, 65}, {171, 130, 69}, {175, 125, 74}, {195, 135, 72},
 {211, 143, 73}, {219, 137, 76}, {224, 140, 74}, {215, 144, 71},
 {198, 140, 76}, {186, 137, 70}, {173, 126, 68}, {167, 109, 50},
 {147, 102, 55}, {110, 85, 39}, {87, 62, 37}, {52, 51, 30},
},
/* matisse.bonheur-vivre.ppm*/
{
 {3, 3, 3}, {39, 31, 46}, {91, 59, 63}, {169, 125, 81},
 {206, 159, 105}, {208, 186, 115}, {204, 196, 101}, {223, 190, 85},
 {245, 207, 76}, {247, 210, 66}, {248, 210, 60}, {245, 197, 62},
 {222, 186, 74}, {207, 176, 85}, {191, 155, 108}, {161, 126, 102},
 {105, 111, 111}, {80, 98, 102}, {43, 82, 60}, {36, 61, 45},
 {23, 54, 40}, {18, 51, 42}, {32, 60, 38}, {53, 74, 51},
 {73, 98, 67}, {118, 135, 93}, {175, 161, 120}, {219, 165, 132},
 {226, 171, 140}, {226, 195, 154}, {228, 206, 139}, {241, 213, 115},
 {239, 208, 112}, {234, 199, 103}, {223, 189, 95}, {227, 161, 77},
 {220, 151, 71}, {205, 158, 48}, {202, 142, 41}, {184, 121, 37},
 {177, 116, 25}, {160, 107, 36}, {100, 116, 44}, {81, 66, 62},
 {66, 52, 60}, {75, 84, 83}, {79, 90, 108}, {94, 104, 112},
 {122, 120, 122}, {175, 163, 125}, {212, 176, 145}, {221, 190, 167},
 {225, 201, 166}, {232, 199, 158}, {230, 198, 147}, {228, 199, 107},
 {228, 208, 101}, {226, 206, 68}, {230, 203, 59}, {223, 197, 46},
 {243, 199, 23}, {232, 203, 40}, {217, 191, 46}, {218, 173, 35},
 {201, 178, 35}, {226, 186, 25}, {210, 168, 29}, {204, 176, 59},
 {217, 150, 36}, {188, 119, 21}, {216, 163, 19}, {220, 145, 9},
 {225, 159, 1}, {223, 157, 1}, {219, 135, 0}, {204, 134, 21},
 {204, 113, 2}, {193, 104, 2}, {195, 112, 0}, {186, 115, 18},
 {173, 117, 13}, {183, 104, 19}, {183, 118, 32}, {164, 155, 43},
 {142, 155, 66}, {97, 138, 69}, {47, 88, 61}, {48, 79, 51},
 {35, 74, 49}, {39, 72, 52}, {42, 77, 57}, {67, 86, 90},
 {90, 95, 101}, {142, 133, 104}, {168, 142, 94}, {187, 136, 104},
 {201, 135, 106}, {207, 138, 123}, {209, 140, 121}, {217, 151, 122},
 {217, 151, 127}, {222, 150, 126}, {219, 152, 134}, {222, 167, 136},
 {227, 170, 144}, {220, 174, 146}, {220, 183, 156}, {219, 176, 157},
 {192, 169, 155}, {138, 168, 128}, {104, 149, 108}, {65, 119, 86},
 {38, 87, 71}, {29, 70, 58}, {25, 59, 54}, {25, 69, 56},
 {29, 66, 56}, {43, 88, 64}, {73, 117, 88}, {118, 135, 93},
 {153, 142, 78}, {193, 146, 72}, {198, 145, 61}, {199, 162, 70},
 {196, 157, 53}, {219, 150, 47}, {222, 163, 48}, {217, 193, 59},
 {222, 201, 62}, {222, 189, 82}, {207, 180, 93}, {211, 185, 98},
 {205, 179, 100}, {190, 161, 97}, {169, 154, 85}, {117, 158, 94},
 {82, 131, 102}, {75, 121, 93}, {78, 119, 94}, {88, 121, 90},
 {131, 102, 87}, {162, 105, 38}, {160, 101, 33}, {163, 104, 28},
 {166, 88, 30}, {176, 78, 3}, {169, 71, 3}, {166, 43, 1},
 {159, 15, 8}, {154, 8, 8}, {165, 6, 3}, {160, 3, 0},
 {149, 1, 0}, {148, 9, 3}, {50, 11, 10}, {48, 29, 12},
 {46, 24, 27}, {48, 39, 33}, {82, 70, 32}, {155, 103, 30},
 {172, 119, 46}, {184, 130, 54}, {210, 156, 69}, {227, 161, 91},
 {220, 169, 110}, {224, 155, 107}, {210, 131, 104}, {184, 106, 94},
 {170, 101, 86}, {166, 91, 81}, {156, 96, 85}, {88, 111, 82},
 {76, 123, 90}, {62, 119, 86}, {54, 116, 91}, {66, 123, 102},
 {86, 142, 116}, {126, 158, 123}, {163, 165, 118}, {209, 168, 119},
 {222, 178, 144}, {225, 200, 163}, {226, 212, 162}, {221, 201, 167},
 {225, 209, 170}, {215, 213, 188}, {234, 206, 190}, {224, 210, 171},
 {227, 201, 174}, {223, 203, 178}, {225, 181, 170}, {218, 163, 147},
 {196, 142, 130}, {181, 132, 97}, {180, 111, 63}, {198, 93, 35},
 {200, 101, 3}, {213, 103, 26}, {208, 94, 4}, {209, 84, 8},
 {210, 67, 1}, {195, 66, 1}, {194, 74, 2}, {181, 70, 0},
 {188, 65, 1}, {189, 53, 4}, {184, 50, 1}, {179, 53, 3},
 {170, 41, 4}, {174, 13, 6}, {176, 13, 3}, {178, 48, 5},
 {166, 64, 52}, {197, 90, 56}, {188, 99, 80}, {209, 104, 96},
 {222, 122, 92}, {206, 131, 112}, {206, 151, 120}, {199, 161, 131},
 {173, 180, 138}, {136, 179, 145}, {98, 156, 130}, {83, 147, 117},
 {70, 134, 107}, {85, 132, 106}, {110, 144, 103}, {162, 140, 88},
 {178, 118, 84}, {192, 122, 93}, {204, 122, 113}, {203, 126, 119},
 {196, 137, 118}, {191, 131, 113}, {182, 130, 107}, {161, 153, 120},
 {104, 145, 109}, {78, 128, 103}, {53, 112, 87}, {35, 102, 80},
 {40, 96, 71}, {52, 103, 75}, {97, 137, 79}, {138, 159, 67},
 {187, 173, 64}, {192, 177, 59}, {210, 190, 61}, {219, 183, 91},
 {224, 196, 104}, {221, 205, 139}, {225, 202, 155}, {209, 201, 152},
 {156, 176, 144}, {115, 120, 128}, {69, 87, 96}, {27, 58, 48},
},
/* matisse.flowers.ppm*/
{
 {13, 10, 17}, {66, 30, 14}, {140, 53, 34}, {165, 44, 33},
 {205, 94, 45}, {177, 121, 75}, {182, 159, 89}, {185, 175, 117},
 {209, 186, 130}, {203, 189, 140}, {208, 192, 141}, {214, 198, 142},
 {220, 201, 150}, {221, 204, 151}, {222, 202, 151}, {220, 198, 141},
 {216, 197, 135}, {220, 203, 142}, {216, 203, 156}, {224, 207, 168},
 {227, 206, 168}, {227, 212, 168}, {230, 217, 173}, {232, 217, 181},
 {235, 218, 193}, {241, 213, 200}, {235, 218, 199}, {233, 218, 198},
 {231, 217, 185}, {231, 219, 176}, {228, 213, 170}, {221, 208, 170},
 {211, 204, 178}, {206, 203, 188}, {209, 205, 191}, {214, 205, 197},
 {211, 207, 198}, {200, 201, 195}, {199, 199, 187}, {198, 197, 178},
 {203, 198, 167}, {206, 197, 164}, {213, 202, 163}, {216, 202, 164},
 {218, 196, 160}, {224, 191, 153}, {225, 189, 141}, {215, 194, 130},
 {217, 191, 115}, {220, 197, 104}, {221, 188, 104}, {217, 163, 87},
 {215, 161, 51}, {211, 172, 50}, {213, 174, 59}, {206, 166, 88},
 {214, 164, 87}, {208, 153, 87}, {197, 121, 93}, {209, 82, 39},
 {193, 21, 8}, {168, 38, 20}, {170, 75, 61}, {151, 127, 95},
 {154, 165, 148}, {180, 188, 174}, {184, 187, 172}, {181, 187, 175},
 {178, 184, 177}, {157, 178, 184}, {152, 175, 182}, {133, 172, 173},
 {130, 171, 159}, {139, 171, 165}, {156, 177, 183}, {175, 187, 185},
 {180, 189, 190}, {182, 189, 183}, {189, 190, 174}, {190, 192, 168},
 {202, 194, 160}, {206, 197, 153}, {212, 201, 158}, {218, 202, 169},
 {225, 209, 179}, {226, 216, 183}, {237, 222, 193}, {236, 222, 200},
 {235, 223, 207}, {235, 221, 210}, {236, 222, 213}, {233, 223, 214},
 {234, 219, 215}, {234, 221, 214}, {233, 220, 212}, {234, 221, 214},
 {237, 222, 217}, {239, 226, 216}, {239, 233, 216}, {239, 230, 221},
 {239, 229, 219}, {237, 228, 214}, {233, 222, 211}, {231, 221, 208},
 {230, 223, 204}, {232, 216, 201}, {222, 215, 187}, {207, 205, 185},
 {199, 200, 185}, {195, 197, 184}, {195, 196, 182}, {194, 195, 178},
 {186, 190, 176}, {180, 184, 177}, {158, 174, 178}, {143, 172, 156},
 {116, 159, 149}, {72, 103, 96}, {55, 76, 65}, {21, 42, 44},
 {41, 38, 37}, {70, 59, 35}, {149, 106, 97}, {175, 131, 93},
 {213, 180, 99}, {219, 188, 113}, {221, 195, 117}, {227, 204, 124},
 {226, 206, 143}, {233, 198, 151}, {229, 211, 163}, {230, 215, 178},
 {233, 216, 200}, {220, 218, 206}, {211, 211, 204}, {195, 198, 199},
 {185, 197, 189}, {187, 189, 187}, {188, 182, 188}, {181, 177, 182},
 {175, 178, 176}, {161, 175, 162}, {163, 141, 151}, {176, 112, 118},
 {141, 99, 109}, {82, 80, 53}, {53, 51, 40}, {36, 40, 51},
 {60, 73, 63}, {78, 111, 97}, {131, 161, 125}, {154, 178, 154},
 {156, 181, 179}, {157, 182, 187}, {164, 192, 197}, {180, 188, 197},
 {192, 194, 200}, {200, 200, 198}, {209, 208, 199}, {215, 214, 202},
 {213, 218, 201}, {212, 215, 205}, {205, 207, 204}, {198, 198, 204},
 {192, 196, 199}, {180, 193, 193}, {176, 186, 192}, {174, 184, 189},
 {158, 181, 187}, {151, 175, 178}, {135, 169, 158}, {116, 156, 147},
 {57, 83, 86}, {56, 31, 32}, {70, 28, 19}, {121, 56, 46},
 {155, 75, 65}, {178, 106, 114}, {193, 133, 101}, {182, 171, 116},
 {165, 167, 140}, {188, 139, 142}, {184, 123, 127}, {186, 114, 117},
 {197, 146, 111}, {208, 168, 141}, {221, 184, 171}, {208, 198, 181},
 {213, 206, 191}, {223, 209, 195}, {232, 216, 201}, {232, 216, 207},
 {231, 217, 208}, {232, 220, 213}, {226, 220, 215}, {219, 217, 209},
 {217, 218, 209}, {216, 209, 208}, {202, 202, 202}, {192, 197, 195},
 {193, 195, 186}, {192, 193, 185}, {193, 195, 182}, {194, 198, 191},
 {205, 206, 200}, {217, 210, 195}, {231, 215, 202}, {231, 218, 204},
 {235, 220, 205}, {236, 220, 204}, {234, 221, 205}, {232, 221, 205},
 {231, 217, 207}, {231, 214, 204}, {225, 207, 196}, {214, 200, 192},
 {205, 191, 187}, {204, 169, 169}, {206, 173, 167}, {200, 193, 175},
 {195, 196, 180}, {194, 198, 186}, {198, 200, 196}, {215, 201, 202},
 {229, 214, 207}, {231, 217, 208}, {233, 219, 209}, {234, 223, 211},
 {238, 227, 211}, {240, 229, 207}, {240, 227, 208}, {239, 226, 209},
 {237, 224, 208}, {236, 220, 205}, {235, 215, 204}, {227, 211, 197},
 {214, 208, 193}, {197, 197, 184}, {188, 189, 172}, {169, 180, 160},
 {149, 169, 137}, {115, 136, 85}, {73, 66, 39}, {51, 31, 30},
 {35, 32, 12}, {33, 28, 14}, {38, 41, 33}, {63, 55, 40},
 {77, 100, 78}, {129, 155, 131}, {123, 162, 151}, {129, 165, 159},
 {135, 167, 158}, {138, 150, 139}, {124, 121, 135}, {56, 54, 65},
},
/* matisse.lecon-musique.ppm*/
{
 {17, 24, 13}, {25, 50, 37}, {51, 60, 57}, {56, 70, 71},
 {50, 108, 84}, {60, 120, 101}, {78, 109, 104}, {91, 110, 128},
 {119, 123, 103}, {131, 141, 108}, {139, 147, 107}, {140, 144, 102},
 {129, 130, 88}, {129, 120, 90}, {142, 119, 69}, {162, 122, 56},
 {171, 127, 64}, {179, 127, 69}, {148, 107, 66}, {133, 103, 70},
 {107, 101, 68}, {92, 116, 55}, {83, 102, 62}, {78, 127, 54},
 {69, 132, 63}, {77, 137, 76}, {85, 144, 72}, {89, 154, 81},
 {103, 161, 72}, {98, 163, 76}, {101, 156, 80}, {98, 164, 114},
 {107, 177, 79}, {106, 162, 118}, {120, 164, 114}, {128, 150, 134},
 {129, 160, 141}, {138, 163, 154}, {140, 170, 157}, {142, 170, 160},
 {129, 167, 170}, {152, 180, 168}, {160, 179, 158}, {173, 190, 157},
 {172, 193, 172}, {173, 201, 181}, {183, 205, 191}, {180, 198, 192},
 {187, 202, 204}, {191, 202, 196}, {206, 209, 188}, {211, 213, 196},
 {209, 214, 190}, {211, 208, 189}, {200, 201, 185}, {197, 199, 182},
 {204, 198, 162}, {196, 190, 159}, {190, 192, 136}, {179, 190, 122},
 {181, 178, 114}, {184, 163, 122}, {175, 156, 120}, {172, 156, 120},
 {171, 156, 126}, {147, 146, 127}, {132, 151, 135}, {141, 158, 139},
 {153, 154, 141}, {154, 149, 131}, {148, 158, 114}, {150, 150, 113},
 {136, 142, 113}, {128, 122, 96}, {122, 119, 98}, {114, 121, 95},
 {113, 117, 90}, {106, 107, 82}, {112, 94, 85}, {130, 95, 87},
 {150, 92, 81}, {167, 91, 92}, {180, 78, 72}, {181, 74, 75},
 {185, 69, 75}, {182, 67, 62}, {194, 85, 50}, {196, 122, 30},
 {221, 159, 7}, {226, 161, 6}, {220, 163, 6}, {234, 187, 37},
 {190, 132, 59}, {207, 156, 59}, {186, 128, 40}, {187, 130, 19},
 {188, 129, 36}, {186, 115, 28}, {162, 108, 32}, {154, 110, 45},
 {115, 91, 48}, {98, 100, 65}, {93, 97, 62}, {90, 93, 64},
 {70, 81, 63}, {71, 74, 57}, {75, 78, 50}, {96, 74, 40},
 {107, 80, 43}, {150, 81, 55}, {178, 92, 50}, {189, 88, 80},
 {186, 105, 102}, {175, 138, 121}, {195, 151, 124}, {205, 153, 135},
 {187, 179, 141}, {191, 210, 162}, {209, 223, 182}, {228, 234, 208},
 {228, 225, 208}, {219, 221, 207}, {210, 212, 197}, {206, 206, 195},
 {188, 198, 189}, {188, 194, 178}, {183, 187, 160}, {183, 191, 155},
 {186, 186, 144}, {185, 176, 141}, {191, 175, 136}, {191, 163, 124},
 {168, 170, 111}, {155, 184, 107}, {145, 177, 97}, {120, 168, 75},
 {113, 149, 78}, {117, 161, 80}, {121, 171, 82}, {134, 178, 96},
 {152, 190, 111}, {145, 194, 131}, {150, 180, 133}, {164, 179, 132},
 {167, 177, 128}, {178, 176, 139}, {169, 166, 132}, {162, 157, 129},
 {156, 146, 119}, {154, 146, 118}, {154, 131, 117}, {150, 109, 103},
 {171, 93, 90}, {185, 102, 92}, {197, 102, 96}, {193, 104, 95},
 {183, 84, 82}, {173, 71, 64}, {173, 65, 63}, {160, 58, 43},
 {157, 48, 38}, {120, 4, 5}, {38, 30, 9}, {32, 26, 12},
 {31, 25, 14}, {47, 48, 28}, {63, 52, 26}, {94, 63, 20},
 {99, 66, 22}, {115, 88, 28}, {121, 98, 33}, {158, 111, 48},
 {176, 129, 61}, {185, 121, 30}, {192, 148, 29}, {173, 124, 34},
 {192, 107, 2}, {192, 98, 3}, {185, 91, 2}, {161, 89, 9},
 {158, 89, 22}, {154, 96, 32}, {122, 86, 46}, {113, 85, 37},
 {107, 94, 41}, {88, 83, 60}, {75, 80, 50}, {68, 80, 54},
 {65, 78, 58}, {63, 71, 53}, {59, 66, 40}, {58, 51, 40},
 {60, 68, 37}, {49, 55, 37}, {63, 65, 37}, {62, 64, 42},
 {66, 73, 52}, {70, 80, 58}, {80, 90, 74}, {80, 95, 84},
 {85, 93, 71}, {94, 101, 70}, {98, 98, 67}, {96, 100, 77},
 {103, 111, 82}, {104, 115, 95}, {111, 112, 91}, {104, 109, 87},
 {93, 113, 83}, {76, 110, 84}, {67, 93, 94}, {69, 85, 89},
 {75, 90, 74}, {78, 81, 64}, {72, 75, 57}, {70, 73, 56},
 {68, 71, 50}, {92, 72, 33}, {108, 59, 21}, {138, 77, 13},
 {161, 80, 5}, {160, 65, 0}, {154, 54, 0}, {138, 34, 2},
 {55, 42, 5}, {20, 14, 6}, {14, 9, 4}, {24, 25, 12},
 {33, 39, 30}, {45, 45, 35}, {45, 48, 40}, {51, 62, 49},
 {60, 74, 55}, {63, 77, 63}, {59, 103, 64}, {75, 128, 70},
 {89, 149, 79}, {96, 157, 105}, {101, 175, 137}, {123, 187, 147},
 {124, 194, 146}, {137, 189, 144}, {110, 177, 136}, {115, 181, 127},
 {112, 176, 129}, {119, 162, 149}, {91, 170, 136}, {84, 152, 119},
 {67, 152, 116}, {52, 140, 116}, {49, 141, 121}, {46, 134, 117},
 {28, 119, 107}, {42, 88, 69}, {47, 75, 61}, {33, 50, 45},
},
/* modigliani.nude-caryatid.ppm*/
{
 {31, 24, 17}, {57, 47, 38}, {89, 77, 61}, {119, 88, 86},
 {151, 108, 104}, {173, 128, 129}, {184, 141, 152}, {196, 148, 160},
 {197, 156, 158}, {201, 164, 169}, {199, 171, 174}, {200, 176, 179},
 {203, 178, 181}, {203, 179, 182}, {203, 178, 185}, {201, 178, 183},
 {202, 177, 186}, {198, 178, 184}, {195, 179, 178}, {203, 173, 173},
 {202, 169, 169}, {204, 167, 163}, {199, 155, 155}, {200, 158, 151},
 {203, 157, 147}, {199, 157, 148}, {196, 152, 139}, {202, 144, 123},
 {200, 142, 123}, {190, 130, 119}, {175, 111, 102}, {175, 92, 77},
 {168, 91, 81}, {158, 87, 83}, {139, 73, 72}, {133, 71, 62},
 {114, 57, 55}, {86, 51, 50}, {50, 34, 32}, {40, 32, 30},
 {33, 31, 33}, {33, 31, 34}, {40, 35, 34}, {57, 53, 43},
 {82, 70, 66}, {108, 84, 89}, {130, 107, 112}, {170, 134, 135},
 {184, 142, 145}, {191, 151, 145}, {189, 151, 150}, {181, 147, 146},
 {172, 155, 132}, {169, 153, 130}, {168, 152, 129}, {168, 151, 129},
 {167, 149, 127}, {149, 128, 113}, {142, 120, 97}, {140, 108, 87},
 {127, 105, 84}, {127, 85, 80}, {118, 77, 78}, {115, 76, 80},
 {112, 80, 74}, {96, 77, 60}, {72, 57, 48}, {44, 38, 36},
 {38, 29, 34}, {35, 29, 31}, {37, 31, 27}, {41, 33, 31},
 {48, 40, 38}, {86, 56, 51}, {116, 79, 74}, {125, 95, 94},
 {153, 110, 106}, {176, 122, 127}, {185, 135, 135}, {194, 143, 142},
 {195, 145, 143}, {190, 145, 134}, {179, 129, 122}, {164, 119, 119},
 {156, 111, 108}, {140, 106, 101}, {128, 103, 98}, {124, 106, 103},
 {125, 97, 95}, {145, 92, 89}, {156, 93, 87}, {157, 92, 91},
 {164, 100, 96}, {165, 109, 111}, {182, 123, 125}, {181, 124, 126},
 {180, 134, 130}, {169, 149, 128}, {169, 151, 129}, {171, 155, 130},
 {193, 151, 139}, {201, 154, 150}, {204, 156, 152}, {212, 163, 163},
 {210, 166, 162}, {216, 175, 169}, {225, 188, 179}, {218, 185, 188},
 {217, 192, 196}, {224, 195, 196}, {224, 195, 200}, {225, 205, 209},
 {229, 209, 212}, {226, 208, 211}, {218, 203, 212}, {217, 194, 200},
 {215, 196, 199}, {214, 191, 194}, {218, 185, 183}, {215, 183, 181},
 {214, 175, 173}, {206, 167, 164}, {197, 159, 160}, {193, 154, 153},
 {177, 150, 148}, {170, 154, 132}, {168, 149, 127}, {160, 139, 111},
 {152, 126, 103}, {152, 128, 104}, {161, 142, 118}, {168, 150, 129},
 {174, 156, 134}, {190, 157, 148}, {196, 159, 161}, {196, 164, 172},
 {196, 174, 181}, {198, 176, 183}, {202, 180, 182}, {206, 180, 180},
 {210, 178, 180}, {214, 187, 183}, {209, 188, 189}, {208, 184, 193},
 {211, 189, 191}, {215, 194, 193}, {212, 196, 197}, {207, 191, 199},
 {194, 189, 194}, {177, 176, 180}, {173, 159, 165}, {173, 149, 155},
 {170, 149, 154}, {167, 136, 146}, {161, 125, 128}, {146, 109, 113},
 {132, 98, 92}, {128, 80, 81}, {133, 77, 80}, {148, 92, 92},
 {156, 102, 99}, {165, 117, 113}, {174, 131, 128}, {187, 143, 140},
 {181, 142, 139}, {168, 122, 122}, {144, 108, 104}, {121, 92, 94},
 {107, 83, 81}, {74, 63, 54}, {45, 43, 41}, {41, 32, 31},
 {37, 28, 26}, {33, 25, 25}, {35, 25, 24}, {38, 28, 27},
 {58, 40, 24}, {76, 54, 40}, {109, 68, 56}, {104, 65, 44},
 {67, 53, 40}, {42, 34, 32}, {36, 27, 28}, {32, 23, 27},
 {29, 20, 23}, {30, 20, 21}, {31, 21, 20}, {29, 20, 19},
 {21, 15, 15}, {15, 11, 12}, {15, 10, 11}, {18, 7, 9},
 {18, 12, 12}, {21, 12, 14}, {21, 12, 15}, {21, 15, 17},
 {25, 20, 21}, {29, 23, 24}, {30, 24, 27}, {31, 24, 27},
 {34, 25, 26}, {40, 35, 33}, {51, 49, 46}, {68, 72, 61},
 {105, 99, 94}, {123, 109, 116}, {144, 118, 116}, {157, 149, 136},
 {166, 150, 125}, {154, 134, 102}, {151, 127, 103}, {147, 123, 99},
 {143, 118, 96}, {153, 104, 100}, {160, 107, 104}, {166, 115, 103},
 {181, 121, 112}, {187, 119, 112}, {177, 123, 111}, {155, 112, 108},
 {142, 119, 97}, {138, 122, 97}, {126, 106, 85}, {118, 99, 81},
 {103, 80, 60}, {80, 60, 48}, {53, 45, 37}, {42, 34, 32},
 {41, 33, 31}, {43, 38, 35}, {66, 57, 53}, {90, 71, 73},
 {116, 80, 81}, {135, 101, 104}, {152, 117, 118}, {168, 139, 142},
 {164, 153, 155}, {153, 157, 168}, {147, 158, 172}, {170, 152, 159},
 {187, 158, 166}, {186, 163, 166}, {188, 164, 163}, {192, 168, 167},
 {201, 167, 164}, {204, 168, 168}, {202, 166, 167}, {198, 163, 166},
 {190, 161, 162}, {185, 154, 157}, {187, 149, 152}, {182, 147, 147},
 {166, 135, 138}, {139, 114, 121}, {104, 92, 88}, {69, 62, 55},
},
/* braque.instruments.ppm*/
{
 {13, 9, 4}, {22, 18, 10}, {35, 31, 20}, {48, 42, 14},
 {56, 45, 7}, {68, 57, 11}, {83, 66, 15}, {101, 82, 18},
 {117, 89, 15}, {116, 87, 19}, {103, 83, 16}, {88, 94, 25},
 {72, 92, 33}, {64, 83, 25}, {58, 79, 20}, {57, 68, 18},
 {54, 66, 15}, {62, 69, 15}, {65, 73, 13}, {70, 68, 11},
 {78, 62, 12}, {87, 61, 11}, {103, 68, 11}, {111, 70, 20},
 {128, 81, 12}, {132, 87, 23}, {139, 85, 22}, {134, 107, 24},
 {138, 115, 30}, {146, 118, 44}, {157, 130, 56}, {165, 139, 63},
 {161, 145, 82}, {170, 164, 114}, {186, 177, 126}, {195, 185, 128},
 {210, 200, 137}, {220, 213, 139}, {234, 213, 133}, {240, 213, 133},
 {239, 220, 145}, {249, 227, 147}, {249, 227, 153}, {250, 231, 160},
 {244, 227, 162}, {247, 232, 165}, {249, 242, 188}, {245, 242, 171},
 {255, 252, 190}, {251, 241, 168}, {247, 241, 181}, {241, 231, 170},
 {237, 229, 166}, {222, 217, 161}, {212, 205, 159}, {208, 202, 146},
 {205, 192, 123}, {196, 174, 99}, {178, 150, 78}, {168, 140, 66},
 {150, 126, 52}, {131, 117, 43}, {127, 95, 33}, {120, 96, 34},
 {106, 95, 41}, {95, 90, 45}, {93, 87, 50}, {93, 91, 54},
 {97, 86, 62}, {118, 109, 80}, {146, 132, 93}, {169, 161, 125},
 {189, 183, 135}, {207, 197, 145}, {213, 206, 148}, {221, 206, 139},
 {223, 203, 137}, {223, 202, 137}, {225, 204, 134}, {226, 207, 130},
 {234, 207, 127}, {222, 203, 126}, {216, 188, 114}, {210, 179, 98},
 {223, 172, 46}, {217, 171, 46}, {211, 166, 46}, {208, 159, 29},
 {202, 145, 22}, {199, 153, 33}, {196, 161, 62}, {203, 179, 91},
 {211, 192, 115}, {213, 197, 127}, {220, 204, 130}, {221, 208, 129},
 {221, 201, 130}, {212, 196, 124}, {200, 179, 113}, {194, 174, 96},
 {175, 154, 83}, {166, 146, 72}, {167, 147, 76}, {180, 156, 90},
 {203, 177, 110}, {211, 192, 115}, {213, 198, 116}, {218, 199, 122},
 {209, 191, 107}, {193, 167, 77}, {206, 159, 42}, {194, 146, 32},
 {193, 141, 20}, {186, 135, 10}, {179, 141, 16}, {179, 143, 8},
 {153, 120, 7}, {147, 110, 20}, {128, 110, 25}, {118, 103, 37},
 {115, 107, 38}, {110, 122, 46}, {117, 120, 64}, {132, 129, 74},
 {140, 133, 89}, {145, 133, 85}, {135, 128, 80}, {136, 112, 67},
 {139, 116, 53}, {138, 118, 31}, {136, 109, 27}, {133, 101, 14},
 {135, 92, 4}, {130, 80, 2}, {123, 74, 6}, {111, 73, 1},
 {93, 67, 4}, {80, 63, 8}, {79, 61, 14}, {82, 70, 22},
 {89, 93, 19}, {106, 100, 28}, {119, 103, 39}, {139, 125, 42},
 {159, 138, 59}, {176, 148, 84}, {188, 162, 110}, {207, 184, 130},
 {215, 196, 131}, {219, 193, 137}, {208, 187, 126}, {201, 174, 109},
 {177, 158, 83}, {179, 154, 61}, {173, 137, 39}, {177, 139, 26},
 {177, 145, 20}, {150, 115, 11}, {139, 108, 7}, {130, 101, 9},
 {114, 76, 5}, {103, 67, 8}, {100, 55, 5}, {82, 59, 8},
 {82, 58, 17}, {71, 64, 22}, {66, 74, 18}, {60, 73, 22},
 {60, 73, 28}, {68, 85, 27}, {79, 88, 33}, {87, 97, 37},
 {90, 107, 37}, {96, 97, 58}, {120, 113, 63}, {137, 121, 57},
 {159, 131, 57}, {171, 144, 64}, {165, 147, 63}, {161, 136, 48},
 {162, 125, 34}, {154, 122, 42}, {145, 113, 29}, {127, 102, 11},
 {110, 93, 3}, {87, 87, 1}, {83, 59, 0}, {79, 56, 5},
 {81, 53, 6}, {71, 45, 6}, {61, 36, 2}, {60, 34, 1},
 {54, 31, 5}, {51, 24, 3}, {46, 19, 0}, {39, 15, 4},
 {34, 16, 2}, {33, 15, 4}, {36, 13, 5}, {39, 16, 3},
 {37, 29, 3}, {38, 27, 8}, {38, 27, 8}, {44, 20, 9},
 {56, 28, 6}, {57, 26, 2}, {61, 25, 2}, {65, 29, 4},
 {58, 30, 9}, {65, 38, 10}, {66, 45, 13}, {73, 47, 10},
 {70, 54, 8}, {70, 55, 6}, {56, 59, 6}, {48, 61, 14},
 {48, 55, 7}, {43, 55, 5}, {48, 55, 14}, {45, 68, 8},
 {48, 85, 20}, {56, 86, 24}, {60, 81, 22}, {57, 81, 25},
 {55, 82, 40}, {71, 74, 51}, {89, 75, 46}, {90, 82, 53},
 {102, 82, 64}, {120, 106, 81}, {130, 123, 78}, {142, 137, 81},
 {163, 153, 92}, {178, 167, 112}, {186, 175, 120}, {180, 168, 120},
 {164, 154, 93}, {147, 144, 74}, {134, 132, 71}, {130, 115, 66},
 {120, 108, 60}, {109, 98, 44}, {110, 87, 29}, {128, 87, 22},
 {122, 82, 10}, {110, 77, 10}, {100, 65, 5}, {91, 55, 2},
 {81, 54, 3}, {76, 54, 7}, {64, 50, 9}, {44, 52, 13},
 {35, 42, 8}, {35, 41, 8}, {29, 26, 9}, {24, 12, 1},
},
/* calcoast09.ppm*/
{
 {32, 32, 44}, {52, 56, 66}, {68, 71, 89}, {76, 94, 103},
 {82, 116, 122}, {83, 114, 143}, {90, 123, 154}, {94, 127, 158},
 {96, 130, 161}, {99, 134, 164}, {99, 135, 167}, {101, 136, 168},
 {103, 138, 170}, {103, 139, 171}, {103, 139, 173}, {103, 139, 174},
 {103, 139, 175}, {104, 140, 174}, {106, 142, 176}, {108, 143, 175},
 {108, 143, 176}, {109, 144, 176}, {108, 143, 174}, {106, 141, 172},
 {103, 139, 173}, {102, 138, 172}, {100, 136, 170}, {98, 134, 170},
 {98, 133, 168}, {97, 131, 166}, {95, 129, 164}, {95, 128, 159},
 {95, 128, 156}, {94, 126, 153}, {92, 127, 145}, {82, 118, 140},
 {76, 115, 122}, {69, 100, 107}, {70, 89, 94}, {61, 84, 91},
 {64, 76, 88}, {71, 75, 78}, {70, 72, 68}, {65, 73, 73},
 {66, 65, 73}, {56, 62, 74}, {55, 59, 71}, {54, 59, 69},
 {50, 55, 64}, {41, 45, 58}, {42, 41, 53}, {44, 44, 53},
 {46, 44, 58}, {48, 50, 55}, {58, 56, 56}, {57, 64, 65},
 {72, 68, 63}, {81, 77, 64}, {96, 82, 62}, {103, 93, 73},
 {100, 92, 78}, {92, 89, 71}, {88, 88, 71}, {89, 84, 73},
 {87, 87, 77}, {94, 94, 84}, {99, 101, 89}, {99, 107, 99},
 {96, 110, 119}, {85, 113, 143}, {85, 115, 149}, {91, 124, 155},
 {96, 129, 160}, {100, 135, 165}, {106, 139, 170}, {108, 143, 172},
 {119, 146, 156}, {127, 149, 160}, {148, 165, 157}, {165, 188, 190},
 {179, 191, 172}, {184, 189, 154}, {190, 194, 149}, {174, 155, 104},
 {147, 131, 96}, {144, 138, 108}, {137, 135, 107}, {138, 130, 112},
 {145, 142, 115}, {132, 137, 131}, {114, 128, 136}, {101, 130, 142},
 {102, 130, 157}, {96, 129, 162}, {96, 130, 165}, {98, 131, 166},
 {99, 133, 168}, {99, 134, 169}, {100, 134, 169}, {100, 136, 169},
 {100, 134, 169}, {100, 134, 169}, {99, 134, 166}, {96, 129, 164},
 {94, 127, 160}, {92, 124, 157}, {90, 123, 154}, {84, 114, 147},
 {81, 109, 139}, {75, 101, 129}, {62, 91, 119}, {59, 89, 105},
 {55, 88, 99}, {55, 87, 98}, {57, 82, 112}, {58, 81, 115},
 {63, 87, 120}, {67, 93, 126}, {74, 100, 133}, {77, 106, 138},
 {81, 110, 143}, {80, 110, 144}, {78, 107, 141}, {75, 101, 134},
 {68, 94, 127}, {62, 88, 121}, {64, 90, 120}, {73, 98, 128},
 {75, 104, 136}, {79, 110, 140}, {81, 111, 144}, {82, 112, 146},
 {82, 111, 142}, {77, 105, 135}, {79, 108, 117}, {81, 98, 115},
 {87, 96, 103}, {91, 95, 97}, {94, 91, 91}, {101, 102, 94},
 {117, 116, 100}, {125, 128, 107}, {118, 134, 131}, {122, 145, 148},
 {130, 166, 167}, {140, 176, 186}, {156, 193, 200}, {163, 204, 212},
 {167, 213, 212}, {169, 207, 215}, {168, 207, 211}, {157, 199, 205},
 {137, 175, 189}, {130, 166, 174}, {118, 152, 164}, {118, 153, 157},
 {118, 158, 160}, {123, 164, 166}, {136, 177, 177}, {146, 191, 197},
 {162, 197, 198}, {166, 201, 203}, {161, 200, 203}, {153, 189, 200},
 {137, 175, 185}, {121, 163, 167}, {108, 147, 151}, {106, 141, 153},
 {98, 131, 161}, {96, 131, 161}, {100, 136, 155}, {111, 132, 145},
 {112, 134, 144}, {105, 134, 138}, {101, 134, 138}, {105, 130, 141},
 {109, 117, 128}, {110, 115, 107}, {104, 107, 95}, {113, 111, 88},
 {119, 112, 92}, {126, 124, 103}, {121, 116, 103}, {119, 117, 90},
 {117, 112, 85}, {112, 102, 82}, {95, 95, 81}, {86, 86, 80},
 {80, 84, 83}, {81, 92, 101}, {85, 112, 122}, {94, 127, 132},
 {106, 140, 143}, {116, 162, 160}, {142, 183, 185}, {184, 201, 205},
 {189, 224, 229}, {214, 248, 247}, {224, 251, 250}, {201, 232, 240},
 {187, 218, 222}, {170, 194, 203}, {138, 175, 176}, {115, 153, 162},
 {101, 137, 151}, {83, 126, 132}, {67, 106, 111}, {70, 87, 93},
 {73, 80, 82}, {73, 76, 78}, {71, 81, 80}, {71, 78, 81},
 {66, 75, 88}, {61, 81, 97}, {70, 91, 117}, {73, 98, 127},
 {77, 106, 138}, {82, 110, 143}, {83, 115, 148}, {85, 118, 151},
 {90, 123, 156}, {90, 124, 157}, {92, 125, 158}, {93, 126, 159},
 {93, 126, 159}, {94, 127, 160}, {94, 127, 162}, {94, 127, 162},
 {94, 128, 163}, {95, 128, 163}, {95, 129, 164}, {95, 128, 163},
 {95, 128, 161}, {93, 126, 159}, {93, 126, 157}, {94, 124, 153},
 {91, 122, 140}, {81, 116, 124}, {78, 105, 114}, {81, 91, 96},
 {84, 84, 80}, {77, 78, 71}, {64, 62, 54}, {51, 43, 35},
 {37, 29, 35}, {26, 23, 30}, {0, 0, 0}, {5, 2, 12},
 {22, 27, 46}, {35, 32, 48}, {43, 40, 50}, {42, 49, 58},
 {29, 56, 73}, {35, 62, 80}, {38, 47, 63}, {29, 33, 53},
},
/* dodge102.ppm*/
{
 {47, 42, 46}, {88, 93, 90}, {136, 152, 150}, {140, 218, 225},
 {130, 242, 251}, {123, 245, 243}, {122, 188, 198}, {99, 137, 153},
 {74, 113, 109}, {74, 89, 82}, {58, 73, 61}, {49, 64, 54},
 {58, 41, 32}, {64, 30, 24}, {63, 28, 23}, {65, 27, 22},
 {76, 30, 21}, {75, 34, 17}, {74, 32, 14}, {79, 31, 14},
 {80, 32, 15}, {85, 31, 18}, {82, 34, 23}, {89, 42, 25},
 {85, 45, 27}, {78, 49, 29}, {77, 40, 29}, {77, 36, 27},
 {89, 39, 35}, {112, 56, 39}, {116, 69, 43}, {118, 89, 51},
 {124, 92, 37}, {160, 122, 46}, {171, 135, 56}, {168, 156, 97},
 {153, 159, 102}, {144, 150, 88}, {137, 115, 85}, {118, 108, 89},
 {108, 95, 75}, {95, 87, 63}, {95, 78, 55}, {88, 65, 56},
 {92, 57, 49}, {94, 57, 48}, {94, 53, 47}, {98, 51, 43},
 {105, 67, 50}, {109, 74, 60}, {116, 91, 81}, {140, 119, 89},
 {179, 161, 111}, {235, 221, 170}, {245, 246, 140}, {237, 221, 102},
 {227, 193, 91}, {215, 181, 106}, {197, 157, 88}, {184, 153, 62},
 {161, 124, 46}, {149, 99, 41}, {143, 84, 37}, {130, 77, 42},
 {117, 73, 48}, {118, 67, 53}, {124, 81, 60}, {139, 107, 90},
 {156, 161, 147}, {192, 207, 161}, {221, 235, 186}, {216, 244, 206},
 {178, 223, 200}, {179, 187, 163}, {154, 134, 116}, {146, 106, 79},
 {129, 105, 52}, {114, 103, 49}, {119, 122, 74}, {135, 141, 112},
 {147, 164, 149}, {165, 213, 168}, {199, 243, 222}, {187, 251, 248},
 {190, 248, 233}, {169, 215, 199}, {158, 176, 150}, {136, 139, 120},
 {119, 121, 104}, {121, 120, 93}, {146, 152, 109}, {180, 159, 99},
 {181, 191, 105}, {181, 205, 157}, {175, 231, 216}, {168, 243, 243},
 {138, 241, 247}, {127, 247, 247}, {138, 247, 240}, {141, 188, 174},
 {112, 136, 129}, {91, 103, 81}, {69, 86, 67}, {69, 59, 41},
 {62, 59, 21}, {59, 36, 17}, {61, 25, 14}, {61, 24, 16},
 {55, 25, 15}, {44, 26, 23}, {47, 31, 23}, {54, 33, 22},
 {60, 34, 30}, {53, 42, 49}, {51, 60, 66}, {46, 72, 60},
 {53, 84, 86}, {54, 100, 125}, {84, 149, 155}, {92, 243, 249},
 {108, 244, 249}, {130, 219, 231}, {125, 155, 166}, {71, 105, 120},
 {47, 89, 118}, {26, 50, 68}, {24, 25, 32}, {13, 12, 21},
 {12, 9, 8}, {5, 4, 4}, {5, 2, 2}, {4, 0, 1},
 {5, 1, 0}, {12, 4, 2}, {16, 7, 4}, {21, 7, 1},
 {22, 5, 2}, {18, 5, 5}, {16, 6, 6}, {9, 5, 4},
 {5, 2, 1}, {1, 0, 0}, {0, 0, 0}, {0, 0, 0},
 {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
 {0, 0, 0}, {1, 0, 0}, {3, 0, 1}, {6, 0, 3},
 {16, 5, 5}, {23, 9, 4}, {22, 15, 9}, {18, 14, 14},
 {20, 20, 26}, {26, 26, 23}, {43, 36, 29}, {52, 42, 42},
 {59, 67, 62}, {75, 80, 80}, {77, 116, 99}, {97, 141, 153},
 {121, 219, 225}, {121, 246, 252}, {136, 238, 245}, {143, 176, 174},
 {121, 125, 121}, {107, 98, 94}, {76, 93, 72}, {77, 86, 51},
 {83, 57, 49}, {78, 51, 44}, {70, 40, 41}, {67, 31, 31},
 {63, 28, 24}, {62, 27, 20}, {58, 29, 10}, {55, 31, 12},
 {49, 28, 13}, {42, 23, 7}, {37, 19, 7}, {38, 17, 6},
 {43, 13, 5}, {47, 14, 5}, {59, 15, 6}, {61, 17, 6},
 {63, 21, 5}, {67, 23, 8}, {69, 27, 6}, {66, 28, 6},
 {66, 30, 13}, {70, 34, 18}, {70, 40, 28}, {78, 42, 35},
 {88, 53, 39}, {93, 69, 56}, {113, 83, 83}, {138, 119, 116},
 {196, 181, 138}, {222, 227, 216}, {247, 245, 223}, {250, 249, 228},
 {247, 251, 242}, {230, 247, 235}, {199, 236, 231}, {199, 236, 228},
 {193, 231, 227}, {165, 173, 178}, {153, 134, 140}, {128, 119, 110},
 {112, 95, 87}, {108, 78, 57}, {99, 79, 48}, {94, 71, 37},
 {71, 52, 28}, {65, 47, 26}, {69, 31, 26}, {61, 26, 22},
 {56, 24, 19}, {56, 21, 15}, {55, 21, 13}, {47, 16, 11},
 {45, 11, 3}, {41, 10, 4}, {39, 10, 6}, {37, 11, 5},
 {33, 14, 3}, {30, 9, 2}, {30, 5, 0}, {28, 9, 3},
 {27, 11, 2}, {27, 11, 3}, {26, 14, 7}, {24, 12, 5},
 {22, 15, 5}, {27, 12, 4}, {31, 16, 6}, {36, 17, 7},
 {41, 21, 11}, {48, 20, 12}, {57, 18, 12}, {61, 22, 11},
 {65, 23, 13}, {68, 23, 14}, {68, 22, 9}, {63, 19, 7},
 {57, 17, 7}, {46, 17, 7}, {37, 18, 5}, {34, 17, 6},
 {30, 18, 14}, {30, 26, 11}, {25, 32, 17}, {37, 31, 31},
},
/* ernst.anti-pope.ppm*/
{
 {60, 41, 44}, {63, 44, 53}, {61, 45, 54}, {62, 43, 55},
 {59, 42, 56}, {61, 39, 55}, {61, 43, 57}, {65, 44, 53},
 {67, 46, 53}, {74, 44, 54}, {76, 44, 57}, {80, 48, 63},
 {87, 49, 64}, {89, 43, 57}, {93, 46, 53}, {96, 44, 53},
 {106, 49, 53}, {104, 56, 56}, {108, 68, 64}, {111, 72, 67},
 {119, 70, 68}, {129, 76, 71}, {133, 79, 68}, {133, 75, 74},
 {139, 65, 65}, {134, 69, 76}, {143, 77, 76}, {170, 77, 76},
 {148, 92, 81}, {136, 92, 73}, {135, 90, 87}, {149, 96, 75},
 {174, 114, 73}, {203, 130, 81}, {202, 137, 86}, {201, 164, 136},
 {201, 164, 138}, {176, 147, 135}, {203, 131, 101}, {167, 145, 117},
 {186, 121, 108}, {174, 107, 89}, {146, 117, 90}, {133, 112, 98},
 {118, 112, 123}, {100, 95, 100}, {125, 102, 98}, {113, 100, 93},
 {102, 84, 81}, {100, 74, 86}, {99, 77, 97}, {98, 63, 76},
 {94, 53, 70}, {86, 52, 65}, {81, 49, 63}, {75, 52, 61},
 {71, 52, 64}, {70, 49, 64}, {70, 50, 62}, {69, 52, 63},
 {67, 50, 61}, {64, 50, 63}, {66, 51, 59}, {63, 51, 62},
 {63, 54, 61}, {62, 50, 61}, {62, 48, 61}, {62, 48, 61},
 {57, 45, 59}, {57, 43, 56}, {57, 46, 56}, {55, 45, 56},
 {53, 43, 56}, {53, 43, 57}, {54, 40, 53}, {53, 41, 55},
 {55, 43, 57}, {57, 42, 59}, {57, 47, 59}, {59, 49, 60},
 {53, 48, 68}, {58, 50, 66}, {51, 49, 70}, {49, 49, 64},
 {52, 51, 70}, {54, 51, 69}, {57, 53, 67}, {61, 52, 73},
 {65, 53, 75}, {64, 52, 70}, {62, 51, 67}, {61, 50, 68},
 {60, 48, 70}, {58, 49, 70}, {58, 49, 67}, {60, 48, 62},
 {61, 50, 64}, {61, 50, 63}, {62, 50, 62}, {63, 48, 61},
 {65, 47, 61}, {67, 45, 59}, {65, 46, 58}, {64, 46, 58},
 {63, 47, 58}, {63, 45, 57}, {59, 45, 58}, {58, 44, 57},
 {61, 43, 57}, {61, 44, 57}, {61, 43, 59}, {62, 42, 60},
 {64, 44, 60}, {66, 45, 61}, {67, 47, 62}, {66, 48, 67},
 {66, 50, 69}, {72, 53, 68}, {74, 56, 70}, {78, 56, 71},
 {73, 68, 75}, {80, 55, 76}, {85, 58, 78}, {79, 60, 84},
 {86, 65, 82}, {96, 68, 76}, {98, 72, 79}, {108, 85, 78},
 {123, 88, 70}, {113, 83, 78}, {122, 85, 81}, {132, 104, 92},
 {127, 111, 90}, {136, 93, 101}, {142, 83, 87}, {137, 82, 75},
 {121, 80, 77}, {110, 67, 85}, {102, 67, 77}, {94, 66, 72},
 {83, 68, 66}, {80, 71, 76}, {81, 73, 85}, {87, 84, 89},
 {85, 69, 84}, {90, 84, 96}, {82, 84, 88}, {80, 90, 95},
 {85, 84, 110}, {93, 72, 86}, {82, 72, 81}, {77, 70, 82},
 {74, 63, 77}, {72, 56, 74}, {71, 55, 68}, {67, 51, 65},
 {65, 51, 67}, {64, 50, 65}, {67, 50, 66}, {72, 51, 68},
 {74, 50, 66}, {80, 53, 63}, {86, 55, 68}, {89, 63, 68},
 {91, 66, 68}, {97, 65, 65}, {103, 66, 58}, {99, 64, 64},
 {102, 61, 71}, {111, 58, 72}, {104, 63, 63}, {118, 53, 59},
 {127, 52, 59}, {141, 47, 52}, {161, 39, 53}, {164, 37, 51},
 {143, 41, 51}, {136, 46, 61}, {118, 47, 50}, {111, 47, 59},
 {109, 45, 59}, {106, 46, 61}, {107, 42, 63}, {109, 41, 58},
 {106, 42, 53}, {95, 44, 59}, {88, 45, 57}, {78, 43, 61},
 {70, 47, 63}, {67, 46, 61}, {66, 45, 62}, {64, 46, 62},
 {62, 45, 60}, {62, 46, 58}, {60, 45, 58}, {58, 45, 59},
 {58, 47, 58}, {62, 48, 62}, {64, 50, 63}, {66, 52, 65},
 {69, 55, 68}, {71, 63, 68}, {68, 65, 76}, {66, 66, 76},
 {62, 61, 78}, {62, 61, 79}, {65, 55, 80}, {66, 54, 76},
 {65, 53, 77}, {60, 52, 80}, {57, 54, 73}, {58, 58, 70},
 {57, 59, 74}, {62, 61, 80}, {59, 67, 86}, {63, 68, 86},
 {63, 68, 88}, {65, 70, 90}, {67, 65, 93}, {62, 70, 95},
 {58, 68, 99}, {62, 75, 92}, {59, 77, 97}, {61, 76, 109},
 {61, 77, 100}, {54, 70, 105}, {56, 70, 105}, {53, 67, 102},
 {52, 65, 99}, {55, 65, 102}, {54, 68, 103}, {61, 73, 92},
 {64, 68, 94}, {68, 76, 95}, {74, 79, 89}, {70, 77, 83},
 {66, 72, 87}, {68, 62, 92}, {70, 56, 77}, {72, 55, 76},
 {68, 56, 75}, {72, 53, 72}, {74, 54, 66}, {75, 56, 64},
 {77, 53, 61}, {81, 50, 58}, {87, 54, 52}, {96, 51, 58},
 {92, 44, 61}, {85, 45, 62}, {75, 45, 58}, {71, 41, 54},
 {70, 41, 56}, {70, 41, 56}, {69, 41, 55}, {66, 41, 53},
},
/* ernst.ubu-imperator.ppm*/
{
 {36, 57, 12}, {87, 102, 130}, {126, 148, 170}, {137, 166, 178},
 {146, 174, 185}, {160, 179, 186}, {163, 183, 190}, {161, 180, 186},
 {154, 172, 181}, {147, 165, 174}, {138, 144, 155}, {144, 103, 23},
 {127, 77, 3}, {93, 20, 6}, {78, 10, 6}, {65, 4, 2},
 {53, 0, 8}, {30, 4, 0}, {9, 3, 2}, {1, 1, 0},
 {0, 0, 1}, {3, 1, 3}, {5, 0, 9}, {21, 15, 4},
 {32, 17, 0}, {39, 3, 2}, {48, 5, 0}, {54, 4, 0},
 {56, 3, 3}, {65, 3, 0}, {66, 2, 2}, {70, 3, 3},
 {76, 7, 1}, {80, 4, 1}, {79, 3, 0}, {80, 4, 0},
 {81, 9, 0}, {81, 15, 0}, {87, 26, 1}, {103, 68, 8},
 {108, 151, 11}, {93, 159, 31}, {123, 149, 161}, {139, 163, 175},
 {149, 171, 181}, {158, 176, 184}, {162, 177, 186}, {166, 178, 187},
 {164, 175, 185}, {161, 173, 181}, {162, 170, 173}, {172, 123, 74},
 {178, 113, 3}, {187, 117, 1}, {190, 122, 0}, {184, 122, 2},
 {165, 123, 8}, {108, 143, 36}, {117, 147, 164}, {129, 161, 176},
 {129, 166, 182}, {103, 148, 174}, {92, 105, 135}, {72, 69, 15},
 {76, 24, 3}, {72, 17, 3}, {73, 16, 1}, {75, 15, 2},
 {77, 14, 3}, {78, 11, 4}, {78, 9, 3}, {77, 9, 1},
 {74, 9, 1}, {72, 10, 2}, {71, 10, 4}, {66, 9, 4},
 {66, 6, 1}, {64, 6, 2}, {66, 10, 1}, {68, 12, 2},
 {69, 8, 1}, {68, 6, 1}, {69, 6, 0}, {71, 7, 0},
 {71, 8, 1}, {73, 10, 2}, {75, 12, 1}, {75, 14, 1},
 {81, 13, 2}, {84, 15, 1}, {90, 17, 2}, {99, 23, 2},
 {139, 79, 0}, {151, 87, 6}, {134, 63, 9}, {102, 21, 4},
 {93, 15, 5}, {92, 12, 6}, {101, 10, 2}, {125, 27, 3},
 {163, 66, 2}, {179, 76, 2}, {190, 94, 5}, {206, 116, 4},
 {211, 121, 1}, {213, 130, 2}, {214, 136, 1}, {209, 137, 1},
 {198, 131, 2}, {181, 112, 1}, {167, 100, 0}, {150, 90, 1},
 {126, 87, 7}, {58, 84, 7}, {34, 64, 2}, {62, 90, 10},
 {131, 87, 4}, {157, 83, 1}, {166, 87, 2}, {168, 88, 2},
 {169, 88, 1}, {175, 87, 1}, {180, 90, 4}, {177, 98, 4},
 {181, 102, 1}, {177, 105, 1}, {179, 109, 3}, {188, 112, 1},
 {195, 107, 1}, {197, 109, 0}, {200, 116, 2}, {192, 121, 4},
 {191, 121, 2}, {179, 113, 3}, {173, 105, 2}, {158, 106, 9},
 {107, 121, 142}, {114, 139, 162}, {109, 136, 162}, {88, 101, 138},
 {92, 44, 33}, {86, 16, 5}, {84, 10, 2}, {82, 9, 3},
 {84, 7, 1}, {89, 11, 0}, {91, 14, 1}, {99, 17, 1},
 {110, 20, 0}, {151, 57, 4}, {165, 68, 2}, {170, 70, 6},
 {170, 69, 2}, {168, 73, 2}, {171, 78, 0}, {173, 88, 0},
 {175, 95, 2}, {182, 105, 0}, {189, 114, 0}, {197, 123, 2},
 {206, 127, 2}, {209, 130, 2}, {212, 129, 3}, {208, 124, 1},
 {206, 122, 1}, {198, 124, 4}, {191, 119, 2}, {186, 104, 5},
 {177, 89, 8}, {169, 74, 5}, {164, 73, 2}, {157, 57, 1},
 {124, 25, 6}, {102, 16, 2}, {95, 16, 3}, {91, 14, 2},
 {87, 16, 2}, {88, 15, 4}, {95, 22, 2}, {131, 52, 2},
 {159, 67, 1}, {162, 76, 0}, {162, 80, 2}, {168, 88, 6},
 {173, 96, 6}, {175, 96, 3}, {172, 97, 2}, {173, 98, 3},
 {174, 102, 2}, {167, 102, 4}, {162, 113, 19}, {145, 151, 153},
 {162, 171, 176}, {163, 172, 179}, {169, 178, 183}, {168, 177, 186},
 {168, 184, 193}, {169, 185, 190}, {176, 186, 188}, {182, 191, 183},
 {180, 189, 188}, {173, 190, 196}, {177, 191, 200}, {169, 191, 198},
 {159, 190, 201}, {148, 176, 187}, {138, 166, 178}, {133, 158, 172},
 {109, 126, 146}, {74, 88, 37}, {58, 27, 5}, {71, 19, 2},
 {78, 19, 3}, {81, 15, 5}, {92, 33, 34}, {87, 99, 124},
 {102, 126, 155}, {94, 105, 113}, {130, 95, 4}, {146, 99, 3},
 {152, 96, 1}, {159, 92, 2}, {166, 103, 2}, {177, 113, 0},
 {175, 117, 2}, {171, 121, 16}, {152, 133, 70}, {146, 163, 173},
 {150, 168, 177}, {154, 172, 181}, {153, 176, 184}, {151, 173, 186},
 {154, 171, 185}, {149, 169, 184}, {145, 169, 177}, {138, 154, 157},
 {172, 124, 23}, {195, 124, 6}, {197, 126, 7}, {200, 127, 7},
 {212, 130, 11}, {175, 176, 172}, {175, 183, 184}, {173, 182, 181},
 {160, 170, 179}, {139, 161, 174}, {125, 138, 160}, {91, 98, 105},
 {43, 58, 6}, {29, 18, 5}, {15, 12, 4}, {3, 6, 4},
 {1, 3, 4}, {4, 3, 2}, {11, 11, 1}, {26, 25, 3},
},
/* fighting-forms.ppm*/
{
 {2, 3, 0}, {11, 15, 2}, {22, 23, 8}, {40, 36, 23},
 {82, 53, 40}, {133, 63, 36}, {149, 96, 18}, {169, 100, 12},
 {182, 122, 14}, {214, 140, 47}, {235, 178, 73}, {230, 176, 63},
 {220, 159, 44}, {174, 151, 29}, {141, 139, 43}, {129, 99, 40},
 {56, 61, 33}, {35, 36, 18}, {25, 24, 6}, {17, 18, 3},
 {18, 17, 0}, {24, 19, 0}, {27, 25, 3}, {35, 29, 12},
 {100, 42, 16}, {140, 45, 14}, {144, 52, 14}, {120, 55, 39},
 {75, 59, 56}, {51, 40, 38}, {34, 28, 15}, {24, 19, 5},
 {13, 13, 3}, {12, 13, 1}, {7, 8, 3}, {11, 13, 2},
 {9, 11, 0}, {12, 11, 2}, {13, 15, 2}, {22, 23, 7},
 {30, 31, 12}, {40, 40, 28}, {52, 63, 69}, {63, 96, 65},
 {66, 103, 73}, {100, 114, 124}, {105, 155, 133}, {138, 146, 105},
 {152, 125, 65}, {159, 122, 55}, {158, 94, 30}, {156, 60, 7},
 {149, 46, 14}, {135, 43, 40}, {124, 57, 81}, {97, 58, 132},
 {80, 70, 149}, {66, 83, 139}, {85, 94, 140}, {97, 116, 153},
 {96, 119, 151}, {96, 102, 126}, {97, 87, 79}, {137, 77, 67},
 {164, 55, 24}, {174, 60, 16}, {175, 42, 4}, {175, 37, 7},
 {164, 40, 12}, {142, 47, 14}, {111, 47, 30}, {65, 46, 47},
 {37, 34, 22}, {32, 34, 12}, {31, 32, 16}, {43, 33, 25},
 {88, 42, 37}, {140, 30, 9}, {164, 24, 1}, {169, 28, 2},
 {174, 34, 2}, {168, 38, 1}, {160, 41, 4}, {131, 44, 7},
 {71, 53, 21}, {34, 30, 10}, {27, 22, 5}, {18, 15, 1},
 {13, 16, 1}, {18, 19, 3}, {30, 27, 11}, {37, 33, 32},
 {46, 32, 70}, {59, 38, 117}, {66, 58, 127}, {67, 60, 133},
 {63, 63, 123}, {53, 51, 71}, {56, 50, 67}, {55, 47, 64},
 {45, 46, 37}, {45, 40, 29}, {48, 43, 39}, {61, 50, 62},
 {75, 90, 70}, {81, 95, 120}, {89, 100, 136}, {99, 97, 124},
 {130, 93, 79}, {158, 58, 28}, {174, 63, 9}, {184, 51, 4},
 {186, 46, 8}, {190, 37, 18}, {187, 40, 21}, {180, 48, 10},
 {174, 50, 3}, {166, 69, 2}, {181, 83, 21}, {205, 97, 2},
 {203, 115, 5}, {212, 138, 3}, {218, 141, 4}, {237, 144, 0},
 {233, 139, 5}, {225, 115, 4}, {207, 98, 4}, {204, 58, 27},
 {199, 52, 18}, {199, 49, 16}, {193, 39, 9}, {194, 35, 6},
 {189, 36, 5}, {186, 35, 2}, {186, 33, 6}, {182, 37, 5},
 {185, 39, 2}, {186, 31, 2}, {185, 30, 3}, {186, 31, 3},
 {187, 30, 3}, {186, 30, 2}, {183, 32, 2}, {179, 27, 3},
 {180, 31, 3}, {184, 31, 5}, {184, 29, 6}, {181, 30, 3},
 {181, 28, 0}, {181, 30, 2}, {179, 29, 2}, {174, 29, 0},
 {176, 33, 3}, {178, 30, 3}, {175, 25, 1}, {174, 24, 1},
 {173, 25, 0}, {166, 24, 1}, {153, 26, 7}, {116, 30, 5},
 {43, 25, 4}, {28, 18, 2}, {26, 15, 1}, {27, 15, 1},
 {32, 23, 8}, {43, 28, 14}, {111, 34, 2}, {144, 39, 4},
 {160, 30, 2}, {163, 35, 4}, {155, 41, 12}, {129, 53, 66},
 {132, 71, 99}, {99, 109, 132}, {95, 141, 145}, {107, 135, 143},
 {101, 125, 156}, {100, 117, 143}, {87, 111, 128}, {66, 114, 73},
 {72, 108, 48}, {97, 111, 29}, {108, 120, 58}, {138, 150, 119},
 {183, 165, 155}, {195, 175, 164}, {163, 166, 182}, {125, 170, 197},
 {131, 154, 188}, {120, 117, 172}, {86, 106, 175}, {68, 81, 143},
 {67, 61, 123}, {85, 56, 66}, {112, 37, 48}, {154, 39, 15},
 {180, 48, 24}, {187, 60, 69}, {188, 118, 123}, {193, 146, 160},
 {206, 170, 188}, {162, 157, 190}, {144, 136, 147}, {139, 102, 158},
 {173, 54, 109}, {167, 45, 49}, {177, 43, 13}, {170, 41, 14},
 {153, 40, 9}, {126, 36, 5}, {55, 29, 11}, {29, 17, 2},
 {21, 11, 1}, {18, 10, 0}, {25, 16, 1}, {28, 19, 8},
 {36, 28, 10}, {91, 44, 9}, {143, 38, 7}, {146, 47, 6},
 {142, 52, 5}, {130, 73, 10}, {78, 62, 22}, {40, 37, 23},
 {44, 26, 16}, {90, 27, 4}, {136, 30, 7}, {158, 30, 2},
 {169, 33, 1}, {175, 32, 7}, {166, 37, 17}, {149, 51, 36},
 {129, 48, 74}, {99, 54, 126}, {76, 51, 129}, {73, 58, 137},
 {84, 74, 148}, {102, 79, 152}, {119, 80, 142}, {174, 57, 99},
 {178, 50, 50}, {175, 49, 49}, {186, 58, 48}, {186, 57, 99},
 {176, 59, 115}, {124, 107, 116}, {116, 143, 147}, {128, 161, 139},
 {190, 169, 127}, {235, 175, 114}, {233, 175, 81}, {148, 146, 56},
 {151, 99, 30}, {120, 86, 12}, {120, 78, 22}, {56, 50, 9},
},
/* fog25.ppm*/
{
 {11, 14, 2}, {30, 28, 10}, {35, 35, 14}, {52, 43, 23},
 {52, 61, 22}, {61, 63, 29}, {67, 62, 30}, {83, 70, 39},
 {113, 96, 63}, {149, 134, 131}, {163, 157, 162}, {175, 169, 173},
 {178, 172, 176}, {173, 165, 170}, {160, 149, 152}, {162, 119, 78},
 {159, 108, 65}, {135, 95, 47}, {112, 83, 32}, {88, 81, 23},
 {75, 72, 18}, {72, 59, 18}, {73, 63, 24}, {70, 48, 22},
 {72, 57, 30}, {66, 52, 20}, {64, 60, 21}, {66, 71, 23},
 {72, 62, 27}, {66, 73, 21}, {75, 66, 26}, {80, 64, 23},
 {103, 73, 33}, {130, 88, 40}, {163, 99, 47}, {172, 100, 47},
 {174, 106, 51}, {185, 120, 60}, {194, 128, 73}, {206, 141, 84},
 {201, 145, 94}, {179, 165, 164}, {191, 180, 184}, {205, 196, 192},
 {214, 212, 217}, {231, 230, 236}, {238, 242, 245}, {239, 242, 247},
 {233, 236, 241}, {227, 226, 231}, {213, 208, 214}, {197, 192, 198},
 {178, 172, 177}, {150, 144, 146}, {130, 103, 68}, {86, 76, 53},
 {74, 61, 44}, {68, 58, 40}, {61, 53, 28}, {58, 51, 19},
 {60, 53, 11}, {62, 45, 5}, {45, 43, 6}, {34, 39, 4},
 {31, 41, 3}, {36, 36, 9}, {32, 35, 9}, {30, 36, 6},
 {17, 16, 10}, {21, 18, 2}, {31, 13, 5}, {28, 20, 7},
 {28, 24, 4}, {33, 24, 6}, {35, 41, 17}, {45, 42, 12},
 {51, 36, 17}, {53, 37, 22}, {62, 38, 16}, {78, 39, 12},
 {81, 46, 17}, {83, 52, 12}, {89, 65, 13}, {103, 76, 18},
 {119, 80, 26}, {137, 85, 29}, {160, 92, 41}, {162, 103, 54},
 {171, 109, 59}, {184, 120, 59}, {196, 124, 60}, {194, 131, 73},
 {199, 146, 97}, {181, 170, 172}, {196, 186, 191}, {203, 198, 202},
 {215, 216, 218}, {230, 229, 235}, {231, 231, 239}, {231, 230, 238},
 {225, 225, 229}, {211, 208, 207}, {195, 189, 193}, {173, 168, 171},
 {145, 140, 142}, {117, 103, 54}, {98, 77, 33}, {86, 61, 34},
 {78, 63, 30}, {76, 63, 31}, {75, 64, 34}, {70, 58, 42},
 {76, 55, 36}, {72, 58, 30}, {67, 57, 17}, {63, 55, 9},
 {53, 62, 2}, {50, 42, 4}, {47, 40, 7}, {46, 40, 6},
 {51, 39, 8}, {52, 39, 10}, {55, 41, 12}, {58, 45, 19},
 {57, 48, 20}, {63, 47, 18}, {70, 48, 15}, {71, 48, 16},
 {87, 53, 19}, {100, 72, 29}, {110, 90, 39}, {134, 119, 63},
 {148, 138, 137}, {167, 164, 163}, {182, 177, 177}, {186, 179, 187},
 {184, 177, 185}, {178, 171, 178}, {168, 155, 158}, {187, 143, 107},
 {192, 130, 79}, {179, 119, 63}, {165, 111, 56}, {159, 109, 55},
 {160, 111, 61}, {160, 114, 72}, {153, 141, 142}, {167, 159, 164},
 {172, 167, 171}, {171, 166, 170}, {157, 151, 153}, {151, 135, 129},
 {143, 105, 64}, {124, 86, 40}, {112, 73, 31}, {88, 62, 31},
 {91, 64, 24}, {90, 64, 19}, {89, 63, 18}, {92, 69, 20},
 {102, 78, 19}, {112, 78, 29}, {123, 83, 37}, {142, 97, 52},
 {143, 118, 69}, {155, 146, 149}, {178, 172, 174}, {194, 190, 190},
 {203, 199, 202}, {217, 216, 222}, {232, 235, 239}, {241, 245, 248},
 {245, 249, 252}, {247, 251, 254}, {249, 253, 255}, {251, 253, 255},
 {253, 254, 255}, {253, 254, 255}, {253, 254, 255}, {251, 255, 255},
 {249, 254, 255}, {249, 253, 254}, {249, 253, 254}, {247, 253, 255},
 {245, 250, 253}, {244, 249, 253}, {244, 249, 252}, {240, 245, 248},
 {231, 232, 237}, {219, 216, 218}, {203, 196, 202}, {189, 183, 187},
 {169, 160, 164}, {180, 133, 98}, {169, 113, 66}, {163, 109, 56},
 {167, 105, 58}, {167, 114, 65}, {162, 115, 75}, {155, 144, 148},
 {173, 164, 171}, {184, 177, 185}, {187, 182, 189}, {188, 182, 187},
 {179, 173, 174}, {166, 156, 155}, {198, 138, 89}, {181, 123, 67},
 {163, 104, 55}, {152, 95, 50}, {133, 91, 37}, {124, 81, 28},
 {117, 81, 28}, {108, 77, 27}, {111, 79, 32}, {118, 83, 39},
 {133, 92, 51}, {146, 97, 56}, {153, 103, 61}, {152, 104, 57},
 {148, 104, 57}, {142, 101, 48}, {134, 95, 43}, {123, 84, 31},
 {109, 70, 28}, {99, 66, 22}, {95, 64, 28}, {97, 65, 36},
 {102, 78, 52}, {120, 88, 58}, {143, 110, 81}, {152, 144, 147},
 {174, 165, 170}, {193, 182, 188}, {205, 195, 203}, {220, 217, 224},
 {232, 235, 242}, {243, 246, 251}, {245, 250, 253}, {248, 253, 254},
 {249, 253, 254}, {253, 255, 254}, {255, 255, 255}, {255, 255, 255},
 {254, 255, 255}, {253, 254, 255}, {253, 254, 255}, {250, 251, 253},
 {244, 248, 250}, {234, 236, 243}, {222, 219, 229}, {207, 197, 205},
 {188, 181, 189}, {170, 160, 167}, {142, 133, 134}, {76, 67, 44},
},
/* geyser27.ppm*/
{
 {0, 0, 0}, {26, 5, 5}, {77, 17, 6}, {98, 45, 29},
 {124, 78, 66}, {114, 129, 146}, {115, 168, 193}, {132, 179, 210},
 {152, 186, 220}, {153, 176, 202}, {142, 171, 181}, {157, 169, 176},
 {165, 162, 158}, {154, 131, 103}, {149, 104, 73}, {152, 98, 60},
 {140, 85, 46}, {138, 67, 23}, {163, 57, 6}, {173, 55, 8},
 {179, 56, 3}, {190, 61, 8}, {208, 86, 7}, {210, 110, 25},
 {221, 127, 29}, {222, 150, 44}, {226, 161, 53}, {222, 159, 52},
 {222, 152, 60}, {213, 148, 66}, {193, 134, 70}, {164, 146, 113},
 {138, 141, 159}, {133, 144, 165}, {154, 139, 122}, {148, 108, 84},
 {158, 115, 69}, {189, 121, 57}, {198, 124, 48}, {212, 136, 45},
 {224, 146, 39}, {223, 143, 35}, {222, 137, 31}, {222, 136, 24},
 {221, 137, 18}, {205, 101, 19}, {198, 76, 4}, {176, 60, 14},
 {148, 86, 43}, {154, 110, 61}, {141, 115, 89}, {125, 168, 156},
 {126, 173, 199}, {109, 156, 212}, {105, 144, 195}, {96, 120, 161},
 {71, 74, 121}, {37, 58, 125}, {26, 49, 119}, {16, 42, 117},
 {17, 41, 115}, {18, 38, 106}, {35, 42, 95}, {53, 36, 45},
 {59, 35, 35}, {84, 25, 14}, {98, 35, 15}, {116, 48, 18},
 {121, 56, 23}, {135, 72, 28}, {142, 82, 36}, {163, 103, 51},
 {178, 108, 56}, {196, 123, 61}, {214, 145, 68}, {202, 165, 99},
 {182, 166, 149}, {177, 174, 165}, {175, 176, 165}, {157, 168, 171},
 {135, 153, 167}, {120, 125, 129}, {126, 87, 69}, {125, 82, 64},
 {126, 81, 63}, {127, 75, 46}, {137, 83, 37}, {142, 82, 36},
 {142, 80, 35}, {134, 70, 20}, {116, 51, 9}, {107, 38, 11},
 {97, 29, 7}, {86, 25, 13}, {87, 26, 8}, {93, 28, 8},
 {103, 31, 6}, {110, 40, 6}, {111, 43, 7}, {141, 28, 8},
 {143, 31, 7}, {145, 34, 10}, {148, 36, 6}, {145, 39, 3},
 {128, 54, 22}, {115, 51, 25}, {99, 50, 25}, {99, 47, 28},
 {102, 44, 27}, {95, 42, 26}, {53, 35, 43}, {23, 38, 100},
 {14, 34, 103}, {18, 28, 89}, {4, 0, 2}, {1, 0, 0},
 {24, 3, 2}, {75, 15, 6}, {85, 15, 2}, {98, 23, 4},
 {101, 24, 2}, {105, 32, 2}, {106, 34, 2}, {104, 37, 12},
 {100, 33, 14}, {91, 30, 11}, {88, 29, 11}, {93, 38, 18},
 {96, 39, 24}, {98, 47, 30}, {69, 63, 76}, {36, 54, 121},
 {49, 63, 118}, {100, 68, 69}, {114, 71, 55}, {131, 86, 57},
 {159, 109, 61}, {186, 112, 45}, {200, 123, 46}, {217, 143, 50},
 {221, 149, 55}, {221, 147, 50}, {211, 139, 54}, {188, 119, 49},
 {175, 103, 38}, {152, 85, 32}, {165, 61, 23}, {160, 43, 7},
 {163, 41, 6}, {153, 31, 3}, {156, 35, 7}, {162, 41, 7},
 {164, 43, 5}, {170, 53, 9}, {182, 67, 12}, {195, 110, 40},
 {213, 134, 48}, {224, 152, 58}, {223, 161, 67}, {222, 154, 64},
 {195, 134, 61}, {181, 119, 60}, {156, 111, 61}, {145, 104, 74},
 {126, 81, 65}, {91, 91, 112}, {114, 123, 157}, {118, 163, 183},
 {127, 182, 196}, {128, 186, 211}, {132, 187, 192}, {154, 193, 164},
 {167, 204, 164}, {170, 202, 163}, {180, 203, 188}, {163, 198, 225},
 {139, 193, 222}, {136, 192, 219}, {119, 177, 225}, {115, 173, 225},
 {112, 166, 225}, {109, 154, 202}, {113, 118, 144}, {119, 77, 72},
 {112, 67, 52}, {102, 53, 32}, {102, 53, 33}, {111, 67, 54},
 {90, 85, 91}, {44, 63, 127}, {32, 52, 121}, {26, 46, 119},
 {18, 38, 109}, {16, 31, 95}, {2, 4, 21}, {0, 0, 0},
 {0, 0, 0}, {6, 1, 0}, {33, 11, 21}, {46, 37, 52},
 {55, 66, 120}, {98, 107, 144}, {133, 149, 176}, {137, 158, 190},
 {121, 132, 164}, {76, 86, 128}, {40, 58, 125}, {30, 50, 118},
 {27, 47, 121}, {39, 50, 109}, {107, 61, 46}, {104, 57, 36},
 {110, 60, 40}, {130, 82, 55}, {153, 108, 60}, {155, 114, 66},
 {186, 132, 68}, {216, 177, 98}, {221, 182, 114}, {220, 213, 126},
 {223, 205, 147}, {194, 197, 178}, {174, 198, 177}, {183, 184, 159},
 {192, 145, 102}, {178, 111, 64}, {170, 81, 28}, {173, 58, 7},
 {173, 52, 7}, {173, 50, 5}, {167, 48, 2}, {160, 47, 3},
 {158, 48, 2}, {163, 51, 6}, {174, 58, 8}, {189, 97, 22},
 {209, 124, 41}, {219, 144, 52}, {219, 148, 62}, {200, 138, 62},
 {187, 134, 72}, {171, 156, 133}, {167, 172, 160}, {138, 150, 173},
 {126, 139, 157}, {142, 106, 81}, {117, 71, 55}, {108, 50, 28},
 {98, 42, 18}, {89, 28, 10}, {81, 23, 6}, {78, 14, 2},
 {78, 14, 1}, {75, 7, 1}, {9, 0, 1}, {0, 0, 0},
},
/* gris.josette.ppm*/
{
 {36, 41, 40}, {71, 77, 82}, {90, 114, 119}, {120, 152, 164},
 {158, 192, 200}, {171, 198, 207}, {176, 199, 207}, {178, 198, 207},
 {176, 199, 208}, {179, 200, 207}, {181, 202, 207}, {184, 204, 213},
 {186, 209, 219}, {184, 209, 220}, {183, 211, 217}, {181, 207, 209},
 {179, 205, 210}, {187, 207, 213}, {188, 211, 216}, {188, 211, 217},
 {188, 211, 217}, {190, 209, 221}, {194, 213, 219}, {250, 249, 229},
 {255, 250, 227}, {255, 247, 228}, {227, 228, 218}, {193, 205, 212},
 {188, 204, 204}, {180, 195, 198}, {162, 178, 167}, {117, 146, 147},
 {90, 124, 134}, {81, 117, 123}, {76, 105, 109}, {71, 102, 97},
 {63, 89, 80}, {40, 59, 60}, {33, 47, 50}, {29, 43, 46},
 {26, 36, 38}, {18, 27, 26}, {14, 23, 22}, {19, 28, 27},
 {30, 36, 35}, {29, 36, 39}, {32, 41, 46}, {32, 46, 49},
 {42, 48, 47}, {42, 53, 46}, {73, 82, 57}, {72, 84, 72},
 {73, 91, 84}, {76, 95, 96}, {79, 98, 94}, {82, 102, 99},
 {84, 104, 100}, {93, 106, 100}, {90, 111, 114}, {88, 115, 124},
 {94, 122, 133}, {139, 153, 152}, {175, 190, 183}, {177, 193, 190},
 {157, 174, 157}, {94, 123, 129}, {82, 108, 109}, {66, 93, 89},
 {37, 52, 58}, {26, 38, 39}, {11, 18, 22}, {8, 11, 18},
 {7, 9, 16}, {9, 14, 18}, {13, 20, 23}, {26, 36, 38},
 {36, 50, 55}, {61, 80, 82}, {70, 96, 93}, {76, 100, 101},
 {76, 103, 111}, {79, 110, 113}, {82, 110, 120}, {85, 112, 125},
 {86, 115, 129}, {87, 118, 133}, {90, 124, 143}, {139, 166, 175},
 {171, 187, 203}, {180, 195, 202}, {183, 198, 201}, {180, 198, 199},
 {174, 194, 195}, {157, 160, 165}, {97, 119, 125}, {86, 106, 106},
 {69, 83, 82}, {37, 52, 53}, {28, 39, 36}, {16, 25, 24},
 {10, 18, 21}, {10, 16, 22}, {12, 20, 23}, {25, 39, 42},
 {40, 59, 65}, {69, 97, 94}, {90, 117, 122}, {125, 150, 154},
 {173, 193, 185}, {185, 200, 195}, {184, 200, 200}, {174, 196, 201},
 {145, 179, 183}, {91, 133, 141}, {86, 120, 132}, {86, 116, 127},
 {86, 116, 127}, {90, 116, 127}, {99, 128, 135}, {160, 176, 163},
 {193, 195, 186}, {190, 205, 197}, {208, 214, 203}, {255, 250, 223},
 {254, 252, 232}, {253, 252, 234}, {253, 250, 231}, {246, 245, 225},
 {191, 210, 215}, {186, 204, 213}, {182, 203, 208}, {178, 201, 209},
 {174, 201, 209}, {165, 197, 207}, {142, 175, 185}, {87, 123, 144},
 {85, 119, 138}, {87, 120, 141}, {108, 137, 143}, {145, 181, 181},
 {175, 196, 201}, {184, 197, 205}, {189, 207, 207}, {192, 206, 207},
 {192, 209, 208}, {214, 225, 211}, {249, 253, 231}, {253, 253, 243},
 {253, 253, 244}, {253, 252, 243}, {247, 249, 225}, {192, 209, 203},
 {163, 178, 172}, {118, 136, 143}, {90, 119, 126}, {85, 113, 120},
 {84, 112, 115}, {86, 110, 111}, {88, 112, 116}, {88, 117, 123},
 {92, 122, 132}, {118, 148, 148}, {161, 181, 176}, {176, 195, 200},
 {178, 197, 204}, {178, 198, 205}, {172, 200, 204}, {169, 192, 200},
 {125, 156, 166}, {91, 123, 135}, {77, 112, 116}, {68, 97, 97},
 {53, 71, 81}, {32, 49, 59}, {30, 46, 57}, {40, 60, 67},
 {65, 88, 80}, {72, 92, 91}, {74, 95, 98}, {75, 100, 97},
 {77, 102, 99}, {79, 104, 101}, {78, 103, 100}, {78, 101, 95},
 {78, 101, 95}, {78, 102, 95}, {80, 103, 98}, {81, 102, 101},
 {81, 101, 102}, {82, 102, 103}, {80, 104, 105}, {76, 106, 107},
 {77, 106, 108}, {79, 109, 108}, {80, 110, 112}, {79, 111, 114},
 {81, 111, 114}, {82, 113, 115}, {85, 115, 116}, {85, 114, 118},
 {85, 113, 123}, {85, 115, 127}, {84, 116, 124}, {83, 117, 127},
 {86, 119, 125}, {97, 126, 133}, {149, 174, 171}, {173, 194, 197},
 {177, 197, 199}, {179, 200, 200}, {173, 193, 201}, {144, 173, 179},
 {91, 124, 141}, {84, 118, 130}, {76, 112, 121}, {66, 106, 112},
 {71, 104, 106}, {73, 104, 103}, {72, 101, 97}, {68, 91, 83},
 {46, 61, 68}, {39, 50, 52}, {36, 46, 39}, {34, 38, 28},
 {13, 19, 19}, {9, 18, 17}, {9, 20, 23}, {24, 34, 37},
 {34, 43, 42}, {42, 52, 54}, {70, 81, 71}, {73, 88, 81},
 {74, 96, 87}, {72, 95, 86}, {70, 90, 82}, {70, 84, 79},
 {44, 62, 67}, {29, 48, 54}, {30, 48, 52}, {32, 51, 58},
 {48, 63, 70}, {69, 91, 89}, {86, 108, 111}, {95, 124, 130},
 {181, 190, 150}, {224, 207, 189}, {250, 246, 219}, {255, 251, 224},
 {252, 250, 229}, {238, 243, 231}, {189, 212, 214}, {181, 203, 201},
 {174, 193, 194}, {129, 156, 154}, {92, 121, 120}, {69, 90, 80},
},
/* gris.landscape-ceret.ppm*/
{
 {16, 15, 9}, {38, 38, 25}, {74, 64, 42}, {102, 59, 39},
 {124, 79, 40}, {136, 91, 44}, {160, 94, 56}, {173, 80, 72},
 {182, 80, 70}, {210, 77, 71}, {209, 82, 67}, {202, 48, 38},
 {227, 88, 54}, {211, 102, 54}, {226, 127, 50}, {234, 143, 56},
 {238, 156, 65}, {228, 167, 71}, {189, 166, 79}, {133, 176, 107},
 {119, 153, 122}, {111, 145, 124}, {96, 138, 126}, {103, 124, 100},
 {99, 100, 94}, {78, 96, 107}, {69, 100, 132}, {64, 121, 173},
 {98, 165, 196}, {107, 165, 182}, {122, 172, 179}, {171, 201, 211},
 {189, 209, 209}, {201, 210, 207}, {210, 219, 205}, {196, 208, 204},
 {163, 189, 199}, {132, 166, 174}, {118, 138, 153}, {134, 115, 126},
 {168, 130, 107}, {180, 120, 108}, {181, 101, 112}, {209, 90, 97},
 {215, 92, 95}, {220, 95, 96}, {217, 98, 100}, {226, 98, 95},
 {228, 105, 92}, {232, 105, 88}, {229, 97, 83}, {224, 83, 73},
 {227, 88, 85}, {219, 100, 76}, {227, 105, 83}, {229, 106, 90},
 {224, 107, 98}, {226, 116, 103}, {226, 121, 114}, {215, 152, 155},
 {218, 168, 168}, {217, 172, 167}, {222, 177, 172}, {239, 183, 170},
 {239, 185, 167}, {226, 202, 144}, {252, 231, 99}, {252, 223, 89},
 {248, 218, 82}, {249, 200, 79}, {228, 191, 83}, {180, 160, 91},
 {136, 184, 126}, {112, 162, 130}, {113, 156, 132}, {111, 156, 135},
 {124, 161, 154}, {128, 163, 167}, {126, 154, 174}, {120, 141, 162},
 {98, 123, 138}, {101, 123, 131}, {100, 132, 109}, {100, 120, 96},
 {96, 110, 85}, {88, 94, 70}, {112, 87, 42}, {120, 85, 44},
 {128, 86, 56}, {139, 86, 54}, {159, 115, 62}, {177, 122, 52},
 {198, 127, 62}, {221, 146, 50}, {221, 160, 47}, {214, 166, 37},
 {234, 179, 32}, {248, 194, 35}, {253, 197, 34}, {252, 198, 35},
 {249, 196, 31}, {249, 195, 43}, {249, 165, 48}, {242, 150, 38},
 {241, 151, 32}, {242, 149, 36}, {241, 150, 35}, {237, 142, 33},
 {225, 139, 28}, {229, 140, 32}, {230, 133, 43}, {220, 126, 44},
 {223, 122, 32}, {221, 127, 29}, {214, 135, 33}, {207, 133, 39},
 {210, 144, 43}, {206, 140, 60}, {193, 141, 67}, {164, 143, 82},
 {129, 131, 69}, {109, 115, 58}, {90, 116, 69}, {85, 107, 68},
 {76, 79, 81}, {89, 93, 72}, {78, 85, 68}, {66, 71, 62},
 {56, 62, 58}, {48, 51, 51}, {36, 35, 24}, {25, 15, 16},
 {10, 13, 9}, {8, 7, 5}, {4, 2, 3}, {14, 13, 11},
 {16, 14, 15}, {19, 18, 15}, {20, 18, 19}, {28, 35, 24},
 {33, 34, 32}, {29, 38, 31}, {45, 56, 40}, {52, 57, 47},
 {58, 54, 43}, {57, 59, 46}, {60, 53, 49}, {62, 60, 58},
 {69, 68, 63}, {70, 80, 60}, {83, 81, 70}, {97, 87, 81},
 {112, 94, 86}, {116, 104, 83}, {129, 111, 73}, {130, 124, 55},
 {125, 120, 57}, {134, 112, 46}, {163, 121, 48}, {198, 142, 59},
 {205, 153, 76}, {218, 163, 137}, {212, 164, 160}, {208, 155, 162},
 {199, 126, 129}, {194, 113, 123}, {189, 121, 124}, {202, 126, 104},
 {196, 116, 69}, {198, 112, 35}, {199, 108, 31}, {207, 127, 39},
 {211, 131, 40}, {228, 140, 40}, {244, 160, 44}, {248, 194, 44},
 {253, 199, 40}, {253, 200, 35}, {253, 201, 37}, {254, 204, 41},
 {251, 205, 41}, {252, 206, 42}, {254, 211, 39}, {254, 206, 44},
 {253, 202, 44}, {249, 204, 53}, {246, 196, 59}, {241, 192, 54},
 {236, 172, 64}, {195, 164, 84}, {132, 187, 124}, {127, 189, 119},
 {115, 171, 106}, {111, 161, 95}, {103, 126, 95}, {97, 115, 89},
 {94, 112, 86}, {90, 108, 78}, {106, 107, 67}, {115, 94, 66},
 {104, 87, 59}, {100, 75, 56}, {92, 69, 49}, {85, 77, 61},
 {93, 85, 62}, {98, 89, 50}, {96, 71, 46}, {93, 74, 46},
 {87, 73, 43}, {79, 82, 63}, {69, 89, 69}, {69, 95, 62},
 {52, 86, 60}, {60, 84, 63}, {64, 86, 47}, {65, 71, 57},
 {69, 70, 50}, {76, 69, 49}, {74, 80, 52}, {72, 95, 61},
 {78, 105, 71}, {95, 123, 75}, {108, 138, 71}, {119, 138, 81},
 {152, 142, 139}, {201, 151, 162}, {215, 173, 175}, {218, 200, 175},
 {227, 228, 211}, {254, 251, 249}, {252, 252, 250}, {250, 252, 252},
 {228, 234, 230}, {219, 220, 216}, {237, 189, 172}, {253, 228, 97},
 {251, 218, 72}, {254, 213, 63}, {251, 211, 67}, {249, 214, 62},
 {251, 212, 56}, {252, 213, 52}, {253, 210, 46}, {254, 201, 44},
 {246, 191, 47}, {244, 164, 74}, {222, 170, 100}, {231, 157, 139},
 {214, 165, 166}, {213, 156, 162}, {198, 135, 148}, {178, 118, 131},
 {161, 106, 115}, {123, 76, 72}, {75, 68, 56}, {42, 42, 38},
},
/* kandinsky.comp-9.ppm*/
{
 {81, 31, 21}, {121, 26, 10}, {159, 21, 3}, {194, 57, 2},
 {216, 102, 0}, {215, 111, 0}, {215, 122, 1}, {220, 132, 2},
 {227, 148, 3}, {233, 167, 22}, {251, 191, 41}, {252, 194, 60},
 {253, 200, 72}, {225, 192, 103}, {216, 204, 135}, {224, 205, 153},
 {232, 201, 156}, {251, 210, 92}, {254, 207, 68}, {254, 191, 42},
 {248, 182, 7}, {231, 146, 2}, {225, 127, 2}, {221, 107, 0},
 {197, 62, 6}, {169, 26, 4}, {157, 35, 12}, {154, 76, 92},
 {162, 80, 100}, {173, 137, 99}, {141, 186, 121}, {146, 183, 127},
 {179, 183, 142}, {192, 170, 137}, {240, 177, 82}, {254, 198, 69},
 {254, 207, 68}, {254, 203, 65}, {252, 194, 62}, {251, 190, 56},
 {249, 181, 57}, {243, 169, 37}, {221, 129, 5}, {210, 110, 0},
 {195, 60, 4}, {167, 19, 1}, {129, 20, 3}, {96, 28, 20},
 {84, 30, 23}, {88, 33, 27}, {97, 29, 42}, {84, 35, 46},
 {92, 136, 115}, {90, 161, 127}, {125, 186, 117}, {143, 187, 118},
 {203, 172, 77}, {200, 138, 40}, {196, 115, 9}, {170, 51, 13},
 {123, 29, 7}, {106, 35, 13}, {92, 32, 18}, {92, 29, 17},
 {119, 28, 5}, {125, 30, 7}, {182, 57, 14}, {210, 109, 3},
 {218, 123, 10}, {237, 165, 27}, {235, 187, 61}, {215, 194, 103},
 {173, 197, 132}, {146, 197, 126}, {138, 195, 127}, {134, 194, 124},
 {137, 192, 130}, {149, 193, 134}, {178, 188, 138}, {200, 205, 141},
 {212, 205, 172}, {216, 213, 187}, {212, 217, 186}, {180, 205, 174},
 {157, 195, 166}, {112, 187, 178}, {103, 185, 183}, {95, 177, 181},
 {68, 160, 185}, {69, 166, 201}, {91, 173, 167}, {112, 172, 141},
 {129, 190, 123}, {131, 188, 123}, {128, 186, 116}, {121, 182, 107},
 {91, 149, 116}, {102, 34, 47}, {107, 34, 15}, {123, 28, 10},
 {170, 49, 11}, {214, 97, 1}, {217, 111, 0}, {222, 124, 3},
 {227, 141, 2}, {234, 157, 22}, {240, 176, 44}, {249, 194, 54},
 {250, 194, 60}, {252, 202, 64}, {254, 200, 63}, {253, 196, 67},
 {246, 192, 66}, {219, 182, 92}, {162, 192, 118}, {141, 188, 124},
 {133, 187, 123}, {136, 186, 121}, {137, 189, 128}, {132, 187, 132},
 {108, 176, 182}, {98, 183, 188}, {96, 185, 193}, {81, 171, 198},
 {67, 175, 209}, {68, 174, 204}, {81, 180, 196}, {94, 181, 171},
 {130, 192, 129}, {136, 186, 120}, {134, 118, 91}, {127, 53, 73},
 {94, 31, 50}, {85, 26, 44}, {81, 25, 40}, {81, 25, 36},
 {74, 29, 33}, {73, 29, 30}, {29, 41, 29}, {28, 38, 27},
 {11, 17, 13}, {5, 16, 11}, {10, 12, 8}, {12, 12, 10},
 {26, 18, 7}, {71, 26, 33}, {85, 30, 43}, {96, 81, 53},
 {86, 157, 121}, {127, 184, 120}, {145, 173, 143}, {163, 176, 159},
 {197, 184, 169}, {215, 198, 190}, {209, 202, 182}, {179, 201, 158},
 {155, 200, 143}, {139, 195, 127}, {134, 184, 113}, {148, 113, 77},
 {158, 36, 13}, {165, 15, 3}, {174, 4, 5}, {178, 5, 1},
 {181, 14, 1}, {162, 18, 3}, {131, 19, 0}, {119, 22, 5},
 {122, 28, 14}, {144, 95, 64}, {161, 147, 76}, {136, 184, 115},
 {138, 187, 118}, {151, 186, 112}, {213, 190, 86}, {235, 190, 72},
 {252, 203, 78}, {239, 213, 117}, {231, 214, 169}, {234, 218, 179},
 {228, 220, 181}, {210, 214, 170}, {160, 205, 149}, {148, 202, 142},
 {147, 200, 138}, {161, 198, 139}, {181, 200, 134}, {198, 195, 118},
 {234, 187, 70}, {241, 174, 51}, {230, 129, 18}, {227, 125, 3},
 {224, 121, 3}, {228, 119, 2}, {222, 123, 4}, {224, 125, 4},
 {223, 130, 1}, {229, 145, 1}, {232, 166, 29}, {219, 181, 69},
 {183, 183, 110}, {153, 193, 124}, {153, 201, 135}, {158, 203, 146},
 {188, 210, 164}, {206, 218, 197}, {202, 219, 203}, {200, 214, 201},
 {149, 193, 172}, {112, 192, 183}, {125, 194, 172}, {144, 192, 132},
 {166, 192, 126}, {213, 152, 98}, {213, 131, 14}, {218, 121, 7},
 {221, 113, 5}, {220, 111, 2}, {223, 117, 2}, {223, 117, 4},
 {222, 118, 1}, {218, 119, 1}, {218, 122, 0}, {217, 125, 1},
 {217, 134, 9}, {231, 160, 32}, {241, 171, 85}, {206, 186, 135},
 {230, 211, 173}, {227, 216, 188}, {227, 210, 192}, {230, 220, 195},
 {226, 221, 194}, {225, 219, 188}, {221, 218, 192}, {223, 227, 196},
 {219, 222, 207}, {207, 221, 204}, {216, 223, 196}, {215, 218, 189},
 {220, 218, 173}, {204, 191, 145}, {201, 135, 144}, {218, 142, 83},
 {196, 127, 22}, {202, 87, 2}, {163, 21, 0}, {124, 19, 1},
 {101, 32, 6}, {84, 47, 14}, {111, 120, 67}, {85, 155, 123},
 {89, 165, 129}, {83, 157, 124}, {70, 122, 117}, {78, 32, 40},
},
/* kandinsky.yellow-red-blue.ppm*/
{
 {8, 1, 9}, {18, 7, 12}, {41, 2, 17}, {56, 14, 26},
 {97, 18, 40}, {101, 48, 45}, {110, 76, 36}, {142, 112, 37},
 {125, 122, 42}, {118, 90, 40}, {110, 72, 34}, {104, 17, 29},
 {111, 23, 27}, {141, 41, 42}, {168, 88, 88}, {178, 116, 101},
 {156, 118, 128}, {138, 130, 114}, {139, 126, 99}, {132, 121, 90},
 {129, 120, 101}, {129, 118, 116}, {110, 100, 123}, {92, 69, 125},
 {85, 65, 116}, {98, 71, 105}, {130, 98, 74}, {137, 130, 54},
 {140, 128, 55}, {145, 118, 45}, {149, 123, 38}, {144, 128, 50},
 {158, 141, 56}, {172, 151, 55}, {159, 145, 47}, {171, 154, 58},
 {184, 153, 66}, {185, 154, 70}, {183, 155, 68}, {177, 163, 70},
 {174, 160, 66}, {168, 157, 71}, {172, 159, 65}, {168, 156, 68},
 {163, 155, 67}, {160, 147, 69}, {164, 151, 85}, {164, 153, 89},
 {162, 153, 91}, {156, 155, 98}, {155, 142, 108}, {158, 149, 97},
 {152, 149, 96}, {151, 147, 113}, {143, 137, 124}, {139, 128, 135},
 {128, 118, 135}, {119, 126, 142}, {115, 128, 147}, {116, 128, 154},
 {117, 109, 167}, {105, 110, 165}, {103, 139, 206}, {116, 143, 241},
 {118, 132, 242}, {128, 138, 243}, {135, 150, 243}, {148, 161, 244},
 {140, 151, 239}, {141, 160, 242}, {145, 155, 240}, {158, 145, 230},
 {161, 146, 223}, {144, 152, 223}, {158, 136, 227}, {170, 135, 216},
 {169, 146, 220}, {188, 165, 214}, {210, 179, 238}, {219, 192, 244},
 {233, 209, 245}, {236, 211, 243}, {218, 190, 245}, {191, 170, 246},
 {178, 158, 247}, {157, 144, 237}, {147, 128, 230}, {143, 125, 227},
 {103, 124, 233}, {100, 115, 200}, {102, 87, 192}, {75, 74, 148},
 {27, 54, 120}, {30, 45, 100}, {30, 39, 66}, {28, 37, 51},
 {33, 31, 33}, {32, 33, 37}, {39, 45, 51}, {40, 67, 94},
 {59, 52, 113}, {71, 66, 120}, {78, 66, 158}, {88, 66, 180},
 {107, 75, 215}, {120, 89, 216}, {125, 84, 226}, {132, 101, 228},
 {141, 107, 236}, {144, 113, 236}, {139, 108, 233}, {125, 104, 207},
 {110, 95, 198}, {133, 110, 177}, {155, 133, 166}, {168, 154, 171},
 {163, 149, 162}, {145, 134, 166}, {129, 132, 161}, {109, 121, 132},
 {96, 114, 122}, {86, 98, 124}, {67, 76, 117}, {56, 63, 104},
 {60, 58, 69}, {66, 35, 69}, {95, 25, 56}, {113, 29, 62},
 {144, 42, 79}, {157, 65, 100}, {129, 75, 130}, {98, 81, 181},
 {97, 85, 199}, {96, 61, 204}, {94, 59, 202}, {89, 57, 197},
 {85, 53, 196}, {92, 63, 190}, {94, 61, 197}, {90, 59, 188},
 {74, 45, 173}, {70, 43, 176}, {69, 40, 160}, {63, 36, 144},
 {31, 33, 99}, {20, 19, 67}, {19, 16, 48}, {17, 14, 39},
 {19, 20, 27}, {13, 9, 7}, {5, 2, 9}, {5, 0, 7},
 {4, 0, 6}, {1, 1, 3}, {1, 0, 2}, {3, 2, 2},
 {3, 4, 4}, {3, 2, 6}, {3, 1, 10}, {8, 6, 14},
 {22, 19, 32}, {34, 29, 31}, {34, 30, 30}, {42, 29, 38},
 {44, 26, 48}, {52, 37, 48}, {60, 56, 66}, {66, 66, 74},
 {67, 75, 95}, {128, 118, 104}, {155, 142, 109}, {168, 155, 126},
 {178, 163, 154}, {177, 167, 165}, {183, 170, 173}, {193, 175, 195},
 {201, 183, 220}, {214, 186, 227}, {215, 178, 232}, {219, 180, 240},
 {208, 180, 244}, {198, 175, 242}, {178, 171, 231}, {177, 160, 220},
 {182, 156, 210}, {184, 156, 207}, {186, 155, 207}, {181, 158, 187},
 {180, 159, 185}, {151, 141, 201}, {143, 130, 204}, {154, 126, 218},
 {147, 120, 232}, {148, 115, 236}, {158, 120, 237}, {158, 137, 235},
 {156, 139, 240}, {149, 152, 246}, {148, 157, 250}, {150, 160, 250},
 {163, 158, 254}, {182, 174, 250}, {181, 177, 239}, {175, 177, 235},
 {176, 167, 212}, {163, 149, 196}, {147, 149, 183}, {136, 140, 187},
 {120, 119, 174}, {126, 123, 191}, {145, 138, 187}, {139, 147, 196},
 {149, 129, 196}, {157, 132, 188}, {164, 93, 177}, {183, 94, 182},
 {185, 110, 174}, {183, 133, 144}, {158, 138, 149}, {166, 141, 158},
 {159, 147, 145}, {158, 150, 130}, {160, 155, 125}, {161, 156, 101},
 {168, 157, 80}, {175, 160, 75}, {187, 159, 70}, {192, 162, 64},
 {228, 195, 48}, {198, 165, 66}, {200, 174, 84}, {202, 169, 86},
 {220, 171, 90}, {216, 186, 60}, {211, 181, 92}, {211, 177, 96},
 {221, 172, 100}, {207, 178, 98}, {219, 186, 97}, {228, 203, 101},
 {225, 197, 113}, {223, 192, 148}, {213, 188, 149}, {209, 179, 151},
 {194, 163, 141}, {182, 166, 137}, {162, 152, 107}, {161, 150, 87},
 {159, 145, 65}, {158, 130, 56}, {138, 129, 75}, {125, 95, 54},
 {104, 70, 31}, {56, 19, 44}, {27, 9, 40}, {13, 2, 11},
},
/* klee.insula-dulcamara.ppm*/
{
 {23, 10, 4}, {63, 38, 27}, {144, 110, 85}, {148, 131, 73},
 {144, 136, 86}, {163, 131, 90}, {176, 146, 96}, {192, 163, 102},
 {193, 157, 114}, {193, 161, 130}, {193, 168, 147}, {181, 169, 156},
 {168, 169, 150}, {146, 160, 158}, {130, 147, 155}, {120, 159, 162},
 {121, 161, 146}, {112, 150, 152}, {87, 121, 142}, {92, 116, 138},
 {119, 138, 142}, {131, 142, 131}, {154, 158, 110}, {156, 154, 101},
 {171, 151, 99}, {170, 147, 84}, {166, 131, 76}, {152, 128, 75},
 {149, 122, 63}, {109, 83, 48}, {26, 8, 7}, {24, 6, 4},
 {19, 7, 6}, {17, 3, 2}, {9, 2, 2}, {4, 11, 6},
 {26, 20, 6}, {87, 117, 85}, {117, 151, 117}, {145, 138, 113},
 {143, 132, 87}, {129, 107, 66}, {28, 10, 7}, {22, 7, 8},
 {30, 15, 12}, {92, 111, 109}, {84, 117, 137}, {84, 111, 146},
 {110, 139, 153}, {126, 157, 141}, {153, 160, 132}, {151, 165, 120},
 {164, 171, 122}, {171, 167, 111}, {170, 169, 104}, {177, 149, 104},
 {186, 143, 93}, {176, 148, 77}, {160, 151, 65}, {175, 150, 75},
 {169, 141, 61}, {163, 108, 61}, {132, 86, 35}, {32, 9, 1},
 {34, 20, 5}, {128, 109, 56}, {159, 114, 78}, {177, 117, 83},
 {186, 129, 83}, {184, 131, 89}, {193, 134, 99}, {187, 149, 91},
 {192, 143, 100}, {199, 154, 108}, {201, 156, 119}, {201, 169, 121},
 {202, 174, 128}, {201, 178, 133}, {213, 183, 133}, {206, 179, 137},
 {210, 179, 137}, {219, 180, 138}, {219, 182, 133}, {216, 185, 134},
 {216, 185, 137}, {221, 184, 144}, {221, 193, 147}, {221, 192, 158},
 {219, 187, 159}, {221, 190, 165}, {221, 196, 167}, {220, 197, 172},
 {220, 200, 165}, {206, 196, 165}, {196, 191, 167}, {195, 184, 166},
 {192, 178, 167}, {166, 178, 173}, {160, 179, 167}, {158, 168, 161},
 {149, 165, 164}, {148, 164, 167}, {144, 170, 170}, {142, 165, 178},
 {121, 153, 171}, {113, 138, 160}, {94, 119, 147}, {89, 110, 140},
 {52, 49, 54}, {23, 10, 7}, {14, 5, 0}, {6, 1, 0},
 {9, 2, 1}, {19, 8, 7}, {26, 8, 6}, {54, 34, 14},
 {150, 122, 40}, {147, 148, 57}, {143, 149, 61}, {155, 145, 69},
 {176, 143, 69}, {194, 151, 66}, {199, 146, 64}, {197, 145, 60},
 {181, 145, 67}, {178, 139, 72}, {186, 142, 76}, {183, 147, 72},
 {185, 154, 80}, {190, 156, 84}, {191, 168, 99}, {175, 179, 104},
 {181, 168, 120}, {195, 169, 133}, {183, 174, 137}, {197, 165, 130},
 {206, 166, 126}, {211, 176, 133}, {209, 188, 136}, {215, 181, 133},
 {202, 184, 122}, {205, 197, 119}, {195, 192, 115}, {203, 190, 107},
 {210, 172, 110}, {212, 189, 110}, {207, 192, 106}, {191, 190, 101},
 {182, 186, 92}, {174, 183, 78}, {168, 179, 79}, {158, 175, 75},
 {157, 166, 69}, {145, 164, 64}, {129, 163, 91}, {94, 146, 106},
 {67, 58, 29}, {24, 11, 6}, {26, 9, 6}, {95, 79, 42},
 {121, 129, 96}, {146, 161, 92}, {166, 185, 88}, {172, 177, 82},
 {185, 184, 76}, {184, 187, 85}, {179, 177, 86}, {189, 175, 97},
 {203, 177, 100}, {199, 168, 110}, {211, 164, 112}, {208, 162, 123},
 {202, 166, 121}, {210, 164, 134}, {207, 167, 147}, {207, 169, 135},
 {207, 169, 130}, {214, 174, 125}, {210, 173, 122}, {205, 172, 125},
 {202, 178, 124}, {187, 178, 120}, {184, 182, 117}, {203, 187, 95},
 {209, 186, 94}, {217, 193, 101}, {213, 175, 93}, {208, 171, 87},
 {208, 165, 80}, {205, 158, 79}, {193, 160, 79}, {192, 162, 80},
 {203, 180, 85}, {199, 187, 82}, {217, 198, 90}, {220, 201, 98},
 {226, 204, 105}, {221, 190, 103}, {222, 200, 120}, {222, 191, 127},
 {234, 200, 134}, {222, 186, 122}, {221, 186, 133}, {219, 186, 135},
 {215, 185, 130}, {206, 189, 130}, {204, 185, 139}, {206, 183, 146},
 {200, 174, 144}, {202, 177, 146}, {193, 182, 150}, {187, 184, 154},
 {181, 174, 153}, {194, 184, 149}, {210, 178, 152}, {209, 181, 157},
 {216, 188, 146}, {214, 191, 146}, {216, 196, 147}, {223, 197, 151},
 {226, 198, 154}, {223, 207, 156}, {215, 203, 166}, {221, 204, 164},
 {222, 195, 177}, {237, 204, 177}, {223, 200, 171}, {230, 221, 187},
 {226, 219, 191}, {217, 208, 195}, {255, 250, 232}, {210, 201, 181},
 {217, 209, 167}, {230, 208, 161}, {227, 208, 158}, {224, 207, 153},
 {226, 202, 156}, {227, 196, 161}, {223, 191, 165}, {224, 190, 159},
 {219, 196, 162}, {215, 198, 163}, {212, 192, 167}, {211, 191, 160},
 {206, 196, 161}, {206, 195, 165}, {207, 186, 165}, {200, 190, 166},
 {199, 194, 160}, {198, 197, 143}, {179, 200, 141}, {171, 171, 130},
 {155, 147, 120}, {147, 135, 111}, {134, 114, 74}, {34, 16, 7},
},
/* nile.ppm*/
{
 {6, 39, 66}, {27, 62, 99}, {97, 68, 75}, {156, 67, 38},
 {216, 117, 3}, {235, 142, 3}, {254, 172, 3}, {250, 212, 163},
 {252, 231, 218}, {238, 226, 247}, {239, 229, 249}, {237, 221, 250},
 {220, 207, 244}, {203, 200, 243}, {198, 194, 235}, {198, 173, 212},
 {205, 162, 167}, {203, 138, 42}, {233, 145, 2}, {242, 148, 1},
 {250, 157, 6}, {215, 175, 140}, {203, 175, 195}, {190, 164, 195},
 {190, 148, 137}, {216, 135, 22}, {215, 125, 10}, {171, 102, 23},
 {129, 100, 47}, {121, 95, 144}, {128, 142, 174}, {173, 161, 221},
 {183, 170, 228}, {186, 173, 229}, {188, 175, 237}, {188, 180, 239},
 {191, 178, 242}, {191, 176, 241}, {195, 171, 230}, {193, 166, 240},
 {196, 167, 231}, {195, 168, 229}, {185, 164, 220}, {177, 160, 210},
 {137, 139, 141}, {134, 82, 60}, {141, 38, 18}, {116, 24, 1},
 {112, 16, 1}, {115, 28, 6}, {120, 61, 52}, {103, 73, 159},
 {64, 36, 166}, {29, 40, 175}, {24, 42, 167}, {8, 47, 170},
 {2, 38, 172}, {7, 34, 178}, {9, 48, 185}, {19, 54, 186},
 {23, 67, 194}, {40, 59, 185}, {52, 61, 183}, {65, 68, 191},
 {68, 70, 191}, {77, 86, 199}, {84, 89, 201}, {105, 106, 203},
 {114, 114, 223}, {178, 149, 221}, {193, 157, 211}, {211, 172, 164},
 {248, 158, 11}, {254, 165, 3}, {252, 172, 8}, {234, 191, 176},
 {219, 196, 207}, {212, 193, 216}, {207, 192, 219}, {205, 177, 227},
 {203, 179, 227}, {197, 183, 238}, {196, 189, 244}, {194, 184, 244},
 {200, 187, 245}, {205, 199, 251}, {213, 215, 251}, {217, 214, 254},
 {236, 233, 250}, {247, 232, 253}, {251, 238, 253}, {251, 242, 251},
 {252, 243, 251}, {251, 240, 252}, {243, 231, 251}, {233, 219, 231},
 {235, 212, 214}, {213, 182, 218}, {204, 164, 169}, {161, 110, 98},
 {115, 59, 43}, {119, 40, 3}, {124, 31, 5}, {132, 39, 8},
 {174, 73, 7}, {223, 128, 5}, {243, 157, 10}, {232, 179, 167},
 {224, 196, 210}, {239, 205, 211}, {241, 221, 218}, {234, 223, 238},
 {236, 225, 248}, {230, 217, 247}, {229, 206, 234}, {219, 205, 219},
 {214, 196, 210}, {215, 184, 163}, {246, 158, 7}, {249, 165, 3},
 {245, 160, 4}, {241, 146, 3}, {233, 137, 2}, {220, 122, 7},
 {161, 88, 51}, {153, 127, 130}, {172, 145, 194}, {191, 160, 214},
 {192, 164, 225}, {192, 162, 230}, {185, 159, 232}, {177, 156, 226},
 {144, 147, 223}, {98, 131, 220}, {81, 124, 214}, {64, 115, 203},
 {61, 117, 181}, {62, 111, 175}, {69, 106, 162}, {66, 106, 148},
 {49, 100, 154}, {25, 87, 150}, {30, 80, 145}, {13, 66, 130},
 {17, 70, 121}, {32, 80, 103}, {68, 82, 99}, {88, 34, 11},
 {105, 17, 6}, {106, 19, 3}, {119, 56, 31}, {114, 76, 83},
 {118, 101, 167}, {161, 150, 217}, {176, 172, 233}, {179, 177, 233},
 {176, 183, 242}, {171, 177, 238}, {168, 181, 241}, {177, 185, 242},
 {178, 188, 241}, {178, 190, 247}, {189, 196, 252}, {194, 208, 250},
 {203, 203, 243}, {197, 198, 244}, {196, 195, 243}, {192, 196, 244},
 {196, 193, 238}, {192, 187, 239}, {183, 191, 240}, {182, 190, 244},
 {188, 191, 224}, {185, 179, 224}, {185, 171, 210}, {171, 144, 177},
 {175, 129, 92}, {225, 138, 1}, {234, 140, 1}, {240, 146, 4},
 {245, 151, 6}, {219, 168, 138}, {193, 157, 206}, {173, 157, 219},
 {108, 123, 203}, {83, 122, 207}, {70, 127, 189}, {64, 116, 180},
 {61, 113, 168}, {56, 97, 158}, {30, 89, 142}, {35, 90, 128},
 {30, 89, 125}, {22, 77, 120}, {18, 68, 110}, {20, 55, 88},
 {93, 8, 6}, {100, 9, 3}, {118, 14, 1}, {136, 41, 6},
 {217, 113, 3}, {227, 137, 1}, {223, 132, 3}, {165, 99, 20},
 {144, 55, 30}, {127, 32, 6}, {116, 26, 6}, {112, 46, 44},
 {111, 71, 98}, {92, 93, 152}, {107, 110, 176}, {102, 115, 200},
 {110, 118, 213}, {146, 142, 222}, {173, 163, 224}, {182, 175, 229},
 {184, 179, 233}, {184, 177, 236}, {182, 172, 239}, {178, 170, 239},
 {174, 173, 237}, {170, 160, 225}, {108, 120, 218}, {98, 125, 210},
 {84, 119, 218}, {81, 121, 217}, {71, 123, 218}, {72, 115, 212},
 {79, 114, 208}, {87, 116, 206}, {87, 106, 203}, {85, 100, 202},
 {74, 92, 198}, {57, 90, 209}, {55, 95, 206}, {61, 88, 195},
 {61, 79, 186}, {51, 83, 194}, {33, 80, 195}, {32, 87, 198},
 {32, 90, 201}, {51, 104, 211}, {58, 102, 206}, {61, 106, 181},
 {62, 110, 178}, {72, 115, 165}, {73, 110, 160}, {75, 95, 155},
 {75, 96, 145}, {68, 91, 149}, {39, 96, 148}, {31, 81, 143},
 {29, 82, 137}, {23, 79, 121}, {25, 64, 120}, {17, 60, 100},
},
/* picasso.jfille-chevre.ppm*/
{
 {24, 0, 0}, {84, 2, 2}, {184, 46, 0}, {195, 61, 5},
 {198, 61, 2}, {203, 76, 3}, {207, 80, 3}, {211, 85, 3},
 {209, 84, 2}, {208, 79, 3}, {204, 73, 0}, {203, 61, 1},
 {201, 59, 4}, {199, 62, 3}, {202, 76, 3}, {205, 77, 7},
 {207, 85, 7}, {203, 93, 14}, {194, 90, 28}, {203, 102, 46},
 {204, 100, 40}, {183, 97, 38}, {185, 96, 28}, {151, 102, 51},
 {196, 102, 41}, {206, 119, 51}, {225, 142, 78}, {222, 148, 77},
 {228, 148, 76}, {220, 140, 77}, {199, 136, 70}, {208, 114, 43},
 {209, 108, 37}, {199, 124, 31}, {206, 127, 29}, {207, 130, 30},
 {205, 135, 30}, {208, 137, 32}, {214, 146, 36}, {218, 154, 55},
 {222, 162, 83}, {225, 184, 99}, {228, 197, 128}, {232, 202, 150},
 {227, 202, 163}, {237, 208, 172}, {239, 211, 172}, {241, 214, 173},
 {246, 218, 175}, {248, 219, 178}, {249, 220, 178}, {247, 223, 185},
 {252, 226, 180}, {252, 224, 187}, {250, 226, 191}, {249, 225, 189},
 {247, 224, 191}, {249, 226, 195}, {248, 225, 192}, {247, 227, 192},
 {247, 224, 193}, {245, 222, 193}, {244, 220, 186}, {243, 221, 184},
 {245, 220, 182}, {245, 216, 184}, {244, 215, 183}, {242, 216, 180},
 {239, 215, 179}, {238, 213, 175}, {237, 214, 172}, {238, 211, 162},
 {236, 206, 152}, {236, 204, 140}, {232, 199, 128}, {229, 179, 113},
 {229, 167, 97}, {225, 163, 93}, {223, 155, 82}, {210, 147, 85},
 {196, 126, 70}, {208, 104, 48}, {215, 101, 49}, {211, 111, 32},
 {205, 125, 18}, {214, 133, 14}, {214, 142, 15}, {215, 153, 44},
 {219, 168, 76}, {228, 184, 90}, {231, 188, 99}, {233, 194, 118},
 {241, 203, 124}, {235, 202, 135}, {236, 201, 133}, {237, 186, 120},
 {237, 176, 107}, {231, 171, 102}, {231, 168, 94}, {227, 167, 101},
 {225, 168, 119}, {212, 164, 105}, {232, 178, 119}, {244, 194, 131},
 {241, 206, 140}, {238, 208, 150}, {238, 210, 161}, {233, 208, 170},
 {233, 211, 169}, {237, 215, 173}, {241, 217, 177}, {243, 217, 181},
 {246, 218, 179}, {247, 221, 173}, {251, 223, 174}, {247, 220, 172},
 {247, 220, 169}, {243, 216, 161}, {245, 209, 144}, {242, 201, 137},
 {241, 201, 116}, {232, 187, 99}, {227, 160, 80}, {225, 145, 73},
 {217, 122, 51}, {213, 122, 33}, {204, 129, 21}, {200, 127, 20},
 {197, 121, 11}, {196, 117, 7}, {193, 109, 0}, {195, 120, 8},
 {197, 132, 18}, {209, 137, 27}, {218, 145, 31}, {220, 163, 56},
 {230, 186, 95}, {232, 193, 105}, {233, 200, 129}, {237, 207, 141},
 {245, 211, 150}, {242, 215, 158}, {242, 213, 164}, {236, 212, 171},
 {235, 211, 172}, {234, 212, 176}, {236, 214, 177}, {238, 213, 183},
 {238, 214, 179}, {227, 207, 181}, {240, 215, 182}, {242, 219, 182},
 {241, 221, 182}, {243, 221, 183}, {244, 220, 183}, {242, 218, 183},
 {240, 216, 190}, {242, 218, 191}, {246, 219, 195}, {245, 224, 198},
 {243, 226, 199}, {246, 228, 205}, {246, 226, 202}, {250, 230, 205},
 {250, 229, 206}, {248, 231, 205}, {250, 228, 197}, {248, 230, 194},
 {248, 228, 196}, {246, 227, 195}, {244, 224, 196}, {239, 223, 197},
 {236, 214, 193}, {237, 218, 188}, {240, 217, 186}, {239, 215, 181},
 {241, 212, 173}, {238, 211, 166}, {237, 212, 155}, {233, 206, 145},
 {235, 201, 134}, {220, 179, 120}, {212, 170, 121}, {206, 175, 108},
 {211, 162, 117}, {210, 156, 93}, {223, 154, 89}, {224, 158, 81},
 {228, 163, 81}, {234, 167, 90}, {237, 176, 104}, {240, 193, 127},
 {237, 204, 141}, {237, 206, 152}, {237, 208, 159}, {238, 212, 165},
 {241, 218, 170}, {240, 215, 171}, {244, 216, 170}, {246, 215, 160},
 {242, 213, 169}, {245, 210, 160}, {249, 215, 154}, {247, 212, 146},
 {251, 213, 137}, {245, 211, 137}, {239, 207, 146}, {235, 203, 151},
 {224, 201, 154}, {236, 202, 151}, {237, 203, 154}, {233, 206, 158},
 {239, 210, 166}, {238, 211, 169}, {240, 211, 167}, {242, 212, 168},
 {239, 212, 164}, {241, 211, 157}, {236, 208, 150}, {236, 205, 142},
 {235, 202, 139}, {231, 192, 122}, {227, 189, 102}, {226, 168, 88},
 {224, 159, 72}, {211, 144, 40}, {201, 136, 33}, {204, 132, 21},
 {205, 133, 16}, {208, 132, 14}, {205, 131, 10}, {204, 130, 9},
 {202, 120, 8}, {204, 124, 2}, {195, 119, 6}, {193, 117, 12},
 {205, 109, 27}, {213, 98, 30}, {203, 89, 27}, {207, 92, 29},
 {212, 95, 23}, {203, 90, 24}, {201, 89, 25}, {203, 90, 23},
 {202, 90, 20}, {204, 92, 16}, {203, 85, 11}, {189, 82, 5},
 {196, 80, 15}, {193, 78, 12}, {189, 68, 5}, {194, 78, 4},
 {183, 70, 2}, {182, 65, 9}, {147, 49, 11}, {42, 1, 3},
},
/* pollock.lavender-mist.ppm*/
{
 {3, 5, 2}, {37, 33, 23}, {65, 68, 36}, {96, 95, 63},
 {128, 112, 83}, {152, 127, 86}, {168, 141, 100}, {181, 155, 104},
 {183, 157, 111}, {179, 157, 119}, {175, 157, 121}, {175, 159, 122},
 {172, 157, 121}, {168, 154, 114}, {161, 149, 111}, {154, 140, 106},
 {150, 139, 107}, {149, 135, 103}, {144, 132, 102}, {140, 130, 104},
 {137, 128, 103}, {140, 124, 102}, {136, 126, 102}, {133, 124, 97},
 {135, 123, 94}, {137, 123, 96}, {140, 123, 94}, {142, 126, 98},
 {146, 125, 99}, {150, 136, 101}, {157, 145, 102}, {164, 146, 107},
 {172, 150, 121}, {172, 156, 126}, {180, 156, 123}, {196, 164, 119},
 {207, 171, 120}, {208, 174, 128}, {212, 181, 136}, {210, 187, 137},
 {209, 181, 131}, {206, 168, 129}, {203, 169, 127}, {196, 171, 121},
 {184, 166, 122}, {177, 156, 117}, {164, 146, 105}, {156, 131, 93},
 {136, 121, 89}, {121, 112, 82}, {105, 104, 75}, {102, 102, 77},
 {94, 90, 74}, {71, 76, 62}, {73, 77, 57}, {94, 90, 65},
 {108, 96, 66}, {111, 98, 71}, {110, 99, 81}, {115, 111, 86},
 {121, 114, 95}, {123, 114, 94}, {129, 117, 94}, {130, 120, 90},
 {130, 121, 90}, {130, 119, 86}, {130, 117, 81}, {125, 103, 68},
 {107, 88, 56}, {96, 84, 53}, {74, 62, 40}, {55, 48, 36},
 {41, 31, 29}, {40, 34, 24}, {37, 38, 25}, {42, 39, 28},
 {56, 49, 28}, {59, 57, 36}, {69, 73, 51}, {94, 80, 63},
 {99, 95, 79}, {106, 99, 80}, {118, 111, 85}, {126, 113, 92},
 {133, 123, 95}, {132, 128, 95}, {137, 132, 95}, {140, 133, 103},
 {141, 132, 104}, {142, 135, 106}, {144, 135, 109}, {148, 139, 112},
 {148, 142, 113}, {151, 146, 118}, {151, 144, 121}, {156, 145, 124},
 {152, 151, 130}, {147, 156, 130}, {150, 159, 134}, {158, 157, 132},
 {162, 158, 136}, {164, 160, 137}, {173, 165, 143}, {179, 171, 154},
 {189, 179, 155}, {194, 187, 161}, {192, 186, 164}, {188, 186, 158},
 {188, 180, 149}, {185, 177, 146}, {179, 167, 139}, {170, 164, 132},
 {167, 157, 129}, {162, 155, 126}, {155, 149, 120}, {158, 142, 119},
 {156, 142, 115}, {157, 147, 114}, {159, 148, 115}, {164, 152, 115},
 {167, 153, 123}, {169, 155, 129}, {173, 160, 131}, {176, 163, 130},
 {185, 172, 135}, {191, 181, 142}, {197, 185, 149}, {198, 188, 159},
 {202, 187, 160}, {207, 190, 156}, {212, 196, 152}, {212, 194, 155},
 {207, 193, 164}, {209, 196, 165}, {213, 197, 165}, {218, 194, 160},
 {215, 189, 152}, {207, 185, 152}, {200, 179, 150}, {197, 177, 145},
 {188, 170, 137}, {174, 160, 131}, {169, 157, 127}, {166, 162, 119},
 {155, 153, 116}, {147, 145, 108}, {145, 138, 114}, {139, 134, 114},
 {138, 132, 115}, {129, 133, 113}, {129, 128, 109}, {127, 130, 102},
 {119, 118, 93}, {119, 112, 87}, {114, 101, 77}, {114, 102, 72},
 {117, 106, 74}, {117, 111, 77}, {123, 116, 87}, {120, 115, 91},
 {126, 121, 92}, {134, 128, 92}, {145, 128, 90}, {149, 138, 97},
 {154, 140, 104}, {162, 138, 103}, {163, 137, 102}, {167, 143, 108},
 {167, 144, 111}, {172, 149, 118}, {175, 157, 121}, {177, 163, 122},
 {180, 166, 119}, {186, 167, 128}, {191, 174, 130}, {200, 173, 131},
 {201, 173, 132}, {192, 176, 136}, {188, 174, 141}, {189, 177, 143},
 {191, 172, 136}, {185, 166, 128}, {181, 161, 126}, {187, 157, 122},
 {194, 149, 113}, {182, 140, 94}, {166, 118, 76}, {131, 100, 61},
 {101, 81, 56}, {74, 70, 52}, {71, 56, 38}, {66, 55, 35},
 {58, 49, 32}, {69, 63, 49}, {77, 73, 56}, {94, 84, 71},
 {98, 97, 80}, {103, 103, 88}, {101, 117, 98}, {109, 143, 125},
 {138, 142, 122}, {138, 142, 121}, {145, 143, 123}, {155, 152, 128},
 {161, 158, 133}, {172, 159, 137}, {184, 169, 143}, {197, 178, 149},
 {201, 187, 146}, {206, 188, 152}, {215, 189, 147}, {213, 188, 135},
 {222, 181, 123}, {213, 181, 124}, {203, 163, 112}, {192, 153, 110},
 {185, 145, 99}, {177, 142, 106}, {168, 142, 105}, {162, 142, 105},
 {154, 139, 106}, {151, 135, 109}, {149, 136, 110}, {150, 137, 114},
 {151, 143, 120}, {158, 146, 122}, {167, 155, 130}, {181, 168, 134},
 {194, 182, 143}, {208, 186, 143}, {210, 200, 145}, {224, 198, 145},
 {225, 196, 150}, {229, 205, 161}, {243, 223, 174}, {245, 222, 183},
 {232, 211, 177}, {225, 208, 171}, {224, 219, 189}, {224, 217, 200},
 {222, 205, 186}, {207, 203, 169}, {203, 196, 156}, {196, 186, 157},
 {189, 178, 149}, {175, 164, 133}, {163, 157, 129}, {151, 151, 120},
 {141, 141, 112}, {132, 129, 104}, {121, 128, 106}, {100, 110, 94},
 {84, 88, 75}, {73, 69, 60}, {50, 56, 42}, {18, 19, 13},
},
/* yngpaint.ppm*/
{
 {20, 15, 10}, {52, 47, 45}, {20, 105, 104}, {63, 130, 123},
 {91, 144, 114}, {104, 140, 123}, {126, 141, 130}, {137, 151, 131},
 {160, 157, 128}, {170, 165, 126}, {182, 173, 128}, {188, 186, 129},
 {190, 192, 144}, {200, 204, 157}, {204, 205, 163}, {211, 209, 166},
 {212, 213, 167}, {216, 218, 171}, {219, 220, 174}, {221, 223, 173},
 {222, 224, 176}, {222, 224, 177}, {224, 224, 174}, {222, 222, 171},
 {221, 221, 167}, {220, 220, 164}, {219, 220, 160}, {217, 219, 154},
 {215, 218, 153}, {212, 211, 148}, {202, 203, 153}, {194, 194, 152},
 {185, 182, 141}, {171, 167, 129}, {165, 167, 121}, {166, 153, 113},
 {162, 134, 98}, {158, 140, 102}, {171, 158, 105}, {172, 163, 116},
 {165, 163, 117}, {175, 171, 107}, {179, 169, 111}, {187, 166, 130},
 {192, 187, 131}, {197, 193, 140}, {202, 201, 155}, {205, 207, 158},
 {210, 214, 155}, {211, 223, 162}, {220, 222, 163}, {226, 224, 166},
 {225, 222, 171}, {224, 224, 172}, {224, 224, 174}, {224, 226, 176},
 {225, 226, 182}, {225, 231, 185}, {225, 227, 177}, {227, 227, 175},
 {228, 227, 180}, {229, 231, 184}, {228, 234, 188}, {226, 232, 188},
 {228, 234, 190}, {229, 231, 192}, {228, 233, 191}, {227, 232, 192},
 {229, 234, 194}, {228, 233, 196}, {229, 233, 200}, {231, 235, 202},
 {233, 242, 214}, {244, 247, 219}, {236, 241, 210}, {238, 235, 204},
 {234, 238, 201}, {229, 236, 201}, {229, 234, 202}, {231, 236, 199},
 {234, 234, 196}, {233, 231, 191}, {233, 231, 190}, {229, 230, 188},
 {229, 229, 188}, {220, 224, 189}, {218, 222, 189}, {219, 223, 190},
 {220, 224, 188}, {220, 224, 187}, {222, 230, 183}, {224, 225, 181},
 {220, 226, 180}, {220, 226, 178}, {219, 226, 178}, {217, 226, 174},
 {218, 226, 172}, {220, 222, 172}, {221, 221, 171}, {223, 221, 169},
 {224, 221, 168}, {224, 219, 169}, {222, 218, 170}, {217, 219, 169},
 {216, 219, 165}, {216, 216, 162}, {213, 213, 161}, {205, 208, 157},
 {201, 199, 146}, {184, 184, 129}, {165, 164, 109}, {152, 146, 97},
 {143, 145, 89}, {137, 143, 95}, {145, 149, 111}, {126, 130, 101},
 {107, 137, 86}, {89, 115, 101}, {116, 115, 83}, {117, 115, 97},
 {122, 131, 115}, {115, 122, 105}, {108, 124, 125}, {133, 143, 104},
 {139, 144, 116}, {142, 154, 120}, {166, 172, 118}, {182, 187, 121},
 {195, 198, 119}, {206, 208, 146}, {212, 210, 145}, {212, 219, 154},
 {214, 218, 157}, {215, 217, 157}, {216, 217, 157}, {216, 217, 159},
 {215, 213, 159}, {212, 212, 162}, {205, 206, 162}, {203, 199, 162},
 {200, 200, 157}, {184, 185, 144}, {173, 166, 139}, {141, 155, 133},
 {114, 148, 132}, {99, 147, 140}, {90, 142, 146}, {110, 149, 142},
 {125, 157, 145}, {129, 146, 147}, {164, 165, 137}, {183, 186, 140},
 {200, 202, 161}, {203, 203, 170}, {204, 210, 173}, {205, 208, 177},
 {211, 210, 180}, {212, 215, 184}, {212, 214, 190}, {217, 217, 189},
 {219, 218, 187}, {217, 221, 189}, {221, 220, 190}, {221, 221, 195},
 {219, 222, 191}, {221, 225, 192}, {218, 221, 195}, {218, 222, 198},
 {218, 222, 197}, {215, 226, 194}, {218, 224, 190}, {218, 223, 183},
 {218, 224, 180}, {218, 224, 177}, {217, 224, 180}, {216, 221, 181},
 {216, 220, 183}, {213, 218, 183}, {213, 216, 185}, {213, 216, 184},
 {214, 213, 183}, {213, 210, 180}, {209, 213, 175}, {213, 215, 168},
 {216, 215, 168}, {216, 216, 166}, {215, 212, 165}, {214, 212, 163},
 {214, 214, 160}, {217, 217, 163}, {217, 217, 167}, {216, 218, 170},
 {218, 220, 173}, {221, 220, 174}, {222, 221, 175}, {221, 222, 179},
 {217, 224, 180}, {217, 221, 187}, {214, 220, 186}, {216, 219, 188},
 {216, 219, 188}, {218, 218, 190}, {220, 218, 192}, {214, 218, 190},
 {216, 219, 188}, {215, 218, 187}, {217, 216, 185}, {216, 215, 184},
 {216, 215, 184}, {217, 214, 184}, {216, 216, 184}, {217, 217, 183},
 {220, 221, 182}, {219, 219, 184}, {220, 220, 184}, {217, 222, 183},
 {217, 223, 179}, {215, 221, 176}, {213, 219, 175}, {215, 221, 173},
 {215, 222, 171}, {213, 222, 169}, {215, 222, 173}, {216, 222, 173},
 {219, 221, 174}, {216, 222, 174}, {215, 221, 175}, {215, 222, 178},
 {215, 220, 180}, {219, 219, 181}, {217, 216, 183}, {215, 214, 183},
 {211, 214, 181}, {206, 213, 173}, {201, 207, 161}, {202, 205, 148},
 {187, 186, 124}, {181, 172, 107}, {166, 158, 86}, {166, 138, 81},
 {162, 142, 87}, {150, 140, 75}, {136, 133, 68}, {132, 123, 66},
 {122, 117, 45}, {119, 92, 9}, {133, 113, 56}, {102, 96, 52},
 {99, 55, 50}, {116, 108, 66}, {74, 61, 7}, {75, 50, 24},
 {55, 41, 51}, {46, 43, 20}, {84, 9, 8}, {32, 3, 5},
},   

};

int get_cmap(int n, clrmap c, int cmap_len)
{
   int i, j;
   if (cmap_random == n)
      n = RAND_FUNC ();
   if (n < 0) n = 0;
   n = n % vlen(the_cmaps);
   for (i = 0; i < cmap_len; i++) {
      int ii = (i * 256) / cmap_len;
      for (j = 0; j < 3; j++)
	 c[i][j] = the_cmaps[n][ii][j] / 255.0;
   }
   return n;
}

/* rgb 0 - 1,
   h 0 - 6, s 0 - 1, v 0 - 1 */
void rgb2hsv(rgb, hsv)
   double *rgb; double *hsv;
 {
  double rd, gd, bd, h, s, v, max, min, del, rc, gc, bc;

  rd = rgb[0];
  gd = rgb[1];
  bd = rgb[2];

  /* compute maximum of rd,gd,bd */
  if (rd>=gd) { if (rd>=bd) max = rd;  else max = bd; }
         else { if (gd>=bd) max = gd;  else max = bd; }

  /* compute minimum of rd,gd,bd */
  if (rd<=gd) { if (rd<=bd) min = rd;  else min = bd; }
         else { if (gd<=bd) min = gd;  else min = bd; }

  del = max - min;
  v = max;
  if (max != 0.0) s = (del) / max;
             else s = 0.0;

  h = 0;
  if (s != 0.0) {
    rc = (max - rd) / del;
    gc = (max - gd) / del;
    bc = (max - bd) / del;

    if      (rd==max) h = bc - gc;
    else if (gd==max) h = 2 + rc - bc;
    else if (bd==max) h = 4 + gc - rc;

    if (h<0) h += 6;
  }

  hsv[0] = h;
  hsv[1] = s;
  hsv[2] = v;
}


/* h 0 - 6, s 0 - 1, v 0 - 1
   rgb 0 - 1 */
void hsv2rgb(hsv, rgb)
   double *hsv;
   double *rgb;
{
   double h = hsv[0], s = hsv[1], v = hsv[2];
  int    j;
  double rd, gd, bd;
  double f, p, q, t;

   while (h >= 6.0) h = h - 6.0;
   while (h <  0.0) h = h + 6.0;
   j = (int) floor(h);
   f = h - j;
   p = v * (1-s);
   q = v * (1 - (s*f));
   t = v * (1 - (s*(1 - f)));
   
   switch (j) {
    case 0:  rd = v;  gd = t;  bd = p;  break;
    case 1:  rd = q;  gd = v;  bd = p;  break;
    case 2:  rd = p;  gd = v;  bd = t;  break;
    case 3:  rd = p;  gd = q;  bd = v;  break;
    case 4:  rd = t;  gd = p;  bd = v;  break;
    case 5:  rd = v;  gd = p;  bd = q;  break;
    default: rd = v;  gd = t;  bd = p;  break;
   }

   rgb[0] = rd;
   rgb[1] = gd;
   rgb[2] = bd;
}

void
cmap2image(n, f)
   int n;
   FILE *f;
{
   int i;

   fprintf(f, "P3\n16 16\n# cmap %d\n255\n", n);
   for (i = 0; i < 256; i++)
      fprintf(f, "%d %d %d ",
	      the_cmaps[n][i][0],
	      the_cmaps[n][i][1],
	      the_cmaps[n][i][2]);
   fprintf(f, "\n");
}
   

#if 0
main(argc, argv)
   int argc;
   char **argv;
{
   int n = atoi(argv[1]);
   cmap2image(n, stdout);
}
#endif
