/* Exports from syscalls1.c. */

scheme_value wait_pid(int pid, int flags, int *result_pid, int *status);

int scheme_exec(const char *prog, scheme_value argv, scheme_value env);

int scheme_pipe(int *r, int *w);

char const *scm_readlink(const char *path);

int scm_utime(char const *path, int ac_hi, int ac_lo, int mod_hi, int mod_lo);

int scm_utime_now(char const *path);

int scheme_cwd(const char **dirp);

int process_times(int *utime, int *stime, int *cutime, int *cstime);

int cpu_clock_ticks_per_sec();

scheme_value read_fdes_char(int fd);

int write_fdes_char(char c, int fd);

int read_fdes_substring(scheme_value buf, int start, int end, int fd);

int read_stream_substring(scheme_value buf, int start, int end, FILE *f);

int write_fdes_substring(scheme_value buf, int start, int end, int fd);

int write_stream_substring(scheme_value buf, int start, int end, FILE *f);

int scheme_stat(const char *path, scheme_value vec, int chase_p);

int scheme_fstat(int fd, scheme_value vec);

int num_supp_groups(void);

int get_groups(scheme_value gvec);

int put_env(const char *s);

char** scm_envvec(int *len);

int install_env(scheme_value vec);

void delete_env(const char *var);

char *scm_gethostname(void);

char *errno_msg(int i);

int fcntl_read(int fd, int command);

int fcntl_write(int fd, int command, int value);
