#include "sysdep.h"

#include <sys/types.h>
#include <sys/time.h>
#if defined(HAVE_SELECT)
#  include <sys/types.h>	/* for FD_SET and friends (BSD) */
#if defined(HAVE_SYS_SELECT_H)
#  include <sys/select.h>
#endif
#endif
#include <unistd.h>
#include <time.h>
#include "../scheme48.h"

/* Sux because it's dependent on 32-bitness. */
#define hi8(i)  (((i)>>24) & 0xff)
#define lo24(i) ((i) & 0xffffff)
#define comp8_24(hi, lo) (((hi)<<24) + (lo))

/* Sleep until time hisecs/losecs (return #t),
** or until interrupted (return #f).
**
** We make you pass in an absolute time so that if you have to loop
** making multiple tries to sleep due to interrupts, you don't get
** drift.
**
** Posix sleep() is not too well defined. This one uses select(),
** and is pretty straightforward.
*/

scheme_value sleep_until(int hisecs, int losecs)
{
  time_t when = comp8_24(hisecs, losecs);
  time_t now = time(0);
  int delta = when - now;
  if( delta > 0 ) {
    fd_set r, w, e;
    struct timeval tv;
    tv.tv_sec = delta;
    tv.tv_usec = 0;
    FD_ZERO(&r);
    FD_ZERO(&w);
    FD_ZERO(&e);
    if( select(0, &r, &w, &e, &tv) ) return SCHFALSE;	/* Lose */
    }
  return SCHTRUE; /* Win */
  }
  
