;;; Interfaces and packages for the machine specific parts of scsh.
;;; This is a specific to CX/UX
;;; Copyright (c) 1994 by Olin Shivers. See file COPYING.
;;; Copyright (c) 1994 by Brian D. Carlstrom.

(define-interface cxux-fdflags-extras-interface
  (export open/no-delay
	  open/sync))

(define-interface cxux-errno-extras-interface
  (export errno/addrinuse
	  errno/addrnotavail
	  errno/adlinkstarted
	  errno/adnostatavail
	  errno/adnotconfigured
	  errno/adstatavail
	  errno/adv
	  errno/afnosupport
	  errno/already
	  errno/areq
	  errno/badcmp
	  errno/bade
	  errno/badfd
	  errno/badmsg
	  errno/badr
	  errno/badrqc
	  errno/badslt
	  errno/badspace
	  errno/bfont
	  errno/buflow
	  errno/bufok
	  errno/chnrst
	  errno/chrng
	  errno/comm
	  errno/connaborted
	  errno/connrefused
	  errno/connreset
	  errno/deadlock
	  errno/destaddrreq
	  errno/dotdot
	  errno/dquot
	  errno/fail
	  errno/hostdown
	  errno/hostunreach
	  errno/idlestop
	  errno/idrm
	  errno/inprogress
	  errno/iocancel
	  errno/isconn
	  errno/l2hlt
	  errno/l2nsync
	  errno/l3hlt
	  errno/l3rst
	  errno/libacc
	  errno/libbad
	  errno/libexec
	  errno/libmax
	  errno/libscn
	  errno/lidle
	  errno/lnkdwn
	  errno/lnkrst
	  errno/lnrng
	  errno/loop
	  errno/lubuf
	  errno/luinit
	  errno/lupubad
	  errno/lupudown
	  errno/msgsize
	  errno/mtimers
	  errno/multihop
	  errno/ndatreg
	  errno/netdown
	  errno/netreset
	  errno/netunreach
	  errno/noano
	  errno/nobufs
	  errno/nocsi
	  errno/nodata
	  errno/nolink
	  errno/nomsg
	  errno/nonet
	  errno/nopkg
	  errno/noprotoopt
	  errno/norfmode
	  errno/nosr
	  errno/nostr
	  errno/notblk
	  errno/notconn
	  errno/notsock
	  errno/notsup
	  errno/notuniq
	  errno/nrlock
	  errno/opnotsupp
	  errno/pagnv
	  errno/pfnosupport
	  errno/powerfail
	  errno/proclim
	  errno/proto
	  errno/protonosupport
	  errno/prototype
	  errno/puappl
	  errno/pubuf
	  errno/puludown
	  errno/reclos
	  errno/regstale
	  errno/rembsy
	  errno/remchg
	  errno/remote
	  errno/reopen
	  errno/restart
	  errno/rtryex
	  errno/sdaddr
	  errno/sdencode
	  errno/sdfrsize
	  errno/sdkbuf
	  errno/sdopen
	  errno/sdpu
	  errno/shutdown
	  errno/socktnosupport
	  errno/srmnt
	  errno/stale
	  errno/strpipe
	  errno/time
	  errno/timedout
	  errno/toomanyrefs
	  errno/txtbsy
	  errno/unatch
	  errno/users
	  errno/verr
	  errno/vovrfl
	  errno/xaratt
	  errno/xbadcom
	  errno/xbadfac
	  errno/xbadpac
	  errno/xbadpar
	  errno/xbadstate
	  errno/xbadwin
	  errno/xcaclr
	  errno/xcancel
	  errno/xcollin
	  errno/xdwas
	  errno/xexmax
	  errno/xforbid
	  errno/xfull
	  errno/xlncon
	  errno/xlnerr
	  errno/xlnop
	  errno/xlobnd
	  errno/xmit
	  errno/xmulrq
	  errno/xnatt
	  errno/xnfst
	  errno/xnoact
	  errno/xnofac
	  errno/xnone
	  errno/xnres
	  errno/xrange
	  errno/xrdexcd
	  errno/xtmout
	  errno/xwover))

(define-interface cxux-signals-extras-interface
  (export signal/cld
	  signal/iot))

(define-interface cxux-network-extras-interface
  (export socket/debug
	  socket/accept-connect
	  socket/reuse-address
	  socket/keep-alive
	  socket/dont-route
	  socket/broadcast
	  socket/use-loop-back
	  socket/linger
	  socket/oob-inline
	  socket/use-privileged
	  socket/cant-signal
	  socket/send-buffer
	  socket/receive-buffer
	  socket/send-low-water
	  socket/receive-low-water
	  socket/send-timeout
	  socket/receive-timeout
	  socket/error
	  socket/type
	  ip/options
	  ip/time-to-live
	  tcp/no-delay
	  tcp/max-segment))

(define-interface cxux-extras-interface
  (compound-interface cxux-errno-extras-interface
		      cxux-fdflags-extras-interface
		      cxux-network-extras-interface
		      cxux-signals-extras-interface))

(define-interface cxux-defs-interface
  (compound-interface cxux-extras-interface
		      sockets-network-interface
		      posix-errno-interface
		      posix-fdflags-interface
		      posix-signals-interface))

(define-structure cxux-defs cxux-defs-interface
  (open scheme bitwise defenum-package)
  (files fdflags errno signals netconst))

(define-interface os-extras-interface cxux-extras-interface)
(define os-dependent cxux-defs)
