; Copyright (c) 1993, 1994 Richard Kelsey and Jonathan Rees.  See file COPYING.


; Packages involved in building the initial system.


; Access to values from packages and structures 

(define-structure environments environments-interface
  (open scheme-level-2
	packages syntactic meta-types
	fluids
	locations	; contents
	signals)	; error
  (files (rts env)))

; EVAL and LOAD

(define-structure evaluation evaluation-interface
  (open scheme-level-2
	compiler
	packages        	;package-uid
	environments		;package-for-load
	closures		;make-closure
	vm-exposure		;invoke-closure
	scan			;noting-undefined-variables
	signals fluids)
  (files (rts eval)))

; Scheme = scheme-level-2 plus EVAL and friends

(define-module (make-scheme environments evaluation)
  (define-structure scheme scheme-interface
    (open scheme-level-2
	  environments
	  evaluation))
  scheme)


; Command processor.

(define-module (make-mini-command scheme) ;copied from debug-packages.scm
  (define-structure mini-command (export command-processor)
    (open scheme
	  signals conditions handle
	  display-conditions)
    (files (debug mini-command)))
  mini-command)


; For building systems.

(define-module (make-initial-system scheme command)

  (define-structure initial-system (export start)
    (open scheme
	  command
	  interfaces		;make-simple-interface
	  packages		;make-simple-package
	  environments		;with-interaction-environment, etc.
	  scheme-level-2-internal ;usual-resumer
	  conditions handle	;error? with-handler
	  signals)		;error
    (files (env start)))

  initial-system)


; Utility to load packages following dependency links (OPEN and ACCESS)

(define-structure ensures-loaded	;Cf. (link-initial-system) and Makefile
    (export ensure-loaded really-ensure-loaded)
  (open scheme-level-2
	packages
	packages-internal
	evaluation		;load
	filenames
	signals
	environments		;with-interaction-environment
	scan)			;scan-structures
  (files (env load-package)))


; Things needed by the expression generated by REIFY-STRUCTURES.

(define-structure for-reification for-reification-interface
  (open scheme-level-1
	packages packages-internal
	syntactic usual-macros
	meta-types			;sexp->type
	interfaces			;make-simple-interface
	inline
	tables)
  (files (bcomp for-reify)))
