/***************************************************************************
                          ryesnodialog.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** ryesnodialog.cpp 1998/09/03 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include <qlabel.h>
#include <qlayout.h>
#include <qkeycode.h>
#include <qpushbutton.h>

#include "rlog.h"
#include "rprgdef.h"
#include "ryesnodialog.h"

// Constructor:
//
RYesNoDialog::RYesNoDialog(const QString& _label, 
                           const QString& _but1,
                           const QString& _but2,
                           QWidget* _parent, 
                           const char* _name)
  :QDialog(_parent, _name, true, WStyle_NormalBorder)
{
  setFixedSize(256, 110);

  setCaption(DEF_APPNAME);
  
  QGridLayout* gl = new QGridLayout(this, 2, 2, 8);
  gl->setRowStretch(0, 7);
  gl->setRowStretch(1, 2);
  
  lText = new QLabel(_label, this, "ltext");
  lText->setAlignment(AlignCenter|AlignVCenter);
  gl->addMultiCellWidget(lText, 0, 0, 0, 1);
 
  bBut1 = new QPushButton(_but1, this);
  connect(bBut1, SIGNAL(clicked()), SLOT(accept()));
  bBut1->setAccel(Key_Return);
  gl->addWidget(bBut1, 1, 0);

  bBut2 = new QPushButton(_but2, this);
  connect(bBut2, SIGNAL(clicked()), SLOT(reject()));
  bBut2->setAccel(Key_Escape);
  gl->addWidget(bBut2, 1, 1);
  
  if(lText->sizeHint().width()+20>width()   ||
     lText->sizeHint().height()+40>height()    ) {
    setFixedSize(lText->sizeHint().width()+20, 
                 lText->sizeHint().height()+40);
  }
}



// Destructor:
//
RYesNoDialog::~RYesNoDialog()
{

}


// EOF



