/***************************************************************************
                          rsetupedgedecdlg.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/****************************************************************************
** rsetupedgedecdlg.h 1998/09/03 A. Mustun RibbonSoft 
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#ifndef RSETUPEDGEDECDLG_H
#define RSETUPEDGEDECDLG_H

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qdialog.h>

class QLabel;
class RGraphic;

/*! Dialog for setting up the edge deceleration (CAM)
*/
class RSetupEdgeDecDlg : public QDialog
{
  Q_OBJECT
public:
  /*! Constructor:
      \param _parent The parent widget
      \param _name  Name
  */
  RSetupEdgeDecDlg( RGraphic* _graphic,
                    QWidget* _parent=0,
                    const char* _name=0 );
  /*! Destructor
  */
  ~RSetupEdgeDecDlg();

  /** Show and initialize */
  virtual void show();

  /** Initialize */
  void init();

  /** Save values to graphic */
  void saveValues();

protected slots:
  /*! OK (SLOT for OK-Button) */
  void accept();



private:
  /*! Comboboxes */
  QComboBox* cbLength;
  QComboBox* cbSteps;
  QComboBox* cbReduction;
  QComboBox* cbMinAngle;
  
  QCheckBox* ckbDecBegin;
  QCheckBox* ckbDecEnd;
  QCheckBox* ckbDecContBegin;
  QCheckBox* ckbDecContEnd;

  QPushButton* bOk;
  QPushButton* bCancel;

  RGraphic*  graphic;
    
};


#endif

// EOF

