/***************************************************************************
                          rlistview.h  -  description
                             -------------------
    begin                : Sun Sep 12 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RLISTVIEW_H
#define RLISTVIEW_H

#include <qlistview.h>
#include <qstring.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qtimer.h>
#include <qpopupmenu.h>

class QWidget;

/**
 * An item in the project view.
 */
class RListViewItem : public QListViewItem
{
public:
  RListViewItem( QListView *_parent, const QString& _label, bool _open=false, int _id=-1 );
  RListViewItem( RListViewItem *_parent, const QString& _label, bool _open=false, int _id=-1 );

  QString getFullPath( void );
  QString text( int column ) const;

  QString getLabel() const { return label; }

  void setOpen( bool o );
  void setup();

  void setId( int _id ) { id = _id; }
  int  getId() { return id; }

private:
  RListViewItem* p;
  QString label;
  QString object;
  int id;
};


class RListView : public QListView
{
  Q_OBJECT

public:
  RListView( QWidget *parent = 0, const char *name = 0 );

  virtual QSize minimumSizeHint () const;

signals:
  void folderSelected( const QString & );

protected slots:
  void slotFolderSelected( QListViewItem *_e );

private:
  QString fullPath(QListViewItem* _item);

};

#endif






