/***************************************************************************
                          rlayer.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/****************************************************************************
** rlayer.h 1998/09/05 A. Mustun RibbonSoft 
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#ifndef RLAYER_H
#define RLAYER_H

#define Y_VISIBLE    1       // Layer is visible
#define Y_USED       2       // Layer is used
#define Y_CONV       4       // Layer is already converted

#include <qstring.h>
#include <qcolor.h>

#include "rflags.h"

class RGraphic;

class RLayer : public RFlags
{
public:
  RLayer();
  ~RLayer();

  void  setName(const QString& _name) { name=_name; }
  QString getName() { return name; }
  QString getStringName() { return name; }
  void  setNumber(int _number) { number=_number; }
  int   getNumber() { return number; }
  QColor getColor() { return color; }
  void setColor(QColor _c) { color=_c; }
  int getWidth() { return width; }
  void setWidth(int _w) { width=_w; }
  Qt::PenStyle getStyle() { return style; }
  void setStyle(Qt::PenStyle _s) { style=_s; }

private:
  QString name;     // Name of layer (show in layer list)
  int     number;   // Number of layer (el->layer)
  QColor color;        // Color of the layer
  int width;           // Line-width of the layer
  Qt::PenStyle style;  // Line-style of the Layer

};


#endif

// EOF



