/***************************************************************************
                          rinputdialog.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rinputdialog.cpp 1998/09/03 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include <qkeycode.h>
#include <qlabel.h>
#include <qpushbutton.h>

#include "rcombobox.h"
#include "rgraphic.h"
#include "rlineedit.h"
#include "rinputdialog.h"
#include "rlog.h"
#include "rprgdef.h"

// Constructor for a textline input:
//
RInputDialog::RInputDialog(const QString& _label, 
                           int _maxLen,
                           const QString& _default, 
                           QWidget* _parent, 
                           const char* _name)
  :QDialog(_parent, _name, true, WStyle_NormalBorder)
{
  cInput=0;
  
  createStaticElements(_label);

  eInput = new RLineEdit(this, "einput");
  if(_default) eInput->setText(_default);
  eInput->setGeometry(75, 42, width()-150, 20);
  eInput->setMaxLength(_maxLen);
  eInput->setFocus();
}



// Constructor for a combobox input
//   Label (Message)
//   Max length for input
//   Default value
//   Typ of combobox ('l'=Layer)
//   Parent widget
//
RInputDialog::RInputDialog(const QString& _label,
                           const QString& _default, 
                           char _typ,
                           bool _rw,
                           RGraphic* _graphic,
                           QWidget* _parent, 
                           const char* _name)
  :QDialog(_parent, _name, true, WStyle_NormalBorder)
{
  eInput=0;
  createStaticElements(_label);
  
  cInput = new RComboBox(_rw, this, "cinput");
  if(_default) cInput->setEditText(_default);
  cInput->setGeometry(75, 42, width()-150, 20);
  cInput->setFocus();
  
  switch(_typ) {
  
    // Fill in Layers:
    //
    case 'l':
      if(_graphic) cInput->fillInLayers(_graphic, false);
      break;
      
    default:
      break;
  }
}


// Destructor:
//
RInputDialog::~RInputDialog()
{

}



// Create elements which are the same for all input dialogs:
//
void
RInputDialog::createStaticElements(const QString& _label)
{
  setCaption(DEF_APPNAME);

  setFixedSize(DEF_INPUTDLG_WIDTH, DEF_INPUTDLG_HEIGHT);

  lText = new QLabel(_label, this, "ltext");
  lText->setAlignment(AlignCenter);
  
  if(lText->sizeHint().width()+20>DEF_INPUTDLG_WIDTH) {
    setFixedWidth(lText->sizeHint().width()+20);
  }
  
  if(lText->sizeHint().height()+70>DEF_INPUTDLG_HEIGHT) {
    setFixedHeight(lText->sizeHint().height()+70);
  }
  
  lText->setGeometry( 10, 10, width()-10, 30 );
 
  bOk = new QPushButton( tr("Ok"), this );
  bOk->setGeometry( width()-150, 80, 70, 20 );
  bOk->setAccel( Key_Return );
  connect( bOk, SIGNAL(clicked()), SLOT(accept()) );
  
  bCancel = new QPushButton( tr("Cancel"), this );
  //bCancel->setGeometry( 10+(width()-20)/3, 80, (width()-20)/3, 20 );
  bCancel->setGeometry( width()-80, 80, 70, 20 );
  bCancel->setAccel( Key_Escape );
  connect( bCancel, SIGNAL(clicked()), SLOT(reject()) );

  /*
  bHelp = new QPushButton(tr("Help"), this);
  bHelp->setGeometry(10+(width()-20)/3*2, 80, (width()-20)/3, 20);
  bHelp->setAccel(Key_F1);
  */
}



// Get the user input:
//
QString
RInputDialog::getInput()
{
  if(eInput) {
    return eInput->text();
  }
  else {
    if(cInput) {
      return cInput->currentText();
    }
    else {
      return "";
    }
  }
}



// EOF

