/***************************************************************************
                          rinfowidget.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rinfowidget.cpp 1998/09/23 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
        Last change:  A    10 Dec 1998   10:06 am
*****************************************************************************/

#include "rinfowidget.h"

#include <qdatetime.h>
#include <qfileinfo.h>
#include <qlabel.h>
#include <qtooltip.h>

#include "rgraphic.h"
#include "rlog.h"

// Constructor:
//
RInfoWidget::RInfoWidget(QWidget* _parent, 
                         const char* _name, 
                         WFlags _f)
:RWidget(_parent, _name, _f)
{
  graphic=0;

  valid=false;

  //setFrameStyle(WinPanel|Raised);
  //setFrameStyle(Panel|Sunken);
  setFrameStyle(WinPanel|Sunken);
  setLineWidth(1);

  lPath = new QLabel(tr("Path:"), this, "lpath");
  QToolTip::add(lPath, tr("Path and File name of the loaded file"));
  path  = new QLabel("", this, "path");

  lCreation = new QLabel(tr("Creation:"), this, "lcreation");
  QToolTip::add(lCreation, tr("Date/Time of creation"));
  creation  = new QLabel("", this, "creation");

  lSize = new QLabel(tr("Size:"), this, "lsize");
  QToolTip::add(lSize, tr("File size in Bytes"));
  size  = new QLabel("", this, "size");

  lObjects = new QLabel(tr("Objects:"), this, "lobjects");
  QToolTip::add(lObjects, tr("Number of objects in the graphic"));
  objects  = new QLabel("", this, "objects");

  lTotalWay = new QLabel(tr("Total Way:"), this, "ltotalway");
  QToolTip::add(lTotalWay, tr("Total way in graphic"));
  totalWay  = new QLabel("", this, "totalway");

  lCuttingWay = new QLabel(tr("Cutting Way:"), this, "lcuttingway");
  QToolTip::add(lCuttingWay, tr("Cutting way in graphic (Total way minus Rapidmove)"));
  cuttingWay  = new QLabel("", this, "cuttingway");
                             
}



// Destructor:
//
RInfoWidget::~RInfoWidget()
{

}



// Show info widget:
//
void 
RInfoWidget::show()
{
  RWidget::show();
  
  if(!valid) updateInfo();
}



// Resize event:
//
void 
RInfoWidget::resizeEvent(QResizeEvent* _ev)
{
  RWidget::resizeEvent(_ev);
  resizeChildren();
}



// Resize the children:
//
void
RInfoWidget::resizeChildren()
{
  int ly=5;
  
  if(lPath)       lPath->setGeometry(10, ly, 85, 15);
  if(path)        path-> setGeometry(105, ly, width()-115, 15);
  ly+=16;
  if(lCreation)   lCreation->setGeometry(10, ly, 65, 15);
  if(creation)    creation-> setGeometry(105, ly, width()-115, 15);
  ly+=16;
  if(lSize)       lSize->setGeometry(10, ly, 85, 15);
  if(size)        size-> setGeometry(105, ly, width()-115, 15);
  ly+=16;
  if(lObjects)    lObjects->setGeometry(10, ly, 85, 15);
  if(objects)     objects-> setGeometry(105, ly, width()-115, 15);
  ly+=16;
  if(lTotalWay)   lTotalWay->setGeometry(10, ly, 85, 15);
  if(totalWay)    totalWay-> setGeometry(105, ly, width()-115, 15);
  ly+=16;
  if(lCuttingWay) lCuttingWay->setGeometry(10, ly, 85, 15);
  if(cuttingWay)  cuttingWay-> setGeometry(105, ly, width()-115, 15);

  updateInfo(false);
  
}



// Set the pointer to a graphic and update the layers:
//
void 
RInfoWidget::setGraphic(RGraphic* _graphic) 
{ 
  graphic=_graphic;
  valid=false;
  if(graphic) updateInfo();
}



// Update the graphic info:
//   only if the info widget is visible
//
// _values: true:  update also values
//          false: update only layout
//
void 
RInfoWidget::updateInfo(bool _values)
{
  RLOG( "\nRInfoWidget::upateInfo():" );

  // Update only if visible:
  //
  if(isVisible() && graphic && !graphic->getFileName().isEmpty()) {

    QFileInfo fi(graphic->getFileName());
    QDate     fd(fi.lastModified().date());
    QTime     ft(fi.lastModified().time());
    QString   str;

    if(path) {
      if(fi.exists()) {
        str=fi.absFilePath();
        path->setText(str);
        while(str.length()>3 && path->sizeHint().width()>path->width()) {
          str.remove(0, 1);
          str[0]='.';
          str[1]='.';
          path->setText(str);
        }
      }
      else {
        path->setText("-");
      }
    }

    if(creation && _values) {
      if(fi.exists()) {
        str = QString("%1 / %2")
	                  .arg(fd.toString())
                      .arg(ft.toString());
        creation->setText(str);
      }
      else {
        creation->setText("-");
      }
    }

    if(size && _values) {
      if(fi.exists()) {
        str.sprintf("%d Bytes", fi.size());
        size->setText(str);
      }
      else {
        size->setText("-");
      }
    }
    if(objects && _values) {
      str.sprintf("%d", graphic->count());
      objects->setText(str);
    }
    if(totalWay && _values) {
      str.sprintf("%.3f %s", graphic->getTotalWay(), mtGetSignForUnit( graphic->getUnit() ).latin1() );
      totalWay->setText(str);
    }
    if(cuttingWay && _values) {
      str.sprintf("%.3f %s", graphic->getCuttingWay(), mtGetSignForUnit( graphic->getUnit() ).latin1() );
      cuttingWay->setText(str);
    }

    repaint();
    if(_values) valid=true;
  }

  // It's not visible / update later:
  //
  else {
    valid=false;
  }
}

// EOF

