#include "rfileeps.h"
#include "rappwin.h"
#include "rfilebase.h"
#include "rfonts.h"
#include "rgraphic.h"
#include "rconfig.h"
#include "rlog.h"
#include "rmath.h"
#include "rprgdef.h"
#include "rstring.h"
#include "rstatuspanel.h"

// Constructor:
//
RFileEps::RFileEps(const QString& _name, RGraphic* _graphic)
  :RFileBase(_name)
{
  graphic=_graphic;
  lineWidthFactor=4;
}



// Destructor:
//
RFileEps::~RFileEps()
{
  
}



// load an eps file (NOT IMPLEMENTED):
//
bool
RFileEps::load(bool add)
{
  if(readFileInBuffer()) {
    separateBuf();
    return readFromBuffer(add);
  }
  else {
    return false;
  }
}



// read an eps file from buffer (NOT IMPLEMENTED):
//
bool
RFileEps::readFromBuffer(bool /* add */)
{
  RLOG( "\nEPS: Read from buffer" );

  return false;
}



// save an eps file:
//
bool
RFileEps::save()
{
  RLOG( "\nRFileEps::save()" );

  bool ret;             // returned value
  int i;                // counter
  RLayer* lay;          // Pointer to a layer in the graphic
  RElement *el;         // pointer which walks through elements
	double factor = 10.0/0.35;  // Factor for EPS format output - Note
	                            // that we scale by 0.1 for better accuracy.

  bool ok;
  lineWidthFactor = RCONFIG->getSettingInt("EPS:LineWidthFactor", &ok);
  if(!ok || lineWidthFactor<=0) lineWidthFactor=4;

  statusPanel()->iniProgress(graphic->count(), QObject::tr("Saving File..."));

  fPointer = fopen(name(), "wt");
  if(fPointer!=NULL) {

    // Write EPS-header:
    
    // HEADER:
    //
    double lb, tb, rb, bb;
    graphic->getBorders(lb, tb, rb, bb);
    fprintf(fPointer,
            "%%!PS-Adobe-2.0 EPSF-1.2\n"
            "%%%%Title: drawing\n"
            "%%%%Creator: %s %s\n"
            //"%%%%CreationDate: 8/1/1990\n"
            "%%%%Pages: 1\n"
            //"%%%%DocumentFonts: (atend)\n"
            "%%%%BoundingBox: %d %d %d %d\n"
            "%%%%EndComments\n"
            "%%%%EndProlog\n"
            "%.2f %.2f scale\n",
            DEF_APPNAME, DEF_VERSION, 
            mtRound(lb*factor/10.0), 
            mtRound(bb*factor/10.0), 
            mtRound(rb*factor/10.0), 
            mtRound(tb*factor/10.0),
            0.1, 0.1);
    fflush( fPointer );

    // ELEMENTS:
    //
    for(el=graphic->elementFirst(); el!=0; el=graphic->elementNext()) {
      //if(el->getFlag(E_VISIBLE)) {   // Save elements on invisible layers too!!
      if(el->getFlag(E_ACTIVE) && !el->getFlag(E_UNDO)) {

        statusPanel()->setProgress(graphic->elementAt(), 200);

				writeElement(el, fPointer, factor);
      }
    }

    RLOG( "\nEPS saved" );

    // EPS-End:
    //
    fprintf(fPointer, "showpage\n");
  
    fclose(fPointer);

    RLOG( "\nEPS closed" );

    statusPanel()->delProgress();

    RLOG( "\nstatusPanel()->delProgress() done" );

    ret=true;
  }
  else {
    ret=false;
  }

  RLOG( "\nReturn" );

  return ret;
}


void
RFileEps::writeElement(RElement* el, FILE* fp, double factor)
{
  switch(el->getElementTyp()) {
        
  // Point:
  //
  case T_POINT:
    // NOT IMPLEMENTED
    break;
            
    // Line:
    //
    case T_LINE:
      fprintf(fp, "%.1f setlinewidth\n", (float)el->getWidth()*lineWidthFactor);
      fprintf(fp, "%d %d moveto\n", mtRound(el->getX1()*factor), mtRound(el->getY1()*factor));
      fprintf(fp, "%d %d lineto\n", mtRound(el->getX2()*factor), mtRound(el->getY2()*factor));
      fprintf(fp, "stroke\n");
      fflush( fp );
      break;

    // Arc:
    //
    case T_ARC:
		  fprintf(fp, "%.1f setlinewidth\n", (float)el->getWidth()*lineWidthFactor);
      fprintf(fp, "%d %d %d %d %d %s\n", mtRound(el->getCx()*factor), mtRound(el->getCy()*factor), 
                                         mtRound(el->getCr()*factor), 
                                         (int)el->getA1(), (int)el->getA2(), 
                                         (el->getFlag(E_REVERSED) ? "arcn" : "arc"));
      fprintf(fp, "stroke\n");
      fflush( fp );
      break;

    case T_CIRCLE:
		  fprintf(fp, "%.1f setlinewidth\n", (float)el->getWidth()*lineWidthFactor);
      fprintf(fp, "%d %d %d %d %d %s\n", mtRound(el->getCx()*factor), mtRound(el->getCy()*factor), 
                                         mtRound(el->getCr()*factor), 
                                         0, 360, 
                                         "arc");
      fprintf(fp, "stroke\n");
      fflush( fp );
      break;

    // Text:
    //
    case T_TEXT:
    case T_DIMENSION:
    case T_HATCH:
			if(true) {
			  RGraphic tmpGr;
				RElement* el2;
				tmpGr.singleElements(el,
				                     true,
				                     false,
				                     0,
				                     false,
				                     0, 0, 0, 0,
				                     false,
				                     false);
				for(el2=tmpGr.elementFirst(); el2!=0; el2=tmpGr.elementNext()) {
          writeElement(el2, fp, factor);
			  }
			}
      break;

    default:
      break;
  }
}


// EOF



















































