
/*
    xskat - a card game for 1 to 3 players.
    Copyright (C) 2000  Gunter Gerhardt

    This program is free software; you can redistribute it freely.
    Use it at your own risk; there is NO WARRANTY.

    Redistribution of modified versions is permitted
    provided that the following conditions are met:
    1. All copyright & permission notices are preserved.
    2.a) Only changes required for packaging or porting are made.
      or
    2.b) It is clearly stated who last changed the program.
         The program is renamed or
         the version number is of the form x.y.z,
         where x.y is the version of the original program
         and z is an arbitrary suffix.
*/

#define TEXT_C

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "defs.h"
#include "text.h"

#define VERSION   " X S K A T   3.3 "
#define COPYRIGHT "Copyright 2000  Gunter Gerhardt"
#define EMAIL     "(gerhardt@draeger.com)"
#define HOMEPAGE  "XSkat Home Page"
#define URL       "http://www.gulu.net/xskat/"

static char *ger_text[]={
  "Null","Karo","Herz","Pik","Kreuz","Grand","Ramsch",
  "As","10","Knig","Dame","Bube","9","8","7",
  " A"," 10"," K"," D"," B"," 9"," 8"," 7",
  "Schellen","Rot","Grn","Eicheln",
  "As","10","Knig","Ober","Unter","9","8","7",
  " A"," 10"," K"," O"," U"," 9"," 8"," 7",
  "Hand gespielt","Schneider angesagt","Schwarz angesagt",
  "Ouvert gespielt","Ouvert Hand gespielt",
  "Passe","Ja","Nein","Spieler%d","Computer","links","rechts",
  "Drcken","spielt ","ouvert Hand","ouvert","Hand","Ouvert",
  "berlegt","Gereizt bis: %d","Lschen"," spielte ",
  "Gewonnen"," gewann ","Verloren"," verlor ","%d Augen",
  "berreizt !","Gegner nicht Schneider !","Gegner nicht schwarz !",
  "Eine Jungfrau !","Durchmarsch !",
  "Niemand","gewinnt","verliert","den Ramsch",
  "das Nullspiel.","das Spiel schwarz !","mit %d zu %d Augen.",
  " Hand ? "," Spiel beenden ? "," Spielende ","beendet das Spiel","Aha",
  " Lschen ? "," Spiel ","Schneider","Schwarz","Spielen"," Hinweis ",
  "Nur bei Handspielen kann Schneider",
  "oder schwarz angesagt werden.",
  "Ouvert schliet schwarz angesagt",
  "ein (auer bei Null natrlich).",
  "Du hast hher gereizt als der",
  "Wert des angesagten Spiels !",
  "Null:23  Null ouvert:46",
  "Null Hand:35  Null ouvert Hand:59",
  "Revolution:92",
  " Angesagt ist "," Resultat ","Der Spielwert ist","Ende",
  "Spiele gewonnen/verloren",
  "Protokoll","Weiter"," Protokoll ",
  "Im Skat ist:",
  "Im Skat war:",
  "Gereizt bis:",
  "Gewonnen mit:",
  "Verloren mit:",
  "Spielliste"," Spielliste ",VERSION,
  COPYRIGHT,EMAIL,HOMEPAGE,URL,
  "Sortieren","Aufwrts","Abwrts","Alternierend","Sequentiell",
  "Normal",
  "Gereizt bis:","Gespielt wird:","Letzter Stich:",
  "Du bist dran !","Vordefiniertes Spiel","Speichern",
  "Dieses Programm ist freie Software;",
  "es kann frei verbreitet werden.",
  "Verwendung auf eigenes Risiko;",
  "es gibt KEINE GARANTIE.",
  "Optionen"," Computer ","Strategie","passe","sage 18",
  "Vorschlge"," Varianten ",
  "Ramsch spielen","Immer",
  "Schieberamsch"," Skat aufnehmen ? ","Fertig",
  "Buben drfen nicht geschoben werden.",
  "Unter drfen nicht geschoben werden.",
  " Spielwert verdoppelt ","nimmt den Skat nicht auf.","klopft !",
  "VH schob:","MH schob:","HH schob:",
  "Kontra sagen","mit Kontra","ab 18","Kontra"," Kontra ! ","Re","von ",
  "Wiederholen"," Spiel wiederholen ","mit den Karten von","mir",
  "Vorhand wechselt:",
  " Geschwindigkeit ","Nimm Stich nach:","Sekunden","Maus-Klick",
  "Abkrzung","Fragen","Nie",
  "Bock-Runden","+Ramsch","fortsetzen",
  " Bock-Ereignisse ","Bock-Ereignis","%d Bock-Ereignisse",
  "Bock-Spiele:"," Grand Hand ? ",
  "Verloren mit 60 Augen","Grand Hand gewonnen",
  "Erfolgreicher Kontra","Kontra & Re angesagt",
  "NNN Punkte in Spielliste","N00 Punkte in Spielliste",
  "Spielwert ist >= +72","Spielwert ist >= +96",
  " Eingabe ","Tastatur",
  "Men-Button","Jeder","und ESC / F1",
  "Spitze","zhlt 2","Spitze verloren !","Spitze !",
  "Spitze nicht erlaubt !",
  "Niedrigster Trumpf nicht auf der Hand.",
  "Grand mit 4.",
  " Null ist dicht ! "," Rest bei mir ! ","Karten aufdecken ?",
  "Revolution","Revolution: Karten austauschen !",
  "Vorhand","Mittelhand","Hinterhand",
  "Klopfen"," Klopfen ","Spielwert verdoppeln ?",
  "Schenken"," Schenken ","Spiel verloren geben ?","Geschenk annehmen ?",
  "Mitspieler lehnt ab.","Gegner geben auf.","Annehmen",
  "Geben","Schnell","Langsam",
  "Grafik & Text",
  "Blatt","Franzsisch","Franzsisch (4 Farben)",
  "Deutsch","Deutsch (4 Farben)",
  "Sprache","Deutsch","English",
  "Alte Regeln",
  "Internet Relay Chat",
  "IRC-Verbindung herstellen mit:",
  "Zur IRC-Konfiguration siehe:",
  "man xskat",
  "Verschiedene Versionen",
  "(Probleme? README.IRC oder 'man xskat' NOTES lesen!)",
  "Nicht auf diesem Kanal !",
  "Nur ein Spieler sollte /go sagen !  Nochmal.",
  "Sollte das /go%s sein ?",
  "Verbunden mit Spieler%d.",
  "Warten auf Spieler%d.",
  "\n Zum Spielen mit /join #xskatXYZ auf einen freien Kanal wechseln.",
  " Wenn alle Mitspieler auf diesem Kanal sind, mu einer /go eingeben,",
  " bzw. /go2, wenn nur 2 Spieler teilnehmen.",
  " Zeilen, die nicht mit / beginnen, werden als Nachricht verschickt.\n",
  " ### XSkat-Zeiten: jeden Fr 13:30 und So 18:00 MEZ/MESZ ###\n",
  "Offizielle Regeln",
  "Position","Alternativ","Turnier","Geber",
  "Unbekanntes Kommando (versuche /help)",
  "/join kanal - wechsle auf einen anderen Kanal",
  "/go, /go2 - starte Spiel mit 3 bzw. 2 Spielern",
  "/quit - beende XSkat",
  "/nick name, /nick - ndere Namen oder zeige ihn an",
  "/who - wer ist auf dem aktuellen Kanal ?",
  "/list, /list text - zeige Kanle (die xskat/text enthalten)",
  "/pos n - setze Position auf 1, 2 oder 3",
  "/bell - schalte Alarmton ein/aus",
  "/sync - synchronisiere sofort",
  "/quote command args - fr Spezialisten",
  "/default - aktiviere offizielle Regeln",
  "/ramsch n, /sramsch b, /kontra n, /bock n, /resumebock n,",
  " /spitze n, /revolution b, /klopfen b, /schenken b, /oldrules b,",
  " /bockevents n, /alist b, /tlist b, /start n, /s1 n",
  " - ndere Regeln (n ist eine Zahl, b ist true/false)",
  "/rules - zeige allen Mitspielern aktuelle Regeln an"
};

static char *eng_text[]={
  "Null","Diamond","Heart","Spade","Club","Grand","Ramsch",
  "Ace","10","King","Queen","Jack","9","8","7",
  " A"," 10"," K"," Q"," J"," 9"," 8"," 7",
  "Bells","Hearts","Leaves","Acorns",
  "Ace","10","King","Ober","Unter","9","8","7",
  " A"," 10"," K"," O"," U"," 9"," 8"," 7",
  "Played Hand","Schneider announced","Schwarz announced",
  "Played ouvert","Played ouvert Hand",
  "Pass","Yes","No","Player%d","Computer","left","right",
  "Done","plays ","ouvert Hand","ouvert","Hand","Ouvert",
  "thinks","You have bid: %d","Clear"," played ",
  "Won"," won ","Lost"," lost ","%d points",
  "Overbid !","Opponents not Schneider !","Opponents not schwarz !",
  "One virgin !","Forced march !",
  "Nobody","wins","loses","the Ramsch",
  "the Null game.","the game schwarz !","with %d vs %d points.",
  " Hand ? "," Quit game ? "," Game over ","quits the game","OK",
  " Clear ? "," Game ","Schneider","Schwarz","Play"," Reminder ",
  "Only when playing Hand you may",
  "say Schneider or schwarz.",
  "Ouvert includes schwarz",
  "(except when playing Null).",
  "The value of your game",
  "is not high enough !",
  "Null:23  Null ouvert:46",
  "Null Hand:35  Null ouvert Hand:59",
  "Revolution:92",
  " Playing "," Result ","The value of the game is","Quit",
  "Games won/lost",
  "Log","Continue"," Log ",
  "Skat is:",
  "Skat was:",
  "Last bid:",
  "Won with:",
  "Lost with:",
  "Game list"," Game list ",VERSION,
  COPYRIGHT,EMAIL,HOMEPAGE,URL,
  "Sort","Up","Down","Alternating","Sequential",
  "Normal",
  "Bidding:","Playing:","Last trick:",
  "It's your turn !","      predefined game      ","Save",
  "This program is free software;",
  "you can redistribute it freely.",
  "Use it at your own risk;",
  "there is NO WARRANTY.",
  "Options"," Computer ","Strategy","pass","say 18",
  "Hints"," Variations ",
  "Play Ramsch","Always",
  "Schieberamsch"," Pick up Skat ? ","Done",
  "It's not allowed to pass on jacks.",
  "It's not allowed to pass on unters.",
  " Game score doubled ","doesn't pick up the Skat.","knocks !",
  "FH passed:","MH passed:","RH passed:",
  "Say Kontra","with Kontra","if 18","Kontra"," Kontra ! ","Re","by ",
  "Replay"," Replay game ","with the cards from","me",
  "Forehand changes:",
  " Speed ","Take trick after:","seconds","mouse click",
  "Shortcut","Ask","Never",
  "Bockrounds","+Ramsch","resume",
  " Bock events ","Bock event","%d Bock events",
  "Bock games:"," Grand Hand ? ",
  "Lost with 60 points","Successful Grand Hand",
  "Successful Kontra","Kontra & Re game",
  "NNN points in game list","N00 points in game list",
  "Game value is >= +72","Game value is >= +96",
  " Input ","Keyboard",
  "Menu button","Any","and ESC / F1",
  "Spitze","counts 2","Lost Spitze !","Spitze !",
  "Spitze not allowed !",
  "Lowest trump not in your hand.",
  "Grand with 4.",
  " Null is safe ! "," Rest is mine ! ","Show cards ?",
  "Revolution","Revolution: exchange cards !",
  "Forehand","Middlehand","Rearhand",
  "Klopfen"," Klopfen ","Double game value ?",
  "Schenken"," Schenken ","Give up the game ?","Accept the gift ?",
  "Partner disagrees.","Opponents give up.","Accept",
  "Deal","Fast","Slow",
  "Graphic & Text",
  "Cards","French","French (4 colors)",
  "German","German (4 colors)",
  "Language","Deutsch","English",
  "Old rules",
  "Internet Relay Chat",
  "Establish IRC connection with:",
  "For IRC configuration see:",
  "man xskat",
  "Version mismatch",
  "(Problems? See README.IRC or 'man xskat' NOTES!)",
  "Not on this channel !",
  "Only one player should say /go !  Try again.",
  "Did you mean /go%s ?",
  "Connected to Player%d.",
  "Waiting for Player%d.",
  "\n Start playing by typing /join #xskatXYZ to switch to a free channel.",
  " When all players are on this channel, one player has to enter /go,",
  " or /go2, if there are only 2 players.",
  " Lines that don't begin with / are sent as messages.\n",
  " ### XSkat times: every Fri 13:30 and Sun 18:00 MET/MEST ###\n",
  "Official rules",
  "Position","Alternative","Tournament","Dealer",
  "Unknown command (try /help)",
  "/join channel - switch to another channel",
  "/go, /go2 - start a game with 3 or 2 players",
  "/quit - terminate XSkat",
  "/nick name, /nick - change or display your nickname",
  "/who - is on the current channel ?",
  "/list, /list string - show channels (matching xskat/string)",
  "/pos n - set position to 1, 2 or 3",
  "/bell - toggle the alarm bell",
  "/sync - synchronize now",
  "/quote command args - for specialists",
  "/default - set the official rules",
  "/ramsch n, /sramsch b, /kontra n, /bock n, /resumebock n,",
  " /spitze n, /revolution b, /klopfen b, /schenken b, /oldrules b,",
  " /bockevents n, /alist b, /tlist b, /start n, /s1 n",
  " - change the rules of the game (n is a number, b is true/false)",
  "/rules - show the current rules to everyone on your channel"
};

tx_typ textarr[TX_NUM_TX];

static struct {
  char **arr;
  char *name;
  char *langpref[5];
} textdesc[NUM_LANG] = {
  {ger_text,"german",{"de","german",0}},
  {eng_text,"english",{"en",0}}
};

VOID init_text()
{
  int i,j;

  for (i=0;i<NUM_LANG;i++) {
    for (j=0;j<TX_NUM_TX;j++) {
      textarr[j].t[i]=textdesc[i].arr[j];
    }
  }
}

int langidx(s)
char *s;
{
  char h[80];
  int i,j;

  for (i=0;i<79 && s && *s;i++,s++) {
    h[i]=tolower(*s);
  }
  h[i]=0;
  for (i=0;i<NUM_LANG;i++) {
    if (!strcmp(textdesc[i].name,h)) return i;
  }
  if (s) {
    fprintf(stderr,"Unknown language '%s'.  Try one of:",h);
    for (i=0;i<NUM_LANG;i++) {
      if (i) fputc(',',stderr);
      fprintf(stderr," %s",textdesc[i].name);
    }
    fputs(".\n",stderr);
  }
  s=getenv("LANG");
  if (s) {
    for (i=0;i<79 && s && *s;i++,s++) {
      h[i]=tolower(*s);
    }
    h[i]=0;
    for (i=0;i<NUM_LANG;i++) {
      for (j=0;j<5 && textdesc[i].langpref[j];j++) {
	if (!strncmp(h,textdesc[i].langpref[j],
		     strlen(textdesc[i].langpref[j]))) return i;
      }
    }
  }
  for (i=0;i<NUM_LANG;i++) {
    if (!strcmp(textdesc[i].name,DEFAULT_LANGUAGE)) return i;
  }
  return 0;
}
