/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

class TextJournal {
    private TextCanvas canvas;
    private Vector lines;
    private TextJournalItem journal;
    private TextJournalItem undo_list;
    private TextJournalItem redo_list;
    private boolean had_undo;
    private boolean had_redo;
    private String lineSeparator;
    private final int REPLACE_LINE = 1;
    private final int SPLIT_LINE = 2;
    private final int JOIN_LINE = 3;
    private final int INSERT = 4;
    private final int DELETE = 5;

    public TextJournal(TextCanvas textCanvas, Vector vector, String string) {
        this.canvas = textCanvas;
        this.lines = vector;
        this.lineSeparator = string;
        this.redo_list = null;
        this.undo_list = null;
        this.had_redo = false;
        this.had_undo = false;
    }

    public void clear() {
        this.redo_list = null;
        this.undo_list = null;
        this.had_redo = false;
        this.had_undo = false;
    }

    private void updateMenus() {
        boolean bl;
        boolean bl2 = this.undo_list != null;
        boolean bl3 = bl = this.redo_list != null;
        if (this.had_undo != bl2 || this.had_redo != bl) {
            this.canvas.updateUndoItems(bl2, bl);
        }
        this.had_undo = bl2;
        this.had_redo = bl;
    }

    public TextPosition undo() {
        TextPosition textPosition = null;
        if (this.undo_list != null) {
            TextJournalItem textJournalItem = this.undo_list;
            this.undo_list = textJournalItem.next;
            switch (textJournalItem.action) {
                case 1: {
                    this.redo_line(textJournalItem);
                    break;
                }
                case 2: {
                    this.split_or_join(textJournalItem, true);
                    break;
                }
                case 3: {
                    this.split_or_join(textJournalItem, false);
                    break;
                }
                case 4: {
                    this.copy_or_cut(textJournalItem, true);
                    break;
                }
                case 5: {
                    this.insert(textJournalItem);
                }
            }
            textPosition = new TextPosition(textJournalItem.line, textJournalItem.column);
            textJournalItem.next = this.redo_list;
            this.redo_list = textJournalItem;
        }
        this.updateMenus();
        return textPosition;
    }

    public TextPosition redo() {
        TextPosition textPosition = null;
        if (this.redo_list != null) {
            TextJournalItem textJournalItem = this.redo_list;
            this.redo_list = textJournalItem.next;
            int n = textJournalItem.line;
            int n2 = textJournalItem.column;
            switch (textJournalItem.action) {
                case 1: {
                    n2 = textJournalItem.text.length();
                    this.redo_line(textJournalItem);
                    break;
                }
                case 2: {
                    this.split_or_join(textJournalItem, false);
                    n2 = 0;
                    break;
                }
                case 3: {
                    this.split_or_join(textJournalItem, true);
                    break;
                }
                case 4: {
                    this.insert(textJournalItem);
                    n = textJournalItem.eline;
                    n2 = textJournalItem.ecolumn;
                    break;
                }
                case 5: {
                    this.copy_or_cut(textJournalItem, true);
                }
            }
            textPosition = new TextPosition(n, n2);
            textJournalItem.next = this.undo_list;
            this.undo_list = textJournalItem;
        }
        this.updateMenus();
        return textPosition;
    }

    public void insert_char(int n, int n2, char c) {
        String string = (String)this.lines.elementAt(n);
        this.remember_line(n, n2, string);
        string = String.valueOf(string.substring(0, n2)) + c + string.substring(n2, string.length());
        this.lines.setElementAt(string, n);
    }

    public void delete_prev_char(int n, int n2) {
        String string = (String)this.lines.elementAt(n);
        this.remember_line(n, n2, string);
        string = String.valueOf(string.substring(0, n2 - 1)) + string.substring(n2, string.length());
        this.lines.setElementAt(string, n);
    }

    public void delete_next_char(int n, int n2) {
        String string = (String)this.lines.elementAt(n);
        this.remember_line(n, n2, string);
        string = String.valueOf(string.substring(0, n2)) + string.substring(n2 + 1, string.length());
        this.lines.setElementAt(string, n);
    }

    private void remember_line(int n, int n2, String string) {
        boolean bl = true;
        if (this.undo_list != null) {
            boolean bl2 = bl = this.undo_list.action != 1 || this.undo_list.line != n;
        }
        if (bl) {
            TextJournalItem textJournalItem = new TextJournalItem();
            textJournalItem.action = 1;
            textJournalItem.line = n;
            textJournalItem.column = n2;
            textJournalItem.text = new String(string);
            textJournalItem.next = this.undo_list;
            this.undo_list = textJournalItem;
        }
        this.redo_list = null;
        this.updateMenus();
    }

    private void redo_line(TextJournalItem textJournalItem) {
        String string = (String)this.lines.elementAt(textJournalItem.line);
        this.lines.setElementAt(textJournalItem.text, textJournalItem.line);
        textJournalItem.text = string;
    }

    public void split_line(int n, int n2) {
        TextJournalItem textJournalItem = new TextJournalItem();
        textJournalItem.action = 2;
        textJournalItem.line = n;
        textJournalItem.column = n2;
        this.split_or_join(textJournalItem, false);
        textJournalItem.next = this.undo_list;
        this.undo_list = textJournalItem;
        this.redo_list = null;
        this.updateMenus();
    }

    public void join_line(int n, int n2) {
        TextJournalItem textJournalItem = new TextJournalItem();
        textJournalItem.action = 3;
        textJournalItem.line = n;
        textJournalItem.column = n2;
        this.split_or_join(textJournalItem, true);
        textJournalItem.next = this.undo_list;
        this.undo_list = textJournalItem;
        this.redo_list = null;
        this.updateMenus();
    }

    public void split_or_join(TextJournalItem textJournalItem, boolean bl) {
        int n = textJournalItem.line;
        int n2 = textJournalItem.column;
        if (bl) {
            String string = (String)this.lines.elementAt(n);
            string = string.concat((String)this.lines.elementAt(n + 1));
            this.lines.setElementAt(string, n);
            this.lines.removeElementAt(n + 1);
            return;
        }
        String string = (String)this.lines.elementAt(n);
        this.lines.setElementAt(string.substring(0, n2), n);
        this.lines.insertElementAt(string.substring(n2, string.length()), ++n);
    }

    public TextPosition insert_section(int n, int n2, String string) {
        TextJournalItem textJournalItem = new TextJournalItem();
        textJournalItem.action = 4;
        textJournalItem.text = new String(string);
        textJournalItem.line = n;
        textJournalItem.column = n2;
        TextPosition textPosition = this.insert(textJournalItem);
        textJournalItem.eline = textPosition.line;
        textJournalItem.ecolumn = textPosition.column;
        textJournalItem.next = this.undo_list;
        this.undo_list = textJournalItem;
        this.redo_list = null;
        this.updateMenus();
        return textPosition;
    }

    public TextPosition insert(TextJournalItem textJournalItem) {
        int n = textJournalItem.line;
        int n2 = textJournalItem.column;
        String string = textJournalItem.text;
        String string2 = null;
        int n3 = string.length();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            char c = string.charAt(n5);
            ++n5;
            if (c != '\r' && c != '\n') continue;
            string2 = (String)this.lines.elementAt(n);
            this.lines.setElementAt(String.valueOf(string2.substring(0, n2)) + string.substring(n4, n5 - 1), n);
            this.lines.insertElementAt(string2.substring(n2, string2.length()), ++n);
            n2 = 0;
            if (n5 < n3) {
                char c2 = string.charAt(n5);
                if (c == '\r' && c2 == '\n' || c2 != '\r' || c == '\n') {
                    // empty if block
                }
            }
            n4 = ++n5;
        }
        if (n4 < n5) {
            string2 = (String)this.lines.elementAt(n);
            string = string.substring(n4, n5);
            string2 = n2 == 0 ? String.valueOf(string) + string2 : String.valueOf(string2.substring(0, n2)) + string + string2.substring(n2, string2.length());
            n2 += string.length();
            this.lines.setElementAt(string2, n);
        }
        return new TextPosition(n, n2);
    }

    public String delete_section(int n, int n2, int n3, int n4, boolean bl) {
        TextJournalItem textJournalItem = new TextJournalItem();
        textJournalItem.action = 5;
        textJournalItem.line = n;
        textJournalItem.column = n2;
        textJournalItem.eline = n3;
        textJournalItem.ecolumn = n4;
        String string = this.copy_or_cut(textJournalItem, bl);
        if (bl) {
            textJournalItem.text = new String(string);
            textJournalItem.next = this.undo_list;
            this.undo_list = textJournalItem;
            this.redo_list = null;
            this.updateMenus();
        }
        return string;
    }

    private String copy_or_cut(TextJournalItem textJournalItem, boolean bl) {
        String string = null;
        int n = textJournalItem.line;
        int n2 = textJournalItem.column;
        int n3 = textJournalItem.eline;
        int n4 = textJournalItem.ecolumn;
        if (n == n3) {
            String string2 = (String)this.lines.elementAt(n);
            string = string2.substring(n2, n4);
            if (bl) {
                string2 = String.valueOf(string2.substring(0, n2)) + string2.substring(n4, string2.length());
                this.lines.setElementAt(string2, n);
            }
        } else {
            String string3;
            String string4 = (String)this.lines.elementAt(n);
            string = string4.substring(n2, string4.length());
            string4 = string4.substring(0, n2);
            int n5 = n3 - n;
            int n6 = n + 1;
            int n7 = 1;
            while (n7 < n5) {
                string3 = (String)this.lines.elementAt(n6);
                string = String.valueOf(string) + this.lineSeparator + string3;
                if (bl) {
                    this.lines.removeElementAt(n6);
                } else {
                    ++n6;
                }
                ++n7;
            }
            if (n6 != this.lines.size()) {
                string3 = (String)this.lines.elementAt(n6);
                string = String.valueOf(string) + this.lineSeparator + string3.substring(0, n4);
                string4 = String.valueOf(string4) + string3.substring(n4, string3.length());
                if (bl) {
                    this.lines.removeElementAt(n6);
                }
            }
            if (bl) {
                this.lines.setElementAt(string4, n);
            }
        }
        return string;
    }
}

