/*
 * Decompiled with CFR 0.152.
 */
package kaffe.util;

import java.io.DataInput;
import java.io.IOException;
import java.io.UTFDataFormatException;

public final class UTF8 {
    public static String decode(DataInput dataInput, int n) throws IOException, UTFDataFormatException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            byte by = dataInput.readByte();
            ++n2;
            if ((by & 0x80) == 128) {
                byte by2;
                if ((by & 0xE0) == 192) {
                    if (n2++ == n) {
                        throw new UTFDataFormatException("truncated");
                    }
                    by2 = dataInput.readByte();
                    if ((by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("byte #" + n2 + " invalid");
                    }
                    stringBuffer.append((char)(((by & 0x1F) << 6) + (by2 & 0x3F)));
                    continue;
                }
                if ((by & 0xF0) == 224) {
                    if (n2++ == n) {
                        throw new UTFDataFormatException("truncated");
                    }
                    by2 = dataInput.readByte();
                    if ((by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("byte #" + n2 + " invalid");
                    }
                    if (n2++ == n) {
                        throw new UTFDataFormatException("truncated");
                    }
                    byte by3 = dataInput.readByte();
                    if ((by3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("byte #" + n2 + " invalid");
                    }
                    stringBuffer.append((char)(((by & 0xF) << 12) + ((by2 & 0x3F) << 6) + (by3 & 0x3F)));
                    continue;
                }
                throw new UTFDataFormatException("byte #" + n2 + " invalid");
            }
            stringBuffer.append((char)by);
        }
        return stringBuffer.toString();
    }

    public static byte[] encode(String string) {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < cArray.length) {
            n = cArray[n4];
            n2 = n >= 1 && n <= 127 ? ++n2 : (n <= 2047 ? (n2 += 2) : (n2 += 3));
            ++n4;
        }
        byte[] byArray = new byte[n2];
        n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n3++] = (byte)c;
            } else if (c <= '\u07ff') {
                byArray[n3++] = (byte)(0xC0 | 0x3F & c >> 6);
                byArray[n3++] = (byte)(0x80 | 0x3F & c);
            } else {
                byArray[n3++] = (byte)(0xE0 | 0xF & c >> 12);
                byArray[n3++] = (byte)(0x80 | 0x3F & c >> 6);
                byArray[n3++] = (byte)(0x80 | 0x3F & c);
            }
            ++n;
        }
        return byArray;
    }

    private UTF8() {
    }
}

