/*
 * Decompiled with CFR 0.152.
 */
package kaffe.net.www.protocol.http;

import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    private static final String[] headers = new String[]{"content-encoding", "content-length", "content-type", "content-location", "date", "expiration", "If-Modified-Since", "lastModified", "location", "server"};
    private static final int ContentEncoding = 0;
    private static final int ContentLength = 1;
    private static final int ContentType = 2;
    private static final int Date = 3;
    private static final int Expiration = 4;
    private static final int IfModifiedSince = 5;
    private static final int LastModified = 6;
    private static String proxyHost;
    private static int proxyPort;
    private static boolean useProxy;
    private String[] headersValue = new String[headers.length];
    private Socket sock;
    private InputStream in;
    private DataOutputStream out;
    private boolean redir = java.net.HttpURLConnection.getFollowRedirects();

    public void connect() throws IOException {
        while (true) {
            String string;
            String string2;
            String string3;
            int n;
            if (useProxy) {
                n = proxyPort;
                string3 = proxyHost;
            } else {
                n = this.url.getPort();
                string3 = this.url.getHost();
            }
            if (n == -1) {
                n = 80;
            }
            this.sock = new Socket(string3, n);
            this.in = new BufferedInputStream(this.sock.getInputStream());
            this.out = new DataOutputStream(this.sock.getOutputStream());
            if (useProxy) {
                string2 = this.url.toString();
            } else {
                string2 = this.url.getFile();
                if (string2.equals("")) {
                    string2 = "/";
                }
            }
            this.out.writeBytes(this.method + " " + string2 + " HTTP/1.0\r\n\r\n");
            this.out.flush();
            DataInputStream dataInputStream = new DataInputStream(this.in);
            while ((string = dataInputStream.readLine()) != null && !string.equals("")) {
                if (string.startsWith("HTTP")) {
                    this.responseMessage = string;
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    if (stringTokenizer.countTokens() < 3) continue;
                    stringTokenizer.nextToken();
                    try {
                        this.responseCode = Integer.parseInt(stringTokenizer.nextToken());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.responseCode = 500;
                    }
                    continue;
                }
                int n2 = string.indexOf(58);
                if (n2 <= 0) continue;
                String string4 = string.substring(0, n2);
                ++n2;
                while (Character.isWhitespace(string.charAt(n2))) {
                    ++n2;
                }
                String string5 = string.substring(n2);
                this.setHeaderField(string4, string5);
            }
            string = this.getHeaderField("location");
            if (!this.redir || this.responseCode < 300 || this.responseCode > 305 || string == null) break;
            this.url = new URL(string);
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    public String getHeaderField(String string) {
        int n = 0;
        while (n < headers.length) {
            if (headers[n].equalsIgnoreCase(string)) {
                return this.getHeaderField(n);
            }
            ++n;
        }
        return null;
    }

    public String getHeaderField(int n) {
        if (n < 0 || n >= this.headersValue.length) {
            return null;
        }
        return this.headersValue[n];
    }

    public String getHeaderFieldKey(int n) {
        if (n < 0 || n >= headers.length) {
            return null;
        }
        return headers[n];
    }

    protected void setHeaderField(String string, String string2) {
        int n = 0;
        while (n < headers.length) {
            if (headers[n].equalsIgnoreCase(string)) {
                this.headersValue[n] = string2;
                break;
            }
            ++n;
        }
    }

    public Object getContent() throws IOException {
        if (this.headersValue[0] == null) {
            return this.in;
        }
        if (this.headersValue[0].startsWith("image/")) {
            return Toolkit.getDefaultToolkit().getImage(this.url).getSource();
        }
        return this.in;
    }

    protected void setContentTypeFromName() {
        String string;
        this.headersValue[2] = string = URLConnection.getFileNameMap().getContentTypeFor(this.url.getFile());
        this.headersValue[0] = string;
    }

    public void disconnect() {
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.sock = null;
    }

    public boolean usingProxy() {
        return useProxy;
    }

    public void setInstanceFollowRedirects(boolean bl) {
        this.redir = bl;
    }

    public HttpURLConnection(URL uRL) {
        super(uRL);
    }

    static {
        proxyPort = -1;
        useProxy = false;
        proxyHost = System.getProperty("http.proxyHost");
        if (proxyHost != null) {
            useProxy = true;
            String string = System.getProperty("http.proxyPort");
            if (string != null) {
                proxyPort = Integer.parseInt(string);
            }
        }
    }
}

