/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class TimeZone
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3581463369166924961L;
    private static TimeZone defaultTimeZone = null;
    private static Hashtable zones = new Hashtable();
    private String timezoneID = null;

    public Object clone() {
        try {
            TimeZone timeZone = (TimeZone)this.getClass().newInstance();
            timeZone.setID(this.getID());
            return timeZone;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static synchronized String[] getAvailableIDs() {
        String[] stringArray = new String[zones.size()];
        Enumeration enumeration = zones.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = ((TimeZone)enumeration.nextElement()).getID();
            ++n;
        }
        return stringArray;
    }

    public static synchronized String[] getAvailableIDs(int n) {
        String[] stringArray;
        Enumeration enumeration = zones.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            if (stringArray.getRawOffset() != n) continue;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        stringArray = new String[n2];
        enumeration = zones.elements();
        n2 = 0;
        while (enumeration.hasMoreElements()) {
            TimeZone timeZone = (TimeZone)enumeration.nextElement();
            if (timeZone.getRawOffset() != n) continue;
            stringArray[n2++] = timeZone.getID();
        }
        return stringArray;
    }

    public static synchronized TimeZone getDefault() {
        if (defaultTimeZone == null) {
            String string = System.getProperty("user.timezone", "GMT");
            defaultTimeZone = TimeZone.getTimeZone(string);
            if (defaultTimeZone == null) {
                defaultTimeZone = TimeZone.getTimeZone("GMT");
            }
            if (defaultTimeZone == null) {
                throw new InternalError("Cannot intialize timezone.  GMT & " + string + " zones are undefined.");
            }
        }
        return defaultTimeZone;
    }

    public String getID() {
        return this.timezoneID;
    }

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract int getRawOffset();

    public static synchronized TimeZone getTimeZone(String string) {
        TimeZone timeZone = (TimeZone)zones.get(string);
        return timeZone;
    }

    public abstract boolean inDaylightTime(Date var1);

    public static synchronized void setDefault(TimeZone timeZone) {
        defaultTimeZone = timeZone;
    }

    public void setID(String string) {
        if (this.timezoneID != null) {
            zones.remove(this.timezoneID);
        }
        this.timezoneID = string;
        zones.put(this.timezoneID, this);
    }

    public abstract void setRawOffset(int var1);

    public String toString() {
        return this.timezoneID;
    }

    public abstract boolean useDaylightTime();
}

