/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class Constructor
implements Member {
    private Class clazz;
    private int slot;
    private Class[] parameterTypes;
    private Class[] exceptionTypes;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Constructor)) {
            return false;
        }
        Constructor constructor = (Constructor)object;
        if (this.clazz != constructor.clazz) {
            return false;
        }
        if (this.parameterTypes.length != constructor.parameterTypes.length) {
            return false;
        }
        int n = this.parameterTypes.length;
        while (n-- > 0) {
            if (this.parameterTypes[n] == constructor.parameterTypes[n]) continue;
            return false;
        }
        return true;
    }

    public Class getDeclaringClass() {
        return this.clazz;
    }

    public Class[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    public native int getModifiers();

    public String getName() {
        return this.clazz.getName();
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    public native Object newInstance(Object[] var1) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getModifiers();
        if (Modifier.isPublic(n)) {
            stringBuffer.append("public ");
        } else if (Modifier.isPrivate(n)) {
            stringBuffer.append("private ");
        } else if (Modifier.isProtected(n)) {
            stringBuffer.append("protected ");
        }
        stringBuffer.append(this.clazz.getName());
        stringBuffer.append("(");
        int n2 = 0;
        while (n2 < this.parameterTypes.length) {
            stringBuffer.append(Method.getPrettyName(this.parameterTypes[n2]));
            if (n2 + 1 < this.parameterTypes.length) {
                stringBuffer.append(",");
            }
            ++n2;
        }
        stringBuffer.append(")");
        if (this.exceptionTypes.length > 0) {
            stringBuffer.append(" throws ");
            n2 = 0;
            while (n2 < this.exceptionTypes.length) {
                stringBuffer.append(this.exceptionTypes[n2].getName());
                if (n2 + 1 < this.exceptionTypes.length) {
                    stringBuffer.append(",");
                }
                ++n2;
            }
        }
        return new String(stringBuffer);
    }

    private Constructor() {
    }
}

