/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.ActionEvt;
import java.awt.Cursor;
import java.awt.Defaults;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.NativeGraphics;
import java.awt.PopupMenu;
import java.awt.TextBuffer;
import java.awt.TextComponent;
import java.awt.TextCursor;
import java.awt.TextEvt;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class TextField
extends TextComponent
implements MouseMotionListener,
KeyListener,
FocusListener,
MouseListener {
    private static final long serialVersionUID = -2966288784432217853L;
    static int xOffs = 2;
    char echoChar;
    ActionListener aListener;
    int cols;
    FontMetrics fm;
    TextCursor tCursor = new TextCursor();
    int selStart;
    int selEnd;
    TextBuffer textBuf = new TextBuffer();
    TextBuffer hiddenBuf;
    int first;
    NativeGraphics rgr;

    public void addActionListener(ActionListener actionListener) {
        this.aListener = AWTEventMulticaster.add(this.aListener, actionListener);
    }

    public void addNotify() {
        super.addNotify();
        if (this.rgr == null) {
            this.setResGraphics();
        }
    }

    void blankSelection() {
        if (this.selStart != this.selEnd) {
            this.setTextCursor(this.selStart, true, false);
        }
    }

    protected void buildMenu() {
        PopupMenu popupMenu = new PopupMenu();
        popupMenu.add(new MenuItem("Cut")).setShortcut(new MenuShortcut(85, false));
        popupMenu.add(new MenuItem("Copy")).setShortcut(new MenuShortcut(79, false));
        popupMenu.add(new MenuItem("Paste")).setShortcut(new MenuShortcut(65, false));
        popupMenu.addSeparator();
        popupMenu.add(new MenuItem("Select All")).setShortcut(new MenuShortcut(83, false));
        popupMenu.addActionListener(this);
        this.add(popupMenu);
    }

    public void deleteSelection() {
        if (this.selStart != this.selEnd) {
            this.textBuf.remove(this.selStart, this.selEnd - this.selStart);
            if (this.hiddenBuf != null) {
                this.hiddenBuf.remove(this.selStart, this.selEnd - this.selStart);
            }
            this.setTextCursor(this.selStart, true, false);
        }
    }

    public boolean echoCharIsSet() {
        return this.echoChar != '\u0000';
    }

    void extendSelectionTo(int n, boolean bl) {
        if (n < 0) {
            n = 0;
        } else if (n > this.textBuf.len) {
            n = this.textBuf.len;
        }
        if (n == this.tCursor.index) {
            return;
        }
        if (n < this.selStart) {
            this.selStart = n;
        } else if (n > this.selEnd) {
            this.selEnd = n;
        } else if (bl) {
            this.tCursor.index = this.selStart;
            this.selStart = n;
        } else {
            this.selEnd = n;
        }
        this.setTextCursor(n, false, true);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.paintBorder();
        if (Defaults.ShowInactiveCursor) {
            this.paintInactiveCursor();
        } else {
            this.repaintFrom(0);
        }
    }

    TextBuffer getBuffer() {
        return this.hiddenBuf != null ? this.hiddenBuf : this.textBuf;
    }

    public int getCaretPosition() {
        return this.tCursor.index;
    }

    public int getColumns() {
        return this.cols;
    }

    int getCursorPos(TextBuffer textBuffer, int n) {
        if (n < 0) {
            n = 0;
        } else if (n > this.textBuf.len) {
            n = this.textBuf.len;
        }
        return 2 + xOffs + textBuffer.getWidth(this.first, n);
    }

    public char getEchoChar() {
        return this.echoChar;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension getMinimumSize(int n) {
        return this.minimumSize(n);
    }

    public Dimension getPreferredSize(int n) {
        return this.preferredSize(n);
    }

    public String getSelectedText() {
        if (this.selStart != this.selEnd) {
            return this.textBuf.getString(this.selStart, this.selEnd - this.selStart);
        }
        return null;
    }

    public int getSelectionEnd() {
        return this.selEnd;
    }

    public int getSelectionStart() {
        return this.selStart;
    }

    public String getText() {
        return this.textBuf.toString();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        boolean bl = keyEvent.isShiftDown();
        int n2 = keyEvent.getKeyCode();
        if (n != 0 && n != 1) {
            return;
        }
        switch (n2) {
            case 10: {
                this.notifyAction();
                break;
            }
            case 27: {
                if (!this.isEditable) break;
                this.setText("");
                break;
            }
            case 36: {
                if (bl) {
                    this.extendSelectionTo(0, false);
                    break;
                }
                this.setTextCursor(0, true, false);
                break;
            }
            case 35: {
                if (bl) {
                    this.extendSelectionTo(this.textBuf.len, true);
                    break;
                }
                this.setTextCursor(this.textBuf.len, true, false);
                break;
            }
            case 37: {
                if (bl) {
                    this.extendSelectionTo(this.tCursor.index - 1, false);
                    break;
                }
                this.shiftTextCursor(-1, true);
                break;
            }
            case 39: {
                if (bl) {
                    this.extendSelectionTo(this.tCursor.index + 1, true);
                    break;
                }
                this.shiftTextCursor(1, true);
                break;
            }
            case 8: {
                if (!this.isEditable) break;
                if (this.selStart != this.selEnd) {
                    this.deleteSelection();
                    break;
                }
                if (this.tCursor.index <= 0) break;
                this.textBuf.remove(this.tCursor.index - 1, 1);
                this.shiftTextCursor(-1, true);
                break;
            }
            case 127: {
                if (!this.isEditable) break;
                if (this.selStart != this.selEnd) {
                    this.deleteSelection();
                    break;
                }
                if (this.tCursor.index >= this.textBuf.len) break;
                this.textBuf.remove(this.tCursor.index, 1);
                this.repaintTrailing();
                break;
            }
            default: {
                return;
            }
        }
        keyEvent.consume();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (!this.isEditable || keyEvent.isConsumed() || !this.isPrintableTyped(keyEvent)) {
            return;
        }
        char c = keyEvent.getKeyChar();
        if (this.selStart != this.selEnd) {
            this.textBuf.replace(this.selStart, this.selEnd - this.selStart, c);
            if (this.hiddenBuf != null) {
                this.hiddenBuf.replace(this.selStart, this.selEnd - this.selStart, this.echoChar);
            }
            this.setTextCursor(this.selStart + 1, true, false);
        } else {
            this.textBuf.insert(this.tCursor.index, c);
            if (this.hiddenBuf != null) {
                this.hiddenBuf.insert(this.tCursor.index, this.echoChar);
            }
            this.shiftTextCursor(1, true);
        }
        if (this.textListener != null || (this.eventMask & 0x400) != 0) {
            Toolkit.eventQueue.postEvent(TextEvt.getEvent(this, 900));
        }
    }

    void makeVisible(int n) {
        int n2 = 2;
        TextBuffer textBuffer = this.getBuffer();
        int n3 = this.first;
        if (n < 0) {
            n = 0;
        } else if (n > textBuffer.len) {
            n = textBuffer.len;
        }
        if (n < this.first) {
            this.first = n;
        } else {
            int n4 = textBuffer.getPos(n);
            if (this.width > 0) {
                int n5 = this.width - 2 * n2 - 2 * xOffs - this.tCursor.width;
                while (n5 < n4 - textBuffer.getPos(this.first)) {
                    ++this.first;
                }
            }
        }
        if (this.first != n3) {
            this.repaint();
        }
    }

    public Dimension minimumSize() {
        return this.minimumSize(this.cols);
    }

    public Dimension minimumSize(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        int n2 = n;
        int n3 = fontMetrics.getHeight() + 6;
        int n4 = 0;
        if (n2 <= 0) {
            if (this.textBuf.len > 0) {
                n4 = this.textBuf.getWidth(0, this.textBuf.len);
            } else {
                n2 = 5;
            }
        }
        if (n4 == 0) {
            n4 = n2 * fontMetrics.charWidth('X');
        }
        return new Dimension(n4 += 2 * (2 + xOffs), n3);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        TextBuffer textBuffer = this.getBuffer();
        this.extendSelectionTo(n, (n = textBuffer.getIdxFrom(this.first, mouseEvent.getX() - xOffs - 2)) > this.tCursor.index);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && this.triggerPopup(mouseEvent.getX(), mouseEvent.getY()) != null) {
            return;
        }
        TextBuffer textBuffer = this.getBuffer();
        int n = textBuffer.getIdxFrom(this.first, mouseEvent.getX() - xOffs - 2);
        this.blankSelection();
        this.setTextCursor(n, true, false);
        this.requestFocus();
        if (mouseEvent.getModifiers() == 8) {
            this.pasteFromClipboard();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    void notifyAction() {
        if (this.aListener != null || (this.eventMask & 0x80) != 0) {
            Toolkit.eventQueue.postEvent(ActionEvt.getEvent(this, 1001, this.getText(), 0));
        }
    }

    public void paint(Graphics graphics) {
        int n = 2;
        this.paintBorder(graphics);
        graphics.setColor(this.bgClr);
        graphics.fillRect(n, n, this.width - 2 * n, this.height - 2 * n);
        this.repaintFrom(0);
    }

    public void paintInactiveCursor() {
        this.rgr.setColor(Defaults.TextCursorInactiveClr);
        this.tCursor.blank(this.rgr);
    }

    protected String paramString() {
        return super.paramString();
    }

    public Dimension preferredSize() {
        return this.preferredSize(this.cols);
    }

    public Dimension preferredSize(int n) {
        return this.getMinimumSize(n);
    }

    void process(ActionEvent actionEvent) {
        if (this.aListener != null || (this.eventMask & 0x80000080) == 128) {
            this.processEvent(actionEvent);
        }
        if ((this.flags & 0x20) > 0) {
            this.postEvent(Event.getEvent(actionEvent));
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.aListener != null) {
            this.aListener.actionPerformed(actionEvent);
        }
    }

    void propagateReshape() {
        if (this.rgr != null) {
            this.updateLinkedGraphics();
            this.rgr.setClip(2, 2, this.width - 4, this.height - 4);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.aListener = AWTEventMulticaster.remove(this.aListener, actionListener);
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.rgr != null) {
            this.rgr.dispose();
            this.rgr = null;
        }
    }

    void repaintFrom(int n) {
        if ((this.flags & 0x405) != 1029) {
            return;
        }
        TextBuffer textBuffer = this.getBuffer();
        if (n > 0) {
            --n;
        }
        if (this.selStart == this.selEnd || n > this.selEnd) {
            this.repaintRange(textBuffer, n, textBuffer.len, false);
        } else {
            if (this.selStart > n) {
                this.repaintRange(textBuffer, n, this.selStart, false);
            }
            if (this.selEnd > n) {
                this.repaintRange(textBuffer, Math.max(this.selStart, n), this.selEnd, true);
            }
            if (this.textBuf.len > this.selEnd) {
                this.repaintRange(textBuffer, this.selEnd, this.textBuf.len, false);
            }
        }
        if (AWTEvent.keyTgt == this) {
            this.tCursor.paint(this.rgr);
        } else if (Defaults.ShowInactiveCursor) {
            this.paintInactiveCursor();
        }
    }

    void repaintRange(TextBuffer textBuffer, int n, int n2, boolean bl) {
        int n3 = 2;
        if (this.rgr == null) {
            return;
        }
        if (n < this.first) {
            n = this.first;
        }
        int n4 = n3 + xOffs + textBuffer.getWidth(this.first, n);
        int n5 = n4 + textBuffer.getWidth(n, n2);
        if (bl) {
            this.rgr.setColor(Defaults.TextFieldSelBgClr);
            if (n2 == textBuffer.len) {
                n5 += this.tCursor.width;
            }
            this.rgr.fill3DRect(n4, this.tCursor.y, n5 - n4, this.tCursor.height + 1, true);
            this.rgr.setColor(Defaults.TextFieldSelTxtClr);
        } else {
            this.rgr.setColor(this.bgClr);
            if (n2 == textBuffer.len) {
                n5 = this.width - n3;
            }
            this.rgr.fillRect(n4, this.tCursor.y, n5 - n4, this.tCursor.height + 1);
            this.rgr.setColor(this.fgClr);
        }
        textBuffer.paintFrom(this.rgr, n3 + xOffs, 0, this.height, this.first, n, n2 - n);
    }

    void repaintTrailing() {
        this.repaintFrom(this.tCursor.index);
    }

    void replaceSelectionWith(String string) {
        this.deleteSelection();
        if (string != null) {
            this.textBuf.insert(this.selEnd, string);
            this.selEnd = this.selStart = this.selEnd + string.length();
            this.setCaretPosition(this.selStart);
            this.repaint();
        }
    }

    void resetSelIdxs(int n) {
        this.selStart = n;
        this.selEnd = n;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        int n5 = this.fm.getHeight();
        this.tCursor.setPos((this.height - n5) / 2, n5);
    }

    public void select(int n, int n2) {
        this.selStart = n;
        this.selEnd = n2;
        this.setTextCursor(this.selStart, false, true);
    }

    public void selectAll() {
        this.select(0, this.textBuf.len);
    }

    public void setCaretPosition(int n) {
        this.setTextCursor(n, true, false);
    }

    public void setColumns(int n) {
        if (this.cols != n) {
            this.cols = n;
        }
    }

    public void setEchoChar(char c) {
        this.setEchoCharacter(c);
    }

    public void setEchoCharacter(char c) {
        this.echoChar = c;
        if (c != '\u0000') {
            if (this.hiddenBuf == null) {
                this.hiddenBuf = new TextBuffer();
                this.hiddenBuf.setMetrics(this.fm, 20);
            }
            this.hiddenBuf.set(c, this.textBuf.len);
        } else {
            this.hiddenBuf = null;
        }
        this.setTextCursor(this.tCursor.index, false, true);
    }

    public void setFont(Font font) {
        this.fm = this.getFontMetrics(font);
        this.textBuf.setMetrics(this.fm, 20);
        if (this.hiddenBuf != null) {
            this.hiddenBuf.setMetrics(this.fm, 20);
        }
        int n = this.fm.getHeight();
        TextBuffer textBuffer = this.hiddenBuf != null ? this.hiddenBuf : this.textBuf;
        this.tCursor.setPos((this.height - n) / 2, n);
        this.tCursor.setIndex(this.tCursor.index, this.getCursorPos(textBuffer, this.tCursor.index));
        if (this.rgr != null) {
            this.rgr.setFont(font);
        }
        super.setFont(font);
    }

    void setResGraphics() {
        this.rgr = NativeGraphics.getClippedGraphics(this.rgr, this, 0, 0, 2, 2, this.width - 4, this.height - 4, false);
        if (this.rgr != null) {
            this.linkGraphics(this.rgr);
        }
    }

    public void setSelectionEnd(int n) {
        this.select(this.selStart, n);
    }

    public void setSelectionStart(int n) {
        this.select(n, this.selEnd);
    }

    public void setText(String string) {
        this.textBuf.set(string);
        if (this.hiddenBuf != null) {
            this.hiddenBuf.set(this.echoChar, string.length());
        }
        this.setTextCursor(0, true, false);
    }

    protected void setTextCursor(int n, boolean bl, boolean bl2) {
        int n2 = 0;
        int n3 = 2;
        TextBuffer textBuffer = this.getBuffer();
        if (n > textBuffer.len) {
            n = textBuffer.len;
        } else if (n < 0) {
            n = 0;
        }
        this.makeVisible(n);
        if (bl) {
            n2 = Math.min(this.selStart, n);
            this.resetSelIdxs(n);
        } else if (!bl2) {
            n2 = Math.min(n, this.tCursor.index);
        }
        this.tCursor.setIndex(n, this.getCursorPos(textBuffer, n));
        this.repaintFrom(n2);
    }

    protected void shiftTextCursor(int n, boolean bl) {
        if (this.tCursor.index + n < 0) {
            this.setTextCursor(0, bl, false);
        } else if (this.tCursor.index + n > this.textBuf.len) {
            this.setTextCursor(this.textBuf.len, bl, false);
        } else {
            this.setTextCursor(this.tCursor.index + n, bl, false);
        }
    }

    public TextField() {
        this("", 0);
    }

    public TextField(String string) {
        this(string, string != null ? string.length() : 0);
    }

    public TextField(String string, int n) {
        this.cols = n;
        this.cursor = Cursor.getPredefinedCursor(2);
        this.setFont(Defaults.TextFieldFont);
        this.setBackground(Defaults.TextFieldBgClr);
        this.setForeground(Defaults.TextFieldTxtClr);
        this.setText(string);
        this.buildMenu();
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public TextField(int n) {
        this("", n);
    }
}

