/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.ActionEvt;
import java.awt.Color;
import java.awt.Defaults;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuShortcut;
import java.awt.ShortcutConsumer;
import java.awt.ShortcutHandler;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class MenuItem
extends MenuComponent
implements ShortcutConsumer {
    static MenuItem separator = new MenuItem("-");
    private static final long serialVersionUID = -21757335363267194L;
    MenuShortcut shortcut;
    String label;
    ActionListener aListener;
    String aCmd;
    int eventMask;

    public synchronized void addActionListener(ActionListener actionListener) {
        if (!this.isSeparator()) {
            this.aListener = AWTEventMulticaster.add(this.aListener, actionListener);
        }
    }

    public void addNotify() {
        if ((this.flags & 0x400) == 0) {
            if (this.shortcut != null) {
                ShortcutHandler.addShortcut(this.shortcut, this.owner, this);
            }
            this.flags |= 0x400;
        }
    }

    Vector addShortcuts(Vector vector) {
        if (this.shortcut != null) {
            vector.addElement(this.shortcut);
        }
        return vector;
    }

    public void deleteShortcut() {
        if ((this.flags & 0x400) > 0 && this.shortcut != null) {
            ShortcutHandler.removeFromOwner(this.owner, this.shortcut);
        }
        this.shortcut = null;
    }

    public synchronized void disable() {
        this.setEnabled(false);
    }

    public void disableEvents(long l) {
        this.eventMask = (int)((long)this.eventMask & (l ^ -1L));
    }

    public synchronized void enable() {
        this.setEnabled(true);
    }

    public void enable(boolean bl) {
        this.setEnabled(bl);
    }

    public void enableEvents(long l) {
        this.eventMask = (int)((long)this.eventMask | l);
    }

    public String getActionCommand() {
        return this.aCmd != null ? this.aCmd : this.label;
    }

    int getHeight() {
        return this.isSeparator() ? 5 : this.fm.getHeight() + 5;
    }

    public String getLabel() {
        return this.label;
    }

    public MenuShortcut getShortcut() {
        return this.shortcut;
    }

    MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        if (menuShortcut.equals(this.shortcut)) {
            return this;
        }
        return null;
    }

    int getWidth() {
        return this.fm.stringWidth(this.label);
    }

    public void handleShortcut(MenuShortcut menuShortcut) {
        int n;
        int n2 = n = menuShortcut != null ? menuShortcut.mods : 0;
        if ((this.eventMask & Integer.MIN_VALUE) != 0) {
            return;
        }
        if (this.aListener != null || (this.eventMask & 0x80) != 0 || (this.flags & 0x20) != 0) {
            Toolkit.eventQueue.postEvent(ActionEvt.getEvent(this, 1001, this.getActionCommand(), n));
            return;
        }
        MenuContainer menuContainer = this.parent;
        while (menuContainer instanceof Menu) {
            Menu menu = (Menu)menuContainer;
            if (menu.aListener != null || (menu.eventMask & 0x80) != 0) {
                Toolkit.eventQueue.postEvent(ActionEvt.getEvent(menu, 1001, this.getActionCommand(), n));
                return;
            }
            menuContainer = menu.parent;
        }
    }

    public boolean isEnabled() {
        return (this.eventMask & Integer.MIN_VALUE) == 0;
    }

    public boolean isSeparator() {
        return separator == this;
    }

    int paint(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, Color color2, boolean bl) {
        int n6 = this.getHeight();
        int n7 = n5 > 0 ? n3 + (n5 - n6) / 2 : n3;
        int n8 = n + n2;
        if (separator == this) {
            graphics.setColor(color);
            graphics.draw3DRect(n + 2, n3 + n6 / 2, n4 - 4, 1, false);
        } else {
            n7 += this.fm.getAscent() + 3;
            graphics.setFont(this.fnt);
            if (bl && (this.eventMask & Integer.MIN_VALUE) == 0) {
                graphics.setColor(Defaults.MenuSelBgClr);
                graphics.fill3DRect(n + 1, n3 + 1, n4 - 2, n6 - 1, false);
            } else {
                graphics.setColor(color);
                graphics.fillRect(n + 1, n3 + 1, n4 - 1, n6);
            }
            if ((this.eventMask & Integer.MIN_VALUE) == 0) {
                if (Defaults.MenuTxtCarved) {
                    graphics.setColor(Color.white);
                    graphics.drawString(this.label, n8 + 1, n7 + 1);
                }
                graphics.setColor(bl ? Defaults.MenuSelTxtClr : color2);
            } else {
                graphics.setColor(color.darker());
            }
            graphics.drawString(this.label, n8, n7);
        }
        return n6;
    }

    public String paramString() {
        return this.getClass().getName() + "[Label: " + this.label + "]";
    }

    void process(ActionEvent actionEvent) {
        if (this.aListener != null || (this.eventMask & 0x80000080) == 128) {
            this.processEvent(actionEvent);
        }
        if ((this.flags & 0x20) > 0) {
            this.postEvent(Event.getEvent(actionEvent));
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.aListener != null) {
            this.aListener.actionPerformed(actionEvent);
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent.id == 1001) {
            this.processActionEvent((ActionEvent)aWTEvent);
        }
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.aListener = AWTEventMulticaster.remove(this.aListener, actionListener);
    }

    public void removeNotify() {
        if ((this.flags & 0x400) > 0) {
            if (this.shortcut != null) {
                ShortcutHandler.removeFromOwner(this.owner, this.shortcut);
            }
            this.flags &= 0xFFFFFBFF;
            this.owner = null;
            this.parent = null;
        }
    }

    public void setActionCommand(String string) {
        this.aCmd = string;
    }

    public synchronized void setEnabled(boolean bl) {
        this.eventMask = bl ? (this.eventMask &= Integer.MAX_VALUE) : (this.eventMask |= Integer.MIN_VALUE);
    }

    public synchronized void setLabel(String string) {
        this.label = string;
    }

    public void setShortcut(MenuShortcut menuShortcut) {
        MenuShortcut menuShortcut2;
        MenuShortcut menuShortcut3 = menuShortcut2 = menuShortcut != null ? new MenuShortcut(menuShortcut) : null;
        if ((this.flags & 0x400) > 0) {
            if (this.shortcut != null) {
                ShortcutHandler.removeFromOwner(this.owner, this.shortcut);
            }
            if (menuShortcut2 != null) {
                ShortcutHandler.addShortcut(menuShortcut2, this.owner, this);
            }
        }
        this.shortcut = menuShortcut2;
    }

    public MenuItem() {
        this(null, null);
    }

    public MenuItem(String string) {
        this(string, null);
    }

    public MenuItem(String string, MenuShortcut menuShortcut) {
        this.setShortcut(menuShortcut);
        this.setLabel(string);
        this.setFont(defFnt);
    }
}

