/*
** The Sleuth Kit
**
** Brian Carrier [carrier@sleuthkit.org]
** Copyright (c) 2003 Brian Carrier.  All rights reserved
**
*/

#ifndef _SUN_H
#define _SUN_H

typedef struct {
	u_int8_t asciilabel[128];

	/* VTOC */
	u_int8_t version[4];
	u_int8_t vol_name[8];
	u_int8_t num_parts[2];

	struct {
		u_int8_t type[2];
		u_int8_t flag[2];
	} part_meta[8];

	u_int8_t bootinfo[4][3];
	u_int8_t reserved0[2];
	u_int8_t sanity[4];
	u_int8_t reserved1[38];
	u_int8_t timestamp[8][4];
	/* End VTOC */


	u_int8_t write_reinstruct[2];
	u_int8_t read_reinstruct[2];
	u_int8_t reserved2[154];  
	u_int8_t rpm[2];
	u_int8_t num_ph_cyl[2];
	u_int8_t alt_per_cyl[2];
	u_int8_t reserved3[4];
	u_int8_t interleave[2];
	u_int8_t num_cyl[2];
	u_int8_t num_alt_cyl[2];
	u_int8_t num_head[2];
	u_int8_t sec_per_tr[2];
	u_int8_t reserved5[4];

	struct {
		u_int8_t start_cyl[4];
		u_int8_t size_blk[4];
	} part_layout[8];

	u_int8_t magic[2];
	u_int8_t checksum[2];

} sun_dlabel_sparc;


typedef struct {

	/* VTOC */
	u_int8_t bootinfo[3][4];
	u_int8_t sanity[4];
	u_int8_t version[4];
	u_int8_t vol_name[8];
	u_int8_t sec_size[2];
	u_int8_t num_parts[2];
	u_int8_t reserved0[40];

	struct {
		u_int8_t type[2];
		u_int8_t flag[2];
		u_int8_t start_sec[4];
		u_int8_t size_sec[4];
	} part[16];

	u_int8_t timestamp[16][4];
	u_int8_t asciilabel[128];
	/* END of VTOC */

	u_int8_t num_ph_cyl[4];
	u_int8_t num_cyl[4];
	u_int8_t num_alt_cyl[2];
	u_int8_t cyl_offset[2];
	u_int8_t num_head[4];
	u_int8_t sec_per_tr[4];
	u_int8_t interleave[2];
	u_int8_t skew[2];
	u_int8_t alt_per_cyl[2];
	u_int8_t rpm[2];
	u_int8_t write_reinstruct[2];
	u_int8_t read_reinstruct[2];
	u_int8_t reserved1[8];
	u_int8_t reserved2[12]; 
	u_int8_t magic[2];
	u_int8_t checksum[2];

} sun_dlabel_i386;

#define SUN_MAGIC	0xDABE
#define SUN_SANITY	0x600DDEEE

#define SUN_FLAG_UNMNT	0x01
#define SUN_FLAG_RO		0x10

#define SUN_SPARC_PART_OFFSET	0
#define SUN_I386_PART_OFFSET	1

#endif
