/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.connection.internal.ui.wizards;

import java.util.Properties;

/**
 * @author ledunnel
 */
public class ConnectionWizardProperties {
	private String classLocation = null;

	private String connectionName = null;
	
	private String databaseName = null;
	
	private String driverName = null;

	private String driverClassName = null;
	
	private String password = null;

	private String product = null;

	private String url = null;

	private String userID = null;

	private String version = null;
	
	private Properties customProperties = null;

	/**
	 * @return the driver class loading path
	 */
	public String getClassLocation() {
		return classLocation;
	}

	/**
	 * specify the class path to load the driver class.
	 * 
	 * @param path
	 *            semicolon separated class path
	 */
	public void setClassLocation(String path) {
		this.classLocation = path;
	}

	/**
	 * @return the database name.
	 */
	public String getDatabaseName() {
		return databaseName;
	}

	/**
	 * @param className
	 *            the database name.
	 */
	public void setDatabaseName(String databaseName) {
		this.databaseName = databaseName;
	}
	
	
	/**
	 * @return the JDBC driver class full name.
	 */
	public String getDriverClassName() {
		return driverClassName;
	}

	/**
	 * @param className
	 *            the driver class full name.
	 */
	public void setDriverClassName(String className) {
		this.driverClassName = className;
	}

	/**
	 * 
	 * @return JDBC connection URL
	 */
	public String getURL() {
		return this.url;
	}

	/**
	 * @param url
	 *            JDBC connection URL
	 */
	public void setURL(String url) {
		this.url = url;
	}

	/**
	 * @return User ID
	 */
	public String getUserID() {
		return this.userID;
	}

	/**
	 * @param User
	 *            ID
	 */
	public void setUserID(String id) {
		this.userID = id;
	}

	/**
	 * @return Password
	 */
	public String getPassword() {
		return this.password;
	}

	/**
	 * @param Password
	 */
	public void setPassword(String pwd) {
		this.password = pwd;
	}
	
	/**
	 * @return product string
	 */
	public String getProduct() {
		return this.product;
	}

	/**
	 * @param product
	 *            string
	 */
	public void setProduct(String product) {
		this.product = product;
	}

	/**
	 * @return version string
	 */
	public String getVersion() {
		return this.version;
	}

	/**
	 * @param version
	 *            string
	 */
	public void setVersion(String version) {
		this.version = version;
	}

	/**
	 * @return connection name
	 */
	public String getConnectionName() {
		return this.connectionName;
	}

	/**
	 * @param connection
	 *            name
	 */
	public void setConnectionName(String connectionName) {
		this.connectionName = connectionName;
	}
	
	/**
	 * @return driver name
	 */
	public String getDriverName() {
		return this.driverName;
	}

	/**
	 * @param driver
	 *            name
	 */
	public void setDriverName(String driverName) {
		this.driverName = driverName;
	}
	
	/**
	 * @return custom properties
	 */
	public Properties getCustomProperties() {
		return this.customProperties;
	}

	/**
	 * @param custom properties
	 */
	public void setCustomProperties(Properties customProperties) {
		this.customProperties = customProperties;
	}
}