/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.deploy;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.jst.j2ee.internal.deploy.DeployerRegistry;

public class DeployerRegistryReader
extends RegistryReader {
    static final String J2EE_DEPLOYER_EXTENSION_POINT = "DeployerExtension";
    static final String TARGET_SERVER_RUNTIME_ID = "runtime_server_id";
    static final String RUNTIME = "runtime";
    static final String DEPLOYER = "deployer";
    public static final String DEPLOYER_CLASS = "deployer_class";
    static final String MODULE_TYPE_NATURE_ID = "module_nature_id";
    static final String NATURE = "nature";
    static final String COMPONENT_TYPE_ID = "component_type";
    static final String COMPONENT = "component";

    public DeployerRegistryReader() {
        super("org.eclipse.jst.j2ee", J2EE_DEPLOYER_EXTENSION_POINT);
    }

    public boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals(DEPLOYER)) {
            return false;
        }
        ArrayList<String> runtimeList = new ArrayList<String>();
        ArrayList<String> natureandcomponents = new ArrayList<String>();
        IConfigurationElement[] runtimes = element.getChildren(RUNTIME);
        int i = 0;
        while (i < runtimes.length) {
            IConfigurationElement runtime = runtimes[i];
            String serverTarget = runtime.getAttribute(TARGET_SERVER_RUNTIME_ID);
            runtimeList.add(serverTarget);
            ++i;
        }
        IConfigurationElement[] natures = element.getChildren(NATURE);
        int i2 = 0;
        while (i2 < natures.length) {
            IConfigurationElement nature = natures[i2];
            String natureID = nature.getAttribute(MODULE_TYPE_NATURE_ID);
            natureandcomponents.add(natureID);
            ++i2;
        }
        IConfigurationElement[] components = element.getChildren(COMPONENT);
        int i3 = 0;
        while (i3 < components.length) {
            IConfigurationElement component = components[i3];
            String compType = component.getAttribute(COMPONENT_TYPE_ID);
            natureandcomponents.add(compType);
            ++i3;
        }
        String deployer = element.getAttribute(DEPLOYER_CLASS);
        if (deployer != null) {
            DeployerRegistry.instance().register(element, runtimeList, natureandcomponents);
            return true;
        }
        return false;
    }
}

