/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.provisional.preferences;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;

public class CSSPreferenceHelper {
    private static CSSPreferenceHelper fInstance = null;

    public static synchronized CSSPreferenceHelper getInstance() {
        if (fInstance == null) {
            fInstance = new CSSPreferenceHelper();
        }
        return fInstance;
    }

    public String getBetweenValueString() {
        return this.getPreferences().getString("betweenValue");
    }

    public String getIndentString() {
        StringBuffer indent = new StringBuffer();
        Preferences preferences = this.getPreferences();
        if (preferences != null) {
            char indentChar = ' ';
            String indentCharPref = preferences.getString("indentationChar");
            if ("tab".equals(indentCharPref)) {
                indentChar = '\t';
            }
            int indentationWidth = preferences.getInt("indentationSize");
            int i = 0;
            while (i < indentationWidth) {
                indent.append(indentChar);
                ++i;
            }
        }
        return indent.toString();
    }

    public int getMaxLineWidth() {
        Preferences prefs = this.getPreferences();
        return prefs.getInt("lineWidth");
    }

    public String getQuoteString(ICSSModel model) {
        return this.getPreferences().getString("quote");
    }

    public int getSpacesPostDelimiter() {
        return this.getPreferences().getInt("postDelim");
    }

    public int getSpacesPreDelimiter() {
        return this.getPreferences().getInt("preDelim");
    }

    public boolean isIdentUpperCase() {
        return this.getPreferences().getInt("identifierCase") == 2;
    }

    public boolean isNewLineOnOpenBrace() {
        return this.getPreferences().getBoolean("newLineOnOpenBrace");
    }

    public boolean isOnePropertyPerLine() {
        return this.getPreferences().getBoolean("onePropertyPerLine");
    }

    public boolean isProhibitWrapOnAttr() {
        return this.getPreferences().getBoolean("prohibitWrapOnAttr");
    }

    public boolean isPropNameUpperCase() {
        return this.getPreferences().getInt("propNameCase") == 2;
    }

    public boolean isPropValueUpperCase() {
        return this.getPreferences().getInt("propValueCase") == 2;
    }

    public boolean isQuoteInURI() {
        return this.getPreferences().getBoolean("quoteInURI");
    }

    protected void setBetweenValueString(String newBetweenValueString) {
        this.getPreferences().setValue("betweenValue", newBetweenValueString);
    }

    protected void setIdentUpperCase(boolean newIdentUpperCase) {
        int theCase = 1;
        if (newIdentUpperCase) {
            theCase = 2;
        }
        this.getPreferences().setValue("identifierCase", theCase);
    }

    protected void setOnePropertyPerLine(boolean newOnePropertyPerLine) {
        this.getPreferences().setValue("onePropertyPerLine", newOnePropertyPerLine);
    }

    protected void setProhibitWrapOnAttr(boolean newProhibitWrapOnAttr) {
        this.getPreferences().setValue("prohibitWrapOnAttr", newProhibitWrapOnAttr);
    }

    protected void setPropNameUpperCase(boolean newPropNameUpperCase) {
        int theCase = 1;
        if (newPropNameUpperCase) {
            theCase = 2;
        }
        this.getPreferences().setValue("propNameCase", theCase);
    }

    protected void setPropValueUpperCase(boolean newPropValueUpperCase) {
        int theCase = 1;
        if (newPropValueUpperCase) {
            theCase = 2;
        }
        this.getPreferences().setValue("propValueCase", theCase);
    }

    public void setQuoteString(String quote) {
        this.getPreferences().setValue("quote", quote);
    }

    public void setSpacesPostDelimiter(int num) {
        this.getPreferences().setValue("postDelim", num);
    }

    public void setSpacesPreDelimiter(int num) {
        this.getPreferences().setValue("preDelim", num);
    }

    private Preferences getPreferences() {
        CSSCorePlugin cssModelPlugin = CSSCorePlugin.getDefault();
        return cssModelPlugin.getPluginPreferences();
    }

    private CSSPreferenceHelper() {
    }
}

