/* $Id: utf8.c,v 1.2 2004/11/08 06:50:10 onoe Exp $ */

/*-
 * Copyright (c) 2004 Atsushi Onoe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "utf8.h"

static const unsigned long eucjp_utf8[] = {
	/* 0xa1a1 */
0xe38080, 0xe38081, 0xe38082, 0xefbc8c, 0xefbc8e, 0xe383bb, 0xefbc9a, 0xefbc9b, 
0xefbc9f, 0xefbc81, 0xe3829b, 0xe3829c, 0x00c2b4, 0xefbd80, 0x00c2a8, 0xefbcbe, 
0xefbfa3, 0xefbcbf, 0xe383bd, 0xe383be, 0xe3829d, 0xe3829e, 0xe38083, 0xe4bb9d, 
0xe38085, 0xe38086, 0xe38087, 0xe383bc, 0xe28095, 0xe28090, 0xefbc8f, 0x000000, 
0xe3809c, 0xe28096, 0xefbd9c, 0xe280a6, 0xe280a5, 0xe28098, 0xe28099, 0xe2809c, 
0xe2809d, 0xefbc88, 0xefbc89, 0xe38094, 0xe38095, 0xefbcbb, 0xefbcbd, 0xefbd9b, 
0xefbd9d, 0xe38088, 0xe38089, 0xe3808a, 0xe3808b, 0xe3808c, 0xe3808d, 0xe3808e, 
0xe3808f, 0xe38090, 0xe38091, 0xefbc8b, 0xe28892, 0x00c2b1, 0x00c397, 0x00c3b7, 
0xefbc9d, 0xe289a0, 0xefbc9c, 0xefbc9e, 0xe289a6, 0xe289a7, 0xe2889e, 0xe288b4, 
0xe29982, 0xe29980, 0x00c2b0, 0xe280b2, 0xe280b3, 0xe28483, 0xefbfa5, 0xefbc84, 
0x00c2a2, 0x00c2a3, 0xefbc85, 0xefbc83, 0xefbc86, 0xefbc8a, 0xefbca0, 0x00c2a7, 
0xe29886, 0xe29885, 0xe2978b, 0xe2978f, 0xe2978e, 0xe29787, 
	/* 0xa2a1 */
0xe29786, 0xe296a1, 0xe296a0, 0xe296b3, 0xe296b2, 0xe296bd, 0xe296bc, 0xe280bb, 
0xe38092, 0xe28692, 0xe28690, 0xe28691, 0xe28693, 0xe38093, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0xe28888, 0xe2888b, 0xe28a86, 0xe28a87, 0xe28a82, 0xe28a83, 0xe288aa, 
0xe288a9, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0xe288a7, 0xe288a8, 0x00c2ac, 0xe28792, 0xe28794, 0xe28880, 0xe28883, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0xe288a0, 0xe28aa5, 0xe28c92, 0xe28882, 0xe28887, 
0xe289a1, 0xe28992, 0xe289aa, 0xe289ab, 0xe2889a, 0xe288bd, 0xe2889d, 0xe288b5, 
0xe288ab, 0xe288ac, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0xe284ab, 0xe280b0, 0xe299af, 0xe299ad, 0xe299aa, 0xe280a0, 0xe280a1, 
0x00c2b6, 0x000000, 0x000000, 0x000000, 0x000000, 0xe297af, 
	/* 0xa3a1 */
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0xefbc90, 
0xefbc91, 0xefbc92, 0xefbc93, 0xefbc94, 0xefbc95, 0xefbc96, 0xefbc97, 0xefbc98, 
0xefbc99, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0xefbca1, 0xefbca2, 0xefbca3, 0xefbca4, 0xefbca5, 0xefbca6, 0xefbca7, 0xefbca8, 
0xefbca9, 0xefbcaa, 0xefbcab, 0xefbcac, 0xefbcad, 0xefbcae, 0xefbcaf, 0xefbcb0, 
0xefbcb1, 0xefbcb2, 0xefbcb3, 0xefbcb4, 0xefbcb5, 0xefbcb6, 0xefbcb7, 0xefbcb8, 
0xefbcb9, 0xefbcba, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0xefbd81, 0xefbd82, 0xefbd83, 0xefbd84, 0xefbd85, 0xefbd86, 0xefbd87, 0xefbd88, 
0xefbd89, 0xefbd8a, 0xefbd8b, 0xefbd8c, 0xefbd8d, 0xefbd8e, 0xefbd8f, 0xefbd90, 
0xefbd91, 0xefbd92, 0xefbd93, 0xefbd94, 0xefbd95, 0xefbd96, 0xefbd97, 0xefbd98, 
0xefbd99, 0xefbd9a, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0xa4a1 */
0xe38181, 0xe38182, 0xe38183, 0xe38184, 0xe38185, 0xe38186, 0xe38187, 0xe38188, 
0xe38189, 0xe3818a, 0xe3818b, 0xe3818c, 0xe3818d, 0xe3818e, 0xe3818f, 0xe38190, 
0xe38191, 0xe38192, 0xe38193, 0xe38194, 0xe38195, 0xe38196, 0xe38197, 0xe38198, 
0xe38199, 0xe3819a, 0xe3819b, 0xe3819c, 0xe3819d, 0xe3819e, 0xe3819f, 0xe381a0, 
0xe381a1, 0xe381a2, 0xe381a3, 0xe381a4, 0xe381a5, 0xe381a6, 0xe381a7, 0xe381a8, 
0xe381a9, 0xe381aa, 0xe381ab, 0xe381ac, 0xe381ad, 0xe381ae, 0xe381af, 0xe381b0, 
0xe381b1, 0xe381b2, 0xe381b3, 0xe381b4, 0xe381b5, 0xe381b6, 0xe381b7, 0xe381b8, 
0xe381b9, 0xe381ba, 0xe381bb, 0xe381bc, 0xe381bd, 0xe381be, 0xe381bf, 0xe38280, 
0xe38281, 0xe38282, 0xe38283, 0xe38284, 0xe38285, 0xe38286, 0xe38287, 0xe38288, 
0xe38289, 0xe3828a, 0xe3828b, 0xe3828c, 0xe3828d, 0xe3828e, 0xe3828f, 0xe38290, 
0xe38291, 0xe38292, 0xe38293, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0xa5a1 */
0xe382a1, 0xe382a2, 0xe382a3, 0xe382a4, 0xe382a5, 0xe382a6, 0xe382a7, 0xe382a8, 
0xe382a9, 0xe382aa, 0xe382ab, 0xe382ac, 0xe382ad, 0xe382ae, 0xe382af, 0xe382b0, 
0xe382b1, 0xe382b2, 0xe382b3, 0xe382b4, 0xe382b5, 0xe382b6, 0xe382b7, 0xe382b8, 
0xe382b9, 0xe382ba, 0xe382bb, 0xe382bc, 0xe382bd, 0xe382be, 0xe382bf, 0xe38380, 
0xe38381, 0xe38382, 0xe38383, 0xe38384, 0xe38385, 0xe38386, 0xe38387, 0xe38388, 
0xe38389, 0xe3838a, 0xe3838b, 0xe3838c, 0xe3838d, 0xe3838e, 0xe3838f, 0xe38390, 
0xe38391, 0xe38392, 0xe38393, 0xe38394, 0xe38395, 0xe38396, 0xe38397, 0xe38398, 
0xe38399, 0xe3839a, 0xe3839b, 0xe3839c, 0xe3839d, 0xe3839e, 0xe3839f, 0xe383a0, 
0xe383a1, 0xe383a2, 0xe383a3, 0xe383a4, 0xe383a5, 0xe383a6, 0xe383a7, 0xe383a8, 
0xe383a9, 0xe383aa, 0xe383ab, 0xe383ac, 0xe383ad, 0xe383ae, 0xe383af, 0xe383b0, 
0xe383b1, 0xe383b2, 0xe383b3, 0xe383b4, 0xe383b5, 0xe383b6, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0xa6a1 */
0x00ce91, 0x00ce92, 0x00ce93, 0x00ce94, 0x00ce95, 0x00ce96, 0x00ce97, 0x00ce98, 
0x00ce99, 0x00ce9a, 0x00ce9b, 0x00ce9c, 0x00ce9d, 0x00ce9e, 0x00ce9f, 0x00cea0, 
0x00cea1, 0x00cea3, 0x00cea4, 0x00cea5, 0x00cea6, 0x00cea7, 0x00cea8, 0x00cea9, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x00ceb1, 0x00ceb2, 0x00ceb3, 0x00ceb4, 0x00ceb5, 0x00ceb6, 0x00ceb7, 0x00ceb8, 
0x00ceb9, 0x00ceba, 0x00cebb, 0x00cebc, 0x00cebd, 0x00cebe, 0x00cebf, 0x00cf80, 
0x00cf81, 0x00cf83, 0x00cf84, 0x00cf85, 0x00cf86, 0x00cf87, 0x00cf88, 0x00cf89, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0xa7a1 */
0x00d090, 0x00d091, 0x00d092, 0x00d093, 0x00d094, 0x00d095, 0x00d081, 0x00d096, 
0x00d097, 0x00d098, 0x00d099, 0x00d09a, 0x00d09b, 0x00d09c, 0x00d09d, 0x00d09e, 
0x00d09f, 0x00d0a0, 0x00d0a1, 0x00d0a2, 0x00d0a3, 0x00d0a4, 0x00d0a5, 0x00d0a6, 
0x00d0a7, 0x00d0a8, 0x00d0a9, 0x00d0aa, 0x00d0ab, 0x00d0ac, 0x00d0ad, 0x00d0ae, 
0x00d0af, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x00d0b0, 0x00d0b1, 0x00d0b2, 0x00d0b3, 0x00d0b4, 0x00d0b5, 0x00d191, 0x00d0b6, 
0x00d0b7, 0x00d0b8, 0x00d0b9, 0x00d0ba, 0x00d0bb, 0x00d0bc, 0x00d0bd, 0x00d0be, 
0x00d0bf, 0x00d180, 0x00d181, 0x00d182, 0x00d183, 0x00d184, 0x00d185, 0x00d186, 
0x00d187, 0x00d188, 0x00d189, 0x00d18a, 0x00d18b, 0x00d18c, 0x00d18d, 0x00d18e, 
0x00d18f, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0xa8a1 */
0xe29480, 0xe29482, 0xe2948c, 0xe29490, 0xe29498, 0xe29494, 0xe2949c, 0xe294ac, 
0xe294a4, 0xe294b4, 0xe294bc, 0xe29481, 0xe29483, 0xe2948f, 0xe29493, 0xe2949b, 
0xe29497, 0xe294a3, 0xe294b3, 0xe294ab, 0xe294bb, 0xe2958b, 0xe294a0, 0xe294af, 
0xe294a8, 0xe294b7, 0xe294bf, 0xe2949d, 0xe294b0, 0xe294a5, 0xe294b8, 0xe29582, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0xa9a1 */
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0xaaa1 */
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0xaba1 */
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0xaca1 */
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0xada1 */
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0xaea1 */
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0xafa1 */
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0xb0a1 */
0xe4ba9c, 0xe59496, 0xe5a883, 0xe998bf, 0xe59380, 0xe6849b, 0xe68ca8, 0xe5a7b6, 
0xe980a2, 0xe891b5, 0xe88c9c, 0xe7a990, 0xe682aa, 0xe68fa1, 0xe6b8a5, 0xe697ad, 
0xe891a6, 0xe88aa6, 0xe9afb5, 0xe6a293, 0xe59ca7, 0xe696a1, 0xe689b1, 0xe5ae9b, 
0xe5a790, 0xe899bb, 0xe9a3b4, 0xe7b5a2, 0xe7b6be, 0xe9ae8e, 0xe68896, 0xe7b29f, 
0xe8a2b7, 0xe5ae89, 0xe5bab5, 0xe68c89, 0xe69a97, 0xe6a188, 0xe99787, 0xe99e8d, 
0xe69d8f, 0xe4bba5, 0xe4bc8a, 0xe4bd8d, 0xe4be9d, 0xe58189, 0xe59bb2, 0xe5a4b7, 
0xe5a794, 0xe5a881, 0xe5b089, 0xe6839f, 0xe6848f, 0xe685b0, 0xe69893, 0xe6a485, 
0xe782ba, 0xe7958f, 0xe795b0, 0xe7a7bb, 0xe7b6ad, 0xe7b7af, 0xe88383, 0xe8908e, 
0xe8a1a3, 0xe8ac82, 0xe98195, 0xe981ba, 0xe58cbb, 0xe4ba95, 0xe4baa5, 0xe59f9f, 
0xe882b2, 0xe98381, 0xe7a3af, 0xe4b880, 0xe5a3b1, 0xe6baa2, 0xe980b8, 0xe7a8b2, 
0xe88ca8, 0xe88a8b, 0xe9b0af, 0xe58581, 0xe58db0, 0xe592bd, 0xe593a1, 0xe59ba0, 
0xe5a7bb, 0xe5bc95, 0xe9a3b2, 0xe6b7ab, 0xe883a4, 0xe894ad, 
	/* 0xb1a1 */
0xe999a2, 0xe999b0, 0xe99aa0, 0xe99fbb, 0xe5908b, 0xe58fb3, 0xe5ae87, 0xe7838f, 
0xe7bebd, 0xe8bf82, 0xe99ba8, 0xe58daf, 0xe9b59c, 0xe7aaba, 0xe4b891, 0xe7a293, 
0xe887bc, 0xe6b8a6, 0xe59898, 0xe59484, 0xe6ac9d, 0xe8949a, 0xe9b0bb, 0xe5a7a5, 
0xe58ea9, 0xe6b5a6, 0xe7939c, 0xe9968f, 0xe59982, 0xe4ba91, 0xe9818b, 0xe99bb2, 
0xe88d8f, 0xe9a48c, 0xe58fa1, 0xe596b6, 0xe5acb0, 0xe5bdb1, 0xe698a0, 0xe69bb3, 
0xe6a084, 0xe6b0b8, 0xe6b3b3, 0xe6b4a9, 0xe7919b, 0xe79b88, 0xe7a98e, 0xe9a0b4, 
0xe88bb1, 0xe8a19b, 0xe8a9a0, 0xe98bad, 0xe6b6b2, 0xe796ab, 0xe79b8a, 0xe9a785, 
0xe682a6, 0xe8ac81, 0xe8b68a, 0xe996b2, 0xe6a68e, 0xe58ead, 0xe58686, 0xe59c92, 
0xe5a0b0, 0xe5a584, 0xe5aeb4, 0xe5bbb6, 0xe680a8, 0xe68ea9, 0xe68fb4, 0xe6b2bf, 
0xe6bc94, 0xe7828e, 0xe78494, 0xe78599, 0xe78795, 0xe78cbf, 0xe7b881, 0xe889b6, 
0xe88b91, 0xe89697, 0xe981a0, 0xe9899b, 0xe9b49b, 0xe5a1a9, 0xe696bc, 0xe6b19a, 
0xe794a5, 0xe587b9, 0xe5a4ae, 0xe5a5a5, 0xe5be80, 0xe5bf9c, 
	/* 0xb2a1 */
0xe68abc, 0xe697ba, 0xe6a8aa, 0xe6aca7, 0xe6aeb4, 0xe78e8b, 0xe7bf81, 0xe8a596, 
0xe9b4ac, 0xe9b48e, 0xe9bb84, 0xe5b2a1, 0xe6b296, 0xe88dbb, 0xe58484, 0xe5b18b, 
0xe686b6, 0xe88786, 0xe6a1b6, 0xe789a1, 0xe4b999, 0xe4bfba, 0xe58db8, 0xe681a9, 
0xe6b8a9, 0xe7a98f, 0xe99fb3, 0xe4b88b, 0xe58c96, 0xe4bbae, 0xe4bd95, 0xe4bcbd, 
0xe4bea1, 0xe4bdb3, 0xe58aa0, 0xe58faf, 0xe59889, 0xe5a48f, 0xe5ab81, 0xe5aeb6, 
0xe5afa1, 0xe7a791, 0xe69a87, 0xe69e9c, 0xe69eb6, 0xe6ad8c, 0xe6b2b3, 0xe781ab, 
0xe78f82, 0xe7a68d, 0xe7a6be, 0xe7a8bc, 0xe7ae87, 0xe88ab1, 0xe88b9b, 0xe88c84, 
0xe88db7, 0xe88faf, 0xe88f93, 0xe89da6, 0xe8aab2, 0xe598a9, 0xe8b2a8, 0xe8bfa6, 
0xe9818e, 0xe99c9e, 0xe89a8a, 0xe4bf84, 0xe5b3a8, 0xe68891, 0xe78999, 0xe794bb, 
0xe887a5, 0xe88abd, 0xe89bbe, 0xe8b380, 0xe99b85, 0xe9a493, 0xe9a795, 0xe4bb8b, 
0xe4bc9a, 0xe8a7a3, 0xe59b9e, 0xe5a18a, 0xe5a38a, 0xe5bbbb, 0xe5bfab, 0xe680aa, 
0xe68294, 0xe681a2, 0xe68790, 0xe68892, 0xe68b90, 0xe694b9, 
	/* 0xb3a1 */
0xe9ad81, 0xe699a6, 0xe6a2b0, 0xe6b5b7, 0xe781b0, 0xe7958c, 0xe79a86, 0xe7b5b5, 
0xe88aa5, 0xe89fb9, 0xe9968b, 0xe99a8e, 0xe8b29d, 0xe587b1, 0xe58abe, 0xe5a496, 
0xe592b3, 0xe5aeb3, 0xe5b496, 0xe685a8, 0xe6a682, 0xe6b6af, 0xe7a28d, 0xe8938b, 
0xe8a197, 0xe8a9b2, 0xe98ea7, 0xe9aab8, 0xe6b5ac, 0xe9a6a8, 0xe89b99, 0xe59ea3, 
0xe69fbf, 0xe89b8e, 0xe9888e, 0xe58a83, 0xe59a87, 0xe59084, 0xe5bb93, 0xe68ba1, 
0xe692b9, 0xe6a0bc, 0xe6a0b8, 0xe6aebb, 0xe78db2, 0xe7a2ba, 0xe7a9ab, 0xe8a69a, 
0xe8a792, 0xe8b5ab, 0xe8bc83, 0xe983ad, 0xe996a3, 0xe99a94, 0xe99da9, 0xe5ada6, 
0xe5b2b3, 0xe6a5bd, 0xe9a18d, 0xe9a18e, 0xe68e9b, 0xe7aca0, 0xe6a8ab, 0xe6a9bf, 
0xe6a2b6, 0xe9b08d, 0xe6bd9f, 0xe589b2, 0xe5969d, 0xe681b0, 0xe68bac, 0xe6b4bb, 
0xe6b887, 0xe6bb91, 0xe8919b, 0xe8a490, 0xe8bd84, 0xe4b894, 0xe9b0b9, 0xe58fb6, 
0xe6a49b, 0xe6a8ba, 0xe99e84, 0xe6a0aa, 0xe5859c, 0xe7ab83, 0xe892b2, 0xe9879c, 
0xe98e8c, 0xe5999b, 0xe9b4a8, 0xe6a0a2, 0xe88c85, 0xe890b1, 
	/* 0xb4a1 */
0xe7b2a5, 0xe58888, 0xe88b85, 0xe793a6, 0xe4b9be, 0xe4be83, 0xe586a0, 0xe5af92, 
0xe5888a, 0xe58b98, 0xe58ba7, 0xe5b7bb, 0xe5969a, 0xe5a0aa, 0xe5a7a6, 0xe5ae8c, 
0xe5ae98, 0xe5af9b, 0xe5b9b2, 0xe5b9b9, 0xe682a3, 0xe6849f, 0xe685a3, 0xe686be, 
0xe68f9b, 0xe695a2, 0xe69f91, 0xe6a193, 0xe6a3ba, 0xe6acbe, 0xe6ad93, 0xe6b197, 
0xe6bca2, 0xe6be97, 0xe6bd85, 0xe792b0, 0xe79498, 0xe79ba3, 0xe79c8b, 0xe7abbf, 
0xe7aea1, 0xe7b0a1, 0xe7b7a9, 0xe7bcb6, 0xe7bfb0, 0xe8829d, 0xe889a6, 0xe88e9e, 
0xe8a6b3, 0xe8ab8c, 0xe8b2ab, 0xe98284, 0xe99191, 0xe99693, 0xe99691, 0xe996a2, 
0xe999a5, 0xe99f93, 0xe9a4a8, 0xe88898, 0xe4b8b8, 0xe590ab, 0xe5b2b8, 0xe5b78c, 
0xe78ea9, 0xe7998c, 0xe79cbc, 0xe5b2a9, 0xe7bfab, 0xe8b48b, 0xe99b81, 0xe9a091, 
0xe9a194, 0xe9a198, 0xe4bc81, 0xe4bc8e, 0xe58db1, 0xe5969c, 0xe599a8, 0xe59fba, 
0xe5a587, 0xe5ac89, 0xe5af84, 0xe5b290, 0xe5b88c, 0xe5b9be, 0xe5bf8c, 0xe68fae, 
0xe69cba, 0xe69797, 0xe697a2, 0xe69c9f, 0xe6a38b, 0xe6a384, 
	/* 0xb5a1 */
0xe6a99f, 0xe5b8b0, 0xe6af85, 0xe6b097, 0xe6b1bd, 0xe795bf, 0xe7a588, 0xe5ada3, 
0xe7a880, 0xe7b480, 0xe5bebd, 0xe8a68f, 0xe8a898, 0xe8b2b4, 0xe8b5b7, 0xe8bb8c, 
0xe8bc9d, 0xe9a3a2, 0xe9a88e, 0xe9acbc, 0xe4ba80, 0xe581bd, 0xe58480, 0xe5a693, 
0xe5ae9c, 0xe688af, 0xe68a80, 0xe693ac, 0xe6acba, 0xe78aa0, 0xe79691, 0xe7a587, 
0xe7bea9, 0xe89fbb, 0xe8aabc, 0xe8adb0, 0xe68eac, 0xe88f8a, 0xe99ea0, 0xe59089, 
0xe59083, 0xe596ab, 0xe6a194, 0xe6a998, 0xe8a9b0, 0xe7a0a7, 0xe69db5, 0xe9bb8d, 
0xe58db4, 0xe5aea2, 0xe8849a, 0xe89990, 0xe98086, 0xe4b898, 0xe4b985, 0xe4bb87, 
0xe4bc91, 0xe58f8a, 0xe590b8, 0xe5aeae, 0xe5bc93, 0xe680a5, 0xe69591, 0xe69cbd, 
0xe6b182, 0xe6b1b2, 0xe6b3a3, 0xe781b8, 0xe79083, 0xe7a9b6, 0xe7aaae, 0xe7ac88, 
0xe7b49a, 0xe7b3be, 0xe7b5a6, 0xe697a7, 0xe7899b, 0xe58ebb, 0xe5b185, 0xe5b7a8, 
0xe68b92, 0xe68ba0, 0xe68c99, 0xe6b8a0, 0xe8999a, 0xe8a8b1, 0xe8b79d, 0xe98bb8, 
0xe6bc81, 0xe7a6a6, 0xe9ad9a, 0xe4baa8, 0xe4baab, 0xe4baac, 
	/* 0xb6a1 */
0xe4be9b, 0xe4bea0, 0xe58391, 0xe58587, 0xe7abb6, 0xe585b1, 0xe587b6, 0xe58d94, 
0xe58ca1, 0xe58dbf, 0xe58fab, 0xe596ac, 0xe5a283, 0xe5b3a1, 0xe5bcb7, 0xe5bd8a, 
0xe680af, 0xe68190, 0xe681ad, 0xe68c9f, 0xe69599, 0xe6a98b, 0xe6b381, 0xe78b82, 
0xe78bad, 0xe79faf, 0xe883b8, 0xe88485, 0xe88888, 0xe8958e, 0xe983b7, 0xe98fa1, 
0xe99fbf, 0xe9a597, 0xe9a99a, 0xe4bbb0, 0xe5879d, 0xe5b0ad, 0xe69a81, 0xe6a5ad, 
0xe5b180, 0xe69bb2, 0xe6a5b5, 0xe78e89, 0xe6a190, 0xe7b281, 0xe58385, 0xe58ba4, 
0xe59d87, 0xe5b7be, 0xe98ca6, 0xe696a4, 0xe6aca3, 0xe6acbd, 0xe790b4, 0xe7a681, 
0xe7a6bd, 0xe7ad8b, 0xe7b78a, 0xe88ab9, 0xe88f8c, 0xe8a1bf, 0xe8a59f, 0xe8acb9, 
0xe8bf91, 0xe98791, 0xe5909f, 0xe98a80, 0xe4b99d, 0xe580b6, 0xe58fa5, 0xe58cba, 
0xe78b97, 0xe78e96, 0xe79fa9, 0xe88ba6, 0xe8baaf, 0xe9a786, 0xe9a788, 0xe9a792, 
0xe585b7, 0xe6849a, 0xe8999e, 0xe596b0, 0xe7a9ba, 0xe581b6, 0xe5af93, 0xe98187, 
0xe99a85, 0xe4b8b2, 0xe6ab9b, 0xe987a7, 0xe5b191, 0xe5b188, 
	/* 0xb7a1 */
0xe68e98, 0xe7aa9f, 0xe6b293, 0xe99db4, 0xe8bda1, 0xe7aaaa, 0xe7868a, 0xe99a88, 
0xe7b282, 0xe6a097, 0xe7b9b0, 0xe6a191, 0xe98dac, 0xe58bb2, 0xe5909b, 0xe896ab, 
0xe8a893, 0xe7bea4, 0xe8bb8d, 0xe983a1, 0xe58da6, 0xe8a288, 0xe7a581, 0xe4bf82, 
0xe582be, 0xe58891, 0xe58584, 0xe59593, 0xe59cad, 0xe78faa, 0xe59e8b, 0xe5a591, 
0xe5bda2, 0xe5be84, 0xe681b5, 0xe685b6, 0xe685a7, 0xe686a9, 0xe68eb2, 0xe690ba, 
0xe695ac, 0xe699af, 0xe6a182, 0xe6b893, 0xe795a6, 0xe7a8bd, 0xe7b3bb, 0xe7b58c, 
0xe7b699, 0xe7b98b, 0xe7bdab, 0xe88c8e, 0xe88d8a, 0xe89b8d, 0xe8a888, 0xe8a9a3, 
0xe8ada6, 0xe8bbbd, 0xe9a09a, 0xe9b68f, 0xe88ab8, 0xe8bf8e, 0xe9afa8, 0xe58a87, 
0xe6889f, 0xe69283, 0xe6bf80, 0xe99a99, 0xe6a181, 0xe58291, 0xe6aca0, 0xe6b1ba, 
0xe6bd94, 0xe7a9b4, 0xe7b590, 0xe8a180, 0xe8a8a3, 0xe69c88, 0xe4bbb6, 0xe580b9, 
0xe580a6, 0xe581a5, 0xe585bc, 0xe588b8, 0xe589a3, 0xe596a7, 0xe59c8f, 0xe5a085, 
0xe5ab8c, 0xe5bbba, 0xe686b2, 0xe687b8, 0xe68bb3, 0xe68db2, 
	/* 0xb8a1 */
0xe6a49c, 0xe6a8a9, 0xe789bd, 0xe78aac, 0xe78cae, 0xe7a094, 0xe7a1af, 0xe7b5b9, 
0xe79c8c, 0xe882a9, 0xe8a68b, 0xe8ac99, 0xe8b3a2, 0xe8bb92, 0xe981a3, 0xe98db5, 
0xe999ba, 0xe9a195, 0xe9a893, 0xe9b9b8, 0xe58583, 0xe58e9f, 0xe58eb3, 0xe5b9bb, 
0xe5bca6, 0xe6b89b, 0xe6ba90, 0xe78e84, 0xe78fbe, 0xe7b583, 0xe888b7, 0xe8a880, 
0xe8abba, 0xe99990, 0xe4b98e, 0xe5808b, 0xe58fa4, 0xe591bc, 0xe59bba, 0xe5a791, 
0xe5ada4, 0xe5b7b1, 0xe5baab, 0xe5bca7, 0xe688b8, 0xe69585, 0xe69eaf, 0xe6b996, 
0xe78b90, 0xe7b38a, 0xe8a2b4, 0xe882a1, 0xe883a1, 0xe88fb0, 0xe8998e, 0xe8aa87, 
0xe8b7a8, 0xe988b7, 0xe99b87, 0xe9a1a7, 0xe9bc93, 0xe4ba94, 0xe4ba92, 0xe4bc8d, 
0xe58d88, 0xe59189, 0xe590be, 0xe5a8af, 0xe5be8c, 0xe5bea1, 0xe6829f, 0xe6a2a7, 
0xe6aa8e, 0xe7919a, 0xe7a281, 0xe8aa9e, 0xe8aaa4, 0xe8adb7, 0xe98690, 0xe4b99e, 
0xe9af89, 0xe4baa4, 0xe4bdbc, 0xe4beaf, 0xe58099, 0xe58096, 0xe58589, 0xe585ac, 
0xe58a9f, 0xe58ab9, 0xe58bbe, 0xe58e9a, 0xe58fa3, 0xe59091, 
	/* 0xb9a1 */
0xe5908e, 0xe59689, 0xe59d91, 0xe59ea2, 0xe5a5bd, 0xe5ad94, 0xe5ad9d, 0xe5ae8f, 
0xe5b7a5, 0xe5b7a7, 0xe5b7b7, 0xe5b9b8, 0xe5ba83, 0xe5ba9a, 0xe5bab7, 0xe5bc98, 
0xe68192, 0xe6858c, 0xe68a97, 0xe68b98, 0xe68ea7, 0xe694bb, 0xe69882, 0xe69983, 
0xe69bb4, 0xe69dad, 0xe6a0a1, 0xe6a297, 0xe6a78b, 0xe6b19f, 0xe6b4aa, 0xe6b5a9, 
0xe6b8af, 0xe6ba9d, 0xe794b2, 0xe79a87, 0xe7a1ac, 0xe7a8bf, 0xe7b3a0, 0xe7b485, 
0xe7b498, 0xe7b59e, 0xe7b6b1, 0xe88095, 0xe88083, 0xe882af, 0xe882b1, 0xe88594, 
0xe8868f, 0xe888aa, 0xe88d92, 0xe8a18c, 0xe8a1a1, 0xe8ac9b, 0xe8b2a2, 0xe8b3bc, 
0xe9838a, 0xe985b5, 0xe989b1, 0xe7a0bf, 0xe98bbc, 0xe996a4, 0xe9998d, 0xe9a085, 
0xe9a699, 0xe9ab98, 0xe9b4bb, 0xe5899b, 0xe58aab, 0xe58fb7, 0xe59088, 0xe5a395, 
0xe68bb7, 0xe6bfa0, 0xe8b1aa, 0xe8bd9f, 0xe9bab9, 0xe5858b, 0xe588bb, 0xe5918a, 
0xe59bbd, 0xe7a980, 0xe985b7, 0xe9b5a0, 0xe9bb92, 0xe78d84, 0xe6bc89, 0xe885b0, 
0xe79491, 0xe5bfbd, 0xe6839a, 0xe9aaa8, 0xe78b9b, 0xe8bebc, 
	/* 0xbaa1 */
0xe6ada4, 0xe9a083, 0xe4bb8a, 0xe59bb0, 0xe59da4, 0xe5a2be, 0xe5a99a, 0xe681a8, 
0xe68787, 0xe6988f, 0xe69886, 0xe6a0b9, 0xe6a2b1, 0xe6b7b7, 0xe79795, 0xe7b4ba, 
0xe889ae, 0xe9ad82, 0xe4ba9b, 0xe4bd90, 0xe58f89, 0xe59486, 0xe5b5af, 0xe5b7a6, 
0xe5b7ae, 0xe69fbb, 0xe6b299, 0xe791b3, 0xe7a082, 0xe8a990, 0xe98e96, 0xe8a39f, 
0xe59d90, 0xe5baa7, 0xe68cab, 0xe582b5, 0xe582ac, 0xe5868d, 0xe69c80, 0xe59389, 
0xe5a19e, 0xe5a6bb, 0xe5aeb0, 0xe5bda9, 0xe6898d, 0xe68ea1, 0xe6a0bd, 0xe6adb3, 
0xe6b888, 0xe781bd, 0xe98787, 0xe78a80, 0xe7a095, 0xe7a0a6, 0xe7a5ad, 0xe6968e, 
0xe7b4b0, 0xe88f9c, 0xe8a381, 0xe8bc89, 0xe99a9b, 0xe589a4, 0xe59ca8, 0xe69d90, 
0xe7bdaa, 0xe8b2a1, 0xe586b4, 0xe59d82, 0xe998aa, 0xe5a0ba, 0xe6a68a, 0xe882b4, 
0xe592b2, 0xe5b48e, 0xe59fbc, 0xe7a295, 0xe9b7ba, 0xe4bd9c, 0xe5898a, 0xe5928b, 
0xe690be, 0xe698a8, 0xe69c94, 0xe69fb5, 0xe7aa84, 0xe7ad96, 0xe7b4a2, 0xe98caf, 
0xe6a19c, 0xe9aead, 0xe7acb9, 0xe58c99, 0xe5868a, 0xe588b7, 
	/* 0xbba1 */
0xe5af9f, 0xe68bb6, 0xe692ae, 0xe693a6, 0xe69cad, 0xe6aeba, 0xe896a9, 0xe99b91, 
0xe79a90, 0xe9af96, 0xe68d8c, 0xe98c86, 0xe9aeab, 0xe79abf, 0xe69992, 0xe4b889, 
0xe58298, 0xe58f82, 0xe5b1b1, 0xe683a8, 0xe69292, 0xe695a3, 0xe6a19f, 0xe787a6, 
0xe78f8a, 0xe794a3, 0xe7ae97, 0xe7ba82, 0xe89a95, 0xe8ae83, 0xe8b39b, 0xe985b8, 
0xe9a490, 0xe696ac, 0xe69aab, 0xe6ae8b, 0xe4bb95, 0xe4bb94, 0xe4bcba, 0xe4bdbf, 
0xe588ba, 0xe58fb8, 0xe58fb2, 0xe597a3, 0xe59b9b, 0xe5a3ab, 0xe5a78b, 0xe5a789, 
0xe5a7bf, 0xe5ad90, 0xe5b18d, 0xe5b882, 0xe5b8ab, 0xe5bf97, 0xe6809d, 0xe68c87, 
0xe694af, 0xe5ad9c, 0xe696af, 0xe696bd, 0xe697a8, 0xe69e9d, 0xe6ada2, 0xe6adbb, 
0xe6b08f, 0xe78d85, 0xe7a589, 0xe7a781, 0xe7b3b8, 0xe7b499, 0xe7b4ab, 0xe882a2, 
0xe88482, 0xe887b3, 0xe8a696, 0xe8a99e, 0xe8a9a9, 0xe8a9a6, 0xe8aa8c, 0xe8abae, 
0xe8b387, 0xe8b39c, 0xe99b8c, 0xe9a3bc, 0xe6adaf, 0xe4ba8b, 0xe4bcbc, 0xe4be8d, 
0xe58590, 0xe5ad97, 0xe5afba, 0xe68588, 0xe68c81, 0xe69982, 
	/* 0xbca1 */
0xe6aca1, 0xe6bb8b, 0xe6b2bb, 0xe788be, 0xe792bd, 0xe79794, 0xe7a381, 0xe7a4ba, 
0xe8808c, 0xe880b3, 0xe887aa, 0xe89294, 0xe8be9e, 0xe6b190, 0xe9b9bf, 0xe5bc8f, 
0xe8ad98, 0xe9b4ab, 0xe7abba, 0xe8bbb8, 0xe5ae8d, 0xe99bab, 0xe4b883, 0xe58fb1, 
0xe59fb7, 0xe5a4b1, 0xe5ab89, 0xe5aea4, 0xe68289, 0xe6b9bf, 0xe6bc86, 0xe796be, 
0xe8b3aa, 0xe5ae9f, 0xe89480, 0xe7afa0, 0xe581b2, 0xe69fb4, 0xe88a9d, 0xe5b1a1, 
0xe8958a, 0xe7b89e, 0xe8888e, 0xe58699, 0xe5b084, 0xe68da8, 0xe8b5a6, 0xe6969c, 
0xe785ae, 0xe7a4be, 0xe7b497, 0xe88085, 0xe8ac9d, 0xe8bb8a, 0xe981ae, 0xe89b87, 
0xe982aa, 0xe5809f, 0xe58bba, 0xe5b0ba, 0xe69d93, 0xe781bc, 0xe788b5, 0xe9858c, 
0xe98788, 0xe98cab, 0xe88ba5, 0xe5af82, 0xe5bcb1, 0xe683b9, 0xe4b8bb, 0xe58f96, 
0xe5ae88, 0xe6898b, 0xe69cb1, 0xe6ae8a, 0xe78ba9, 0xe78fa0, 0xe7a8ae, 0xe885ab, 
0xe8b6a3, 0xe98592, 0xe9a696, 0xe58492, 0xe58f97, 0xe591aa, 0xe5afbf, 0xe68e88, 
0xe6a8b9, 0xe7b6ac, 0xe99c80, 0xe59b9a, 0xe58f8e, 0xe591a8, 
	/* 0xbda1 */
0xe5ae97, 0xe5b0b1, 0xe5b79e, 0xe4bfae, 0xe68481, 0xe68bbe, 0xe6b4b2, 0xe7a780, 
0xe7a78b, 0xe7b582, 0xe7b98d, 0xe7bf92, 0xe887ad, 0xe8889f, 0xe89290, 0xe8a186, 
0xe8a5b2, 0xe8ae90, 0xe8b9b4, 0xe8bcaf, 0xe980b1, 0xe9858b, 0xe985ac, 0xe99b86, 
0xe9869c, 0xe4bb80, 0xe4bd8f, 0xe58585, 0xe58d81, 0xe5be93, 0xe6888e, 0xe69f94, 
0xe6b181, 0xe6b88b, 0xe78da3, 0xe7b8a6, 0xe9878d, 0xe98a83, 0xe58f94, 0xe5a499, 
0xe5aebf, 0xe6b791, 0xe7a59d, 0xe7b8ae, 0xe7b29b, 0xe5a1be, 0xe7869f, 0xe587ba, 
0xe8a193, 0xe8bfb0, 0xe4bf8a, 0xe5b3bb, 0xe698a5, 0xe79eac, 0xe7aba3, 0xe8889c, 
0xe9a7bf, 0xe58786, 0xe5beaa, 0xe697ac, 0xe6a5af, 0xe6ae89, 0xe6b7b3, 0xe6ba96, 
0xe6bda4, 0xe79bbe, 0xe7b494, 0xe5b7a1, 0xe981b5, 0xe98687, 0xe9a086, 0xe587a6, 
0xe5889d, 0xe68980, 0xe69a91, 0xe69b99, 0xe6b89a, 0xe5bab6, 0xe7b792, 0xe7bdb2, 
0xe69bb8, 0xe896af, 0xe897b7, 0xe8abb8, 0xe58aa9, 0xe58f99, 0xe5a5b3, 0xe5ba8f, 
0xe5be90, 0xe68195, 0xe98ba4, 0xe999a4, 0xe582b7, 0xe5849f, 
	/* 0xbea1 */
0xe58b9d, 0xe58ca0, 0xe58d87, 0xe58fac, 0xe593a8, 0xe59586, 0xe594b1, 0xe59897, 
0xe5a5a8, 0xe5a6be, 0xe5a8bc, 0xe5aeb5, 0xe5b086, 0xe5b08f, 0xe5b091, 0xe5b09a, 
0xe5ba84, 0xe5ba8a, 0xe5bba0, 0xe5bdb0, 0xe689bf, 0xe68a84, 0xe68b9b, 0xe68e8c, 
0xe68db7, 0xe69887, 0xe6988c, 0xe698ad, 0xe699b6, 0xe69dbe, 0xe6a2a2, 0xe6a89f, 
0xe6a8b5, 0xe6b2bc, 0xe6b688, 0xe6b889, 0xe6b998, 0xe784bc, 0xe784a6, 0xe785a7, 
0xe79787, 0xe79c81, 0xe7a19d, 0xe7a481, 0xe7a5a5, 0xe7a7b0, 0xe7aba0, 0xe7ac91, 
0xe7b2a7, 0xe7b4b9, 0xe88296, 0xe88f96, 0xe8928b, 0xe89589, 0xe8a19d, 0xe8a3b3, 
0xe8a89f, 0xe8a8bc, 0xe8a994, 0xe8a9b3, 0xe8b1a1, 0xe8b39e, 0xe986a4, 0xe989a6, 
0xe98dbe, 0xe99098, 0xe99a9c, 0xe99e98, 0xe4b88a, 0xe4b888, 0xe4b89e, 0xe4b997, 
0xe58697, 0xe589b0, 0xe59f8e, 0xe5a0b4, 0xe5a38c, 0xe5aca2, 0xe5b8b8, 0xe68385, 
0xe693be, 0xe69da1, 0xe69d96, 0xe6b584, 0xe78ab6, 0xe795b3, 0xe7a9a3, 0xe892b8, 
0xe8adb2, 0xe986b8, 0xe98ca0, 0xe598b1, 0xe59fb4, 0xe9a3be, 
	/* 0xbfa1 */
0xe68bad, 0xe6a48d, 0xe6ae96, 0xe787ad, 0xe7b994, 0xe881b7, 0xe889b2, 0xe8a7a6, 
0xe9a39f, 0xe89d95, 0xe8beb1, 0xe5b0bb, 0xe4bcb8, 0xe4bfa1, 0xe4beb5, 0xe59487, 
0xe5a8a0, 0xe5af9d, 0xe5afa9, 0xe5bf83, 0xe6858e, 0xe68caf, 0xe696b0, 0xe6998b, 
0xe6a3ae, 0xe6a69b, 0xe6b5b8, 0xe6b7b1, 0xe794b3, 0xe796b9, 0xe79c9f, 0xe7a59e, 
0xe7a7a6, 0xe7b4b3, 0xe887a3, 0xe88aaf, 0xe896aa, 0xe8a6aa, 0xe8a8ba, 0xe8baab, 
0xe8be9b, 0xe980b2, 0xe9879d, 0xe99c87, 0xe4baba, 0xe4bb81, 0xe58883, 0xe5a1b5, 
0xe5a3ac, 0xe5b08b, 0xe7949a, 0xe5b0bd, 0xe8858e, 0xe8a88a, 0xe8bf85, 0xe999a3, 
0xe99dad, 0xe7aca5, 0xe8ab8f, 0xe9a088, 0xe985a2, 0xe59bb3, 0xe58ea8, 0xe98097, 
0xe590b9, 0xe59e82, 0xe5b8a5, 0xe68ea8, 0xe6b0b4, 0xe7828a, 0xe79da1, 0xe7b28b, 
0xe7bfa0, 0xe8a1b0, 0xe98182, 0xe98594, 0xe98c90, 0xe98c98, 0xe99a8f, 0xe7919e, 
0xe9ab84, 0xe5b487, 0xe5b5a9, 0xe695b0, 0xe69ea2, 0xe8b6a8, 0xe99b9b, 0xe68dae, 
0xe69d89, 0xe6a499, 0xe88f85, 0xe9a097, 0xe99b80, 0xe8a3be, 
	/* 0xc0a1 */
0xe6be84, 0xe691ba, 0xe5afb8, 0xe4b896, 0xe780ac, 0xe7959d, 0xe698af, 0xe58784, 
0xe588b6, 0xe58ba2, 0xe5a793, 0xe5be81, 0xe680a7, 0xe68890, 0xe694bf, 0xe695b4, 
0xe6989f, 0xe699b4, 0xe6a3b2, 0xe6a096, 0xe6ada3, 0xe6b885, 0xe789b2, 0xe7949f, 
0xe79b9b, 0xe7b2be, 0xe88196, 0xe5a3b0, 0xe8a3bd, 0xe8a5bf, 0xe8aaa0, 0xe8aa93, 
0xe8ab8b, 0xe9809d, 0xe98692, 0xe99d92, 0xe99d99, 0xe69689, 0xe7a88e, 0xe88486, 
0xe99abb, 0xe5b8ad, 0xe6839c, 0xe6889a, 0xe696a5, 0xe69894, 0xe69e90, 0xe79fb3, 
0xe7a98d, 0xe7b18d, 0xe7b8be, 0xe8848a, 0xe8b2ac, 0xe8b5a4, 0xe8b7a1, 0xe8b99f, 
0xe7a2a9, 0xe58887, 0xe68b99, 0xe68ea5, 0xe69182, 0xe68a98, 0xe8a8ad, 0xe7aa83, 
0xe7af80, 0xe8aaac, 0xe99baa, 0xe7b5b6, 0xe8888c, 0xe89d89, 0xe4bb99, 0xe58588, 
0xe58d83, 0xe58da0, 0xe5aea3, 0xe5b082, 0xe5b096, 0xe5b79d, 0xe688a6, 0xe68987, 
0xe692b0, 0xe6a093, 0xe6a0b4, 0xe6b389, 0xe6b585, 0xe6b497, 0xe69f93, 0xe6bd9c, 
0xe7858e, 0xe785bd, 0xe6978b, 0xe7a9bf, 0xe7aead, 0xe7b79a, 
	/* 0xc1a1 */
0xe7b98a, 0xe7bea8, 0xe885ba, 0xe8889b, 0xe888b9, 0xe896a6, 0xe8a9ae, 0xe8b38e, 
0xe8b7b5, 0xe981b8, 0xe981b7, 0xe98aad, 0xe98a91, 0xe99683, 0xe9aeae, 0xe5898d, 
0xe59684, 0xe6bcb8, 0xe784b6, 0xe585a8, 0xe7a685, 0xe7b995, 0xe886b3, 0xe7b38e, 
0xe5998c, 0xe5a191, 0xe5b2a8, 0xe68eaa, 0xe69bbe, 0xe69bbd, 0xe6a59a, 0xe78b99, 
0xe7968f, 0xe7968e, 0xe7a48e, 0xe7a596, 0xe7a79f, 0xe7b297, 0xe7b4a0, 0xe7b584, 
0xe89887, 0xe8a8b4, 0xe998bb, 0xe981a1, 0xe9bca0, 0xe583a7, 0xe589b5, 0xe58f8c, 
0xe58fa2, 0xe58089, 0xe596aa, 0xe5a3ae, 0xe5a58f, 0xe788bd, 0xe5ae8b, 0xe5b1a4, 
0xe58c9d, 0xe683a3, 0xe683b3, 0xe68d9c, 0xe68e83, 0xe68cbf, 0xe68ebb, 0xe6938d, 
0xe697a9, 0xe69bb9, 0xe5b7a3, 0xe6a78d, 0xe6a7bd, 0xe6bc95, 0xe787a5, 0xe4ba89, 
0xe797a9, 0xe79bb8, 0xe7aa93, 0xe7b39f, 0xe7b78f, 0xe7b69c, 0xe881a1, 0xe88d89, 
0xe88d98, 0xe891ac, 0xe892bc, 0xe897bb, 0xe8a385, 0xe8b5b0, 0xe98081, 0xe981ad, 
0xe98e97, 0xe99c9c, 0xe9a892, 0xe5838f, 0xe5a297, 0xe6868e, 
	/* 0xc2a1 */
0xe88793, 0xe894b5, 0xe8b488, 0xe980a0, 0xe4bf83, 0xe581b4, 0xe58987, 0xe58db3, 
0xe681af, 0xe68d89, 0xe69d9f, 0xe6b8ac, 0xe8b6b3, 0xe9809f, 0xe4bf97, 0xe5b19e, 
0xe8b38a, 0xe6978f, 0xe7b69a, 0xe58d92, 0xe8a296, 0xe585b6, 0xe68f83, 0xe5ad98, 
0xe5adab, 0xe5b08a, 0xe6908d, 0xe69d91, 0xe9819c, 0xe4bb96, 0xe5a49a, 0xe5a4aa, 
0xe6b1b0, 0xe8a991, 0xe594be, 0xe5a095, 0xe5a6a5, 0xe683b0, 0xe68993, 0xe69f81, 
0xe888b5, 0xe6a595, 0xe99980, 0xe9a784, 0xe9a8a8, 0xe4bd93, 0xe5a086, 0xe5afbe, 
0xe88090, 0xe5b2b1, 0xe5b8af, 0xe5be85, 0xe680a0, 0xe6858b, 0xe688b4, 0xe69bbf, 
0xe6b3b0, 0xe6bb9e, 0xe8838e, 0xe885bf, 0xe88b94, 0xe8a28b, 0xe8b2b8, 0xe98080, 
0xe980ae, 0xe99a8a, 0xe9bb9b, 0xe9af9b, 0xe4bba3, 0xe58fb0, 0xe5a4a7, 0xe7acac, 
0xe9868d, 0xe9a18c, 0xe9b7b9, 0xe6bb9d, 0xe780a7, 0xe58d93, 0xe59584, 0xe5ae85, 
0xe68998, 0xe68a9e, 0xe68b93, 0xe6b2a2, 0xe6bfaf, 0xe790a2, 0xe8a897, 0xe990b8, 
0xe6bf81, 0xe8abbe, 0xe88cb8, 0xe587a7, 0xe89bb8, 0xe58faa, 
	/* 0xc3a1 */
0xe58fa9, 0xe4bd86, 0xe98194, 0xe8beb0, 0xe5a5aa, 0xe884b1, 0xe5b7bd, 0xe7abaa, 
0xe8bebf, 0xe6a39a, 0xe8b0b7, 0xe78bb8, 0xe9b188, 0xe6a8bd, 0xe8aab0, 0xe4b8b9, 
0xe58d98, 0xe59886, 0xe59da6, 0xe68b85, 0xe68ea2, 0xe697a6, 0xe6ad8e, 0xe6b7a1, 
0xe6b99b, 0xe782ad, 0xe79fad, 0xe7abaf, 0xe7aeaa, 0xe7b6bb, 0xe880bd, 0xe88386, 
0xe89b8b, 0xe8aa95, 0xe98d9b, 0xe59ba3, 0xe5a387, 0xe5bcbe, 0xe696ad, 0xe69a96, 
0xe6aa80, 0xe6aeb5, 0xe794b7, 0xe8ab87, 0xe580a4, 0xe79fa5, 0xe59cb0, 0xe5bc9b, 
0xe681a5, 0xe699ba, 0xe6b1a0, 0xe797b4, 0xe7a89a, 0xe7bdae, 0xe887b4, 0xe89c98, 
0xe98185, 0xe9a6b3, 0xe7af89, 0xe7959c, 0xe7abb9, 0xe7ad91, 0xe89384, 0xe98090, 
0xe7a7a9, 0xe7aa92, 0xe88cb6, 0xe5aba1, 0xe79d80, 0xe4b8ad, 0xe4bbb2, 0xe5ae99, 
0xe5bfa0, 0xe68abd, 0xe698bc, 0xe69fb1, 0xe6b3a8, 0xe899ab, 0xe8a1b7, 0xe8a8bb, 
0xe9858e, 0xe98bb3, 0xe9a790, 0xe6a897, 0xe780a6, 0xe78caa, 0xe88ba7, 0xe89197, 
0xe8b2af, 0xe4b881, 0xe58586, 0xe5878b, 0xe5968b, 0xe5afb5, 
	/* 0xc4a1 */
0xe5b896, 0xe5b8b3, 0xe5ba81, 0xe5bc94, 0xe5bcb5, 0xe5bdab, 0xe5beb4, 0xe687b2, 
0xe68c91, 0xe69aa2, 0xe69c9d, 0xe6bdae, 0xe78992, 0xe794ba, 0xe79cba, 0xe881b4, 
0xe884b9, 0xe885b8, 0xe89db6, 0xe8aabf, 0xe8ab9c, 0xe8b685, 0xe8b7b3, 0xe98a9a, 
0xe995b7, 0xe9a082, 0xe9b3a5, 0xe58b85, 0xe68d97, 0xe79bb4, 0xe69c95, 0xe6b288, 
0xe78f8d, 0xe8b383, 0xe98eae, 0xe999b3, 0xe6b4a5, 0xe5a29c, 0xe6a48e, 0xe6a78c, 
0xe8bfbd, 0xe98e9a, 0xe7979b, 0xe9809a, 0xe5a19a, 0xe6a082, 0xe68eb4, 0xe6a7bb, 
0xe4bd83, 0xe6bcac, 0xe69f98, 0xe8bebb, 0xe894a6, 0xe7b6b4, 0xe98d94, 0xe6a4bf, 
0xe6bdb0, 0xe59daa, 0xe5a3b7, 0xe5acac, 0xe7b4ac, 0xe788aa, 0xe5908a, 0xe987a3, 
0xe9b6b4, 0xe4baad, 0xe4bd8e, 0xe5819c, 0xe581b5, 0xe58983, 0xe8b29e, 0xe59188, 
0xe5a0a4, 0xe5ae9a, 0xe5b89d, 0xe5ba95, 0xe5baad, 0xe5bbb7, 0xe5bc9f, 0xe6828c, 
0xe68ab5, 0xe68cba, 0xe68f90, 0xe6a2af, 0xe6b180, 0xe7a287, 0xe7a68e, 0xe7a88b, 
0xe7b7a0, 0xe88987, 0xe8a882, 0xe8aba6, 0xe8b984, 0xe98093, 
	/* 0xc5a1 */
0xe982b8, 0xe984ad, 0xe98798, 0xe9bc8e, 0xe6b3a5, 0xe69198, 0xe693a2, 0xe695b5, 
0xe6bbb4, 0xe79a84, 0xe7ac9b, 0xe981a9, 0xe98f91, 0xe6baba, 0xe593b2, 0xe5beb9, 
0xe692a4, 0xe8bd8d, 0xe8bfad, 0xe98984, 0xe585b8, 0xe5a1ab, 0xe5a4a9, 0xe5b195, 
0xe5ba97, 0xe6b7bb, 0xe7ba8f, 0xe7949c, 0xe8b2bc, 0xe8bba2, 0xe9a19b, 0xe782b9, 
0xe4bc9d, 0xe6aebf, 0xe6beb1, 0xe794b0, 0xe99bbb, 0xe5858e, 0xe59090, 0xe5a0b5, 
0xe5a197, 0xe5a6ac, 0xe5b1a0, 0xe5be92, 0xe69697, 0xe69d9c, 0xe6b8a1, 0xe799bb, 
0xe88f9f, 0xe8b3ad, 0xe98094, 0xe983bd, 0xe98d8d, 0xe7a0a5, 0xe7a0ba, 0xe58aaa, 
0xe5baa6, 0xe59c9f, 0xe5a5b4, 0xe68092, 0xe58092, 0xe5859a, 0xe586ac, 0xe5878d, 
0xe58880, 0xe59490, 0xe5a194, 0xe5a198, 0xe5a597, 0xe5ae95, 0xe5b3b6, 0xe5b68b, 
0xe682bc, 0xe68a95, 0xe690ad, 0xe69db1, 0xe6a183, 0xe6a2bc, 0xe6a39f, 0xe79b97, 
0xe6b798, 0xe6b9af, 0xe6b69b, 0xe781af, 0xe78788, 0xe5bd93, 0xe79798, 0xe7a5b7, 
0xe7ad89, 0xe7ad94, 0xe7ad92, 0xe7b396, 0xe7b5b1, 0xe588b0, 
	/* 0xc6a1 */
0xe891a3, 0xe895a9, 0xe897a4, 0xe8a88e, 0xe8ac84, 0xe8b186, 0xe8b88f, 0xe98083, 
0xe9808f, 0xe99099, 0xe999b6, 0xe9a0ad, 0xe9a8b0, 0xe99798, 0xe5838d, 0xe58b95, 
0xe5908c, 0xe5a082, 0xe5b08e, 0xe686a7, 0xe6929e, 0xe6b49e, 0xe79eb3, 0xe7aba5, 
0xe883b4, 0xe89084, 0xe98193, 0xe98a85, 0xe5b3a0, 0xe9b487, 0xe58cbf, 0xe5be97, 
0xe5beb3, 0xe6b69c, 0xe789b9, 0xe79da3, 0xe7a6bf, 0xe7afa4, 0xe6af92, 0xe78bac, 
0xe8aaad, 0xe6a083, 0xe6a9a1, 0xe587b8, 0xe7aa81, 0xe6a4b4, 0xe5b18a, 0xe9b3b6, 
0xe88bab, 0xe5af85, 0xe98589, 0xe7809e, 0xe599b8, 0xe5b1af, 0xe68387, 0xe695a6, 
0xe6b28c, 0xe8b19a, 0xe98181, 0xe9a093, 0xe59191, 0xe69b87, 0xe9888d, 0xe5a588, 
0xe982a3, 0xe58685, 0xe4b98d, 0xe587aa, 0xe89699, 0xe8ac8e, 0xe78198, 0xe68dba, 
0xe98d8b, 0xe6a5a2, 0xe9a6b4, 0xe7b884, 0xe795b7, 0xe58d97, 0xe6a5a0, 0xe8bb9f, 
0xe99ba3, 0xe6b19d, 0xe4ba8c, 0xe5b0bc, 0xe5bc90, 0xe8bfa9, 0xe58c82, 0xe8b391, 
0xe88289, 0xe899b9, 0xe5bbbf, 0xe697a5, 0xe4b9b3, 0xe585a5, 
	/* 0xc7a1 */
0xe5a682, 0xe5b0bf, 0xe99fae, 0xe4bbbb, 0xe5a68a, 0xe5bf8d, 0xe8aa8d, 0xe6bfa1, 
0xe7a6b0, 0xe7a5a2, 0xe5afa7, 0xe891b1, 0xe78cab, 0xe786b1, 0xe5b9b4, 0xe5bfb5, 
0xe68dbb, 0xe6929a, 0xe78783, 0xe7b298, 0xe4b983, 0xe5bbbc, 0xe4b98b, 0xe59f9c, 
0xe59aa2, 0xe682a9, 0xe6bf83, 0xe7b48d, 0xe883bd, 0xe884b3, 0xe886bf, 0xe8beb2, 
0xe8a697, 0xe89aa4, 0xe5b7b4, 0xe68a8a, 0xe692ad, 0xe8a687, 0xe69db7, 0xe6b3a2, 
0xe6b4be, 0xe790b6, 0xe7a0b4, 0xe5a986, 0xe7bdb5, 0xe88aad, 0xe9a6ac, 0xe4bfb3, 
0xe5bb83, 0xe68b9d, 0xe68e92, 0xe69597, 0xe69daf, 0xe79b83, 0xe7898c, 0xe8838c, 
0xe882ba, 0xe8bca9, 0xe9858d, 0xe5808d, 0xe59fb9, 0xe5aa92, 0xe6a285, 0xe6a5b3, 
0xe785a4, 0xe78bbd, 0xe8b2b7, 0xe5a3b2, 0xe8b3a0, 0xe999aa, 0xe98099, 0xe89dbf, 
0xe7a7a4, 0xe79fa7, 0xe890a9, 0xe4bcaf, 0xe589a5, 0xe58d9a, 0xe68b8d, 0xe69f8f, 
0xe6b38a, 0xe799bd, 0xe7ae94, 0xe7b295, 0xe888b6, 0xe89684, 0xe8bfab, 0xe69b9d, 
0xe6bca0, 0xe78886, 0xe7b89b, 0xe88eab, 0xe9a781, 0xe9baa6, 
	/* 0xc8a1 */
0xe587bd, 0xe7aeb1, 0xe7a1b2, 0xe7aeb8, 0xe88287, 0xe7ad88, 0xe6aba8, 0xe5b9a1, 
0xe8828c, 0xe79591, 0xe795a0, 0xe585ab, 0xe989a2, 0xe6ba8c, 0xe799ba, 0xe98697, 
0xe9abaa, 0xe4bc90, 0xe7bdb0, 0xe68a9c, 0xe7ad8f, 0xe996a5, 0xe9b3a9, 0xe599ba, 
0xe5a199, 0xe89ba4, 0xe99abc, 0xe4bcb4, 0xe588a4, 0xe58d8a, 0xe58f8d, 0xe58f9b, 
0xe5b886, 0xe690ac, 0xe69691, 0xe69dbf, 0xe6b0be, 0xe6b18e, 0xe78988, 0xe78aaf, 
0xe78fad, 0xe79594, 0xe7b981, 0xe888ac, 0xe897a9, 0xe8b2a9, 0xe7af84, 0xe98786, 
0xe785a9, 0xe9a092, 0xe9a3af, 0xe68cbd, 0xe699a9, 0xe795aa, 0xe79ba4, 0xe7a390, 
0xe89583, 0xe89bae, 0xe58caa, 0xe58d91, 0xe590a6, 0xe5a683, 0xe5ba87, 0xe5bdbc, 
0xe682b2, 0xe68989, 0xe689b9, 0xe68aab, 0xe69690, 0xe6af94, 0xe6b38c, 0xe796b2, 
0xe79aae, 0xe7a291, 0xe7a798, 0xe7b78b, 0xe7bdb7, 0xe882a5, 0xe8a2ab, 0xe8aab9, 
0xe8b2bb, 0xe981bf, 0xe99d9e, 0xe9a39b, 0xe6a88b, 0xe7b0b8, 0xe58299, 0xe5b0be, 
0xe5beae, 0xe69e87, 0xe6af98, 0xe790b5, 0xe79c89, 0xe7be8e, 
	/* 0xc9a1 */
0xe9bcbb, 0xe69f8a, 0xe7a897, 0xe58cb9, 0xe7968b, 0xe9abad, 0xe5bda6, 0xe8869d, 
0xe88fb1, 0xe88298, 0xe5bcbc, 0xe5bf85, 0xe795a2, 0xe7ad86, 0xe980bc, 0xe6a1a7, 
0xe5a7ab, 0xe5aa9b, 0xe7b490, 0xe799be, 0xe8acac, 0xe4bfb5, 0xe5bdaa, 0xe6a899, 
0xe6b0b7, 0xe6bc82, 0xe793a2, 0xe7a5a8, 0xe8a1a8, 0xe8a995, 0xe8b1b9, 0xe5bb9f, 
0xe68f8f, 0xe79785, 0xe7a792, 0xe88b97, 0xe98ca8, 0xe98bb2, 0xe8929c, 0xe89bad, 
0xe9b0ad, 0xe59381, 0xe5bdac, 0xe6968c, 0xe6b59c, 0xe78095, 0xe8b2a7, 0xe8b393, 
0xe9a0bb, 0xe6958f, 0xe793b6, 0xe4b88d, 0xe4bb98, 0xe59fa0, 0xe5a4ab, 0xe5a9a6, 
0xe5af8c, 0xe586a8, 0xe5b883, 0xe5ba9c, 0xe68096, 0xe689b6, 0xe695b7, 0xe696a7, 
0xe699ae, 0xe6b5ae, 0xe788b6, 0xe7aca6, 0xe88590, 0xe8869a, 0xe88a99, 0xe8ad9c, 
0xe8b2a0, 0xe8b3a6, 0xe8b5b4, 0xe9989c, 0xe99984, 0xe4beae, 0xe692ab, 0xe6ada6, 
0xe8889e, 0xe891a1, 0xe895aa, 0xe983a8, 0xe5b081, 0xe6a593, 0xe9a2a8, 0xe891ba, 
0xe89597, 0xe4bc8f, 0xe589af, 0xe5bea9, 0xe5b985, 0xe69c8d, 
	/* 0xcaa1 */
0xe7a68f, 0xe885b9, 0xe8a487, 0xe8a686, 0xe6b7b5, 0xe5bc97, 0xe68995, 0xe6b2b8, 
0xe4bb8f, 0xe789a9, 0xe9ae92, 0xe58886, 0xe590bb, 0xe599b4, 0xe5a2b3, 0xe686a4, 
0xe689ae, 0xe7849a, 0xe5a5ae, 0xe7b289, 0xe7b39e, 0xe7b49b, 0xe99bb0, 0xe69687, 
0xe8819e, 0xe4b899, 0xe4bdb5, 0xe585b5, 0xe5a180, 0xe5b9a3, 0xe5b9b3, 0xe5bc8a, 
0xe69f84, 0xe4b8a6, 0xe894bd, 0xe99689, 0xe9999b, 0xe7b1b3, 0xe9a081, 0xe583bb, 
0xe5a381, 0xe79996, 0xe7a2a7, 0xe588a5, 0xe79ea5, 0xe89491, 0xe7ae86, 0xe5818f, 
0xe5a489, 0xe78987, 0xe7af87, 0xe7b7a8, 0xe8beba, 0xe8bf94, 0xe9818d, 0xe4bebf, 
0xe58b89, 0xe5a8a9, 0xe5bc81, 0xe99ead, 0xe4bf9d, 0xe88897, 0xe98baa, 0xe59c83, 
0xe68d95, 0xe6ada9, 0xe794ab, 0xe8a39c, 0xe8bc94, 0xe7a982, 0xe58b9f, 0xe5a293, 
0xe68595, 0xe6888a, 0xe69aae, 0xe6af8d, 0xe7b0bf, 0xe88fa9, 0xe580a3, 0xe4bfb8, 
0xe58c85, 0xe59186, 0xe5a0b1, 0xe5a589, 0xe5ae9d, 0xe5b3b0, 0xe5b3af, 0xe5b4a9, 
0xe5ba96, 0xe68ab1, 0xe68da7, 0xe694be, 0xe696b9, 0xe69c8b, 
	/* 0xcba1 */
0xe6b395, 0xe6b3a1, 0xe783b9, 0xe7a0b2, 0xe7b8ab, 0xe8839e, 0xe88ab3, 0xe8908c, 
0xe893ac, 0xe89c82, 0xe8a492, 0xe8a8aa, 0xe8b18a, 0xe982a6, 0xe98b92, 0xe9a3bd, 
0xe9b3b3, 0xe9b5ac, 0xe4b98f, 0xe4baa1, 0xe5828d, 0xe58996, 0xe59d8a, 0xe5a6a8, 
0xe5b8bd, 0xe5bf98, 0xe5bf99, 0xe688bf, 0xe69ab4, 0xe69c9b, 0xe69f90, 0xe6a392, 
0xe58692, 0xe7b4a1, 0xe882aa, 0xe886a8, 0xe8ac80, 0xe8b28c, 0xe8b2bf, 0xe989be, 
0xe998b2, 0xe590a0, 0xe9a0ac, 0xe58c97, 0xe58395, 0xe58d9c, 0xe5a2a8, 0xe692b2, 
0xe69cb4, 0xe789a7, 0xe79da6, 0xe7a986, 0xe987a6, 0xe58b83, 0xe6b2a1, 0xe6ae86, 
0xe5a080, 0xe5b98c, 0xe5a594, 0xe69cac, 0xe7bfbb, 0xe587a1, 0xe79b86, 0xe691a9, 
0xe7a3a8, 0xe9ad94, 0xe9babb, 0xe59f8b, 0xe5a6b9, 0xe698a7, 0xe69e9a, 0xe6af8e, 
0xe593a9, 0xe6a799, 0xe5b995, 0xe8869c, 0xe69e95, 0xe9aeaa, 0xe69fbe, 0xe9b192, 
0xe6a19d, 0xe4baa6, 0xe4bfa3, 0xe58f88, 0xe68ab9, 0xe69cab, 0xe6b2ab, 0xe8bf84, 
0xe4bead, 0xe7b9ad, 0xe9babf, 0xe4b887, 0xe685a2, 0xe6ba80, 
	/* 0xcca1 */
0xe6bcab, 0xe89493, 0xe591b3, 0xe69caa, 0xe9ad85, 0xe5b7b3, 0xe7ae95, 0xe5b2ac, 
0xe5af86, 0xe89c9c, 0xe6b98a, 0xe89391, 0xe7a894, 0xe88488, 0xe5a699, 0xe7b28d, 
0xe6b091, 0xe79ca0, 0xe58b99, 0xe5a4a2, 0xe784a1, 0xe7899f, 0xe79f9b, 0xe99ca7, 
0xe9b5a1, 0xe6a48b, 0xe5a9bf, 0xe5a898, 0xe586a5, 0xe5908d, 0xe591bd, 0xe6988e, 
0xe79b9f, 0xe8bfb7, 0xe98a98, 0xe9b3b4, 0xe5a7aa, 0xe7899d, 0xe6bb85, 0xe5858d, 
0xe6a389, 0xe7b6bf, 0xe7b7ac, 0xe99da2, 0xe9baba, 0xe691b8, 0xe6a8a1, 0xe88c82, 
0xe5a684, 0xe5ad9f, 0xe6af9b, 0xe78c9b, 0xe79bb2, 0xe7b6b2, 0xe88097, 0xe89299, 
0xe584b2, 0xe69ca8, 0xe9bb99, 0xe79bae, 0xe69da2, 0xe58bbf, 0xe9a485, 0xe5b0a4, 
0xe688bb, 0xe7b1be, 0xe8b2b0, 0xe5958f, 0xe682b6, 0xe7b48b, 0xe99680, 0xe58c81, 
0xe4b99f, 0xe586b6, 0xe5a49c, 0xe788ba, 0xe880b6, 0xe9878e, 0xe5bca5, 0xe79fa2, 
0xe58e84, 0xe5bdb9, 0xe7b484, 0xe896ac, 0xe8a8b3, 0xe8ba8d, 0xe99d96, 0xe69fb3, 
0xe896ae, 0xe99193, 0xe68489, 0xe68488, 0xe6b2b9, 0xe79992, 
	/* 0xcda1 */
0xe8abad, 0xe8bcb8, 0xe594af, 0xe4bd91, 0xe584aa, 0xe58b87, 0xe58f8b, 0xe5aea5, 
0xe5b9bd, 0xe682a0, 0xe68682, 0xe68f96, 0xe69c89, 0xe69f9a, 0xe6b9a7, 0xe6b68c, 
0xe78cb6, 0xe78cb7, 0xe794b1, 0xe7a590, 0xe8a395, 0xe8aa98, 0xe9818a, 0xe98291, 
0xe983b5, 0xe99b84, 0xe89e8d, 0xe5a495, 0xe4ba88, 0xe4bd99, 0xe4b88e, 0xe8aa89, 
0xe8bcbf, 0xe9a090, 0xe582ad, 0xe5b9bc, 0xe5a696, 0xe5aeb9, 0xe5bab8, 0xe68f9a, 
0xe68fba, 0xe69381, 0xe69b9c, 0xe6a58a, 0xe6a798, 0xe6b48b, 0xe6bab6, 0xe78694, 
0xe794a8, 0xe7aaaf, 0xe7be8a, 0xe88080, 0xe89189, 0xe89389, 0xe8a681, 0xe8aca1, 
0xe8b88a, 0xe981a5, 0xe999bd, 0xe9a48a, 0xe685be, 0xe68a91, 0xe6acb2, 0xe6b283, 
0xe6b5b4, 0xe7bf8c, 0xe7bfbc, 0xe6b780, 0xe7be85, 0xe89eba, 0xe8a3b8, 0xe69da5, 
0xe88eb1, 0xe9a0bc, 0xe99bb7, 0xe6b49b, 0xe7b5a1, 0xe890bd, 0xe985aa, 0xe4b9b1, 
0xe58db5, 0xe5b590, 0xe6ac84, 0xe6bfab, 0xe8978d, 0xe898ad, 0xe8a6a7, 0xe588a9, 
0xe5908f, 0xe5b1a5, 0xe69d8e, 0xe6a2a8, 0xe79086, 0xe79283, 
	/* 0xcea1 */
0xe797a2, 0xe8a38f, 0xe8a3a1, 0xe9878c, 0xe99ba2, 0xe999b8, 0xe5be8b, 0xe78e87, 
0xe7ab8b, 0xe8918e, 0xe68ea0, 0xe795a5, 0xe58a89, 0xe6b581, 0xe6ba9c, 0xe79089, 
0xe79599, 0xe7a1ab, 0xe7b292, 0xe99a86, 0xe7ab9c, 0xe9be8d, 0xe4beb6, 0xe685ae, 
0xe69785, 0xe8999c, 0xe4ba86, 0xe4baae, 0xe5839a, 0xe4b8a1, 0xe5878c, 0xe5afae, 
0xe69699, 0xe6a281, 0xe6b6bc, 0xe78c9f, 0xe79982, 0xe79ead, 0xe7a89c, 0xe7b3a7, 
0xe889af, 0xe8ab92, 0xe981bc, 0xe9878f, 0xe999b5, 0xe9a098, 0xe58a9b, 0xe7b791, 
0xe580ab, 0xe58e98, 0xe69e97, 0xe6b78b, 0xe78790, 0xe790b3, 0xe887a8, 0xe8bcaa, 
0xe99aa3, 0xe9b197, 0xe9ba9f, 0xe791a0, 0xe5a181, 0xe6b699, 0xe7b4af, 0xe9a19e, 
0xe4bba4, 0xe4bcb6, 0xe4be8b, 0xe586b7, 0xe58ab1, 0xe5b6ba, 0xe6809c, 0xe78eb2, 
0xe7a4bc, 0xe88b93, 0xe988b4, 0xe99ab7, 0xe99bb6, 0xe99c8a, 0xe9ba97, 0xe9bda2, 
0xe69aa6, 0xe6adb4, 0xe58897, 0xe58aa3, 0xe78388, 0xe8a382, 0xe5bb89, 0xe6818b, 
0xe68690, 0xe6bca3, 0xe78589, 0xe7b0be, 0xe7b7b4, 0xe881af, 
	/* 0xcfa1 */
0xe893ae, 0xe980a3, 0xe98cac, 0xe59182, 0xe9adaf, 0xe6ab93, 0xe78289, 0xe8b382, 
0xe8b7af, 0xe99cb2, 0xe58ab4, 0xe5a981, 0xe5bb8a, 0xe5bc84, 0xe69c97, 0xe6a5bc, 
0xe6a694, 0xe6b5aa, 0xe6bc8f, 0xe789a2, 0xe78bbc, 0xe7afad, 0xe88081, 0xe881be, 
0xe89d8b, 0xe9838e, 0xe585ad, 0xe9ba93, 0xe7a684, 0xe8828b, 0xe98cb2, 0xe8ab96, 
0xe580ad, 0xe5928c, 0xe8a9b1, 0xe6adaa, 0xe8b384, 0xe88487, 0xe68391, 0xe69ea0, 
0xe9b7b2, 0xe4ba99, 0xe4ba98, 0xe9b090, 0xe8a9ab, 0xe89781, 0xe895a8, 0xe6a480, 
0xe6b9be, 0xe7a297, 0xe88595, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0xd0a1 */
0xe5bc8c, 0xe4b890, 0xe4b895, 0xe4b8aa, 0xe4b8b1, 0xe4b8b6, 0xe4b8bc, 0xe4b8bf, 
0xe4b982, 0xe4b996, 0xe4b998, 0xe4ba82, 0xe4ba85, 0xe8b1ab, 0xe4ba8a, 0xe88892, 
0xe5bc8d, 0xe4ba8e, 0xe4ba9e, 0xe4ba9f, 0xe4baa0, 0xe4baa2, 0xe4bab0, 0xe4bab3, 
0xe4bab6, 0xe4bb8e, 0xe4bb8d, 0xe4bb84, 0xe4bb86, 0xe4bb82, 0xe4bb97, 0xe4bb9e, 
0xe4bbad, 0xe4bb9f, 0xe4bbb7, 0xe4bc89, 0xe4bd9a, 0xe4bcb0, 0xe4bd9b, 0xe4bd9d, 
0xe4bd97, 0xe4bd87, 0xe4bdb6, 0xe4be88, 0xe4be8f, 0xe4be98, 0xe4bdbb, 0xe4bda9, 
0xe4bdb0, 0xe4be91, 0xe4bdaf, 0xe4be86, 0xe4be96, 0xe58498, 0xe4bf94, 0xe4bf9f, 
0xe4bf8e, 0xe4bf98, 0xe4bf9b, 0xe4bf91, 0xe4bf9a, 0xe4bf90, 0xe4bfa4, 0xe4bfa5, 
0xe5809a, 0xe580a8, 0xe58094, 0xe580aa, 0xe580a5, 0xe58085, 0xe4bc9c, 0xe4bfb6, 
0xe580a1, 0xe580a9, 0xe580ac, 0xe4bfbe, 0xe4bfaf, 0xe58091, 0xe58086, 0xe58183, 
0xe58187, 0xe69c83, 0xe58195, 0xe58190, 0xe58188, 0xe5819a, 0xe58196, 0xe581ac, 
0xe581b8, 0xe58280, 0xe5829a, 0xe58285, 0xe582b4, 0xe582b2, 
	/* 0xd1a1 */
0xe58389, 0xe5838a, 0xe582b3, 0xe58382, 0xe58396, 0xe5839e, 0xe583a5, 0xe583ad, 
0xe583a3, 0xe583ae, 0xe583b9, 0xe583b5, 0xe58489, 0xe58481, 0xe58482, 0xe58496, 
0xe58495, 0xe58494, 0xe5849a, 0xe584a1, 0xe584ba, 0xe584b7, 0xe584bc, 0xe584bb, 
0xe584bf, 0xe58580, 0xe58592, 0xe5858c, 0xe58594, 0xe585a2, 0xe7abb8, 0xe585a9, 
0xe585aa, 0xe585ae, 0xe58680, 0xe58682, 0xe59b98, 0xe5868c, 0xe58689, 0xe5868f, 
0xe58691, 0xe58693, 0xe58695, 0xe58696, 0xe586a4, 0xe586a6, 0xe586a2, 0xe586a9, 
0xe586aa, 0xe586ab, 0xe586b3, 0xe586b1, 0xe586b2, 0xe586b0, 0xe586b5, 0xe586bd, 
0xe58785, 0xe58789, 0xe5879b, 0xe587a0, 0xe89995, 0xe587a9, 0xe587ad, 0xe587b0, 
0xe587b5, 0xe587be, 0xe58884, 0xe5888b, 0xe58894, 0xe5888e, 0xe588a7, 0xe588aa, 
0xe588ae, 0xe588b3, 0xe588b9, 0xe5898f, 0xe58984, 0xe5898b, 0xe5898c, 0xe5899e, 
0xe58994, 0xe589aa, 0xe589b4, 0xe589a9, 0xe589b3, 0xe589bf, 0xe589bd, 0xe58a8d, 
0xe58a94, 0xe58a92, 0xe589b1, 0xe58a88, 0xe58a91, 0xe8bea8, 
	/* 0xd2a1 */
0xe8bea7, 0xe58aac, 0xe58aad, 0xe58abc, 0xe58ab5, 0xe58b81, 0xe58b8d, 0xe58b97, 
0xe58b9e, 0xe58ba3, 0xe58ba6, 0xe9a3ad, 0xe58ba0, 0xe58bb3, 0xe58bb5, 0xe58bb8, 
0xe58bb9, 0xe58c86, 0xe58c88, 0xe794b8, 0xe58c8d, 0xe58c90, 0xe58c8f, 0xe58c95, 
0xe58c9a, 0xe58ca3, 0xe58caf, 0xe58cb1, 0xe58cb3, 0xe58cb8, 0xe58d80, 0xe58d86, 
0xe58d85, 0xe4b897, 0xe58d89, 0xe58d8d, 0xe58796, 0xe58d9e, 0xe58da9, 0xe58dae, 
0xe5a498, 0xe58dbb, 0xe58db7, 0xe58e82, 0xe58e96, 0xe58ea0, 0xe58ea6, 0xe58ea5, 
0xe58eae, 0xe58eb0, 0xe58eb6, 0xe58f83, 0xe7b092, 0xe99b99, 0xe58f9f, 0xe69bbc, 
0xe787ae, 0xe58fae, 0xe58fa8, 0xe58fad, 0xe58fba, 0xe59081, 0xe590bd, 0xe59180, 
0xe590ac, 0xe590ad, 0xe590bc, 0xe590ae, 0xe590b6, 0xe590a9, 0xe5909d, 0xe5918e, 
0xe5928f, 0xe591b5, 0xe5928e, 0xe5919f, 0xe591b1, 0xe591b7, 0xe591b0, 0xe59292, 
0xe591bb, 0xe59280, 0xe591b6, 0xe59284, 0xe59290, 0xe59286, 0xe59387, 0xe592a2, 
0xe592b8, 0xe592a5, 0xe592ac, 0xe59384, 0xe59388, 0xe592a8, 
	/* 0xd3a1 */
0xe592ab, 0xe59382, 0xe592a4, 0xe592be, 0xe592bc, 0xe59398, 0xe593a5, 0xe593a6, 
0xe5948f, 0xe59494, 0xe593bd, 0xe593ae, 0xe593ad, 0xe593ba, 0xe593a2, 0xe594b9, 
0xe59580, 0xe595a3, 0xe5958c, 0xe594ae, 0xe5959c, 0xe59585, 0xe59596, 0xe59597, 
0xe594b8, 0xe594b3, 0xe5959d, 0xe59699, 0xe59680, 0xe592af, 0xe5968a, 0xe5969f, 
0xe595bb, 0xe595be, 0xe59698, 0xe5969e, 0xe596ae, 0xe595bc, 0xe59683, 0xe596a9, 
0xe59687, 0xe596a8, 0xe5979a, 0xe59785, 0xe5979f, 0xe59784, 0xe5979c, 0xe597a4, 
0xe59794, 0xe59894, 0xe597b7, 0xe59896, 0xe597be, 0xe597bd, 0xe5989b, 0xe597b9, 
0xe5998e, 0xe59990, 0xe7879f, 0xe598b4, 0xe598b6, 0xe598b2, 0xe598b8, 0xe599ab, 
0xe599a4, 0xe598af, 0xe599ac, 0xe599aa, 0xe59a86, 0xe59a80, 0xe59a8a, 0xe59aa0, 
0xe59a94, 0xe59a8f, 0xe59aa5, 0xe59aae, 0xe59ab6, 0xe59ab4, 0xe59b82, 0xe59abc, 
0xe59b81, 0xe59b83, 0xe59b80, 0xe59b88, 0xe59b8e, 0xe59b91, 0xe59b93, 0xe59b97, 
0xe59bae, 0xe59bb9, 0xe59c80, 0xe59bbf, 0xe59c84, 0xe59c89, 
	/* 0xd4a1 */
0xe59c88, 0xe59c8b, 0xe59c8d, 0xe59c93, 0xe59c98, 0xe59c96, 0xe59787, 0xe59c9c, 
0xe59ca6, 0xe59cb7, 0xe59cb8, 0xe59d8e, 0xe59cbb, 0xe59d80, 0xe59d8f, 0xe59da9, 
0xe59f80, 0xe59e88, 0xe59da1, 0xe59dbf, 0xe59e89, 0xe59e93, 0xe59ea0, 0xe59eb3, 
0xe59ea4, 0xe59eaa, 0xe59eb0, 0xe59f83, 0xe59f86, 0xe59f94, 0xe59f92, 0xe59f93, 
0xe5a08a, 0xe59f96, 0xe59fa3, 0xe5a08b, 0xe5a099, 0xe5a09d, 0xe5a1b2, 0xe5a0a1, 
0xe5a1a2, 0xe5a18b, 0xe5a1b0, 0xe6af80, 0xe5a192, 0xe5a0bd, 0xe5a1b9, 0xe5a285, 
0xe5a2b9, 0xe5a29f, 0xe5a2ab, 0xe5a2ba, 0xe5a39e, 0xe5a2bb, 0xe5a2b8, 0xe5a2ae, 
0xe5a385, 0xe5a393, 0xe5a391, 0xe5a397, 0xe5a399, 0xe5a398, 0xe5a3a5, 0xe5a39c, 
0xe5a3a4, 0xe5a39f, 0xe5a3af, 0xe5a3ba, 0xe5a3b9, 0xe5a3bb, 0xe5a3bc, 0xe5a3bd, 
0xe5a482, 0xe5a48a, 0xe5a490, 0xe5a49b, 0xe6a2a6, 0xe5a4a5, 0xe5a4ac, 0xe5a4ad, 
0xe5a4b2, 0xe5a4b8, 0xe5a4be, 0xe7ab92, 0xe5a595, 0xe5a590, 0xe5a58e, 0xe5a59a, 
0xe5a598, 0xe5a5a2, 0xe5a5a0, 0xe5a5a7, 0xe5a5ac, 0xe5a5a9, 
	/* 0xd5a1 */
0xe5a5b8, 0xe5a681, 0xe5a69d, 0xe4bd9e, 0xe4beab, 0xe5a6a3, 0xe5a6b2, 0xe5a786, 
0xe5a7a8, 0xe5a79c, 0xe5a68d, 0xe5a799, 0xe5a79a, 0xe5a8a5, 0xe5a89f, 0xe5a891, 
0xe5a89c, 0xe5a889, 0xe5a89a, 0xe5a980, 0xe5a9ac, 0xe5a989, 0xe5a8b5, 0xe5a8b6, 
0xe5a9a2, 0xe5a9aa, 0xe5aa9a, 0xe5aabc, 0xe5aabe, 0xe5ab8b, 0xe5ab82, 0xe5aabd, 
0xe5aba3, 0xe5ab97, 0xe5aba6, 0xe5aba9, 0xe5ab96, 0xe5abba, 0xe5abbb, 0xe5ac8c, 
0xe5ac8b, 0xe5ac96, 0xe5acb2, 0xe5ab90, 0xe5acaa, 0xe5acb6, 0xe5acbe, 0xe5ad83, 
0xe5ad85, 0xe5ad80, 0xe5ad91, 0xe5ad95, 0xe5ad9a, 0xe5ad9b, 0xe5ada5, 0xe5ada9, 
0xe5adb0, 0xe5adb3, 0xe5adb5, 0xe5adb8, 0xe69688, 0xe5adba, 0xe5ae80, 0xe5ae83, 
0xe5aea6, 0xe5aeb8, 0xe5af83, 0xe5af87, 0xe5af89, 0xe5af94, 0xe5af90, 0xe5afa4, 
0xe5afa6, 0xe5afa2, 0xe5af9e, 0xe5afa5, 0xe5afab, 0xe5afb0, 0xe5afb6, 0xe5afb3, 
0xe5b085, 0xe5b087, 0xe5b088, 0xe5b08d, 0xe5b093, 0xe5b0a0, 0xe5b0a2, 0xe5b0a8, 
0xe5b0b8, 0xe5b0b9, 0xe5b181, 0xe5b186, 0xe5b18e, 0xe5b193, 
	/* 0xd6a1 */
0xe5b190, 0xe5b18f, 0xe5adb1, 0xe5b1ac, 0xe5b1ae, 0xe4b9a2, 0xe5b1b6, 0xe5b1b9, 
0xe5b28c, 0xe5b291, 0xe5b294, 0xe5a69b, 0xe5b2ab, 0xe5b2bb, 0xe5b2b6, 0xe5b2bc, 
0xe5b2b7, 0xe5b385, 0xe5b2be, 0xe5b387, 0xe5b399, 0xe5b3a9, 0xe5b3bd, 0xe5b3ba, 
0xe5b3ad, 0xe5b68c, 0xe5b3aa, 0xe5b48b, 0xe5b495, 0xe5b497, 0xe5b59c, 0xe5b49f, 
0xe5b49b, 0xe5b491, 0xe5b494, 0xe5b4a2, 0xe5b49a, 0xe5b499, 0xe5b498, 0xe5b58c, 
0xe5b592, 0xe5b58e, 0xe5b58b, 0xe5b5ac, 0xe5b5b3, 0xe5b5b6, 0xe5b687, 0xe5b684, 
0xe5b682, 0xe5b6a2, 0xe5b69d, 0xe5b6ac, 0xe5b6ae, 0xe5b6bd, 0xe5b690, 0xe5b6b7, 
0xe5b6bc, 0xe5b789, 0xe5b78d, 0xe5b793, 0xe5b792, 0xe5b796, 0xe5b79b, 0xe5b7ab, 
0xe5b7b2, 0xe5b7b5, 0xe5b88b, 0xe5b89a, 0xe5b899, 0xe5b891, 0xe5b89b, 0xe5b8b6, 
0xe5b8b7, 0xe5b984, 0xe5b983, 0xe5b980, 0xe5b98e, 0xe5b997, 0xe5b994, 0xe5b99f, 
0xe5b9a2, 0xe5b9a4, 0xe5b987, 0xe5b9b5, 0xe5b9b6, 0xe5b9ba, 0xe9babc, 0xe5b9bf, 
0xe5baa0, 0xe5bb81, 0xe5bb82, 0xe5bb88, 0xe5bb90, 0xe5bb8f, 
	/* 0xd7a1 */
0xe5bb96, 0xe5bba3, 0xe5bb9d, 0xe5bb9a, 0xe5bb9b, 0xe5bba2, 0xe5bba1, 0xe5bba8, 
0xe5bba9, 0xe5bbac, 0xe5bbb1, 0xe5bbb3, 0xe5bbb0, 0xe5bbb4, 0xe5bbb8, 0xe5bbbe, 
0xe5bc83, 0xe5bc89, 0xe5bd9d, 0xe5bd9c, 0xe5bc8b, 0xe5bc91, 0xe5bc96, 0xe5bca9, 
0xe5bcad, 0xe5bcb8, 0xe5bd81, 0xe5bd88, 0xe5bd8c, 0xe5bd8e, 0xe5bcaf, 0xe5bd91, 
0xe5bd96, 0xe5bd97, 0xe5bd99, 0xe5bda1, 0xe5bdad, 0xe5bdb3, 0xe5bdb7, 0xe5be83, 
0xe5be82, 0xe5bdbf, 0xe5be8a, 0xe5be88, 0xe5be91, 0xe5be87, 0xe5be9e, 0xe5be99, 
0xe5be98, 0xe5bea0, 0xe5bea8, 0xe5bead, 0xe5bebc, 0xe5bf96, 0xe5bfbb, 0xe5bfa4, 
0xe5bfb8, 0xe5bfb1, 0xe5bf9d, 0xe682b3, 0xe5bfbf, 0xe680a1, 0xe681a0, 0xe68099, 
0xe68090, 0xe680a9, 0xe6808e, 0xe680b1, 0xe6809b, 0xe68095, 0xe680ab, 0xe680a6, 
0xe6808f, 0xe680ba, 0xe6819a, 0xe68181, 0xe681aa, 0xe681b7, 0xe6819f, 0xe6818a, 
0xe68186, 0xe6818d, 0xe681a3, 0xe68183, 0xe681a4, 0xe68182, 0xe681ac, 0xe681ab, 
0xe68199, 0xe68281, 0xe6828d, 0xe683a7, 0xe68283, 0xe6829a, 
	/* 0xd8a1 */
0xe68284, 0xe6829b, 0xe68296, 0xe68297, 0xe68292, 0xe682a7, 0xe6828b, 0xe683a1, 
0xe682b8, 0xe683a0, 0xe68393, 0xe682b4, 0xe5bfb0, 0xe682bd, 0xe68386, 0xe682b5, 
0xe68398, 0xe6858d, 0xe68495, 0xe68486, 0xe683b6, 0xe683b7, 0xe68480, 0xe683b4, 
0xe683ba, 0xe68483, 0xe684a1, 0xe683bb, 0xe683b1, 0xe6848d, 0xe6848e, 0xe68587, 
0xe684be, 0xe684a8, 0xe684a7, 0xe6858a, 0xe684bf, 0xe684bc, 0xe684ac, 0xe684b4, 
0xe684bd, 0xe68582, 0xe68584, 0xe685b3, 0xe685b7, 0xe68598, 0xe68599, 0xe6859a, 
0xe685ab, 0xe685b4, 0xe685af, 0xe685a5, 0xe685b1, 0xe6859f, 0xe6859d, 0xe68593, 
0xe685b5, 0xe68699, 0xe68696, 0xe68687, 0xe686ac, 0xe68694, 0xe6869a, 0xe6868a, 
0xe68691, 0xe686ab, 0xe686ae, 0xe6878c, 0xe6878a, 0xe68789, 0xe687b7, 0xe68788, 
0xe68783, 0xe68786, 0xe686ba, 0xe6878b, 0xe7bdb9, 0xe6878d, 0xe687a6, 0xe687a3, 
0xe687b6, 0xe687ba, 0xe687b4, 0xe687bf, 0xe687bd, 0xe687bc, 0xe687be, 0xe68880, 
0xe68888, 0xe68889, 0xe6888d, 0xe6888c, 0xe68894, 0xe6889b, 
	/* 0xd9a1 */
0xe6889e, 0xe688a1, 0xe688aa, 0xe688ae, 0xe688b0, 0xe688b2, 0xe688b3, 0xe68981, 
0xe6898e, 0xe6899e, 0xe689a3, 0xe6899b, 0xe689a0, 0xe689a8, 0xe689bc, 0xe68a82, 
0xe68a89, 0xe689be, 0xe68a92, 0xe68a93, 0xe68a96, 0xe68b94, 0xe68a83, 0xe68a94, 
0xe68b97, 0xe68b91, 0xe68abb, 0xe68b8f, 0xe68bbf, 0xe68b86, 0xe69394, 0xe68b88, 
0xe68b9c, 0xe68b8c, 0xe68b8a, 0xe68b82, 0xe68b87, 0xe68a9b, 0xe68b89, 0xe68c8c, 
0xe68bae, 0xe68bb1, 0xe68ca7, 0xe68c82, 0xe68c88, 0xe68baf, 0xe68bb5, 0xe68d90, 
0xe68cbe, 0xe68d8d, 0xe6909c, 0xe68d8f, 0xe68e96, 0xe68e8e, 0xe68e80, 0xe68eab, 
0xe68db6, 0xe68ea3, 0xe68e8f, 0xe68e89, 0xe68e9f, 0xe68eb5, 0xe68dab, 0xe68da9, 
0xe68ebe, 0xe68fa9, 0xe68f80, 0xe68f86, 0xe68fa3, 0xe68f89, 0xe68f92, 0xe68fb6, 
0xe68f84, 0xe69096, 0xe690b4, 0xe69086, 0xe69093, 0xe690a6, 0xe690b6, 0xe6949d, 
0xe69097, 0xe690a8, 0xe6908f, 0xe691a7, 0xe691af, 0xe691b6, 0xe6918e, 0xe694aa, 
0xe69295, 0xe69293, 0xe692a5, 0xe692a9, 0xe69288, 0xe692bc, 
	/* 0xdaa1 */
0xe6939a, 0xe69392, 0xe69385, 0xe69387, 0xe692bb, 0xe69398, 0xe69382, 0xe693b1, 
0xe693a7, 0xe88889, 0xe693a0, 0xe693a1, 0xe68aac, 0xe693a3, 0xe693af, 0xe694ac, 
0xe693b6, 0xe693b4, 0xe693b2, 0xe693ba, 0xe69480, 0xe693bd, 0xe69498, 0xe6949c, 
0xe69485, 0xe694a4, 0xe694a3, 0xe694ab, 0xe694b4, 0xe694b5, 0xe694b7, 0xe694b6, 
0xe694b8, 0xe7958b, 0xe69588, 0xe69596, 0xe69595, 0xe6958d, 0xe69598, 0xe6959e, 
0xe6959d, 0xe695b2, 0xe695b8, 0xe69682, 0xe69683, 0xe8ae8a, 0xe6969b, 0xe6969f, 
0xe696ab, 0xe696b7, 0xe69783, 0xe69786, 0xe69781, 0xe69784, 0xe6978c, 0xe69792, 
0xe6979b, 0xe69799, 0xe697a0, 0xe697a1, 0xe697b1, 0xe69db2, 0xe6988a, 0xe69883, 
0xe697bb, 0xe69db3, 0xe698b5, 0xe698b6, 0xe698b4, 0xe6989c, 0xe6998f, 0xe69984, 
0xe69989, 0xe69981, 0xe6999e, 0xe6999d, 0xe699a4, 0xe699a7, 0xe699a8, 0xe6999f, 
0xe699a2, 0xe699b0, 0xe69a83, 0xe69a88, 0xe69a8e, 0xe69a89, 0xe69a84, 0xe69a98, 
0xe69a9d, 0xe69b81, 0xe69ab9, 0xe69b89, 0xe69abe, 0xe69abc, 
	/* 0xdba1 */
0xe69b84, 0xe69ab8, 0xe69b96, 0xe69b9a, 0xe69ba0, 0xe698bf, 0xe69ba6, 0xe69ba9, 
0xe69bb0, 0xe69bb5, 0xe69bb7, 0xe69c8f, 0xe69c96, 0xe69c9e, 0xe69ca6, 0xe69ca7, 
0xe99cb8, 0xe69cae, 0xe69cbf, 0xe69cb6, 0xe69d81, 0xe69cb8, 0xe69cb7, 0xe69d86, 
0xe69d9e, 0xe69da0, 0xe69d99, 0xe69da3, 0xe69da4, 0xe69e89, 0xe69db0, 0xe69ea9, 
0xe69dbc, 0xe69daa, 0xe69e8c, 0xe69e8b, 0xe69ea6, 0xe69ea1, 0xe69e85, 0xe69eb7, 
0xe69faf, 0xe69eb4, 0xe69fac, 0xe69eb3, 0xe69fa9, 0xe69eb8, 0xe69fa4, 0xe69f9e, 
0xe69f9d, 0xe69fa2, 0xe69fae, 0xe69eb9, 0xe69f8e, 0xe69f86, 0xe69fa7, 0xe6aa9c, 
0xe6a09e, 0xe6a186, 0xe6a0a9, 0xe6a180, 0xe6a18d, 0xe6a0b2, 0xe6a18e, 0xe6a2b3, 
0xe6a0ab, 0xe6a199, 0xe6a1a3, 0xe6a1b7, 0xe6a1bf, 0xe6a29f, 0xe6a28f, 0xe6a2ad, 
0xe6a294, 0xe6a29d, 0xe6a29b, 0xe6a283, 0xe6aaae, 0xe6a2b9, 0xe6a1b4, 0xe6a2b5, 
0xe6a2a0, 0xe6a2ba, 0xe6a48f, 0xe6a28d, 0xe6a1be, 0xe6a481, 0xe6a38a, 0xe6a488, 
0xe6a398, 0xe6a4a2, 0xe6a4a6, 0xe6a3a1, 0xe6a48c, 0xe6a38d, 
	/* 0xdca1 */
0xe6a394, 0xe6a3a7, 0xe6a395, 0xe6a4b6, 0xe6a492, 0xe6a484, 0xe6a397, 0xe6a3a3, 
0xe6a4a5, 0xe6a3b9, 0xe6a3a0, 0xe6a3af, 0xe6a4a8, 0xe6a4aa, 0xe6a49a, 0xe6a4a3, 
0xe6a4a1, 0xe6a386, 0xe6a5b9, 0xe6a5b7, 0xe6a59c, 0xe6a5b8, 0xe6a5ab, 0xe6a594, 
0xe6a5be, 0xe6a5ae, 0xe6a4b9, 0xe6a5b4, 0xe6a4bd, 0xe6a599, 0xe6a4b0, 0xe6a5a1, 
0xe6a59e, 0xe6a59d, 0xe6a681, 0xe6a5aa, 0xe6a6b2, 0xe6a6ae, 0xe6a790, 0xe6a6bf, 
0xe6a781, 0xe6a793, 0xe6a6be, 0xe6a78e, 0xe5afa8, 0xe6a78a, 0xe6a79d, 0xe6a6bb, 
0xe6a783, 0xe6a6a7, 0xe6a8ae, 0xe6a691, 0xe6a6a0, 0xe6a69c, 0xe6a695, 0xe6a6b4, 
0xe6a79e, 0xe6a7a8, 0xe6a882, 0xe6a89b, 0xe6a7bf, 0xe6ac8a, 0xe6a7b9, 0xe6a7b2, 
0xe6a7a7, 0xe6a885, 0xe6a6b1, 0xe6a89e, 0xe6a7ad, 0xe6a894, 0xe6a7ab, 0xe6a88a, 
0xe6a892, 0xe6ab81, 0xe6a8a3, 0xe6a893, 0xe6a984, 0xe6a88c, 0xe6a9b2, 0xe6a8b6, 
0xe6a9b8, 0xe6a987, 0xe6a9a2, 0xe6a999, 0xe6a9a6, 0xe6a988, 0xe6a8b8, 0xe6a8a2, 
0xe6aa90, 0xe6aa8d, 0xe6aaa0, 0xe6aa84, 0xe6aaa2, 0xe6aaa3, 
	/* 0xdda1 */
0xe6aa97, 0xe89897, 0xe6aabb, 0xe6ab83, 0xe6ab82, 0xe6aab8, 0xe6aab3, 0xe6aaac, 
0xe6ab9e, 0xe6ab91, 0xe6ab9f, 0xe6aaaa, 0xe6ab9a, 0xe6abaa, 0xe6abbb, 0xe6ac85, 
0xe89896, 0xe6abba, 0xe6ac92, 0xe6ac96, 0xe9acb1, 0xe6ac9f, 0xe6acb8, 0xe6acb7, 
0xe79b9c, 0xe6acb9, 0xe9a3ae, 0xe6ad87, 0xe6ad83, 0xe6ad89, 0xe6ad90, 0xe6ad99, 
0xe6ad94, 0xe6ad9b, 0xe6ad9f, 0xe6ada1, 0xe6adb8, 0xe6adb9, 0xe6adbf, 0xe6ae80, 
0xe6ae84, 0xe6ae83, 0xe6ae8d, 0xe6ae98, 0xe6ae95, 0xe6ae9e, 0xe6aea4, 0xe6aeaa, 
0xe6aeab, 0xe6aeaf, 0xe6aeb2, 0xe6aeb1, 0xe6aeb3, 0xe6aeb7, 0xe6aebc, 0xe6af86, 
0xe6af8b, 0xe6af93, 0xe6af9f, 0xe6afac, 0xe6afab, 0xe6afb3, 0xe6afaf, 0xe9babe, 
0xe6b088, 0xe6b093, 0xe6b094, 0xe6b09b, 0xe6b0a4, 0xe6b0a3, 0xe6b19e, 0xe6b195, 
0xe6b1a2, 0xe6b1aa, 0xe6b282, 0xe6b28d, 0xe6b29a, 0xe6b281, 0xe6b29b, 0xe6b1be, 
0xe6b1a8, 0xe6b1b3, 0xe6b292, 0xe6b290, 0xe6b384, 0xe6b3b1, 0xe6b393, 0xe6b2bd, 
0xe6b397, 0xe6b385, 0xe6b39d, 0xe6b2ae, 0xe6b2b1, 0xe6b2be, 
	/* 0xdea1 */
0xe6b2ba, 0xe6b39b, 0xe6b3af, 0xe6b399, 0xe6b3aa, 0xe6b49f, 0xe8a18d, 0xe6b4b6, 
0xe6b4ab, 0xe6b4bd, 0xe6b4b8, 0xe6b499, 0xe6b4b5, 0xe6b4b3, 0xe6b492, 0xe6b48c, 
0xe6b5a3, 0xe6b693, 0xe6b5a4, 0xe6b59a, 0xe6b5b9, 0xe6b599, 0xe6b68e, 0xe6b695, 
0xe6bfa4, 0xe6b685, 0xe6b7b9, 0xe6b895, 0xe6b88a, 0xe6b6b5, 0xe6b787, 0xe6b7a6, 
0xe6b6b8, 0xe6b786, 0xe6b7ac, 0xe6b79e, 0xe6b78c, 0xe6b7a8, 0xe6b792, 0xe6b785, 
0xe6b7ba, 0xe6b799, 0xe6b7a4, 0xe6b795, 0xe6b7aa, 0xe6b7ae, 0xe6b8ad, 0xe6b9ae, 
0xe6b8ae, 0xe6b899, 0xe6b9b2, 0xe6b99f, 0xe6b8be, 0xe6b8a3, 0xe6b9ab, 0xe6b8ab, 
0xe6b9b6, 0xe6b98d, 0xe6b89f, 0xe6b983, 0xe6b8ba, 0xe6b98e, 0xe6b8a4, 0xe6bbbf, 
0xe6b89d, 0xe6b8b8, 0xe6ba82, 0xe6baaa, 0xe6ba98, 0xe6bb89, 0xe6bab7, 0xe6bb93, 
0xe6babd, 0xe6baaf, 0xe6bb84, 0xe6bab2, 0xe6bb94, 0xe6bb95, 0xe6ba8f, 0xe6baa5, 
0xe6bb82, 0xe6ba9f, 0xe6bd81, 0xe6bc91, 0xe7818c, 0xe6bbac, 0xe6bbb8, 0xe6bbbe, 
0xe6bcbf, 0xe6bbb2, 0xe6bcb1, 0xe6bbaf, 0xe6bcb2, 0xe6bb8c, 
	/* 0xdfa1 */
0xe6bcbe, 0xe6bc93, 0xe6bbb7, 0xe6be86, 0xe6bdba, 0xe6bdb8, 0xe6be81, 0xe6be80, 
0xe6bdaf, 0xe6bd9b, 0xe6bfb3, 0xe6bdad, 0xe6be82, 0xe6bdbc, 0xe6bd98, 0xe6be8e, 
0xe6be91, 0xe6bf82, 0xe6bda6, 0xe6beb3, 0xe6bea3, 0xe6bea1, 0xe6bea4, 0xe6beb9, 
0xe6bf86, 0xe6beaa, 0xe6bf9f, 0xe6bf95, 0xe6bfac, 0xe6bf94, 0xe6bf98, 0xe6bfb1, 
0xe6bfae, 0xe6bf9b, 0xe78089, 0xe7808b, 0xe6bfba, 0xe78091, 0xe78081, 0xe7808f, 
0xe6bfbe, 0xe7809b, 0xe7809a, 0xe6bdb4, 0xe7809d, 0xe78098, 0xe7809f, 0xe780b0, 
0xe780be, 0xe780b2, 0xe78191, 0xe781a3, 0xe78299, 0xe78292, 0xe782af, 0xe783b1, 
0xe782ac, 0xe782b8, 0xe782b3, 0xe782ae, 0xe7839f, 0xe7838b, 0xe7839d, 0xe78399, 
0xe78489, 0xe783bd, 0xe7849c, 0xe78499, 0xe785a5, 0xe78595, 0xe78688, 0xe785a6, 
0xe785a2, 0xe7858c, 0xe78596, 0xe785ac, 0xe7868f, 0xe787bb, 0xe78684, 0xe78695, 
0xe786a8, 0xe786ac, 0xe78797, 0xe786b9, 0xe786be, 0xe78792, 0xe78789, 0xe78794, 
0xe7878e, 0xe787a0, 0xe787ac, 0xe787a7, 0xe787b5, 0xe787bc, 
	/* 0xe0a1 */
0xe787b9, 0xe787bf, 0xe7888d, 0xe78890, 0xe7889b, 0xe788a8, 0xe788ad, 0xe788ac, 
0xe788b0, 0xe788b2, 0xe788bb, 0xe788bc, 0xe788bf, 0xe78980, 0xe78986, 0xe7898b, 
0xe78998, 0xe789b4, 0xe789be, 0xe78a82, 0xe78a81, 0xe78a87, 0xe78a92, 0xe78a96, 
0xe78aa2, 0xe78aa7, 0xe78ab9, 0xe78ab2, 0xe78b83, 0xe78b86, 0xe78b84, 0xe78b8e, 
0xe78b92, 0xe78ba2, 0xe78ba0, 0xe78ba1, 0xe78bb9, 0xe78bb7, 0xe5808f, 0xe78c97, 
0xe78c8a, 0xe78c9c, 0xe78c96, 0xe78c9d, 0xe78cb4, 0xe78caf, 0xe78ca9, 0xe78ca5, 
0xe78cbe, 0xe78d8e, 0xe78d8f, 0xe9bb98, 0xe78d97, 0xe78daa, 0xe78da8, 0xe78db0, 
0xe78db8, 0xe78db5, 0xe78dbb, 0xe78dba, 0xe78f88, 0xe78eb3, 0xe78f8e, 0xe78ebb, 
0xe78f80, 0xe78fa5, 0xe78fae, 0xe78f9e, 0xe792a2, 0xe79085, 0xe791af, 0xe790a5, 
0xe78fb8, 0xe790b2, 0xe790ba, 0xe79195, 0xe790bf, 0xe7919f, 0xe79199, 0xe79181, 
0xe7919c, 0xe791a9, 0xe791b0, 0xe791a3, 0xe791aa, 0xe791b6, 0xe791be, 0xe7928b, 
0xe7929e, 0xe792a7, 0xe7938a, 0xe7938f, 0xe79394, 0xe78fb1, 
	/* 0xe1a1 */
0xe793a0, 0xe793a3, 0xe793a7, 0xe793a9, 0xe793ae, 0xe793b2, 0xe793b0, 0xe793b1, 
0xe793b8, 0xe793b7, 0xe79484, 0xe79483, 0xe79485, 0xe7948c, 0xe7948e, 0xe7948d, 
0xe79495, 0xe79493, 0xe7949e, 0xe794a6, 0xe794ac, 0xe794bc, 0xe79584, 0xe7958d, 
0xe7958a, 0xe79589, 0xe7959b, 0xe79586, 0xe7959a, 0xe795a9, 0xe795a4, 0xe795a7, 
0xe795ab, 0xe795ad, 0xe795b8, 0xe795b6, 0xe79686, 0xe79687, 0xe795b4, 0xe7968a, 
0xe79689, 0xe79682, 0xe79694, 0xe7969a, 0xe7969d, 0xe796a5, 0xe796a3, 0xe79782, 
0xe796b3, 0xe79783, 0xe796b5, 0xe796bd, 0xe796b8, 0xe796bc, 0xe796b1, 0xe7978d, 
0xe7978a, 0xe79792, 0xe79799, 0xe797a3, 0xe7979e, 0xe797be, 0xe797bf, 0xe797bc, 
0xe79881, 0xe797b0, 0xe797ba, 0xe797b2, 0xe797b3, 0xe7988b, 0xe7988d, 0xe79889, 
0xe7989f, 0xe798a7, 0xe798a0, 0xe798a1, 0xe798a2, 0xe798a4, 0xe798b4, 0xe798b0, 
0xe798bb, 0xe79987, 0xe79988, 0xe79986, 0xe7999c, 0xe79998, 0xe799a1, 0xe799a2, 
0xe799a8, 0xe799a9, 0xe799aa, 0xe799a7, 0xe799ac, 0xe799b0, 
	/* 0xe2a1 */
0xe799b2, 0xe799b6, 0xe799b8, 0xe799bc, 0xe79a80, 0xe79a83, 0xe79a88, 0xe79a8b, 
0xe79a8e, 0xe79a96, 0xe79a93, 0xe79a99, 0xe79a9a, 0xe79ab0, 0xe79ab4, 0xe79ab8, 
0xe79ab9, 0xe79aba, 0xe79b82, 0xe79b8d, 0xe79b96, 0xe79b92, 0xe79b9e, 0xe79ba1, 
0xe79ba5, 0xe79ba7, 0xe79baa, 0xe898af, 0xe79bbb, 0xe79c88, 0xe79c87, 0xe79c84, 
0xe79ca9, 0xe79ca4, 0xe79c9e, 0xe79ca5, 0xe79ca6, 0xe79c9b, 0xe79cb7, 0xe79cb8, 
0xe79d87, 0xe79d9a, 0xe79da8, 0xe79dab, 0xe79d9b, 0xe79da5, 0xe79dbf, 0xe79dbe, 
0xe79db9, 0xe79e8e, 0xe79e8b, 0xe79e91, 0xe79ea0, 0xe79e9e, 0xe79eb0, 0xe79eb6, 
0xe79eb9, 0xe79ebf, 0xe79ebc, 0xe79ebd, 0xe79ebb, 0xe79f87, 0xe79f8d, 0xe79f97, 
0xe79f9a, 0xe79f9c, 0xe79fa3, 0xe79fae, 0xe79fbc, 0xe7a08c, 0xe7a092, 0xe7a4a6, 
0xe7a0a0, 0xe7a4aa, 0xe7a185, 0xe7a28e, 0xe7a1b4, 0xe7a286, 0xe7a1bc, 0xe7a29a, 
0xe7a28c, 0xe7a2a3, 0xe7a2b5, 0xe7a2aa, 0xe7a2af, 0xe7a391, 0xe7a386, 0xe7a38b, 
0xe7a394, 0xe7a2be, 0xe7a2bc, 0xe7a385, 0xe7a38a, 0xe7a3ac, 
	/* 0xe3a1 */
0xe7a3a7, 0xe7a39a, 0xe7a3bd, 0xe7a3b4, 0xe7a487, 0xe7a492, 0xe7a491, 0xe7a499, 
0xe7a4ac, 0xe7a4ab, 0xe7a580, 0xe7a5a0, 0xe7a597, 0xe7a59f, 0xe7a59a, 0xe7a595, 
0xe7a593, 0xe7a5ba, 0xe7a5bf, 0xe7a68a, 0xe7a69d, 0xe7a6a7, 0xe9bd8b, 0xe7a6aa, 
0xe7a6ae, 0xe7a6b3, 0xe7a6b9, 0xe7a6ba, 0xe7a789, 0xe7a795, 0xe7a7a7, 0xe7a7ac, 
0xe7a7a1, 0xe7a7a3, 0xe7a888, 0xe7a88d, 0xe7a898, 0xe7a899, 0xe7a8a0, 0xe7a89f, 
0xe7a680, 0xe7a8b1, 0xe7a8bb, 0xe7a8be, 0xe7a8b7, 0xe7a983, 0xe7a997, 0xe7a989, 
0xe7a9a1, 0xe7a9a2, 0xe7a9a9, 0xe9be9d, 0xe7a9b0, 0xe7a9b9, 0xe7a9bd, 0xe7aa88, 
0xe7aa97, 0xe7aa95, 0xe7aa98, 0xe7aa96, 0xe7aaa9, 0xe7ab88, 0xe7aab0, 0xe7aab6, 
0xe7ab85, 0xe7ab84, 0xe7aabf, 0xe98283, 0xe7ab87, 0xe7ab8a, 0xe7ab8d, 0xe7ab8f, 
0xe7ab95, 0xe7ab93, 0xe7ab99, 0xe7ab9a, 0xe7ab9d, 0xe7aba1, 0xe7aba2, 0xe7aba6, 
0xe7abad, 0xe7abb0, 0xe7ac82, 0xe7ac8f, 0xe7ac8a, 0xe7ac86, 0xe7acb3, 0xe7ac98, 
0xe7ac99, 0xe7ac9e, 0xe7acb5, 0xe7aca8, 0xe7acb6, 0xe7ad90, 
	/* 0xe4a1 */
0xe7adba, 0xe7ac84, 0xe7ad8d, 0xe7ac8b, 0xe7ad8c, 0xe7ad85, 0xe7adb5, 0xe7ada5, 
0xe7adb4, 0xe7ada7, 0xe7adb0, 0xe7adb1, 0xe7adac, 0xe7adae, 0xe7ae9d, 0xe7ae98, 
0xe7ae9f, 0xe7ae8d, 0xe7ae9c, 0xe7ae9a, 0xe7ae8b, 0xe7ae92, 0xe7ae8f, 0xe7ad9d, 
0xe7ae99, 0xe7af8b, 0xe7af81, 0xe7af8c, 0xe7af8f, 0xe7aeb4, 0xe7af86, 0xe7af9d, 
0xe7afa9, 0xe7b091, 0xe7b094, 0xe7afa6, 0xe7afa5, 0xe7b1a0, 0xe7b080, 0xe7b087, 
0xe7b093, 0xe7afb3, 0xe7afb7, 0xe7b097, 0xe7b08d, 0xe7afb6, 0xe7b0a3, 0xe7b0a7, 
0xe7b0aa, 0xe7b09f, 0xe7b0b7, 0xe7b0ab, 0xe7b0bd, 0xe7b18c, 0xe7b183, 0xe7b194, 
0xe7b18f, 0xe7b180, 0xe7b190, 0xe7b198, 0xe7b19f, 0xe7b1a4, 0xe7b196, 0xe7b1a5, 
0xe7b1ac, 0xe7b1b5, 0xe7b283, 0xe7b290, 0xe7b2a4, 0xe7b2ad, 0xe7b2a2, 0xe7b2ab, 
0xe7b2a1, 0xe7b2a8, 0xe7b2b3, 0xe7b2b2, 0xe7b2b1, 0xe7b2ae, 0xe7b2b9, 0xe7b2bd, 
0xe7b380, 0xe7b385, 0xe7b382, 0xe7b398, 0xe7b392, 0xe7b39c, 0xe7b3a2, 0xe9acbb, 
0xe7b3af, 0xe7b3b2, 0xe7b3b4, 0xe7b3b6, 0xe7b3ba, 0xe7b486, 
	/* 0xe5a1 */
0xe7b482, 0xe7b49c, 0xe7b495, 0xe7b48a, 0xe7b585, 0xe7b58b, 0xe7b4ae, 0xe7b4b2, 
0xe7b4bf, 0xe7b4b5, 0xe7b586, 0xe7b5b3, 0xe7b596, 0xe7b58e, 0xe7b5b2, 0xe7b5a8, 
0xe7b5ae, 0xe7b58f, 0xe7b5a3, 0xe7b693, 0xe7b689, 0xe7b59b, 0xe7b68f, 0xe7b5bd, 
0xe7b69b, 0xe7b6ba, 0xe7b6ae, 0xe7b6a3, 0xe7b6b5, 0xe7b787, 0xe7b6bd, 0xe7b6ab, 
0xe7b8bd, 0xe7b6a2, 0xe7b6af, 0xe7b79c, 0xe7b6b8, 0xe7b69f, 0xe7b6b0, 0xe7b798, 
0xe7b79d, 0xe7b7a4, 0xe7b79e, 0xe7b7bb, 0xe7b7b2, 0xe7b7a1, 0xe7b885, 0xe7b88a, 
0xe7b8a3, 0xe7b8a1, 0xe7b892, 0xe7b8b1, 0xe7b89f, 0xe7b889, 0xe7b88b, 0xe7b8a2, 
0xe7b986, 0xe7b9a6, 0xe7b8bb, 0xe7b8b5, 0xe7b8b9, 0xe7b983, 0xe7b8b7, 0xe7b8b2, 
0xe7b8ba, 0xe7b9a7, 0xe7b99d, 0xe7b996, 0xe7b99e, 0xe7b999, 0xe7b99a, 0xe7b9b9, 
0xe7b9aa, 0xe7b9a9, 0xe7b9bc, 0xe7b9bb, 0xe7ba83, 0xe7b795, 0xe7b9bd, 0xe8beae, 
0xe7b9bf, 0xe7ba88, 0xe7ba89, 0xe7ba8c, 0xe7ba92, 0xe7ba90, 0xe7ba93, 0xe7ba94, 
0xe7ba96, 0xe7ba8e, 0xe7ba9b, 0xe7ba9c, 0xe7bcb8, 0xe7bcba, 
	/* 0xe6a1 */
0xe7bd85, 0xe7bd8c, 0xe7bd8d, 0xe7bd8e, 0xe7bd90, 0xe7bd91, 0xe7bd95, 0xe7bd94, 
0xe7bd98, 0xe7bd9f, 0xe7bda0, 0xe7bda8, 0xe7bda9, 0xe7bda7, 0xe7bdb8, 0xe7be82, 
0xe7be86, 0xe7be83, 0xe7be88, 0xe7be87, 0xe7be8c, 0xe7be94, 0xe7be9e, 0xe7be9d, 
0xe7be9a, 0xe7bea3, 0xe7beaf, 0xe7beb2, 0xe7beb9, 0xe7beae, 0xe7beb6, 0xe7beb8, 
0xe8adb1, 0xe7bf85, 0xe7bf86, 0xe7bf8a, 0xe7bf95, 0xe7bf94, 0xe7bfa1, 0xe7bfa6, 
0xe7bfa9, 0xe7bfb3, 0xe7bfb9, 0xe9a39c, 0xe88086, 0xe88084, 0xe8808b, 0xe88092, 
0xe88098, 0xe88099, 0xe8809c, 0xe880a1, 0xe880a8, 0xe880bf, 0xe880bb, 0xe8818a, 
0xe88186, 0xe88192, 0xe88198, 0xe8819a, 0xe8819f, 0xe881a2, 0xe881a8, 0xe881b3, 
0xe881b2, 0xe881b0, 0xe881b6, 0xe881b9, 0xe881bd, 0xe881bf, 0xe88284, 0xe88286, 
0xe88285, 0xe8829b, 0xe88293, 0xe8829a, 0xe882ad, 0xe58690, 0xe882ac, 0xe8839b, 
0xe883a5, 0xe88399, 0xe8839d, 0xe88384, 0xe8839a, 0xe88396, 0xe88489, 0xe883af, 
0xe883b1, 0xe8849b, 0xe884a9, 0xe884a3, 0xe884af, 0xe8858b, 
	/* 0xe7a1 */
0xe99a8b, 0xe88586, 0xe884be, 0xe88593, 0xe88591, 0xe883bc, 0xe885b1, 0xe885ae, 
0xe885a5, 0xe885a6, 0xe885b4, 0xe88683, 0xe88688, 0xe8868a, 0xe88680, 0xe88682, 
0xe886a0, 0xe88695, 0xe886a4, 0xe886a3, 0xe8859f, 0xe88693, 0xe886a9, 0xe886b0, 
0xe886b5, 0xe886be, 0xe886b8, 0xe886bd, 0xe88780, 0xe88782, 0xe886ba, 0xe88789, 
0xe8878d, 0xe88791, 0xe88799, 0xe88798, 0xe88788, 0xe8879a, 0xe8879f, 0xe887a0, 
0xe887a7, 0xe887ba, 0xe887bb, 0xe887be, 0xe88881, 0xe88882, 0xe88885, 0xe88887, 
0xe8888a, 0xe8888d, 0xe88890, 0xe88896, 0xe888a9, 0xe888ab, 0xe888b8, 0xe888b3, 
0xe88980, 0xe88999, 0xe88998, 0xe8899d, 0xe8899a, 0xe8899f, 0xe889a4, 0xe889a2, 
0xe889a8, 0xe889aa, 0xe889ab, 0xe888ae, 0xe889b1, 0xe889b7, 0xe889b8, 0xe889be, 
0xe88a8d, 0xe88a92, 0xe88aab, 0xe88a9f, 0xe88abb, 0xe88aac, 0xe88ba1, 0xe88ba3, 
0xe88b9f, 0xe88b92, 0xe88bb4, 0xe88bb3, 0xe88bba, 0xe88e93, 0xe88c83, 0xe88bbb, 
0xe88bb9, 0xe88b9e, 0xe88c86, 0xe88b9c, 0xe88c89, 0xe88b99, 
	/* 0xe8a1 */
0xe88cb5, 0xe88cb4, 0xe88c96, 0xe88cb2, 0xe88cb1, 0xe88d80, 0xe88cb9, 0xe88d90, 
0xe88d85, 0xe88caf, 0xe88cab, 0xe88c97, 0xe88c98, 0xe88e85, 0xe88e9a, 0xe88eaa, 
0xe88e9f, 0xe88ea2, 0xe88e96, 0xe88ca3, 0xe88e8e, 0xe88e87, 0xe88e8a, 0xe88dbc, 
0xe88eb5, 0xe88db3, 0xe88db5, 0xe88ea0, 0xe88e89, 0xe88ea8, 0xe88fb4, 0xe89093, 
0xe88fab, 0xe88f8e, 0xe88fbd, 0xe89083, 0xe88f98, 0xe8908b, 0xe88f81, 0xe88fb7, 
0xe89087, 0xe88fa0, 0xe88fb2, 0xe8908d, 0xe890a2, 0xe890a0, 0xe88ebd, 0xe890b8, 
0xe89486, 0xe88fbb, 0xe891ad, 0xe890aa, 0xe890bc, 0xe8959a, 0xe89284, 0xe891b7, 
0xe891ab, 0xe892ad, 0xe891ae, 0xe89282, 0xe891a9, 0xe89186, 0xe890ac, 0xe891af, 
0xe891b9, 0xe890b5, 0xe8938a, 0xe891a2, 0xe892b9, 0xe892bf, 0xe8929f, 0xe89399, 
0xe8938d, 0xe892bb, 0xe8939a, 0xe89390, 0xe89381, 0xe89386, 0xe89396, 0xe892a1, 
0xe894a1, 0xe893bf, 0xe893b4, 0xe89497, 0xe89498, 0xe894ac, 0xe8949f, 0xe89495, 
0xe89494, 0xe893bc, 0xe89580, 0xe895a3, 0xe89598, 0xe89588, 
	/* 0xe9a1 */
0xe89581, 0xe89882, 0xe8958b, 0xe89595, 0xe89680, 0xe896a4, 0xe89688, 0xe89691, 
0xe8968a, 0xe896a8, 0xe895ad, 0xe89694, 0xe8969b, 0xe897aa, 0xe89687, 0xe8969c, 
0xe895b7, 0xe895be, 0xe89690, 0xe89789, 0xe896ba, 0xe8978f, 0xe896b9, 0xe89790, 
0xe89795, 0xe8979d, 0xe897a5, 0xe8979c, 0xe897b9, 0xe8988a, 0xe89893, 0xe8988b, 
0xe897be, 0xe897ba, 0xe89886, 0xe898a2, 0xe8989a, 0xe898b0, 0xe898bf, 0xe8998d, 
0xe4b995, 0xe89994, 0xe8999f, 0xe899a7, 0xe899b1, 0xe89a93, 0xe89aa3, 0xe89aa9, 
0xe89aaa, 0xe89a8b, 0xe89a8c, 0xe89ab6, 0xe89aaf, 0xe89b84, 0xe89b86, 0xe89ab0, 
0xe89b89, 0xe8a0a3, 0xe89aab, 0xe89b94, 0xe89b9e, 0xe89ba9, 0xe89bac, 0xe89b9f, 
0xe89b9b, 0xe89baf, 0xe89c92, 0xe89c86, 0xe89c88, 0xe89c80, 0xe89c83, 0xe89bbb, 
0xe89c91, 0xe89c89, 0xe89c8d, 0xe89bb9, 0xe89c8a, 0xe89cb4, 0xe89cbf, 0xe89cb7, 
0xe89cbb, 0xe89ca5, 0xe89ca9, 0xe89c9a, 0xe89da0, 0xe89d9f, 0xe89db8, 0xe89d8c, 
0xe89d8e, 0xe89db4, 0xe89d97, 0xe89da8, 0xe89dae, 0xe89d99, 
	/* 0xeaa1 */
0xe89d93, 0xe89da3, 0xe89daa, 0xe8a085, 0xe89ea2, 0xe89e9f, 0xe89e82, 0xe89eaf, 
0xe89f8b, 0xe89ebd, 0xe89f80, 0xe89f90, 0xe99b96, 0xe89eab, 0xe89f84, 0xe89eb3, 
0xe89f87, 0xe89f86, 0xe89ebb, 0xe89faf, 0xe89fb2, 0xe89fa0, 0xe8a08f, 0xe8a08d, 
0xe89fbe, 0xe89fb6, 0xe89fb7, 0xe8a08e, 0xe89f92, 0xe8a091, 0xe8a096, 0xe8a095, 
0xe8a0a2, 0xe8a0a1, 0xe8a0b1, 0xe8a0b6, 0xe8a0b9, 0xe8a0a7, 0xe8a0bb, 0xe8a184, 
0xe8a182, 0xe8a192, 0xe8a199, 0xe8a19e, 0xe8a1a2, 0xe8a1ab, 0xe8a281, 0xe8a1be, 
0xe8a29e, 0xe8a1b5, 0xe8a1bd, 0xe8a2b5, 0xe8a1b2, 0xe8a282, 0xe8a297, 0xe8a292, 
0xe8a2ae, 0xe8a299, 0xe8a2a2, 0xe8a28d, 0xe8a2a4, 0xe8a2b0, 0xe8a2bf, 0xe8a2b1, 
0xe8a383, 0xe8a384, 0xe8a394, 0xe8a398, 0xe8a399, 0xe8a39d, 0xe8a3b9, 0xe8a482, 
0xe8a3bc, 0xe8a3b4, 0xe8a3a8, 0xe8a3b2, 0xe8a484, 0xe8a48c, 0xe8a48a, 0xe8a493, 
0xe8a583, 0xe8a49e, 0xe8a4a5, 0xe8a4aa, 0xe8a4ab, 0xe8a581, 0xe8a584, 0xe8a4bb, 
0xe8a4b6, 0xe8a4b8, 0xe8a58c, 0xe8a49d, 0xe8a5a0, 0xe8a59e, 
	/* 0xeba1 */
0xe8a5a6, 0xe8a5a4, 0xe8a5ad, 0xe8a5aa, 0xe8a5af, 0xe8a5b4, 0xe8a5b7, 0xe8a5be, 
0xe8a683, 0xe8a688, 0xe8a68a, 0xe8a693, 0xe8a698, 0xe8a6a1, 0xe8a6a9, 0xe8a6a6, 
0xe8a6ac, 0xe8a6af, 0xe8a6b2, 0xe8a6ba, 0xe8a6bd, 0xe8a6bf, 0xe8a780, 0xe8a79a, 
0xe8a79c, 0xe8a79d, 0xe8a7a7, 0xe8a7b4, 0xe8a7b8, 0xe8a883, 0xe8a896, 0xe8a890, 
0xe8a88c, 0xe8a89b, 0xe8a89d, 0xe8a8a5, 0xe8a8b6, 0xe8a981, 0xe8a99b, 0xe8a992, 
0xe8a986, 0xe8a988, 0xe8a9bc, 0xe8a9ad, 0xe8a9ac, 0xe8a9a2, 0xe8aa85, 0xe8aa82, 
0xe8aa84, 0xe8aaa8, 0xe8aaa1, 0xe8aa91, 0xe8aaa5, 0xe8aaa6, 0xe8aa9a, 0xe8aaa3, 
0xe8ab84, 0xe8ab8d, 0xe8ab82, 0xe8ab9a, 0xe8abab, 0xe8abb3, 0xe8aba7, 0xe8aba4, 
0xe8abb1, 0xe8ac94, 0xe8aba0, 0xe8aba2, 0xe8abb7, 0xe8ab9e, 0xe8ab9b, 0xe8ac8c, 
0xe8ac87, 0xe8ac9a, 0xe8aba1, 0xe8ac96, 0xe8ac90, 0xe8ac97, 0xe8aca0, 0xe8acb3, 
0xe99eab, 0xe8aca6, 0xe8acab, 0xe8acbe, 0xe8aca8, 0xe8ad81, 0xe8ad8c, 0xe8ad8f, 
0xe8ad8e, 0xe8ad89, 0xe8ad96, 0xe8ad9b, 0xe8ad9a, 0xe8adab, 
	/* 0xeca1 */
0xe8ad9f, 0xe8adac, 0xe8adaf, 0xe8adb4, 0xe8adbd, 0xe8ae80, 0xe8ae8c, 0xe8ae8e, 
0xe8ae92, 0xe8ae93, 0xe8ae96, 0xe8ae99, 0xe8ae9a, 0xe8b0ba, 0xe8b181, 0xe8b0bf, 
0xe8b188, 0xe8b18c, 0xe8b18e, 0xe8b190, 0xe8b195, 0xe8b1a2, 0xe8b1ac, 0xe8b1b8, 
0xe8b1ba, 0xe8b282, 0xe8b289, 0xe8b285, 0xe8b28a, 0xe8b28d, 0xe8b28e, 0xe8b294, 
0xe8b1bc, 0xe8b298, 0xe6889d, 0xe8b2ad, 0xe8b2aa, 0xe8b2bd, 0xe8b2b2, 0xe8b2b3, 
0xe8b2ae, 0xe8b2b6, 0xe8b388, 0xe8b381, 0xe8b3a4, 0xe8b3a3, 0xe8b39a, 0xe8b3bd, 
0xe8b3ba, 0xe8b3bb, 0xe8b484, 0xe8b485, 0xe8b48a, 0xe8b487, 0xe8b48f, 0xe8b48d, 
0xe8b490, 0xe9bd8e, 0xe8b493, 0xe8b38d, 0xe8b494, 0xe8b496, 0xe8b5a7, 0xe8b5ad, 
0xe8b5b1, 0xe8b5b3, 0xe8b681, 0xe8b699, 0xe8b782, 0xe8b6be, 0xe8b6ba, 0xe8b78f, 
0xe8b79a, 0xe8b796, 0xe8b78c, 0xe8b79b, 0xe8b78b, 0xe8b7aa, 0xe8b7ab, 0xe8b79f, 
0xe8b7a3, 0xe8b7bc, 0xe8b888, 0xe8b889, 0xe8b7bf, 0xe8b89d, 0xe8b89e, 0xe8b890, 
0xe8b89f, 0xe8b982, 0xe8b8b5, 0xe8b8b0, 0xe8b8b4, 0xe8b98a, 
	/* 0xeda1 */
0xe8b987, 0xe8b989, 0xe8b98c, 0xe8b990, 0xe8b988, 0xe8b999, 0xe8b9a4, 0xe8b9a0, 
0xe8b8aa, 0xe8b9a3, 0xe8b995, 0xe8b9b6, 0xe8b9b2, 0xe8b9bc, 0xe8ba81, 0xe8ba87, 
0xe8ba85, 0xe8ba84, 0xe8ba8b, 0xe8ba8a, 0xe8ba93, 0xe8ba91, 0xe8ba94, 0xe8ba99, 
0xe8baaa, 0xe8baa1, 0xe8baac, 0xe8bab0, 0xe8bb86, 0xe8bab1, 0xe8babe, 0xe8bb85, 
0xe8bb88, 0xe8bb8b, 0xe8bb9b, 0xe8bba3, 0xe8bbbc, 0xe8bbbb, 0xe8bbab, 0xe8bbbe, 
0xe8bc8a, 0xe8bc85, 0xe8bc95, 0xe8bc92, 0xe8bc99, 0xe8bc93, 0xe8bc9c, 0xe8bc9f, 
0xe8bc9b, 0xe8bc8c, 0xe8bca6, 0xe8bcb3, 0xe8bcbb, 0xe8bcb9, 0xe8bd85, 0xe8bd82, 
0xe8bcbe, 0xe8bd8c, 0xe8bd89, 0xe8bd86, 0xe8bd8e, 0xe8bd97, 0xe8bd9c, 0xe8bda2, 
0xe8bda3, 0xe8bda4, 0xe8be9c, 0xe8be9f, 0xe8bea3, 0xe8bead, 0xe8beaf, 0xe8beb7, 
0xe8bf9a, 0xe8bfa5, 0xe8bfa2, 0xe8bfaa, 0xe8bfaf, 0xe98287, 0xe8bfb4, 0xe98085, 
0xe8bfb9, 0xe8bfba, 0xe98091, 0xe98095, 0xe980a1, 0xe9808d, 0xe9809e, 0xe98096, 
0xe9808b, 0xe980a7, 0xe980b6, 0xe980b5, 0xe980b9, 0xe8bfb8, 
	/* 0xeea1 */
0xe9818f, 0xe98190, 0xe98191, 0xe98192, 0xe9808e, 0xe98189, 0xe980be, 0xe98196, 
0xe98198, 0xe9819e, 0xe981a8, 0xe981af, 0xe981b6, 0xe99aa8, 0xe981b2, 0xe98282, 
0xe981bd, 0xe98281, 0xe98280, 0xe9828a, 0xe98289, 0xe9828f, 0xe982a8, 0xe982af, 
0xe982b1, 0xe982b5, 0xe983a2, 0xe983a4, 0xe68988, 0xe9839b, 0xe98482, 0xe98492, 
0xe98499, 0xe984b2, 0xe984b0, 0xe9858a, 0xe98596, 0xe98598, 0xe985a3, 0xe985a5, 
0xe985a9, 0xe985b3, 0xe985b2, 0xe9868b, 0xe98689, 0xe98682, 0xe986a2, 0xe986ab, 
0xe986af, 0xe986aa, 0xe986b5, 0xe986b4, 0xe986ba, 0xe98780, 0xe98781, 0xe98789, 
0xe9878b, 0xe98790, 0xe98796, 0xe9879f, 0xe987a1, 0xe9879b, 0xe987bc, 0xe987b5, 
0xe987b6, 0xe9889e, 0xe987bf, 0xe98894, 0xe988ac, 0xe98895, 0xe98891, 0xe9899e, 
0xe98997, 0xe98985, 0xe98989, 0xe989a4, 0xe98988, 0xe98a95, 0xe988bf, 0xe9898b, 
0xe98990, 0xe98a9c, 0xe98a96, 0xe98a93, 0xe98a9b, 0xe9899a, 0xe98b8f, 0xe98ab9, 
0xe98ab7, 0xe98ba9, 0xe98c8f, 0xe98bba, 0xe98d84, 0xe98cae, 
	/* 0xefa1 */
0xe98c99, 0xe98ca2, 0xe98c9a, 0xe98ca3, 0xe98cba, 0xe98cb5, 0xe98cbb, 0xe98d9c, 
0xe98da0, 0xe98dbc, 0xe98dae, 0xe98d96, 0xe98eb0, 0xe98eac, 0xe98ead, 0xe98e94, 
0xe98eb9, 0xe98f96, 0xe98f97, 0xe98fa8, 0xe98fa5, 0xe98f98, 0xe98f83, 0xe98f9d, 
0xe98f90, 0xe98f88, 0xe98fa4, 0xe9909a, 0xe99094, 0xe99093, 0xe99083, 0xe99087, 
0xe99090, 0xe990b6, 0xe990ab, 0xe990b5, 0xe990a1, 0xe990ba, 0xe99181, 0xe99192, 
0xe99184, 0xe9919b, 0xe991a0, 0xe991a2, 0xe9919e, 0xe991aa, 0xe988a9, 0xe991b0, 
0xe991b5, 0xe991b7, 0xe991bd, 0xe9919a, 0xe991bc, 0xe991be, 0xe99281, 0xe991bf, 
0xe99682, 0xe99687, 0xe9968a, 0xe99694, 0xe99696, 0xe99698, 0xe99699, 0xe996a0, 
0xe996a8, 0xe996a7, 0xe996ad, 0xe996bc, 0xe996bb, 0xe996b9, 0xe996be, 0xe9978a, 
0xe6bfb6, 0xe99783, 0xe9978d, 0xe9978c, 0xe99795, 0xe99794, 0xe99796, 0xe9979c, 
0xe997a1, 0xe997a5, 0xe997a2, 0xe998a1, 0xe998a8, 0xe998ae, 0xe998af, 0xe99982, 
0xe9998c, 0xe9998f, 0xe9998b, 0xe999b7, 0xe9999c, 0xe9999e, 
	/* 0xf0a1 */
0xe9999d, 0xe9999f, 0xe999a6, 0xe999b2, 0xe999ac, 0xe99a8d, 0xe99a98, 0xe99a95, 
0xe99a97, 0xe99aaa, 0xe99aa7, 0xe99ab1, 0xe99ab2, 0xe99ab0, 0xe99ab4, 0xe99ab6, 
0xe99ab8, 0xe99ab9, 0xe99b8e, 0xe99b8b, 0xe99b89, 0xe99b8d, 0xe8a58d, 0xe99b9c, 
0xe99c8d, 0xe99b95, 0xe99bb9, 0xe99c84, 0xe99c86, 0xe99c88, 0xe99c93, 0xe99c8e, 
0xe99c91, 0xe99c8f, 0xe99c96, 0xe99c99, 0xe99ca4, 0xe99caa, 0xe99cb0, 0xe99cb9, 
0xe99cbd, 0xe99cbe, 0xe99d84, 0xe99d86, 0xe99d88, 0xe99d82, 0xe99d89, 0xe99d9c, 
0xe99da0, 0xe99da4, 0xe99da6, 0xe99da8, 0xe58b92, 0xe99dab, 0xe99db1, 0xe99db9, 
0xe99e85, 0xe99dbc, 0xe99e81, 0xe99dba, 0xe99e86, 0xe99e8b, 0xe99e8f, 0xe99e90, 
0xe99e9c, 0xe99ea8, 0xe99ea6, 0xe99ea3, 0xe99eb3, 0xe99eb4, 0xe99f83, 0xe99f86, 
0xe99f88, 0xe99f8b, 0xe99f9c, 0xe99fad, 0xe9bd8f, 0xe99fb2, 0xe7ab9f, 0xe99fb6, 
0xe99fb5, 0xe9a08f, 0xe9a08c, 0xe9a0b8, 0xe9a0a4, 0xe9a0a1, 0xe9a0b7, 0xe9a0bd, 
0xe9a186, 0xe9a18f, 0xe9a18b, 0xe9a1ab, 0xe9a1af, 0xe9a1b0, 
	/* 0xf1a1 */
0xe9a1b1, 0xe9a1b4, 0xe9a1b3, 0xe9a2aa, 0xe9a2af, 0xe9a2b1, 0xe9a2b6, 0xe9a384, 
0xe9a383, 0xe9a386, 0xe9a3a9, 0xe9a3ab, 0xe9a483, 0xe9a489, 0xe9a492, 0xe9a494, 
0xe9a498, 0xe9a4a1, 0xe9a49d, 0xe9a49e, 0xe9a4a4, 0xe9a4a0, 0xe9a4ac, 0xe9a4ae, 
0xe9a4bd, 0xe9a4be, 0xe9a582, 0xe9a589, 0xe9a585, 0xe9a590, 0xe9a58b, 0xe9a591, 
0xe9a592, 0xe9a58c, 0xe9a595, 0xe9a697, 0xe9a698, 0xe9a6a5, 0xe9a6ad, 0xe9a6ae, 
0xe9a6bc, 0xe9a79f, 0xe9a79b, 0xe9a79d, 0xe9a798, 0xe9a791, 0xe9a7ad, 0xe9a7ae, 
0xe9a7b1, 0xe9a7b2, 0xe9a7bb, 0xe9a7b8, 0xe9a881, 0xe9a88f, 0xe9a885, 0xe9a7a2, 
0xe9a899, 0xe9a8ab, 0xe9a8b7, 0xe9a985, 0xe9a982, 0xe9a980, 0xe9a983, 0xe9a8be, 
0xe9a995, 0xe9a98d, 0xe9a99b, 0xe9a997, 0xe9a99f, 0xe9a9a2, 0xe9a9a5, 0xe9a9a4, 
0xe9a9a9, 0xe9a9ab, 0xe9a9aa, 0xe9aaad, 0xe9aab0, 0xe9aabc, 0xe9ab80, 0xe9ab8f, 
0xe9ab91, 0xe9ab93, 0xe9ab94, 0xe9ab9e, 0xe9ab9f, 0xe9aba2, 0xe9aba3, 0xe9aba6, 
0xe9abaf, 0xe9abab, 0xe9abae, 0xe9abb4, 0xe9abb1, 0xe9abb7, 
	/* 0xf2a1 */
0xe9abbb, 0xe9ac86, 0xe9ac98, 0xe9ac9a, 0xe9ac9f, 0xe9aca2, 0xe9aca3, 0xe9aca5, 
0xe9aca7, 0xe9aca8, 0xe9aca9, 0xe9acaa, 0xe9acae, 0xe9acaf, 0xe9acb2, 0xe9ad84, 
0xe9ad83, 0xe9ad8f, 0xe9ad8d, 0xe9ad8e, 0xe9ad91, 0xe9ad98, 0xe9adb4, 0xe9ae93, 
0xe9ae83, 0xe9ae91, 0xe9ae96, 0xe9ae97, 0xe9ae9f, 0xe9aea0, 0xe9aea8, 0xe9aeb4, 
0xe9af80, 0xe9af8a, 0xe9aeb9, 0xe9af86, 0xe9af8f, 0xe9af91, 0xe9af92, 0xe9afa3, 
0xe9afa2, 0xe9afa4, 0xe9af94, 0xe9afa1, 0xe9b0ba, 0xe9afb2, 0xe9afb1, 0xe9afb0, 
0xe9b095, 0xe9b094, 0xe9b089, 0xe9b093, 0xe9b08c, 0xe9b086, 0xe9b088, 0xe9b092, 
0xe9b08a, 0xe9b084, 0xe9b0ae, 0xe9b09b, 0xe9b0a5, 0xe9b0a4, 0xe9b0a1, 0xe9b0b0, 
0xe9b187, 0xe9b0b2, 0xe9b186, 0xe9b0be, 0xe9b19a, 0xe9b1a0, 0xe9b1a7, 0xe9b1b6, 
0xe9b1b8, 0xe9b3a7, 0xe9b3ac, 0xe9b3b0, 0xe9b489, 0xe9b488, 0xe9b3ab, 0xe9b483, 
0xe9b486, 0xe9b4aa, 0xe9b4a6, 0xe9b6af, 0xe9b4a3, 0xe9b49f, 0xe9b584, 0xe9b495, 
0xe9b492, 0xe9b581, 0xe9b4bf, 0xe9b4be, 0xe9b586, 0xe9b588, 
	/* 0xf3a1 */
0xe9b59d, 0xe9b59e, 0xe9b5a4, 0xe9b591, 0xe9b590, 0xe9b599, 0xe9b5b2, 0xe9b689, 
0xe9b687, 0xe9b6ab, 0xe9b5af, 0xe9b5ba, 0xe9b69a, 0xe9b6a4, 0xe9b6a9, 0xe9b6b2, 
0xe9b784, 0xe9b781, 0xe9b6bb, 0xe9b6b8, 0xe9b6ba, 0xe9b786, 0xe9b78f, 0xe9b782, 
0xe9b799, 0xe9b793, 0xe9b7b8, 0xe9b7a6, 0xe9b7ad, 0xe9b7af, 0xe9b7bd, 0xe9b89a, 
0xe9b89b, 0xe9b89e, 0xe9b9b5, 0xe9b9b9, 0xe9b9bd, 0xe9ba81, 0xe9ba88, 0xe9ba8b, 
0xe9ba8c, 0xe9ba92, 0xe9ba95, 0xe9ba91, 0xe9ba9d, 0xe9baa5, 0xe9baa9, 0xe9bab8, 
0xe9baaa, 0xe9baad, 0xe99da1, 0xe9bb8c, 0xe9bb8e, 0xe9bb8f, 0xe9bb90, 0xe9bb94, 
0xe9bb9c, 0xe9bb9e, 0xe9bb9d, 0xe9bba0, 0xe9bba5, 0xe9bba8, 0xe9bbaf, 0xe9bbb4, 
0xe9bbb6, 0xe9bbb7, 0xe9bbb9, 0xe9bbbb, 0xe9bbbc, 0xe9bbbd, 0xe9bc87, 0xe9bc88, 
0xe79ab7, 0xe9bc95, 0xe9bca1, 0xe9bcac, 0xe9bcbe, 0xe9bd8a, 0xe9bd92, 0xe9bd94, 
0xe9bda3, 0xe9bd9f, 0xe9bda0, 0xe9bda1, 0xe9bda6, 0xe9bda7, 0xe9bdac, 0xe9bdaa, 
0xe9bdb7, 0xe9bdb2, 0xe9bdb6, 0xe9be95, 0xe9be9c, 0xe9bea0, 
	/* 0xf4a1 */
0xe5a0af, 0xe6a787, 0xe98199, 0xe791a4, 0xe5879c, 0xe78699
};

static const unsigned long eucjp3_utf8[] = {
	/* 0x8fa2a1 */
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x00cb98, 0x00cb87, 
0x00c2b8, 0x00cb99, 0x00cb9d, 0x00c2af, 0x00cb9b, 0x00cb9a, 0x000000, 0x00ce84, 
0x00ce85, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x00c2a1, 0x00c2a6, 0x00c2bf, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x00c2ba, 0x00c2aa, 0x00c2a9, 0x00c2ae, 0xe284a2, 0x00c2a4, 
0xe28496, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0x8fa3a1 */
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0x8fa4a1 */
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0x8fa5a1 */
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0x8fa6a1 */
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x00ce86, 0x00ce88, 0x00ce89, 0x00ce8a, 0x00ceaa, 0x000000, 0x00ce8c, 0x000000, 
0x00ce8e, 0x00ceab, 0x000000, 0x00ce8f, 0x000000, 0x000000, 0x000000, 0x000000, 
0x00ceac, 0x00cead, 0x00ceae, 0x00ceaf, 0x00cf8a, 0x00ce90, 0x00cf8c, 0x00cf82, 
0x00cf8d, 0x00cf8b, 0x00ceb0, 0x00cf8e, 0x000000, 0x000000, 
	/* 0x8fa7a1 */
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x00d082, 0x00d083, 0x00d084, 0x00d085, 0x00d086, 0x00d087, 0x00d088, 
0x00d089, 0x00d08a, 0x00d08b, 0x00d08c, 0x00d08e, 0x00d08f, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x00d192, 0x00d193, 0x00d194, 0x00d195, 0x00d196, 0x00d197, 0x00d198, 
0x00d199, 0x00d19a, 0x00d19b, 0x00d19c, 0x00d19e, 0x00d19f, 
	/* 0x8fa8a1 */
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0x8fa9a1 */
0x00c386, 0x00c490, 0x000000, 0x00c4a6, 0x000000, 0x00c4b2, 0x000000, 0x00c581, 
0x00c4bf, 0x000000, 0x00c58a, 0x00c398, 0x00c592, 0x000000, 0x00c5a6, 0x00c39e, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x00c3a6, 0x00c491, 0x00c3b0, 0x00c4a7, 0x00c4b1, 0x00c4b3, 0x00c4b8, 0x00c582, 
0x00c580, 0x00c589, 0x00c58b, 0x00c3b8, 0x00c593, 0x00c39f, 0x00c5a7, 0x00c3be, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0x8faaa1 */
0x00c381, 0x00c380, 0x00c384, 0x00c382, 0x00c482, 0x00c78d, 0x00c480, 0x00c484, 
0x00c385, 0x00c383, 0x00c486, 0x00c488, 0x00c48c, 0x00c387, 0x00c48a, 0x00c48e, 
0x00c389, 0x00c388, 0x00c38b, 0x00c38a, 0x00c49a, 0x00c496, 0x00c492, 0x00c498, 
0x000000, 0x00c49c, 0x00c49e, 0x00c4a2, 0x00c4a0, 0x00c4a4, 0x00c38d, 0x00c38c, 
0x00c38f, 0x00c38e, 0x00c78f, 0x00c4b0, 0x00c4aa, 0x00c4ae, 0x00c4a8, 0x00c4b4, 
0x00c4b6, 0x00c4b9, 0x00c4bd, 0x00c4bb, 0x00c583, 0x00c587, 0x00c585, 0x00c391, 
0x00c393, 0x00c392, 0x00c396, 0x00c394, 0x00c791, 0x00c590, 0x00c58c, 0x00c395, 
0x00c594, 0x00c598, 0x00c596, 0x00c59a, 0x00c59c, 0x00c5a0, 0x00c59e, 0x00c5a4, 
0x00c5a2, 0x00c39a, 0x00c399, 0x00c39c, 0x00c39b, 0x00c5ac, 0x00c793, 0x00c5b0, 
0x00c5aa, 0x00c5b2, 0x00c5ae, 0x00c5a8, 0x00c797, 0x00c79b, 0x00c799, 0x00c795, 
0x00c5b4, 0x00c39d, 0x00c5b8, 0x00c5b6, 0x00c5b9, 0x00c5bd, 0x00c5bb, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0x8faba1 */
0x00c3a1, 0x00c3a0, 0x00c3a4, 0x00c3a2, 0x00c483, 0x00c78e, 0x00c481, 0x00c485, 
0x00c3a5, 0x00c3a3, 0x00c487, 0x00c489, 0x00c48d, 0x00c3a7, 0x00c48b, 0x00c48f, 
0x00c3a9, 0x00c3a8, 0x00c3ab, 0x00c3aa, 0x00c49b, 0x00c497, 0x00c493, 0x00c499, 
0x00c7b5, 0x00c49d, 0x00c49f, 0x000000, 0x00c4a1, 0x00c4a5, 0x00c3ad, 0x00c3ac, 
0x00c3af, 0x00c3ae, 0x00c790, 0x000000, 0x00c4ab, 0x00c4af, 0x00c4a9, 0x00c4b5, 
0x00c4b7, 0x00c4ba, 0x00c4be, 0x00c4bc, 0x00c584, 0x00c588, 0x00c586, 0x00c3b1, 
0x00c3b3, 0x00c3b2, 0x00c3b6, 0x00c3b4, 0x00c792, 0x00c591, 0x00c58d, 0x00c3b5, 
0x00c595, 0x00c599, 0x00c597, 0x00c59b, 0x00c59d, 0x00c5a1, 0x00c59f, 0x00c5a5, 
0x00c5a3, 0x00c3ba, 0x00c3b9, 0x00c3bc, 0x00c3bb, 0x00c5ad, 0x00c794, 0x00c5b1, 
0x00c5ab, 0x00c5b3, 0x00c5af, 0x00c5a9, 0x00c798, 0x00c79c, 0x00c79a, 0x00c796, 
0x00c5b5, 0x00c3bd, 0x00c3bf, 0x00c5b7, 0x00c5ba, 0x00c5be, 0x00c5bc, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0x8faca1 */
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0x8fada1 */
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0x8faea1 */
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0x8fafa1 */
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 
	/* 0x8fb0a1 */
0xe4b882, 0xe4b884, 0xe4b885, 0xe4b88c, 0xe4b892, 0xe4b89f, 0xe4b8a3, 0xe4b8a4, 
0xe4b8a8, 0xe4b8ab, 0xe4b8ae, 0xe4b8af, 0xe4b8b0, 0xe4b8b5, 0xe4b980, 0xe4b981, 
0xe4b984, 0xe4b987, 0xe4b991, 0xe4b99a, 0xe4b99c, 0xe4b9a3, 0xe4b9a8, 0xe4b9a9, 
0xe4b9b4, 0xe4b9b5, 0xe4b9b9, 0xe4b9bf, 0xe4ba8d, 0xe4ba96, 0xe4ba97, 0xe4ba9d, 
0xe4baaf, 0xe4bab9, 0xe4bb83, 0xe4bb90, 0xe4bb9a, 0xe4bb9b, 0xe4bba0, 0xe4bba1, 
0xe4bba2, 0xe4bba8, 0xe4bbaf, 0xe4bbb1, 0xe4bbb3, 0xe4bbb5, 0xe4bbbd, 0xe4bbbe, 
0xe4bbbf, 0xe4bc80, 0xe4bc82, 0xe4bc83, 0xe4bc88, 0xe4bc8b, 0xe4bc8c, 0xe4bc92, 
0xe4bc95, 0xe4bc96, 0xe4bc97, 0xe4bc99, 0xe4bcae, 0xe4bcb1, 0xe4bda0, 0xe4bcb3, 
0xe4bcb5, 0xe4bcb7, 0xe4bcb9, 0xe4bcbb, 0xe4bcbe, 0xe4bd80, 0xe4bd82, 0xe4bd88, 
0xe4bd89, 0xe4bd8b, 0xe4bd8c, 0xe4bd92, 0xe4bd94, 0xe4bd96, 0xe4bd98, 0xe4bd9f, 
0xe4bda3, 0xe4bdaa, 0xe4bdac, 0xe4bdae, 0xe4bdb1, 0xe4bdb7, 0xe4bdb8, 0xe4bdb9, 
0xe4bdba, 0xe4bdbd, 0xe4bdbe, 0xe4be81, 0xe4be82, 0xe4be84, 
	/* 0x8fb1a1 */
0xe4be85, 0xe4be89, 0xe4be8a, 0xe4be8c, 0xe4be8e, 0xe4be90, 0xe4be92, 0xe4be93, 
0xe4be94, 0xe4be97, 0xe4be99, 0xe4be9a, 0xe4be9e, 0xe4be9f, 0xe4beb2, 0xe4beb7, 
0xe4beb9, 0xe4bebb, 0xe4bebc, 0xe4bebd, 0xe4bebe, 0xe4bf80, 0xe4bf81, 0xe4bf85, 
0xe4bf86, 0xe4bf88, 0xe4bf89, 0xe4bf8b, 0xe4bf8c, 0xe4bf8d, 0xe4bf8f, 0xe4bf92, 
0xe4bf9c, 0xe4bfa0, 0xe4bfa2, 0xe4bfb0, 0xe4bfb2, 0xe4bfbc, 0xe4bfbd, 0xe4bfbf, 
0xe58080, 0xe58081, 0xe58084, 0xe58087, 0xe5808a, 0xe5808c, 0xe5808e, 0xe58090, 
0xe58093, 0xe58097, 0xe58098, 0xe5809b, 0xe5809c, 0xe5809d, 0xe5809e, 0xe580a2, 
0xe580a7, 0xe580ae, 0xe580b0, 0xe580b2, 0xe580b3, 0xe580b5, 0xe58180, 0xe58181, 
0xe58182, 0xe58185, 0xe58186, 0xe5818a, 0xe5818c, 0xe5818e, 0xe58191, 0xe58192, 
0xe58193, 0xe58197, 0xe58199, 0xe5819f, 0xe581a0, 0xe581a2, 0xe581a3, 0xe581a6, 
0xe581a7, 0xe581aa, 0xe581ad, 0xe581b0, 0xe581b1, 0xe580bb, 0xe58281, 0xe58283, 
0xe58284, 0xe58286, 0xe5828a, 0xe5828e, 0xe5828f, 0xe58290, 
	/* 0x8fb2a1 */
0xe58292, 0xe58293, 0xe58294, 0xe58296, 0xe5829b, 0xe5829c, 0xe5829e, 0xe5829f, 
0xe582a0, 0xe582a1, 0xe582a2, 0xe582aa, 0xe582af, 0xe582b0, 0xe582b9, 0xe582ba, 
0xe582bd, 0xe58380, 0xe58383, 0xe58384, 0xe58387, 0xe5838c, 0xe5838e, 0xe58390, 
0xe58393, 0xe58394, 0xe58398, 0xe5839c, 0xe5839d, 0xe5839f, 0xe583a2, 0xe583a4, 
0xe583a6, 0xe583a8, 0xe583a9, 0xe583af, 0xe583b1, 0xe583b6, 0xe583ba, 0xe583be, 
0xe58483, 0xe58486, 0xe58487, 0xe58488, 0xe5848b, 0xe5848c, 0xe5848d, 0xe5848e, 
0xe583b2, 0xe58490, 0xe58497, 0xe58499, 0xe5849b, 0xe5849c, 0xe5849d, 0xe5849e, 
0xe584a3, 0xe584a7, 0xe584a8, 0xe584ac, 0xe584ad, 0xe584af, 0xe584b1, 0xe584b3, 
0xe584b4, 0xe584b5, 0xe584b8, 0xe584b9, 0xe58582, 0xe5858a, 0xe5858f, 0xe58593, 
0xe58595, 0xe58597, 0xe58598, 0xe5859f, 0xe585a4, 0xe585a6, 0xe585be, 0xe58683, 
0xe58684, 0xe5868b, 0xe5868e, 0xe58698, 0xe5869d, 0xe586a1, 0xe586a3, 0xe586ad, 
0xe586b8, 0xe586ba, 0xe586bc, 0xe586be, 0xe586bf, 0xe58782, 
	/* 0x8fb3a1 */
0xe58788, 0xe5878f, 0xe58791, 0xe58792, 0xe58793, 0xe58795, 0xe58798, 0xe5879e, 
0xe587a2, 0xe587a5, 0xe587ae, 0xe587b2, 0xe587b3, 0xe587b4, 0xe587b7, 0xe58881, 
0xe58882, 0xe58885, 0xe58892, 0xe58893, 0xe58895, 0xe58896, 0xe58898, 0xe588a2, 
0xe588a8, 0xe588b1, 0xe588b2, 0xe588b5, 0xe588bc, 0xe58985, 0xe58989, 0xe58995, 
0xe58997, 0xe58998, 0xe5899a, 0xe5899c, 0xe5899f, 0xe589a0, 0xe589a1, 0xe589a6, 
0xe589ae, 0xe589b7, 0xe589b8, 0xe589b9, 0xe58a80, 0xe58a82, 0xe58a85, 0xe58a8a, 
0xe58a8c, 0xe58a93, 0xe58a95, 0xe58a96, 0xe58a97, 0xe58a98, 0xe58a9a, 0xe58a9c, 
0xe58aa4, 0xe58aa5, 0xe58aa6, 0xe58aa7, 0xe58aaf, 0xe58ab0, 0xe58ab6, 0xe58ab7, 
0xe58ab8, 0xe58aba, 0xe58abb, 0xe58abd, 0xe58b80, 0xe58b84, 0xe58b86, 0xe58b88, 
0xe58b8c, 0xe58b8f, 0xe58b91, 0xe58b94, 0xe58b96, 0xe58b9b, 0xe58b9c, 0xe58ba1, 
0xe58ba5, 0xe58ba8, 0xe58ba9, 0xe58baa, 0xe58bac, 0xe58bb0, 0xe58bb1, 0xe58bb4, 
0xe58bb6, 0xe58bb7, 0xe58c80, 0xe58c83, 0xe58c8a, 0xe58c8b, 
	/* 0x8fb4a1 */
0xe58c8c, 0xe58c91, 0xe58c93, 0xe58c98, 0xe58c9b, 0xe58c9c, 0xe58c9e, 0xe58c9f, 
0xe58ca5, 0xe58ca7, 0xe58ca8, 0xe58ca9, 0xe58cab, 0xe58cac, 0xe58cad, 0xe58cb0, 
0xe58cb2, 0xe58cb5, 0xe58cbc, 0xe58cbd, 0xe58cbe, 0xe58d82, 0xe58d8c, 0xe58d8b, 
0xe58d99, 0xe58d9b, 0xe58da1, 0xe58da3, 0xe58da5, 0xe58dac, 0xe58dad, 0xe58db2, 
0xe58db9, 0xe58dbe, 0xe58e83, 0xe58e87, 0xe58e88, 0xe58e8e, 0xe58e93, 0xe58e94, 
0xe58e99, 0xe58e9d, 0xe58ea1, 0xe58ea4, 0xe58eaa, 0xe58eab, 0xe58eaf, 0xe58eb2, 
0xe58eb4, 0xe58eb5, 0xe58eb7, 0xe58eb8, 0xe58eba, 0xe58ebd, 0xe58f80, 0xe58f85, 
0xe58f8f, 0xe58f92, 0xe58f93, 0xe58f95, 0xe58f9a, 0xe58f9d, 0xe58f9e, 0xe58fa0, 
0xe58fa6, 0xe58fa7, 0xe58fb5, 0xe59082, 0xe59093, 0xe5909a, 0xe590a1, 0xe590a7, 
0xe590a8, 0xe590aa, 0xe590af, 0xe590b1, 0xe590b4, 0xe590b5, 0xe59183, 0xe59184, 
0xe59187, 0xe5918d, 0xe5918f, 0xe5919e, 0xe591a2, 0xe591a4, 0xe591a6, 0xe591a7, 
0xe591a9, 0xe591ab, 0xe591ad, 0xe591ae, 0xe591b4, 0xe591bf, 
	/* 0x8fb5a1 */
0xe59281, 0xe59283, 0xe59285, 0xe59288, 0xe59289, 0xe5928d, 0xe59291, 0xe59295, 
0xe59296, 0xe5929c, 0xe5929f, 0xe592a1, 0xe592a6, 0xe592a7, 0xe592a9, 0xe592aa, 
0xe592ad, 0xe592ae, 0xe592b1, 0xe592b7, 0xe592b9, 0xe592ba, 0xe592bb, 0xe592bf, 
0xe59386, 0xe5938a, 0xe5938d, 0xe5938e, 0xe593a0, 0xe593aa, 0xe593ac, 0xe593af, 
0xe593b6, 0xe593bc, 0xe593be, 0xe593bf, 0xe59480, 0xe59481, 0xe59485, 0xe59488, 
0xe59489, 0xe5948c, 0xe5948d, 0xe5948e, 0xe59495, 0xe594aa, 0xe594ab, 0xe594b2, 
0xe594b5, 0xe594b6, 0xe594bb, 0xe594bc, 0xe594bd, 0xe59581, 0xe59587, 0xe59589, 
0xe5958a, 0xe5958d, 0xe59590, 0xe59591, 0xe59598, 0xe5959a, 0xe5959b, 0xe5959e, 
0xe595a0, 0xe595a1, 0xe595a4, 0xe595a6, 0xe595bf, 0xe59681, 0xe59682, 0xe59686, 
0xe59688, 0xe5968e, 0xe5968f, 0xe59691, 0xe59692, 0xe59693, 0xe59694, 0xe59697, 
0xe596a3, 0xe596a4, 0xe596ad, 0xe596b2, 0xe596bf, 0xe59781, 0xe59783, 0xe59786, 
0xe59789, 0xe5978b, 0xe5978c, 0xe5978e, 0xe59791, 0xe59792, 
	/* 0x8fb6a1 */
0xe59793, 0xe59797, 0xe59798, 0xe5979b, 0xe5979e, 0xe597a2, 0xe597a9, 0xe597b6, 
0xe597bf, 0xe59885, 0xe59888, 0xe5988a, 0xe5988d, 0xe5988e, 0xe5988f, 0xe59890, 
0xe59891, 0xe59892, 0xe59899, 0xe598ac, 0xe598b0, 0xe598b3, 0xe598b5, 0xe598b7, 
0xe598b9, 0xe598bb, 0xe598bc, 0xe598bd, 0xe598bf, 0xe59980, 0xe59981, 0xe59983, 
0xe59984, 0xe59986, 0xe59989, 0xe5998b, 0xe5998d, 0xe5998f, 0xe59994, 0xe5999e, 
0xe599a0, 0xe599a1, 0xe599a2, 0xe599a3, 0xe599a6, 0xe599a9, 0xe599ad, 0xe599af, 
0xe599b1, 0xe599b2, 0xe599b5, 0xe59a84, 0xe59a85, 0xe59a88, 0xe59a8b, 0xe59a8c, 
0xe59a95, 0xe59a99, 0xe59a9a, 0xe59a9d, 0xe59a9e, 0xe59a9f, 0xe59aa6, 0xe59aa7, 
0xe59aa8, 0xe59aa9, 0xe59aab, 0xe59aac, 0xe59aad, 0xe59ab1, 0xe59ab3, 0xe59ab7, 
0xe59abe, 0xe59b85, 0xe59b89, 0xe59b8a, 0xe59b8b, 0xe59b8f, 0xe59b90, 0xe59b8c, 
0xe59b8d, 0xe59b99, 0xe59b9c, 0xe59b9d, 0xe59b9f, 0xe59ba1, 0xe59ba4, 0xe59ba5, 
0xe59ba6, 0xe59ba7, 0xe59ba8, 0xe59bb1, 0xe59bab, 0xe59bad, 
	/* 0x8fb7a1 */
0xe59bb6, 0xe59bb7, 0xe59c81, 0xe59c82, 0xe59c87, 0xe59c8a, 0xe59c8c, 0xe59c91, 
0xe59c95, 0xe59c9a, 0xe59c9b, 0xe59c9d, 0xe59ca0, 0xe59ca2, 0xe59ca3, 0xe59ca4, 
0xe59ca5, 0xe59ca9, 0xe59caa, 0xe59cac, 0xe59cae, 0xe59caf, 0xe59cb3, 0xe59cb4, 
0xe59cbd, 0xe59cbe, 0xe59cbf, 0xe59d85, 0xe59d86, 0xe59d8c, 0xe59d8d, 0xe59d92, 
0xe59da2, 0xe59da5, 0xe59da7, 0xe59da8, 0xe59dab, 0xe59dad, 0xe59dae, 0xe59daf, 
0xe59db0, 0xe59db1, 0xe59db3, 0xe59db4, 0xe59db5, 0xe59db7, 0xe59db9, 0xe59dba, 
0xe59dbb, 0xe59dbc, 0xe59dbe, 0xe59e81, 0xe59e83, 0xe59e8c, 0xe59e94, 0xe59e97, 
0xe59e99, 0xe59e9a, 0xe59e9c, 0xe59e9d, 0xe59e9e, 0xe59e9f, 0xe59ea1, 0xe59e95, 
0xe59ea7, 0xe59ea8, 0xe59ea9, 0xe59eac, 0xe59eb8, 0xe59ebd, 0xe59f87, 0xe59f88, 
0xe59f8c, 0xe59f8f, 0xe59f95, 0xe59f9d, 0xe59f9e, 0xe59fa4, 0xe59fa6, 0xe59fa7, 
0xe59fa9, 0xe59fad, 0xe59fb0, 0xe59fb5, 0xe59fb6, 0xe59fb8, 0xe59fbd, 0xe59fbe, 
0xe59fbf, 0xe5a083, 0xe5a084, 0xe5a088, 0xe5a089, 0xe59fa1, 
	/* 0x8fb8a1 */
0xe5a08c, 0xe5a08d, 0xe5a09b, 0xe5a09e, 0xe5a09f, 0xe5a0a0, 0xe5a0a6, 0xe5a0a7, 
0xe5a0ad, 0xe5a0b2, 0xe5a0b9, 0xe5a0bf, 0xe5a189, 0xe5a18c, 0xe5a18d, 0xe5a18f, 
0xe5a190, 0xe5a195, 0xe5a19f, 0xe5a1a1, 0xe5a1a4, 0xe5a1a7, 0xe5a1a8, 0xe5a1b8, 
0xe5a1bc, 0xe5a1bf, 0xe5a280, 0xe5a281, 0xe5a287, 0xe5a288, 0xe5a289, 0xe5a28a, 
0xe5a28c, 0xe5a28d, 0xe5a28f, 0xe5a290, 0xe5a294, 0xe5a296, 0xe5a29d, 0xe5a2a0, 
0xe5a2a1, 0xe5a2a2, 0xe5a2a6, 0xe5a2a9, 0xe5a2b1, 0xe5a2b2, 0xe5a384, 0xe5a2bc, 
0xe5a382, 0xe5a388, 0xe5a38d, 0xe5a38e, 0xe5a390, 0xe5a392, 0xe5a394, 0xe5a396, 
0xe5a39a, 0xe5a39d, 0xe5a3a1, 0xe5a3a2, 0xe5a3a9, 0xe5a3b3, 0xe5a485, 0xe5a486, 
0xe5a48b, 0xe5a48c, 0xe5a492, 0xe5a493, 0xe5a494, 0xe89981, 0xe5a49d, 0xe5a4a1, 
0xe5a4a3, 0xe5a4a4, 0xe5a4a8, 0xe5a4af, 0xe5a4b0, 0xe5a4b3, 0xe5a4b5, 0xe5a4b6, 
0xe5a4bf, 0xe5a583, 0xe5a586, 0xe5a592, 0xe5a593, 0xe5a599, 0xe5a59b, 0xe5a59d, 
0xe5a59e, 0xe5a59f, 0xe5a5a1, 0xe5a5a3, 0xe5a5ab, 0xe5a5ad, 
	/* 0x8fb9a1 */
0xe5a5af, 0xe5a5b2, 0xe5a5b5, 0xe5a5b6, 0xe5a5b9, 0xe5a5bb, 0xe5a5bc, 0xe5a68b, 
0xe5a68c, 0xe5a68e, 0xe5a692, 0xe5a695, 0xe5a697, 0xe5a69f, 0xe5a6a4, 0xe5a6a7, 
0xe5a6ad, 0xe5a6ae, 0xe5a6af, 0xe5a6b0, 0xe5a6b3, 0xe5a6b7, 0xe5a6ba, 0xe5a6bc, 
0xe5a781, 0xe5a783, 0xe5a784, 0xe5a788, 0xe5a78a, 0xe5a78d, 0xe5a792, 0xe5a79d, 
0xe5a79e, 0xe5a79f, 0xe5a7a3, 0xe5a7a4, 0xe5a7a7, 0xe5a7ae, 0xe5a7af, 0xe5a7b1, 
0xe5a7b2, 0xe5a7b4, 0xe5a7b7, 0xe5a880, 0xe5a884, 0xe5a88c, 0xe5a88d, 0xe5a88e, 
0xe5a892, 0xe5a893, 0xe5a89e, 0xe5a8a3, 0xe5a8a4, 0xe5a8a7, 0xe5a8a8, 0xe5a8aa, 
0xe5a8ad, 0xe5a8b0, 0xe5a984, 0xe5a985, 0xe5a987, 0xe5a988, 0xe5a98c, 0xe5a990, 
0xe5a995, 0xe5a99e, 0xe5a9a3, 0xe5a9a5, 0xe5a9a7, 0xe5a9ad, 0xe5a9b7, 0xe5a9ba, 
0xe5a9bb, 0xe5a9be, 0xe5aa8b, 0xe5aa90, 0xe5aa93, 0xe5aa96, 0xe5aa99, 0xe5aa9c, 
0xe5aa9e, 0xe5aa9f, 0xe5aaa0, 0xe5aaa2, 0xe5aaa7, 0xe5aaac, 0xe5aab1, 0xe5aab2, 
0xe5aab3, 0xe5aab5, 0xe5aab8, 0xe5aaba, 0xe5aabb, 0xe5aabf, 
	/* 0x8fbaa1 */
0xe5ab84, 0xe5ab86, 0xe5ab88, 0xe5ab8f, 0xe5ab9a, 0xe5ab9c, 0xe5aba0, 0xe5aba5, 
0xe5abaa, 0xe5abae, 0xe5abb5, 0xe5abb6, 0xe5abbd, 0xe5ac80, 0xe5ac81, 0xe5ac88, 
0xe5ac97, 0xe5acb4, 0xe5ac99, 0xe5ac9b, 0xe5ac9d, 0xe5aca1, 0xe5aca5, 0xe5acad, 
0xe5acb8, 0xe5ad81, 0xe5ad8b, 0xe5ad8c, 0xe5ad92, 0xe5ad96, 0xe5ad9e, 0xe5ada8, 
0xe5adae, 0xe5adaf, 0xe5adbc, 0xe5adbd, 0xe5adbe, 0xe5adbf, 0xe5ae81, 0xe5ae84, 
0xe5ae86, 0xe5ae8a, 0xe5ae8e, 0xe5ae90, 0xe5ae91, 0xe5ae93, 0xe5ae94, 0xe5ae96, 
0xe5aea8, 0xe5aea9, 0xe5aeac, 0xe5aead, 0xe5aeaf, 0xe5aeb1, 0xe5aeb2, 0xe5aeb7, 
0xe5aeba, 0xe5aebc, 0xe5af80, 0xe5af81, 0xe5af8d, 0xe5af8f, 0xe5af96, 0xe5af97, 
0xe5af98, 0xe5af99, 0xe5af9a, 0xe5afa0, 0xe5afaf, 0xe5afb1, 0xe5afb4, 0xe5afbd, 
0xe5b08c, 0xe5b097, 0xe5b09e, 0xe5b09f, 0xe5b0a3, 0xe5b0a6, 0xe5b0a9, 0xe5b0ab, 
0xe5b0ac, 0xe5b0ae, 0xe5b0b0, 0xe5b0b2, 0xe5b0b5, 0xe5b0b6, 0xe5b199, 0xe5b19a, 
0xe5b19c, 0xe5b1a2, 0xe5b1a3, 0xe5b1a7, 0xe5b1a8, 0xe5b1a9, 
	/* 0x8fbba1 */
0xe5b1ad, 0xe5b1b0, 0xe5b1b4, 0xe5b1b5, 0xe5b1ba, 0xe5b1bb, 0xe5b1bc, 0xe5b1bd, 
0xe5b287, 0xe5b288, 0xe5b28a, 0xe5b28f, 0xe5b292, 0xe5b29d, 0xe5b29f, 0xe5b2a0, 
0xe5b2a2, 0xe5b2a3, 0xe5b2a6, 0xe5b2aa, 0xe5b2b2, 0xe5b2b4, 0xe5b2b5, 0xe5b2ba, 
0xe5b389, 0xe5b38b, 0xe5b392, 0xe5b39d, 0xe5b397, 0xe5b3ae, 0xe5b3b1, 0xe5b3b2, 
0xe5b3b4, 0xe5b481, 0xe5b486, 0xe5b48d, 0xe5b492, 0xe5b4ab, 0xe5b4a3, 0xe5b4a4, 
0xe5b4a6, 0xe5b4a7, 0xe5b4b1, 0xe5b4b4, 0xe5b4b9, 0xe5b4bd, 0xe5b4bf, 0xe5b582, 
0xe5b583, 0xe5b586, 0xe5b588, 0xe5b595, 0xe5b591, 0xe5b599, 0xe5b58a, 0xe5b59f, 
0xe5b5a0, 0xe5b5a1, 0xe5b5a2, 0xe5b5a4, 0xe5b5aa, 0xe5b5ad, 0xe5b5b0, 0xe5b5b9, 
0xe5b5ba, 0xe5b5be, 0xe5b5bf, 0xe5b681, 0xe5b683, 0xe5b688, 0xe5b68a, 0xe5b692, 
0xe5b693, 0xe5b694, 0xe5b695, 0xe5b699, 0xe5b69b, 0xe5b69f, 0xe5b6a0, 0xe5b6a7, 
0xe5b6ab, 0xe5b6b0, 0xe5b6b4, 0xe5b6b8, 0xe5b6b9, 0xe5b783, 0xe5b787, 0xe5b78b, 
0xe5b790, 0xe5b78e, 0xe5b798, 0xe5b799, 0xe5b7a0, 0xe5b7a4, 
	/* 0x8fbca1 */
0xe5b7a9, 0xe5b7b8, 0xe5b7b9, 0xe5b880, 0xe5b887, 0xe5b88d, 0xe5b892, 0xe5b894, 
0xe5b895, 0xe5b898, 0xe5b89f, 0xe5b8a0, 0xe5b8ae, 0xe5b8a8, 0xe5b8b2, 0xe5b8b5, 
0xe5b8be, 0xe5b98b, 0xe5b990, 0xe5b989, 0xe5b991, 0xe5b996, 0xe5b998, 0xe5b99b, 
0xe5b99c, 0xe5b99e, 0xe5b9a8, 0xe5b9aa, 0xe5b9ab, 0xe5b9ac, 0xe5b9ad, 0xe5b9ae, 
0xe5b9b0, 0xe5ba80, 0xe5ba8b, 0xe5ba8e, 0xe5baa2, 0xe5baa4, 0xe5baa5, 0xe5baa8, 
0xe5baaa, 0xe5baac, 0xe5bab1, 0xe5bab3, 0xe5babd, 0xe5babe, 0xe5babf, 0xe5bb86, 
0xe5bb8c, 0xe5bb8b, 0xe5bb8e, 0xe5bb91, 0xe5bb92, 0xe5bb94, 0xe5bb95, 0xe5bb9c, 
0xe5bb9e, 0xe5bba5, 0xe5bbab, 0xe5bc82, 0xe5bc86, 0xe5bc87, 0xe5bc88, 0xe5bc8e, 
0xe5bc99, 0xe5bc9c, 0xe5bc9d, 0xe5bca1, 0xe5bca2, 0xe5bca3, 0xe5bca4, 0xe5bca8, 
0xe5bcab, 0xe5bcac, 0xe5bcae, 0xe5bcb0, 0xe5bcb4, 0xe5bcb6, 0xe5bcbb, 0xe5bcbd, 
0xe5bcbf, 0xe5bd80, 0xe5bd84, 0xe5bd85, 0xe5bd87, 0xe5bd8d, 0xe5bd90, 0xe5bd94, 
0xe5bd98, 0xe5bd9b, 0xe5bda0, 0xe5bda3, 0xe5bda4, 0xe5bda7, 
	/* 0x8fbda1 */
0xe5bdaf, 0xe5bdb2, 0xe5bdb4, 0xe5bdb5, 0xe5bdb8, 0xe5bdba, 0xe5bdbd, 0xe5bdbe, 
0xe5be89, 0xe5be8d, 0xe5be8f, 0xe5be96, 0xe5be9c, 0xe5be9d, 0xe5bea2, 0xe5bea7, 
0xe5beab, 0xe5bea4, 0xe5beac, 0xe5beaf, 0xe5beb0, 0xe5beb1, 0xe5beb8, 0xe5bf84, 
0xe5bf87, 0xe5bf88, 0xe5bf89, 0xe5bf8b, 0xe5bf90, 0xe5bf91, 0xe5bf92, 0xe5bf93, 
0xe5bf94, 0xe5bf9e, 0xe5bfa1, 0xe5bfa2, 0xe5bfa8, 0xe5bfa9, 0xe5bfaa, 0xe5bfac, 
0xe5bfad, 0xe5bfae, 0xe5bfaf, 0xe5bfb2, 0xe5bfb3, 0xe5bfb6, 0xe5bfba, 0xe5bfbc, 
0xe68087, 0xe6808a, 0xe6808d, 0xe68093, 0xe68094, 0xe68097, 0xe68098, 0xe6809a, 
0xe6809f, 0xe680a4, 0xe680ad, 0xe680b3, 0xe680b5, 0xe68180, 0xe68187, 0xe68188, 
0xe68189, 0xe6818c, 0xe68191, 0xe68194, 0xe68196, 0xe68197, 0xe6819d, 0xe681a1, 
0xe681a7, 0xe681b1, 0xe681be, 0xe681bf, 0xe68282, 0xe68286, 0xe68288, 0xe6828a, 
0xe6828e, 0xe68291, 0xe68293, 0xe68295, 0xe68298, 0xe6829d, 0xe6829e, 0xe682a2, 
0xe682a4, 0xe682a5, 0xe682a8, 0xe682b0, 0xe682b1, 0xe682b7, 
	/* 0x8fbea1 */
0xe682bb, 0xe682be, 0xe68382, 0xe68384, 0xe68388, 0xe68389, 0xe6838a, 0xe6838b, 
0xe6838e, 0xe6838f, 0xe68394, 0xe68395, 0xe68399, 0xe6839b, 0xe6839d, 0xe6839e, 
0xe683a2, 0xe683a5, 0xe683b2, 0xe683b5, 0xe683b8, 0xe683bc, 0xe683bd, 0xe68482, 
0xe68487, 0xe6848a, 0xe6848c, 0xe68490, 0xe68491, 0xe68492, 0xe68493, 0xe68494, 
0xe68496, 0xe68497, 0xe68499, 0xe6849c, 0xe6849e, 0xe684a2, 0xe684aa, 0xe684ab, 
0xe684b0, 0xe684b1, 0xe684b5, 0xe684b6, 0xe684b7, 0xe684b9, 0xe68581, 0xe68585, 
0xe68586, 0xe68589, 0xe6859e, 0xe685a0, 0xe685ac, 0xe685b2, 0xe685b8, 0xe685bb, 
0xe685bc, 0xe685bf, 0xe68680, 0xe68681, 0xe68683, 0xe68684, 0xe6868b, 0xe6868d, 
0xe68692, 0xe68693, 0xe68697, 0xe68698, 0xe6869c, 0xe6869d, 0xe6869f, 0xe686a0, 
0xe686a5, 0xe686a8, 0xe686aa, 0xe686ad, 0xe686b8, 0xe686b9, 0xe686bc, 0xe68780, 
0xe68781, 0xe68782, 0xe6878e, 0xe6878f, 0xe68795, 0xe6879c, 0xe6879d, 0xe6879e, 
0xe6879f, 0xe687a1, 0xe687a2, 0xe687a7, 0xe687a9, 0xe687a5, 
	/* 0x8fbfa1 */
0xe687ac, 0xe687ad, 0xe687af, 0xe68881, 0xe68883, 0xe68884, 0xe68887, 0xe68893, 
0xe68895, 0xe6889c, 0xe688a0, 0xe688a2, 0xe688a3, 0xe688a7, 0xe688a9, 0xe688ab, 
0xe688b9, 0xe688bd, 0xe68982, 0xe68983, 0xe68984, 0xe68986, 0xe6898c, 0xe68990, 
0xe68991, 0xe68992, 0xe68994, 0xe68996, 0xe6899a, 0xe6899c, 0xe689a4, 0xe689ad, 
0xe689af, 0xe689b3, 0xe689ba, 0xe689bd, 0xe68a8d, 0xe68a8e, 0xe68a8f, 0xe68a90, 
0xe68aa6, 0xe68aa8, 0xe68ab3, 0xe68ab6, 0xe68ab7, 0xe68aba, 0xe68abe, 0xe68abf, 
0xe68b84, 0xe68b8e, 0xe68b95, 0xe68b96, 0xe68b9a, 0xe68baa, 0xe68bb2, 0xe68bb4, 
0xe68bbc, 0xe68bbd, 0xe68c83, 0xe68c84, 0xe68c8a, 0xe68c8b, 0xe68c8d, 0xe68c90, 
0xe68c93, 0xe68c96, 0xe68c98, 0xe68ca9, 0xe68caa, 0xe68cad, 0xe68cb5, 0xe68cb6, 
0xe68cb9, 0xe68cbc, 0xe68d81, 0xe68d82, 0xe68d83, 0xe68d84, 0xe68d86, 0xe68d8a, 
0xe68d8b, 0xe68d8e, 0xe68d92, 0xe68d93, 0xe68d94, 0xe68d98, 0xe68d9b, 0xe68da5, 
0xe68da6, 0xe68dac, 0xe68dad, 0xe68db1, 0xe68db4, 0xe68db5, 
	/* 0x8fc0a1 */
0xe68db8, 0xe68dbc, 0xe68dbd, 0xe68dbf, 0xe68e82, 0xe68e84, 0xe68e87, 0xe68e8a, 
0xe68e90, 0xe68e94, 0xe68e95, 0xe68e99, 0xe68e9a, 0xe68e9e, 0xe68ea4, 0xe68ea6, 
0xe68ead, 0xe68eae, 0xe68eaf, 0xe68ebd, 0xe68f81, 0xe68f85, 0xe68f88, 0xe68f8e, 
0xe68f91, 0xe68f93, 0xe68f94, 0xe68f95, 0xe68f9c, 0xe68fa0, 0xe68fa5, 0xe68faa, 
0xe68fac, 0xe68fb2, 0xe68fb3, 0xe68fb5, 0xe68fb8, 0xe68fb9, 0xe69089, 0xe6908a, 
0xe69090, 0xe69092, 0xe69094, 0xe69098, 0xe6909e, 0xe690a0, 0xe690a2, 0xe690a4, 
0xe690a5, 0xe690a9, 0xe690aa, 0xe690af, 0xe690b0, 0xe690b5, 0xe690bd, 0xe690bf, 
0xe6918b, 0xe6918f, 0xe69191, 0xe69192, 0xe69193, 0xe69194, 0xe6919a, 0xe6919b, 
0xe6919c, 0xe6919d, 0xe6919f, 0xe691a0, 0xe691a1, 0xe691a3, 0xe691ad, 0xe691b3, 
0xe691b4, 0xe691bb, 0xe691bd, 0xe69285, 0xe69287, 0xe6928f, 0xe69290, 0xe69291, 
0xe69298, 0xe69299, 0xe6929b, 0xe6929d, 0xe6929f, 0xe692a1, 0xe692a3, 0xe692a6, 
0xe692a8, 0xe692ac, 0xe692b3, 0xe692bd, 0xe692be, 0xe692bf, 
	/* 0x8fc1a1 */
0xe69384, 0xe69389, 0xe6938a, 0xe6938b, 0xe6938c, 0xe6938e, 0xe69390, 0xe69391, 
0xe69395, 0xe69397, 0xe693a4, 0xe693a5, 0xe693a9, 0xe693aa, 0xe693ad, 0xe693b0, 
0xe693b5, 0xe693b7, 0xe693bb, 0xe693bf, 0xe69481, 0xe69484, 0xe69488, 0xe69489, 
0xe6948a, 0xe6948f, 0xe69493, 0xe69494, 0xe69496, 0xe69499, 0xe6949b, 0xe6949e, 
0xe6949f, 0xe694a2, 0xe694a6, 0xe694a9, 0xe694ae, 0xe694b1, 0xe694ba, 0xe694bc, 
0xe694bd, 0xe69583, 0xe69587, 0xe69589, 0xe69590, 0xe69592, 0xe69594, 0xe6959f, 
0xe695a0, 0xe695a7, 0xe695ab, 0xe695ba, 0xe695bd, 0xe69681, 0xe69685, 0xe6968a, 
0xe69692, 0xe69695, 0xe69698, 0xe6969d, 0xe696a0, 0xe696a3, 0xe696a6, 0xe696ae, 
0xe696b2, 0xe696b3, 0xe696b4, 0xe696bf, 0xe69782, 0xe69788, 0xe69789, 0xe6978e, 
0xe69790, 0xe69794, 0xe69796, 0xe69798, 0xe6979f, 0xe697b0, 0xe697b2, 0xe697b4, 
0xe697b5, 0xe697b9, 0xe697be, 0xe697bf, 0xe69880, 0xe69884, 0xe69888, 0xe69889, 
0xe6988d, 0xe69891, 0xe69892, 0xe69895, 0xe69896, 0xe6989d, 
	/* 0x8fc2a1 */
0xe6989e, 0xe698a1, 0xe698a2, 0xe698a3, 0xe698a4, 0xe698a6, 0xe698a9, 0xe698aa, 
0xe698ab, 0xe698ac, 0xe698ae, 0xe698b0, 0xe698b1, 0xe698b3, 0xe698b9, 0xe698b7, 
0xe69980, 0xe69985, 0xe69986, 0xe6998a, 0xe6998c, 0xe69991, 0xe6998e, 0xe69997, 
0xe69998, 0xe69999, 0xe6999b, 0xe6999c, 0xe699a0, 0xe699a1, 0xe69bbb, 0xe699aa, 
0xe699ab, 0xe699ac, 0xe699be, 0xe699b3, 0xe699b5, 0xe699bf, 0xe699b7, 0xe699b8, 
0xe699b9, 0xe699bb, 0xe69a80, 0xe699bc, 0xe69a8b, 0xe69a8c, 0xe69a8d, 0xe69a90, 
0xe69a92, 0xe69a99, 0xe69a9a, 0xe69a9b, 0xe69a9c, 0xe69a9f, 0xe69aa0, 0xe69aa4, 
0xe69aad, 0xe69ab1, 0xe69ab2, 0xe69ab5, 0xe69abb, 0xe69abf, 0xe69b80, 0xe69b82, 
0xe69b83, 0xe69b88, 0xe69b8c, 0xe69b8e, 0xe69b8f, 0xe69b94, 0xe69b9b, 0xe69b9f, 
0xe69ba8, 0xe69bab, 0xe69bac, 0xe69bae, 0xe69bba, 0xe69c85, 0xe69c87, 0xe69c8e, 
0xe69c93, 0xe69c99, 0xe69c9c, 0xe69ca0, 0xe69ca2, 0xe69cb3, 0xe69cbe, 0xe69d85, 
0xe69d87, 0xe69d88, 0xe69d8c, 0xe69d94, 0xe69d95, 0xe69d9d, 
	/* 0x8fc3a1 */
0xe69da6, 0xe69dac, 0xe69dae, 0xe69db4, 0xe69db6, 0xe69dbb, 0xe69e81, 0xe69e84, 
0xe69e8e, 0xe69e8f, 0xe69e91, 0xe69e93, 0xe69e96, 0xe69e98, 0xe69e99, 0xe69e9b, 
0xe69eb0, 0xe69eb1, 0xe69eb2, 0xe69eb5, 0xe69ebb, 0xe69ebc, 0xe69ebd, 0xe69fb9, 
0xe69f80, 0xe69f82, 0xe69f83, 0xe69f85, 0xe69f88, 0xe69f89, 0xe69f92, 0xe69f97, 
0xe69f99, 0xe69f9c, 0xe69fa1, 0xe69fa6, 0xe69fb0, 0xe69fb2, 0xe69fb6, 0xe69fb7, 
0xe6a192, 0xe6a094, 0xe6a099, 0xe6a09d, 0xe6a09f, 0xe6a0a8, 0xe6a0a7, 0xe6a0ac, 
0xe6a0ad, 0xe6a0af, 0xe6a0b0, 0xe6a0b1, 0xe6a0b3, 0xe6a0bb, 0xe6a0bf, 0xe6a184, 
0xe6a185, 0xe6a18a, 0xe6a18c, 0xe6a195, 0xe6a197, 0xe6a198, 0xe6a19b, 0xe6a1ab, 
0xe6a1ae, 0xe6a1af, 0xe6a1b0, 0xe6a1b1, 0xe6a1b2, 0xe6a1b5, 0xe6a1b9, 0xe6a1ba, 
0xe6a1bb, 0xe6a1bc, 0xe6a282, 0xe6a284, 0xe6a286, 0xe6a288, 0xe6a296, 0xe6a298, 
0xe6a29a, 0xe6a29c, 0xe6a2a1, 0xe6a2a3, 0xe6a2a5, 0xe6a2a9, 0xe6a2aa, 0xe6a2ae, 
0xe6a2b2, 0xe6a2bb, 0xe6a385, 0xe6a388, 0xe6a38c, 0xe6a38f, 
	/* 0x8fc4a1 */
0xe6a390, 0xe6a391, 0xe6a393, 0xe6a396, 0xe6a399, 0xe6a39c, 0xe6a39d, 0xe6a3a5, 
0xe6a3a8, 0xe6a3aa, 0xe6a3ab, 0xe6a3ac, 0xe6a3ad, 0xe6a3b0, 0xe6a3b1, 0xe6a3b5, 
0xe6a3b6, 0xe6a3bb, 0xe6a3bc, 0xe6a3bd, 0xe6a486, 0xe6a489, 0xe6a48a, 0xe6a490, 
0xe6a491, 0xe6a493, 0xe6a496, 0xe6a497, 0xe6a4b1, 0xe6a4b3, 0xe6a4b5, 0xe6a4b8, 
0xe6a4bb, 0xe6a582, 0xe6a585, 0xe6a589, 0xe6a58e, 0xe6a597, 0xe6a59b, 0xe6a5a3, 
0xe6a5a4, 0xe6a5a5, 0xe6a5a6, 0xe6a5a8, 0xe6a5a9, 0xe6a5ac, 0xe6a5b0, 0xe6a5b1, 
0xe6a5b2, 0xe6a5ba, 0xe6a5bb, 0xe6a5bf, 0xe6a680, 0xe6a68d, 0xe6a692, 0xe6a696, 
0xe6a698, 0xe6a6a1, 0xe6a6a5, 0xe6a6a6, 0xe6a6a8, 0xe6a6ab, 0xe6a6ad, 0xe6a6af, 
0xe6a6b7, 0xe6a6b8, 0xe6a6ba, 0xe6a6bc, 0xe6a785, 0xe6a788, 0xe6a791, 0xe6a796, 
0xe6a797, 0xe6a7a2, 0xe6a7a5, 0xe6a7ae, 0xe6a7af, 0xe6a7b1, 0xe6a7b3, 0xe6a7b5, 
0xe6a7be, 0xe6a880, 0xe6a881, 0xe6a883, 0xe6a88f, 0xe6a891, 0xe6a895, 0xe6a89a, 
0xe6a89d, 0xe6a8a0, 0xe6a8a4, 0xe6a8a8, 0xe6a8b0, 0xe6a8b2, 
	/* 0x8fc5a1 */
0xe6a8b4, 0xe6a8b7, 0xe6a8bb, 0xe6a8be, 0xe6a8bf, 0xe6a985, 0xe6a986, 0xe6a989, 
0xe6a98a, 0xe6a98e, 0xe6a990, 0xe6a991, 0xe6a992, 0xe6a995, 0xe6a996, 0xe6a99b, 
0xe6a9a4, 0xe6a9a7, 0xe6a9aa, 0xe6a9b1, 0xe6a9b3, 0xe6a9be, 0xe6aa81, 0xe6aa83, 
0xe6aa86, 0xe6aa87, 0xe6aa89, 0xe6aa8b, 0xe6aa91, 0xe6aa9b, 0xe6aa9d, 0xe6aa9e, 
0xe6aa9f, 0xe6aaa5, 0xe6aaab, 0xe6aaaf, 0xe6aab0, 0xe6aab1, 0xe6aab4, 0xe6aabd, 
0xe6aabe, 0xe6aabf, 0xe6ab86, 0xe6ab89, 0xe6ab88, 0xe6ab8c, 0xe6ab90, 0xe6ab94, 
0xe6ab95, 0xe6ab96, 0xe6ab9c, 0xe6ab9d, 0xe6aba4, 0xe6aba7, 0xe6abac, 0xe6abb0, 
0xe6abb1, 0xe6abb2, 0xe6abbc, 0xe6abbd, 0xe6ac82, 0xe6ac83, 0xe6ac86, 0xe6ac87, 
0xe6ac89, 0xe6ac8f, 0xe6ac90, 0xe6ac91, 0xe6ac97, 0xe6ac9b, 0xe6ac9e, 0xe6aca4, 
0xe6aca8, 0xe6acab, 0xe6acac, 0xe6acaf, 0xe6acb5, 0xe6acb6, 0xe6acbb, 0xe6acbf, 
0xe6ad86, 0xe6ad8a, 0xe6ad8d, 0xe6ad92, 0xe6ad96, 0xe6ad98, 0xe6ad9d, 0xe6ada0, 
0xe6ada7, 0xe6adab, 0xe6adae, 0xe6adb0, 0xe6adb5, 0xe6adbd, 
	/* 0x8fc6a1 */
0xe6adbe, 0xe6ae82, 0xe6ae85, 0xe6ae97, 0xe6ae9b, 0xe6ae9f, 0xe6aea0, 0xe6aea2, 
0xe6aea3, 0xe6aea8, 0xe6aea9, 0xe6aeac, 0xe6aead, 0xe6aeae, 0xe6aeb0, 0xe6aeb8, 
0xe6aeb9, 0xe6aebd, 0xe6aebe, 0xe6af83, 0xe6af84, 0xe6af89, 0xe6af8c, 0xe6af96, 
0xe6af9a, 0xe6afa1, 0xe6afa3, 0xe6afa6, 0xe6afa7, 0xe6afae, 0xe6afb1, 0xe6afb7, 
0xe6afb9, 0xe6afbf, 0xe6b082, 0xe6b084, 0xe6b085, 0xe6b089, 0xe6b08d, 0xe6b08e, 
0xe6b090, 0xe6b092, 0xe6b099, 0xe6b09f, 0xe6b0a6, 0xe6b0a7, 0xe6b0a8, 0xe6b0ac, 
0xe6b0ae, 0xe6b0b3, 0xe6b0b5, 0xe6b0b6, 0xe6b0ba, 0xe6b0bb, 0xe6b0bf, 0xe6b18a, 
0xe6b18b, 0xe6b18d, 0xe6b18f, 0xe6b192, 0xe6b194, 0xe6b199, 0xe6b19b, 0xe6b19c, 
0xe6b1ab, 0xe6b1ad, 0xe6b1af, 0xe6b1b4, 0xe6b1b6, 0xe6b1b8, 0xe6b1b9, 0xe6b1bb, 
0xe6b285, 0xe6b286, 0xe6b287, 0xe6b289, 0xe6b294, 0xe6b295, 0xe6b297, 0xe6b298, 
0xe6b29c, 0xe6b29f, 0xe6b2b0, 0xe6b2b2, 0xe6b2b4, 0xe6b382, 0xe6b386, 0xe6b38d, 
0xe6b38f, 0xe6b390, 0xe6b391, 0xe6b392, 0xe6b394, 0xe6b396, 
	/* 0x8fc7a1 */
0xe6b39a, 0xe6b39c, 0xe6b3a0, 0xe6b3a7, 0xe6b3a9, 0xe6b3ab, 0xe6b3ac, 0xe6b3ae, 
0xe6b3b2, 0xe6b3b4, 0xe6b484, 0xe6b487, 0xe6b48a, 0xe6b48e, 0xe6b48f, 0xe6b491, 
0xe6b493, 0xe6b49a, 0xe6b4a6, 0xe6b4a7, 0xe6b4a8, 0xe6b1a7, 0xe6b4ae, 0xe6b4af, 
0xe6b4b1, 0xe6b4b9, 0xe6b4bc, 0xe6b4bf, 0xe6b597, 0xe6b59e, 0xe6b59f, 0xe6b5a1, 
0xe6b5a5, 0xe6b5a7, 0xe6b5af, 0xe6b5b0, 0xe6b5bc, 0xe6b682, 0xe6b687, 0xe6b691, 
0xe6b692, 0xe6b694, 0xe6b696, 0xe6b697, 0xe6b698, 0xe6b6aa, 0xe6b6ac, 0xe6b6b4, 
0xe6b6b7, 0xe6b6b9, 0xe6b6bd, 0xe6b6bf, 0xe6b784, 0xe6b788, 0xe6b78a, 0xe6b78e, 
0xe6b78f, 0xe6b796, 0xe6b79b, 0xe6b79d, 0xe6b79f, 0xe6b7a0, 0xe6b7a2, 0xe6b7a5, 
0xe6b7a9, 0xe6b7af, 0xe6b7b0, 0xe6b7b4, 0xe6b7b6, 0xe6b7bc, 0xe6b880, 0xe6b884, 
0xe6b89e, 0xe6b8a2, 0xe6b8a7, 0xe6b8b2, 0xe6b8b6, 0xe6b8b9, 0xe6b8bb, 0xe6b8bc, 
0xe6b984, 0xe6b985, 0xe6b988, 0xe6b989, 0xe6b98b, 0xe6b98f, 0xe6b991, 0xe6b992, 
0xe6b993, 0xe6b994, 0xe6b997, 0xe6b99c, 0xe6b99d, 0xe6b99e, 
	/* 0x8fc8a1 */
0xe6b9a2, 0xe6b9a3, 0xe6b9a8, 0xe6b9b3, 0xe6b9bb, 0xe6b9bd, 0xe6ba8d, 0xe6ba93, 
0xe6ba99, 0xe6baa0, 0xe6baa7, 0xe6baad, 0xe6baae, 0xe6bab1, 0xe6bab3, 0xe6babb, 
0xe6babf, 0xe6bb80, 0xe6bb81, 0xe6bb83, 0xe6bb87, 0xe6bb88, 0xe6bb8a, 0xe6bb8d, 
0xe6bb8e, 0xe6bb8f, 0xe6bbab, 0xe6bbad, 0xe6bbae, 0xe6bbb9, 0xe6bbbb, 0xe6bbbd, 
0xe6bc84, 0xe6bc88, 0xe6bc8a, 0xe6bc8c, 0xe6bc8d, 0xe6bc96, 0xe6bc98, 0xe6bc9a, 
0xe6bc9b, 0xe6bca6, 0xe6bca9, 0xe6bcaa, 0xe6bcaf, 0xe6bcb0, 0xe6bcb3, 0xe6bcb6, 
0xe6bcbb, 0xe6bcbc, 0xe6bcad, 0xe6bd8f, 0xe6bd91, 0xe6bd92, 0xe6bd93, 0xe6bd97, 
0xe6bd99, 0xe6bd9a, 0xe6bd9d, 0xe6bd9e, 0xe6bda1, 0xe6bda2, 0xe6bda8, 0xe6bdac, 
0xe6bdbd, 0xe6bdbe, 0xe6be83, 0xe6be87, 0xe6be88, 0xe6be8b, 0xe6be8c, 0xe6be8d, 
0xe6be90, 0xe6be92, 0xe6be93, 0xe6be94, 0xe6be96, 0xe6be9a, 0xe6be9f, 0xe6bea0, 
0xe6bea5, 0xe6bea6, 0xe6bea7, 0xe6bea8, 0xe6beae, 0xe6beaf, 0xe6beb0, 0xe6beb5, 
0xe6beb6, 0xe6bebc, 0xe6bf85, 0xe6bf87, 0xe6bf88, 0xe6bf8a, 
	/* 0x8fc9a1 */
0xe6bf9a, 0xe6bf9e, 0xe6bfa8, 0xe6bfa9, 0xe6bfb0, 0xe6bfb5, 0xe6bfb9, 0xe6bfbc, 
0xe6bfbd, 0xe78080, 0xe78085, 0xe78086, 0xe78087, 0xe7808d, 0xe78097, 0xe780a0, 
0xe780a3, 0xe780af, 0xe780b4, 0xe780b7, 0xe780b9, 0xe780bc, 0xe78183, 0xe78184, 
0xe78188, 0xe78189, 0xe7818a, 0xe7818b, 0xe78194, 0xe78195, 0xe7819d, 0xe7819e, 
0xe7818e, 0xe781a4, 0xe781a5, 0xe781ac, 0xe781ae, 0xe781b5, 0xe781b6, 0xe781be, 
0xe78281, 0xe78285, 0xe78286, 0xe78294, 0xe78295, 0xe78296, 0xe78297, 0xe78298, 
0xe7829b, 0xe782a4, 0xe782ab, 0xe782b0, 0xe782b1, 0xe782b4, 0xe782b7, 0xe7838a, 
0xe78391, 0xe78393, 0xe78394, 0xe78395, 0xe78396, 0xe78398, 0xe7839c, 0xe783a4, 
0xe783ba, 0xe78483, 0xe78484, 0xe78485, 0xe78486, 0xe78487, 0xe7848b, 0xe7848c, 
0xe7848f, 0xe7849e, 0xe784a0, 0xe784ab, 0xe784ad, 0xe784af, 0xe784b0, 0xe784b1, 
0xe784b8, 0xe78581, 0xe78585, 0xe78586, 0xe78587, 0xe7858a, 0xe7858b, 0xe78590, 
0xe78592, 0xe78597, 0xe7859a, 0xe7859c, 0xe7859e, 0xe785a0, 
	/* 0x8fcaa1 */
0xe785a8, 0xe785b9, 0xe78680, 0xe78685, 0xe78687, 0xe7868c, 0xe78692, 0xe7869a, 
0xe7869b, 0xe786a0, 0xe786a2, 0xe786af, 0xe786b0, 0xe786b2, 0xe786b3, 0xe786ba, 
0xe786bf, 0xe78780, 0xe78781, 0xe78784, 0xe7878b, 0xe7878c, 0xe78793, 0xe78796, 
0xe78799, 0xe7879a, 0xe7879c, 0xe787b8, 0xe787be, 0xe78880, 0xe78887, 0xe78888, 
0xe78889, 0xe78893, 0xe78897, 0xe7889a, 0xe7889d, 0xe7889f, 0xe788a4, 0xe788ab, 
0xe788af, 0xe788b4, 0xe788b8, 0xe788b9, 0xe78981, 0xe78982, 0xe78983, 0xe78985, 
0xe7898e, 0xe7898f, 0xe78990, 0xe78993, 0xe78995, 0xe78996, 0xe7899a, 0xe7899c, 
0xe7899e, 0xe789a0, 0xe789a3, 0xe789a8, 0xe789ab, 0xe789ae, 0xe789af, 0xe789b1, 
0xe789b7, 0xe789b8, 0xe789bb, 0xe789bc, 0xe789bf, 0xe78a84, 0xe78a89, 0xe78a8d, 
0xe78a8e, 0xe78a93, 0xe78a9b, 0xe78aa8, 0xe78aad, 0xe78aae, 0xe78ab1, 0xe78ab4, 
0xe78abe, 0xe78b81, 0xe78b87, 0xe78b89, 0xe78b8c, 0xe78b95, 0xe78b96, 0xe78b98, 
0xe78b9f, 0xe78ba5, 0xe78bb3, 0xe78bb4, 0xe78bba, 0xe78bbb, 
	/* 0x8fcba1 */
0xe78bbe, 0xe78c82, 0xe78c84, 0xe78c85, 0xe78c87, 0xe78c8b, 0xe78c8d, 0xe78c92, 
0xe78c93, 0xe78c98, 0xe78c99, 0xe78c9e, 0xe78ca2, 0xe78ca4, 0xe78ca7, 0xe78ca8, 
0xe78cac, 0xe78cb1, 0xe78cb2, 0xe78cb5, 0xe78cba, 0xe78cbb, 0xe78cbd, 0xe78d83, 
0xe78d8d, 0xe78d90, 0xe78d92, 0xe78d96, 0xe78d98, 0xe78d9d, 0xe78d9e, 0xe78d9f, 
0xe78da0, 0xe78da6, 0xe78da7, 0xe78da9, 0xe78dab, 0xe78dac, 0xe78dae, 0xe78daf, 
0xe78db1, 0xe78db7, 0xe78db9, 0xe78dbc, 0xe78e80, 0xe78e81, 0xe78e83, 0xe78e85, 
0xe78e86, 0xe78e8e, 0xe78e90, 0xe78e93, 0xe78e95, 0xe78e97, 0xe78e98, 0xe78e9c, 
0xe78e9e, 0xe78e9f, 0xe78ea0, 0xe78ea2, 0xe78ea5, 0xe78ea6, 0xe78eaa, 0xe78eab, 
0xe78ead, 0xe78eb5, 0xe78eb7, 0xe78eb9, 0xe78ebc, 0xe78ebd, 0xe78ebf, 0xe78f85, 
0xe78f86, 0xe78f89, 0xe78f8b, 0xe78f8c, 0xe78f8f, 0xe78f92, 0xe78f93, 0xe78f96, 
0xe78f99, 0xe78f9d, 0xe78fa1, 0xe78fa3, 0xe78fa6, 0xe78fa7, 0xe78fa9, 0xe78fb4, 
0xe78fb5, 0xe78fb7, 0xe78fb9, 0xe78fba, 0xe78fbb, 0xe78fbd, 
	/* 0x8fcca1 */
0xe78fbf, 0xe79080, 0xe79081, 0xe79084, 0xe79087, 0xe7908a, 0xe79091, 0xe7909a, 
0xe7909b, 0xe790a4, 0xe790a6, 0xe790a8, 0xe790a9, 0xe790aa, 0xe790ab, 0xe790ac, 
0xe790ad, 0xe790ae, 0xe790af, 0xe790b0, 0xe790b1, 0xe790b9, 0xe79180, 0xe79183, 
0xe79184, 0xe79186, 0xe79187, 0xe7918b, 0xe7918d, 0xe79191, 0xe79192, 0xe79197, 
0xe7919d, 0xe791a2, 0xe791a6, 0xe791a7, 0xe791a8, 0xe791ab, 0xe791ad, 0xe791ae, 
0xe791b1, 0xe791b2, 0xe79280, 0xe79281, 0xe79285, 0xe79286, 0xe79287, 0xe79289, 
0xe7928f, 0xe79290, 0xe79291, 0xe79292, 0xe79298, 0xe79299, 0xe7929a, 0xe7929c, 
0xe7929f, 0xe792a0, 0xe792a1, 0xe792a3, 0xe792a6, 0xe792a8, 0xe792a9, 0xe792aa, 
0xe792ab, 0xe792ae, 0xe792af, 0xe792b1, 0xe792b2, 0xe792b5, 0xe792b9, 0xe792bb, 
0xe792bf, 0xe79388, 0xe79389, 0xe7938c, 0xe79390, 0xe79393, 0xe79398, 0xe7939a, 
0xe7939b, 0xe7939e, 0xe7939f, 0xe793a4, 0xe793a8, 0xe793aa, 0xe793ab, 0xe793af, 
0xe793b4, 0xe793ba, 0xe793bb, 0xe793bc, 0xe793bf, 0xe79486, 
	/* 0x8fcda1 */
0xe79492, 0xe79496, 0xe79497, 0xe794a0, 0xe794a1, 0xe794a4, 0xe794a7, 0xe794a9, 
0xe794aa, 0xe794af, 0xe794b6, 0xe794b9, 0xe794bd, 0xe794be, 0xe794bf, 0xe79580, 
0xe79583, 0xe79587, 0xe79588, 0xe7958e, 0xe79590, 0xe79592, 0xe79597, 0xe7959e, 
0xe7959f, 0xe795a1, 0xe795af, 0xe795b1, 0xe795b9, 0xe795ba, 0xe795bb, 0xe795bc, 
0xe795bd, 0xe795be, 0xe79681, 0xe79685, 0xe79690, 0xe79692, 0xe79693, 0xe79695, 
0xe79699, 0xe7969c, 0xe796a2, 0xe796a4, 0xe796b4, 0xe796ba, 0xe796bf, 0xe79780, 
0xe79781, 0xe79784, 0xe79786, 0xe7978c, 0xe7978e, 0xe7978f, 0xe79797, 0xe7979c, 
0xe7979f, 0xe797a0, 0xe797a1, 0xe797a4, 0xe797a7, 0xe797ac, 0xe797ae, 0xe797af, 
0xe797b1, 0xe797b9, 0xe79880, 0xe79882, 0xe79883, 0xe79884, 0xe79887, 0xe79888, 
0xe7988a, 0xe7988c, 0xe7988f, 0xe79892, 0xe79893, 0xe79895, 0xe79896, 0xe79899, 
0xe7989b, 0xe7989c, 0xe7989d, 0xe7989e, 0xe798a3, 0xe798a5, 0xe798a6, 0xe798a9, 
0xe798ad, 0xe798b2, 0xe798b3, 0xe798b5, 0xe798b8, 0xe798b9, 
	/* 0x8fcea1 */
0xe798ba, 0xe798bc, 0xe7998a, 0xe79980, 0xe79981, 0xe79983, 0xe79984, 0xe79985, 
0xe79989, 0xe7998b, 0xe79995, 0xe79999, 0xe7999f, 0xe799a4, 0xe799a5, 0xe799ad, 
0xe799ae, 0xe799af, 0xe799b1, 0xe799b4, 0xe79a81, 0xe79a85, 0xe79a8c, 0xe79a8d, 
0xe79a95, 0xe79a9b, 0xe79a9c, 0xe79a9d, 0xe79a9f, 0xe79aa0, 0xe79aa2, 0xe79aa3, 
0xe79aa4, 0xe79aa5, 0xe79aa6, 0xe79aa7, 0xe79aa8, 0xe79aaa, 0xe79aad, 0xe79abd, 
0xe79b81, 0xe79b85, 0xe79b89, 0xe79b8b, 0xe79b8c, 0xe79b8e, 0xe79b94, 0xe79b99, 
0xe79ba0, 0xe79ba6, 0xe79ba8, 0xe79bac, 0xe79bb0, 0xe79bb1, 0xe79bb6, 0xe79bb9, 
0xe79bbc, 0xe79c80, 0xe79c86, 0xe79c8a, 0xe79c8e, 0xe79c92, 0xe79c94, 0xe79c95, 
0xe79c97, 0xe79c99, 0xe79c9a, 0xe79c9c, 0xe79ca2, 0xe79ca8, 0xe79cad, 0xe79cae, 
0xe79caf, 0xe79cb4, 0xe79cb5, 0xe79cb6, 0xe79cb9, 0xe79cbd, 0xe79cbe, 0xe79d82, 
0xe79d85, 0xe79d86, 0xe79d8a, 0xe79d8d, 0xe79d8e, 0xe79d8f, 0xe79d92, 0xe79d96, 
0xe79d97, 0xe79d9c, 0xe79d9e, 0xe79d9f, 0xe79da0, 0xe79da2, 
	/* 0x8fcfa1 */
0xe79da4, 0xe79da7, 0xe79daa, 0xe79dac, 0xe79db0, 0xe79db2, 0xe79db3, 0xe79db4, 
0xe79dba, 0xe79dbd, 0xe79e80, 0xe79e84, 0xe79e8c, 0xe79e8d, 0xe79e94, 0xe79e95, 
0xe79e96, 0xe79e9a, 0xe79e9f, 0xe79ea2, 0xe79ea7, 0xe79eaa, 0xe79eae, 0xe79eaf, 
0xe79eb1, 0xe79eb5, 0xe79ebe, 0xe79f83, 0xe79f89, 0xe79f91, 0xe79f92, 0xe79f95, 
0xe79f99, 0xe79f9e, 0xe79f9f, 0xe79fa0, 0xe79fa4, 0xe79fa6, 0xe79faa, 0xe79fac, 
0xe79fb0, 0xe79fb1, 0xe79fb4, 0xe79fb8, 0xe79fbb, 0xe7a085, 0xe7a086, 0xe7a089, 
0xe7a08d, 0xe7a08e, 0xe7a091, 0xe7a09d, 0xe7a0a1, 0xe7a0a2, 0xe7a0a3, 0xe7a0ad, 
0xe7a0ae, 0xe7a0b0, 0xe7a0b5, 0xe7a0b7, 0xe7a183, 0xe7a184, 0xe7a187, 0xe7a188, 
0xe7a18c, 0xe7a18e, 0xe7a192, 0xe7a19c, 0xe7a19e, 0xe7a1a0, 0xe7a1a1, 0xe7a1a3, 
0xe7a1a4, 0xe7a1a8, 0xe7a1aa, 0xe7a1ae, 0xe7a1ba, 0xe7a1be, 0xe7a28a, 0xe7a28f, 
0xe7a294, 0xe7a298, 0xe7a2a1, 0xe7a29d, 0xe7a29e, 0xe7a29f, 0xe7a2a4, 0xe7a2a8, 
0xe7a2ac, 0xe7a2ad, 0xe7a2b0, 0xe7a2b1, 0xe7a2b2, 0xe7a2b3, 
	/* 0x8fd0a1 */
0xe7a2bb, 0xe7a2bd, 0xe7a2bf, 0xe7a387, 0xe7a388, 0xe7a389, 0xe7a38c, 0xe7a38e, 
0xe7a392, 0xe7a393, 0xe7a395, 0xe7a396, 0xe7a3a4, 0xe7a39b, 0xe7a39f, 0xe7a3a0, 
0xe7a3a1, 0xe7a3a6, 0xe7a3aa, 0xe7a3b2, 0xe7a3b3, 0xe7a480, 0xe7a3b6, 0xe7a3b7, 
0xe7a3ba, 0xe7a3bb, 0xe7a3bf, 0xe7a486, 0xe7a48c, 0xe7a490, 0xe7a49a, 0xe7a49c, 
0xe7a49e, 0xe7a49f, 0xe7a4a0, 0xe7a4a5, 0xe7a4a7, 0xe7a4a9, 0xe7a4ad, 0xe7a4b1, 
0xe7a4b4, 0xe7a4b5, 0xe7a4bb, 0xe7a4bd, 0xe7a4bf, 0xe7a584, 0xe7a585, 0xe7a586, 
0xe7a58a, 0xe7a58b, 0xe7a58f, 0xe7a591, 0xe7a594, 0xe7a598, 0xe7a59b, 0xe7a59c, 
0xe7a5a7, 0xe7a5a9, 0xe7a5ab, 0xe7a5b2, 0xe7a5b9, 0xe7a5bb, 0xe7a5bc, 0xe7a5be, 
0xe7a68b, 0xe7a68c, 0xe7a691, 0xe7a693, 0xe7a694, 0xe7a695, 0xe7a696, 0xe7a698, 
0xe7a69b, 0xe7a69c, 0xe7a6a1, 0xe7a6a8, 0xe7a6a9, 0xe7a6ab, 0xe7a6af, 0xe7a6b1, 
0xe7a6b4, 0xe7a6b8, 0xe7a6bb, 0xe7a782, 0xe7a784, 0xe7a787, 0xe7a788, 0xe7a78a, 
0xe7a78f, 0xe7a794, 0xe7a796, 0xe7a79a, 0xe7a79d, 0xe7a79e, 
	/* 0x8fd1a1 */
0xe7a7a0, 0xe7a7a2, 0xe7a7a5, 0xe7a7aa, 0xe7a7ab, 0xe7a7ad, 0xe7a7b1, 0xe7a7b8, 
0xe7a7bc, 0xe7a882, 0xe7a883, 0xe7a887, 0xe7a889, 0xe7a88a, 0xe7a88c, 0xe7a891, 
0xe7a895, 0xe7a89b, 0xe7a89e, 0xe7a8a1, 0xe7a8a7, 0xe7a8ab, 0xe7a8ad, 0xe7a8af, 
0xe7a8b0, 0xe7a8b4, 0xe7a8b5, 0xe7a8b8, 0xe7a8b9, 0xe7a8ba, 0xe7a984, 0xe7a985, 
0xe7a987, 0xe7a988, 0xe7a98c, 0xe7a995, 0xe7a996, 0xe7a999, 0xe7a99c, 0xe7a99d, 
0xe7a99f, 0xe7a9a0, 0xe7a9a5, 0xe7a9a7, 0xe7a9aa, 0xe7a9ad, 0xe7a9b5, 0xe7a9b8, 
0xe7a9be, 0xe7aa80, 0xe7aa82, 0xe7aa85, 0xe7aa86, 0xe7aa8a, 0xe7aa8b, 0xe7aa90, 
0xe7aa91, 0xe7aa94, 0xe7aa9e, 0xe7aaa0, 0xe7aaa3, 0xe7aaac, 0xe7aab3, 0xe7aab5, 
0xe7aab9, 0xe7aabb, 0xe7aabc, 0xe7ab86, 0xe7ab89, 0xe7ab8c, 0xe7ab8e, 0xe7ab91, 
0xe7ab9b, 0xe7aba8, 0xe7aba9, 0xe7abab, 0xe7abac, 0xe7abb1, 0xe7abb4, 0xe7abbb, 
0xe7abbd, 0xe7abbe, 0xe7ac87, 0xe7ac94, 0xe7ac9f, 0xe7aca3, 0xe7aca7, 0xe7aca9, 
0xe7acaa, 0xe7acab, 0xe7acad, 0xe7acae, 0xe7acaf, 0xe7acb0, 
	/* 0x8fd2a1 */
0xe7acb1, 0xe7acb4, 0xe7acbd, 0xe7acbf, 0xe7ad80, 0xe7ad81, 0xe7ad87, 0xe7ad8e, 
0xe7ad95, 0xe7ada0, 0xe7ada4, 0xe7ada6, 0xe7ada9, 0xe7adaa, 0xe7adad, 0xe7adaf, 
0xe7adb2, 0xe7adb3, 0xe7adb7, 0xe7ae84, 0xe7ae89, 0xe7ae8e, 0xe7ae90, 0xe7ae91, 
0xe7ae96, 0xe7ae9b, 0xe7ae9e, 0xe7aea0, 0xe7aea5, 0xe7aeac, 0xe7aeaf, 0xe7aeb0, 
0xe7aeb2, 0xe7aeb5, 0xe7aeb6, 0xe7aeba, 0xe7aebb, 0xe7aebc, 0xe7aebd, 0xe7af82, 
0xe7af85, 0xe7af88, 0xe7af8a, 0xe7af94, 0xe7af96, 0xe7af97, 0xe7af99, 0xe7af9a, 
0xe7af9b, 0xe7afa8, 0xe7afaa, 0xe7afb2, 0xe7afb4, 0xe7afb5, 0xe7afb8, 0xe7afb9, 
0xe7afba, 0xe7afbc, 0xe7afbe, 0xe7b081, 0xe7b082, 0xe7b083, 0xe7b084, 0xe7b086, 
0xe7b089, 0xe7b08b, 0xe7b08c, 0xe7b08e, 0xe7b08f, 0xe7b099, 0xe7b09b, 0xe7b0a0, 
0xe7b0a5, 0xe7b0a6, 0xe7b0a8, 0xe7b0ac, 0xe7b0b1, 0xe7b0b3, 0xe7b0b4, 0xe7b0b6, 
0xe7b0b9, 0xe7b0ba, 0xe7b186, 0xe7b18a, 0xe7b195, 0xe7b191, 0xe7b192, 0xe7b193, 
0xe7b199, 0xe7b19a, 0xe7b19b, 0xe7b19c, 0xe7b19d, 0xe7b19e, 
	/* 0x8fd3a1 */
0xe7b1a1, 0xe7b1a3, 0xe7b1a7, 0xe7b1a9, 0xe7b1ad, 0xe7b1ae, 0xe7b1b0, 0xe7b1b2, 
0xe7b1b9, 0xe7b1bc, 0xe7b1bd, 0xe7b286, 0xe7b287, 0xe7b28f, 0xe7b294, 0xe7b29e, 
0xe7b2a0, 0xe7b2a6, 0xe7b2b0, 0xe7b2b6, 0xe7b2b7, 0xe7b2ba, 0xe7b2bb, 0xe7b2bc, 
0xe7b2bf, 0xe7b384, 0xe7b387, 0xe7b388, 0xe7b389, 0xe7b38d, 0xe7b38f, 0xe7b393, 
0xe7b394, 0xe7b395, 0xe7b397, 0xe7b399, 0xe7b39a, 0xe7b39d, 0xe7b3a6, 0xe7b3a9, 
0xe7b3ab, 0xe7b3b5, 0xe7b483, 0xe7b487, 0xe7b488, 0xe7b489, 0xe7b48f, 0xe7b491, 
0xe7b492, 0xe7b493, 0xe7b496, 0xe7b49d, 0xe7b49e, 0xe7b4a3, 0xe7b4a6, 0xe7b4aa, 
0xe7b4ad, 0xe7b4b1, 0xe7b4bc, 0xe7b4bd, 0xe7b4be, 0xe7b580, 0xe7b581, 0xe7b587, 
0xe7b588, 0xe7b58d, 0xe7b591, 0xe7b593, 0xe7b597, 0xe7b599, 0xe7b59a, 0xe7b59c, 
0xe7b59d, 0xe7b5a5, 0xe7b5a7, 0xe7b5aa, 0xe7b5b0, 0xe7b5b8, 0xe7b5ba, 0xe7b5bb, 
0xe7b5bf, 0xe7b681, 0xe7b682, 0xe7b683, 0xe7b685, 0xe7b686, 0xe7b688, 0xe7b68b, 
0xe7b68c, 0xe7b68d, 0xe7b691, 0xe7b696, 0xe7b697, 0xe7b69d, 
	/* 0x8fd4a1 */
0xe7b69e, 0xe7b6a6, 0xe7b6a7, 0xe7b6aa, 0xe7b6b3, 0xe7b6b6, 0xe7b6b7, 0xe7b6b9, 
0xe7b782, 0xe7b783, 0xe7b784, 0xe7b785, 0xe7b786, 0xe7b78c, 0xe7b78d, 0xe7b78e, 
0xe7b797, 0xe7b799, 0xe7b880, 0xe7b7a2, 0xe7b7a5, 0xe7b7a6, 0xe7b7aa, 0xe7b7ab, 
0xe7b7ad, 0xe7b7b1, 0xe7b7b5, 0xe7b7b6, 0xe7b7b9, 0xe7b7ba, 0xe7b888, 0xe7b890, 
0xe7b891, 0xe7b895, 0xe7b897, 0xe7b89c, 0xe7b89d, 0xe7b8a0, 0xe7b8a7, 0xe7b8a8, 
0xe7b8ac, 0xe7b8ad, 0xe7b8af, 0xe7b8b3, 0xe7b8b6, 0xe7b8bf, 0xe7b984, 0xe7b985, 
0xe7b987, 0xe7b98e, 0xe7b990, 0xe7b992, 0xe7b998, 0xe7b99f, 0xe7b9a1, 0xe7b9a2, 
0xe7b9a5, 0xe7b9ab, 0xe7b9ae, 0xe7b9af, 0xe7b9b3, 0xe7b9b8, 0xe7b9be, 0xe7ba81, 
0xe7ba86, 0xe7ba87, 0xe7ba8a, 0xe7ba8d, 0xe7ba91, 0xe7ba95, 0xe7ba98, 0xe7ba9a, 
0xe7ba9d, 0xe7ba9e, 0xe7bcbc, 0xe7bcbb, 0xe7bcbd, 0xe7bcbe, 0xe7bcbf, 0xe7bd83, 
0xe7bd84, 0xe7bd87, 0xe7bd8f, 0xe7bd92, 0xe7bd93, 0xe7bd9b, 0xe7bd9c, 0xe7bd9d, 
0xe7bda1, 0xe7bda3, 0xe7bda4, 0xe7bda5, 0xe7bda6, 0xe7bdad, 
	/* 0x8fd5a1 */
0xe7bdb1, 0xe7bdbd, 0xe7bdbe, 0xe7bdbf, 0xe7be80, 0xe7be8b, 0xe7be8d, 0xe7be8f, 
0xe7be90, 0xe7be91, 0xe7be96, 0xe7be97, 0xe7be9c, 0xe7bea1, 0xe7bea2, 0xe7bea6, 
0xe7beaa, 0xe7bead, 0xe7beb4, 0xe7bebc, 0xe7bebf, 0xe7bf80, 0xe7bf83, 0xe7bf88, 
0xe7bf8e, 0xe7bf8f, 0xe7bf9b, 0xe7bf9f, 0xe7bfa3, 0xe7bfa5, 0xe7bfa8, 0xe7bfac, 
0xe7bfae, 0xe7bfaf, 0xe7bfb2, 0xe7bfba, 0xe7bfbd, 0xe7bfbe, 0xe7bfbf, 0xe88087, 
0xe88088, 0xe8808a, 0xe8808d, 0xe8808e, 0xe8808f, 0xe88091, 0xe88093, 0xe88094, 
0xe88096, 0xe8809d, 0xe8809e, 0xe8809f, 0xe880a0, 0xe880a4, 0xe880a6, 0xe880ac, 
0xe880ae, 0xe880b0, 0xe880b4, 0xe880b5, 0xe880b7, 0xe880b9, 0xe880ba, 0xe880bc, 
0xe880be, 0xe88180, 0xe88184, 0xe881a0, 0xe881a4, 0xe881a6, 0xe881ad, 0xe881b1, 
0xe881b5, 0xe88281, 0xe88288, 0xe8828e, 0xe8829c, 0xe8829e, 0xe882a6, 0xe882a7, 
0xe882ab, 0xe882b8, 0xe882b9, 0xe88388, 0xe8838d, 0xe8838f, 0xe88392, 0xe88394, 
0xe88395, 0xe88397, 0xe88398, 0xe883a0, 0xe883ad, 0xe883ae, 
	/* 0x8fd6a1 */
0xe883b0, 0xe883b2, 0xe883b3, 0xe883b6, 0xe883b9, 0xe883ba, 0xe883be, 0xe88483, 
0xe8848b, 0xe88496, 0xe88497, 0xe88498, 0xe8849c, 0xe8849e, 0xe884a0, 0xe884a4, 
0xe884a7, 0xe884ac, 0xe884b0, 0xe884b5, 0xe884ba, 0xe884bc, 0xe88585, 0xe88587, 
0xe8858a, 0xe8858c, 0xe88592, 0xe88597, 0xe885a0, 0xe885a1, 0xe885a7, 0xe885a8, 
0xe885a9, 0xe885ad, 0xe885af, 0xe885b7, 0xe88681, 0xe88690, 0xe88684, 0xe88685, 
0xe88686, 0xe8868b, 0xe8868e, 0xe88696, 0xe88698, 0xe8869b, 0xe8869e, 0xe886a2, 
0xe886ae, 0xe886b2, 0xe886b4, 0xe886bb, 0xe8878b, 0xe88783, 0xe88785, 0xe8878a, 
0xe8878e, 0xe8878f, 0xe88795, 0xe88797, 0xe8879b, 0xe8879d, 0xe8879e, 0xe887a1, 
0xe887a4, 0xe887ab, 0xe887ac, 0xe887b0, 0xe887b1, 0xe887b2, 0xe887b5, 0xe887b6, 
0xe887b8, 0xe887b9, 0xe887bd, 0xe887bf, 0xe88880, 0xe88883, 0xe8888f, 0xe88893, 
0xe88894, 0xe88899, 0xe8889a, 0xe8889d, 0xe888a1, 0xe888a2, 0xe888a8, 0xe888b2, 
0xe888b4, 0xe888ba, 0xe88983, 0xe88984, 0xe88985, 0xe88986, 
	/* 0x8fd7a1 */
0xe8898b, 0xe8898e, 0xe8898f, 0xe88991, 0xe88996, 0xe8899c, 0xe889a0, 0xe889a3, 
0xe889a7, 0xe889ad, 0xe889b4, 0xe889bb, 0xe889bd, 0xe889bf, 0xe88a80, 0xe88a81, 
0xe88a83, 0xe88a84, 0xe88a87, 0xe88a89, 0xe88a8a, 0xe88a8e, 0xe88a91, 0xe88a94, 
0xe88a96, 0xe88a98, 0xe88a9a, 0xe88a9b, 0xe88aa0, 0xe88aa1, 0xe88aa3, 0xe88aa4, 
0xe88aa7, 0xe88aa8, 0xe88aa9, 0xe88aaa, 0xe88aae, 0xe88ab0, 0xe88ab2, 0xe88ab4, 
0xe88ab7, 0xe88aba, 0xe88abc, 0xe88abe, 0xe88abf, 0xe88b86, 0xe88b90, 0xe88b95, 
0xe88b9a, 0xe88ba0, 0xe88ba2, 0xe88ba4, 0xe88ba8, 0xe88baa, 0xe88bad, 0xe88baf, 
0xe88bb6, 0xe88bb7, 0xe88bbd, 0xe88bbe, 0xe88c80, 0xe88c81, 0xe88c87, 0xe88c88, 
0xe88c8a, 0xe88c8b, 0xe88d94, 0xe88c9b, 0xe88c9d, 0xe88c9e, 0xe88c9f, 0xe88ca1, 
0xe88ca2, 0xe88cac, 0xe88cad, 0xe88cae, 0xe88cb0, 0xe88cb3, 0xe88cb7, 0xe88cba, 
0xe88cbc, 0xe88cbd, 0xe88d82, 0xe88d83, 0xe88d84, 0xe88d87, 0xe88d8d, 0xe88d8e, 
0xe88d91, 0xe88d95, 0xe88d96, 0xe88d97, 0xe88db0, 0xe88db8, 
	/* 0x8fd8a1 */
0xe88dbd, 0xe88dbf, 0xe88e80, 0xe88e82, 0xe88e84, 0xe88e86, 0xe88e8d, 0xe88e92, 
0xe88e94, 0xe88e95, 0xe88e98, 0xe88e99, 0xe88e9b, 0xe88e9c, 0xe88e9d, 0xe88ea6, 
0xe88ea7, 0xe88ea9, 0xe88eac, 0xe88ebe, 0xe88ebf, 0xe88f80, 0xe88f87, 0xe88f89, 
0xe88f8f, 0xe88f90, 0xe88f91, 0xe88f94, 0xe88f9d, 0xe88d93, 0xe88fa8, 0xe88faa, 
0xe88fb6, 0xe88fb8, 0xe88fb9, 0xe88fbc, 0xe89081, 0xe89086, 0xe8908a, 0xe8908f, 
0xe89091, 0xe89095, 0xe89099, 0xe88ead, 0xe890af, 0xe890b9, 0xe89185, 0xe89187, 
0xe89188, 0xe8918a, 0xe8918d, 0xe8918f, 0xe89191, 0xe89192, 0xe89196, 0xe89198, 
0xe89199, 0xe8919a, 0xe8919c, 0xe891a0, 0xe891a4, 0xe891a5, 0xe891a7, 0xe891aa, 
0xe891b0, 0xe891b3, 0xe891b4, 0xe891b6, 0xe891b8, 0xe891bc, 0xe891bd, 0xe89281, 
0xe89285, 0xe89292, 0xe89293, 0xe89295, 0xe8929e, 0xe892a6, 0xe892a8, 0xe892a9, 
0xe892aa, 0xe892af, 0xe892b1, 0xe892b4, 0xe892ba, 0xe892bd, 0xe892be, 0xe89380, 
0xe89382, 0xe89387, 0xe89388, 0xe8938c, 0xe8938f, 0xe89393, 
	/* 0x8fd9a1 */
0xe8939c, 0xe893a7, 0xe893aa, 0xe893af, 0xe893b0, 0xe893b1, 0xe893b2, 0xe893b7, 
0xe894b2, 0xe893ba, 0xe893bb, 0xe893bd, 0xe89482, 0xe89483, 0xe89487, 0xe8948c, 
0xe8948e, 0xe89490, 0xe8949c, 0xe8949e, 0xe894a2, 0xe894a3, 0xe894a4, 0xe894a5, 
0xe894a7, 0xe894aa, 0xe894ab, 0xe894af, 0xe894b3, 0xe894b4, 0xe894b6, 0xe894bf, 
0xe89586, 0xe8958f, 0xe89590, 0xe89591, 0xe89592, 0xe89593, 0xe89596, 0xe89599, 
0xe8959c, 0xe8959d, 0xe8959e, 0xe8959f, 0xe895a0, 0xe895a1, 0xe895a2, 0xe895a4, 
0xe895ab, 0xe895af, 0xe895b9, 0xe895ba, 0xe895bb, 0xe895bd, 0xe895bf, 0xe89681, 
0xe89685, 0xe89686, 0xe89689, 0xe8968b, 0xe8968c, 0xe8968f, 0xe89693, 0xe89698, 
0xe8969d, 0xe8969f, 0xe896a0, 0xe896a2, 0xe896a5, 0xe896a7, 0xe896b4, 0xe896b6, 
0xe896b7, 0xe896b8, 0xe896bc, 0xe896bd, 0xe896be, 0xe896bf, 0xe89782, 0xe89787, 
0xe8978a, 0xe8978b, 0xe8978e, 0xe896ad, 0xe89798, 0xe8979a, 0xe8979f, 0xe897a0, 
0xe897a6, 0xe897a8, 0xe897ad, 0xe897b3, 0xe897b6, 0xe897bc, 
	/* 0x8fdaa1 */
0xe897bf, 0xe89880, 0xe89884, 0xe89885, 0xe8988d, 0xe8988e, 0xe89890, 0xe89891, 
0xe89892, 0xe89898, 0xe89899, 0xe8989b, 0xe8989e, 0xe898a1, 0xe898a7, 0xe898a9, 
0xe898b6, 0xe898b8, 0xe898ba, 0xe898bc, 0xe898bd, 0xe89980, 0xe89982, 0xe89986, 
0xe89992, 0xe89993, 0xe89996, 0xe89997, 0xe89998, 0xe89999, 0xe8999d, 0xe899a0, 
0xe899a1, 0xe899a2, 0xe899a3, 0xe899a4, 0xe899a9, 0xe899ac, 0xe899af, 0xe899b5, 
0xe899b6, 0xe899b7, 0xe899ba, 0xe89a8d, 0xe89a91, 0xe89a96, 0xe89a98, 0xe89a9a, 
0xe89a9c, 0xe89aa1, 0xe89aa6, 0xe89aa7, 0xe89aa8, 0xe89aad, 0xe89ab1, 0xe89ab3, 
0xe89ab4, 0xe89ab5, 0xe89ab7, 0xe89ab8, 0xe89ab9, 0xe89abf, 0xe89b80, 0xe89b81, 
0xe89b83, 0xe89b85, 0xe89b91, 0xe89b92, 0xe89b95, 0xe89b97, 0xe89b9a, 0xe89b9c, 
0xe89ba0, 0xe89ba3, 0xe89ba5, 0xe89ba7, 0xe89a88, 0xe89bba, 0xe89bbc, 0xe89bbd, 
0xe89c84, 0xe89c85, 0xe89c87, 0xe89c8b, 0xe89c8e, 0xe89c8f, 0xe89c90, 0xe89c93, 
0xe89c94, 0xe89c99, 0xe89c9e, 0xe89c9f, 0xe89ca1, 0xe89ca3, 
	/* 0x8fdba1 */
0xe89ca8, 0xe89cae, 0xe89caf, 0xe89cb1, 0xe89cb2, 0xe89cb9, 0xe89cba, 0xe89cbc, 
0xe89cbd, 0xe89cbe, 0xe89d80, 0xe89d83, 0xe89d85, 0xe89d8d, 0xe89d98, 0xe89d9d, 
0xe89da1, 0xe89da4, 0xe89da5, 0xe89daf, 0xe89db1, 0xe89db2, 0xe89dbb, 0xe89e83, 
0xe89e84, 0xe89e85, 0xe89e86, 0xe89e87, 0xe89e88, 0xe89e89, 0xe89e8b, 0xe89e8c, 
0xe89e90, 0xe89e93, 0xe89e95, 0xe89e97, 0xe89e98, 0xe89e99, 0xe89e9e, 0xe89ea0, 
0xe89ea3, 0xe89ea7, 0xe89eac, 0xe89ead, 0xe89eae, 0xe89eb1, 0xe89eb5, 0xe89ebe, 
0xe89ebf, 0xe89f81, 0xe89f88, 0xe89f89, 0xe89f8a, 0xe89f8e, 0xe89f95, 0xe89f96, 
0xe89f99, 0xe89f9a, 0xe89f9c, 0xe89f9f, 0xe89fa2, 0xe89fa3, 0xe89fa4, 0xe89faa, 
0xe89fab, 0xe89fad, 0xe89fb1, 0xe89fb3, 0xe89fb8, 0xe89fba, 0xe89fbf, 0xe8a081, 
0xe8a083, 0xe8a086, 0xe8a089, 0xe8a08a, 0xe8a08b, 0xe8a090, 0xe8a099, 0xe8a092, 
0xe8a093, 0xe8a094, 0xe8a098, 0xe8a09a, 0xe8a09b, 0xe8a09c, 0xe8a09e, 0xe8a09f, 
0xe8a0a8, 0xe8a0ad, 0xe8a0ae, 0xe8a0b0, 0xe8a0b2, 0xe8a0b5, 
	/* 0x8fdca1 */
0xe8a0ba, 0xe8a0bc, 0xe8a181, 0xe8a183, 0xe8a185, 0xe8a188, 0xe8a189, 0xe8a18a, 
0xe8a18b, 0xe8a18e, 0xe8a191, 0xe8a195, 0xe8a196, 0xe8a198, 0xe8a19a, 0xe8a19c, 
0xe8a19f, 0xe8a1a0, 0xe8a1a4, 0xe8a1a9, 0xe8a1b1, 0xe8a1b9, 0xe8a1bb, 0xe8a280, 
0xe8a298, 0xe8a29a, 0xe8a29b, 0xe8a29c, 0xe8a29f, 0xe8a2a0, 0xe8a2a8, 0xe8a2aa, 
0xe8a2ba, 0xe8a2bd, 0xe8a2be, 0xe8a380, 0xe8a38a, 0xe8a38b, 0xe8a38c, 0xe8a38d, 
0xe8a38e, 0xe8a391, 0xe8a392, 0xe8a393, 0xe8a39b, 0xe8a39e, 0xe8a3a7, 0xe8a3af, 
0xe8a3b0, 0xe8a3b1, 0xe8a3b5, 0xe8a3b7, 0xe8a481, 0xe8a486, 0xe8a48d, 0xe8a48e, 
0xe8a48f, 0xe8a495, 0xe8a496, 0xe8a498, 0xe8a499, 0xe8a49a, 0xe8a49c, 0xe8a4a0, 
0xe8a4a6, 0xe8a4a7, 0xe8a4a8, 0xe8a4b0, 0xe8a4b1, 0xe8a4b2, 0xe8a4b5, 0xe8a4b9, 
0xe8a4ba, 0xe8a4be, 0xe8a580, 0xe8a582, 0xe8a585, 0xe8a586, 0xe8a589, 0xe8a58f, 
0xe8a592, 0xe8a597, 0xe8a59a, 0xe8a59b, 0xe8a59c, 0xe8a5a1, 0xe8a5a2, 0xe8a5a3, 
0xe8a5ab, 0xe8a5ae, 0xe8a5b0, 0xe8a5b3, 0xe8a5b5, 0xe8a5ba, 
	/* 0x8fdda1 */
0xe8a5bb, 0xe8a5bc, 0xe8a5bd, 0xe8a689, 0xe8a68d, 0xe8a690, 0xe8a694, 0xe8a695, 
0xe8a69b, 0xe8a69c, 0xe8a69f, 0xe8a6a0, 0xe8a6a5, 0xe8a6b0, 0xe8a6b4, 0xe8a6b5, 
0xe8a6b6, 0xe8a6b7, 0xe8a6bc, 0xe8a794, 0xe8a795, 0xe8a796, 0xe8a797, 0xe8a798, 
0xe8a7a5, 0xe8a7a9, 0xe8a7ab, 0xe8a7ad, 0xe8a7b1, 0xe8a7b3, 0xe8a7b6, 0xe8a7b9, 
0xe8a7bd, 0xe8a7bf, 0xe8a884, 0xe8a885, 0xe8a887, 0xe8a88f, 0xe8a891, 0xe8a892, 
0xe8a894, 0xe8a895, 0xe8a89e, 0xe8a8a0, 0xe8a8a2, 0xe8a8a4, 0xe8a8a6, 0xe8a8ab, 
0xe8a8ac, 0xe8a8af, 0xe8a8b5, 0xe8a8b7, 0xe8a8bd, 0xe8a8be, 0xe8a980, 0xe8a983, 
0xe8a985, 0xe8a987, 0xe8a989, 0xe8a98d, 0xe8a98e, 0xe8a993, 0xe8a996, 0xe8a997, 
0xe8a998, 0xe8a99c, 0xe8a99d, 0xe8a9a1, 0xe8a9a5, 0xe8a9a7, 0xe8a9b5, 0xe8a9b6, 
0xe8a9b7, 0xe8a9b9, 0xe8a9ba, 0xe8a9bb, 0xe8a9be, 0xe8a9bf, 0xe8aa80, 0xe8aa83, 
0xe8aa86, 0xe8aa8b, 0xe8aa8f, 0xe8aa90, 0xe8aa92, 0xe8aa96, 0xe8aa97, 0xe8aa99, 
0xe8aa9f, 0xe8aaa7, 0xe8aaa9, 0xe8aaae, 0xe8aaaf, 0xe8aab3, 
	/* 0x8fdea1 */
0xe8aab6, 0xe8aab7, 0xe8aabb, 0xe8aabe, 0xe8ab83, 0xe8ab86, 0xe8ab88, 0xe8ab89, 
0xe8ab8a, 0xe8ab91, 0xe8ab93, 0xe8ab94, 0xe8ab95, 0xe8ab97, 0xe8ab9d, 0xe8ab9f, 
0xe8abac, 0xe8abb0, 0xe8abb4, 0xe8abb5, 0xe8abb6, 0xe8abbc, 0xe8abbf, 0xe8ac85, 
0xe8ac86, 0xe8ac8b, 0xe8ac91, 0xe8ac9c, 0xe8ac9e, 0xe8ac9f, 0xe8ac8a, 0xe8acad, 
0xe8acb0, 0xe8acb7, 0xe8acbc, 0xe8ad82, 0xe8ad83, 0xe8ad84, 0xe8ad85, 0xe8ad86, 
0xe8ad88, 0xe8ad92, 0xe8ad93, 0xe8ad94, 0xe8ad99, 0xe8ad8d, 0xe8ad9e, 0xe8ada3, 
0xe8adad, 0xe8adb6, 0xe8adb8, 0xe8adb9, 0xe8adbc, 0xe8adbe, 0xe8ae81, 0xe8ae84, 
0xe8ae85, 0xe8ae8b, 0xe8ae8d, 0xe8ae8f, 0xe8ae94, 0xe8ae95, 0xe8ae9c, 0xe8ae9e, 
0xe8ae9f, 0xe8b0b8, 0xe8b0b9, 0xe8b0bd, 0xe8b0be, 0xe8b185, 0xe8b187, 0xe8b189, 
0xe8b18b, 0xe8b18f, 0xe8b191, 0xe8b193, 0xe8b194, 0xe8b197, 0xe8b198, 0xe8b19b, 
0xe8b19d, 0xe8b199, 0xe8b1a3, 0xe8b1a4, 0xe8b1a6, 0xe8b1a8, 0xe8b1a9, 0xe8b1ad, 
0xe8b1b3, 0xe8b1b5, 0xe8b1b6, 0xe8b1bb, 0xe8b1be, 0xe8b286, 
	/* 0x8fdfa1 */
0xe8b287, 0xe8b28b, 0xe8b290, 0xe8b292, 0xe8b293, 0xe8b299, 0xe8b29b, 0xe8b29c, 
0xe8b2a4, 0xe8b2b9, 0xe8b2ba, 0xe8b385, 0xe8b386, 0xe8b389, 0xe8b38b, 0xe8b38f, 
0xe8b396, 0xe8b395, 0xe8b399, 0xe8b39d, 0xe8b3a1, 0xe8b3a8, 0xe8b3ac, 0xe8b3af, 
0xe8b3b0, 0xe8b3b2, 0xe8b3b5, 0xe8b3b7, 0xe8b3b8, 0xe8b3be, 0xe8b3bf, 0xe8b481, 
0xe8b483, 0xe8b489, 0xe8b492, 0xe8b497, 0xe8b49b, 0xe8b5a5, 0xe8b5a9, 0xe8b5ac, 
0xe8b5ae, 0xe8b5bf, 0xe8b682, 0xe8b684, 0xe8b688, 0xe8b68d, 0xe8b690, 0xe8b691, 
0xe8b695, 0xe8b69e, 0xe8b69f, 0xe8b6a0, 0xe8b6a6, 0xe8b6ab, 0xe8b6ac, 0xe8b6af, 
0xe8b6b2, 0xe8b6b5, 0xe8b6b7, 0xe8b6b9, 0xe8b6bb, 0xe8b780, 0xe8b785, 0xe8b786, 
0xe8b787, 0xe8b788, 0xe8b78a, 0xe8b78e, 0xe8b791, 0xe8b794, 0xe8b795, 0xe8b797, 
0xe8b799, 0xe8b7a4, 0xe8b7a5, 0xe8b7a7, 0xe8b7ac, 0xe8b7b0, 0xe8b6bc, 0xe8b7b1, 
0xe8b7b2, 0xe8b7b4, 0xe8b7bd, 0xe8b881, 0xe8b884, 0xe8b885, 0xe8b886, 0xe8b88b, 
0xe8b891, 0xe8b894, 0xe8b896, 0xe8b8a0, 0xe8b8a1, 0xe8b8a2, 
	/* 0x8fe0a1 */
0xe8b8a3, 0xe8b8a6, 0xe8b8a7, 0xe8b8b1, 0xe8b8b3, 0xe8b8b6, 0xe8b8b7, 0xe8b8b8, 
0xe8b8b9, 0xe8b8bd, 0xe8b980, 0xe8b981, 0xe8b98b, 0xe8b98d, 0xe8b98e, 0xe8b98f, 
0xe8b994, 0xe8b99b, 0xe8b99c, 0xe8b99d, 0xe8b99e, 0xe8b9a1, 0xe8b9a2, 0xe8b9a9, 
0xe8b9ac, 0xe8b9ad, 0xe8b9af, 0xe8b9b0, 0xe8b9b1, 0xe8b9b9, 0xe8b9ba, 0xe8b9bb, 
0xe8ba82, 0xe8ba83, 0xe8ba89, 0xe8ba90, 0xe8ba92, 0xe8ba95, 0xe8ba9a, 0xe8ba9b, 
0xe8ba9d, 0xe8ba9e, 0xe8baa2, 0xe8baa7, 0xe8baa9, 0xe8baad, 0xe8baae, 0xe8bab3, 
0xe8bab5, 0xe8baba, 0xe8babb, 0xe8bb80, 0xe8bb81, 0xe8bb83, 0xe8bb84, 0xe8bb87, 
0xe8bb8f, 0xe8bb91, 0xe8bb94, 0xe8bb9c, 0xe8bba8, 0xe8bbae, 0xe8bbb0, 0xe8bbb1, 
0xe8bbb7, 0xe8bbb9, 0xe8bbba, 0xe8bbad, 0xe8bc80, 0xe8bc82, 0xe8bc87, 0xe8bc88, 
0xe8bc8f, 0xe8bc90, 0xe8bc96, 0xe8bc97, 0xe8bc98, 0xe8bc9e, 0xe8bca0, 0xe8bca1, 
0xe8bca3, 0xe8bca5, 0xe8bca7, 0xe8bca8, 0xe8bcac, 0xe8bcad, 0xe8bcae, 0xe8bcb4, 
0xe8bcb5, 0xe8bcb6, 0xe8bcb7, 0xe8bcba, 0xe8bd80, 0xe8bd81, 
	/* 0x8fe1a1 */
0xe8bd83, 0xe8bd87, 0xe8bd8f, 0xe8bd91, 0xe8bd92, 0xe8bd93, 0xe8bd94, 0xe8bd95, 
0xe8bd98, 0xe8bd9d, 0xe8bd9e, 0xe8bda5, 0xe8be9d, 0xe8bea0, 0xe8bea1, 0xe8bea4, 
0xe8bea5, 0xe8bea6, 0xe8beb5, 0xe8beb6, 0xe8beb8, 0xe8bebe, 0xe8bf80, 0xe8bf81, 
0xe8bf86, 0xe8bf8a, 0xe8bf8b, 0xe8bf8d, 0xe8bf90, 0xe8bf92, 0xe8bf93, 0xe8bf95, 
0xe8bfa0, 0xe8bfa3, 0xe8bfa4, 0xe8bfa8, 0xe8bfae, 0xe8bfb1, 0xe8bfb5, 0xe8bfb6, 
0xe8bfbb, 0xe8bfbe, 0xe98082, 0xe98084, 0xe98088, 0xe9808c, 0xe98098, 0xe9809b, 
0xe980a8, 0xe980a9, 0xe980af, 0xe980aa, 0xe980ac, 0xe980ad, 0xe980b3, 0xe980b4, 
0xe980b7, 0xe980bf, 0xe98183, 0xe98184, 0xe9818c, 0xe9819b, 0xe9819d, 0xe981a2, 
0xe981a6, 0xe981a7, 0xe981ac, 0xe981b0, 0xe981b4, 0xe981b9, 0xe98285, 0xe98288, 
0xe9828b, 0xe9828c, 0xe9828e, 0xe98290, 0xe98295, 0xe98297, 0xe98298, 0xe98299, 
0xe9829b, 0xe982a0, 0xe982a1, 0xe982a2, 0xe982a5, 0xe982b0, 0xe982b2, 0xe982b3, 
0xe982b4, 0xe982b6, 0xe982bd, 0xe9838c, 0xe982be, 0xe98383, 
	/* 0x8fe2a1 */
0xe98384, 0xe98385, 0xe98387, 0xe98388, 0xe98395, 0xe98397, 0xe98398, 0xe98399, 
0xe9839c, 0xe9839d, 0xe9839f, 0xe983a5, 0xe98392, 0xe983b6, 0xe983ab, 0xe983af, 
0xe983b0, 0xe983b4, 0xe983be, 0xe983bf, 0xe98480, 0xe98484, 0xe98485, 0xe98486, 
0xe98488, 0xe9848d, 0xe98490, 0xe98494, 0xe98496, 0xe98497, 0xe98498, 0xe9849a, 
0xe9849c, 0xe9849e, 0xe984a0, 0xe984a5, 0xe984a2, 0xe984a3, 0xe984a7, 0xe984a9, 
0xe984ae, 0xe984af, 0xe984b1, 0xe984b4, 0xe984b6, 0xe984b7, 0xe984b9, 0xe984ba, 
0xe984bc, 0xe984bd, 0xe98583, 0xe98587, 0xe98588, 0xe9858f, 0xe98593, 0xe98597, 
0xe98599, 0xe9859a, 0xe9859b, 0xe985a1, 0xe985a4, 0xe985a7, 0xe985ad, 0xe985b4, 
0xe985b9, 0xe985ba, 0xe985bb, 0xe98681, 0xe98683, 0xe98685, 0xe98686, 0xe9868a, 
0xe9868e, 0xe98691, 0xe98693, 0xe98694, 0xe98695, 0xe98698, 0xe9869e, 0xe986a1, 
0xe986a6, 0xe986a8, 0xe986ac, 0xe986ad, 0xe986ae, 0xe986b0, 0xe986b1, 0xe986b2, 
0xe986b3, 0xe986b6, 0xe986bb, 0xe986bc, 0xe986bd, 0xe986bf, 
	/* 0x8fe3a1 */
0xe98782, 0xe98783, 0xe98785, 0xe98793, 0xe98794, 0xe98797, 0xe98799, 0xe9879a, 
0xe9879e, 0xe987a4, 0xe987a5, 0xe987a9, 0xe987aa, 0xe987ac, 0xe987ad, 0xe987ae, 
0xe987af, 0xe987b0, 0xe987b1, 0xe987b7, 0xe987b9, 0xe987bb, 0xe987bd, 0xe98880, 
0xe98881, 0xe98884, 0xe98885, 0xe98886, 0xe98887, 0xe98889, 0xe9888a, 0xe9888c, 
0xe98890, 0xe98892, 0xe98893, 0xe98896, 0xe98898, 0xe9889c, 0xe9889d, 0xe988a3, 
0xe988a4, 0xe988a5, 0xe988a6, 0xe988a8, 0xe988ae, 0xe988af, 0xe988b0, 0xe988b3, 
0xe988b5, 0xe988b6, 0xe988b8, 0xe988b9, 0xe988ba, 0xe988bc, 0xe988be, 0xe98980, 
0xe98982, 0xe98983, 0xe98986, 0xe98987, 0xe9898a, 0xe9898d, 0xe9898e, 0xe9898f, 
0xe98991, 0xe98998, 0xe98999, 0xe9899c, 0xe9899d, 0xe989a0, 0xe989a1, 0xe989a5, 
0xe989a7, 0xe989a8, 0xe989a9, 0xe989ae, 0xe989af, 0xe989b0, 0xe989b5, 0xe989b6, 
0xe989b7, 0xe989b8, 0xe989b9, 0xe989bb, 0xe989bc, 0xe989bd, 0xe989bf, 0xe98a88, 
0xe98a89, 0xe98a8a, 0xe98a8d, 0xe98a8e, 0xe98a92, 0xe98a97, 
	/* 0x8fe4a1 */
0xe98a99, 0xe98a9f, 0xe98aa0, 0xe98aa4, 0xe98aa5, 0xe98aa7, 0xe98aa8, 0xe98aab, 
0xe98aaf, 0xe98ab2, 0xe98ab6, 0xe98ab8, 0xe98aba, 0xe98abb, 0xe98abc, 0xe98abd, 
0xe98abf, 0xe98b80, 0xe98b81, 0xe98b82, 0xe98b83, 0xe98b85, 0xe98b86, 0xe98b87, 
0xe98b88, 0xe98b8b, 0xe98b8c, 0xe98b8d, 0xe98b8e, 0xe98b90, 0xe98b93, 0xe98b95, 
0xe98b97, 0xe98b98, 0xe98b99, 0xe98b9c, 0xe98b9d, 0xe98b9f, 0xe98ba0, 0xe98ba1, 
0xe98ba3, 0xe98ba5, 0xe98ba7, 0xe98ba8, 0xe98bac, 0xe98bae, 0xe98bb0, 0xe98bb9, 
0xe98bbb, 0xe98bbf, 0xe98c80, 0xe98c82, 0xe98c88, 0xe98c8d, 0xe98c91, 0xe98c94, 
0xe98c95, 0xe98c9c, 0xe98c9d, 0xe98c9e, 0xe98c9f, 0xe98ca1, 0xe98ca4, 0xe98ca5, 
0xe98ca7, 0xe98ca9, 0xe98caa, 0xe98cb3, 0xe98cb4, 0xe98cb6, 0xe98cb7, 0xe98d87, 
0xe98d88, 0xe98d89, 0xe98d90, 0xe98d91, 0xe98d92, 0xe98d95, 0xe98d97, 0xe98d98, 
0xe98d9a, 0xe98d9e, 0xe98da4, 0xe98da5, 0xe98da7, 0xe98da9, 0xe98daa, 0xe98dad, 
0xe98daf, 0xe98db0, 0xe98db1, 0xe98db3, 0xe98db4, 0xe98db6, 
	/* 0x8fe5a1 */
0xe98dba, 0xe98dbd, 0xe98dbf, 0xe98e80, 0xe98e81, 0xe98e82, 0xe98e88, 0xe98e8a, 
0xe98e8b, 0xe98e8d, 0xe98e8f, 0xe98e92, 0xe98e95, 0xe98e98, 0xe98e9b, 0xe98e9e, 
0xe98ea1, 0xe98ea3, 0xe98ea4, 0xe98ea6, 0xe98ea8, 0xe98eab, 0xe98eb4, 0xe98eb5, 
0xe98eb6, 0xe98eba, 0xe98ea9, 0xe98f81, 0xe98f84, 0xe98f85, 0xe98f86, 0xe98f87, 
0xe98f89, 0xe98f8a, 0xe98f8b, 0xe98f8c, 0xe98f8d, 0xe98f93, 0xe98f99, 0xe98f9c, 
0xe98f9e, 0xe98f9f, 0xe98fa2, 0xe98fa6, 0xe98fa7, 0xe98fb9, 0xe98fb7, 0xe98fb8, 
0xe98fba, 0xe98fbb, 0xe98fbd, 0xe99081, 0xe99082, 0xe99084, 0xe99088, 0xe99089, 
0xe9908d, 0xe9908e, 0xe9908f, 0xe99095, 0xe99096, 0xe99097, 0xe9909f, 0xe990ae, 
0xe990af, 0xe990b1, 0xe990b2, 0xe990b3, 0xe990b4, 0xe990bb, 0xe990bf, 0xe990bd, 
0xe99183, 0xe99185, 0xe99188, 0xe9918a, 0xe9918c, 0xe99195, 0xe99199, 0xe9919c, 
0xe9919f, 0xe991a1, 0xe991a3, 0xe991a8, 0xe991ab, 0xe991ad, 0xe991ae, 0xe991af, 
0xe991b1, 0xe991b2, 0xe99284, 0xe99283, 0xe995b8, 0xe995b9, 
	/* 0x8fe6a1 */
0xe995be, 0xe99684, 0xe99688, 0xe9968c, 0xe9968d, 0xe9968e, 0xe9969d, 0xe9969e, 
0xe9969f, 0xe996a1, 0xe996a6, 0xe996a9, 0xe996ab, 0xe996ac, 0xe996b4, 0xe996b6, 
0xe996ba, 0xe996bd, 0xe996bf, 0xe99786, 0xe99788, 0xe99789, 0xe9978b, 0xe99790, 
0xe99791, 0xe99792, 0xe99793, 0xe99799, 0xe9979a, 0xe9979d, 0xe9979e, 0xe9979f, 
0xe997a0, 0xe997a4, 0xe997a6, 0xe9989d, 0xe9989e, 0xe998a2, 0xe998a4, 0xe998a5, 
0xe998a6, 0xe998ac, 0xe998b1, 0xe998b3, 0xe998b7, 0xe998b8, 0xe998b9, 0xe998ba, 
0xe998bc, 0xe998bd, 0xe99981, 0xe99992, 0xe99994, 0xe99996, 0xe99997, 0xe99998, 
0xe999a1, 0xe999ae, 0xe999b4, 0xe999bb, 0xe999bc, 0xe999be, 0xe999bf, 0xe99a81, 
0xe99a82, 0xe99a83, 0xe99a84, 0xe99a89, 0xe99a91, 0xe99a96, 0xe99a9a, 0xe99a9d, 
0xe99a9f, 0xe99aa4, 0xe99aa5, 0xe99aa6, 0xe99aa9, 0xe99aae, 0xe99aaf, 0xe99ab3, 
0xe99aba, 0xe99b8a, 0xe99b92, 0xe5b6b2, 0xe99b98, 0xe99b9a, 0xe99b9d, 0xe99b9e, 
0xe99b9f, 0xe99ba9, 0xe99baf, 0xe99bb1, 0xe99bba, 0xe99c82, 
	/* 0x8fe7a1 */
0xe99c83, 0xe99c85, 0xe99c89, 0xe99c9a, 0xe99c9b, 0xe99c9d, 0xe99ca1, 0xe99ca2, 
0xe99ca3, 0xe99ca8, 0xe99cb1, 0xe99cb3, 0xe99d81, 0xe99d83, 0xe99d8a, 0xe99d8e, 
0xe99d8f, 0xe99d95, 0xe99d97, 0xe99d98, 0xe99d9a, 0xe99d9b, 0xe99da3, 0xe99da7, 
0xe99daa, 0xe99dae, 0xe99db3, 0xe99db6, 0xe99db7, 0xe99db8, 0xe99dbb, 0xe99dbd, 
0xe99dbf, 0xe99e80, 0xe99e89, 0xe99e95, 0xe99e96, 0xe99e97, 0xe99e99, 0xe99e9a, 
0xe99e9e, 0xe99e9f, 0xe99ea2, 0xe99eac, 0xe99eae, 0xe99eb1, 0xe99eb2, 0xe99eb5, 
0xe99eb6, 0xe99eb8, 0xe99eb9, 0xe99eba, 0xe99ebc, 0xe99ebe, 0xe99ebf, 0xe99f81, 
0xe99f84, 0xe99f85, 0xe99f87, 0xe99f89, 0xe99f8a, 0xe99f8c, 0xe99f8d, 0xe99f8e, 
0xe99f90, 0xe99f91, 0xe99f94, 0xe99f97, 0xe99f98, 0xe99f99, 0xe99f9d, 0xe99f9e, 
0xe99fa0, 0xe99f9b, 0xe99fa1, 0xe99fa4, 0xe99faf, 0xe99fb1, 0xe99fb4, 0xe99fb7, 
0xe99fb8, 0xe99fba, 0xe9a087, 0xe9a08a, 0xe9a099, 0xe9a08d, 0xe9a08e, 0xe9a094, 
0xe9a096, 0xe9a09c, 0xe9a09e, 0xe9a0a0, 0xe9a0a3, 0xe9a0a6, 
	/* 0x8fe8a1 */
0xe9a0ab, 0xe9a0ae, 0xe9a0af, 0xe9a0b0, 0xe9a0b2, 0xe9a0b3, 0xe9a0b5, 0xe9a0a5, 
0xe9a0be, 0xe9a184, 0xe9a187, 0xe9a18a, 0xe9a191, 0xe9a192, 0xe9a193, 0xe9a196, 
0xe9a197, 0xe9a199, 0xe9a19a, 0xe9a1a2, 0xe9a1a3, 0xe9a1a5, 0xe9a1a6, 0xe9a1aa, 
0xe9a1ac, 0xe9a2ab, 0xe9a2ad, 0xe9a2ae, 0xe9a2b0, 0xe9a2b4, 0xe9a2b7, 0xe9a2b8, 
0xe9a2ba, 0xe9a2bb, 0xe9a2bf, 0xe9a382, 0xe9a385, 0xe9a388, 0xe9a38c, 0xe9a3a1, 
0xe9a3a3, 0xe9a3a5, 0xe9a3a6, 0xe9a3a7, 0xe9a3aa, 0xe9a3b3, 0xe9a3b6, 0xe9a482, 
0xe9a487, 0xe9a488, 0xe9a491, 0xe9a495, 0xe9a496, 0xe9a497, 0xe9a49a, 0xe9a49b, 
0xe9a49c, 0xe9a49f, 0xe9a4a2, 0xe9a4a6, 0xe9a4a7, 0xe9a4ab, 0xe9a4b1, 0xe9a4b2, 
0xe9a4b3, 0xe9a4b4, 0xe9a4b5, 0xe9a4b9, 0xe9a4ba, 0xe9a4bb, 0xe9a4bc, 0xe9a580, 
0xe9a581, 0xe9a586, 0xe9a587, 0xe9a588, 0xe9a58d, 0xe9a58e, 0xe9a594, 0xe9a598, 
0xe9a599, 0xe9a59b, 0xe9a59c, 0xe9a59e, 0xe9a59f, 0xe9a5a0, 0xe9a69b, 0xe9a69d, 
0xe9a69f, 0xe9a6a6, 0xe9a6b0, 0xe9a6b1, 0xe9a6b2, 0xe9a6b5, 
	/* 0x8fe9a1 */
0xe9a6b9, 0xe9a6ba, 0xe9a6bd, 0xe9a6bf, 0xe9a783, 0xe9a789, 0xe9a793, 0xe9a794, 
0xe9a799, 0xe9a79a, 0xe9a79c, 0xe9a79e, 0xe9a7a7, 0xe9a7aa, 0xe9a7ab, 0xe9a7ac, 
0xe9a7b0, 0xe9a7b4, 0xe9a7b5, 0xe9a7b9, 0xe9a7bd, 0xe9a7be, 0xe9a882, 0xe9a883, 
0xe9a884, 0xe9a88b, 0xe9a88c, 0xe9a890, 0xe9a891, 0xe9a896, 0xe9a89e, 0xe9a8a0, 
0xe9a8a2, 0xe9a8a3, 0xe9a8a4, 0xe9a8a7, 0xe9a8ad, 0xe9a8ae, 0xe9a8b3, 0xe9a8b5, 
0xe9a8b6, 0xe9a8b8, 0xe9a987, 0xe9a981, 0xe9a984, 0xe9a98a, 0xe9a98b, 0xe9a98c, 
0xe9a98e, 0xe9a991, 0xe9a994, 0xe9a996, 0xe9a99d, 0xe9aaaa, 0xe9aaac, 0xe9aaae, 
0xe9aaaf, 0xe9aab2, 0xe9aab4, 0xe9aab5, 0xe9aab6, 0xe9aab9, 0xe9aabb, 0xe9aabe, 
0xe9aabf, 0xe9ab81, 0xe9ab83, 0xe9ab86, 0xe9ab88, 0xe9ab8e, 0xe9ab90, 0xe9ab92, 
0xe9ab95, 0xe9ab96, 0xe9ab97, 0xe9ab9b, 0xe9ab9c, 0xe9aba0, 0xe9aba4, 0xe9aba5, 
0xe9aba7, 0xe9aba9, 0xe9abac, 0xe9abb2, 0xe9abb3, 0xe9abb5, 0xe9abb9, 0xe9abba, 
0xe9abbd, 0xe9abbf, 0xe9ac80, 0xe9ac81, 0xe9ac82, 0xe9ac83, 
	/* 0x8feaa1 */
0xe9ac84, 0xe9ac85, 0xe9ac88, 0xe9ac89, 0xe9ac8b, 0xe9ac8c, 0xe9ac8d, 0xe9ac8e, 
0xe9ac90, 0xe9ac92, 0xe9ac96, 0xe9ac99, 0xe9ac9b, 0xe9ac9c, 0xe9aca0, 0xe9aca6, 
0xe9acab, 0xe9acad, 0xe9acb3, 0xe9acb4, 0xe9acb5, 0xe9acb7, 0xe9acb9, 0xe9acba, 
0xe9acbd, 0xe9ad88, 0xe9ad8b, 0xe9ad8c, 0xe9ad95, 0xe9ad96, 0xe9ad97, 0xe9ad9b, 
0xe9ad9e, 0xe9ada1, 0xe9ada3, 0xe9ada5, 0xe9ada6, 0xe9ada8, 0xe9adaa, 0xe9adab, 
0xe9adac, 0xe9adad, 0xe9adae, 0xe9adb3, 0xe9adb5, 0xe9adb7, 0xe9adb8, 0xe9adb9, 
0xe9adbf, 0xe9ae80, 0xe9ae84, 0xe9ae85, 0xe9ae86, 0xe9ae87, 0xe9ae89, 0xe9ae8a, 
0xe9ae8b, 0xe9ae8d, 0xe9ae8f, 0xe9ae90, 0xe9ae94, 0xe9ae9a, 0xe9ae9d, 0xe9ae9e, 
0xe9aea6, 0xe9aea7, 0xe9aea9, 0xe9aeac, 0xe9aeb0, 0xe9aeb1, 0xe9aeb2, 0xe9aeb7, 
0xe9aeb8, 0xe9aebb, 0xe9aebc, 0xe9aebe, 0xe9aebf, 0xe9af81, 0xe9af87, 0xe9af88, 
0xe9af8e, 0xe9af90, 0xe9af97, 0xe9af98, 0xe9af9d, 0xe9af9f, 0xe9afa5, 0xe9afa7, 
0xe9afaa, 0xe9afab, 0xe9afaf, 0xe9afb3, 0xe9afb7, 0xe9afb8, 
	/* 0x8feba1 */
0xe9afb9, 0xe9afba, 0xe9afbd, 0xe9afbf, 0xe9b080, 0xe9b082, 0xe9b08b, 0xe9b08f, 
0xe9b091, 0xe9b096, 0xe9b098, 0xe9b099, 0xe9b09a, 0xe9b09c, 0xe9b09e, 0xe9b0a2, 
0xe9b0a3, 0xe9b0a6, 0xe9b0a7, 0xe9b0a8, 0xe9b0a9, 0xe9b0aa, 0xe9b0b1, 0xe9b0b5, 
0xe9b0b6, 0xe9b0b7, 0xe9b0bd, 0xe9b181, 0xe9b183, 0xe9b184, 0xe9b185, 0xe9b189, 
0xe9b18a, 0xe9b18e, 0xe9b18f, 0xe9b190, 0xe9b193, 0xe9b194, 0xe9b196, 0xe9b198, 
0xe9b19b, 0xe9b19d, 0xe9b19e, 0xe9b19f, 0xe9b1a3, 0xe9b1a9, 0xe9b1aa, 0xe9b19c, 
0xe9b1ab, 0xe9b1a8, 0xe9b1ae, 0xe9b1b0, 0xe9b1b2, 0xe9b1b5, 0xe9b1b7, 0xe9b1bb, 
0xe9b3a6, 0xe9b3b2, 0xe9b3b7, 0xe9b3b9, 0xe9b48b, 0xe9b482, 0xe9b491, 0xe9b497, 
0xe9b498, 0xe9b49c, 0xe9b49d, 0xe9b49e, 0xe9b4af, 0xe9b4b0, 0xe9b4b2, 0xe9b4b3, 
0xe9b4b4, 0xe9b4ba, 0xe9b4bc, 0xe9b585, 0xe9b4bd, 0xe9b582, 0xe9b583, 0xe9b587, 
0xe9b58a, 0xe9b593, 0xe9b594, 0xe9b59f, 0xe9b5a3, 0xe9b5a2, 0xe9b5a5, 0xe9b5a9, 
0xe9b5aa, 0xe9b5ab, 0xe9b5b0, 0xe9b5b6, 0xe9b5b7, 0xe9b5bb, 
	/* 0x8feca1 */
0xe9b5bc, 0xe9b5be, 0xe9b683, 0xe9b684, 0xe9b686, 0xe9b68a, 0xe9b68d, 0xe9b68e, 
0xe9b692, 0xe9b693, 0xe9b695, 0xe9b696, 0xe9b697, 0xe9b698, 0xe9b6a1, 0xe9b6aa, 
0xe9b6ac, 0xe9b6ae, 0xe9b6b1, 0xe9b6b5, 0xe9b6b9, 0xe9b6bc, 0xe9b6bf, 0xe9b783, 
0xe9b787, 0xe9b789, 0xe9b78a, 0xe9b794, 0xe9b795, 0xe9b796, 0xe9b797, 0xe9b79a, 
0xe9b79e, 0xe9b79f, 0xe9b7a0, 0xe9b7a5, 0xe9b7a7, 0xe9b7a9, 0xe9b7ab, 0xe9b7ae, 
0xe9b7b0, 0xe9b7b3, 0xe9b7b4, 0xe9b7be, 0xe9b88a, 0xe9b882, 0xe9b887, 0xe9b88e, 
0xe9b890, 0xe9b891, 0xe9b892, 0xe9b895, 0xe9b896, 0xe9b899, 0xe9b89c, 0xe9b89d, 
0xe9b9ba, 0xe9b9bb, 0xe9b9bc, 0xe9ba80, 0xe9ba82, 0xe9ba83, 0xe9ba84, 0xe9ba85, 
0xe9ba87, 0xe9ba8e, 0xe9ba8f, 0xe9ba96, 0xe9ba98, 0xe9ba9b, 0xe9ba9e, 0xe9baa4, 
0xe9baa8, 0xe9baac, 0xe9baae, 0xe9baaf, 0xe9bab0, 0xe9bab3, 0xe9bab4, 0xe9bab5, 
0xe9bb86, 0xe9bb88, 0xe9bb8b, 0xe9bb95, 0xe9bb9f, 0xe9bba4, 0xe9bba7, 0xe9bbac, 
0xe9bbad, 0xe9bbae, 0xe9bbb0, 0xe9bbb1, 0xe9bbb2, 0xe9bbb5, 
	/* 0x8feda1 */
0xe9bbb8, 0xe9bbbf, 0xe9bc82, 0xe9bc83, 0xe9bc89, 0xe9bc8f, 0xe9bc90, 0xe9bc91, 
0xe9bc92, 0xe9bc94, 0xe9bc96, 0xe9bc97, 0xe9bc99, 0xe9bc9a, 0xe9bc9b, 0xe9bc9f, 
0xe9bca2, 0xe9bca6, 0xe9bcaa, 0xe9bcab, 0xe9bcaf, 0xe9bcb1, 0xe9bcb2, 0xe9bcb4, 
0xe9bcb7, 0xe9bcb9, 0xe9bcba, 0xe9bcbc, 0xe9bcbd, 0xe9bcbf, 0xe9bd81, 0xe9bd83, 
0xe9bd84, 0xe9bd85, 0xe9bd86, 0xe9bd87, 0xe9bd93, 0xe9bd95, 0xe9bd96, 0xe9bd97, 
0xe9bd98, 0xe9bd9a, 0xe9bd9d, 0xe9bd9e, 0xe9bda8, 0xe9bda9, 0xe9bdad, 0xe9bdae, 
0xe9bdaf, 0xe9bdb0, 0xe9bdb1, 0xe9bdb3, 0xe9bdb5, 0xe9bdba, 0xe9bdbd, 0xe9be8f, 
0xe9be90, 0xe9be91, 0xe9be92, 0xe9be94, 0xe9be96, 0xe9be97, 0xe9be9e, 0xe9bea1, 
0xe9bea2, 0xe9bea3, 0xe9bea5, 
};

static const unsigned long utf8_eucjpx[] = {
	0xefbd9e, 0xa1c1,
	0xefbc8d, 0xa1dd,
	0x00c2b7, 0x8021b7,
	0xe280a2, 0x8021b7,
};

unsigned long
utf8_decode(unsigned long utf8)
{
	int i;

	if (utf8 >= 0xefbda1 && utf8 <= 0xefbdbf)
		return 0x8e00 | (utf8 & 0xff);
	if (utf8 >= 0xefbe80 && utf8 <= 0xefbe9f)
		return 0x8e40 | (utf8 & 0xff);

	for (i = 0; i < sizeof(eucjp_utf8) / sizeof(eucjp_utf8[0]); i++) {
		if (eucjp_utf8[i] == utf8)
			return 0xa1a1 + (i / 94) * 256 + i % 94;
	}
	for (i = 0; i < sizeof(eucjp3_utf8) / sizeof(eucjp3_utf8[0]); i++) {
		if (eucjp3_utf8[i] == utf8)
			return 0x8fa2a1 + (i / 94) * 256 + i % 94;
	}

	/* special ... one way mapping */
	for (i = 0; i < sizeof(utf8_eucjpx) / sizeof(utf8_eucjpx[0]); i += 2) {
		if (utf8_eucjpx[i] == utf8)
			return utf8_eucjpx[i + 1];
	}

	return 0;
}

unsigned long
utf8_encode(unsigned long code)
{
	int b1, b2, b3;

	if (code >= 0x8e00 && code <= 0x8ebf)
		return 0xefbd00 | (code & 0xff);
	if (code >= 0x8ec0 && code <= 0x8edf)
		return 0xefbe80 | (code & 0x3f);
	b1 = code >> 16;
	b2 = (code >> 8) & 0xff;
	b3 = code & 0xff;
	if (b2 < 0xa1 || b2 > 0xfe || b3 < 0xa1 || b3 > 0xfe)
		return 0;
	code = (b2 - 0xa1) * 94 + (b3 - 0xa1);
	if (b1 == 0) {
		if (code < sizeof(eucjp_utf8) / sizeof(eucjp_utf8[0]))
			return eucjp_utf8[code];
	} else if (b1 == 0x8f) {
		if (code < sizeof(eucjp3_utf8) / sizeof(eucjp3_utf8[0]))
			return eucjp3_utf8[code];
	}
	return 0;
}
