/*
  decode_sniffer.c

  Network Associates Sniffer.
  
  Copyright (c) 2000 Anonymous <nobody@localhost>
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
 
  $Id: decode_sniffer.c,v 1.1 2000/05/16 17:31:14 dugsong Exp $
*/

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "base64.h"
#include "decode.h"

int 
decode_sniffer(u_char *buf, int len)
{
	u_int i, opcode;
	
	if (len < 36 || buf[0] != 5)
		return (0);
	
	opcode = pletohs(&buf[6]);
	
	if (opcode == 260) {
		if (buf[32] == 0)
			return (strlcpy(Buf, "[]\n", sizeof(Buf)));
	}
	else if (opcode == 261) {
		if (pletohl(&buf[32]) == -1)
			return (strlcpy(Buf, "[]\n", sizeof(Buf)));
	}
	else return (0);
	
	buf[len - 3]= '\0'; strtok(&buf[32], "\r\n");
	snprintf(Buf, sizeof(Buf), "%s [", &buf[32]);
	len = strlen(Buf);
	i = base64_pton(&buf[32], &Buf[len], sizeof(Buf) - len - 3);
	Buf[len + i] = '\0';
	strlcat(Buf, "]\n", sizeof(Buf));
	
	return (strlen(Buf));
}

