/*
  decode_postgresql.c

  PostgreSQL.

  Thanks to Eric Jackson <shinobi@monkey.org> for packet traces.
  
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>

  $Id: decode_postgresql.c,v 1.1 2000/05/17 00:34:49 dugsong Exp $
*/

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "decode.h"

#define STARTUP_PKTLEN	296

int
decode_postgresql(u_char *buf, int len)
{
	u_long plen;
	u_char *p;
	char *db, *user;
	
	if (len < STARTUP_PKTLEN)
		return (0);
	
	Buf[0] = '\0';
	db = user = NULL;
	
	for (;;) {
		if (len < 4) break;
		plen = ntohl(*(u_long *) buf);
		
		if (plen > len)	break;
		p = buf + 4;
		
		if (plen == STARTUP_PKTLEN) {
			if (ntohl(*(u_long *)p) >> 16 == 2) {
				db = p + 4; db[63] = '\0';
				user = db + 64; user[31] = '\0';
			}
		}
		else if (db != NULL && user != NULL) {
			buf[plen - 1] = '\0';
			snprintf(Buf + strlen(Buf),
				 sizeof(Buf) - strlen(Buf),
				 "%s\n%s\n%s\n", db, user, p);
			db = user = NULL;
		}
		buf += plen;
		len -= plen;
	}
	return (strlen(Buf));
}

