/*
  decode_portmap.c

  RPC portmap.
  
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
 
  $Id: decode_portmap.c,v 1.2 2000/05/16 21:27:53 dugsong Exp $
*/

#include <sys/types.h>
#include <rpc/rpc.h>
#include <rpc/pmap_prot.h>
#include <stdio.h>
#include <stdlib.h>
#include <libnet.h>
#include <nids.h>
#include "rpc.h"
#include "trigger.h"
#include "decode.h"

int
decode_portmap(u_char *buf, int len)
{
	struct rpc_msg msg;
	struct pmap *pm, pmap;
	struct xid_map *xm;
	XDR xdrs;
	int hdrlen;

	memset(&msg, 0, sizeof(msg));
	
	if ((hdrlen = rpc_decode(buf, len, &msg)) == 0)
		return (0);
	
	if (msg.rm_direction == CALL &&
	    msg.rm_call.cb_prog == PMAPPROG &&
	    msg.rm_call.cb_proc == PMAPPROC_GETPORT) {
		xdrmem_create(&xdrs, buf + hdrlen, len - hdrlen, XDR_DECODE);
		if (!xdr_pmap(&xdrs, &pmap)) {
			xdr_destroy(&xdrs);
			return (0);
		}
		xdr_destroy(&xdrs);

		if ((pm = (struct pmap *) malloc(sizeof(*pm))) == NULL)
			return (0);
		*pm = pmap;
		
		xid_map_enter(msg.rm_xid, PMAPPROG, (void *) pm);
	}
	else if (msg.rm_direction == REPLY &&
		 (xm = xid_map_find(msg.rm_xid)) != NULL) {
		if (msg.rm_reply.rp_stat == MSG_ACCEPTED &&
		    msg.acpted_rply.ar_stat == SUCCESS &&
		    len - hdrlen == 4) {
			pm = (struct pmap *) xm->data;
			pm->pm_port = ntohl(*(u_long *)(buf + hdrlen));

			if (pm->pm_port) {
				/* XXX - any client-only RPC decodes? */
				trigger_rpc(pm->pm_prog, pm->pm_prot,
					    pm->pm_port);
				trigger_rpc(pm->pm_prog, pm->pm_prot,
					    0 - (int) pm->pm_port);
			}
		}
		free(xm->data);
		memset(xm, 0, sizeof(*xm));
	}
	return (0);
}
