/*
  decode_ospf.c

  Open Shortest Path First.
  
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
 
  $Id: decode_ospf.c,v 1.2 2000/05/18 23:52:35 dugsong Exp $
*/

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "decode.h"

int
decode_ospf(u_char *buf, int len)
{
	if (len < 25)
		return (0);
	
	if (ntohs(*(u_short *)&buf[14]) != 1)
		return (0);
	
	buf[24] = '\0';
	
	return (snprintf(Buf, sizeof(Buf), "%s\n", buf + 16));
}

