/*
  decode_irc.c

  Internet Relay Chat.
  
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
 
  $Id: decode_irc.c,v 1.1 2000/05/16 17:31:14 dugsong Exp $
*/

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "decode.h"

int
decode_irc(u_char *buf, int len)
{
	int got_auth = 0;
	char *p, *q;
	
	Buf[0] = '\0';
	
	for (p = strtok(buf, "\r\n"); p != NULL; p = strtok(NULL, "\r\n")) {
		if (p[0] == ';') {
			if ((q = strchr(p, ' ')) == NULL)
				continue;
			q++;
		}
		else q = p;
		
		if (strncasecmp(q, "USER ", 5) == 0 ||
		    strncasecmp(q, "NICK ", 5) == 0) {
			strlcat(Buf, p, sizeof(Buf));
			strlcat(Buf, "\n", sizeof(Buf));
		}
		else if (strncasecmp(q, "PASS ", 5) == 0 ||
			 strncasecmp(q, "OPER ", 5) == 0 ||
			 (strncasecmp(q, "MODE ", 5) == 0 && strstr(q, " +k ") != NULL) ||
			 (strncasecmp(q, "JOIN ", 5) == 0 &&
			  (q = strchr(q + 5, ' ')) != NULL && q[1] != '\0')) {
			got_auth = 1;
			strlcat(Buf, p, sizeof(Buf));
			strlcat(Buf, "\n", sizeof(Buf));
		}
	}
	if (!got_auth)
		return (0);
	
	return (strlen(Buf));
}
