/*
  decode_http.c

  Hypertext Transfer Protocol.
  
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
 
  $Id: decode_http.c,v 1.2 2000/05/16 18:48:01 dugsong Exp $
*/

#include "config.h"
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#ifdef HAVE_LIBGEN_H
#include <libgen.h>
#endif
#include "base64.h"
#include "decode.h"

char *
http_req_dirname(char *req)
{
	char *uri, *vers;
	
	if ((uri = strchr(req, ' ')) == NULL)
		return (req);
	
	if ((vers = strrchr(uri, ' ')) == uri)
		vers = NULL;
	else if (vers[-1] == '/')
		return (req);
	else
		*vers++ = '\0';
	
	strcpy(req, dirname(req));
	strcat(req, "/");
	
	if (vers) {
		strcat(req, " ");
		strcat(req, vers);
	}
	return (req);
}  

int
decode_http(u_char *buf, int len)
{
	char *p, *s, *e;
	int i;
	
	Buf[0] = '\0';
	
	/* Process requests. */
	for (s = buf; (e = bufbuf(s, len, "\r\n\r\n", 4)) != NULL; s = e + 4) {
		len -= (e + 4) - s;
		*e = '\0';
		
		/* Check for auth info. */
		if (strstr(s, "uthorization: ") == NULL)
			continue;
		
		/* Process header. */
		for (p = strtok(s, "\r\n"); p != NULL; p = strtok(NULL, "\r\n")) {
			if (!strlen(p)) continue;
			
			if (strncasecmp(p, "GET ", 4) == 0 ||
			    strncasecmp(p, "POST ", 5) == 0) {
				p = http_req_dirname(p);
				strlcat(Buf, p, sizeof(Buf));
				strlcat(Buf, "\n", sizeof(Buf));
			}
			else if (strncasecmp(p, "Host: ", 6) == 0) {
				strlcat(Buf, p, sizeof(Buf));
				strlcat(Buf, "\n", sizeof(Buf));
			}
			else if (strncasecmp(p, "Authorization: Basic ", 21) == 0 ) {
				strlcat(Buf, p, sizeof(Buf));
				p += 21;
				i = base64_pton(p, p, strlen(p));
				p[i] = '\0';
				strlcat(Buf, " [", sizeof(Buf));
				strlcat(Buf, p, sizeof(Buf));
				strlcat(Buf, "]\n\n", sizeof(Buf));
			}
		}
	}
	return (strlen(Buf));
}
