/*
  decode.h

  Protocol decoding routines.
  
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>

  $Id: decode.h,v 1.1 2000/05/16 17:31:14 dugsong Exp $
*/

#ifndef DECODE_H
#define DECODE_H

typedef int (*decode_func)(u_char *, int);

struct decode {
	char	       *dc_name;
	decode_func	dc_func;
};

struct decode *getdecodebyname(const char *name);


#define pletohs(p)	((u_short)                      \
			 ((u_short)*((u_char *)p+1)<<8| \
			  (u_short)*((u_char *)p+0)<<0))
     
#define pletohl(p)	((u_long)*((u_char *)p+3)<<24|  \
			 (u_long)*((u_char *)p+2)<<16|  \
			 (u_long)*((u_char *)p+1)<<8|   \
			 (u_long)*((u_char *)p+0)<<0)

u_char *bufbuf(u_char *big, int blen, u_char *little, int llen);

int	strip_telopts(u_char *buf, int len);

int	strip_lines(char *buf, int max_lines);

int	is_ascii_string(char *buf, int len);

extern u_char Buf[4096];

#endif /* DECODE_H */
